#!/usr/bin/env python
# Statistics.py
# 
# Maintained by G.Winter
# 2nd December 2004
# 
# A couple of useful statistical jiffies for working out expert system
# questions.
# 
# 
# 
# 
# 
# $Id: Statistics.py,v 1.3 2005/11/22 13:38:14 svensson Exp $

import math

def mean_chi_sq(o_list, e, sigma_sq):
    '''Calculate a chi-squared value for o_list assuming that sigma_sq is a
    reasonable variation estimate and that e is the expected value for all
    points.'''

    chi_sq = 0.0

    for o in o_list:
        chi_sq += (o - e) * (o - e) / sigma_sq

    return chi_sq

def mean_chi_sq_list(o_list, e, sigma_sq):
    '''Calculate a chi-squared value for o_list assuming that sigma_sq is a
    reasonable variation estimate and that e is the expected value for all
    points.'''

    chi_sq = 0.0
    i = 0
    chi_sq_list = []

    for o in o_list:
        i += 1
        chi_sq += (o - e) * (o - e) / sigma_sq
        chi_sq_list.append(chi_sq / i)

    return chi_sq_list

def mean_and_standard_deviation(list):
    '''Calculate the mean and standard deviation of a list of numbers'''

    sum = 0
    for l in list:
        sum += l
    sum /= len(list)

    sumsq = 0
    for l in list:
        diff = l - sum
        sumsq += diff * diff

    sumsq /= len(list)

    mean = sum
    sd = math.sqrt(sumsq)

    return mean, sd
        

def mean_significantly_over_limit(list, limit):
    '''See if the list of values is significantly (3 sigma) over the limit'''

    mean, sd = mean_and_standard_deviation(list)

    sd_mean = sd / math.sqrt(float(len(list)))

    standard_deviations = (mean - limit) / sd_mean

    if standard_deviations > 3.0:
        return True

    return False

