#!/usr/bin/env python
# MessageHandler.py
# Maintained by G.Winter
# A staging point for messages coming from the Scheduler and going to the 
# expert system.
# 21st January 2004
# 
# A part of the second generation scheduler. This is all based around the 
# thread safe Queue class in Python - which requires threads to have been 
# compiled in. Note that the flushing could be messy... depends on how thread
# safe the Python *language* is. :o)
# $Id: MessageHandler.py,v 1.1 2004/01/21 10:39:53 gwin Exp $

import Queue

# a few global message queues

_log = Queue.Queue()
_debug = Queue.Queue()
_error = Queue.Queue()

# these all have basically the same structures - a method to record a message,
# a method to get a list of all recorded messages since the last get, and a
# method to flush the message buffer.

def log(message):
    '''Record a message in the log'''
    _log.put(message)

def get_log():
    '''Get a list of all of the things in the log'''
    messages = []
    while _log.empty() == 0:
        try:
            message = _log.get(0)
            messages.append(message)
        except:
            pass

    return messages

def flush_log():
    '''Empty the log'''
    _log = Queue.Queue()

def debug(message):
    '''Record a message in the debug log'''
    _debug.put(message)

def get_debug():
    '''Get a list of all of the recent debugging messages'''
    messages = []
    while _debug.empty() == 0:
        try:
            message = _debug.get(0)
            messages.append(message)
        except:
            pass

    return messages

def flush_debug():
    '''Empty the debug log'''
    _debug = Queue.Queue()

def error(message):
    '''Record a message in the error log'''
    _error.put(message)

def get_error():
    '''Get a list of all of the recent errorging messages'''
    messages = []
    while _error.empty() == 0:
        try:
            message = _error.get(0)
            messages.append(message)
        except:
            pass

    return messages

def flush_error():
    '''Empty the error log'''
    _error = Queue.Queue()

if __name__ == '__main__':
    for i in range(1, 10):
        log('message ' + str(i))

    l = get_log()

    for m in l:
        print m

