#!/usr/bin/env python
# Checks.py
# Maintained by G.Winter
# A few little bits of expertise, which may be applied in a modular fashion
# 20th January 2004
# 
# This will include things like comparison of P1 cells from different 
# indexing's and so on.
# 
# 
# $Id: Checks.py,v 1.8 2004/06/21 11:03:44 gwin Exp $

# system imports
import os, sys

# DNA related imports
if not os.environ.has_key('DNAHOME'):
    raise RuntimeError, 'DNAHOME not defined'

dna = os.environ['DNAHOME']

sys.path.append(dna + '/xsd/python')

import XSD

# add the Messenger system into here...

sys.path.append(dna + '/scheduler/Scheduler/Mosflm')
from Messenger import *

from ExpertException import ExpertException

# string handling bits and pieces - for convenience, along with some maths
import string, math

def capitalise(word):
    return string.upper(word[0]) + word[1:]

# compare two unit cells, returning 1 if they differ and 0 if the are about
# the same (within 1 angstrom or 1 degree on each property)

def CompareCells(one, two):
    '''Compare two triclinic unit cells, in terms of lengths of the sides
    and the angles'''

    # check the types of the input objects

    if one.name != 'cell':
        raise ExpertException, 'argument is not a cell'
    if two.name != 'cell':
        raise ExpertException, 'argument is not a cell'

    for property in ['a', 'b', 'c', 'alpha', 'beta', 'gamma']:
        Property = capitalise(property)
        method = getattr(one, 'get' + Property)
        value = float(method())
        method = getattr(two, 'get' + Property)
        if math.fabs(value - method()) > 2.0:
            # they differ by more than 2 angstroms or 2 degrees
            return 1

    return 0

def MosaicSpread(mosaic):
    '''Compare the mosaic spreads for a number of images and check for
    consistancy between them'''

    images = mosaic.keys()
    images.sort()

    total = 0.0

    for image in images:
        total += mosaic[image]

    average = total / len(images)

    for image in images:
        if math.fabs(mosaic[image] - average) > (0.25 * average):
            return 1

    return 0

def dot_theta(a, b):
    '''compute thete between a and b and return a normalized angle'''
    mod_a = math.sqrt((a[0] * a[0]) +
                      (a[1] * a[1]) +
                      (a[2] * a[2]))
    mod_b = math.sqrt((b[0] * b[0]) +
                      (b[1] * b[1]) +
                      (b[2] * b[2]))
    
    dot = (a[0] * b[0]) + (a[1] * b[1]) + (a[2] * b[2])
    theta = math.acos(math.fabs(dot / (mod_a * mod_b)))

    return theta


def DotAMatrix(matrix_1, matrix_2):
    '''Compute the dot products between the two matrices, and return a
    feeling for whether they are the same or orthogonal'''

    a1 = []
    a2 = []
    b1 = []
    b2 = []
    c1 = []
    c2 = []

    a1.append(float(matrix_1.getE11()))
    a1.append(float(matrix_1.getE21()))
    a1.append(float(matrix_1.getE31()))
    b1.append(float(matrix_1.getE12()))
    b1.append(float(matrix_1.getE22()))
    b1.append(float(matrix_1.getE32()))
    c1.append(float(matrix_1.getE13()))
    c1.append(float(matrix_1.getE23()))
    c1.append(float(matrix_1.getE33()))
    
    a2.append(float(matrix_2.getE11()))
    a2.append(float(matrix_2.getE21()))
    a2.append(float(matrix_2.getE31()))
    b2.append(float(matrix_2.getE12()))
    b2.append(float(matrix_2.getE22()))
    b2.append(float(matrix_2.getE32()))
    c2.append(float(matrix_2.getE13()))
    c2.append(float(matrix_2.getE23()))
    c2.append(float(matrix_2.getE33()))
    
    theta_a = dot_theta(a1, a2)
    theta_b = dot_theta(b1, b2)
    theta_c = dot_theta(c1, c2)

    rtod = 180.0 / (4.0 * math.atan(1.0))

    if (rtod * theta_a) > 2.0 or \
       (rtod * theta_b) > 2.0 or \
       (rtod * theta_c) > 2.0:
        return 1

    return 0
    

def NameThatProtein(cell):
    if cell.name != 'cell':
        raise ExpertException, 'argument is not a cell'

    a = float(cell.getA())
    b = float(cell.getB())
    c = float(cell.getC())
    alpha = float(cell.getAlpha())
    beta = float(cell.getBeta())
    gamma = float(cell.getGamma())

    if 1 == 1:
        return

    # check for trypsin
    
    if math.fabs(a - 53.2) < 3.0 and \
           math.fabs(b - 56.8) < 3.0 and \
           math.fabs(c - 65.3) < 3.0 and \
           math.fabs(alpha - 90.0) < 1.0 and \
           math.fabs(beta - 90.0) < 1.0 and \
           math.fabs(gamma - 90.0) < 1.0:
        Messenger.log_write('This looks like trypsin!')

    # next lysozyme
    if math.fabs(a - 78.7) < 3.0 and \
           math.fabs(b - 78.7) < 3.0 and \
           math.fabs(c - 36.9) < 3.0 and \
           math.fabs(alpha - 90.0) < 1.0 and \
           math.fabs(beta - 90.0) < 1.0 and \
           math.fabs(gamma - 90.0) < 1.0:
        Messenger.log_write('This looks like lysozyme!')

    
