import sys
sys.path.append("../../xsd/python")
sys.path.append("../src")
import XSD
from ESConfig import *
from XML_utils import *

collect_data_request = XSD.Collect_data_request()
collect_request = XSD.Collect_request()
fileinfo = XSD.Fileinfo()
fileinfo.setDirectory("/scisoft/pxsoft/data/dna_061202")
fileinfo.setPrefix("mystery")
fileinfo.setRun_number(2)
collect_request.setFileinfo(fileinfo)
oscillation_sequence = XSD.Oscillation_sequence()
oscillation_sequence.setStart(5.0)
oscillation_sequence.setRange(0.5)
oscillation_sequence.setNumber_of_images(50)
oscillation_sequence.setExposure_time(1.0)
oscillation_sequence.setStart_image_number(1)
collect_request.addOscillation_sequence(oscillation_sequence)
collect_data_request.setCollect_request(collect_request)
collect_data_request.setIntegrate("true")

xml_message = collect_request.marshal()

server_data = ESConfig.getDna_configuration().getServer_data()
ES_host = server_data.getExpert_system_host_name()
ES_port = server_data.getExpert_system_port_number()

print XML_utils.http_post(ES_host, ES_port, "/collect_data_request", collect_data_request.marshal())
