import sys, pprint, os

if "DNAHOME" in os.environ.keys():
    tmp_path = os.path.join(os.environ["DNAHOME"], "xsd")
    sys.path.append(os.path.join(tmp_path, "python"))
    tmp_path = os.path.join(os.environ["DNAHOME"], "es")
    sys.path.append(os.path.join(tmp_path, "src"))
else:
    print "ERROR in DNA_message_tools - DNAHOME not defined"
    exit

import XSD
from ESConfig import *
from XML_utils import *

def send_dna_message(type, message_text, level):
    dna_message = XSD.Dna_message()
    dna_message.setType(type)
    dna_message.setMessage(message_text)
    if not level is None:
        dna_message.setLevel(level)
    server_data = ESConfig.getDna_configuration().getServer_data()
    ES_host = server_data.getExpert_system_host_name()
    ES_port = server_data.getExpert_system_port_number()
    tmp = XML_utils.http_post(ES_host, ES_port, \
                              "/dna_message", dna_message.marshal())

def log_write(message_text, level=None):
    type = "log"
    send_dna_message(type, message_text, level)

def debug_write(message_text, level=None):
    type = "debug"
    send_dna_message(type, message_text, level)


def error_write(message_text, level=None):
    type = "error"
    send_dna_message(type, message_text, level)


