#################################################################
#
# GUI_proxy.py
#
# Authors: The DNA team, http://www.dna.ac.uk
#
# Version: $Id: GUI_proxy.py,v 1.5 2003/09/10 16:23:20 svensson Exp $
#
# Revision history:
#
# 110203: O. Svensson (svensson@esrf.fr)
#         Added header
#
#################################################################

import dna_httplib, os, string, time

from XML_utils import *
from Debug import *
from ESConfig import *

FALSE = 0
TRUE  = 1

DEBUG = TRUE

class GUI_proxy:

  def __init__(self, server_name, port):
    self.gui_server_name = server_name
    self.gui_port = port
    #
    # Name of the ES server
    #
    self.dna_configuration  = ESConfig.getDna_configuration()
    self.server_data        = self.dna_configuration.getServer_data()
    self.ES_host = self.server_data.getExpert_system_host_name()

  def send_message(self, path, message):
    xml_message = message.marshal()
    reply = self.http_post(path, xml_message)
    return reply

  def send_xml_message(self, path, dict_message):
    xml_message = XML_utils.DictToXML(dict_message)
    reply = self.http_post(path, xml_message)
    return reply

  def send_collect_response(self, collect_dict):
    collect_response_xml = XML_utils.DictToXML(collect_dict)
    reply = self.http_post("/collect_response", collect_response_xml)
    return XML_utils.XMLStringToDict(reply)

  def http_post(self, path, message):
    try:
      Debug.out("GUI_proxy.http_post path = "+path,4)
      Debug.out("GUI_proxy.http_post message length = %d"%(len(message)),4)
      Debug.out("GUI_proxy.http_post message = "+message,4)
      h = dna_httplib.HTTP("%s:%d"%(self.gui_server_name, self.gui_port))
      h.putrequest("POST", path)
      h.putheader("Content-Type", "text/xml")
      h.putheader("Content-Length", "%d" % len(message))
      h.putheader('Accept', 'text/plain')
      h.putheader('Host', self.ES_host)
      h.endheaders()
      h.send(message)
      reply, msg, hdrs = h.getreply()
      word = hdrs.getrawheader("Content-Length")
      length = string.atoi(word)
      data = h.getfile().read(length)
      return data
    except:
      return None


