#################################################################
#
# ExecutiveHTTPServer.py
#
# Authors: The DNA team, http://www.dna.ac.uk
#
# Version: $Id: ExecutiveHTTPServer.py,v 1.15 2006/01/05 15:25:17 svensson Exp $
#
#################################################################

import BaseHTTPServer
import threading, string, os, sys
import dna_httplib
import XSD
from ESConfig import *
from ESContext import *

class ExecutiveSystemRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):

  #
  # Reference to the ES
  #
  _executive    = None
  _dna_logger   = None
  _es_db_proxy  = None
  #
  # Reference to an object containing info about the ES status
  #
  _dna_status = None


  def do_POST(self):
    #
    # Reset status for the HTTP server to ok.
    #
    ExecutiveSystemRequestHandler._dna_status.getHttp_server_status().setCode("ok")
    ExecutiveSystemRequestHandler._dna_status.getHttp_server_status().setMessage("")
    #
    # Get incoming XML document
    #
    try:
      if self._executive is None:
        raise "InternalServerError"
      content_length_string = self.headers.getheader("Content-Length")
      if content_length_string is None:
        raise "BadRequestError"
      xml_message_length = string.atoi(content_length_string)
      xml_message = self.rfile.read(xml_message_length)
      xml_response = None
      server_data        = ESConfig.getServer_data()
      ES_host            = server_data.getExpert_system_host_name()
      #
      # The following code redirects different requests to different
      # modules, i.e. DNA_Logger and ExecutiveDBProxy.
      #
      # This is now getting more and more complicated so it should
      # be rewritten. 
      #
      if self.path == "/dna_message":
        #
        # Forward the message to the DNA_Logger
        #
        dna_message = XSD.Dna_message()
        dna_message.unmarshal(xml_message)
        self._dna_logger.forward_dna_message(dna_message)
        #
        #
        #
      elif self.path == "/dna_configuration_request":
        #
        # Forward any new dna_configuration object to ESConfig:
        #
        dna_configuration_request = XSD.Dna_configuration_request()
        dna_configuration_request.unmarshal(xml_message)
        system_defaults = dna_configuration_request.getSystem_defaults()
        #
        # Check if system defaults are provided...
        #
        if not system_defaults is None:
          ESConfig.setSystem_defaults(system_defaults)
          dna_message = XSD.Dna_message()
          dna_message.setType("es-httpserver-log")
          dna_message.setMessage("New system defaults configuration for DNA accepted")
          self._es_gui_proxy.forward_dna_message(dna_message)
        else:
          system_defaults = ESConfig.getSystem_defaults()
        #
        # and the same thing for user defaults:
        #
        user_defaults = dna_configuration_request.getUser_defaults()
        if not user_defaults is None:
          ESConfig.setUser_defaults(user_defaults)
          dna_message = XSD.Dna_message()
          dna_message.setType("es-httpserver-log")
          dna_message.setMessage("New user defaults configuration for DNA accepted")
          self._es_gui_proxy.forward_dna_message(dna_message)
        else:
          user_defaults = ESConfig.getUser_defaults()
        #
        # Provide a reply.
        #
        dna_configuration_response = XSD.Dna_configuration_response()
        status = XSD.Status()
        status.setCode("ok")
        dna_configuration_response.setStatus(status)
        dna_configuration_response.setSystem_defaults(system_defaults)
        dna_configuration_response.setUser_defaults(user_defaults)
        xml_response = dna_configuration_response.marshal()
        #
        #
        #
      elif self.path == "/dna_context_request":
        #
        # Just return the current context
        #
        dna_context = ESContext.get_dna_context()
        dna_context_response = XSD.Dna_context_response()
        status = XSD.Status()
        status.setCode("ok")
        dna_context_response.setStatus(status)
        dna_context_response.setDna_context(dna_context)
        xml_response = dna_context_response.marshal()
        #
        # This seems to be working now so I remove
        # the log message below.
        #
        #try:
        #  dna_message = XSD.Dna_message()
        #  dna_message.setType("es-httpserver-log")
        #  dna_message.setMessage("DNA context request")
        #  self._dna_logger.forward_dna_message(dna_message)
        #except:
        #  # We don't care if this works...
        #  pass
        #
        #
        #
      elif self.path == "/set_rank_engine_request":
        #
        #
        #
        Debug.out("In ExecutiveHTTPServer set_rank_engine_request",1)
        Debug.out("XML message: %s" % xml_message, 2)
        set_rank_engine_request = XSD.Set_rank_engine_request()
        set_rank_engine_request.unmarshal(xml_message)
        rankEngine = set_rank_engine_request.getRankEngine()
        ESConfig.getUser_defaults().getRank_parameters().setRankEngine( rankEngine )
        #
        #
        #
      elif self.path == "/dna_es_state_request":
        #
        #
        #
        es_state = XSD.Status()
        es_state.setCode("ok")
        es_state.setMessage(self._executive.get_status())
        xml_response = es_state.marshal()
        #
        #
        #
      elif self.path != "/dna_status_request":
        #
        # Forward the command to the ES
        #
        Debug.out("Forwarding the command %s to the Executive System" % self.path,1)
        self._executive.send_message(self.path, xml_message)
        #
        #
        #
      #
      #
      #
      if xml_response is None:
        #
        # Send back the dna_status in case xml_response is not defined
        #
        xml_response       = ExecutiveSystemRequestHandler._dna_status.marshal()
        #
        #
      #
      # Everything OK so far.
      #
      self.wfile.write("HTTP/1.1 200 OK\n")
      #
      #
      #

    except "IternalServerError":
      ExecutiveSystemRequestHandler._dna_status.getHttp_server_status().setCode("ERROR")
      ExecutiveSystemRequestHandler._dna_status.getHttp_server_status().setMessage("Internal Server Error")
      self.wfile.write("HTTP/1.1 500 Internal Server Error\n")

    except "BadRequestError":
      ExecutiveSystemRequestHandler._dna_status.getHttp_server_status().setCode("ERROR")
      ExecutiveSystemRequestHandler._dna_status.getHttp_server_status().setMessage("Bad Request")
      self.wfile.write("HTTP/1.1 400 Bad Request\n")

    #
    # Only send back response if command is not "/shutdown"
    #
    if self.path != "/shutdown":
      #
      # Name of the ES server
      #
      self.wfile.write("Host: %s\n"%(ES_host))
      self.wfile.write("Content-Type: text/xml\n")
      self.wfile.write("Content-Length: %d\n\n"%(len(xml_response)))
      self.wfile.write(xml_response)


class HTTPServerThread(threading.Thread):

  def __init__(self, executive, dna_logger, es_db_proxy, hostname, port, GUI_host, GUI_port):
    threading.Thread.__init__(self)
    self.hostname = hostname
    self.port = port
    self.is_shutdown = 0
    #
    # Forward references to the ExecutiveSystemRequest Handler class.
    #
    ExecutiveSystemRequestHandler._executive    = executive
    ExecutiveSystemRequestHandler._dna_logger   = dna_logger
    ExecutiveSystemRequestHandler._es_db_proxy  = es_db_proxy
    #
    # Status messages not fully implemented yet.
    #
    dna_status = XSD.Dna_status()
    es_status = XSD.Status()
    es_status.setCode("ok")
    dna_status.setEs_status(es_status)
    dpm_status = XSD.Status()
    dpm_status.setCode("ok")
    dna_status.setDpm_status(dpm_status)
    bcm_status = XSD.Status()
    bcm_status.setCode("ok")
    dna_status.setBcm_status(bcm_status)
    http_server_status = XSD.Status()
    http_server_status.setCode("ok")
    dna_status.setHttp_server_status(http_server_status)
    ExecutiveSystemRequestHandler._dna_status = dna_status
    
    
  def run(self):  
    server_class=BaseHTTPServer.HTTPServer
    handler_class=ExecutiveSystemRequestHandler
    server_address = (self.hostname, self.port)
    try:
      self.httpd = server_class(server_address, handler_class)
    except:
      status = XSD.Status()
      status.setCode("error")
      status.setMessage("Error starting HTPP server - is an Executive System already running?")
      self.setHttp_server_status(status)
      self.is_shutdown = 1
    while not self.is_shutdown:
      self.httpd.handle_request()

  def setEs_status(self, new_es_status):
    ExecutiveSystemRequestHandler._dna_status.setEs_status(new_es_status)

  def setBcm_status(self, new_bcm_status):
    ExecutiveSystemRequestHandler._dna_status.setBcm_status(new_bcm_status)

  def setDpm_status(self, new_dpm_status):
    ExecutiveSystemRequestHandler._dna_status.setDpm_status(new_dpm_status)

  def getHttp_server_status(self):
    return ExecutiveSystemRequestHandler._dna_status.getHttp_server_status()

  def setHttp_server_status(self, new_http_server_status):
    ExecutiveSystemRequestHandler._dna_status.setHttp_server_status(new_http_server_status)

  def shutdown(self):
    self.is_shutdown = 1
    h = dna_httplib.HTTP("%s:%d"%(self.hostname, self.port))
    h.putrequest("POST", "/shutdown")
    h.endheaders()
    h.send("")



