#################################################################
#
# ESConfig.py
#
# Authors: The DNA team, http://www.dna.ac.uk  
#
# Version: $Id: ESConfig.py,v 1.13 2005/12/08 14:54:27 svensson Exp $
#
#################################################################

import os, os.path, sys, re
import XSD
from XML_utils import *
from Debug import *

class ESConfig:

  def __init__(self):
    #
    # Read the configuration file(s).
    #
    if not "DNAHOME" in os.environ.keys():
      raise "ERROR in ESConfig: DNAHOME not defined"
    if not "DNANAME" in os.environ.keys():
      raise "ERROR in ESConfig: DNANAME not defined"
    #
    #
    #
    if "DNA_SYSTEM_DEFAULTS" in os.environ.keys():
      self.system_defaults_file_name = os.environ["DNA_SYSTEM_DEFAULTS"]
    else:
      self.system_defaults_file_name = os.path.join(os.environ["DNAHOME"], \
                                                    "config",
                                                    os.environ["DNANAME"],
                                                    "system_defaults.xml")
    #
    if "DNA_USER_DEFAULTS" in os.environ.keys():
      self.user_defaults_file_name = os.environ["DNA_USER_DEFAULTS"]
    else:
      self.user_defaults_file_name = os.path.join(os.environ["HOME"], \
                                                  ".dna",
                                                  "user_defaults.xml")
    #
    if os.access(self.system_defaults_file_name, os.F_OK) and \
       os.access(self.user_defaults_file_name, os.F_OK):
      #
      self.read_config_files
      #
    else:
        #
        raise "Fatal error in ESConfig - cannot read configuration files"
        #
    #
    # Read the config files!
    #
    self.read_config_files()
                            

  def read_config_files(self):
    #
    # Read the configuartion files 
    #
    file = open(self.system_defaults_file_name)
    system_defaults_xml = file.read()
    Debug.out("In ESConfig, reading system defaults: %s" % system_defaults_xml, 2)
    self.system_defaults = XSD.System_defaults()
    self.system_defaults.unmarshal(system_defaults_xml)
    file.close()
    file = open(self.user_defaults_file_name)
    user_defaults_xml = file.read()
    Debug.out("In ESConfig, reading user defaults: %s" % user_defaults_xml, 2)
    self.user_defaults = XSD.User_defaults()
    self.user_defaults.unmarshal(user_defaults_xml)
    file.close()

  def save_config_files(self):
    #
    system_defaults_xml = XML_utils.xml_with_indentations(self.system_defaults.marshal())
    user_defaults_xml =    XML_utils.xml_with_indentations(self.user_defaults.marshal())
    #
    try:
      file = open(self.system_defaults_file_name, "w")
      file.write(system_defaults_xml)
      file.close()
    except:
      pass
    #
    if not os.access(os.path.join(os.environ["HOME"], ".dna"), os.F_OK):
      os.system("mkdir -p %s" % os.path.join(os.environ["HOME"], ".dna"))
    file = open(self.user_defaults_file_name, "w")
    file.write(user_defaults_xml)
    file.close()


  def __call__(self):
    return self    

  def getSystem_defaults(self):
    #self.read_config_files()
    return self.system_defaults
    
  def getUser_defaults(self):
    #self.read_config_files()
    return self.user_defaults

  def setSystem_defaults(self, the_system_defaults):
    self.system_defaults = the_system_defaults
    self.save_config_files()

  def setUser_defaults(self, the_user_defaults):
    self.user_defaults = the_user_defaults
    self.save_config_files()

  def getServer_data( self ):
    return self.user_defaults.getServer_data()

  def setServer_data( self, the_server_data ):
    self.user_defaults.setServer_data( the_server_data )

  def getDna_configuration(self):
    dna_configuration = XSD.Dna_configuration()
    dna_configuration.setServer_data(self.user_defaults.getServer_data())
    dna_configuration.setLocal_info(self.system_defaults.getLocal_info())
    dna_configuration.setDefault_values(self.user_defaults.getDefault_values())
    dna_configuration.setIndex_parameters(self.user_defaults.getIndex_parameters())

  def setDna_configuration(self, the_dna_configuration):
    server_data = the_dna_configuration.getServer_data()
    if not server_data is None:
      self.user_defaults.setServer_data(server_data)
    local_info = the_dna_configuration.getServer_data()
    if not local_info is None:
      self.system_defaults.setLocal_info(local_info)
    default_values = the_dna_configuration.getDefault_values()
    if not default_values is None:
      user_defaults.setDefault_values(default_values)
    index_parameters = dna_configuration.getIndex_parameters()
    if not index_parameters is None:  
      user_defaults.setIndex_parameters(index_parameters)



ESConfig = ESConfig()




