#################################################################
#
# DetectorDatabase.py
#
# Authors: The DNA team, http://www.dna.ac.uk  
#
# Version: $Id: DetectorDatabase.py,v 1.3 2005/11/22 13:38:14 svensson Exp $
#
# This class contains a database of detector types used
# in the DNA project. A new detector type only needs to be added
# to this file in order to be useful in the DNA project.
#
#################################################################

import XSD
from Debug import *

class DetectorDatabase:

    #
    # Add new detector types below:
    #
    detector_dict = {
        "adsc":    {"suffix":   "img"},
        "marccd":  {"suffix":  "mccd"},
        }

    def __call__(self):
        """Singleton!"""
        return self

    
    def check_if_known_detector_type(self, the_detector_type):
        """Returns True if the detector type is known, False otherwise."""
        #
        response = False
        if the_detector_type in self.detector_dict.keys():
            response = True
        return response


    def determine_suffix(self, the_detector):
        """Returns the file name suffix for a given detector."""
        #
        suffix = None
        type = the_detector.getType() 
        if type in self.detector_dict.keys():
            suffix = self.detector_dict[type]["suffix"]
        return suffix


    def determine_detector_from_suffix(self, the_suffix):
        """Returns a detector object given a suffix."""
        #
        Debug.out("Determining the detector type for suffix %s" % the_suffix, 2)
        the_detector = None
        for detector_type in self.detector_dict.keys():
            if self.detector_dict[detector_type]["suffix"] == the_suffix:
                the_detector = XSD.Detector()
                the_detector.setType(detector_type)
                Debug.out("The detector type for suffix %s was determined to be %s" % (the_suffix, detector_type), 2)
        return the_detector


#
# Not very elegant singleton definition but it works.
#
DetectorDatabase = DetectorDatabase()


if __name__ == '__main__':

    print
    print "Detector type = 'dummy',  check_if_known_detector_type = %s" % DetectorDatabase.check_if_known_detector_type("dummy")
    print "Detector type = 'adsc',   check_if_known_detector_type = %s" % DetectorDatabase.check_if_known_detector_type("adsc")
    print "Detector type = 'marccd', check_if_known_detector_type = %s" % DetectorDatabase.check_if_known_detector_type("marccd")

    print
    detector = XSD.Detector()
    detector.setType("dummy")
    print "Detector type = 'dummy',  determine_suffix = %s" % DetectorDatabase.determine_suffix(detector)
    detector.setType("adsc")
    print "Detector type = 'adsc',   determine_suffix = %s" % DetectorDatabase.determine_suffix(detector)
    detector.setType("marccd")
    print "Detector type = 'marccd', determine_suffix = %s" % DetectorDatabase.determine_suffix(detector)

    print
    suffix = "img"
    type = DetectorDatabase.determine_detector_from_suffix(suffix).getType()
    print "Suffix = %s,  DetectorDatabase.determine_detector_from_suffix.getType() = %s" % (suffix, type)
    suffix = "mccd"
    type = DetectorDatabase.determine_detector_from_suffix(suffix).getType()
    print "Suffix = %s,  DetectorDatabase.determine_detector_from_suffix.getType() = %s" % (suffix, type)
