#################################################################
#
# Debug.py
#
# Authors: The DNA team, http://www.dna.ac.uk
#
# Version: $Id: Debug.py,v 1.8 2006/01/18 14:16:18 svensson Exp $
#
# Revision history:
#
# 110203: O. Svensson (svensson@esrf.fr)
#         Added header
#
#################################################################

import sys, time, traceback
import XSD

class Debug:

  def __init__(self):
    self.guiproxy=None
    self.debug_level = 0
    if "-d1" in sys.argv:
      self.debug_level = 1
    elif "-d2" in sys.argv:
      self.debug_level = 2
    elif "-d3" in sys.argv:
      self.debug_level = 3
      
  def __call__(self):
    return self

  def setGuiproxy(self, the_guiproxy):
    self.guiproxy = the_guiproxy

  def out(self, message, level = 1 ):
    if level <= self.debug_level:
      logText = "DEBUG level %d: %s"%(level,message)
      print logText
      filename="ES-" + time.strftime("%a_%b_%d_%Y",time.localtime(time.time())) + ".log"
      logFile = open(filename, 'a+')
      logFile.write("%s: "%(time.ctime(time.time())))
      logFile.write(logText)
      logFile.write('\n')
      logFile.close()
      if not self.guiproxy is None:
        dna_message = XSD.Dna_message()
        dna_message.setType("es-debug")
        dna_message.setLevel(self.debug_level)
        dna_message.setMessage(message)
        self.guiproxy.forward_dna_message(dna_message)

  def getLevel(self):
    return self.debug_level

  def out_traceback( self, level = 1 ):
    """Prints the python traceback as log messages - very useful for debugging."""
    #
    #
    #
    if level <= self.debug_level:
      (exc_type, exc_value, exc_traceback) = sys.exc_info()
      self.out(traceback.format_exception_only(exc_type, exc_value)[0], level)
      list = traceback.extract_tb(exc_traceback)
      for line in list:
        self.out("File %s, method name %s, line no %d: %s"%(line[0],line[2],line[1],line[3]),level)
      exc_traceback = None

Debug = Debug()
