#################################################################
#
# DNA_Logger.py
#
# Authors: The DNA team, http://www.dna.ac.uk
#
# Version: $Id: DNA_Logger.py,v 1.10 2006/06/09 08:55:48 svensson Exp $
#
#################################################################

import dna_httplib, os, string, sys
import pprint, time, socket, re, traceback, math
import threading
import smtplib
import XSD, Queue

from ESConfig import *
from ESContext import *
from XML_utils import *
from Debug import *

#################################################################
#
# The "DNA_Logger" class
#


class DNA_Logger(threading.Thread):


  def __init__(self, the_es):
    threading.Thread.__init__(self)
    #
    #
    #
    self.es = the_es
    self.server_data        = ESConfig.getServer_data()
    self.GUI_host = self.server_data.getGui_host_name()
    self.GUI_port = self.server_data.getGui_port_number()
    self.message_queue = Queue.Queue()
    self.condition = threading.Condition()
    self.last_log_lines = []
    self.no_last_log_lines = 200
    if not "DNANAME" in os.environ.keys():
        raise ExecutiveException, "DNA_Logger: DNANAME undefined."
    self.m_strDnaName = os.environ[ "DNANAME" ]
    self.m_strLogFileName = "dna_log_%s_%s.txt" % ( self.m_strDnaName,
                                                time.strftime( "%Y%m%d", 
                                                time.localtime(time.time() ) )
                                                )
    #
    #
    #
    Debug.setGuiproxy(self)

  def forward_dna_message(self, the_dna_message):
    #
    #
    #
    self.condition.acquire()
    self.message_queue.put(the_dna_message)
    self.condition.notify()
    self.condition.release()


  def get_last_log_lines(self):
    return self.last_log_lines


  def run(self):
    #
    #
    #
    while (True):
      self.condition.acquire()
      self.condition.wait()
      self.condition.release()
      while (not self.message_queue.empty()):
        dna_message = self.message_queue.get(0)
        type = dna_message.getType()
        #message = dna_message.getMessage()
        message_lines = string.split( dna_message.getMessage(), "\n" )
        level = dna_message.getLevel()
        if level is None:
          level = 0
        debug_level = Debug.getLevel()
        gui_message = XSD.Gui_message()
        timestring = time.strftime("%d%m%y %H:%M:%S", time.localtime(time.time()))
        new_message = None
        for message in message_lines:
            if debug_level >= 1:
              if level is None:
                new_message = "%s (%8s) : %s" % (timestring, type, message)
              else:
                new_message = "%s (%8s level %d) : %s" % (timestring, type, level, message)
            else:
              new_message = "%s : %s" % (timestring, message)
            gui_message.setContent(new_message)
            xml_message = gui_message.marshal()
            #
            # Print log messages with level 1
            #
            if (debug_level >= 1) or (level < 2):
              try:
                reply = XML_utils.http_post(self.GUI_host, self.GUI_port, \
                                          "/message", xml_message)
              except:
                pass
            #
            # Now saves log messages wit level 1-2
            #
            if (debug_level >= 1) or (level < 3):
              #
              # Print to stdout as well
              #
              print new_message
              #
              # Save the last lines in case of errors
              #
              self.last_log_lines.append(new_message)
              if len(self.last_log_lines) > self.no_last_log_lines:
                self.last_log_lines.remove(self.last_log_lines[0])
              #
              # Writes a line in the user log file
              #
              try:
                log_filename = os.path.join( ESContext.get_current_log_dir(), "dna_log.txt" )
                if os.access(log_filename, os.F_OK):
                  logFile = open(log_filename, "a+")
                else:
                  logFile = open(log_filename, "w")
                logFile.write(new_message)
                logFile.write("\n")
                logFile.close()
              except:
                pass
              #
              # Writes a line in the default log file
              #
              try:
                log_filename2 = os.path.join( ESContext.get_default_log_dir(), self.m_strLogFileName )
                if os.access(log_filename2, os.F_OK):
                  logFile2 = open(log_filename2, "a+")
                else:
                  logFile2 = open(log_filename2, "w")
                logFile2.write(new_message)
                logFile2.write("\n")
                logFile2.close()
              except:
                pass
