#################################################################
#
# BcmParametersHelper.py
#
# Authors: The DNA team, http://www.dna.ac.uk
#
# Version: $Id: BcmParametersHelper.py,v 1.11 2006/03/22 16:33:37 svensson Exp $
#
#################################################################

import pprint, time, socket, re, traceback, math
import os, string, sys, threading
import XSD
# import DiffractionImage, XSD
import Screen
from ESContext import *
from DetectorDatabase import *

def getBcmParametersFromImageFile(fileinfo):
    bcm_parameters_response = XSD.Bcm_parameters_response()
    status = XSD.Status()
    try:
        #
        # Get the header from the last collected image
        #
        filename = ESContext.getPath_to_image(fileinfo,1)
        if not os.access(filename, os.F_OK):
            raise "Image %s not available" % filename
        header = Screen.GetHeader(filename)
        #
        # The beam position
        #
        beam = XSD.Beam()
        beam.setX(header['BeamX'])
        beam.setY(header['BeamY'])
        #
        # The detector type is determined by the suffix
        #
        detector = XSD.Detector()
        the_suffix = fileinfo.getSuffix()
        detector = DetectorDatabase.determine_detector_from_suffix(the_suffix)
        #
        # Wavelength, distance and resolution
        #
        experiment = XSD.Experiment()
        experiment.setWavelength(header['Wavelength'])
        experiment.setDistance(header['Distance'])
        #
        # Calculates the max resolution at the edge of the detecor
        # given parameters from the BCM.
        #        
        detector_type = detector.getType()
        detector_width = min(header['Width'], header['Height'])
        #
        # Resolution calculated with the minimum distance to
        # the detector border
        #
        d1 = beam.getX()
        d2 = detector_width - d1
        d3 = beam.getY()
        d4 = detector_width - d3
        min_d = min([d1,d2,d3,d4])
        #
        # Angle corresponding to min_d
        #
        two_theta = math.atan(min_d/header['Distance'])
        theta = two_theta / 2.0
        #
        # And, finally, the maximum resolution
        #
        resolution_max = header['Wavelength'] / (2.0 * math.sin(theta))
        resolution = XSD.Resolution()
        resolution.setUpper(resolution_max)
        experiment.setResolution(resolution)
        #
        # Construct the BCM parameter response
        #
        bcm_parameters_response.setBeam(beam)
        bcm_parameters_response.setDetector(detector)
        bcm_parameters_response.setExperiment(experiment)
        #
        # Ok!
        #
        status.setCode("ok")
        #
        # 
        #
    except:
        #
        # Something went wrong...
        #
        status.setCode("error")
        status.setMessage("Exception in BcmParametersHelper: %s"%(traceback.format_exception_only(sys.exc_type, sys.exc_value)[0]))
        #
        #
        #
    bcm_parameters_response.setStatus(status)
    #
    #
    #
    return bcm_parameters_response
    

if __name__ == '__main__':

    import pprint

    fileinfo = XSD.Fileinfo()
    fileinfo.setDirectory("/scisoft/users/svensson/develop/dna_testdata/trypsin")
    fileinfo.setPrefix("ref-trypsin")
    fileinfo.setSuffix("img")
    fileinfo.setRun_number(1)

    bcm_params = getBcmParametersFromImageFile(fileinfo)
    
    pprint.pprint(bcm_params.toDict())

    fileinfo.setDirectory("/scisoft/users/svensson/develop/dna_testdata/es")
    fileinfo.setPrefix("ref-id14eh3")
    fileinfo.setSuffix("mccd")
    fileinfo.setRun_number(1)

    bcm_params = getBcmParametersFromImageFile(fileinfo)
    
    pprint.pprint(bcm_params.toDict())

    fileinfo.setDirectory("/scisoft/users/svensson/develop/dna_testdata/es")
    fileinfo.setPrefix("ref-id23eh1")
    fileinfo.setSuffix("mccd")
    fileinfo.setRun_number(1)

    bcm_params = getBcmParametersFromImageFile(fileinfo)
    
    pprint.pprint(bcm_params.toDict())
