#################################################################
#
# BCM_proxy.py
#
# Authors: The DNA team, http://www.dna.ac.uk
#
# Version: $Id: BCM_proxy.py,v 1.8 2003/09/10 16:23:20 svensson Exp $
#
#################################################################

import dna_httplib, os, string, sys, traceback
import XSD

FALSE = 0
TRUE  = 1

DEBUG = TRUE

class BCM_proxy:

  def __init__(self, server_name, port):
    self.server_name = server_name
    self.port = port

  def send(self, command, request):
    status = XSD.Status()
    try:
      xml_message = self.http_post(command, request.marshal())
      status.unmarshal(xml_message)
    except:
      status.setCode("error")
      status.setMessage("Exception: %s"%(traceback.format_exception_only(sys.exc_type, sys.exc_value)[0]))
    return status

  def get_bcm_parameters(self):
    status = XSD.Status()
    bcm_parameters_request = XSD.Bcm_parameters_request()
    bcm_parameters_request.setSynchronous('true')
    bcm_parameters_response = XSD.Bcm_parameters_response()
    try:
      xml_message = self.http_post('/bcm_parameters_request', bcm_parameters_request.marshal())
      bcm_parameters_response.unmarshal(xml_message)
    except:
      status.setCode("error")
      status.setMessage("Exception: %s"%(traceback.format_exception_only(sys.exc_type, sys.exc_value)[0]))
      bcm_parameters_response.setStatus(status)
    return bcm_parameters_response


  def abort(self):
    pass
    #reply = self.http_post("/abort", "<?xml version='1.0'?><abort/>")
    

  def send_message(self, message):
    reply = self.http_post("/message", message)
    return reply

  def http_post(self, path, message):
    h = dna_httplib.HTTP("%s:%d"%(self.server_name, self.port))
    h.putrequest("POST", path)
    h.putheader("Content-Type", "text/xml")
    h.putheader("Content-Length", "%d" % len(message))
    h.putheader('Accept', 'text/plain')
    h.putheader('Host', os.environ["HOSTNAME"])
    h.endheaders()
    h.send(message)
    reply, msg, hdrs = h.getreply()
    word = hdrs.getrawheader("Content-Length")
    length = string.atoi(word)
    data = h.getfile().read(length)
    return data


