#
# This script prepares the eclipse files for DNA
#

import os, sys, string

#
# First check tha DNAHOME is defined.
#

DNAHOME = None
if "DNAHOME" in os.environ.keys():
    DNAHOME = os.environ[ "DNAHOME" ]
else:
    print
    print "DNAHOME not defined - using current working directory."
    DNAHOME = os.getcwd()
    
print
print "Preparing eclipse project files for DNAHOME = %s" % DNAHOME
print

#
# Then check that we are not overwriting an existing eclipse project...
#

strEclipseProjectPath = os.path.join( DNAHOME, ".project" )
if os.path.exists( strEclipseProjectPath ):
    print "There exists already an eclipse project in %s" % strEclipseProjectPath
    print 
    print "This script will overwrite this project file."
    print
    strAnswer = raw_input( "Do you want to continue (y/n):" )
    print
    if strAnswer.upper() != "Y":
        print "Script aborted - no existing files changed."
        print
        sys.exit( 1 )


strNewProjectName = os.path.basename( DNAHOME )

strListLaunchFileNames = [ "GUI_test_screen.launch",
                           "GUI_test_scale.launch",
                           "ES_test_screen.launch",
                           "ES_test_scale.launch",
                           ".classpath",
                           ".project"
                           ]

for strLaunchFileName in strListLaunchFileNames:
    strLaunchFilePrototypePath = os.path.join( DNAHOME, "eclipseProject", strLaunchFileName + ".prototype" )
    f = open( strLaunchFilePrototypePath, "r" )
    strLaunchFilePrototype = f.read()
    f.close()
    strNewLaunchFile = string.replace( strLaunchFilePrototype, 
                                       "DNA_ECLIPSE_PROJECT_NAME", 
                                       strNewProjectName
                                     )
    strNewLaunchFilePath = os.path.join( DNAHOME, "eclipseProject", 
                                         strNewProjectName + "-" + strLaunchFileName
                                         )
    f = open( strNewLaunchFilePath, "w" )
    f.write( strNewLaunchFile )
    f.close()
    
    
os.system( "cp %s %s" % ( os.path.join( DNAHOME, "eclipseProject", "%s-.project" % strNewProjectName),
                          os.path.join( DNAHOME, ".project" ) 
                        ) )
                        
os.system( "cp %s %s" % ( os.path.join( DNAHOME, "eclipseProject", "%s-.classpath" % strNewProjectName),
                          os.path.join( DNAHOME, ".classpath" ) 
                        ) )

strTestsDirectoryName = os.path.join( DNAHOME, "tests" )
if not os.path.exists( strTestsDirectoryName ):
    print "Directory %s needed by the eclipse project files does not exist." % strTestsDirectoryName
    print
    print "Creating it but you might want to download the test images to this"
    print "directory by running one of the dna test scripts in "
    print DNAHOME
    print
    os.mkdir( strTestsDirectoryName )
                        
print "Done."
print
