import unittest
import MySQLdb

from ISPyBDb import *

class TestConnection(unittest.TestCase):

    def setUp(self):
        self.ISPyBDb = ISPyBDb(host='bldata',\
                                  user='pxuser',\
                                  passwd='pxuser',\
                                  db='ispybdb')
        self.db = self.ISPyBDb.db
        self.cursor = self.db.cursor()
        
        self.tearDown()
               
        self.testDict = {\
            "Shipping":['shippingId',"999999,999999,'unittestcode','unittestagent','03-12-2004',\
                    '03-12-2004','unittestcode','unittestflightcode'"],\
            "Dewar":['dewarId',"999999,999999,'unittestcode','unittestcomments',1,'testlocation','03-12-2004'"],\
            "Container":['ContainerId',"999999,999999,'unittestdata','unittestdata',999999,'testlocation'"],\
            "XmlSchema":['xmlSchemaId',"999999,'unittestdata','unittestdata'"],\
            "XmlDocument":['xmlDocumentId',"999999,999999,'xmlunittestdata'"],\
            "DiffractionPlan":['diffractionPlanID',"999999,999999,'SAD',0.0,0.0"],\
            "Laboratory":['laboratoryId',"999999,'testUUID','testname','testaddr','testcity','testcountry',\
                    'testoraganization','testurl'"], \
            "Person":['personId',"999999,999999,'testuuid','testfamilyname','testgivenname','testtitle','testemail',\
                'testnumber','testlogin','passwd'"], \
            "Proposal":['proposalId',"999999,999999,'test','DD',999"], \
            "BeamLineSetup":['beamLineSetupId',"999999,'03-12-2004'"],\
            "Session":['sessionId',"999999,999999,999999,'testprojectcode','03-12-2004','03-12-2004',\
                'lapbliss',0,1,'unittest entry'"],\
            "Protein":['proteinId',"999999, 'testname','testprotein', 1.12345, \
                'testType','testSequence',999999"], \
            "Crystal":['crystalId',"999999, 999999, 999999, 'testUUID','testname','testspacegroup',\
                'testmorphology','testcolour',1.2,1.4,1.6,2.2,2.4,2.6,3.2,3.4,3.6,\
                'testcomments' "], \
            "BLSample":['blSampleId',"999999,999999,999999,999999,'testblsample','testcode',\
                'testlocation',1.1,2.2,'testlooptype',3.3,'testcomments','testcompletion',\
                'teststructure','testpublication'"], \
        }
        """ the records must be inserted in the right order to respect foreign key constraints """
        self.testDictkeys = ['Laboratory','Person','XmlSchema','XmlDocument',\
                            'DiffractionPlan','Proposal','Shipping','Dewar',\
                            'Container','BeamLineSetup','Session','Protein',\
                            'Crystal','BLSample']
        for key in self.testDictkeys:        
            querystr = "insert into %s values (%s)" % (key,self.testDict[key][1])
            self.ISPyBDb.doQuery(querystr)
            querystr = "select * from %s where %s = 999999" % (key,self.testDict[key][0])
            results = self.ISPyBDb.doQuery(querystr)
            exec("self.%sDict = self.ISPyBDb._queryResultToDict('%s',self.ISPyBDb.doQuery(\"%s\"))" % \
                (key.lower(),key,querystr))

    def _makeTestDict(self,table):
        dict = {}
        idx = 0
        values = self.testDict[table].split(',')
        for key in self.ISPyBDb._getAttList(table):
            dict[key] = values[idx].strip("'")
            idx += 1
        print dict
        return dict
            
    def tearDown(self):
        self.querydeletelist = [\
            "delete from Proposal where proposalId = 999999", \
            "delete from Session where sessionId = 999999",\
            "delete from Protein where proteinId = 999999",\
            "delete from Crystal where crystalId = 999999",\
            "delete from BLSample where blSampleId = 999999",\
            "delete from XmlSchema where xmlSchemaId = 999999",\
            "delete from XmlDocument where xmlDocumentId = 999999",\
            "delete from Laboratory where laboratoryId = 999999",\
            "delete from Person where personId = 999999",\
            "delete from BeamLineSetup where beamLineSetupId = 999999",\
            "delete from Container where ContainerId = 999999",\
            "delete from Dewar where dewarId = 999999",\
            "delete from Shipping where shippingId = 999999",\
            "delete from DiffractionPlan where diffractionPlanID = 999999"\
            ]
        for query in self.querydeletelist:
            self.ISPyBDb.doQuery(query)
        self.cursor.close()
        

    def testSetTable(self):
        for table in self.testDictkeys:
            query = "delete from %s where %sId = 999999" %(table,table.lower())
            self.ISPyBDb.doQuery(query)
            exec("key = self.ISPyBDb.setTable('%s',self.%sDict);\
                self.assertEqual(key,self.%sDict[self.testDict['%s'][0]])" % \
                (table,table.lower(),table.lower(),table))
    
    def testGetTable(self):
        for table in self.testDict.keys():
            exec("results = self.ISPyBDb.getTable('%s',self.testDict['%s'][0],self.%sDict[self.testDict['%s'][0]]);\
                self.assertEqual(results,self.%sDict)" % \
                (table,table,table.lower(),table,table.lower()))
        
    def testGetProposals(self):
        proposals = self.ISPyBDb.getProposals("DD",999)
        self.assertEqual(proposals,self.proposalDict)

    """
    def testMapProposal(self,xmlproposaldict):
        proposal = self.ISPyBDb.MapProposal(xmlproposaldict)
        self.assertEqual(proposal,self.testDict['proposal'])
    """
        
if __name__ == '__main__':
    unittest.main()

