import sys
sys.path.append('../../xsd/python')
import unittest
import httplib
import string
import XSD
import pprint

class TestServer(unittest.TestCase):

    def ntestGetProposal(self):
        proposal = XSD.Proposal()
        proposal.setCode("mx")
        proposal.setNumber(415)
        xml_proposal = proposal.marshal()
        print xml_proposal
        h = httplib.HTTP('wow' + ':' + str(2223))
        h.putrequest("POST", "%s"%('/proposal_request'))
        h.putheader("'Host', '%s'"%('wow'))
        h.putheader("Content-Type", "text/xml")
        h.putheader("Content-Length", "%d" % len(xml_proposal))
        h.endheaders()
        h.send(xml_proposal)
        reply, msg, hdrs = h.getreply()
        #print "Reply is %s , with message %s"%(reply, msg)
        #print hdrs
        word = hdrs.getrawheader("Content-Length")
        length = string.atoi(word)
        xml_proposal_response = h.getfile().read(length) # get the raw HTML
        #print xml_proposal_response
        proposal_response = XSD.Proposal_response()
        proposal_response.unmarshal(xml_proposal_response)
        #pprint.pprint(proposal_response.toDict())

    def testGetLoadedSamples(self):
        request = XSD.Loaded_samples_request()
        proposal = XSD.Proposal()
        sample_ref = XSD.Sample_reference()
        sample_ref.setCode("HA00AK0594")
        request.addSample_reference(sample_ref)
        
        sample_ref = XSD.Sample_reference()
        sample_ref.setCode("HA00AK0595")
        request.addSample_reference(sample_ref)
        
        proposal.setProposalId(1170)
        request.setProposal(proposal)
        xml_request = request.marshal()
        print xml_request
        h = httplib.HTTP('plouf' + ':' + str(2224))
        h.putrequest("POST", "%s"%('/loaded_samples_request'))
        h.putheader("'Host', '%s'"%('plouf'))
        h.putheader("Content-Type", "text/xml")
        h.putheader("Content-Length", "%d" % len(xml_request))
        h.endheaders()
        h.send(xml_request)
        reply, msg, hdrs = h.getreply()
        print "Reply is %s , with message %s"%(reply, msg)
        print hdrs
        word = hdrs.getrawheader("Content-Length")
        length = string.atoi(word)
        xml_response = h.getfile().read(length) # get the raw HTML
        loaded_samples_response = XSD.Loaded_samples_response()
        loaded_samples_response.unmarshal(xml_response)
        pprint.pprint(loaded_samples_response.toDict())

if __name__ == '__main__':
    unittest.main()
