import MySQLdb
import string

AVOID_TABLES=("AUTO_PK_SUPPORT",)

class DatabasetoXSD:
    def __init__(self,host,user,passwd,db):
        self.db = self.Connect(host=host,user=user,passwd=passwd,db=db)
        self.cursor = self.db.cursor()
    def getAttList(self,tName):
        sql = "DESCRIBE " + tName
        rs = self.doQuery(sql)
        return rs
    def doQuery(self,querystr):
        self.cursor.execute(querystr)
        return self.cursor.fetchall()
    def Connect(self,host,user,passwd,db):
        return MySQLdb.Connect(host,user,passwd,db)

def printTable(tableName,converter):
    typeDict={'int':'integer', 'varchar':'string', 'datetime':'string',\
        'tinyint':'boolean', 'float':'double', 'timestamp':'string',\
        'longtext':'string', 'enum':'string', 'date':'string',\
        'double':'double', 'tinytext':'string'}

    table_id=[]

    attList = converter.getAttList(tableName)

    print '  <xsd:complexType name="%s">' % tableName
    print '    <xsd:sequence>'

    for att in attList:
        #print "Atributes for",tableName,"are",att
        name=att[0]
        #minEl=1
        #if att[2]=="YES":
        #    minEl=0
        minEl=0
        print '      <xsd:element name="%s"' % name
        print '                   minOccurs="%d"' % minEl
        print '                   maxOccurs="1"'
        t=att[1]

        new_type=None        
        for k in typeDict.keys():
            if t.startswith(k):
                new_type=typeDict[k]
                break
        if new_type is not None:
            t=new_type
        else:
            print "Unknown type",t
            raise TypeError

        if att[3]=="PRI":
            table_id.append(name)

        print '                   type="xsd:%s"/>' % t
    print '    </xsd:sequence>'
    print '  </xsd:complexType>'
    print
    print
    
    return table_id

def printHeader():
    print """<!--
********************************************************
*
* dna_database.xsd
*
* Authors: The DNA team, http://www.dna.ac.uk
*
* Version: $Id: db2xsd.py,v 1.2 2005/11/22 13:38:14 svensson Exp $
*
********************************************************
-->

<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLS chema"
            xmlns:dna="http://www.dna.ac.uk/DNA_XMLSchema">

"""

def printDbStatus(tables):
    inserted_ids=[]

    print """<xsd:complexType name="dbstatus">
    <xsd:sequence>"""

    for table_name in tables:
        table_ids=tables[table_name]
        
        for table_id in table_ids:
            if table_id not in inserted_ids:
                print """      <xsd:element name="%s"
                   minOccurs="0" 
                   maxOccurs="unbounded" 
                   type="xsd:integer"/>""" % table_id

            inserted_ids.append(table_id)

    print """      <xsd:element name="code"    
                   minOccurs="1" 
                   maxOccurs="1" 
                   type="status_code"/>      
      <xsd:element name="message" 
                   minOccurs="0" 
                   maxOccurs="1" 
                   type="xsd:string"/>      
    </xsd:sequence>
  </xsd:complexType>
"""

def printFooter():
    print '</xsd:schema>'

if __name__ == '__main__':
    converter = DatabasetoXSD("bldata","pxadmin","pxadmin","ispydb_test")

    printHeader()

    tables=converter.doQuery("show tables;")
    table_ids={}
    for table in tables:
            tbl_name=table[0]
            if tbl_name not in AVOID_TABLES:
                table_id=printTable(tbl_name,converter)
                table_ids[tbl_name]=table_id

    printDbStatus(table_ids)

    printFooter()
