__revision__ = '$Revision: 1.6 $'

import MySQLdb
import string

class PXWeb:

    def __init__(self,host,user,passwd,db):
        self.db = self.Connect(host=host,user=user,passwd=passwd,db=db)
        self.cursor = self.db.cursor()
        
    def _getAttList(self,tName):
        sql = "DESCRIBE " + tName
        rs = self.doQuery(sql)
        rows = []
        types = []
        for row in range(len(rs)):
            rows.append(rs[row][0])
            types.append(rs[row][1])
        return (rows,types)
                
    def doQuery(self,querystr):
        self.cursor.execute(querystr)
        return self.cursor.fetchall()

    def _queryResultToDictList(self,table,queryresult):
        keylist = self._getAttList(table)[0]
        __resultList = []
        for result in queryresult:
            idx = 0
       	    __resultDict = {}
            for key in keylist:
                __resultDict[key] = result[idx]
                idx += 1
            __resultList.append(__resultDict)
        return __resultList
        
    def _doInsertQuery(self,table,keyvalues):
        fieldlist = ''
        valuelist = ''
        for key in keyvalues.keys():
            fieldlist += key + ','
            try:
                eval(proposalDict[key])+1
                valuelist += '%s,'% keyvalues[key]
            except:
                valuelist += "'%s'," % keyvalues[key]
        stmt = "INSERT into %s (%s) values (%s)" % (table,\
                fieldlist[0:len(fieldlist)-1],valuelist[0:len(valuelist) -1])
        queryResult = self.doQuery(stmt)
        try:
            insert_id = self.db.insert_id()
        except:
            insert_id = self.db._db.insert_id()
        return insert_id
    

    def Connect(self,host,user,passwd,db):
        return MySQLdb.Connect(host,user,passwd,db)
        
    def setTable(self,table,dict):
        return self._doInsertQuery(table,dict)
        
    def getTable(self,table,key,value):
        stmt = "SELECT * from %s where %s = %d" % (table,key,value)
        self.cursor.execute(stmt) 
        queryResult = self.cursor.fetchall()
        return self._queryResultToDictList(table,queryResult)
        
    def getProposals(self,code,number):
        stmt = "SELECT * from PROPOSAL where PROPOSAL_CODE = '%s' and PROPOSAL_NUMBER = %d" % \
                (code,number)
        self.cursor.execute(stmt) 
        queryResult = self.cursor.fetchall()
        print "DEBUG queryResult = ", queryResult
        return self._queryResultToDictList('PROPOSAL',queryResult)
        
    def get_loaded_samples_request(self,proposal_key,sample_references):
        responseList = []

        self.protein_table_keys = [\
        'protein_key','protein_name','protein_acronym','proposal_key','sample_uo_ref']

        self.crystaltype_table_keys = [\
        'crystal_key','protein_key','space_group','cell_dim_a','cell_dim_b',\
        'cell_dim_c','cell_dim_al','cell_dim_be','cell_dim_ga', \
        'res_req', 'exposure', 'osc_range', 'comments']

        self.blsample_keys = [\
        'sample_key','dewar_key','crystal_key','blsample_name','data_set',\
        'crystal_size','rsym','reso_req','remarks','exp_status','holder_id','uniquecrystalid']

        allkeys= self.protein_table_keys + self.crystaltype_table_keys + self.blsample_keys 
        idx=0
        for sample_reference in sample_references:
            if sample_reference.getCode() is None:
                break
	    print "Sample_reference code: %s" % sample_reference.getCode()
            stmt = "SELECT PROTEIN.PROTEIN_KEY,\
                    PROTEIN.PROTEIN_NAME,\
                    PROTEIN.PROTEIN_ACRONYM,\
                    PROTEIN.PROPOSAL_KEY,\
                    PROTEIN.SAMPLE_UO_REF,\
                    CRYSTALTYPE.CRYSTAL_KEY,\
                    CRYSTALTYPE.PROTEIN_KEY,\
                    CRYSTALTYPE.SPACE_GROUP,\
                    CRYSTALTYPE.CELL_DIM_A,\
                    CRYSTALTYPE.CELL_DIM_B,\
                    CRYSTALTYPE.CELL_DIM_C,\
                    CRYSTALTYPE.CELL_DIM_AL,\
                    CRYSTALTYPE.CELL_DIM_BE,\
                    CRYSTALTYPE.CELL_DIM_GA,\
                    CRYSTALTYPE.RES_REQ, \
                    CRYSTALTYPE.EXPOSURE, \
                    CRYSTALTYPE.OSC_RANGE, \
                    CRYSTALTYPE.COMMENTS,\
                    BLSAMPLE.SAMPLE_KEY,\
                    BLSAMPLE.DEWAR_KEY,\
                    BLSAMPLE.CRYSTAL_KEY,\
                    BLSAMPLE.BLSAMPLE_NAME,\
                    BLSAMPLE.DATA_SET,\
                    BLSAMPLE.CRYSTAL_SIZE,\
                    BLSAMPLE.RSYM,\
                    BLSAMPLE.RESO_REQ,\
                    BLSAMPLE.REMARKS,\
                    BLSAMPLE.EXP_STATUS,\
                    BLSAMPLE.HOLDER_ID, \
                    BLSAMPLE.UNIQUECRYSTALID \
                    FROM BLSAMPLE \
                    LEFT JOIN CRYSTALTYPE ON BLSAMPLE.CRYSTAL_KEY=CRYSTALTYPE.CRYSTAL_KEY \
                    LEFT JOIN PROTEIN ON CRYSTALTYPE.PROTEIN_KEY=PROTEIN.PROTEIN_KEY \
                    WHERE PROTEIN.PROPOSAL_KEY = %d AND BLSAMPLE.HOLDER_ID='%s'" \
                    % (proposal_key,sample_reference.getCode().strip())
            result = self.doQuery(stmt)
            print 'result', result
            # should be one result, if not then there are multiple entries for one holder_id/proposal
            for sample in result:
                keyidx = 0
                tmpDict = {}
                for key in allkeys:
                    tmpDict[key]=sample[keyidx]
                    keyidx+=1
                responseList.append(tmpDict)
        print responseList
        return(responseList)
        
    def MapProposal(self,dict):
        pass  
