import BaseHTTPServer
import SocketServer
import string
import logging
import XSD
import ISPyB
import UserOfficeConnect
import xml.sax
from xml.sax import SAXParseException
from xml.sax.handler import ContentHandler

###
### Request handler
###
class ISPyBRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):
    def sendData(self,s):
        try:
            self.wfile.write(s)
        except Exception,diag:
            logging.getLogger().error("ISPyBServer: error sending data (%s)" % str(diag))

    def do_POST(self):
        db_status = XSD.Status()
        xml_response = ""

        try:
            content_length_string = self.headers.getheader("Content-length")
            if content_length_string is None: # Error: no content-length header
                logging.getLogger().error("ISPyBServer: received request but content length is void")
                raise "BadRequestError"

            xml_message_length = string.atoi(content_length_string)
            xml_message = self.rfile.read(xml_message_length)

            # Execute the requested method
            if self.path == "/proposal_request":
                logging.getLogger().debug("ISPyBServer: Proposal_request=%r" % xml_message)
                proposal_request = XSD.Proposal()
                proposal_request.unmarshal(xml_message)
                xsd_response = self.db_get_proposal_request(proposal_request)

            elif self.path == "/loaded_samples_request":
                logging.getLogger().debug("ISPyBServer: loaded_samples_request=%r" % xml_message)
                request = XSD.Loaded_samples_request()
                request.unmarshal(xml_message)
                xsd_response = self.db_get_loaded_samples_request(request)
                
            elif self.path == "/store_datacollection_request":
                logging.getLogger().debug("ISPyBServer: store_datacollection_request=%r" % xml_message)
                request = XSD.DataCollection()
                request.unmarshal(xml_message)
                xsd_response = self.db_store_collect_request(request)

            elif self.path == "/update_datacollection_request":
                logging.getLogger().debug("ISPyBServer: update_datacollection_request=%r" % xml_message)
                request = XSD.DataCollection()
                request.unmarshal(xml_message)
                xsd_response = self.db_update_collect_request(request)

            elif self.path == "/get_session_localcontact":
                logging.getLogger().debug("ISPyBServer: get_session_localcontact=%r" % xml_message)
                request = XSD.Session()
                request.unmarshal(xml_message)
                xsd_response = self.db_get_session_localcontact(request)

            elif self.path == "/store_image_request":
                logging.getLogger().debug("ISPyBServer: store_image_request=%r" % xml_message)
                request = XSD.Image()
                request.unmarshal(xml_message)
                xsd_response = self.db_store_image_request(request)

            elif self.path == "/session_samples_request":
                logging.getLogger().debug("ISPyBServer: session_samples_request=%r" % xml_message)
                request = XSD.Loaded_samples_request()
                request.unmarshal(xml_message)
                xsd_response = self.db_get_session_samples_request(request)

            elif self.path == "/sample_info_request":
                logging.getLogger().debug("ISPyBServer: sample_info_request=%r" % xml_message)
                request = XSD.BLSample()
                request.unmarshal(xml_message)
                xsd_response = self.db_sample_info_request(request)

            elif self.path == "/create_session_request":
                logging.getLogger().debug("ISPyBServer: create_session_request=%r" % xml_message)
                request = XSD.Session()
                request.unmarshal(xml_message)
                xsd_response = self.db_create_session_request(request)

            elif self.path == "/store_object_request":
                logging.getLogger().debug("ISPyBServer: store_object_request=%r" % xml_message)
                objectdict = XSD.XSDBase().XMLStringToDict(xml_message)
                objectxsdtype = objectdict.keys()[0]
                objecttype = objectdict.keys()[0]
                exec("request = XSD.%s()" % capitalizeFirstLetter( objectxsdtype ))
                request.unmarshal(xml_message)
                xsd_response = self.db_store_object(objecttype,objectdict)

            elif self.path == "/retrieve_object_request":
                logging.getLogger().debug("ISPyBServer: retrieve_object_request=%r" % xml_message)
                objectdict = XSD.XSDBase().XMLStringToDict(xml_message)
                objectxsdtype = objectdict.keys()[0]
                objecttype = objectdict.items()[0][1].keys()[0]
                exec("request = XSD.%s()" % capitalizeFirstLetter( objectxsdtype ))
                request.unmarshal(xml_message)
                xsd_response = self.db_get_object(objecttype,objectdict)

            else: # Error: unknown request
                logging.getLogger().error("ISPyBServer: unknown request (%s)" % self.path)
                xsd_response = XSD.Status()
                xsd_response.setCode('error')
                xsd_response.setMessage('ISPyBServer: internal server error')
                raise "InternalServerError"

            # Convert the response object into XML
            xml_response=xsd_response.marshal()
            logging.getLogger().debug("ISPyBServer: xml_response=%s" % xml_response)
            self.sendData("HTTP/1.1 200 OK\n")

        # Catch the exceptions thrown while processing the request
        except "InternalServerError":
            db_status.setCode("error")
            db_status.setMessage("ISPyBServer: internal server error")
            self.sendData("HTTP/1.1 500 Internal Server Error\n")

        # Catch the exceptions thrown while processing the request
        except "BadRequestError":
            db_status.setCode("error")
            db_status.setMessage("ISPyBServer: bad request error")
            self.sendData("HTTP/1.1 400 Bad Request\n")

        server_name = self.hostname
        self.sendData("Host: %s\n"%(server_name))
        self.sendData("Content-type: text/xml\n")
        self.sendData("Content-length: %d\n\n"%(len(xml_response)))
        self.sendData(xml_response)

    # Description    : Stores a data collection
    # Argument type  : XSD.Datacollection
    # Tables modified: DataCollection
    # Return type    : XSD.Dbstatus
    def db_store_collect_request(self,request):
        logging.getLogger().debug("ISPyBServer: db_store_collect_request")
        inputParDict = request.toDict()

        # Create a new entry in the DataCollection table        
        status = XSD.Dbstatus()
        try:
            result = ISPyBRequestHandler.ispyb.insertRecord('DataCollection',inputParDict)
        except Exception,ex:
            status.setCode('error')
            msg="ISPyBServer: %s" % str(ex)
            status.setMessage(msg)
            logging.getLogger().error(msg)
        else:
            status.setCode('ok')
            status.setMessage('New entry in DataCollection')
            status.setDataCollectionId(int(result[1]))

        return status

    # Description    : Updates a data collection
    # Argument type  : XSD.Datacollection
    # Tables modified: DataCollection
    # Return type    : XSD.Dbstatus
    def db_update_collect_request(self,request):
        logging.getLogger().debug("ISPyBServer: db_update_collect_request")
        inputParDict = request.toDict()

        # Remove the primary key from the dictionary and use it to build another one
        cond_dict={}
        for key in inputParDict.keys():
            if key.endswith("ID") or key.endswith("Id"):
                cond_dict[key]=inputParDict.pop(key)

        # Update the DataCollection table
        status = XSD.Dbstatus()
        try:
            result = ISPyBRequestHandler.ispyb.updateRecord('DataCollection',inputParDict,cond_dict)
        except Exception,ex:
            status.setCode('error')
            msg="ISPyBServer: %s" % str(ex)
            status.setMessage(msg)
            logging.getLogger().error(msg)
        else:
            status.setCode('ok')
            status.setMessage('Updated entry in DataCollection')

        return status

    # Description  : Returns the information of one proposal (person, sessions, etc.)
    # Argument type: XSD.Proposal
    # Return type  : XSD.Proposal_response
    def db_get_proposal_request(self,request):
        logging.getLogger().debug("ISPyBServer: db_get_proposal_request")

        # Create response objects
        status = XSD.Status()
        proposal_response = XSD.Proposal_response()

        given_code=request.getCode()
        prop_code=translate(given_code,'ispyb')
        uo_code=translate(given_code,'uo')

        # Fetch the proposal from the UserOffice database
        try:
            uoproposal = ISPyBRequestHandler.userOffice.GetUserOfficeProposal(uo_code,request.getNumber())
        except Exception,diag:
            logging.getLogger().warning("ISPyBServer: received an error from the User Office database (%s)" % str(diag))
            uoproposal=None
        else:
            try:
                if uoproposal['status']['message'].lower() != 'ok':
                    logging.getLogger().warning("ISPyBServer: received an error from the User Office database (%s)" % uoproposal['status']['message'])
                    uoproposal=None
            except KeyError:
                logging.getLogger().warning("ISPyBServer: couldn't retrieve the proposal from the User Office database")
                uoproposal=None

        # Fetch the proposal from the ISPyB database
        ispybdict = ISPyBRequestHandler.ispyb.getProposals(prop_code,request.getNumber())

        # Check if ISPyB proposal actually exists
        if ispybdict is None or len(ispybdict)==0:
            if uoproposal is None:
                status.setCode('error')
                status.setMessage("Couldn't retrieve the proposal from the User Office database")
                proposal_response.setStatus(status)
                return proposal_response

            # Check if the laboratory exists in ISPyB
            uo_lab_name=uoproposal['laboratory']['name']
            uo_lab_country=uoproposal['laboratory']['country']
            lab_result=ISPyBRequestHandler.ispyb.getRecordByFields('Laboratory',('name','country'),(uo_lab_name,uo_lab_country))
            if len(lab_result)==0:
                # Create the laboratory
                temp_dict={'name':uo_lab_name, 'country':uo_lab_country}
                lab_id=ISPyBRequestHandler.ispyb.insertRecord('Laboratory',temp_dict)[1]
                temp_dict={}
            else:
                # Use the first laboratory found
                lab_id=lab_result[0]['laboratoryId']
                if len(lab_result)>1:
                    logging.getLogger().debug("ISPyBServer: several matches for (%s,%s) in Laboratory; using %d" % (uo_lab_name,uo_lab_country,lab_id))

            # Check if the person from that laboratory is in ISPyB
            uo_person_name=uoproposal['person']['familyName']
            person_result=ISPyBRequestHandler.ispyb.getPersonFromLab(uo_person_name,uo_lab_name,uo_lab_country)
            if len(person_result)==0:
                # Create the person
                temp_dict={'givenName':uo_person_name,\
                    'laboratoryId':lab_id,\
                    'login':uo_person_name}
                person_id=ISPyBRequestHandler.ispyb.insertRecord('Person',temp_dict)[1]
                temp_dict={}
            else:
                person_id=person_result[0]['personId']
                if len(person_result)>1:
                    logging.getLogger().debug("ISPyBServer: several matches for (%s,%s,%s) in Person; using %d" % (uo_person_name,uo_lab_name,uo_lab_country,person_id))

            # Create the proposal
            temp_dict={'title':uoproposal['proposal']['title'],\
                'code':prop_code,\
                'number':uoproposal['proposal']['number'],\
                'personId':person_id}
            proposal_id=ISPyBRequestHandler.ispyb.insertRecord('Proposal',temp_dict)[1]
            temp_dict={}

            # Fetch the (just created) proposal
            ispybdict = ISPyBRequestHandler.ispyb.getRecord('Proposal','proposalId',proposal_id)[0]
        else:
            if len(ispybdict)>1:
                logging.getLogger().debug("ISPyBServer: several matches for (%s,%s) in Proposal; using %d" % (request.getCode(),request.getNumber(),ispybdict[0]['proposalId']))
            ispybdict=ispybdict[0]

        # Proposal is ok
        ispybdict['code']=given_code
        ispybproposal = XSD.Proposal()
        ispybproposal.fromDict(ispybdict)

        # Person is ok
        person_dict = ISPyBRequestHandler.ispyb.getRecord('Person','personId',ispybdict['personId'])[0]
        person = XSD.Person()
        person.fromDict(person_dict)
        person_id=person_dict['personId']

        # Laboratory is ok
        lab_dict = ISPyBRequestHandler.ispyb.getRecord('Laboratory','laboratoryId',person_dict['laboratoryId'])[0]
        lab = XSD.Laboratory()
        lab.fromDict(lab_dict)

        # Fetch ISPyB sessions
        ispybsessions=ISPyBRequestHandler.ispyb.getRecord('Session', 'proposalId', ispybdict["proposalId"])

        # Match UO sessions with ISPyB sessions
        if uoproposal is not None:
            uosessions=uoproposal['sessions']
            for uosession in uosessions:
                uo_ses_start=dateUO2ISPyB(uosession['Date_deb'])
                uo_ses_end=dateUO2ISPyB(uosession['Date_fin'])
                uo_beamline=uosession['Instr_nom']
                uo_localcontact=uosession['Local_contact']
                uo_session_id=None

                for ispybsession in ispybsessions:
                    ispyb_ses_start=ispybsession['startDate']
                    ispyb_ses_end=ispybsession['endDate']
                    ispyb_beamline=ispybsession['beamLineName']

                    if uo_ses_start==ispyb_ses_start and uo_ses_end==ispyb_ses_end and\
                        uo_beamline.lower()==ispyb_beamline.lower():
                        uo_session_id=ispybsession['sessionId']
                        break

                # If session not found: create BeamLineSetup and Session entries
                if uo_session_id is None:
                    temp_dict={'date':uo_ses_start}
                    beamlinesetup_id=ISPyBRequestHandler.ispyb.insertRecord('BeamLineSetup',temp_dict)[1]
                    temp_dict={}

                    temp_dict={'startDate':uo_ses_start,\
                        'endDate':uo_ses_end,\
                        'beamLineName':uo_beamline,\
                        'scheduled':uosession['Scheduled'],\
                        'nbShifts':uosession['No_shifts'],\
                        'proposalId':ispybdict["proposalId"],\
                        'beamLineSetupId':beamlinesetup_id}
                    uo_session_id=ISPyBRequestHandler.ispyb.insertRecord('Session',temp_dict)[1]
                    temp_dict={}

                # Session ok but must check the local contact
                session_has_persons=ISPyBRequestHandler.ispyb.getPersonsInSession(uo_session_id,name=uo_localcontact,role="Local Contact")
                if len(session_has_persons)==0:
                    # Session doesn't have a local contact associated; check if it exists
                    localcontact_result=ISPyBRequestHandler.ispyb.getRecordByFields('Person',('givenName',),(uo_localcontact,))
                    if len(localcontact_result)==0:
                        logging.getLogger().debug("ISPyBServer: no such local contact %s" % uo_localcontact)
                    else:
                        # Associate local contact
                        localcontact_id=localcontact_result[0]['personId']
                        if len(localcontact_result)>1:
                            logging.getLogger().debug("ISPyBServer: several matches for %s in Person; using %d as local contact" % (uo_localcontact,localcontact_id))
                        temp_dict={'sessionId':uo_session_id,\
                            'personId':localcontact_id,\
                            'role':'Local Contact'}
                        ISPyBRequestHandler.ispyb.insertRecord('Session_has_Person',temp_dict)
                        temp_dict={}
                else:
                    if len(session_has_persons)>1:
                        logging.getLogger().debug("ISPyBServer: several matches for (%d,%s) in Session_has_Person" % (uo_session_id,uo_localcontact))
        else:
            logging.getLogger().warning("ISPyBServer: couldn't verify the sessions with the User Office database")

        # Sessions are ok
        session_dict_list = ISPyBRequestHandler.ispyb.getRecord('Session', 'proposalId', ispybdict["proposalId"])
        for session_dict in session_dict_list:
            session = XSD.Session()
            session.fromDict(session_dict)
            proposal_response.addSession(session)

        # Build and return the Proposal_response object
        status.setCode('ok')
        status.setMessage('Proposal successfully verified with the User Office')
        proposal_response.setStatus(status)
        proposal_response.setProposal(ispybproposal)
        proposal_response.setPerson(person)
        proposal_response.setLaboratory(lab)

        return proposal_response

    # Description  : Returns the loaded samples of one session
    # Argument type: XSD.Loaded_samples_request
    # Return type  : XSD.Loaded_samples_response
    def db_get_loaded_samples_request(self,request):
        logging.getLogger().debug("ISPyBServer: db_get_loaded_samples_request %r" % request)

        # Fetch all loaded samples
        sample_ref_list=request.getSample_reference() or []
        sample_ref_list2=[]
        for sample_ref in sample_ref_list:
            sample_ref_dict=sample_ref.toDict()
            sample_ref_list2.append(sample_ref_dict)
        sampleList = ISPyBRequestHandler.ispyb.getLoadedSamples(\
            int(request.getProposal().getProposalId()),\
            sample_ref_list2)
        response = XSD.Loaded_samples_response()
        status = XSD.Status()        

        # Go through the samples, and add its the specific object
        for sample in sampleList:
            loaded_sample = XSD.Loaded_sample()

            # Set the proper property using the fetched dictionary
            protein = XSD.Protein()
            for el in sample['protein'].keys():
                exec("protein.set%s(sample['protein']['%s'])" % ( capitalizeFirstLetter( el ),el))

            crystal = XSD.Crystal()
            for el in sample['crystal'].keys():
                exec("crystal.set%s(sample['crystal']['%s'])" % (capitalizeFirstLetter( el ),el))

            blsample = XSD.BLSample()
            for el in sample['blsample'].keys():
                try:
                    exec("blsample.set%s(sample['blsample']['%s'])" % (capitalizeFirstLetter( el ),el))
                except:
                    pass

            diffractionplan_crystaltype = XSD.DiffractionPlan()
            for el in sample['diffractionplan_crystaltype'].keys():
                exec("diffractionplan_crystaltype.set%s(sample['diffractionplan_crystaltype']['%s'])" % (capitalizeFirstLetter( el ),el))

            diffractionplan_blsample = XSD.DiffractionPlan()
            for el in sample['diffractionplan_blsample'].keys():
                exec("diffractionplan_blsample.set%s(sample['diffractionplan_blsample']['%s'])" % (capitalizeFirstLetter( el ),el))

            container = XSD.Container()
            for el in sample['container'].keys():
                exec("container.set%s(sample['container']['%s'])" % (capitalizeFirstLetter( el ),el))

            loaded_sample.setProtein(protein)
            loaded_sample.setCrystal(crystal)
            loaded_sample.setBLSample(blsample)
            loaded_sample.setDiffractionPlan_BLSample(diffractionplan_blsample)
            loaded_sample.setDiffractionPlan_CrystalType(diffractionplan_crystaltype)
            loaded_sample.setContainer(container)

            response.addLoaded_sample(loaded_sample)

        status.setCode('ok')
        response.setStatus(status)
        return response

    # Description  : Returns the samples of a proposal (with the containter status
    #                set to 'Processing'
    # Argument type: XSD.Loaded_samples_request
    # Return type  : XSD.Loaded_samples_response
    def db_get_session_samples_request(self,request):
        logging.getLogger().debug("ISPyBServer: db_get_session_samples_request")

        # Fetch all loaded samples
        sample_ref_list=request.getSample_reference() or []
        sample_ref_list2=[]
        for sample_ref in sample_ref_list:
            sample_ref_dict=sample_ref.toDict()
            sample_ref_list2.append(sample_ref_dict)
        sampleList = ISPyBRequestHandler.ispyb.getSessionSamples(\
            int(request.getProposal().getProposalId()))
        response = XSD.Loaded_samples_response()
        status = XSD.Status()        

        # Go through the samples, and add its the specific object
        for sample in sampleList:
            loaded_sample = XSD.Loaded_sample()

            # Set the proper property using the fetched dictionary
            protein = XSD.Protein()
            for el in sample['protein'].keys():
                exec("protein.set%s(sample['protein']['%s'])" % ( capitalizeFirstLetter( el ),el))

            crystal = XSD.Crystal()
            for el in sample['crystal'].keys():
                exec("crystal.set%s(sample['crystal']['%s'])" % ( capitalizeFirstLetter( el ),el))

            blsample = XSD.BLSample()
            for el in sample['blsample'].keys():
                exec("blsample.set%s(sample['blsample']['%s'])" % ( capitalizeFirstLetter( el ),el))

            loaded_sample.setProtein(protein)
            loaded_sample.setCrystal(crystal)
            loaded_sample.setBLSample(blsample)

            response.addLoaded_sample(loaded_sample)

        status.setCode('ok')
        response.setStatus(status)
        return response

    # Description  : Returns the person acting as a local contact in a session
    # Argument type: XSD.Session
    # Return type  : XSD.Person
    def db_get_session_localcontact(self,request):
        logging.getLogger().debug("ISPyBServer: db_get_session_localcontact")

        person=XSD.Person()

        dict = request.toDict()
        session_id=int(dict['sessionId'])

        session_has_persons=ISPyBRequestHandler.ispyb.getPersonsInSession(session_id,role="Local Contact")
        if session_has_persons is not None and len(session_has_persons)>0:
            session_has_person=session_has_persons[0]
            if len(session_has_persons)>1:
                logging.getLogger().debug("ISPyBServer: several matches for %d in Session_has_Person; using %s as local contact" % (session_id,session_has_person['givenName']))
            person.fromDict(session_has_person)
        return person

    # Description    : Creates an entry in the Image table
    # Argument type  : XSD.Image
    # Tables modified: Image
    # Return type    : XSD.DbStatus
    def db_store_image_request(self,request):
        logging.getLogger().debug("ISPyBServer: db_store_image_request")

        inputParDict = request.toDict()

        # Create a new entry in the DataCollection table        
        status = XSD.Dbstatus()
        try:
            result = ISPyBRequestHandler.ispyb.insertRecord('Image',inputParDict)
        except Exception,ex:
            status.setCode('error')
            msg="ISPyBServer: %s" % str(ex)
            status.setMessage(msg)
            logging.getLogger().error(msg)
        else:
            status.setCode('ok')
            status.setMessage('New entry in Image')
            status.setImageId(int(result[1]))

        return status

    # Description  : Returns the sample information
    # Argument type: XSD.Blsample
    # Return type  : XSD.Blsample
    def db_sample_info_request(self,request):
        logging.getLogger().debug("ISPyBServer: db_sample_info_request")

        dict = request.toDict()
        blsampleid=int(dict['blSampleId'])
        ispybdict = ISPyBRequestHandler.ispyb.getRecord('BLSample','blSampleId',blsampleid)[0]
        blsample=XSD.BLSample()
        blsample.fromDict(ispybdict)
        return blsample

    # Description  : Returns the sample information
    # Argument type: XSD.Blsample
    # Return type  : XSD.Blsample
    def db_create_session_request(self,request):
        logging.getLogger().debug("ISPyBServer: db_create_session_request")

        dict = request.toDict()
        
        temp_dict={'date':dict['startDate']}
        beamlinesetup_id=ISPyBRequestHandler.ispyb.insertRecord('BeamLineSetup',temp_dict)[1]
        dict['beamLineSetupId']=int(beamlinesetup_id)

        session_id=ISPyBRequestHandler.ispyb.insertRecord('Session',dict)[1]
        dict['sessionId']=int(session_id)

        session=XSD.Session()
        session.fromDict(dict)
        return session

    def db_store_object(self,objecttype,requestdict):
        logging.getLogger().debug("ISPyBServer: db_store_object")

        # Create a new entry in the DataCollection table        
        status = XSD.Dbstatus()
        try:
            result = ISPyBRequestHandler.ispyb.insertRecord(objecttype,requestdict[objecttype])
        except Exception,ex:
            status.setCode('error')
            msg="ISPyBServer: %s" % str(ex)
            status.setMessage(msg)
            logging.getLogger().error(msg)
        else:
            status.setCode('ok')
            status.setMessage('New entry inserted into %s, %s' % (objecttype,result))
            exec("status.set%s(int(%d))" % (capitalizeFirstLetter( result[0] ),int(result[1])))

        return status

    def db_get_object(self,objecttype,requestdict):
        logging.getLogger().debug("ISPyBServer: db_get_object")

        status = XSD.Dbstatus()
        # remove the _object to get the real database object name
        dbobjecttype = objecttype.split('_object')[0]
        # get the name of the primary key (it should be the only element given as a reference
        object_id = requestdict['dbobject'].items()[0][1].keys()[0]
        try:
            result = ISPyBRequestHandler.ispyb.getRecord(dbobjecttype,object_id,int(requestdict['dbobject'][objecttype][object_id]))
        except Exception,ex:
            status.setCode('error')
            msg="ISPyBServer: %s" % str(ex)
            status.setMessage(msg)
            logging.getLogger().error(msg)
        else:
            status.setCode('ok')
            status.setMessage('Got results from query.')
        resultObject = XSD.Dbobject()
        for obj in result:
            exec('object = XSD.%s()' % dbobjecttype)
            for element in obj.keys():
                exec('object.set%s("%s")' % (element,obj[element]))
            exec('resultObject.add%s(object)' % objecttype)

        return resultObject

# Capitalizes the first letter of a string, leaving the rest untouched
def capitalizeFirstLetter(_ostr):
    return (_ostr[0].capitalize() + _ostr[1:])

# Converts the date from the User Office database to the ISPyB format
def dateUO2ISPyB(date):
    MONTHS={'JAN':'01','FEB':'02','MAR':'03','APR':'04','MAY':'05','JUN':'06',\
        'JUL':'07','AUG':'08','SEP':'09','OCT':'10','NOV':'11','DEC':'12'}
    date_list=date.split('-')
    day=date_list[0]
    month=MONTHS[date_list[1]]
    year=date_list[2]
    return "%s-%s-%s 00:00:00" % (year,month,day)

# Given a proposal code, returns the correct code to use in the GUI, or what to send
# to LDAP, user office database, or the ISPyB database
translations={}
def translate(code,what):
    try:
        translated=translations[code][what]
    except KeyError:
        translated=code
    return translated

# XML configuration file parser
class XMLConfigurationHandler(ContentHandler):
    def __init__(self):
        ContentHandler.__init__(self)

        self.port = None
        self.uohost = None
        self.uoport = None
        self.dbhost = None
        self.dbuser = None
        self.dbpass = None
        self.db     = None
        self.translations = {}
        self.code  = None
        self.ldap  = None
        self.ispyb = None
        self.uo    = None
        self.gui   = None

    def startElement(self, name, attrs):
        self.addport = name == "port"
        self.adduohost = name == "uohost"
        self.adduoport = name == "uoport"
        self.adddbhost = name == "dbhost"
        self.adddbuser = name == "dbuser"
        self.adddbpass = name == "dbpass"
        self.adddb     = name == "db"
        self.addcode  = name == "code"
        self.addldap  = name == "ldap"
        self.addispyb = name == "ispyb"
        self.adduo    = name == "uo"
        self.addgui   = name == "gui"

    def characters(self, content):
        if self.addport:
            self.port = int(content)
        elif self.adduohost:
            self.uohost = str(content)
        elif self.adduoport:
            self.uoport = int(content)
        elif self.adddbhost:
            self.dbhost = str(content)
        elif self.adddbuser:
            self.dbuser = str(content)
        elif self.adddbpass:
            self.dbpass = str(content)
        elif self.adddb:
            self.db = str(content)
        elif self.addcode:
            self.code = str(content)
        elif self.addldap:
            self.ldap = str(content)
        elif self.addispyb:
            self.ispyb = str(content)
        elif self.adduo:
            self.uo = str(content)
        elif self.addgui:
            self.gui = str(content)

    def endElement(self, name):
        if name == "port":
            self.addport = None
        elif name == "uohost":
            self.adduohost = None
        elif name == "uoport":
            self.adduoport = None
        elif name == "dbhost":
            self.adddbhost = None
        elif name == "dbuser":
            self.adddbuser = None
        elif name == "dbpass":
            self.adddbpass = None
        elif name == "db":
            self.adddb = None
        elif name == "code":
            self.addcode = None
        elif name == "ldap":
            self.addldap = None
        elif name == "ispyb":
            self.addispyb = None
        elif name == "uo":
            self.adduo = None
        elif name == "gui":
            self.addgui = None
        elif name == "proposal":
            if self.code is not None:
                self.translations[self.code] = {}
                if self.ldap is not None:
                    self.translations[self.code]["ldap"] = self.ldap
                if self.ispyb is not None:
                    self.translations[self.code]["ispyb"] = self.ispyb
                if self.uo is not None:
                    self.translations[self.code]["uo"] = self.uo
                if self.gui is not None:
                    self.translations[self.code]["gui"] = self.gui
            self.code  = None
            self.ldap  = None
            self.ispyb = None
            self.uo    = None
            self.gui   = None

# Reads the configuration, parses it and creates a dictionary
def readConfiguration(filename):
    logging.getLogger().debug("ISPyBServer: reading configuration from %s" % filename)

    # Read configuration file
    try:
        f = open(filename)
        conf_xml = f.read()
    except IOError,diag:
        logging.getLogger().error("Error reading configuration file (%s)" % str(diag))
        try:
            f.close()
        except:
            pass
        return {}
    try:
        f.close()
    except IOError:
        pass

    handler = XMLConfigurationHandler()

    conf_dict={}
    try:
        xml.sax.parseString(conf_xml,handler)
    except TypeError,diag:
        logging.getLogger("HWR").error("Error parsing XML data: %s" % str(diag))
    else:
        if handler.port is not None:
            conf_dict["port"]=handler.port
        if handler.uohost is not None:
            conf_dict["uohost"]=handler.uohost
        if handler.uoport is not None:
            conf_dict["uoport"]=handler.uoport
        if handler.dbhost is not None:
            conf_dict["dbhost"]=handler.dbhost
        if handler.dbuser is not None:
            conf_dict["dbuser"]=handler.dbuser
        if handler.dbpass is not None:
            conf_dict["dbpass"]=handler.dbpass
        if handler.db is not None:
            conf_dict["db"]=handler.db
        conf_dict["translations"]=handler.translations

    return conf_dict

# Threaded HTTP server
class ThreadingHTTPServer(SocketServer.ThreadingTCPServer):
    pass

if __name__ == '__main__':
    import os
    import sys
    import getopt
    from logging.handlers import RotatingFileHandler

    # Prints the command-line help/usage/arguments
    def printUsage():
        print "Syntax:",sys.argv[0],"<xml configuration file> [-t] [-h] [-l logfile]"
        print "Arguments :","-t (enable threads)"
        print "           ","-h (display this help)"
        print "           ","-l logfile (filename to store the log)"

    # Configure logging
    _logger = logging.getLogger()
    _logger.setLevel(logging.DEBUG)
    _formatter = logging.Formatter('* %(asctime)s [%(levelname)s] %(message)s')
    _hdlr = logging.StreamHandler(sys.stdout)
    _hdlr.setFormatter(_formatter)
    logging.getLogger().addHandler(_hdlr)

    # Get mandatory arguments
    conf_file=None
    log_file=None
    multithreaded=False
    # Get command-line arguments
    try:
        opts, args = getopt.gnu_getopt(sys.argv[1:], "thl:")
    except getopt.GetoptError:
        printUsage()
        sys.exit(2)
    for o,a in opts:
        if o=='-t':
            multithreaded=True
        elif o=='-h':
            printUsage()
            sys.exit()
        elif o=='-l':
            log_file=a

    # Add file logging
    try:
        if log_file is not None:
            _hdlr2 = RotatingFileHandler(log_file, 'a', 4194304, 5)
            _hdlr2.setFormatter(_formatter)
            logging.getLogger().addHandler(_hdlr2)
    except:
        logging.getLogger().warning("ISPyBServer: problem setting the file logging")

    try:
        conf_file=str(args[0])
    except:
        pass
    if conf_file is None:
        printUsage()
        sys.exit()

    # Get configuration
    conf_dict=readConfiguration(conf_file)

    # Start the server
    try:
        port=conf_dict["port"]
        uohost=conf_dict["uohost"]
        uoport=conf_dict["uoport"]
        dbhost=conf_dict["dbhost"]
        dbuser=conf_dict["dbuser"]
        dbpass=conf_dict["dbpass"]
        db=conf_dict["db"]
        translations=conf_dict["translations"]
    except KeyError,diag:
        logging.getLogger().error("ISPyBServer: missing configuration (%s)" % str(diag))
    else:
        hostname=os.uname()[1]
        if multithreaded:
            logging.getLogger().debug("ISPyBServer: server running on multi-threaded mode")
            server_class=ThreadingHTTPServer
        else:
            server_class=BaseHTTPServer.HTTPServer
        handler_class=ISPyBRequestHandler
        handler_class.ispyb = ISPyB.ISPyB(dbhost,dbuser,dbpass,db)
        handler_class.hostname = hostname
        handler_class.userOffice = UserOfficeConnect.UserOfficeDb(uohost,uoport)
        handler_class.userOffice.uo_connect()
        server_address = (hostname, port)

        try:
            httpd = server_class(server_address,handler_class)
        except Exception,diag:
            logging.getLogger().error("ISPyBServer: exception while creating http server (%s)" % str(diag))
        else:
            logging.getLogger().info("ISPyBServer: running on %s:%d (pid=%d)" % (hostname,port,os.getpid()))
            httpd.serve_forever()
