#!/usr/bin/env/python
"""
  This module runs a http server which is capable of receiving xml documents to communicate with a database.
"""

import BaseHTTPServer
import pyxie, threading, string, os
import dna_httplib
import XSD
import ISPyBDb
import LogMessage

class DatabaseServerRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):

    _dbhandler = None
    _dbstatus = None
    _dbclass = None

    def do_POST(self):
        #
        # Get incoming XML document
        #
        db_status = XSD.Status()
        db_status.setCode("alright then")
        response = None
        try:
            content_length_string = self.headers.getheader("Content-length")
            if content_length_string is None:
                raise "BadRequestError"

            xml_message_length = string.atoi(content_length_string)
            xml_message = self.rfile.read(xml_message_length)
            #
            # Check if the request is a dna_status_request, if yes
            # just return a dna_status
            #
            if self.path == "/db_get_proposal_request":
                proposal_request = XSD.Proposal()
                proposal_request.unmarshal(xml_message)
                xsd_response = self.db_get_proposal_request(proposal_request)
                
            else:
                xsd_response = XSD.Status()
                raise "InternalServerError"
            #
            # Everything OK so far.
            #
            self.wfile.write("HTTP/1.1 200 OK\n")

        except "InternalServerError":
            db_status.setCode("error")
            db_status.setMessage("Internal server error")
            self.wfile.write("HTTP/1.1 500 Internal Server Error\n")

        except "BadRequestError":
            db_status.setCode("error")
            db_status.setMessage("Bad request error")
            self.wfile.write("HTTP/1.1 400 Bad Request\n")

        if self.path != "/shutdown":
            server_name = self.hostname
            xml_response = xsd_response.marshal()
            self.wfile.write("Host: %s\n"%(server_name))
            self.wfile.write("Content-type: text/xml\n")
            self.wfile.write("Content-length: %d\n\n"%(len(xml_response)))
            self.wfile.write(xml_response)

    def db_get_proposal_request(self, request):
        print request.toDict()
    	dict = DatabaseServerRequestHandler.dbclass.getProposals(request.getCode(),request.getNumber())
        proposal = XSD.Proposal()
        proposal.fromDict(dict)
        print proposal.marshal()
        status_object = XSD.Status()
        status_object.setCode('ok')
        status_object.setMessage('testmessage')
        return status_object


   
class  DbHTTPServer:

    def __init__(self, hostname, port, uo_host, uo_port, dbhost,dbuser,dbpass,db, **args):
        self.hostname = hostname
        self.port = port
        self.is_shutdown = 0
        #
        # Forward references to the Database SystemRequest Handler class.
        #
        server_class=BaseHTTPServer.HTTPServer
        handler_class=DatabaseServerRequestHandler
        handler_class.dbclass = ISPyBDb.ISPyBDb(dbhost,dbuser,dbpass,db)
        handler_class.hostname = self.hostname
        server_address = (self.hostname, self.port)
        try:
            self.httpd = server_class(server_address, handler_class)
        except Exception,msg:
            log.logwrite("Database Server may be already running on %s %d:%s" %(hostname,port,msg))
            self.is_shutdown=1
        log.logwrite("Running Db Server on %s, port %d"%(hostname,port))
        while not self.is_shutdown:
            self.httpd.handle_request()

        def setDbStatus(self, newStatus):
            DatabaseServerRequestHandler.DbStatus = newStatus

        def getHttp_server_status(self):
            return DatabaseServerRequestHandler._dna_status.getHttp_server_status()

        def setHttp_server_status(self, new_http_server_status):
            DatabaseServerRequestHandler._dna_status.setHttp_server_status(new_http_server_status)

        def set_xml_response(self,xml_response):
            print "set_xml_reponse to %s" % xml_response
            DatabaseServerRequestHandler.xml_reply = xml_response

        def shutdown(self):
            log.logwrite("DbServer saying Goodbye")
            self.is_shutdown = 1

if __name__ == '__main__':
    import sys
    #print "Try to start ESRF Tcl Database server (%d) arguments- %r"%(len(sys.argv),sys.argv[1:])
    if (len(sys.argv) < 10):
        print "Server requires the following arguments: 'Database server host machine', 'Database server port number', 'User office database server host' , 'User office database server port','Pxweb database host', 'Pxweb database account name', 'Pxweb database account pwd', 'Database name', 'logfile'"
        sys.exit(0)
    #
    # Path to log file, overriding input argument with environment var
    #
    log_filename = "dbserver.log"
    if "PRODC_DBLOGFILE" in os.environ.keys():
        log_filename = os.environ["PRODC_DBLOGFILE"]
    else:
        log_filename=sys.argv[9]
    log = LogMessage.LogMessage(log_filename)
        
    dbhttpserver = DbHTTPServer(sys.argv[1], string.atoi(sys.argv[2]),sys.argv[3], string.atoi(sys.argv[4]),sys.argv[5],sys.argv[6],sys.argv[7], sys.argv[8])


