__revision__ = '$Revision: 1.3 $'

import MySQLdb
import string

class ISPyBDb:

    def __init__(self,host,user,passwd,db):
        self.db = self.Connect(host=host,user=user,passwd=passwd,db=db)
        self.cursor = self.db.cursor()
        
    def _getAttList(self,tName):
        sql = "DESCRIBE " + tName
        rs = self.doQuery(sql)
        rows = []
        types = []
        for row in range(len(rs)):
            rows.append(rs[row][0])
            types.append(rs[row][1])
        return (rows,types)
                
    def doQuery(self,querystr):
        self.cursor.execute(querystr)
        return self.cursor.fetchall()

    def _queryResultToDict(self,table,queryresult):
        __resultDict = {}
        keylist,types = self._getAttList(table)
        for result in queryresult:
            idx = 0
            for key in keylist:
                __resultDict[key] = result[idx]
                idx += 1
        return __resultDict
        
    def _doInsertQuery(self,table,keyvalues):
        fieldlist = ''
        valuelist = ''
        for key in keyvalues.keys():
            fieldlist += key + ','
            try:
                eval(proposalDict[key])+1
                valuelist += '%s,'% keyvalues[key]
            except:
                valuelist += "'%s'," % keyvalues[key]
        stmt = "INSERT into %s (%s) values (%s)" % (table,\
                fieldlist[0:len(fieldlist)-1],valuelist[0:len(valuelist) -1])
        queryResult = self.doQuery(stmt)
        try:
            insert_id = self.db.insert_id()
        except:
            insert_id = self.db._db.insert_id()
        return insert_id
    

    def Connect(self,host,user,passwd,db):
        return MySQLdb.Connect(host,user,passwd,db)
        
    def setTable(self,table,dict):
        return self._doInsertQuery(table,dict)
        
    def getTable(self,table,key,value):
        stmt = "SELECT * from %s where %s = %d" % (table,key,value)
        self.cursor.execute(stmt) 
        queryResult = self.cursor.fetchall()
        return self._queryResultToDict(table,queryResult)
        
    
    def getProposals(self,code,number):
        stmt = "SELECT * from Proposal where code = '%s' and number = %d" % \
                (code,number)
        self.cursor.execute(stmt) 
        queryResult = self.cursor.fetchall()
        return self._queryResultToDict('Proposal',queryResult)
        
    def MapProposal(self,dict):
        pass  
