#!/usr/bin/env/python
"""
  This module runs a http server which is capable of receiving xml documents to communicate with a database.
"""

import sys
sys.path.append('../../xsd/python')
import BaseHTTPServer
import pyxie, threading, string, os
import dna_httplib
import XSD
import PXWeb
import LogMessage
import pprint

class DatabaseServerRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):

    _dbhandler = None
    _dbstatus = None
    _dbclass = None

    def do_POST(self):
        #
        # Get incoming XML document
        #
        db_status = XSD.Status()
        db_status.setCode('ok')
        response = None
        try:
            content_length_string = self.headers.getheader("Content-length")
            if content_length_string is None:
                raise "BadRequestError"

            xml_message_length = string.atoi(content_length_string)
            xml_message = self.rfile.read(xml_message_length)
            #
            # Check if the request is a dna_status_request, if yes
            # just return a dna_status
            #
            if self.path == "/proposal_request":
                proposal_request = XSD.Proposal()
                proposal_request.unmarshal(xml_message)
                xsd_response = self.db_get_proposal_request(proposal_request)
                
            elif self.path == "/loaded_samples_request":
                request = XSD.Loaded_samples_request()
                request.unmarshal(xml_message)
                xsd_response = self.db_get_loaded_samples_request(request)
                
            else:
                xsd_response = XSD.Status()
                raise "InternalServerError"
            #
            # Everything OK so far.
            #
            self.wfile.write("HTTP/1.1 200 OK\n")

        except "InternalServerError":
            db_status.setCode("error")
            db_status.setMessage("Internal server error")
            self.wfile.write("HTTP/1.1 500 Internal Server Error\n")

        except "BadRequestError":
            db_status.setCode("error")
            db_status.setMessage("Bad request error")
            self.wfile.write("HTTP/1.1 400 Bad Request\n")

        if self.path != "/shutdown":
            server_name = self.hostname
            xml_response = xsd_response.marshal()
            self.wfile.write("Host: %s\n"%(server_name))
            self.wfile.write("Content-type: text/xml\n")
            self.wfile.write("Content-length: %d\n\n"%(len(xml_response)))
            self.wfile.write(xml_response)

    def get_loaded_samples_request(self,request):
        print request.toDict()
    	dict = DatabaseServerRequestHandler.dbclass.getLoadedSamples(request.getHolder_id(),request.getProposal().getProposalid())
        print dict
        
    def db_get_proposal_request(self, request):
        print request.toDict()
    	dict = DatabaseServerRequestHandler.dbclass.getProposals(request.getCode(),request.getNumber())[0]
        print dict
        proposal_response = XSD.Proposal_response()
        proposal = XSD.Proposal()
        proposal.setProposalid(dict["PROPOSAL_KEY"])
        proposal.setPersonid(0)
        proposal.setTitle(dict["PROPOS_TIT"])
        proposal.setCode(dict["PROPOSAL_CODE"])
        proposal.setNumber(dict["PROPOSAL_NUMBER"])
        print proposal.marshal()

        session_dict_list = DatabaseServerRequestHandler.dbclass.getTable('SESSION', 'PROPOSAL_KEY', dict["PROPOSAL_KEY"])
        for session_dict in session_dict_list:
            session = XSD.Session()
            session.setSessionid(session_dict['SESSIONNO'])
            session.setBeamlinesetupid(0)
            session.setProposalid(session_dict['PROPOSAL_KEY'])
            session.setProjectcode('')
            session.setStartdate(session_dict['DATE_DEB'])
            session.setEnddate(session_dict['DATE_FIN'])
            session.setBeamlinename(session_dict['INSTR_NOM'])
            session.setScheduled(session_dict['SCHEDULED'])
            session.setNbshifts(session_dict['NO_SHIFTS'])
            session.setComments(session_dict['COMMENT'])
            proposal_response.addSession(session)
        
        status = XSD.Status()
        status.setCode('ok')
        status.setMessage('testmessage')
        proposal_response.setStatus(status)
        proposal_response.setProposal(proposal)
        pprint.pprint(proposal_response.toDict())
        return proposal_response 

    def db_get_loaded_samples_request(self,request):
        print "Loaded_sample_request: %s " % request.toDict()
    	sampleList = DatabaseServerRequestHandler.dbclass.get_loaded_samples_request(\
            request.getProposal().getProposalid(),request.getSample_reference())
        response = XSD.Loaded_samples_response()
        for sample in sampleList:
            print sample
            print sample.keys()
            loaded_sample = XSD.Loaded_sample()

            protein = XSD.Protein()
            protein.setProteinid(sample['protein_key'])
            name = string.replace(sample['protein_name'], '\r\n', '')
            protein.setName(name)
            protein.setAcronym(sample['protein_acronym'])
            protein.setProposalid(sample['proposal_key'])

            crystal = XSD.Crystal()
            crystal.setCrystalid(sample['crystal_key'])
            crystal.setProteinid(sample['protein_key'])
            space_group = sample['space_group']
            if space_group == '\r\n':
                crystal.setSpacegroup("None")
            else:
                crystal.setSpacegroup(space_group)
            crystal.setCell_a(sample['cell_dim_a'])
            crystal.setCell_b(sample['cell_dim_b'])
            crystal.setCell_c(sample['cell_dim_c'])
            crystal.setCell_alpha(sample['cell_dim_al'])
            crystal.setCell_beta(sample['cell_dim_be'])
            crystal.setCell_gamma(sample['cell_dim_ga'])
            crystal.setComments(sample['comments'])
            crystal.setCrystaluuid(sample['uniquecrystalid'])

            blsample = XSD.Blsample()
            blsample.setBlsampleid(sample['sample_key'])
            blsample.setCrystalid(sample['crystal_key'])
            blsample.setName(sample['blsample_name'])
            blsample.setCode(sample['holder_id'])

            sample_reference = XSD.Sample_reference()
	    sample_reference.setCode(sample['holder_id'])

            diffractionPlan = XSD.Diffractionplan()
            diffractionPlan.setMinimalresolution(sample['res_req'])
            diffractionPlan.setExposuretime(sample['exposure'])
            diffractionPlan.setOscillationrange(sample['osc_range'])

            loaded_sample.setProtein(protein)
            loaded_sample.setCrystal(crystal)
            loaded_sample.setBlsample(blsample)
            loaded_sample.setDiffractionplan(diffractionPlan)
	    loaded_sample.setSample_reference(sample_reference)
            
            response.addLoaded_sample(loaded_sample)
	status = XSD.Status()
	status.setCode('ok')
	response.setStatus(status)
        pprint.pprint(response.toDict())
        return response
   
class  DbHTTPServer:

    def __init__(self, hostname, port, uo_host, uo_port, dbhost,dbuser,dbpass,db, **args):
        self.hostname = hostname
        self.port = port
        self.is_shutdown = 0
        #
        # Forward references to the Database SystemRequest Handler class.
        #
        server_class=BaseHTTPServer.HTTPServer
        handler_class=DatabaseServerRequestHandler
        handler_class.dbclass = PXWeb.PXWeb(dbhost,dbuser,dbpass,db)
        handler_class.hostname = self.hostname
        server_address = (self.hostname, self.port)
        try:
            self.httpd = server_class(server_address, handler_class)
        except Exception,msg:
            log.logwrite("Database Server may be already running on %s %d:%s" %(hostname,port,msg))
            self.is_shutdown=1
        log.logwrite("Running Db Server on %s, port %d"%(hostname,port))
        while not self.is_shutdown:
            self.httpd.handle_request()

        def setDbStatus(self, newStatus):
            DatabaseServerRequestHandler.DbStatus = newStatus

        def getHttp_server_status(self):
            return DatabaseServerRequestHandler._dna_status.getHttp_server_status()

        def setHttp_server_status(self, new_http_server_status):
            DatabaseServerRequestHandler._dna_status.setHttp_server_status(new_http_server_status)

        def set_xml_response(self,xml_response):
            print "set_xml_reponse to %s" % xml_response
            DatabaseServerRequestHandler.xml_reply = xml_response

        def shutdown(self):
            log.logwrite("DbServer saying Goodbye")
            self.is_shutdown = 1

if __name__ == '__main__':
    import sys
    #print "Try to start ESRF Tcl Database server (%d) arguments- %r"%(len(sys.argv),sys.argv[1:])
    if (len(sys.argv) < 10):
        print "Server requires the following arguments: 'Database server host machine', 'Database server port number', 'User office database server host' , 'User office database server port','Pxweb database host', 'Pxweb database account name', 'Pxweb database account pwd', 'Database name', 'logfile'"
        sys.exit(0)
    #
    # Path to log file, overriding input argument with environment var
    #
    log_filename = "dbserver.log"
    if "PRODC_DBLOGFILE" in os.environ.keys():
        log_filename = os.environ["PRODC_DBLOGFILE"]
    else:
        log_filename=sys.argv[9]
    log = LogMessage.LogMessage(log_filename)
        
    dbhttpserver = DbHTTPServer(sys.argv[1], string.atoi(sys.argv[2]),sys.argv[3], string.atoi(sys.argv[4]),sys.argv[5],sys.argv[6],sys.argv[7], sys.argv[8])


