#!/usr/bin/env/python
"""
This module is simulating database requests for developping purposes.
"""

import sys
sys.path.append('../../xsd/python')
import BaseHTTPServer
import pyxie, threading, string, os
import dna_httplib
import XSD
import PXWeb
import LogMessage
import pprint

class DatabaseServerRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):

    _dbhandler = None
    _dbstatus = None
    _dbclass = None

    def do_POST(self):
        #
        # Get incoming XML document
        #
        db_status = XSD.Status()
        db_status.setCode('ok')
        response = None
        try:
            content_length_string = self.headers.getheader("Content-length")
            if content_length_string is None:
                raise "BadRequestError"

            xml_message_length = string.atoi(content_length_string)
            xml_message = self.rfile.read(xml_message_length)
            #
            # Check if the request is a dna_status_request, if yes
            # just return a dna_status
            #
            if self.path == "/proposal_request":
                proposal_request = XSD.Proposal()
                proposal_request.unmarshal(xml_message)
                xsd_response = self.db_get_proposal_request(proposal_request)
                
            elif self.path == "/loaded_samples_request":
                request = XSD.Loaded_samples_request()
                request.unmarshal(xml_message)
                xsd_response = self.db_get_loaded_samples_request(request)
                
            else:
                xsd_response = XSD.Status()
                raise "InternalServerError"
            #
            # Everything OK so far.
            #
            self.wfile.write("HTTP/1.1 200 OK\n")

        except "InternalServerError":
            db_status.setCode("error")
            db_status.setMessage("Internal server error")
            self.wfile.write("HTTP/1.1 500 Internal Server Error\n")

        except "BadRequestError":
            db_status.setCode("error")
            db_status.setMessage("Bad request error")
            self.wfile.write("HTTP/1.1 400 Bad Request\n")

        if self.path != "/shutdown":
            server_name = self.hostname
            xml_response = xsd_response.marshal()
            self.wfile.write("Host: %s\n"%(server_name))
            self.wfile.write("Content-type: text/xml\n")
            self.wfile.write("Content-length: %d\n\n"%(len(xml_response)))
            self.wfile.write(xml_response)


    def db_get_proposal_request(self, request):
        print request.toDict()
    	dict = DatabaseServerRequestHandler.dbclass.getProposals(request.getCode(),request.getNumber())[0]
        print dict
        proposal_response = XSD.Proposal_response()
        proposal_response_xml = """<?xml version="1.0"?>
<proposal_response>
  <status>
    <code>ok</code>
  </status>
  <Proposal>
    <proposalId>10168</proposalId>
    <personId>0</personId>
    <title>TEST</title>
    <code>MX</code>
    <number>415</number>
  </Proposal>
  <Session>
    <sessionId>22505</sessionId>
    <beamLineSetupId>0</beamLineSetupId>
    <proposalId>10168</proposalId>
    <startDate>2004-12-09</startDate>
    <endDate>2004-12-10</endDate>
    <beamLineName>ID14 3</beamLineName>
    <scheduled>1</scheduled>
    <nbShifts>3</nbShifts>
  </Session>
  <Session>
    <sessionId>22680</sessionId>
    <beamLineSetupId>0</beamLineSetupId>
    <proposalId>10168</proposalId>
    <startDate>2005-02-09</startDate>
    <endDate>2005-02-09</endDate>
    <beamLineName>ID14-3</beamLineName>
    <scheduled>1</scheduled>
    <nbShifts>1</nbShifts>
    <comments>pipeline</comments>
  </Session>
  <Session>
    <sessionId>22682</sessionId>
    <beamLineSetupId>0</beamLineSetupId>
    <proposalId>10168</proposalId>
    <startDate>2005-02-10</startDate>
    <endDate>2005-02-10</endDate>
    <beamLineName>ID14-3</beamLineName>
    <scheduled>1</scheduled>
    <nbShifts>1</nbShifts>
    <comments>pipeline</comments>
  </Session>
</proposal_response>"""
        proposal_response.unmarshal(proposal_response_xml)
        return proposal_response 


    def db_get_loaded_samples_request(self,request):
        loaded_samples_response = XSD.Loaded_samples_response()
        loaded_samples_response_xml = """<?xml version="1.0"?>
<loaded_samples_response>
  <status>
    <code>ok</code>
  </status>
  <loaded_sample>
    <sample_reference>
      <code>C18B9663</code>
    </sample_reference>
    <Protein>
      <proteinId>363</proteinId>
      <name>Lysozyme Egg 50mg/ml</name>
      <proposalid>10168</proposalid>
    </Protein>
    <Crystal>
      <crystalId>432</crystalId>
      <proteinId>363</proteinId>
      <spaceGroup>P2</spaceGroup>
      <cell_a>0.000000</cell_a>
      <cell_b>0.000000</cell_b>
      <cell_c>0.000000</cell_c>
      <cell_alpha>0.000000</cell_alpha>
      <cell_beta>0.000000</cell_beta>
      <cell_gamma>0.000000</cell_gamma>
    </Crystal>
    <BLSample>
      <blSampleId>2725</blSampleId>
      <crystalId>432</crystalId>
      <name>lystest1</name>
      <code>C18B9663</code>
    </BLSample>
    <DiffractionPlan>
    </DiffractionPlan>
  </loaded_sample>
  <loaded_sample>
    <sample_reference>
      <code>C18B9688</code>
    </sample_reference>
    <Protein>
      <proteinId>361</proteinId>
      <name>Maltooligosyltrehalose trehalohydrolase</name>
      <proposalid>10168</proposalid>
    </Protein>
    <Crystal>
      <crystalId>430</crystalId>
      <proteinId>361</proteinId>
      <spaceGroup>P2</spaceGroup>
      <cell_a>0.000000</cell_a>
      <cell_b>0.000000</cell_b>
      <cell_c>0.000000</cell_c>
      <cell_alpha>0.000000</cell_alpha>
      <cell_beta>0.000000</cell_beta>
      <cell_gamma>0.000000</cell_gamma>
    </Crystal>
    <BLSample>
      <blSampleId>2726</blSampleId>
      <crystalId>430</crystalId>
      <name>darren</name>
      <code>C18B9688</code>
    </BLSample>
    <DiffractionPlan>
    </DiffractionPlan>
  </loaded_sample>
  <loaded_sample>
    <sample_reference>
      <code>C18B9615</code>
    </sample_reference>
    <Protein>
      <proteinId>361</proteinId>
      <name>Maltooligosyltrehalose trehalohydrolase</name>
      <proposalid>10168</proposalid>
    </Protein>
    <Crystal>
      <crystalId>429</crystalId>
      <proteinId>361</proteinId>
      <spaceGroup>P2</spaceGroup>
      <cell_a>0.000000</cell_a>
      <cell_b>0.000000</cell_b>
      <cell_c>0.000000</cell_c>
      <cell_alpha>0.000000</cell_alpha>
      <cell_beta>0.000000</cell_beta>
      <cell_gamma>0.000000</cell_gamma>
    </Crystal>
    <BLSample>
      <blSampleId>2728</blSampleId>
      <crystalId>429</crystalId>
      <name>olof</name>
      <code>C18B9615</code>
    </BLSample>
    <DiffractionPlan>
    </DiffractionPlan>
  </loaded_sample>
</loaded_samples_response>"""
        loaded_samples_response.unmarshal(loaded_samples_response_xml)
        return loaded_samples_response
   

class  DbHTTPServer:

    def __init__(self, hostname, port, uo_host, uo_port, dbhost,dbuser,dbpass,db, **args):
        self.hostname = hostname
        self.port = port
        self.is_shutdown = 0
        #
        # Forward references to the Database SystemRequest Handler class.
        #
        server_class=BaseHTTPServer.HTTPServer
        handler_class=DatabaseServerRequestHandler
        handler_class.dbclass = PXWeb.PXWeb(dbhost,dbuser,dbpass,db)
        handler_class.hostname = self.hostname
        server_address = (self.hostname, self.port)
        try:
            self.httpd = server_class(server_address, handler_class)
        except Exception,msg:
            log.logwrite("Database Server may be already running on %s %d:%s" %(hostname,port,msg))
            self.is_shutdown=1
        log.logwrite("Running Db Server on %s, port %d"%(hostname,port))
        while not self.is_shutdown:
            self.httpd.handle_request()

        def setDbStatus(self, newStatus):
            DatabaseServerRequestHandler.DbStatus = newStatus

        def getHttp_server_status(self):
            return DatabaseServerRequestHandler._dna_status.getHttp_server_status()

        def setHttp_server_status(self, new_http_server_status):
            DatabaseServerRequestHandler._dna_status.setHttp_server_status(new_http_server_status)

        def set_xml_response(self,xml_response):
            print "set_xml_reponse to %s" % xml_response
            DatabaseServerRequestHandler.xml_reply = xml_response

        def shutdown(self):
            log.logwrite("DbServer saying Goodbye")
            self.is_shutdown = 1

if __name__ == '__main__':
    import sys
    #print "Try to start ESRF Tcl Database server (%d) arguments- %r"%(len(sys.argv),sys.argv[1:])
    if (len(sys.argv) < 10):
        print "Server requires the following arguments: 'Database server host machine', 'Database server port number', 'User office database server host' , 'User office database server port','Pxweb database host', 'Pxweb database account name', 'Pxweb database account pwd', 'Database name', 'logfile'"
        sys.exit(0)
    #
    # Path to log file, overriding input argument with environment var
    #
    log_filename = "dbserver.log"
    if "PRODC_DBLOGFILE" in os.environ.keys():
        log_filename = os.environ["PRODC_DBLOGFILE"]
    else:
        log_filename=sys.argv[9]
    log = LogMessage.LogMessage(log_filename)
        
    dbhttpserver = DbHTTPServer(sys.argv[1], string.atoi(sys.argv[2]),sys.argv[3], string.atoi(sys.argv[4]),sys.argv[5],sys.argv[6],sys.argv[7], sys.argv[8])


