# phpMyAdmin MySQL-Dump
# version 2.3.2
# http://www.phpmyadmin.net/ (download page)
#
# Host: localhost
# Generation Time: Oct 08, 2003 at 10:28 AM
# Server version: 3.23.37
# PHP Version: 4.0.6
# Database : `PxWebDb`
# --------------------------------------------------------

#
# Table structure for table `CRYSTAL`
#

CREATE TABLE CRYSTAL (
  CRYSTAL_KEY int(11) NOT NULL auto_increment,
  PROTEIN_KEY int(11) NOT NULL default '0',
  SPACE_GROUP varchar(10) default NULL,
  CELL_DIM_A decimal(4,2) default '0.00',
  CELL_DIM_B decimal(4,2) default '0.00',
  CELL_DIM_C decimal(4,2) default '0.00',
  CELL_DIM_AL decimal(4,2) default '0.00',
  CELL_DIM_BE decimal(4,2) default '0.00',
  CELL_DIM_GA decimal(4,2) default '0.00',
  RES_PREV float(10,2) default '0.00',
  COMMENTS text,
  EDITABLE char(1) binary NOT NULL default 'N',
  PRIMARY KEY  (CRYSTAL_KEY),
  KEY CRYSTAL_KEY1 (CRYSTAL_KEY)
) TYPE=ISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `DETECTORS`
#

CREATE TABLE DETECTORS (
  DETECTORID int(11) NOT NULL auto_increment,
  IMGTYPE varchar(50) default NULL,
  NHEAD int(11) NOT NULL default '0',
  LRECL int(11) NOT NULL default '0',
  NPIXELX int(11) NOT NULL default '0',
  NPIXELY int(11) NOT NULL default '0',
  IMGDRC varchar(50) default NULL,
  ENDED varchar(6) default NULL,
  YPXMAX double(16,4) NOT NULL default '0.0000',
  ZPXMAX double(16,4) NOT NULL default '0.0000',
  YBEAM double(16,4) NOT NULL default '0.0000',
  ZBEAM double(16,4) NOT NULL default '0.0000',
  YPXSIZ double(16,4) NOT NULL default '0.0000',
  ZPXSIZ double(16,4) NOT NULL default '0.0000',
  ROFF double(16,4) NOT NULL default '0.0000',
  TOFF double(16,4) NOT NULL default '0.0000',
  NUMBITS int(11) NOT NULL default '0',
  DESCRIPTION varchar(50) default NULL,
  SPDFIL varchar(255) default NULL,
  PRIMARY KEY  (DETECTORID),
  KEY DETECTORID (DETECTORID),
  KEY NUMBITS (NUMBITS)
) TYPE=ISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `DEWAR`
#

CREATE TABLE DEWAR (
  DEWAR_KEY smallint(6) NOT NULL auto_increment,
  PROPOSAL_KEY int(11) NOT NULL default '0',
  CREATED_ON date NOT NULL default '0000-00-00',
  SENT_ON date NOT NULL default '0000-00-00',
  COURIER_CO varchar(10) NOT NULL default '',
  SENDING_NB varchar(10) default NULL,
  COMMENTS varchar(200) default NULL,
  SUB_STATUS enum('opened','closed') NOT NULL default 'opened',
  STORAGE varchar(40) default NULL,
  PRIMARY KEY  (DEWAR_KEY),
  KEY DEWARE_KEY (DEWAR_KEY)
) TYPE=ISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `DICTIONARY`
#

CREATE TABLE DICTIONARY (
  PARAMID int(11) NOT NULL auto_increment,
  PARAMBRIEF varchar(50) default NULL,
  PARAMDESC varchar(255) default NULL,
  PARAMFORMAT varchar(50) default NULL,
  PARAMELEMENTS int(11) NOT NULL default '0',
  PARAMTYPE int(11) NOT NULL default '0',
  PARAMINST int(11) default NULL,
  PRIMARY KEY  (PARAMID),
  KEY PARAMID (PARAMID)
) TYPE=ISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `DICTIOS`
#

CREATE TABLE DICTIOS (
  PARAMESID int(11) NOT NULL auto_increment,
  PARAMES varchar(50) NOT NULL default '',
  PARAMESDESC varchar(100) default NULL,
  PARAMESTYPE varchar(10) default NULL,
  PRIMARY KEY  (PARAMESID)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `IMAGES`
#

CREATE TABLE IMAGES (
  IMAGEID int(11) NOT NULL auto_increment,
  RUNUNIQUEID int(11) NOT NULL default '0',
  TYPE int(11) NOT NULL default '0',
  FILENAME varchar(50) default NULL,
  LOCATION varchar(60) default NULL,
  PRIMARY KEY  (IMAGEID),
  KEY IMAGEID (IMAGEID),
  KEY RUNUNIQUEID (RUNUNIQUEID)
) TYPE=MyISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `MAD`
#

CREATE TABLE MAD (
  MAD_ID int(11) NOT NULL auto_increment,
  RUNUNIQUEID int(11) NOT NULL default '0',
  ESCAN_FILE varchar(100) default NULL,
  PRIMARY KEY  (MAD_ID),
  KEY MAD_ID (MAD_ID)
) TYPE=ISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `PARAMETERTOES`
#

CREATE TABLE PARAMETERTOES (
  PARAMES_KEY int(11) NOT NULL auto_increment,
  PROCESS_KEY int(11) NOT NULL default '0',
  PARAMESID tinyint(4) NOT NULL default '0',
  PARAMESTEXT varchar(20) default NULL,
  PRIMARY KEY  (PARAMES_KEY)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `PARAMETERTOIMAGE`
#

CREATE TABLE PARAMETERTOIMAGE (
  PARAMRUNID int(11) NOT NULL auto_increment,
  IMAGEID int(11) NOT NULL default '0',
  PARAMID int(11) NOT NULL default '0',
  PARAMVALUE float(10,2) NOT NULL default '0.00',
  PARAMTEXT varchar(50) default NULL,
  PRIMARY KEY  (PARAMRUNID),
  KEY IMAGEID (IMAGEID),
  KEY PARAMID (PARAMID),
  KEY PARAMRUNID (PARAMRUNID)
) TYPE=ISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `PARAMETERTORUN`
#

CREATE TABLE PARAMETERTORUN (
  PARAMRUNID int(11) NOT NULL auto_increment,
  RUNUNIQUEID int(11) NOT NULL default '0',
  PARAMID int(11) NOT NULL default '0',
  PARAMVALUE float(10,2) NOT NULL default '0.00',
  PARAMTEXT varchar(200) NOT NULL default 'None',
  PRIMARY KEY  (PARAMRUNID),
  KEY PARAMID (PARAMID),
  KEY PARAMRUNID (PARAMRUNID),
  KEY RUNUNIQUEID (RUNUNIQUEID)
) TYPE=MyISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `PROCESS`
#

CREATE TABLE PROCESS (
  PROCESS_KEY int(11) NOT NULL default '0',
  PROPOSAL_KEY int(11) default NULL,
  SESSIONNO int(11) default NULL,
  RUNUNIQUEID int(11) default NULL,
  PROC_START date default NULL,
  PRIMARY KEY  (PROCESS_KEY)
) TYPE=MyISAM;
# --------------------------------------------------------

#
# Table structure for table `PROPOSAL`
#

CREATE TABLE PROPOSAL (
  PROPOSAL_KEY int(11) NOT NULL auto_increment,
  PROPOSAL_UO_REF int(11) NOT NULL default '0',
  PROPOSAL_CODE varchar(6) NOT NULL default '',
  PROPOSAL_NUMBER int(11) NOT NULL default '0',
  PROPOSID varchar(10) default NULL,
  SURNAME varchar(45) NOT NULL default '',
  LABO_NAME varchar(45) NOT NULL default '',
  LABO_PAYS_CODE varchar(4) default NULL,
  PROPOS_TIT varchar(180) default NULL,
  PRIMARY KEY  (PROPOSAL_KEY),
  KEY PROPOS_NO (PROPOSAL_UO_REF),
  KEY SESSION_NO (PROPOSAL_KEY)
) TYPE=ISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `PROTEIN`
#

CREATE TABLE PROTEIN (
  PROTEIN_KEY int(6) NOT NULL auto_increment,
  PROTEIN_NAME text,
  PROTEIN_ID varchar(20) NOT NULL default '',
  PROPOSAL_KEY int(11) NOT NULL default '0',
  SAMPLE_UO_REF int(11) default NULL,
  PRIMARY KEY  (PROTEIN_KEY),
  KEY CRYSTALID (PROTEIN_ID)
) TYPE=ISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `RUNS`
#

CREATE TABLE RUNS (
  RUNUNIQUEID int(11) NOT NULL auto_increment,
  SESSIONNO int(11) NOT NULL default '0',
  RUNIDENTIFIER int(11) NOT NULL default '0',
  RUNSTART datetime default NULL,
  RUNEND datetime default NULL,
  RUNSTATUS int(11) NOT NULL default '0',
  TYPEID int(11) default NULL,
  PRIMARY KEY  (RUNUNIQUEID),
  KEY RUNUNIQUEID (RUNUNIQUEID),
  KEY SESSIONNO (SESSIONNO)
) TYPE=MyISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `RUNTYPES`
#

CREATE TABLE RUNTYPES (
  TYPEID int(11) NOT NULL auto_increment,
  RUNTYPE varchar(50) default NULL,
  RUNDESCRIPTION varchar(50) default NULL,
  PRODC int(11) default NULL,
  PRIMARY KEY  (TYPEID),
  KEY TYPEID (TYPEID)
) TYPE=ISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `SAMPLE`
#

CREATE TABLE SAMPLE (
  SAMPLE_KEY int(11) NOT NULL auto_increment,
  DEWAR_KEY int(11) NOT NULL default '0',
  CRYSTAL_KEY int(11) NOT NULL default '0',
  SUFFIX varchar(20) NOT NULL default '',
  DATA_SET enum('native','ligand','mutant','MAD','SAD','MIR') NOT NULL default 'native',
  CRYSTAL_SIZE varchar(20) default NULL,
  RSYM float(10,2) default NULL,
  STRUC_STATUS enum('Completed','Under refinement','Solved','Initial measurements','More phasing needed','Poor data') NOT NULL default 'Initial measurements',
  PUBLI_STATUS enum('Not applicable','In preparation','Submitted','In press','Published') NOT NULL default 'Not applicable',
  BAG_COMMENT varchar(200) default NULL,
  CANE char(3) NOT NULL default '',
  POSITION char(1) NOT NULL default '',
  RESO_REQ float(10,2) default NULL,
  REMARKS varchar(80) default NULL,
  CREAT_DATE date default NULL,
  SAF_FORM enum('yes','no') NOT NULL default 'no',
  EXP_STATUS varchar(10) default NULL,
  LOOP_LENGTH float default NULL,
  PRIMARY KEY  (SAMPLE_KEY)
) TYPE=ISAM PACK_KEYS=1;
# --------------------------------------------------------

#
# Table structure for table `SESSION`
#

CREATE TABLE SESSION (
  SESSIONNO int(11) NOT NULL auto_increment,
  USER_NO int(11) NOT NULL default '0',
  PROPOSAL_KEY int(11) NOT NULL default '0',
  SCHEDULED tinyint(4) NOT NULL default '1',
  LOCAL_CONTACT varchar(20) default NULL,
  DATE_DEB date default NULL,
  DATE_FIN date default NULL,
  NO_SHIFTS smallint(4) NOT NULL default '0',
  INSTR_NOM varchar(16) default NULL,
  EXP_OPERATOR varchar(40) default NULL,
  NO_PERF_SHIFTS float(10,2) NOT NULL default '0.00',
  COMMENT varchar(255) default NULL,
  BLOM_COMMENT varchar(200) default NULL,
  LC_COMMENT varchar(200) default NULL,
  PRIMARY KEY  (SESSIONNO),
  KEY SESSIONNO (SESSIONNO)
) TYPE=ISAM PACK_KEYS=1;

    
