/* get_fitting2(): This routine takes a list of projections, bins them and   *
 *		  does a FFT on the bins. After calculating the absolute    *
 *		  value of the complex result, the highest value between    *
 *		  the first minimum after 0 and a value corresponding to    *
 *		  maximum expected cell edge length is searched. The heights*
 *		  of this peak and the corresponding d_spacing value is	    *
 *		  returned.						    */

/****************  dummy routine to output the chosen fouriers **************/

void get_fitting2(float grid, float stretch, struct vector xyz[], int number_xyz, float d_max, 
		  struct vector *n_vector, float proj[], float *d_experiment, float *n_fit, int debug)

{
  int i;		    /* Counter */
  float extent;	    /* The range covered by the projections (max-min) */
  float shift;	    /* The shift necessary to bring the min value to zero */
  int max;		    /* Number of bins needed */
  float exp;		    /* Exponent calcualted from max (log2(max))*/
  int max_int;	    /* New max value calculated from the rounded exponent */
  static int last_exp = 0;/* Exponent in the last call of get_fitting (static!!) */
  static float fft_help[65568]; /* Help array for storing arithm. tables etc for the FFT.
				   Also static, because this array needs only to be changed 
				   if max_int changes. */
  static float data[65568];	    /*  Array for holding the binned data.
					Also static because the size only 
					changes if max_int changes. */	
  float step;		    /* Stepsize from bin to bin */
  float fit;		    /* Heights of the highest peak in the FFT and temporary
			       variable during calculation. */
  float d_exp;	    /* Corresponding d-spacing for fit. */
  float mean_fft,sd_fft;
  int  harrydum;
  static int harryname;
  char charryname[] = "fft.out";
  char pharryname[] = "proj.out";
  char cincrement[5];   /*filename for putting the FFTs in...*/
  FILE     *fftout,
    *projout,
    *binout;     	    /* Files for debugging output */
  int itemp;
  harryname++;
  harrydum = harryname;
  cincrement[4] = '\0';
  if(harrydum >= 1000) {
    cincrement[0] = (harrydum/1000)+48;
    harrydum = harrydum - (1000*(harrydum/1000));
  }
  else {
    cincrement[0] = '0';
  }
  if(harrydum >= 100) {
    cincrement[1] = (harrydum/100)+48;
    harrydum = harrydum - (100*(harrydum/100));
  }
  else {
    cincrement[1] = '0';
  }
  if(harrydum >= 10) {
    cincrement[2] = (harrydum/10)+48;
    harrydum = harrydum - (10*(harrydum/10));
  }
  else {
    cincrement[2] = '0';
  }
  if(harrydum >= 0) {
    cincrement[3] = (harrydum)+48;
  }
  else {
    cincrement[3] = '0';
  }
  strcat(charryname,cincrement);
  strcat(pharryname,cincrement);
  debug=1;
  if(debug != 0 && harryname <= 30) {
    fftout = fopen(charryname,"w");
    projout = fopen(pharryname,"w");
    binout = fopen("bin.out","w");
  }
  debug = 0;
    	
  /* First we have to bin the data. Therefore we have to know the maximum
     and minimum values of the projections. Also the projections list
     can be unsorted,  the first and last value have to correspond to the
     highest and lowest values. */
  extent=proj[0]-proj[number_xyz-1];

  /* We have to start at zero and therefore move the origin. This makes
     no difference for the FFT. */
  shift=-proj[number_xyz-1];

  /* max is the number of bins we need. This is calculated in a way to
     assure that the introduced error by binning is not too large. The 
     value of grid gives the minimum number of bins per maximum expected
     cell edge length. The value of stretch can be used to get a higher 
     resolution for the returned d-spacing. With stretch != 1,  only
     part of the array will be used for the binned data. The rest is 
     padded with zeros. In the FFT this will result in a higher resolution
     in the returned values. Empirically we found,  that values of 5 for
     grid in 1 for stretch are sufficient. */
  max=extent*d_max*grid*stretch;
  if(max>32768)max=32768;
  /* Most of the FFT routines work best with arrays of the length of the 
     power of two. Because we are binning anyway, we can modify stretch to
     match this requirement. */

  /* Calculating the logarithm on the basis 2... */
  /*  exp=truncf(logf(max)/logf(2)+1); */
  /*	exp = log(max)/log(2)+1.0;
	itemp = exp;
	exp = itemp;
  */
  max_int = 1;
  exp = 0;
  while(max_int<max){
    max_int = max_int*2;
    exp++;
  }
  /* ...recalculating max after rounding exp_fract to the next higher integer... */
  /*	max_int=powf(2, (int)exp);
   */
  /* ... modifying stretch to fit the array. */
  stretch=stretch*(max_int/max);
    
  if(debug != 0) {
    printf("max %d exp %f \n", max, exp);
  }
    
  /* Using the new value for max. */
  max=max_int;
    
  if(debug != 0) {
    printf("max_int %d stretch %f\n", max_int, stretch);
  }

  /* Calculating the stepsize between two consecutive bins. This value is
     needed to calculate the bin number of a projection. */
  step=extent/((float)(max-1)/stretch);

  if(debug != 0) {
    printf("max %d step %f \n", max, step);
  }

  /* In the first call or when the length of the bin array changes, we
     have to reallocate memory for the array and initialize the FFT routine. */
  if(exp != last_exp) {
    last_exp=exp;

    /* Free the old arrays */
    /* free(fft_help);
       free(data);*/

    /* Allocate the new memory. Due to the documentation of the FFT
       routine the size of fft_help should be 2*max+15. Unfortunately, 
       this seems not to be right,  because with this value following
       malloc or free calls lead to segmentation faults. 15000 is a value 
       that works at the moment. This must be further investigated. */
    /*        fft_help=dps_malloc("get_fitting", "fft_help", (size_t)2*max+15000);
	      data=dps_malloc("get_fitting", "data", (size_t)max*sizeof(float));
    */
    /* Call the initialization for the FFT routine */
    rffti_(&max, &fft_help[0]);
  }

  /* Zero the data array */
  for(i=0;i<max;i++) {
    data[i]=0.0;
  }

  /* Go through the list of reflections and calculate the bin number; then
     increment the number in the bin by one. */
  for(i=0;i<number_xyz;i++) {
    ++data[(int)((proj[i]+shift)/step)];
  }

  if(debug != 0) {
    for(i=1;i<max;i++) {
      fprintf(binout, "%d %f\n",i, data[i]);
    }
  }
  /*harry trying to output the projection */
  debug = 1;
  if(debug != 0 && harryname <= 30) {
    for(i=1;i<(max/2)-1;i++) {
      fprintf(projout, "%d %f\n",i, data[i]);
    }
  }
  debug = 0;
  /*harry trying to output the projection */

  /* Apply the FFT */
  rfftf_(&max, &data[0], &fft_help[0]); 
  /* Calculate the absolute value of the complex numbers. The complex numbers
     are stored as:
     c_real[1], c_imag[1], c_real[2], c_imag[2].....
       
     The absolute values are finally stored the following way:
     abs[1], abs[2], ....
       
     !! We do not take the square root,  because we only want to compare the
     size of the values. This saves a lot of time!! */
  /* Harry changed next line from for(i=1;i<max;i=i+2) */
  for(i=1;i<max-1;i=i+2) {
    data[(i+1)/2]=data[i]*data[i]+data[i+1]*data[i+1];
  }

  /* We need now to find the highest maximum corresponding to cell edges 
     between 0 and the maximum expected cell edge length. We also have to 
     avoid sitting on the slope of the maximum at zero. Therefore,  we
     start at 0, move along until we find a local minimum and look
     in the area between the minimum and the maximum expected cell edge
     length for the highest peak.
  */
    
  /* output the FFT */
  debug = 1;
  if(debug != 0 && harryname <= 30) {
    for(i=1;i<(max/2)-1;i++) {
      fprintf(fftout, "%f %f\n",i/(max*step),sqrt(data[i]));
    }
  }
  debug = 0; 
  /* harry finished outputting the FFT*/
  /* First we need the value at 0 */
  fit=data[0]*data[0];
    
  /* The following loop finds the minimum, assign the value at the minimum to
     fit and sets i to  start with the next value */
  /* i=d_max*(max-1)*step*0.1; */
  /* first find the Mean value of the FFT */
  mean_fft = 0.0;
  for(i=0;i<max;i++){
    mean_fft = mean_fft + data[i];
  }
  mean_fft = mean_fft/i;
  /* then find the standard deviation */
  sd_fft = 0.0;
  for(i=0;i<max;i++){
    sd_fft = sd_fft + ((mean_fft - data[i])*(mean_fft - data[i]));
  }
  sd_fft = sqrt(sd_fft)/(i-1);
  /* these are the values for the squared FFT */
  i = 1;
  if (debug != 0) {
    printf("start at %d ",i);
  }
  while(data[i]<fit) {
    fit=data[i];
    i++;
  }
  if(debug != 0) {
    printf("minimum %d with %f\n", i-1, data[i-1]);
  }
  i++;
    
  /* This loop, running from the minimum+1 to the bin corresponding to the
     maximum cell edge length,  finds the maximum in this area. It assigns
     the maximum value to fit and stores the corresponding bin number
     in d_exp. */
  d_exp=i; /* If the bin after the minimum is already the global maximum. */
  fit=data[i];

  /*   added to avoid big origin peaks */
  while(data[i]>mean_fft*mean_fft/(sd_fft)){
    i++;
  }
  fit=data[i];
   
  while(i<d_max*(max-1)*step) {
    if(data[i]>fit) {
      fit=data[i];
      d_exp=i;
      if(debug != 0) {
	printf("%d ", i);
      }
    }
    i++;
  } 
  if(debug != 0) {
    printf("d_exp before %f ", d_exp);
  }

  /* Calculating the d_spacing from the bin number */
  d_exp=1.0/(d_exp)*(max-1)*step;
  if(debug != 0) {
    printf("file %s: max_search %f fit %f d_exp %f = 1/%f\n", cincrement,fabsf(d_max*(max-1)*step), fit, d_exp,1/d_exp);
  }
  /* Preparing the return values */
  *d_experiment=d_exp;
  *n_fit=fit;
  /* close the output files */
  if(debug != 0) {
    fclose(fftout);
    fclose(binout);
    fclose(projout);
  }
}
