/*=======================================================================
 * All files in the distribution of the DPS system are Copyright
 * 1996 by the Computational Biology group in the Department of Biological
 * Sciences at Purdue University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this entire copyright notice is duplicated in all such
 * copies, and that any documentation, announcements, and other materials
 * related to such distribution and use acknowledge that the software was
 * developed by the Computational Biology group in the Department of
 * Biological Sciences at Purdue University, W. Lafayette, IN by Ingo
 * Steller and Michael G. Rossmann. No charge may be made for copies,
 * derivations, or distributions of this material without the express
 * written consent of the copyright holder.  Neither the name of the
 * University nor the names of the authors may be used to endorse or
 * promote products derived from this material without specific prior
 * written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
 *======================================================================*/

/*=====================================================================*
 *                                                                     *
 *                         Data Processing Suit                        *
 *                                                                     *
 *                              dps_index                              *
 *                                                                     *
 *                        Written by Ingo Steller                      *
 *                                                                     *
 *                        File: ind_fortran.c                          *
 *                                                                     *
 *=====================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "util.h"
#include "index_def.h"
#include "ind_gen_direct.h"

/* index_fortran_(): This routine is the call for the indexing from a	*
 *		    FORTRAN program.					*/

void index_fortran_(int *number_xyz, float *x,  float *y, float *z, float *d_max, 
int *index_mode, float *a, int *ierrflg )

{
	int i,dpserrflg;                          /* Counter */
	struct vector xyz[N_XYZ];       /* Array for reciprocal space coordinates 
	                                       in a selected resolution range*/
	struct matrix_3x3 om;           /* Generated orientation matrices */
	/* Make a list of type vector from the coordinates x,y,z. */
	for(i=0;i<(*number_xyz);i++) {
		xyz[i].x=x[i];
		xyz[i].y=y[i];
		xyz[i].z=z[i];
	}
	if (*ierrflg > 0)
		print_vector_list( *number_xyz, xyz);
	dpserrflg = do_index(*number_xyz, xyz, *d_max, *index_mode, &om);
	*ierrflg = dpserrflg;
	a[0] = om.r[0].x;
	a[1] = om.r[0].y;
	a[2] = om.r[0].z;
	a[3] = om.r[1].x;
	a[4] = om.r[1].y;
	a[5] = om.r[1].z;
	a[6] = om.r[2].x;
	a[7] = om.r[2].y;
	a[8] = om.r[2].z;

}


