/* write_stuff_to_socket.c
 * routines to write various kinds of stuff to the socket
 * in mosflm, like spot and prediction positions - these will
 * come out all on one line, which is handy for parsing
 * 
 * gw 29.11.01
 * 
 * 
 */

/* CALL WRITE_SPOTS(NSPOTS, SOCK, SPOTARRAY) etc ..*/

int write_spots_(
  int *n,
  int *sock,
  short int *spots     /* x, y, x, y, x, y .... */
)
{
  int i;
  char numbers[40];

  memset(numbers, 0, 40);
  sprintf(numbers, "spots %d", *n);
  write(*sock, numbers, strlen(numbers));

  for(i = 0; i < *n; i++) {
    memset(numbers, 0, 40);
    sprintf(numbers, " %d %d", spots[2 * i], spots[2 * i + 1]);
    write(*sock, numbers, strlen(numbers));
  }

  write(*sock, "\n", 1);

  return 0;
}

int write_partial_(
  int *n,
  int *sock,
  short int *predictions     /* x, y, x, y, x, y .... */
)
{
  int i;
  char numbers[40];

  memset(numbers, 0, 40);
  sprintf(numbers, "partial %d ", *n);
  write(*sock, numbers, strlen(numbers));

  for(i = 0; i < *n; i++) {
    memset(numbers, 0, 40);
    sprintf(numbers, " %d %d ", predictions[2 * i], predictions[2 * i + 1]);
    write(*sock, numbers, strlen(numbers));
  }

  write(*sock, "\n", 1);

  return 0;
}

int write_full_(
  int *n,
  int *sock,
  short int *predictions     /* x, y, x, y, x, y .... */
)
{
  int i;
  char numbers[40];

  memset(numbers, 0, 40);
  sprintf(numbers, "full %d ", *n);
  write(*sock, numbers, strlen(numbers));

  for(i = 0; i < *n; i++) {
    memset(numbers, 0, 40);
    sprintf(numbers, " %d %d ", predictions[2 * i], predictions[2 * i + 1]);
    write(*sock, numbers, strlen(numbers));
  }

  write(*sock, "\n", 1);

  return 0;
}

int write_overlap_(
  int *n,
  int *sock,
  short int *predictions     /* x, y, x, y, x, y .... */
)
{
  int i;
  char numbers[40];

  memset(numbers, 0, 40);
  sprintf(numbers, "overlap %d ", *n);
  write(*sock, numbers, strlen(numbers));

  for(i = 0; i < *n; i++) {
    memset(numbers, 0, 40);
    sprintf(numbers, " %d %d ", predictions[2 * i], predictions[2 * i + 1]);
    write(*sock, numbers, strlen(numbers));
  }

  write(*sock, "\n", 1);

  return 0;
}

int write_wide_(
  int *n,
  int *sock,
  short int *predictions     /* x, y, x, y, x, y .... */
)
{
  int i;
  char numbers[40];

  memset(numbers, 0, 40);
  sprintf(numbers, "wide %d ", *n);
  write(*sock, numbers, strlen(numbers));

  for(i = 0; i < *n; i++) {
    memset(numbers, 0, 40);
    sprintf(numbers, " %d %d ", predictions[2 * i], predictions[2 * i + 1]);
    write(*sock, numbers, strlen(numbers));
  }

  write(*sock, "\n", 1);

  return 0;
}

