C $Id: torefix.f,v 1.6 2003/05/30 11:06:26 harry Exp $ real torefix.f routine
      SUBROUTINE TOREFIX(NSOL,BOXOPEN,RFIXCELL,RFIXDIST)
C     ==================================================
C
      IMPLICIT NONE
C
C---- This interfaces MOSFLM to REFIX. This is called from MXDSPL
C
C     Information to be passed to refix:
C           Distance
C           Unit cell
C           Spacegroup
C           Wavelength
C           Distortion parameters ROFF,TOFF,CCOMEGA
C           Intensity threshold
C           Spot list
C           Delphi
C
C      Information to be passed back to MOSFLM
C           List of solutions
C           Refined cell encoded in orientation matrix AMAT
C           Error flag if autoindexing did not work        
C  aP      [1,P1]
C  mP      [3,P2] [4,P2(1)]
C mC,mI    [5,C2]
C  oP      [16,P222] [17,P222(1)] [18,P2(1)2(1)2] [19,P2(1)2(1)2(1)]
C  oC      [21,C222] [20,C222(1)]
C  oF      [22,F222]
C  oI      [23,I222] [24,I2(1)2(1)2(1)]
C  tP      [75,P4] [76,P4(1)] [77,P4(2)] [78,P4(3)] [89,P422] [90,P42(1)2]
C          [91,P4(1)22] [92,P4(1)2(1)2] [93,P4(2)22] [94,P4(2)2(1)2]
C          [95,P4(3)22] [96,P4(3)2(1)2]
C  tI      [79,I4] [80,I4(1)] [97,I422] [98,I4(1)22]
C  hP      [143,P3] [144,P3(1)] [145,P3(2)] [149,P312] [150,P321] [151,P3(1)12]
C          [152,P3(1)21] [153,P3(2)12] [154,P3(2)21] [168,P6] [169,P6(1)]
C          [170,P6(5)] [171,P6(2)] [172,P6(4)] [173,P6(3)] [177,P622]
C          [178,P6(1)22] [179,P6(5)22] [180,P6(2)22] [181,P6(4)22] [182,P6(3)22]
C  hR      [146,R3] [155,R32]
C  cP      [195,P23] [198,P2(1)3] [207,P432] [208,P4(2)32] [212,P4(3)32]
C          [213,P4(1)32]
C  cF      [196,F23] [209,F432] [210,F4(1)32]
C  cI      [197,I23] [199,I2(1)3] [211,I432] [214,I4(1)32]

C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C
      INTEGER NPARM
      PARAMETER (NPARM = 200)
C
C     .. Scalar Arguments ..
      INTEGER NSOL
      LOGICAL BOXOPEN,RFIXCELL,RFIXDIST
C
C     ..
C     .. Local Scalars ..
      INTEGER I,ICHECK,NLAUEG,J,K,INDEX,IXW,IYW,
     +        LINELEN,NUMLIN
      REAL X
      CHARACTER LATTYP*1,STR1*1,LINE*90,SPLISTB*57,BTSTR*2,STR*200,
     +          LLINE*130,LINE2*80
C     ..
C     .. Local Arrays ..
      INTEGER*2 IORDER(44),MERIT(44),LCLASS(6,8)
      CHARACTER LTYPE(15)*2,SPLIST(15)*70
      REAL CELLSAVE(6,44)
      INTEGER INDEXA(44)
C     ..
C
C---- Things for parser
C
      INTEGER IBEG(NPARM),IDEC(NPARM),IEND(NPARM),ITYP(NPARM)
      REAL VALUE(NPARM)
      INTEGER NTOK
C     ..
C     .. External Functions ..
      INTEGER LENSTR
      EXTERNAL LENSTR
C     .. External Subroutines ..
      EXTERNAL XDLF_FLUSH_EVENTS,CELLFIX,REFIX,SETMAT,MXDCIO,
     +         MXDWIO,MXDRIO
C     ..
C     .. Intrinsic Functions ..
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/condata.f
C
C $Id: condata.f,v 1.14 2004/07/20 12:40:18 harry Exp $
C
C--- awk generated include file condata.h 
C---- START of include file condata.h 
C 
C
C     FIXSWAP     Forces reversal of normal byte-swapping choice.
C
C---- SUMPART True if two images are to be stored in memory at the
C               same time. This will be the case if post-refinement
C               (other than POSTHOC post-refinement for off-line
C               scanners) is being performed. Note that SUMPART is NOT
C               used to determine if partials should be added across
C               images (this is ADDPART)
C
C---- NEWPREF True if allowing partials over multiple images in post-
C             refinement.
C
C---- ADDPART True if partials are to be summed across images. This is
C               only appropriate for fixed origin (ie on-line)
C               scanners where the X-ray dose is identical for
C               each image.
C     Direct beam coordinates
C             These are read into XMM(3), YMM(3) where (3) is for A,B,C packs
C             Immediately on reading in, these values are transferred
C             into XCENMM, YCENMM, XCENMMIN(J,3) where J=1->MAXPAX.
C
C             If an IMAGE keyword has been given, XCENMM(1,1)=XMM(1) and
C             YCENMM(1)=YSCAL*YMM(1). If swung out, YCENMM(1,1) is updated.
C             If a BEAM keyword has not been given, XMM,YMM, XCENMM,YCENMM,
C             XCENMMIN are all set to the middle of the image.


C             Then, when reflecting input to logfile, it AGAIN sets up
C             XCENMM,YCENMM for all images using XMM,YMM, this time
C             using YSCAL to set up YCENMM, and updating YCENMM if the
C             detctor is swung out. (label 708), DO loop 710. If image
C             is "inverted", corrects XCENMM for all images.


C             XCEN,YCEN are set in "mosflm" to XCENF, YCENF plus
C             camera constants, and XCENF,YCENF are in turn set from
C             XCENMM,YCENMM. Thus XCENMM,YCENMM are what is actually
C             used to define the beam position.

C
C     LPREF   If TRUE, return to display after refinement over entire
C             image. Only active when integrating interactively. Set by
C             toggle button in Parameter window.
C

C     LOVERLAP  If TRUE, do not call the OVERLAP subroutine

C     ALLOUT  If TRUE, all reflections (whether measured or not, or
C             classified as BADSPOTS or not, will be written to the
C             output MTZ file.
C
C     NTDIG   Number of digits in image number, returned as zero if
C             there is an error in the template. Only used if TEMPLATE
C             keyword given.
C
C     TEMPLATE is TRUE if a TEMPLATE keyword has been given.
C
C     NOLP    If TRUE, do NOT apply the Lorentz Polarisation corrections
C
C     MULTIMTZ True if writing each "block" of images to a separate MTZ file
C
C     DISPMENU True if the run was started with a IMAGE keyword. Not to be
C              confused with WINOPEN which is true if the X-window display
C              is being used, but this is not necessarily starting with
C              a "IMAGE" keyword.
c     newgui - this means that we're talking through the new GUI.
c              except that we can't have it here because the prsummary 
c              subroutine, where we REALLY want it, clashes with this common
C
C     HACTIVEMASK,LACTIVEMASK,LACTIVE - only for Rigaku images which 
C     contain a compressed "active mask" (size=HACTIVEMASK bytes)
C     at the end of the image. Compression uses a modified run length encoding
C     at present (10.01.2003).
C
C     ..
C     .. Arrays in common /CONDATA/ ..
      REAL XCENMM,YCENMM,THFOIL,PHIBEGA,PHIENDA,RSYM,XMM,YMM,
     +     XCENMMIN,YCENMMIN
      REAL RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +     PHIRNG,YSCALIN,FULLFRAC,WTIME
C     ..
C     .. Arrays in common /CONDATA/ ..
      INTEGER IDPACK,NFPACK,NFIRST,ICASSET
      INTEGER IPACK1A,IPACK2A,ISERAR
      LOGICAL AVPROF,FILMPLOT,FORCEB,FORCEC
C
C     .. Scalars in common /CONDATA/ ..
C     ..
      INTEGER NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX
      INTEGER IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK
      LOGICAL FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF,ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW, 
     +        spostref,newgui,LACTIVEMASK,USERSPOT,HEADONLY
C     ..
C real arrays, then scalars, integer arrays, scalars, logicals
      COMMON /CONDATA/
     $       XCENMM(MAXPAX,3),
     +       YCENMM(MAXPAX,3), THFOIL(3),PHIBEGA(MAXPAX),
     $       PHIENDA(MAXPAX),RSYM(4,4,96),XMM(3),YMM(3),
     $       XCENMMIN(MAXPAX),YCENMMIN(MAXPAX),
     $       RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +       PHIRNG,YSCALIN,FULLFRAC,WTIME,
     $        IDPACK(MAXPAX),NFPACK(MAXPAX),NFIRST(MAXPAX),
     +        ICASSET(MAXPAX),IPACK1A(50),
     +        IPACK2A(50),ISERAR(50),
     $        AVPROF(MAXPAX),FILMPLOT(MAXPAX),FORCEB(MAXPAX),
     +        FORCEC(MAXPAX),
     $        NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX,
     $        IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK,
     $        FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF, spostref, ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW,
     $        newgui,LACTIVEMASK,USERSPOT,HEADONLY


C&&*&& end_include  ../inc/condata.f
C&&*&& include  ../inc/ccondata.f
C
C $Id: ccondata.f,v 1.3 2003/01/30 13:26:03 harry Exp $
C
C--- awk generated include file  ccondata.h
C---- START of include file ccondata.h
C
C
C     .. Scalars in Common /CCONDATA/ ..
      CHARACTER GENFILE*200,CCFILE*200,ODEXT*8,WAXFN*134,
     +          GTITLE*80,IDENT*40,NEWMATNAM*80,MTZNAM*80,PGNAME*10,
     +          SPGNAM*10,ODFILE*200,SEPCHAR*1,SNEWMATNAM*80,
     +          TEMPLSTART*100,TEMPLEND*100,TEMPLSAV*100,BITMAPTYPE*12,
     $          CCP4VERSION*10
C     ..
C     ..  Arrays in Common /CCONDATA/ ..
      CHARACTER FDISK(10)*80,INLINE(1000)*80
C     ..
C     .. Common block /CCONDATA/ ..
      COMMON /CCONDATA/GENFILE,CCFILE,ODEXT,WAXFN,GTITLE,IDENT,
     +                 NEWMATNAM,MTZNAM,PGNAME,SPGNAM,ODFILE,
     +                 SEPCHAR,SNEWMATNAM,TEMPLSTART,TEMPLEND,
     $                 TEMPLSAV,BITMAPTYPE,CCP4VERSION,FDISK,INLINE
C     ..
C
C
C&&*&& end_include  ../inc/ccondata.f
C&&*&& include  ../inc/cell.f
C
C $Id: cell.f,v 1.2 2003/06/16 16:41:13 harry Exp $
C
C--- awk generated include file  cell.h
C---- START of include file cell.h
C
C     CELL cell dimensions (real space)
C     RCELL reciprocal cell parameters in dimensionless rlu
C
C     .. Arrays in Common /CELLCOM/ ..
      REAL UMAT,BMAT,GMAT,CELL,RCELL,UMATCELL,SOFTCELL
      INTEGER LCELL,ICRYST,NUMSPG,NLAUE
C     ..
C     .. Common Block /CELLCOM/ ..
      COMMON /CELLCOM/UMAT(3,3),BMAT(3,3),GMAT(3,3),CELL(6),RCELL(6),
     $       UMATCELL(6),SOFTCELL,LCELL(6),ICRYST,NUMSPG,NLAUE
C     ..
C
C
C&&*&& end_include  ../inc/cell.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/dsplyc.f
C
C $Id: dsplyc.f,v 1.1 2002/05/02 10:46:46 harry Exp $
C
C--- awk generated include file  dsplyc.h
C---- START of include file dsplyc.h
C
C*******************************************************************
C
C  COMMON  /DSPLYC/
C
C	IMGLOW, IMGHI	low & high values of 16-bit image for scaling
C			integer*2 to byte: IMGLOW maps to  0; 
C			IMGHI to maximum. Note that these are not
C			necessarily the actual limits of the data
C	JDSPWD		.LT. 0  before image window has been created
C                       = +-1 for image display that can be panned
C                       = +-2 for non-interactive image display
C       MAXDEN          highest level in colour table to fill up to
C                       must be less than ~240 - number of overlay colours
C       LDSPSG          if .true., treat image as signed, ie after dark
C                          subtraction
C                       if .false., treat image as unsigned
C       NZOOM           zoom factor for image, = 0 if no zoom
C       JYZOOM, JZZOOM  1st pixel in zoomed image
C
C----   WINOPEN Flag for whether or not window is open. Do not
C               confuse with DISPMENU (/CONDATA/)which is true if the run was
C               started with a IMAGE keyword.
C
C
C       CDSPTL          banner title
C
      INTEGER IMGLOW, IMGHI, JDSPWD, MAXDEN,
     $     NZOOM, JYZOOM, JZZOOM
      LOGICAL LDSPSG,WINOPEN,LPAUSE,LHELP
      COMMON /DSPLYC/ IMGLOW, IMGHI, JDSPWD,
     *     MAXDEN, NZOOM, JYZOOM, JZZOOM, LDSPSG,WINOPEN,LPAUSE,LHELP
C
      CHARACTER  CDSPTL*200
      COMMON /DSPLCC/  CDSPTL
C                                                           
C
C*******************************************************************


C&&*&& end_include  ../inc/dsplyc.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/spots.f
C
C $Id: spots.f,v 1.1 2002/05/02 10:47:18 harry Exp $
C
C--- awk generated include file  spots.h
C---- START of include file spots.h
C
C     XSPT,YSPT,ISPT store spot coordinates (in mm) and intensity
C
C     These arrays hold the complete list of spots found on ALL images.
C     Pointers to the first and last spot in each image are kept in arrays
C
C     XSPT....  X coordinates (in mm) of spots in total spot list for
C               all images.
C
C     YSPT....  Y coordinates (in mm) of spots in total spot list for
C               all images.
C
C     ISPT....  Intensity of spots in total spot list for
C               all images.
C
C     ISDSPT..  Standard deviations of intensities
C
C     INDX...   Stores a pointer into arrays XSPT,YSPT,ISPT for the I'th
C               displayed spot (only spots above current threshold are
C               displayed).
C
C     ISTIMG(IMAG)...  Pointer to first spot for image IMAG in arrays
C                      XSPT,YSPT,ISPT
C     IENDIMG(IMAG)...  Pointer to last spot for image IMAG in arrays
C                      XSPT,YSPT,ISPT
C
C     IXSPT,IYSPT...   Spot coordinates in display pixels for current image
C     SELECT....       True for images selected for autoindexing
C     SPOTFND....      True for images on which spots have been found
C     ITHRESH          I/sig(I) threshold for spots to be used in autoindexing
C
C     .. Scalars in Common Block /SPOTS/ ..
        REAL XF,YF,XFID1,YFID1,XFID2,YFID2,XFID3,YFID3,PHIIMG,
     +       LPIXEL,LYSCALE,LOMEGA,LXCEN,LYCEN
        INTEGER NSPT,ISPOT,ITHRESH,IRSCAL,LIXLEN,LIYLEN,INVFLAG,
     +       LISWUNG
        CHARACTER*100 SPTNAM,NSPTNAM

C     ..
C     .. Arrays in common /SPOTS/ ..
        REAL XSPT(NSPOTS),YSPT(NSPOTS)
        INTEGER ISPT(NSPOTS),IXSPT(NSPOTS),IYSPT(NSPOTS),
     +          ISTIMG(MAXIMG),IENDIMG(MAXIMG),ISDSPT(NSPOTS)
        INTEGER*2 INDX(NSPOTS)
        LOGICAL SELECT(MAXIMG),SPOTFND(MAXIMG)
C     ..
C     .. Common Block /SPOTS/ ..
        COMMON /SPOTS/ XF,YF,XFID1,YFID1,XFID2,YFID2,XFID3,YFID3,
     +                 XSPT,YSPT,ISPT,IXSPT,IYSPT,INDX,ISPOT,NSPT,
     +                 ITHRESH,PHIIMG,IRSCAL,LPIXEL,LYSCALE,LOMEGA,
     +                 LIXLEN,LIYLEN,LXCEN,LYCEN,INVFLAG,LISWUNG,
     +                 ISTIMG,IENDIMG,SELECT,ISDSPT,SPOTFND
C
        COMMON /CSPOTS/ SPTNAM,NSPTNAM

C&&*&& end_include  ../inc/spots.f
C&&*&& include  ../inc/sys.f
C
C $Id: sys.f,v 1.1 2002/05/02 10:47:21 harry Exp $
C
C--- awk generated include file  sys.h
C---- START of include file sys.h
C
C
C     .. Scalars in Common Block /SYS/ ..
      INTEGER ISYS
C     ..
C     .. Arrays in Common Block /SYS/  ..
      INTEGER KSYS
C     ..
C     ..  Common Block /SYS/ ..
      COMMON /SYS/ISYS,KSYS(3)
C     ..
C
C
C&&*&& end_include  ../inc/sys.f
C&&*&& include  ../inc/xy.f
C
C $Id: xy.f,v 1.1 2002/05/02 10:47:25 harry Exp $
C
C--- awk generated include file  xy.h
C---- START of include file xy.h
C
C     .. Scalars in common block /XY/ ..
      REAL XTOFD,SINV,COSV,TANV,TWOTHETA
      INTEGER ICASS
C     ..
C     .. Common Block /XY/ ..
      COMMON /XY/XTOFD,SINV,COSV,TANV,TWOTHETA,ICASS
C     ..
C
C     XTOFD....  Crystal to detector distance in 10 micron units. Read from
C                keyworded input and never changed.
C
C                Spot positions are calculated in S/R XYSPOT (Called from
C                REEK) and are for an "ideal" detector at a distance of XTOFD.
C                These are converted into pixel positions in S/R MMTOPX
C                which applies the multiplicative factor XTOFRA to allow
C                for refinement of the distance. XTOFRA is the parameter
C                that is actually refined (in RDIST), rather than XTOFD.
C                The refined distance that is printed in the logfile is
C                actually XTOFRA*XTOFD
C
C     ICASS....  Indicates detector type:
C                0     Flat film
C                1     Vee shaped cassettes
C                2     FAST detector (only used in TESTGEN mode of OSCGEN)
C                3     Swung out FAST (ditto)
C                4     IP detector
C     TWOTHETA   Detector swing angle (degrees)
C&&*&& end_include  ../inc/xy.f
C
C
      INTEGER IGROUP,FIXF
      REAL FLAMBDA,F,THRESH,Q,DPHI,ORGX,ORGY,CCX,CCY,CCOM,DXY
      LOGICAL TARGET,DCOMP,LCAMC,FILM,FIXCELL
      REAL RFCELL,ED,ACHSE,S0DUMMY,TARMAT
      COMMON /REFCOM/IGROUP,FLAMBDA,RFCELL(6),F,THRESH,Q,DPHI,ED(3,3),
     +       ACHSE(3),S0DUMMY(3),ORGX,ORGY,FIXF,TARMAT(3,3),TARGET,
     +       DCOMP,LCAMC,CCX,CCY,CCOM,FILM,DXY,FIXCELL
      REAL RFROFF,RFTOFF
      COMMON /DISTOR/ RFROFF,RFTOFF
      COMMON /FNAMES/ SPOTFL,MATNAME
      CHARACTER SPOTFL*100,MATNAME*80
      COMMON /THETA/ TWOTH
      REAL TWOTH
C
C---- Common blocks for passing results from REFIX back to MOSFLM
C     RFAMAT contains A-matrix
C     RESLIST/RESLISTC contain list of 44 Laue groups
C
      COMMON /RFAMAT/ ASTV,BSTV,CSTV
      REAL ASTV(3),BSTV(3),CSTV(3)
      COMMON /RESLIST/ LATCH,P,CELLB,SDXY,SDPHI,IERR
      INTEGER*2 LATCH(44)
      REAL P(44),CELLB(6,44)
      REAL SDXY,SDPHI
      INTEGER IERR
      COMMON /RESLISTC/ BT
      CHARACTER*2  BT(44)
C
C---- Common block for I/O
C
      LOGICAL RFONLINE
      INTEGER RFLP,RFLINOUT
      COMMON /RINOUT/ RFONLINE,RFLP,RFLINOUT
C
C     ..
C     .. Equivalences ..
      SAVE
C     ..
C     .. Data ..
      DATA NLAUEG/44/
      DATA LTYPE/'aP','mP','mC','mI','oP','oC','oF','oI','tP','tI',
     +           'hP','hR','cP','cF','cI'/
      DATA SPLIST/'P1','P2,P21','C2','C2','P222,P2221,P21212,P212121',
     +            'C222,C2221','F222','I222,I212121,',
     +  'P4,P41,P42,P43,P422,P4212,P4122,P41212,P4222,P42212,'
     +   , 'I4,I41,I422,I4122',
     +  'P3,P31,P32,P312,P321,P3112,P3121,P3212,P3221,',
     +  'R3,R32','P23,P213,P432,P4232,P4332,P4132','F23,F432,F4132',
     + 'I23,I213,I432,I4132'/
      DATA SPLISTB(1:30)/'P6,P61,P65,P62,P64,P63,P622,P6'/
      DATA SPLISTB(31:57)/'122,P6522,P6222,P6422,P6322'/
C
C---- Flags for crystal classes
C
      DATA LCLASS/-1,-1,-1,-1,-1,-1,
     +            -1,-1,-1, 0,-1, 0,
     +            -1,-1,-1, 0, 0, 0,
     +            -1, 1,-1, 0, 0, 0,
     +            -1, 1,-1, 0, 0, 0,
     +            -1, 1,-1, 0, 0, 0,
     +            -1, 1, 1, 0, 0, 0,
     +            -1, 1, 1,-1, 4, 4/
CAL this was original, it is wrong   +            -1, 0, 0,-1, 4, 4/
C     ..
C
C---- If just giving list of solutions, do it
C
CAL      IF (NSOL.EQ.999) GOTO 22
C
C---- Transfer MOSFLM variables to REFIX variables
C
      SPLIST(9) = SPLIST(9)(1:52)//'P4322,P43212'
      IGROUP = NUMSPG
      FIXCELL = RFIXCELL
      IF (.NOT.RFIXDIST) FIXF = 0
C
C---- Special provision for indexing with rhombohedral cells,
C
      IF (IGROUP.GT.1000) IGROUP = IGROUP - 1000
C
      DPHI = 0.5*(PHIEND-PHIBEG)
      Q = RAST
      THRESH = ITHRESH
      RFROFF = 0.01*ROFF
      RFTOFF = 0.01*TOFF
      F = 0.01*XTOFD*XTOFRA
C
C---- **** IMPORTANT **** Need to negate the sign of twotheta !!
C
      TWOTH = -TWOTHETA
      MATNAME = NEWMATNAM
C
      FLAMBDA = WAVE
      SPOTFL = SPTNAM
      IERRFLG = 0
      RFONLINE = ONLINE
      RFLP = ITOUT
      RFLINOUT = IOUT
C
C---- If we already have an orientation matrix, always refer new solutions
C     to that matrix.
C
      IF (NUMSPG.EQ.0) TARGET = .FALSE.
      IF (NUMSPG.GT.0) THEN
        DCOMP = .TRUE.
        X = 0.0
        DO 4 I = 1,3
          DO 2 J = 1,3
            X = MAX(ABS(AMAT(I,J)),X)
            TARMAT(I,J) = AMAT(I,J)
 2        CONTINUE
 4      CONTINUE
        IF (X.GT.0.00001) TARGET = .TRUE.
      END IF
C
C---- Skip if rhombohedral cell has been requested by CRYST keyword
C
      IF (ICRYST.EQ.8) GOTO 6
C
      IF (NUMSPG.LT.3) THEN
C
C---- Triclinic
C
        ICRYST = 1
      ELSE IF (NUMSPG.LT.16) THEN
C
C---- Monoclinic
C
        ICRYST = 2
      ELSE IF (NUMSPG.LT.75) THEN
C
C---- Orthorhombic
C
        ICRYST = 3
      ELSE IF (NUMSPG.LT.143) THEN
C
C---- Tetragonal
C
        ICRYST = 4
      ELSE IF (NUMSPG.LT.168) THEN
C
C---- Trigonal, but allow for rhombohedral settings (CRYST keyword)
C
        IF (ICRYST.NE.8) ICRYST = 5
      ELSE IF (NUMSPG.LT.195) THEN
C
C---- Hexagonal
C
        ICRYST = 6
      ELSE IF (NUMSPG.LE.230) THEN
C
C---- Cubic
C
        ICRYST = 7
      END IF
C
C---- If a solution has been chosen, impose cell constraints on cell parameters
C
 6    IF (NSOL.NE.0) THEN
C
C---- Recover cell parameters for this solution
C
        DO 12 I = 1,6
          CELL(I) = CELLSAVE(I,NSOL)
 12     CONTINUE
        CALL CELLFIX(CELL)
C
C---- Check spacegroup given is allowed for this solution number
C
        INDEX = INDEXA(NSOL)
        STR = SPLIST(INDEX)
        IF (INDEX.EQ.11) STR = STR(1:LENSTR(STR))//SPLISTB
CAL        WRITE(6,*),'STR IS',STR(1:LENSTR(STR))
C
C---- Also set systematic abscence flags and cell refinement flags
C
C
C---- Set cell refinement flags
C
        DO 14 I = 1,6
          LCELL(I) = LCLASS(I,ICRYST)
  14   CONTINUE
C
C---- Get lattice type from spacegroup name
C
        LATTYP = SPGNAM(1:1)    
C
C
        ISYS = 2
        IF (LATTYP.EQ.'A') THEN
          KSYS(1) = 0
          KSYS(2) = 1
          KSYS(3) = 1
        ELSE IF (LATTYP.EQ.'B') THEN
          KSYS(1) = 1
          KSYS(2) = 0
          KSYS(3) = 1
        ELSE IF (LATTYP.EQ.'C') THEN
          KSYS(1) = 1
          KSYS(2) = 1
          KSYS(3) = 0
        ELSE IF (LATTYP.EQ.'I') THEN
          ISYS = 2
          KSYS(1) = 1
          KSYS(2) = 1
          KSYS(3) = 1
        ELSE IF (LATTYP.EQ.'R') THEN
C
C---- Allow for choice of rhombohedral cell
C
              IF (ICRYST.EQ.8) THEN
                ISYS = 0
                KSYS(1) = 1
                KSYS(2) = 1
                KSYS(3) = 1
              ELSE
                ISYS = 3
                KSYS(1) = -1
                KSYS(2) = 1
                KSYS(3) = 1
              END IF
        ELSE IF (LATTYP.EQ.'F') THEN
          ISYS = 4
          KSYS(1) = 1
          KSYS(2) = 1
          KSYS(3) = 1
        ELSE IF (LATTYP.EQ.'P') THEN
          ISYS = 0
          KSYS(1) = 1
          KSYS(2) = 1
          KSYS(3) = 1
        END IF

      END IF
C
      IF (ICRYST.NE.0) CALL CELLFIX(CELL)
C
      DO 10 I = 1,6
         RFCELL(I) = CELL(I)
 10   CONTINUE
C
      CALL REFIX(DEBUG(64))
C
C---- Trap failure
C
      IF (IERRFLG.EQ.1) RETURN
C
C---- Pass back the A-matrix, and set missets to zero
C
      DO 20 I = 1,3
        AMAT(I,1) = ASTV(I)
        AMAT(I,2) = BSTV(I)
        AMAT(I,3) = CSTV(I)
        DELPHI(I) = 0.0
 20   CONTINUE
C
      ICELL = 0
C
      IF (NUMSPG.GT.0) THEN
        WRITE(IOUT,FMT=6000) NEWMATNAM(1:LENSTR(NEWMATNAM))
        IF (ONLINE) WRITE(ITOUT,FMT=6000) 
     +                   NEWMATNAM(1:LENSTR(NEWMATNAM))
C
C---- Save this filename (in case a NEWMAT keyword is used)
C
        SNEWMATNAM = NEWMATNAM
        IF (ONLINE) WRITE(STR,FMT=6001) NEWMATNAM(1:LENSTR(NEWMATNAM))
        LLINE = STR(1:130)
        IF (ONLINE.AND.WINOPEN.AND.(.NOT.BOXOPEN)) THEN
C     
C     Create IO window
C
          IXW = 200
          IYW = 200
          LINELEN = 100
          NUMLIN = 10
          CALL MXDCIO(0,LINELEN, NUMLIN, IXW,IYW)
          BOXOPEN = .TRUE.
        END IF
        IF (ONLINE.AND.WINOPEN) THEN
          CALL MXDWIO(LLINE, 2)
          LLINE = ' '
          WRITE(LLINE,FMT=6005) IERR, RAST*SDXY, SDPHI
 6005   FORMAT('Using',I5,' indexed reflections, final sd in spot',
     +         ' positions is',F5.2,'mm and in phi',F5.2,' degrees')
          CALL MXDWIO(LLINE, 2)
          LLINE = ' '
          IF (.NOT.RFIXDIST) THEN
            WRITE(LLINE,FMT=6040) F
 6040     FORMAT('Refined detector distance',F8.2,'mm')
            CALL MXDWIO(LLINE, 2)
          END IF
          LLINE = ' '
          IF (RFIXCELL) THEN
            WRITE(LLINE,FMT=6046) (RFCELL(I),I=1,6)
            CALL MXDWIO(LLINE, 2)
             ICELL = 1
          ELSE
            WRITE(LLINE,FMT=6007) (RFCELL(I),I=1,6)
          CALL MXDWIO(LLINE, 2)
          LLINE = ' '
          WRITE(LLINE,FMT=6012)
 6012     FORMAT('Do you want to update cell parameters (Y):')
          CALL MXDWIO(LLINE, 1)
          CALL MXDRIO(LINE2)
C
C---- Parse reply
C
C               ******************************************
          CALL MPARSE(LINE2,IBEG,IEND,ITYP,VALUE,IDEC,NTOK)
C               ******************************************
          IF (NTOK.EQ.0) THEN
            STR1 = 'Y'
          ELSE
            STR1 = LINE2(IBEG(1):IEND(1))
            CALL CCPUPC(STR1)
          END IF
          IF (STR1.EQ.'N') THEN
            ICELL = 1
          ELSE
            ICELL = 0
          END IF
          END IF
 6046     FORMAT('Cell parameters (fixed)',3F8.2,3F7.2)
 6007   FORMAT('Refined cell parameters',3F8.2,3F7.2)
C
C---- Using refined distance does not always work, so only do it if
C     the cell is fixed.
C
          IF ((RFIXCELL).AND.(.NOT.RFIXDIST)) THEN
            LLINE = ' '
            WRITE(LLINE,FMT=6042)
 6042     FORMAT('Do you want to update detector distance (Y):')
            CALL MXDWIO(LLINE, 1)
            CALL MXDRIO(LINE2)
C
C---- Parse reply
C
C                 ******************************************
            CALL MPARSE(LINE2,IBEG,IEND,ITYP,VALUE,IDEC,NTOK)
C                 ******************************************
            IF (NTOK.EQ.0) THEN
                STR1 = 'Y'
            ELSE
              STR1 = LINE2(IBEG(1):IEND(1))
              CALL CCPUPC(STR1)
            END IF
            IF (STR1.EQ.'Y') THEN
              XTOFRA = 100.0*F/XTOFD
            END IF
          END IF
C
C---- If spacegroup was specified in input (ie a solution has not
C     been chosen by the user) close window now
C
 50       IF (NSOL.EQ.0) THEN
            LLINE = ' '
            WRITE(LLINE,FMT=6009)
 6009   FORMAT('Enter "return" to continue')
            CALL MXDWIO(LLINE, 1)
            CALL MXDRIO(LLINE)
            CALL MXDCIO(1,0,0,0,0)
            BOXOPEN = .FALSE.
            CALL XDLF_FLUSH_EVENTS(I)
          END IF
        END IF
      END IF
 6000 FORMAT(/1X,'New orientation matrix written to (Keyword NEWMAT):',
     +             A)
 6001 FORMAT('New orientation matrix written to (Keyword NEWMAT):',
     +             A)
      IMAT = 1
      IUMAT = 0
      ICHECK = 1
C            ************************
      CALL SETMAT(IMAT,IUMAT,ICELL,ICHECK)
C            ************************
C---- Set flag for new matrix written
C
      INEWMAT = 1
C
C---- If spacegroup unknown, give list of solutions sorted on merit
C
      IF (NUMSPG.NE.0) THEN
        NSOL = 0
        RETURN
      END IF
 22   WRITE(IOUT,FMT=6002)
      IF (ONLINE) WRITE(ITOUT,FMT=6002)
 6002 FORMAT(1X,'List of possible Laue groups, sorted on penalty ',
     +  'index.',/,1X,'The lower the PENALTY, the better',
     +   /,1X,'No PENALTY LATT     a        b        c',
     +  '     alpha  beta gamma  Possible spacegroups',/)
C
      IXW = 200
      IYW = 200
      LINELEN = 130
      NUMLIN = 40
C     
C     Create IO window with scrolling
C
      IF (ONLINE.AND.WINOPEN) THEN
      IF (BOXOPEN) CALL MXDCIO(1,0,0,0,0)
      CALL MXDCIO(5,LINELEN, NUMLIN, IXW,IYW)
      BOXOPEN = .TRUE.
      LLINE = ' '
      WRITE(LLINE,FMT=6030)
 6030 FORMAT('List of possible Laue groups, sorted on penalty index.')
      CALL MXDWIO(LLINE, 2)
      LLINE = '                                                      '
      WRITE (LLINE, 6032)
 6032 FORMAT('The lower the PENALTY, the better')
      CALL MXDWIO(LLINE, 2)
      LLINE = '                                                      '
      WRITE (LLINE, 6033)
 6033 FORMAT('Only solutions with PENALTY less than 200 are listed',
     +        ', a complete list is given in the terminal window')
      CALL MXDWIO(LLINE, 2)
      LLINE = ' '
      WRITE (LLINE, 6034)
 6034 FORMAT(' No PENALTY LATT    a        b        c',
     +  '     alpha  beta gamma  Possible spacegroups')
      CALL MXDWIO(LLINE, 2)
      END IF
C
C---- Sort Laue groups on figure of merit
C
      DO 30 I = 1,NLAUEG
        MERIT(I) = NINT(P(I))
 30   CONTINUE
C
      CALL SORTUP2(NLAUEG,MERIT,IORDER)
C
      DO 40 I = NLAUEG,1,-1
        J = IORDER(I)
        BTSTR = BT(J)
        DO 32 K = 1,15
          IF (BTSTR.EQ.LTYPE(K)) THEN
            INDEX = K
            GOTO 34
          END IF
 32     CONTINUE
C
 34     DO 36 K = 1,6
          CELLSAVE(K,I) = CELLB(K,J)
 36     CONTINUE
        INDEXA(I) = INDEX
C
        WRITE(IOUT,FMT=6010) I,MERIT(J),BT(J),(CELLB(K,J),K=1,6),
     +       SPLIST(INDEX)(1:LENSTR(SPLIST(INDEX)))
        IF (ONLINE) WRITE(ITOUT,FMT=6010) I,MERIT(J),BT(J),
     +     (CELLB(K,J),K=1,6),SPLIST(INDEX)(1:LENSTR(SPLIST(INDEX)))
        IF (ONLINE) WRITE(LLINE,FMT=6011) I,MERIT(J),BT(J),
     +     (CELLB(K,J),K=1,6),SPLIST(INDEX)(1:LENSTR(SPLIST(INDEX)))
 6010   FORMAT(1X,I3,I4,4X,A,3F9.2,2X,3F6.1,3X,A)
 6011   FORMAT(I3,I4,5X,A,3F9.2,2X,3F6.1,3X,A)
        IF (ONLINE.AND.(MERIT(J).LE.200)) CALL MXDWIO(LLINE, 2)
        IF (INDEX.EQ.11) THEN
          WRITE(IOUT,FMT=6020) SPLISTB(1:LENSTR(SPLISTB))
          IF (ONLINE) WRITE(ITOUT,FMT=6020) SPLISTB(1:LENSTR(SPLISTB))
          IF (ONLINE) WRITE(LLINE,FMT=6020) SPLISTB(1:LENSTR(SPLISTB))
 6020     FORMAT(64X,A)
          IF (ONLINE.AND.(MERIT(J).LE.200)) CALL MXDWIO(LLINE, 2)
        END IF
 40   CONTINUE
C
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
C
      WRITE(IOUT,FMT=6022)
      IF (ONLINE) WRITE(ITOUT,FMT=6022)
 6022 FORMAT(1X,'No PENALTY LATT     a        b        b',
     +  '     alpha  beta gamma  Possible spacegroups',/)
C
      NSOL = 0
      RETURN
      END
      SUBROUTINE ABSHKL(IGROUP,CELL,ABSTYP)
      IMPLICIT NONE
C***********************************************************************
C
C     OBTAIN CONSTRAINT NUMBER FOR GENERAL SYSTEMATIC ABSENCES
C     FROM SPACE-GROUP NUMBER AND UNIT CELL PARAMETERS
C
C                     VERSION 10-1986
C
C****************** DESCRIPTION OF CALLING PARAMETERS ******************
C
C IGROUP - SPACE-GROUP NUMBER FROM INTERNATIONAL TABLES          (GIVEN)
C  CELL  - UNIT CELL PARAMETER                                   (GIVEN)
C ABSTYP - CONSTRAINT NUMBER FOR GENERAL CONDITIONS LIMITING    (RESULT)
C          POSSIBLE REFLECTIONS
C          0: NO CONDITIONS ON H,K,L
C          1: H+K MUST BE EVEN
C          2: H+L MUST BE EVEN
C          3: K+L MUST BE EVEN
C          4: H+K+L MUST BE EVEN
C          5: -H+K+L MUST BE A MULTIPLE OF THREE
C          6: H+K AND H+L MUST BE EVEN
C
C***************** DECLARATION OF VARIABLES ****************************
      REAL      CELL(6)
      INTEGER   G,ABSTYP,IGROUP,J
      INTEGER*2 IG(86),NUM(86)
C********* INITIALIZE LOOK-UP TABLES OF PAIRS (IGROUP,ABSTYP) **********
      DATA     IG/517,520,521,524,527,20,21,35,36,37,63,64,65,66,67,68,
     2            5,8,9,12,15,
     3            38,39,40,41,
     4            23,24,44,45,46,71,72,73,74,79,80,82,87,88,97,98,107,
     4            108,109,110,119,120,121,122,139,140,141,142,197,199,
     4            204,206,211,214,217,220,229,230,
     5            146,148,155,160,161,166,167,
     6            22,42,43,69,70,196,202,203,209,210,216,219,225,226,
     6            227,228/
      DATA      NUM/16*1, 5*2, 4*3, 38*4, 7*5, 16*6/
C***********************************************************************
      G=IGROUP
      IF ((IGROUP.GT.4).AND.(IGROUP.LT.16).AND.(CELL(5).NE.90.0))
     @   G=IGROUP+512
      IF ((IGROUP.GT.145).AND.(IGROUP.LT.168).AND.(CELL(1).EQ.CELL(2))
     @.AND.(CELL(2).EQ.CELL(3)).AND.(CELL(4).EQ.CELL(5)).AND.
     *     (CELL(5).EQ.CELL(6)))G=IGROUP+512
      ABSTYP=0
      DO 10 J=1,86
      IF (G.EQ.IG(J))ABSTYP=NUM(J)
10    CONTINUE
      RETURN
      END
C
C
C***********************************************************************
C
C                SUBROUTINE AUTOIX                  W.KABSCH 11-1992
C
C***********************************************************************
C
C    DETERMINE CRYSTAL PARAMETER AND INDEX THE LIST OF STRONG SPOTS
C
C***********************************************************************
C
C          INFORMATION EXCHANGE BY FILES FOR THIS SUBROUTINE
C
C   FILE NAME                   DESCRIPTION                      STATUS
C
C  REFIX.DATA   - DATA CARDS FOR THE WHOLE PROGRAM               (GIVEN)
C   SPOT.LIST   - A LIST OF STRONG SPOTS. ON RETURN INDICES   (MODIFIED)
C                 ARE ATTACHED TO THESE DIFFRACTION SPOTS.
C  REFIX.PARM   - REFINED DIFFRACTION PARAMETERS                (RESULT)
C    REFIX.LP   - PRINTED MESSAGES AND RESULTS                  (RESULT)
C
C***********************************************************************
C
C SUBROUTINES REQUIRED: ABSHKL,BASIDX,CRYSYS,DATE,DIFVEC,FITZEL,
C                       GRIDIDX,INDIX,INVCEL,INVERS,LAUESY,
C                       RFMATMUL,METRIC,PREREF,RFPXTOMM,QSORT2,REDUCE,
C                       REDZEL,REFINE,RFSETMAT,UNORM
C
C***********************************************************************
      SUBROUTINE   AUTOIX(CDR,SPOT,XPARM,ERRINT,ERRZEL,MAXIDX,NCYCLE,
     1            MXSPOT,MXY,MZ,MXBEST,MXRFL,ORGXB,ORGYB,FB,UB,EDB,S0B,
     2             RCELLB,ESDCEL,ESDU,ESDXY,ESDPHI,ESD,RMS,V,VC,WEIGHT,
     3             NACCB,IX,IY,IPHI,IH,IK,IL,IP,IQ,IW,IXST,IYST,IRADST,
     4             IPHIST,IORD,TABLE,DEBUG)
      IMPLICIT NONE
ccx
ccx changes to replace vax DATE
ccx
ccx      CHARACTER*24  ZEIT
ccx      CHARACTER*24 FDATE
      CHARACTER*8  ZEIT
      INTEGER      CDR,SPOT,XPARM,NCYCLE,MXSPOT,MXY,MZ,MXBEST,MXRFL,
     1             NRFL,IC,ICS,IGROUP,NSPOT,FIXF,ABSTYP,IER,I,J,K,L,
     2             JRFL,NACC,NBEST,IBEST,NFAR,NOVLAP,NBXYZ,NV,IRANK,
     3             MAXIDX,NEQL,MLAUE(216),INVFLAG,IXLEN,IYLEN,NSOL,
     4             NXSTEP,NYSTEP,ISBEST,IXBS,IYBS,IPASS,NRFLS,IORDI,
     5             NTOT,IGROUPS,ISWUNG
      INTEGER*4    NRFL0,NRFL1
      INTEGER*2    NACCB(MXBEST),IH(MXRFL),IK(MXRFL),IL(MXRFL),
     1             IX(MXRFL),IY(MXRFL),IPHI(MXRFL),
     2             IP(MXRFL),IQ(MXRFL),IW(MXRFL),IDXB(12,44),
     3             IDX(12,44),REIDX0(12),REIDX(12),IXST(MXRFL),
     4             IYST(MXRFL),IRADST(MXRFL),IPHIST(MXRFL),
     5             IORD(MXRFL),TABLE(*)
      REAL         ERRINT,ERRZEL,SEPMIN,FLAMDA,Q,ORGX,ORGY,F,ORGX0,
     1             ORGY0,F0,DPHI,CPHI,SPHI,VOLUME,SDU,SDPHI0,
     2             SDXY0,DXY,R,RX,RY,X,Y,Z,GRID,VOLMIN,RAD,RAD100,
     3             PIXEL,ORGXSTART,ORGYSTART,RESMIN,RADBS,XP,YP,
     4             YSCALE
      LOGICAL      LAST
      PARAMETER    (RAD=57.29578, RAD100=100.0*RAD)
      REAL       ORGXB(MXBEST),ORGYB(MXBEST),FB(MXBEST),UB(3,3,MXBEST),
     1             EDB(3,3,MXBEST),S0B(3,MXBEST),RCELLB(6,MXBEST),
     2             ESDCEL(6,MXBEST),ESDU(MXBEST),ESDXY(MXBEST),
     3             ESDPHI(MXBEST),ESD(MXBEST),RMS(MXBEST),V(3,MXRFL),
     4             VC(3,MXSPOT),WEIGHT(MXSPOT),CELL(6),RCELL(6),
     5             SDCELL(6),PCELL(6),RPCELL(6),BASIS(3,3),RBASIS(3,3),
     6             A(3,3),B(3,3),AA(3,3),U(3,3),ED(3,3),S0(3),ACHSE(3),
     7             ED0(3,3),RCELL0(6),S00(3),MIDX(3),
     8             SDIDX(3),SAVES0(3),
     +  XOFF,YOFF,XF,YF,OMEGA,DTOR,PI,CCX,CCY,CCOM,THRESH,SXOFF,SYOFF,
     +  COSOM,SINOM,XOFFN,YOFFN,XFN,YFN,XFID(3),YFID(3),PHI,
     +  FINT,PSI,CPSI,SPSI,ROFF,TOFF,XCEN,YCEN,XMID,YMID
      REAL ASTV(3),BSTV(3),CSTV(3),XBEAM,YBEAM,PHIXYZ,
     +     CD(3,3),CR(3,3),DE,ROT(3,3),UBM(3,3),ALPHA,BETA,GAMMA,CBETA,
     +     TARMAT,TARINV(3,3),UDEF(3,3)
C     .. Common blocks ..
      LOGICAL DCOMP,LCAMC,FILM
      COMMON /REFCOM/IGROUP,FLAMDA,CELL,F,THRESH,Q,DPHI,ED,
     +       ACHSE,S0,ORGX,ORGY,FIXF,TARMAT(3,3),TARGET,DCOMP,
     +       LCAMC,CCX,CCY,CCOM,FILM,DXY,FIXCELL
      LOGICAL FIXCELL
      COMMON /DISTOR/ ROFF,TOFF
      COMMON /OUTPUT/ IBRIEF,BRIEF,XDSOUT
      LOGICAL ONLINE
      INTEGER LP,LINOUT
      COMMON /RINOUT/ ONLINE,LP,LINOUT
      LOGICAL BRIEF,TARGET,XDSOUT
      INTEGER IBRIEF
      INTEGER IFAIL,LDUM,MAT
      REAL XN,YN,DTR,D,DUM(3,3)
      INTEGER NSRCH
      PARAMETER (NSRCH=25)
      COMMON /BSRCH/ SPRESID(NSRCH),SARESID(NSRCH),SORGX(NSRCH),
     +               SORGY(NSRCH),XSEARCH,YSEARCH,XSTEP,YSTEP,
     +               NPASS,DAMP,NSPOTSR,BSEARCH,CELLSRCH(6,NSRCH),
     +               NINDX(NSRCH)
      REAL SPRESID,SARESID,SORGX,SORGY,XSEARCH,YSEARCH,XSTEP,YSTEP,
     +     DAMP,CELLSRCH,RAT,SDI
      INTEGER NPASS,NSPOTSR,NINDX
      LOGICAL BSEARCH
      LOGICAL DEBUG,NEW
      COMMON /THETA/ TWOTH
      REAL TWOTH
      COMMON /FNAMES/ SPOTFL,MATNAME
      CHARACTER SPOTFL*100,MATNAME*80
C
C---- New common block sends back failure flag
C     IERRFLG = 1   Hard failure (no hope)
C             = 2   Soft failure...worth trying
C
chrp09072001      COMMON /ERRFLG/ IERRFLG
chrp09072001      INTEGER IERRFLG
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C
C---- Common blocks for passing results back to MOSFLM
C     RFAMAT contains A-matrix
C     RESLIST/RESLISTC contain list of 44 Laue groups
C
      COMMON /RFAMAT/ ASTV,BSTV,CSTV
      COMMON /RESLIST/ LATCH,P,CELLB,SDXY,SDPHI,IERR
      INTEGER*2 LATCH(44)
      REAL P(44),CELLB(6,44)
      REAL SDXY,SDPHI
      INTEGER IERR
      COMMON /RESLISTC/ BT
      CHARACTER*2  BT(44)
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/dsplyc.f
C
C $Id: dsplyc.f,v 1.1 2002/05/02 10:46:46 harry Exp $
C
C--- awk generated include file  dsplyc.h
C---- START of include file dsplyc.h
C
C*******************************************************************
C
C  COMMON  /DSPLYC/
C
C	IMGLOW, IMGHI	low & high values of 16-bit image for scaling
C			integer*2 to byte: IMGLOW maps to  0; 
C			IMGHI to maximum. Note that these are not
C			necessarily the actual limits of the data
C	JDSPWD		.LT. 0  before image window has been created
C                       = +-1 for image display that can be panned
C                       = +-2 for non-interactive image display
C       MAXDEN          highest level in colour table to fill up to
C                       must be less than ~240 - number of overlay colours
C       LDSPSG          if .true., treat image as signed, ie after dark
C                          subtraction
C                       if .false., treat image as unsigned
C       NZOOM           zoom factor for image, = 0 if no zoom
C       JYZOOM, JZZOOM  1st pixel in zoomed image
C
C----   WINOPEN Flag for whether or not window is open. Do not
C               confuse with DISPMENU (/CONDATA/)which is true if the run was
C               started with a IMAGE keyword.
C
C
C       CDSPTL          banner title
C
      INTEGER IMGLOW, IMGHI, JDSPWD, MAXDEN,
     $     NZOOM, JYZOOM, JZZOOM
      LOGICAL LDSPSG,WINOPEN,LPAUSE,LHELP
      COMMON /DSPLYC/ IMGLOW, IMGHI, JDSPWD,
     *     MAXDEN, NZOOM, JYZOOM, JZZOOM, LDSPSG,WINOPEN,LPAUSE,LHELP
C
      CHARACTER  CDSPTL*200
      COMMON /DSPLCC/  CDSPTL
C                                                           
C
C*******************************************************************


C&&*&& end_include  ../inc/dsplyc.f
C     ..
C     .. External Subroutines ..
      EXTERNAL CCPFYP,CCPDPN,CCPDAT,CCPOPN
C     ..
CAL      SAVE
      DATA         REIDX0/1,4*0,1,4*0,1,0/
      DATA   UDEF /1.0,0.0,0.0,  0.0,1.0,0.0,  0.0,0.0,1.0/
C
C
      DTR = ATAN(1.0)*4.0/180.0
      NEW = .TRUE.
C      NEW = .FALSE.
      LAST = .FALSE.
C
C
1010  FORMAT(
     +  ' ***** REFIX *****        ',A/,
     1  ' Space Group and Cell parameters are unknown'/)
1020  FORMAT(
     +  ' ***** REFIX *****        ',A/,
     1  ' Space Group Number ',I10/
     2  ' Initial unit Cell ',3F10.3,3F8.3/
     3  ' Reciprocal   Cell ',3F10.7,3F8.3/)
1030  FORMAT(/' Autoindexing is based on ',I7,
     + ' Observed Spot positions with I/sig(i) greater than',F8.0)
1040  FORMAT(/' ***** Determination of the Reduced Cell *****',/,
     1' Number of Difference Vector Clusters used       ',I12/
     2' Minimum allowed value of Reciprocal Cell Volume ',E12.4)
1050  FORMAT(
     1' Dimension of space spanned by difference vector clusters',I4/)
1060  FORMAT(' Parameters of the Reduced Cell (Angstroem & Degrees)'/
     @        6F10.2)
1070  FORMAT(/' Indices of difference vector clusters',
     1' With respect to reduced cell '/
     2'   #      Difference Vector Cluster   Frequency    ',
     3' Reduced Cell Indices')
1080  FORMAT(I5,1X,3F10.7,F10.0,3F10.2)
1090  FORMAT(/,
     + ' ***** Determination of Lattice character and Bravais',
     1 ' Lattice *****',/,
     2' Reference: International Tables for Crystallography Volume A,'/
     3'            Kluwer Academic Publishers, Dordrecht/Boston/London'/
     4'            Second, revised edition  1989, p. 746.'/
     5' Comments:  Low values for the "Quality of Fit", Typically ',/,
     6'  Below 20 Indicate that the corresponding Lattices with the',/,
     7'  listed Cell constants are compatible with the observed ',/,
     +'  diffraction spots.'//,
CAL The results for the 44 possible cases ',/,
CAL     +'  printed below are for your information and not used by XDS ',/,
CAL     +'  at this early stage of data processing.',//,
     B'  Lattice-  Bravais-   Quality  Unit Cell constants',
     C' (Angstroem & Degrees)  Reindexing card (Correct & GLOREF)'/
     D' Character  Lattice     of Fit',
     E'      a      b      c   alpha  beta gamma'/)
1100  FORMAT(I6,8X,A2,F13.1,F10.1,2F7.1,3F6.1,2X,12I3)
1110  FORMAT(//,
CAL     +' After all the individual program steps have been',/,
CAL     1' carried out successfully by "XDS" (COLPROF,PROFIT,CORRECT,',/,
CAL     2' GLOREF) you should come back and read this file again in',/,
CAL     3' case you do not know the space group and the cell constants',/,
CAL     4' of your crystal (as specified by a zero for IGROUP in',/,
CAL     +' "XDS.DATA"). 
     1 'Inspect the above table of Fit-values for each',/,
     6' possible Lattice and pick the one with highest lattice',/,
     7' Symmetry which has an acceptable Quality-of-Fit value.'/,
CAL     +' Use your editor to pick the appropriate line in this table',/,
CAL     +' and to move the cell constants and reindexing transformation',/,
CAL     +' to the proper location in "XDS.DATA".
     2' Do not forget to clean',
     +' the Cell constants if the Lattice Symmetry',/,1X,
     +'requires exact 90',
     +' or 120 degrees or a=b, etc.!!!')
1120  FORMAT(//,1X,'The possible space',
     +' Group numbers corresponding to each Bravais-type are ',/,
     +' given below for your convenience. For example the Bravais',/,
     +' type hP includes all Primitive Trigonal and Hexagonal ',/,
     +' space groups.')
CAL You have to try several different space ',/,
CAL     +' groups by running "CORRECT" and "GLOREF" and to compare ',/,
CAL     +' the output to find out which Symmetry elements are present',/,
CAL     +' and which are not. (do not forget to rename "correct.lp". ',/,
CAL     +' Otherwise it will be overwritten by the next run of ',
CAL     +' "CORRECT"!',/,
CALO     +' for example, a comparison of the results for Igroup=143 (P3)',/,
CAL     +' and Igroup=168 (P6) should clearly show whether you have a ',/,
CAL     +' Trigonal or Hexagonal space group. Except for the presence',/,
CAL     +' of Screw-Axes, at most 4 trials are sufficient to establish',/,
CAL     +' the correct Symmetry group. The presence or absence of',/,
CAL     +' Screw-Axes can be deduced from the intensities of the ',/,
CAL     +' reflections of type h00,0k0,00l listed in "correct.lp".')
1130  FORMAT(/
     1'Bravais-            Possible Space-groups for protein crystals'/
     2'  Type                     [Space group number,Symbol]'/
     3'  aP      [1,P1]'/'  mP      [3,P2] [4,P2(1)]'/
     4' mC,mI    [5,C2]'/'  oP      [16,P222] [17,P222(1)] ',
     5'[18,P2(1)2(1)2] [19,P2(1)2(1)2(1)]'/
     6'  oC      [21,C222] [20,C222(1)]'/'  oF      [22,F222]'/
     7'  oI      [23,I222] [24,I2(1)2(1)2(1)]'/'  tP      [75,P4] ',
     8'[76,P4(1)] [77,P4(2)] [78,P4(3)] [89,P422] [90,P42(1)2]'/10X,
     9'[91,P4(1)22] [92,P4(1)2(1)2] [93,P4(2)22] [94,P4(2)2(1)2]'/10X,
     A'[95,P4(3)22] [96,P4(3)2(1)2]')
1140  FORMAT('  tI      [79,I4] [80,I4(1)] ',
     B'[97,I422] [98,I4(1)22]'/'  hP      [143,P3] [144,P3(1)] ',
     C'[145,P3(2)] [149,P312] [150,P321] [151,P3(1)12]'/10X,
     D'[152,P3(1)21] [153,P3(2)12] [154,P3(2)21] [168,P6] [169,P6(1)]'/
     E10X,'[170,P6(5)] [171,P6(2)] [172,P6(4)] [173,P6(3)] [177,P622]'/
     F10X,'[178,P6(1)22] [179,P6(5)22] [180,P6(2)22] [181,P6(4)22] ',
     G'[182,P6(3)22]'/'  hR      [146,R3] [155,R32]'/'  cP      ',
     H'[195,P23] [198,P2(1)3] [207,P432] [208,P4(2)32] [212,P4(3)32]'/
     I10X,'[213,P4(1)32]'/
     J'  cF      [196,F23] [209,F432] [210,F4(1)32]'/
     K'  cI      [197,I23] [199,I2(1)3] [211,I432] [214,I4(1)32]'/)
1150  FORMAT(/' ***** Indexing of observed spots with respect to the',
     1' Reduced cell *****'/I8,' out of',I8,' Spots indexed.',
     2' Error code (0=No Error)',I5/)
1160  FORMAT(//' ***** Refined solution in Space Group P1 (#1) based',
     @' on the Reduced Cell *****')
1170  FORMAT(/' Refined values of diffraction parameters derived from',
     1I7,' Indexed spots'/
     2' Standard Deviation of Spot    Position (Pixels) ',F8.2/
     3' Standard Deviation of Spindle Position (Degrees)',F8.2/
     4' Detector Origin (Pixels) at',2F10.2/
     5' Crystal to Detector Distance (mm)',F10.2/
     6' Lab coordinates of Detector X-axis',3F10.6/
     7' Lab coordinates of Detector Y-axis',3F10.6/
     8' Direct Beam coordinates (rec. Angstroem) ',3F10.6/
     9' Coordinates of Unit Cell A-axis',3F10.3/
     A' Coordinates of Unit Cell B-axis',3F10.3/
     B' Coordinates of Unit Cell C-axis',3F10.3/
     C' Rec. Cell parameters ',3F10.6,3F8.3/
     D' Unit Cell parameters ',3F10.3,3F8.3/
     E' Standard Deviations  ',3F10.3,3F8.3/
     F' Space Group Number   ',I4/)
1180  FORMAT(//' ***** Refined solutions based on given',
     @' Cell constants and Space group *****')
1190  FORMAT(/' Solution #',I3,' Quality ',F8.5)
1200  FORMAT(/' ***** Diffraction parameters used at start of',
     @' integration *****')
1210  FORMAT(3F10.2,3I5)
1220  FORMAT(3F10.6/3(3F10.6/),3F10.3,3F10.6/3F10.6,3F10.3/
     @6F10.3/3(3F10.6/),3F10.5/6F10.6)
1230  FORMAT(/' !!! ERROR !!! Solution is Inaccurate.'/
     1' If the best solution is really nonsense you should  try'/
     2' increasing the THRESHOLD or check the direct beam coords'/
     3' Since the autoindexing algorithm is sensitive to origin',
     4' errors.')
1240  FORMAT(/' ***** Determination of Lattice character and Bravais',
     1' Lattice *****'/
     2' This is a repeat of the previous list now based on the',
     3' Refined cell constants.'//
     B'  Lattice-  Bravais-   Quality  Unit Cell constants',
     C' (Angstroem & Degrees)  Reindexing card (correct & gloref)'/
     D' Character  Lattice     of Fit',
     E'      a      b      c   alpha  beta gamma'/)
1250  FORMAT(/' !!! ERROR !!! Given cell constants too inaccurate.')
1260  FORMAT(I8, ' out of',I8,' spots accepted for initial refinement'/)
1270  FORMAT(/' Diffraction parameters after initial refinement'/
     1' standard deviation from integral reflection indices ',3F6.2/
     2' Detector Origin (not refined) at ',2F10.2,' Pixels'/
     3' Crystal to Detector Distance (not refined)',F10.2,' (mm)'/
     4' Lab coordinates of Detector X-axis (not refined)',3F10.6/
     5' Lab coordinates of Detector Y-axis (not refined)',3F10.6/
     6' Direct Beam coordinates (rec. Angstroem) ',3F10.6/
     7' Coordinates of Unit Cell A-axis',3F10.3/
     8' Coordinates of Unit Cell B-axis',3F10.3/
     9' Coordinates of Unit Cell C-axis',3F10.3/
     A' Rec. Cell parameters ',3F10.6,3F8.3/
     B' Unit Cell parameters ',3F10.3,3F8.3/
     C' Space Group Number   ',I4/)
C
C----  open all files 
C
CAL      CALL CCPFYP
CAL      LINOUT = 6
CAL      LP = 6
      XPARM = 16
C
C---- Open .lp file if running online
C
      IF (ONLINE) THEN
C
CAL        IFAIL = 1
CAL        LDUM =80
CAL        LP = 4
C
C            **********************************
CAL        CALL CCPDPN(-LP,'refix.lp','UNKNOWN','F',LDUM,IFAIL)
C            **********************************
C       
CAL        IF (IFAIL.EQ.-1) GOTO 430
      END IF
C
      PI = ATAN(1.0)*4.0
      DTOR = PI/180.0
C
C---- get current date
C
ccx         ZEIT = FDATE()
ccx      call date(zeit) replaced
               call ccpdat(ZEIT)
C
C---- read data cards
C
c      READ(CDR,*,ERR=440)FLAMDA,S0,ACHSE
c      READ(CDR,*,ERR=440)IGROUP,CELL
c      READ(CDR,*,ERR=440)Q,F,ORGX,ORGY,((ED(K,J),K=1,3),J=1,2)
c      READ(CDR,*,ERR=440)FIXF,DPHI,DXY
c      READ(CDR,*,ERR=440)CCX,CCY,CCOM,ROFF,TOFF,THRESH
c      CLOSE(CDR)
C
CAL      CALL READDAT
C---- Following initialisations were in READDAT
C
      BSEARCH = .FALSE.
      NPASS = 1
      XSEARCH = 0.0
      YSEARCH = 0.0
      XSTEP = 1.0
      YSTEP = 1.0
      IF (TWOTH.NE.0.0) THEN
        ED(1,1) = - SIN(TWOTH*DTR)
        ED(2,1) = COS(TWOTH*DTR)
        ED(3,1) = 0.0
      END IF
C
      IF (.NOT.BSEARCH) LAST = .TRUE.
C
C---- Open matrix output
C           
        IFAIL = 1
        LDUM =80
        MAT = 12
C
C            **********************************
        IF (BRIEF) THEN
          CALL CCPDPN(-MAT,MATNAME,'UNKNOWN','F',LDUM,IFAIL)
        ELSE
          CALL CCPDPN(MAT,MATNAME,'UNKNOWN','F',LDUM,IFAIL)
        END IF
C            **********************************
C
        IF (IFAIL .EQ. -1) GOTO 445
C
C---- If in BRIEF mode, open output file
C
CAL      IF (BRIEF) THEN
CAL         CALL CCPOPN(-IBRIEF,'MINIOUT',4,1,80,IFAIL)
CAL         WRITE(IBRIEF,FMT=6001)
CAL 6001    FORMAT(1X,'Program REFIX')
CAL      END IF
C
      IF (IGROUP.LT.1)THEN
	  IF (ONLINE)WRITE(LP,1010)ZEIT
	  WRITE (LINOUT,1010)ZEIT
      ELSE
	  CALL ABSHKL(IGROUP,CELL,ABSTYP)
	  CALL CRYSYS(IGROUP,CELL,ICS)
	  IF (ICS.LE.0)GO TO 490
	  CALL INVCEL(CELL,RCELL,VOLUME)
	  IF (VOLUME.LE.0.0)GO TO 500
	  IF (ONLINE) WRITE (LP,1020)ZEIT,IGROUP,CELL,RCELL
	  WRITE (LINOUT,1020)ZEIT,IGROUP,CELL,RCELL
      ENDIF
      IF (DPHI.LE.0.0)GO TO 510
      IF ((Q.LE.0.0).OR.(F.EQ.0.0))GO TO 520
      IF (DXY.LE.0.0)GO TO 420
      IF ((MXBEST.LT.1).OR.(MXBEST.GT.MXSPOT))GO TO 540
C
C---- get observed spots and find their recipr. space coordinates 
C
C---- calculate detector orientation matrix
C
      ED(1,3)=ED(2,1)*ED(3,2)-ED(2,2)*ED(3,1)
      ED(2,3)=ED(3,1)*ED(1,2)-ED(3,2)*ED(1,1)
      ED(3,3)=ED(1,1)*ED(2,2)-ED(1,2)*ED(2,1)
      CALL UNORM(ED,J)
      IF (J.NE.0)GO TO 520
C
C---- normalize incident beam wave-vector to 1/lambda
C
      R=FLAMDA*SQRT(S0(1)**2+S0(2)**2+S0(3)**2)
      IF (R.LE.0.0)GO TO 530
      DO 10 J=1,3      
        S0(J)=S0(J)/R
        SAVES0(J) = S0(J)
 10   CONTINUE
C
C---- normalize rotation axis
C
      R=SQRT(ACHSE(1)**2+ACHSE(2)**2+ACHSE(3)**2)
      IF (R.LE.0.0)GO TO 530
      DO 20 J=1,3
20    ACHSE(J)=ACHSE(J)/R 
C
C---- read list of strong spots
C---- Read spot list (rather spots.dat)
C
                LDUM = 80
                IFAIL = 1
C
C                    **********************************
                IF (BRIEF) THEN
          CALL CCPDPN(-SPOT,SPOTFL,'OLD','F',LDUM,IFAIL)
CAL          CALL CCPDPN(-2,'INDICES','UNKNOWN','F',LDUM,IFAIL)
                ELSE
          CALL CCPDPN(SPOT,SPOTFL,'OLD','F',LDUM,IFAIL)
CAL          CALL CCPDPN(2,'INDICES','UNKNOWN','F',LDUM,IFAIL)
                END IF
C                    **********************************
C
                  NRFL = 0
                  REWIND SPOT
                            
C                                                  
C----  Read in camera constants ccx,ccy
C      and the fiducial coordinates
C
715                 IF (NEW) THEN
                    READ (SPOT,FMT=*,END=40,ERR=460) IXLEN,IYLEN,
     +                PIXEL,YSCALE,OMEGA,INVFLAG,ISWUNG
                    Q = PIXEL
                    XOFF = 0.0
                    YOFF = 0.0
C
                    READ (SPOT,FMT=*,END=40,ERR=460) XCEN,YCEN
                    IF (INVFLAG.EQ.1) XCEN = IXLEN*PIXEL - XCEN
C
C---- Convert from scanner frame to MOSFLM detector frame
C
                    COSOM = COS(OMEGA*DTOR)
                    SINOM = SIN(OMEGA*DTOR)
                    XFN = XCEN*COSOM + YCEN*SINOM
                    YFN = -XCEN*SINOM + YCEN*COSOM
C
C---- If the direct beam coordinates supplied to IMSTILLS were those
C     for the swung-out detector, correct the X for the swing angle.
C     (The detector is assumed to be swung around an axis parallel
C     to the rotation axis). This is because REFIX expects the direct
C     beam coordinates for an un-swung detector.
C
                    IF (ISWUNG.EQ.1) THEN
                      XFN = XFN + F*TAN(TWOTH*DTR)
                    END IF
                    IF (DEBUG) WRITE(6,*) 'XCEN,YCEN,XFN,YFN,TWOTH',
     +               XCEN,YCEN,XFN,YFN,TWOTH
C
C---- Define detector centre neede for ROFF,TOFF corrections
C
                    XP = 0.5*IXLEN*PIXEL
                    YP = 0.5*IYLEN*PIXEL
                    XMID = XP*COSOM + YP*SINOM
                    YMID = -XP*SINOM + YP*COSOM
C
C---- Define direct beam coordinates
C
                    ORGX = XFN/Q
                    ORGY = YFN/Q  
C
                    ELSE
C
C---- OLD style spots file
C
                    READ (SPOT,FMT=*,END=40,ERR=460) XOFF,YOFF
                    XF = 0.0
                    YF = 0.0
C
C
                    DO 720 I = 1,3    
                      READ (SPOT,FMT=*,END=40,ERR=460) XFID(I),
     +                  YFID(I)
                      IF (I.NE.2) THEN
                        XF = XFID(I) + XF
                        YF = YFID(I) + YF
                      END IF
  720               CONTINUE
C
C---- Calculate tilt of cassette
C
                    OMEGA = ATAN2((YFID(3)-YFID(2)), (XFID(3)-XFID(2)))
                    IF (ONLINE) WRITE (LP,FMT=6000) OMEGA/DTOR
                    WRITE (LINOUT,FMT=6000) OMEGA/DTOR
C
C---- Allow for camera constants supplied by user
C
                    OMEGA = CCOM*DTOR + OMEGA
                    SXOFF = XOFF
                    SYOFF = YOFF
C
C----  Reset CCX, CCY if they have been supplied
C
                    IF (CCX.GT.-998.0) XOFF = CCX
                    IF (CCY.GT.-998.0) YOFF = CCY
                    WRITE (LINOUT,FMT=6002)
                    IF (ONLINE) WRITE (LP,FMT=6002)
                    IF (ONLINE) WRITE (LP,FMT=6004)XOFF,YOFF,OMEGA/DTOR
                    IF (ONLINE) WRITE (LP,FMT=6006) SXOFF,SYOFF
                    WRITE (LINOUT,FMT=6006) SXOFF,SYOFF
C
 6000 FORMAT (/1X,'Film Tilt',F6.1,' Degrees')
 6002 FORMAT (/1X,'The camera constants supplied will override those ',
     +       'present in the SPOTS file')
 6004 FORMAT (/1X,'Camera constants used:',/1X,'CCX ',F6.3,'mm  CCY',
     +       F6.3,'mm  combined tilt and ccomega',F7.3,' degrees')
 6006 FORMAT (1X,'(Camera constants in SPOTS file are: CCX ',F6.3,
     +       'mm ',' CCY',F6.3,'mm)')
C
C
                  COSOM = COS(OMEGA)
                  SINOM = SIN(OMEGA)
C
C---- Correct film centre and camera constants for cassette tilt.
C
                  XOFFN = XOFF*COSOM + YOFF*SINOM
                  YOFFN = -XOFF*SINOM + YOFF*COSOM
                  XFN = XF*COSOM + YF*SINOM
                  YFN = -XF*SINOM + YF*COSOM
C                     
C
C---- Define film centre
C
                    ORGX = 0.5*XFN/Q
                    ORGY = 0.5*YFN/Q
C
C---- END of IF NEW block
C
                  END IF
C
   30 CONTINUE
      IF (NEW) THEN
        READ(SPOT,*,END=40,ERR=460)X,Y,Z,PHI,FINT,SDI
        IF (SDI.GT.0) RAT = FINT/SDI
      ELSE
        READ(SPOT,*,END=40,ERR=460)X,Y,Z,PHI,FINT
        RAT = FINT
      END IF
C
C---- Note terminator at end of one image is -99, at end of file is -999
C
      IF (X.GE.-900.0) THEN
        IF (X.LT.-98.0) THEN
C
C---- New image
C
           GO TO 715
        ELSE IF (RAT.LT.THRESH) THEN
           GO TO 30
        ELSE
           IF (NEW) THEN
             IF (INVFLAG.EQ.1) X = IXLEN*PIXEL - X
C
C---- Convert from scanner frame to MOSFLM detector frame
C
             XN = (X*COSOM + Y*SINOM)
             YN = (-X*SINOM + Y*COSOM)
             XP = XN - XMID
             YP = YN - YMID
             RADBS = SQRT(XP*XP + YP*YP)
             IF (DEBUG.AND.(NRFL.LE.10)) WRITE(6,*) 'X,Y,RADBS'
     +                                     ,X,Y,RADBS
             PSI = ATAN2(XP,YP)
             CPSI = COS(PSI)
             SPSI = SIN(PSI)
             X = (XN+TOFF*CPSI-ROFF*SPSI)/Q
             Y = (YN-TOFF*SPSI-ROFF*CPSI)/Q
           ELSE
C
C---- Correct for CCOMEGA and tilt
C
             XN = X*COSOM + Y*SINOM
             YN = -X*SINOM + Y*COSOM
C
C---- Correct for camera constants CCX, CCY and distortion parameters
C     ROFF,TOFF
C
             XP = XN-0.5*XFN
             YP = YN-0.5*YFN
             RADBS = SQRT(XP*XP + YP*YP)
             PSI = ATAN2(XP,YP)
             CPSI = COS(PSI)
             SPSI = SIN(PSI)
             X = (XN+TOFF*CPSI-ROFF*SPSI-XOFFN)/Q
             Y = (YN-TOFF*SPSI-ROFF*CPSI-YOFFN)/Q
           END IF
           IF (NRFL.LT.MXRFL) THEN
             NRFL=NRFL+1
             IX(NRFL)=NINT(X*10.0)
             IY(NRFL)=NINT(Y*10.0)
C
C--- Debug code to check DPS stuff - remove at will
C
             if(debug)then
                if((nrfl.le.1))then
                   write(linout,1708)
                   if(online)write(*,1708)
                endif
                if((nrfl.le.10))then
                write(linout,1707)xp,yp,xn,yn,xfn,yfn,xmid,ymid,
     $               Roff,toff,cpsi,spsi,
     $               ix(nrfl),iy(nrfl)
                if(online)
     $               write(*,1707)xp,yp,xn,yn,xfn,yfn,xmid,ymid,
     $               Roff,toff,cpsi,spsi,
     $               ix(nrfl),iy(nrfl)
                endif
C     
 1707           format(12F8.2,I8,2X,I8)
 1708       FORMAT('    XP       YP     XN      YN     XFN    ',
     $           ' YFN     XMID    YMID    ROFF    TOFF   ',
     $           'CPSI     SPSI    IX(NRFL)',
     $           ' IY(NRFL)')
             ENDIF
C
C--- end of debug code to check DPS stuff - remove at will
C
31           IF (PHI.LE.180.0)GO TO 32
             PHI=PHI-360.0
             GO TO 31                            
32           IF (PHI.GE.-180.0)GO TO 33
             PHI=PHI+360.0
             GO TO 32
33           IPHI(NRFL)=NINT(PHI*100.0)
             IF (BSEARCH) THEN
               IXST(NRFL) = IX(NRFL)
               IYST(NRFL) = IY(NRFL)
               IPHIST(NRFL) = IPHI(NRFL)
               IRADST(NRFL) = 10.0*RADBS
             END IF
             IH(NRFL)=0
             IK(NRFL)=0
             IL(NRFL)=0
             GO TO 30
           ENDIF
         ENDIF
      ELSE
C
C---- Terminator (-999) read, now read final record on file
C     containing image size, pixel size and image inversion flag
C     written by IMSTILLS. This is needed so that REFIX can output
C     the correct direct beam coordinates
C
        READ (SPOT,FMT=*,END=40,ERR=460) IXLEN,IYLEN,
     +                                           PIXEL,INVFLAG
      ENDIF 
C
40    CLOSE(SPOT)
      IF (NRFL.LT.25)GO TO 550
      NRFLS = NRFL
C
C---- calculate transformation from pixel to MM
C
      CALL RFPXTOMM(Q,F,ED,AA)
C
C---- If doing direct beam search and there are more spots than
C     needed for search, choose those with smallest radius
C
      IF (BSEARCH.AND.(NRFL.GT.NSPOTSR)) THEN
C
C---- Sort on radius
C
        CALL SORTUP2(NRFL,IRADST,IORD)
C
C---- Move spots with lowest radius into IX,IY,IPHI
C
        DO 42 I = 1,NSPOTSR
          IORDI = IORD(I)
          IX(I) = IXST(IORDI)
          IY(I) = IYST(IORDI)
          IPHI(I) = IPHIST(IORDI)
 42     CONTINUE
        NRFL = NSPOTSR
      END IF
C---- Loop over possible direct beam positions
C
      IF (XSTEP.EQ.0) XSTEP = 0.01
      IF (YSTEP.EQ.0) YSTEP = 0.01
      NXSTEP = 2*NINT(XSEARCH/XSTEP) + 1
      NYSTEP = 2*NINT(YSEARCH/YSTEP) + 1
      NTOT = NXSTEP*NYSTEP
      IF (NTOT.GT.NSRCH) THEN
        IF (ONLINE) WRITE (LP,FMT=6070) NTOT,NSRCH
        WRITE(LINOUT,FMT=6070) NTOT,NSRCH
 6070   FORMAT(1X,'With the given search distances and step sizes',
     +        ' a total of',I3,' searches',/,1X,'would be required',
     +        ' which exceeds the current limit of',I3,/,1X,
     +        'Either decrease the search distance or increase the',
     +        ' step size,',/,1X,'or change the parameter NSRCH in',
     +        ' the source code and recompile the program')
      END IF
C
      IF (ONLINE) WRITE (LP,1030)NRFL,THRESH
      WRITE (LINOUT,1030)NRFL,THRESH                
      IF (BSEARCH) THEN
        ORGXSTART = ORGX - (NXSTEP/2)*XSTEP/Q
        ORGYSTART = ORGY - (NYSTEP/2)*YSTEP/Q
      ELSE
        ORGXSTART = ORGX
        ORGYSTART = ORGY
      END IF
      IGROUPS = IGROUP
C
      DO 860 IPASS = 1,NPASS
        NSOL = 0
        IF (IPASS.GT.1) THEN
          XSTEP = XSTEP*DAMP
          YSTEP = YSTEP*DAMP
          ORGXSTART = SORGX(ISBEST) - (NXSTEP/2)*XSTEP/Q
          ORGYSTART = SORGY(ISBEST) - (NYSTEP/2)*YSTEP/Q
        END IF
 800    DO 850 IXBS = 1,NXSTEP
          ORGX = ORGXSTART + (IXBS-1)*XSTEP/Q
        DO 840 IYBS = 1,NYSTEP
          ORGY = ORGYSTART + (IYBS-1)*YSTEP/Q
          NSOL = NSOL + 1
          IER = 0
          IF (DEBUG) WRITE(6,*) 'IPASS,IX,IY,ORGX,ORGY',
     +                     IPASS,IXBS,IYBS,ORGX,ORGY
        DO 44 I = 1,NRFL
          IH(I)=0
          IK(I)=0
          IL(I)=0
 44     CONTINUE
        DO 46 I = 1,3
          S0(I) = SAVES0(I)
 46     CONTINUE
        IGROUP = IGROUPS
C
C---- calculate transformation from pixel to MM
C
      CALL RFPXTOMM(Q,F,ED,AA)
C
C---- Direct output to unit 10
        IF (BSEARCH.AND.(.NOT.LAST))  LINOUT = 10
        IF (DEBUG) WRITE(6,*) 'IPASS,SO',IPASS,S0
        IF (DEBUG) WRITE(6,*) 'IPASS,ED',IPASS,ED
        IF (DEBUG) WRITE(6,*) 'IPASS,F',IPASS,F
C
C---- calculate pixel coordinates of direct beam
C
      X=ED(1,1)*S0(1)+ED(2,1)*S0(2)+ED(3,1)*S0(3)
      Y=ED(1,2)*S0(1)+ED(2,2)*S0(2)+ED(3,2)*S0(3)
      Z=ED(1,3)*S0(1)+ED(2,3)*S0(2)+ED(3,3)*S0(3)
      IF (Z.EQ.0.0)GO TO 530
      R=F/(Q*Z)
      X=ORGX+R*X
      Y=ORGY+R*Y
C
C---- calculate laboratory coordinates of observed spots at phi=0
C
      if (debug) WRITE(6,*) 'rad100,orgx,orgy',rad100,orgx,orgy
      if (debug) WRITE(6,*) 'coords spot 1',IX(1),IY(1),IPHI(1)
      if (debug) WRITE(6,*) 'coords spot 2',IX(2),IY(2),IPHI(2)
      if (debug) WRITE(6,*) 'coords spot 3',IX(3),IY(3),IPHI(3)
      IF (DEBUG) WRITE(6,*) 'AA',AA
      IF (DEBUG) WRITE(6,*) 'ACHSE',ACHSE
      DO 60 NV=1,NRFL
      R=IPHI(NV)/RAD100
      CPHI=COS(R)
      SPHI=SIN(R)                  
      RX=IX(NV)/10.0-ORGX
      RY=IY(NV)/10.0-ORGY
      X=AA(1,1)*RX+AA(1,2)*RY+AA(1,3)
      Y=AA(2,1)*RX+AA(2,2)*RY+AA(2,3)
      Z=AA(3,1)*RX+AA(3,2)*RY+AA(3,3)
      R=SQRT(X*X+Y*Y+Z*Z)*FLAMDA
      IF (R.LE.0.0)GO TO 50
      X=X/R-S0(1)
      Y=Y/R-S0(2)
      Z=Z/R-S0(3)
      R=(X*ACHSE(1)+Y*ACHSE(2)+Z*ACHSE(3))*(1.0-CPHI)
50    V(1,NV)=X*CPHI+R*ACHSE(1)-SPHI*(ACHSE(2)*Z-ACHSE(3)*Y)
      V(2,NV)=Y*CPHI+R*ACHSE(2)-SPHI*(ACHSE(3)*X-ACHSE(1)*Z)
      V(3,NV)=Z*CPHI+R*ACHSE(3)-SPHI*(ACHSE(1)*Y-ACHSE(2)*X)
60    CONTINUE
C
C---- explain observed spots by a reduced triclinic cell 
C
C----- Empirical estimated standard deviation of spot position (PIXELS)
C
      SDXY0=DXY
C
C----- empirical estimated standard deviation of spindle position (DEG.)
C
      SDPHI0=DPHI
C
C----- set minimum separation between diffraction spots (pixels)
C
      SEPMIN=6.0
C
C----- set grid size in reciprocal space
C
      GRID=ABS(Q/(F*FLAMDA))
C
C----- set minimum allowed volume of reciprocal cell
C
      VOLMIN=0.5*(GRID*SEPMIN)**3
C
C----- set size of search box for catching difference vector clusters
C
      NBXYZ=NINT(SEPMIN/2.0)
C
C----- find most frequent differences of laboratory coordinates
C      of observed spots.
C
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL DIFVEC(NRFL,V,GRID,SEPMIN,MXSPOT,NBXYZ,MXY,MZ,TABLE,VC,
     @            WEIGHT,NSPOT)
      IF (ONLINE) WRITE (LP,1040)NSPOT,VOLMIN
      IF (NSPOT.LT.3) THEN
        IF (BSEARCH) THEN
          IF (DEBUG) WRITE(6,*) 'Failed after DIFVEC'
          SDXY = 99.0/Q
          SDPHI = 99
          GOTO 390
        ELSE
          GO TO 560
        END IF
      END IF
C
C----- find basis in the set of observed difference vector clusters
C
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL REDUCE(VOLMIN,ERRINT,MAXIDX,NSPOT,VC,WEIGHT,RBASIS,IRANK)
      IF (DEBUG) THEN
        WRITE(LP,FMT=6060) ((RBASIS(I,J),I=1,3),J=1,3)
        WRITE(LINOUT,FMT=6060) ((RBASIS(I,J),I=1,3),J=1,3)
 6060   FORMAT(/,1X,'*** Basis vectors ***',/,3(1X,3F12.6))
      END IF
      IF (ONLINE) WRITE (LP,1050)IRANK
      IF (IRANK.NE.3)GO TO 130
C
C----- find a primitive reduced cell
C
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL REDZEL(0,RBASIS,B,IER )
      IF (DEBUG) THEN
        WRITE(LP,FMT=6062) ((RBASIS(I,J),J=1,3),I=1,3)
        WRITE(LINOUT,FMT=6062) ((RBASIS(I,J),J=1,3),I=1,3)
 6062   FORMAT(/,1X,'*** Reduced cell ***',/,3(1X,3F12.6))
      END IF
      IF (IER.NE.0)GO TO 570
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL FITZEL(B,LATCH,BT,IDXB,CELLB,P,IER)
      IF (IER.NE.0)GO TO 570
      IF (P(44).LT.P(31))THEN
C
C---- reduced cell is of type ii
C
	 L=44
      ELSE
C
C---- reduced cell is of type i
C
	 L=31
      ENDIF
C
C----- get basis vectors of the reduced cell
C
      K=0
      DO 110 J=1,3
      DO 100 I=1,3
100   BASIS(J,I)=
     @    B(1,I)*IDXB(K+1,L)+B(2,I)*IDXB(K+2,L)+B(3,I)*IDXB(K+3,L)
110   K=K+4
C
C----- get reciprocal basis vectors of the reduced cell
C
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL INVERS(BASIS,RBASIS,VOLUME)
      IF (VOLUME.LE.0.0)GO TO 570
C
C----- get cell constants of the primitive triclinic reduced cell
C
      DO 120 I=1,6
120   PCELL(I)=CELLB(I,L)
      IF (ONLINE) WRITE (LP,1060)PCELL
C
C----- index difference vector clusters
C
130   IF (ONLINE) WRITE (LP,1070)
      IF (DEBUG) WRITE(LINOUT,1070)
      DO 150 L=1,NSPOT
      DO 140 J=1,3
      P(J)=0.0
      IF (IRANK.NE.3)GO TO 140
      P(J)=BASIS(J,1)*VC(1,L)+BASIS(J,2)*VC(2,L)+BASIS(J,3)*VC(3,L)
140   CONTINUE
      IF (ONLINE) WRITE (LP,1080)L,(VC(J,L),J=1,3),WEIGHT(L),
     +   (P(J),J=1,3)
      IF (DEBUG) WRITE (LINOUT,1080)L,(VC(J,L),J=1,3),WEIGHT(L),
     +   (P(J),J=1,3)
 150  CONTINUE
      IF (IRANK.LT.3) THEN
        IF (BSEARCH) THEN
          IF (DEBUG) WRITE(6,*) 'Failed rank.lt.3'
          SDXY = 99.0/Q
          SDPHI = 99
          GOTO 390
        ELSE
          GO TO 560
        END IF
      END IF
C
C----- test the 44 lattice characters against the observed reduced cell
C
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL FITZEL(BASIS,LATCH,BT,IDXB,CELLB,P,IER)
      IF (IER.NE.0)GO TO 570
      IF (LAST) WRITE(LINOUT,1090)
      IF (ONLINE) WRITE (LP,1090)
      DO 160 J=1,44
        IF (ONLINE) WRITE (LP,1100)
     +        LATCH(J),BT(J),P(J),(CELLB(K,J),K=1,6),(IDXB(K,J),K=1,12)
        IF (LAST) WRITE(LINOUT,1100)
     +        LATCH(J),BT(J),P(J),(CELLB(K,J),K=1,6),(IDXB(K,J),K=1,12)
 160  CONTINUE
      IF (IGROUP.LT.1)THEN
	  IF (ONLINE) WRITE (LP,1110)
	  IF (ONLINE) WRITE (LP,1120)
	  IF (ONLINE) WRITE (LP,1130)
	  IF (ONLINE) WRITE (LP,1140)
          IF (LAST) THEN
	    WRITE(LINOUT,1110)
  	    WRITE(LINOUT,1120)
	    WRITE(LINOUT,1130)
       	    WRITE(LINOUT,1140)
          ENDIF
      ENDIF
C
C----- index observed spots with respect to reduced cell
C
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL GRIDIDX(NRFL,V,RBASIS,ERRINT,MAXIDX,IP,IQ,IW,IH,IK,IL,NACC)
      IF (ONLINE) WRITE (LP,1150)NACC,NRFL,IER
      IF (IER.LT.0) THEN
        IF (BSEARCH) THEN
          IF (DEBUG) WRITE(6,*) 'Failed after grididx'
          SDXY = 99.0/Q
          SDPHI = 99
          GOTO 390
        ELSE
          GO TO 560
        END IF
      END IF
      IF (NACC.LT.25)THEN
        IF (BSEARCH) THEN
          IF (DEBUG) WRITE(6,*) 'Failed nacc.lt.25, nacc=',nacc
          SDXY = 99.0/Q
          SDPHI = 99
          GOTO 390
        ELSE
          GO TO 550
        END IF
      END IF
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL PREREF(Q,ORGX,ORGY,F,ED,FLAMDA,ACHSE,NRFL,IX,IY,IPHI,
     @            IH,IK,IL,V,MIDX,SDIDX,S0,RBASIS,NACC)
      IF (ONLINE) WRITE (LP,1260)NACC,NRFL
      IF (NACC.EQ.0) THEN
        IF (BSEARCH) THEN
          IF (DEBUG) WRITE(6,*) 'Failed after preref'
          SDXY = 99.0/Q
          SDPHI = 99
          GOTO 390
        ELSE
          GO TO 550
        END IF
      END IF
      IF (NACC.EQ.-1)GO TO 480
      IF (NACC.LT.-1)GO TO 600
      CALL INVERS(RBASIS,BASIS,VOLUME)
      IF (VOLUME.LE.0.0)GO TO 570
C
C----- get cell constants of the primitive triclinic reduced cell
C
      CALL METRIC(BASIS,PCELL,IER)
      IF (IER.NE.0)GO TO 570
C
C----- get reciprocal primitive reduced cell
C
      CALL INVCEL(PCELL,RPCELL,VOLUME)
      IF (VOLUME.LE.0.0)GO TO 570
      IF (ONLINE) WRITE (LP,1270)SDIDX,ORGX,ORGY,F,
     +    (ED(K,1),K=1,3),(ED(K,2),K=1,3),
     +              S0,((BASIS(K,J),J=1,3),K=1,3),RPCELL,PCELL,1
C
C----- calculate setting matrix of reciprocal reduced cell
C
      CALL RFSETMAT(RPCELL,A)
C
C----- get initial orientation matrix of reciprocal reduced cell
C
      CALL RFMATMUL(A,BASIS,B)
      CALL INVERS(B,U,VOLUME)
      IF (VOLUME.LE.0.0)GO TO 570
C
C----- refine all parameters
C
      IF (FIXF.GT.0)THEN
	 IC=5
      ELSE
	 IC=4
      ENDIF
      ICS=1
      IF (FIXCELL) ICS = 0
      SDPHI=SDPHI0
      SDXY =SDXY0
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL REFINE(NCYCLE,REIDX0,NRFL,IH,IK,IL,IX,IY,IPHI,ACHSE,IC,ICS,
     @            Q,ORGX,ORGY,F,S0,ED,U,RPCELL,SDU,SDCELL,SDPHI,SDXY,
     +            IERR)
      IF (ONLINE) WRITE (LP,1160)
      IF (IERR.LE.0)GO TO 580
      CALL INVCEL(RPCELL,PCELL,VOLUME)
      IF (VOLUME.LE.0.0)GO TO 570
      CALL RFSETMAT(RPCELL,A)
      CALL RFMATMUL(U,A,RBASIS)
      CALL INVERS(RBASIS,BASIS,VOLUME)
      IF (VOLUME.LE.0.0)GO TO 570
      IF (ONLINE) WRITE (LP,1170)IERR,SDXY,SDPHI,ORGX,ORGY,F,
     1(ED(K,1),K=1,3),(ED(K,2),K=1,3),S0,
     2((BASIS(K,J),J=1,3),K=1,3),RPCELL,PCELL,SDCELL,1
      WRITE(LINOUT,1170)IERR,SDXY,SDPHI,ORGX,ORGY,F,
     1(ED(K,1),K=1,3),(ED(K,2),K=1,3),S0,
     2((BASIS(K,J),J=1,3),K=1,3),RPCELL,PCELL,SDCELL,1
C      
      IF (IGROUP.GT.0)GO TO 180
      NBEST=1
      IGROUP=1
      ABSTYP=0
      DO 170 J=1,6
      CELL(J)=PCELL(J)
170   RCELL(J)=RPCELL(J)
      GO TO 320
C
C---- derive and refine all diffraction parameters based 
C     on the given cell constants and space group       
C
180   IF (ONLINE) WRITE (LP,1180)
C
C---- get constraint number of general systematic absences
C
      CALL ABSHKL(IGROUP,CELL,ABSTYP)
C
C---- get cystal system number
C
      CALL CRYSYS(IGROUP,CELL,ICS)
      IF (ICS.LT.1)GO TO 490
      IF (FIXCELL) ICS = 0
C
C---- get operators of laue-group
C
      CALL LAUESY(CELL,IGROUP,NEQL,MLAUE)
      IF ((NEQL.LT.1).OR.(NEQL.GT.24))GO TO 490
C
C---- GET RECIPROCAL CELL
C
      CALL INVCEL(CELL,RCELL,VOLUME)
      IF (VOLUME.LE.0.0)GO TO 500
      CALL RFSETMAT(RCELL,AA)
C
C---- get possible orientations of unit cell
C
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL BASIDX(ABSTYP,NEQL,MLAUE,RCELL,BASIS,ERRZEL,MXBEST,NBEST,
     @            ESD,IDX,UB)
      IF (NBEST.EQ.0) THEN
        IF (BSEARCH) THEN
          IF (DEBUG) WRITE(6,*) 'Failed after basidx, NBEST=',NBEST
          SDXY = 99.0/Q
          SDPHI = 99
          GOTO 390
        ELSE
          GO TO 590
        END IF
      END IF
      IF (NBEST.LT.0) THEN
        IF (BSEARCH) THEN
          IF (DEBUG) WRITE(6,*) 'Failed after basidx, NBEST=',NBEST
          SDXY = 99.0/Q
          SDPHI = 99
          GOTO 390
        ELSE
          IERRFLG = 1
          GO TO 560
        END IF
      END IF
C
C---- refine all parameters for each of the nbest solutions
C
      DO 240 IBEST=1,NBEST
C
C----- set starting values of parameters
C
      DO 190 J=1,6
      RCELL0(J)=RCELL(J)
190   SDCELL(J)=0.0
      DO 200 J=1,3
      S00(J)=S0(J)
      DO 200 K=1,3
      ED0(J,K)=ED(J,K)
200   U(J,K)=UB(J,K,IBEST)
      DO 210 L=1,12
210   REIDX(L)=IDX(L,IBEST)
      ORGX0=ORGX
      ORGY0=ORGY
      F0=F
      SDPHI=SDPHI0
      SDXY =SDXY0
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL REFINE(NCYCLE,REIDX,NRFL,IH,IK,IL,IX,IY,IPHI,ACHSE,IC,ICS,Q,
     @      ORGX0,ORGY0,F0,S00,ED0,U,RCELL0,SDU,SDCELL,SDPHI,SDXY,IERR)
      NACCB(IBEST)=IERR
      ESDU(IBEST)=SDU
      ESDXY(IBEST)=SDXY
      ESDPHI(IBEST)=SDPHI
      ORGXB(IBEST)=ORGX0
      ORGYB(IBEST)=ORGY0
      FB(IBEST)=F0
      CALL RFSETMAT(RCELL0,A)
      R=0.0
      DO 220 J=1,3
      S0B(J,IBEST)=S00(J)
      DO 220 K=1,3
      EDB(J,K,IBEST)=ED0(J,K)
      UB(J,K,IBEST)=U(J,K)
220   R=R+(A(J,K)-AA(J,K))**2
      RMS(IBEST)=SQRT(R)
      DO 230 J=1,6
      ESDCEL(J,IBEST)=SDCELL(J)
230   RCELLB(J,IBEST)=RCELL0(J)
240   CONTINUE
C
C---- sort solutions in decreasing quality
C
      NACC=-1
      SDXY=1.0E+06
      SDPHI=1.0E+06
      R=AMAX1(RMS(1),1.0)
      DO 250 J=1,NBEST
      IF (NACCB(J).LE.0)GO TO 250
      IF (NACCB(J).GT.NACC)NACC=NACCB(J)
      IF ((ESDXY(J).GE.0.0).AND.(ESDXY(J).LT.SDXY))SDXY=ESDXY(J)
      IF ((ESDPHI(J).GE.0.0).AND.(ESDPHI(J).LT.SDPHI))SDPHI=ESDPHI(J)
      IF (RMS(J).LT.R)R=RMS(J)
250   CONTINUE
      Z=AMIN1(RCELL(1),RCELL(2),RCELL(3))*0.05
      DO 260 J=1,NBEST
      X=((NACCB(J)-NACC)/(NACC+2.0))**2+
     +   ((ESDXY(J)-SDXY)/(SDXY+0.01))**2
     +   +((ESDPHI(J)-SDPHI)/(SDPHI+0.01))**2+0.1*((RMS(J)-R)/(R+Z))**2
      VC(1,J)=J
260   WEIGHT(J)=-X
      CALL QSORT2(NBEST,VC,WEIGHT)
C
C---- print results
C
      DO 290 L=1,NBEST
      IBEST=NINT(VC(1,L))
      IF (ONLINE) WRITE (LP,1190)L,RMS(IBEST)
      DO 270 J=1,6
270   RCELL(J)=RCELLB(J,IBEST)
      CALL INVCEL(RCELL,CELL,VOLUME)
      DO 280 J=1,3
      DO 280 K=1,3
280   U(J,K)=UB(J,K,IBEST)
      CALL RFSETMAT(RCELL,A)
      CALL RFMATMUL(U,A,B)
      CALL INVERS(B,A,VOLUME)
290   IF (ONLINE) WRITE (LP,1170)NACCB(IBEST),ESDXY(IBEST),
     +   ESDPHI(IBEST),
     1  ORGXB(IBEST),ORGYB(IBEST),FB(IBEST),(EDB(K,1,IBEST),K=1,3),
     2  (EDB(K,2,IBEST),K=1,3),(S0B(J,IBEST),J=1,3),
     3  ((A(K,J),J=1,3),K=1,3),RCELL,CELL,(ESDCEL(J,IBEST),J=1,6),
     +   IGROUP
C
C---- assign best values for parameters orgx,orgy,f,rcell,u,sdxy,etc.
C
      IF (NACC.LT.1)GO TO 360
      IBEST=VC(1,1)
      ORGX=ORGXB(IBEST)
      ORGY=ORGYB(IBEST)
      F=FB(IBEST)
      SDPHI=ESDPHI(IBEST)
      SDXY=ESDXY(IBEST)
      SDU=ESDU(IBEST)
      DO 300 J=1,6
      RCELL(J)=RCELLB(J,IBEST)
300   SDCELL(J)=ESDCEL(J,IBEST)
      DO 310 J=1,3
      S0(J)=S0B(J,IBEST)
      DO 310 K=1,3
      ED(J,K)=EDB(J,K,IBEST)
310   U(J,K)=UB(J,K,IBEST)
C
C---- attach indices to the list of observed spots using 
C     the diffraction parameters from the best solution. 
C
C---- index all spots
C
320   NRFL0=0
      NRFL1=NRFL
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      CALL INDIX(ABSTYP,Q,ORGX,ORGY,F,ED,ACHSE,S0,RCELL,U,MXRFL,
     @NRFL0,NRFL,IX,IY,IPHI,IH,IK,IL,NACC,NOVLAP,NFAR,SDPHI,SDXY)
      SDPHI=SDPHI0
      SDXY =SDXY0
      IF (WINOPEN) CALL XDLF_FLUSH_EVENTS(I)
      if(debug)then
         do 1998 i=1,10
            write(linout,fmt='(2i8,1x,3i4)')ix(i),iy(i),ih(i),ik(i),
     $           il(i)
 1998    continue
         print*,'REFINE in'
         write(*,1999)NCYCLE,REIDX0,NRFL1,ACHSE,IC,ICS,
     @        Q,ORGX,ORGY,F,S0,((ED(I,J),J=1,3),I=1,3),
     $        ((U(I,J),J=1,3),I=1,3),RCELL,CELL,SDU,SDCELL,SDPHI,
     +        SDXY,IERR
         write(linout,*)'REFINE in'
         write(linout,1999)NCYCLE,REIDX0,NRFL1,ACHSE,IC,ICS,
     @        Q,ORGX,ORGY,F,S0,((ED(I,J),J=1,3),I=1,3),
     $        ((U(I,J),J=1,3),I=1,3),RCELL,CELL,SDU,SDCELL,SDPHI,
     +        SDXY,IERR
         write(*,1996)astv,bstv,cstv
         write(linout,1996)astv,bstv,cstv
 1999    format('NCYCLE = ',i2,/,'REIDX0 = ',4i2,2(/,9X,4I2),/,
     $        'NREF = ',i5,/,'ACHSE = ',3F5.2,/,
     $        'IC = ',i2,'   ICS = ',i2,'   RAST = ',F8.4,/,
     $        'ORGX = ',F8.2,'  ORGY = ',F8.2,'    XTD = ',F8.2,/,
     $        'S0L = ',3F12.6,/,'ED = ',3F5.2,2(/,5X,3F5.2),/,
     $        'UMAT = ',3F10.6,2(/,7X,3F10.6),/,'RCELL = ',
     $        3f10.7,1X,3F9.4,/,'CELL =  ',6f9.4,/,'SDU = ',f10.6,/,
     $        'SDCELL = ',6F10.4,/,'SDPHI = ',F10.6,'    SDXY = ',F10.6,
     $        '  IERR = ',I4)
      endif
         CALL REFINE(NCYCLE,REIDX0,NRFL1,IH,IK,IL,IX,IY,IPHI,ACHSE,IC,
     @        ICS,Q,ORGX,ORGY,F,S0,ED,U,RCELL,SDU,SDCELL,SDPHI,SDXY,
     $     IERR)
         if(debug)then
            print*,'REFINE out'
            write(*,1999)NCYCLE,REIDX0,NRFL1,ACHSE,IC,ICS,
     @           Q,ORGX,ORGY,F,S0,((ED(I,J),J=1,3),I=1,3),
     $           ((U(I,J),J=1,3),I=1,3),RCELL,CELL,SDU,SDCELL,SDPHI,
     +           SDXY,IERR
            write(linout,*)'REFINE out'
            write(linout,1999)NCYCLE,REIDX0,NRFL1,ACHSE,IC,ICS,
     @           Q,ORGX,ORGY,F,S0,((ED(I,J),J=1,3),I=1,3),
     $           ((U(I,J),J=1,3),I=1,3),RCELL,CELL,SDU,SDCELL,SDPHI,
     +           SDXY,IERR
         endif
      IF (IERR.LE.0)GO TO 580
      CALL INVCEL(RCELL,CELL,VOLUME)
      CALL RFSETMAT(RCELL,A)
      CALL RFMATMUL(U,A,B)
      CALL INVERS(B,A,VOLUME)
C
C---- add stuff here to calc. missets
C
      CALL INVCEL(RCELL,CELL,VOLUME)
      CALL RFCROSS(A,ASTV,BSTV,CSTV,VOLUME,FLAMDA)
      write(*,1996)astv,bstv,cstv
      write(linout,1996)astv,bstv,cstv
 1996 format('AMAT = ',3F10.6,2(/,7X,3F10.6))
C
C---- If a target matrix was given, find permutation of the UMAT
C     which is closest to it.
C
C                 ***************************
      IF (TARGET) CALL RTUMAT(ASTV,BSTV,CSTV)
C                 ***************************
C
C
C--- Calculate direct beam coordinates in MOSFLM frame
C
      XBEAM = (ORGX*COSOM - ORGY*SINOM)*Q
      YBEAM =  (ORGX*SINOM + ORGY*COSOM)*Q
      IF (INVFLAG.EQ.1) XBEAM = IXLEN*PIXEL - XBEAM
      IF (ONLINE) WRITE (LP,FMT=6010)
      WRITE (LINOUT,FMT=6010)
      IF (BSEARCH.AND.(LINOUT.NE.6)) THEN
        WRITE (*,FMT=6010)
        WRITE (*,FMT=6034) IERR,SDXY,Q*SDXY,SDPHI,
     +      XBEAM,YBEAM,XOFF,YOFF,XBEAM-YOFF,YBEAM+XOFF,F
      WRITE (*,FMT=6037) CELL,RCELL,SDCELL
      END IF
 6010 FORMAT (//1X,'** Final refinement using ALL reflections **',/)
      IF (ONLINE) WRITE (LP,FMT=6034) IERR,SDXY,Q*SDXY,SDPHI,
     +      XBEAM,YBEAM,XOFF,YOFF,XBEAM-YOFF,YBEAM+XOFF,F
 6034 FORMAT (
     +' Refined parameters based on',I5,' indexed spots',/,
     +' Standard deviation of spot positions is ',F6.2,' pixels',/,
     +'                                      or ',F6.2,' mm',/,
     +' Standard deviation of spindle position' ,F8.2,' degrees',/,
     +' Refined direct beam coordinates',2F8.2,' mm',/,
     +'  These direct beam coordinates should be used in ',/,
     +'  conjunction with the input camera constants of ',/,
     +'          (CCX ',F5.2,' CCY ',F5.2,' mm)',/,
     +'  Alternatively the true beam coordinates of',2F8.2,'mm',/,
     +'  can be used with camera constants of zero',/,
     +' Crystal to detector distance  ',7X,F10.2,' mm'/)
      IF (ONLINE) WRITE (LP,FMT=6037) CELL,RCELL,SDCELL
 6037 FORMAT(
     +' Unit cell parameters       ',3F9.2,3F7.2,/,
     +' Reciprocal cell parameters ',3F9.6,3F7.2,/,
     +' Standard deviations        ',3F9.6,3F7.2/)
      WRITE (LINOUT,FMT=6034) IERR,
     +       SDXY,Q*SDXY,SDPHI,XBEAM,YBEAM,XOFF,YOFF,
     +       XBEAM-YOFF,YBEAM+XOFF,F
      WRITE (LINOUT,FMT=6037) CELL,RCELL,SDCELL
C
      IF (ONLINE) WRITE (LP,FMT=*)
     +  '"A" Matrix (equivalent to UB) for OSCGEN'
      WRITE (LINOUT,FMT=*)
     +  '"A" Matrix (equivalent to UB) for OSCGEN'
      IF (ONLINE) WRITE (LP,FMT=6014) (ASTV(I),BSTV(I),CSTV(I),
     +       I=1,3)                              
      WRITE (LINOUT,FMT=6014) (ASTV(I),
     +       BSTV(I),CSTV(I),I=1,3)
      IF (ONLINE) WRITE (LP,FMT=*)
     +'The missetting angles for this A matrix are all zero'
      WRITE (LINOUT,FMT=*)
     +'The missetting angles for this A matrix are all zero'
      PHIXYZ = 0.0
      IF (LAST) WRITE (MAT,FMT=6012) (ASTV(I),BSTV(I),
     +       CSTV(I),I=1,3),PHIXYZ,PHIXYZ,PHIXYZ
CAL      IF (ONLINE) WRITE (LP,FMT=6012) (ASTV(I),BSTV(I),
CAL     +       CSTV(I),I=1,3),PHIXYZ,PHIXYZ,PHIXYZ
CAL      WRITE (LINOUT,FMT=6012) (ASTV(I),BSTV(I),
CAL     +       CSTV(I),I=1,3),PHIXYZ,PHIXYZ,PHIXYZ
 6012 FORMAT (3(3F12.8/),3F12.3)
 6014 FORMAT (3 (3 (5X,F12.7),/))
C
      DO 750 I = 1,3
         UBM(I,1) = ASTV(I)
         UBM(I,2) = BSTV(I)
         UBM(I,3) = CSTV(I)
  750 CONTINUE
C
      CD(1,1) = RCELL(1)
      CD(1,2) = COS(RCELL(6)*DTR)*RCELL(2)
      CD(1,3) = COS(RCELL(5)*DTR)*RCELL(3)
      CD(2,1) = 0.0
      CD(2,2) = SIN(RCELL(6)*DTR)*RCELL(2)
      CD(2,3) = -SIN(RCELL(5)*DTR)*RCELL(3)*
     +          COS(CELL(4)*DTR)
      CD(3,1) = 0.0
      CD(3,2) = 0.0
      CD(3,3) = 1.0/CELL(3)
C
C          ****************
      CALL INVERS(CD,CR,DE)
C          ****************
C---- If target U MAT was given, take this out of ROT
C*****
C**** The following code does not work when a target matrix has been supplied *
C*****
C
      IF (TARGET) THEN
C
C            ***********************
        CALL INVERS(TARMAT,TARINV,D)
        CALL RFMATMUL(CR,TARINV,DUM)
        CALL MATCOP(DUM,CR)
C            ************************
C
      END IF
C
C          ******************
      CALL RFMATMUL(UBM,CR,ROT)
C          ******************
      DO 756 I = 1,3
        DO 754 J = 1,3
          ROT(I,J) = ROT(I,J)/FLAMDA
  754   CONTINUE
  756 CONTINUE
CAL      WRITE (LINOUT,FMT=6018)
CAL      IF (ONLINE) WRITE (LP,FMT=6018)
 6018 FORMAT (' U- Matrix')
CAL      WRITE (LINOUT,
CAL     + FMT=6016) ((ROT(I,J),J=1,3),I=1,3)
CAL      IF (ONLINE) WRITE (LP,FMT=6016) ((ROT(I,J),J=1,3),I=1,3)
 6016 FORMAT (5X,3F12.5)
C
C---- Renormalise ROT
C
C          ************
      CALL UNORM(ROT,J)
C          ************
C
      BETA = ASIN(-ROT(3,1))
      CBETA = COS(BETA)
      ALPHA = ASIN(ROT(3,2)/COS(BETA))
      IF (ROT(3,3).LT.0.0) ALPHA = 3.14159 - ALPHA
      GAMMA = ASIN(ROT(2,1)/COS(BETA))
      IF (ROT(1,1).LT.0.0) GAMMA = 3.14159 - GAMMA
      ALPHA = 57.29578*ALPHA
      BETA = 57.29578*BETA
      GAMMA = 57.29578*GAMMA
C
CAL      IF (ONLINE) WRITE (LP,FMT=6020) ALPHA,BETA,GAMMA
CAL      WRITE (LINOUT,FMT=6020) ALPHA,
CAL     +                        BETA,GAMMA
 6020 FORMAT (
     +' Misset angles:',/,
     +' Phi(X) = ',F10.5,'  Phi(Y) = ',F10.5,'  Phi(Z) = ',F10.5)
      IF (LAST.AND.(.NOT.TARGET)) WRITE (MAT,FMT=6023) 
     +   ((UDEF(I,J),J=1,3),I=1,3)
      IF (LAST.AND.TARGET) WRITE (MAT,FMT=6023)
     +    ((TARMAT(I,J),J=1,3),I=1,3)
      IF (LAST) WRITE (MAT,FMT=6024) CELL                          
      IF (LAST) WRITE (MAT,FMT=6025) ALPHA,BETA,GAMMA
 6023 FORMAT (3F12.7)
 6024 FORMAT (6F12.4)
 6025 FORMAT (3F12.4)
ccc      endfile mat
      CLOSE (MAT)
C
C---- end of inclusion
C
CAL      IF (ONLINE) WRITE (LP,1200)
CAL      IF (ONLINE) WRITE (LP,1170)NACC,SDXY,SDPHI,ORGX,ORGY,F,
CAL     1(ED(K,1),K=1,3),(ED(K,2),K=1,3),S0,
CAL     2((A(K,J),J=1,3),K=1,3),RCELL,CELL,SDCELL,IGROUP
C
C---- save indexed spots
C
CAL      REWIND SPOT
CAL      DO 350 JRFL=1,NRFL
CAL      X=IX(JRFL)/10.0
CAL      Y=IY(JRFL)/10.0
CAL      Z=IPHI(JRFL)/100.0
CAL350   WRITE(2,1210,ERR=470)X,Y,Z,IH(JRFL),IK(JRFL),IL(JRFL)
ccx      endfile 2
ccx      close(2)
C
C---- save refined diffraction parameters
C
      IF (XDSOUT) THEN
        IFAIL = 1
        LDUM = 80
          CALL CCPDPN(XPARM,'PARAMS','UNKNOWN','F',LDUM,IFAIL)
        IF (IFAIL .EQ. -1) GOTO 450
C
        WRITE(XPARM,1220,ERR=450)ACHSE,ED,ORGX,ORGY,F,S0,RCELL,CELL,U,
     @                    SDU,SDXY,SDPHI,SDCELL
ccx        endfile xparm
ccx        close(xparm)
      ENDIF
C
C---- check if solution is acceptable
C
360   IF (((SDXY.GT.2.0*SDXY0).OR.(SDPHI.GT.2.0*SDPHI0).OR.
     @    (NACC.LT.(0.75*NRFL))).AND.(.NOT.BSEARCH))THEN
	  IF (ONLINE) WRITE (LP,1230)
	  WRITE (LINOUT,1230)
CAL	  CALL CCPERR(1, ' solution is not acceptable')
          IERRFLG = 2
          RETURN
ccx	  close(lp)
      ENDIF
C
C---- check if solution is unique
C
      IF (NBEST.LT.2)GO TO 370
      J=NINT(VC(1,2))
      IF (ESDXY(J).GT.(2.0*ESDXY(IBEST)))GO TO 370
      IF (ESDPHI(J).LT.(2.0*ESDPHI(IBEST)))GO TO 380
370   IF (ONLINE) WRITE (LP,*)' Solution is unique.'
      WRITE (LINOUT,*)' Solution is unique.'
      GO TO 390
380   IF (ONLINE) WRITE(LP,*)
     +       ' !!! WARNING !!! SOLUTION MAY NOT BE UNIQUE.'
      WRITE (LINOUT,*)' !!! WARNING !!! SOLUTION MAY NOT BE UNIQUE.'


C
C---- End of loop over possible direct beam positions
C
 390  IF (BSEARCH.AND.(.NOT.LAST)) THEN
        SPRESID(NSOL) = SDXY
        SARESID(NSOL) = SDPHI
        SORGX(NSOL) = ORGX
        SORGY(NSOL) = ORGY
        NINDX(NSOL) = IERR
        DO 392 J = 1,6
          CELLSRCH(J,NSOL) = CELL(J)
          IF (SDPHI.EQ.99) CELLSRCH(J,NSOL) = 0.0
 392    CONTINUE
C
        LINOUT = 6
C
C--- Calculate direct beam coordinates in MOSFLM frame
C
        XBEAM = (ORGX*COSOM - ORGY*SINOM)*Q
        YBEAM =  (ORGX*SINOM + ORGY*COSOM)*Q
        WRITE(6,*) 'ORGX,ORGY,Q',ORGX,ORGY,Q
        WRITE(6,*) 'IXLEN,PIXEL,XBEAM',IXLEN,PIXEL,XBEAM
        IF (INVFLAG.EQ.1) XBEAM = IXLEN*PIXEL - XBEAM
        WRITE(LINOUT,FMT=6040) NSOL,Q*SDXY,SDPHI,XBEAM,YBEAM
 6040   FORMAT(/1X,'Step ',I3,' Positional residual',F5.2,'mm, ',
     +         'angular residual',F5.2,/,1X,
     +         ' Beam coords',2F7.2,'mm'//)
        LINOUT = 10
      END IF
 840  CONTINUE
 850  CONTINUE
C
C---- Find the best solution
C
      RESMIN = 1000.0
      DO 852 I = 1,NSOL
        IF (SPRESID(I).LT.RESMIN) THEN
          ISBEST = I
          RESMIN = SPRESID(I)
        END IF
 852  CONTINUE
C
C---- Summarise results for this pass, if not the final run
C
      IF (LAST) GOTO 860 
C
      LINOUT = 6
      WRITE(LINOUT,FMT=6050) IPASS,XSTEP,YSTEP
      IF (ONLINE) WRITE (LP,FMT=6050) IPASS,XSTEP,YSTEP
 6050 FORMAT(///1X,'Summary of direct beam search for pass',I2,/,1X,
     +       'Step sizes were',F5.2,'mm in X and',F5.2,'mm in Y',/,1X,
     +         'A residual of 99 means that the autoindexing failed',
     +       /,1X,'  Trial  Positional   Angular  Direct beam  Npots',
     +       '  Cell',/,1X,
     +       '         residual(mm) residual position (mm)')
C
      DO 854 I = 1,NSOL
C
C--- Calculate direct beam coordinates in MOSFLM frame
C
        XBEAM = (SORGX(I)*COSOM - SORGY(I)*SINOM)*Q
        YBEAM =  (SORGX(I)*SINOM + SORGY(I)*COSOM)*Q
        IF (INVFLAG.EQ.1) XBEAM = IXLEN*PIXEL - XBEAM
        WRITE(LINOUT,FMT=6051) I,Q*SPRESID(I),SARESID(I),XBEAM,
     +                          YBEAM,NINDX(I),(CELLSRCH(K,I),
     +                          K=1,6)
        IF (ONLINE) WRITE (LP,FMT=6051) I,Q*SPRESID(I),SARESID(I),
     +                          XBEAM,YBEAM,NINDX(I),(CELLSRCH(K,I),
     +                          K=1,6)
 6051   FORMAT(1X,I4,F11.2,F11.2,3X,2F6.1,I6,6F8.2)
 854  CONTINUE
C
      WRITE(LINOUT,FMT=6052) ISBEST
      IF (ONLINE) WRITE (LP,FMT=6052) ISBEST
 6052 FORMAT(/1X,'Best solution is trial number',I2)
      IF (IPASS.NE.NPASS) THEN
        WRITE(LINOUT,FMT=6054) XSTEP*DAMP,YSTEP*DAMP
        IF (ONLINE) WRITE (LP,FMT=6054)  XSTEP*DAMP,YSTEP*DAMP
      END IF
 6054 FORMAT(/1X,'The next pass will be centred on the best ',
     +         'solution, with a step',/,1X,'size of',F5.2,
     +         'mm in X and',F5.2,'mm in Y',//)
      LINOUT = 10
C
C---- Repeat indexing at best position, using all refelctions
C 
      IF ((IPASS.EQ.NPASS).AND.(BSEARCH).AND.(.NOT.LAST)) THEN
          LINOUT = 6
          WRITE(LINOUT,FMT=6056)
          IF (ONLINE) WRITE (LP,FMT=6056)
 6056     FORMAT(//,1X,'The autoindexing will now be repeated',
     +           ' for the best solution but',/,1X,'using all ',
     +           'available reflections'/)
          LAST = .TRUE.
          NPASS = 1
          NXSTEP = 1
          NYSTEP = 1
          ORGXSTART = SORGX(ISBEST)
          ORGYSTART = SORGY(ISBEST)
          NRFL = NRFLS
          IF (NSPOTSR.LT.NRFLS) THEN
            DO 856 I = 1,NRFL
              IX(I) = IXST(I)
              IY(I) = IYST(I)
              IPHI(I) = IPHIST(I)
 856        CONTINUE
          END IF
          GOTO 800
      END IF
 860  CONTINUE
C
C---- test the 44 lattice characters against the refined reduced cell
C
      IF (IGROUP.GT.1)GO TO 410
      CALL FITZEL(A,LATCH,BT,IDXB,CELLB,P,IER)
      IF (IER.NE.0)GO TO 410
      IF (ONLINE) WRITE (LP,1240)
      DO 400 J=1,44
400   IF (ONLINE) WRITE (LP,1100)
     @        LATCH(J),BT(J),P(J),(CELLB(K,J),K=1,6),(IDXB(K,J),K=1,12)
410   continue
ccx    close(lp)
C      END IF                                       
      RETURN
C
C---- Programmed error stops 
C
420   IF (ONLINE) WRITE (LP,*)' !!! ERROR !!!',
     @' INPUT VALUE "DXY" MUST BE POSITIVE'
      WRITE (LINOUT,*)' !!! ERROR !!!',
     @' INPUT VALUE "DXY" MUST BE POSITIVE'
      GO TO 700
CAL430   CALL CCPERR(1, ' !!! ERROR !!! Cannot open refix.lp ')
CAL      GOTO 700
445   IF (ONLINE) WRITE (LP,*)' !!! ERROR !!! CANNOT OPEN MATRIX'
      WRITE (LINOUT,*)' !!! ERROR !!! CANNOT OPEN MATRIX'
      GO TO 700
450   CALL CCPERR(1, ' !!! ERROR !!! Cannot open MATRIX ')
455   CALL CCPERR(1, ' !!! ERROR !!! Cannot open SPOTS ')
460   CALL CCPERR(1, ' !!! ERROR !!! Cannot create INDICES ')
470   IF (ONLINE) WRITE (LP,*)' !!! ERROR !!! CANNOT WRITE SPOT.LIST'
      WRITE (LINOUT,*)' !!! ERROR !!! CANNOT WRITE SPOT.LIST'
      GO TO 700
480   IF (ONLINE) WRITE (LP,*)
     +   ' !!! ERROR !!! IILEGAL CALLING PARAMETERS IN "PREREF"'
      WRITE (LINOUT,*)
     +   ' !!! ERROR !!! IILEGAL CALLING PARAMETERS IN "PREREF"'
      GO TO 700
490   IF (ONLINE) WRITE (LP,*)
     +   ' !!! ERROR !!! ILLEGAL SPACE GROUP OR UNIT CELL.'
      WRITE (LINOUT,*)
     +   ' !!! ERROR !!! ILLEGAL SPACE GROUP OR UNIT CELL.'
      GO TO 700
500   IF (ONLINE) WRITE (LP,*)' !!! ERROR !!! ILLEGAL CELL PARAMETERS.'
      WRITE (LINOUT,*)' !!! ERROR !!! ILLEGAL CELL PARAMETERS.'
      GO TO 700
510   IF (ONLINE) WRITE (LP,*)
     +   ' !!! ERROR !!! DATA COLLECTION RANGE IS EMPTY'
      WRITE (LINOUT,*)' !!! ERROR !!! DATA COLLECTION RANGE IS EMPTY'
      GO TO 700
520   IF (ONLINE) WRITE (LP,*)
     @' !!! ERROR !!! ILLEGAL DETECTOR POSITION OR PIXEL SIZE.'
      WRITE (LINOUT,*)
     @' !!! ERROR !!! ILLEGAL DETECTOR POSITION OR PIXEL SIZE.'
      GO TO 700
530   IF (ONLINE) WRITE (LP,*)
     @' !!! ERROR !!! ILLEGAL INCIDENT BEAM VECTOR OR ROTATION AXIS.'
      WRITE (LINOUT,*)
     @' !!! ERROR !!! ILLEGAL INCIDENT BEAM VECTOR OR ROTATION AXIS.'
      GO TO 700
540   IF (ONLINE) WRITE (LP,*)
     +   ' !!! ERROR !!! PROGRAMMING ERROR IN USING REFIX'
      WRITE (LINOUT,*)' !!! ERROR !!! PROGRAMMING ERROR IN USING REFIX'
      GO TO 700
550   IF (ONLINE) WRITE (LP,*)
     +   ' !!! ERROR !!! INSUFFICIENT NUMBER OF ACCEPTED SPOTS.'
      WRITE (LINOUT,*)
     +   ' !!! ERROR !!! INSUFFICIENT NUMBER OF ACCEPTED SPOTS.'
      GO TO 700
560   IF (ONLINE) WRITE (LP,*)
     @' !!! ERROR !!! DIMENSION OF DIFFERENCE VECTOR SET LESS THAN 3.'
      WRITE (LINOUT,*)
     @' !!! ERROR !!! DIMENSION OF DIFFERENCE VECTOR SET LESS THAN 3.'
      GO TO 700
570   IF (ONLINE) WRITE (LP,*)' !!! ERROR !!! ILLEGAL REDUCED CELL'
      WRITE (LINOUT,*)' !!! ERROR !!! ILLEGAL REDUCED CELL'
      GO TO 700
580   IF (ONLINE) WRITE (LP,*)
     +   ' !!! ERROR IN REFINE !!! RETURN CODE IS IER=',IERR
      WRITE (LINOUT,*)
     +  ' !!! ERROR IN REFINE !!! RETURN CODE IS IER=',IERR
      GO TO 700
590   IF (ONLINE) WRITE (LP,1250)
      WRITE (LINOUT,1250)
      GO TO 700
600   IF (ONLINE) WRITE (LP,*)
     @' !!! ERROR !!! INCOMPLETE SYSTEM OF EQUATIONS IN "PREREF"'
      WRITE (LINOUT,*)
     @' !!! ERROR !!! INCOMPLETE SYSTEM OF EQUATIONS IN "PREREF"'
700   continue
CAL      CALL CCPERR(1, ' Error exit input/ file error')
      IERRFLG = 1
      RETURN
      END
C
C
C
C
      SUBROUTINE BASIDX(ABSTYP,NEQL,ML,RCELL,BASIS,ERRZEL,MXBEST,NBEST,
     @                  ESD,IDX,UB)
      IMPLICIT NONE
C
C
C     RETURNS THE "NBEST" ORIENTATIONS AND SETS OF INDICES
C     FOR THE OBSERVED VECTOR BASE.      W.KABSCH  10-1991
C
C****************** EXTERNAL SUBROUTINES REQUIRED **********************
C
C      GENABS,INVERS,RFSETMAT,U3BEST
C
C*************** DESCRIPTION OF CALLING PARAMETERS *********************
C
C ABSTYP - AN INTEGER VALUE DESCRIBING CONDITIONS LIMITING       (GIVEN)
C          POSSIBLE REFLECTIONS IN A GIVEN RECIPROCAL LATTICE
C            0: NO CONDITIONS ON h,k,l
C            1: h+k MUST BE EVEN
C            2: h+l MUST BE EVEN
C            3: k+l MUST BE EVEN
C            4: h+k+l MUST BE EVEN
C            5: -h+k+l MUST BE A MULTIPLE OF 3
C            6: h+k and h+l MUST BE EVEN
C  NEQL  - NUMBER OF LAUE OPERATORS                              (GIVEN)
C   ML   - LAUE OPERATORS                                        (GIVEN)
C  RCELL - RECIPROCAL CELL PARAMETERS                            (GIVEN)
C  BASIS - CONTAINS OBSERVED VECTOR BASE ( STORED ROW-WISE )     (GIVEN)
C ERRZEL - MAXIMUM PERCENTAGE ERROR OF CELL PARAMETERS           (GIVEN)
C MXBEST - MAXIMUM NUMBER OF BEST UNIT CELL ORIENTATIONS         (GIVEN)
C  NBEST - ACTUAL NUMBER OF UNIT CELL ORIENTATIONS OBTAINED     (RESULT)
C          NBEST=-1 RANK OF "BASIS" IS LESS THAN 3 OR NOT A
C                   RIGHT-HANDED SET OF VECTORS.
C          NBEST=0  INDICATES THAT THE GIVEN CELL PARAMETERS
C                   ARE TOO INACCURATE
C   ESD  - ARRAY(MXBEST) DESCRIBING QUALITY OF EXPLANATION      (RESULT)
C   IDX  - INTEGER*2 ARRAY(12,MXBEST) DESCRIBING REINDEXING     (RESULT)
C          TRANSFORMATIONS FOR EACH SOLUTION
C   UB   - ARRAY(3,3,MXBEST) DESCRIBING ORIENTATIONS            (RESULT)
C
C****************** DECLARATION OF VARIABLES ***************************
      INTEGER    ML(216),NEQL,I,J,K,M,N,MODE,ABSTYP,NBEST,MXBEST,
     1           MAXIDX,IH,IK,IL,NMAX,II,JJ,LL,MM,M1,M2,ISYM,IER,
     2           IXJH,IXJK,IXJL,IBEST
      PARAMETER  (MAXIDX=3,NMAX=124)
CAL original      PARAMETER  (MAXIDX=2,NMAX=124)
      INTEGER*2  IDX(12,MXBEST),IHKL(3,NMAX),IDX0(9),IDX1(9),IDX2(9)
      REAL       UB(3,3,MXBEST),ESD(MXBEST),QNORM(NMAX),BASIS(3,3),
     1           RBASIS(3,3),A0(3,3),A(3,3),U(3,3),BOUND(3),T(3),W(3),
     2           RCELL(6),Q,ERRZEL,QCUT
      DATA       W/3*1.0/
C
C
C
C
      QCUT=2.0*ERRZEL
      MODE=2
C
C---- check reduced cell for singularity
C
      NBEST=-1
      CALL INVERS(BASIS,RBASIS,Q)
      IF (Q.LE.0.0)RETURN
C
C---- calculate squared length of reciprocal basis vectors
C     of the reduced cell.
C
      DO 10 I=1,3
10    BOUND(I)=RBASIS(1,I)**2+RBASIS(2,I)**2+RBASIS(3,I)**2
C
C---- generate a list of possible basis vectors of the "true" cell
C
      CALL RFSETMAT(RCELL,A0)
      N=0
      DO 110 IH=-MAXIDX,MAXIDX
      DO 110 IK=-MAXIDX,MAXIDX
      DO 100 IL=-MAXIDX,MAXIDX
      IF ((IH.EQ.0).AND.(IK.EQ.0).AND.(IL.EQ.0))GO TO 100
C
C----- check if reflection ih,ik,il is generally absent
C
      CALL GENABS(ABSTYP,IH,IK,IL,I)
      IF (I.NE.0)GO TO 100
C
C----- calculate squared length of vector
C
      Q=0.0
      DO 20 I=1,3
20    Q=Q+(A0(I,1)*IH+A0(I,2)*IK+A0(I,3)*IL)**2
C
C----- check if reflection ih,ik,il will ever be useful
C
      DO 30 I=1,3
      IF (ABS(Q-BOUND(I)).LE.QCUT*BOUND(I))GO TO 40
30    CONTINUE
      GO TO 100
C
C----- reflection may become useful
C
40    IF (N.GE.NMAX)GO TO 50
      N=N+1
      GO TO 60
50    IF (Q.GE.QNORM(N))GO TO 100
60    QNORM(N)=Q
      IHKL(1,N)=IH
      IHKL(2,N)=IK
      IHKL(3,N)=IL
C
C----- sort in increasing vector length
C
      IF (N.LT.2)GO TO 100
70    II=0
      DO 90 M1=1,N-1
      DO 90 M2=M1+1,N
      IF (QNORM(M1).LE.QNORM(M2))GO TO 90
      Q=QNORM(M1)
      QNORM(M1)=QNORM(M2)
      QNORM(M2)=Q
      DO 80 II=1,3
      M=IHKL(II,M1)
      IHKL(II,M1)=IHKL(II,M2)
80    IHKL(II,M2)=M
90    CONTINUE
      IF (II.NE.0)GO TO 70
100   CONTINUE
110   CONTINUE
C
C---- determine a list of possible interpretations of the
C      observed reciprocal reduced cell vectors.
C
      NBEST=0
      IF (N.LT.3)RETURN
      DO 360 I=1,N
C
C----- check length of first vector
C
      IF (ABS(QNORM(I)-BOUND(1)).GT.QCUT*BOUND(1))GO TO 360
      DO 150 II=1,3
150   IDX0(II)=IHKL(II,I)
      DO 350 J=1,N
C
C----- check length of second vector
C
      IF (ABS(QNORM(J)-BOUND(2)).GT.QCUT*BOUND(2))GO TO 350
C
C----- test first two vectors for collinearity
C
      IXJH=IHKL(2,I)*IHKL(3,J)-IHKL(3,I)*IHKL(2,J)
      IXJK=IHKL(3,I)*IHKL(1,J)-IHKL(1,I)*IHKL(3,J)
      IXJL=IHKL(1,I)*IHKL(2,J)-IHKL(2,I)*IHKL(1,J)
      IF ((IXJH.EQ.0).AND.(IXJK.EQ.0).AND.(IXJL.EQ.0))GO TO 350
      DO 160 II=1,3
160   IDX0(II+3)=IHKL(II,J)
      DO 340 K=1,N
C
C----- check length of third vector
C
      IF (ABS(QNORM(K)-BOUND(3)).GT.QCUT*BOUND(3))GO TO 340
C
C----- check determinant to assure that cell volume remains conserved
C
      IF ((IXJH*IHKL(1,K)+IXJK*IHKL(2,K)+IXJL*IHKL(3,K)).LT.1)GO TO 340
C
C----- triplett is considered as a candidate reciprocal reduced cell
C
      DO 170 II=1,3
170   IDX0(II+6)=IHKL(II,K)
C
C----- find the asymmetric indices of the triplett
C
      DO 220 ISYM=1,NEQL
      MM=9*(ISYM-1)
      DO 180 II=1,3
      MM=MM+1
      LL=II
      DO 180 JJ=1,9,3
      IDX1(LL)=IDX0(JJ)*ML(MM)+IDX0(JJ+1)*ML(MM+3)+IDX0(JJ+2)*ML(MM+6)
180   LL=LL+3
      IF (ISYM.EQ.1)GO TO 200
      DO 190 II=1,9
      IF (IDX1(II)-IDX2(II))220,190,200
190   CONTINUE
200   DO 210 II=1,9
210   IDX2(II)=IDX1(II)
220   CONTINUE
C
C----- check if there is a symmetry-related set present in the list
C
      IF (NBEST.LT.1)GO TO 250
      DO 240 IBEST=1,NBEST
      DO 230 II=1,9
      IF (IDX(II,IBEST).NE.IDX2(II))GO TO 240
230   CONTINUE
      GO TO 340
240   CONTINUE
C
C----- this triplett is not yet present in the list.
C      calculate reciprocal space vectors for this triplett.
C
250   DO 260 II=1,3
      A(II,1)=A0(II,1)*IDX2(1)+A0(II,2)*IDX2(2)+A0(II,3)*IDX2(3)
      A(II,2)=A0(II,1)*IDX2(4)+A0(II,2)*IDX2(5)+A0(II,3)*IDX2(6)
260   A(II,3)=A0(II,1)*IDX2(7)+A0(II,2)*IDX2(8)+A0(II,3)*IDX2(9)
C
C----- compare with the observed triplett
C
      CALL U3BEST(W,A,RBASIS,3,MODE,Q,U,T,IER)
      IF (IER.NE.0)GO TO 340
C
C----- save if good enough
C
      IF (NBEST.GE.MXBEST)GO TO 270
      NBEST=NBEST+1
      GO TO 280
270   IF (Q.GE.ESD(NBEST))GO TO 330
280   ESD(NBEST)=Q
      II=0
      DO 290 M1=1,3
      DO 290 M2=1,3
      UB(M1,M2,NBEST)=U(M1,M2)
      II=II+1
290   IDX(II,NBEST)=IDX2(II)
C
C----- sort in increasing rms-deviation
C
      IF (NBEST.LT.2)GO TO 330
300   II=0
      DO 320 M1=1,NBEST-1
      DO 320 M2=M1+1,NBEST
      IF (ESD(M1).LE.ESD(M2))GO TO 320
      Q=ESD(M1)
      ESD(M1)=ESD(M2)
      ESD(M2)=Q
      II=0
      DO 310 LL=1,3
      DO 310 MM=1,3
      II=II+1
      M=IDX(II,M1)
      IDX(II,M1)=IDX(II,M2)
      IDX(II,M2)=M
      Q=UB(LL,MM,M1)
      UB(LL,MM,M1)=UB(LL,MM,M2)
310   UB(LL,MM,M2)=Q
320   CONTINUE
      IF (II.NE.0)GO TO 300
330   CONTINUE
340   CONTINUE
350   CONTINUE
360   CONTINUE
C
C---- find number of solutions which must be considered further
C
      IF (NBEST.LT.1)RETURN
      M=NBEST+1
370   M=M-1
      IF ((M.GT.1).AND.(ESD(M).GT.(4.0*ESD(1))))NBEST=M-1
      IF (M.GT.2)GO TO 370
C
C---- fix-up of the reindexing transformations
C
      DO 400 IBEST=1,NBEST
      ESD(IBEST)=SQRT(ESD(IBEST))
      DO 380 I=1,9
380   IDX0(I)=IDX(I,IBEST)
      DO 400 J=1,3
      DO 390 I=1,3
390   IDX(I+4*(J-1),IBEST)=IDX0(J+3*(I-1))
400   IDX(4*J,IBEST)=0
      RETURN
      END
C
C
C
C
C     =============================================================
      SUBROUTINE CORTEX(MXRFL,D,ICUT,NBXS,NBYS,NBZS,NX,NY,NZ,BOX,
     @                  NRFL,V,WEIGHT)
C     =============================================================
      IMPLICIT NONE
C
C
C
      INTEGER    ICUT,NBXS,NBYS,NBZS,NX,NY,NZ,IX,IY,IZ,IX1,IY1,IZ1,IC,J
      INTEGER*2  BOX(*)
      INTEGER*4  NXY,NA,IRFL,JRFL,NRFL,MXRFL,IAX,IAY,IAZ,IAX1,IAY1,IAZ1
      REAL       V(3,MXRFL),WEIGHT(MXRFL),C,D,DD,XC,YC,ZC,W
C
C
C
C---- check preconditions
C
      NRFL=-1
      IF (NBXS.LT.0)GO TO 160
      IF (NBYS.LT.0)GO TO 160
      IF (NBZS.LT.0)GO TO 160
      IF ((2*NBXS+1).GT.NX)GO TO 160
      IF ((2*NBYS+1).GT.NY)GO TO 160
      IF ((2*NBZS+1).GT.NZ)GO TO 160
      IF (MXRFL.LT.1)GO TO 160
C
C---- locate maxima above threshold and determine spot centroids
C
      NXY=NX*NY
      NRFL=0
      DO 90 IZ=1+NBZS,NZ-NBZS
      IAZ=NXY*(IZ-1)
      DO 80 IY=1+NBYS,NY-NBYS
      IAY=NX*(IY-1)+IAZ
      DO 70 IX=1+NBXS,NX-NBXS
      IAX=IX+IAY
      IC=BOX(IAX)
      IF (IC.LT.ICUT)GO TO 70
      XC=0.0
      YC=0.0
      ZC=0.0
      W=0.0
      DO 30 IZ1=-NBZS,NBZS
      IAZ1=NXY*(IZ+IZ1-1)
      DO 20 IY1=-NBYS,NBYS
      IAY1=NX*(IY+IY1-1)+IAZ1
      DO 10 IX1=-NBXS,NBXS
      IAX1=IX+IX1+IAY1
      IF (BOX(IAX1).GT.IC)GO TO 70
      IF (BOX(IAX1).LT.ICUT)GO TO 10
      C=BOX(IAX1)
      XC=XC+IX1*C
      YC=YC+IY1*C
      ZC=YC+IZ1*C
      W=W+C
10    CONTINUE
20    CONTINUE
30    CONTINUE
      IF (NRFL.LT.MXRFL)GO TO 50
C
C----- spots are sorted in decreasing order if nrfl=mxrfl
C
      IF (WEIGHT(NRFL).GE.W)GO TO 70
      GO TO 60
50    NRFL=NRFL+1
60    V(1,NRFL)=IX+XC/W
      V(2,NRFL)=IY+YC/W
      V(3,NRFL)=IZ+ZC/W
      WEIGHT(NRFL)=W
      IF (NRFL.EQ.MXRFL)CALL QSORT2(NRFL,V,WEIGHT)
70    CONTINUE
80    CONTINUE
90    CONTINUE
C
C---- sort spots in decreasing order
C
      IF (NRFL.LT.1)GO TO 160
      IF (NRFL.LT.MXRFL)CALL QSORT2(NRFL,V,WEIGHT)
C
C---- remove spots which are too close
      DD=D**2
      NA=0
      DO 150 JRFL=1,NRFL
      IRFL=1
110   IF (IRFL.GT.NA)GO TO 130
      C=0.0
      DO 120 J=1,3
120   C=C+(V(J,IRFL)-V(J,JRFL))**2
      IF (C.LT.DD)GO TO 150
      IRFL=IRFL+1
      GO TO 110
130   NA=NA+1
      DO 140 J=1,3
140   V(J,NA)=V(J,JRFL)
      WEIGHT(NA)=WEIGHT(JRFL)
150   CONTINUE
      NRFL=NA
160   RETURN
      END
C
C
C
C     ==================================
      SUBROUTINE CRYSYS(IGROUP,CELL,ICS)
C     ==================================
      IMPLICIT NONE
C
C
C
C*****
C*****  DETERMINE CRYSTAL SYSTEM NUMBER FROM SPACEGROUP NUMBER
C*****  AND UNIT CELL PARAMETERS.         W.KABSCH   11-1987
C*****
C
C IGROUP - SPACE GROUP NUMBER OF ONE OF THE 65 ENANTIOMORPHIC    (GIVEN)
C          GROUPS AS OBTAINED FROM THE INTERNATIONAL TABLES.
C  CELL  - UNIT CELL PARAMETERS IN ANGSTROEM AND DEGREES         (GIVEN)
C  ICS   - NUMBER SPECIFYING CRYSTAL SYSTEM                     (RESULT)
C          0 : UNIT CELL PARAMETERS ARE INCONSISTENT WITH
C              SPACE GROUP
C          1 : TRICLINIC
C          2 : MONOCLINIC FIRST SETTING
C          3 : MONOCLINIC SECOND SETTING
C          4 : ORTHORHOMBIC
C          5 : TETRAGONAL
C          6 : TRIGONAL
C          7 : HEXAGONAL
C          8 : CUBIC
C
C
      INTEGER     IGROUP,ICS,IG,J
      REAL        CELL(6)
C
C
C
C
      ICS=0
      IG=IGROUP
      DO 10 J=1,6
      IF (CELL(J).LE.0.0)RETURN
10    CONTINUE
C
C---- determine crystal system number from spacegroup number
C      and unit cell parameters
C
      IF (IG.EQ.1)ICS=1
      IF ((IG.GE.3).AND.(IG.LE.5))THEN
	 IF ((CELL(4).EQ.90.0).AND.(CELL(5).EQ.90.0))ICS=2
	 IF ((CELL(4).EQ.90.0).AND.(CELL(6).EQ.90.0))ICS=3
	 IF (ICS.EQ.3)IG=IG+512
      ENDIF
      IF ((IG.GE.16).AND.(IG.LE.24).AND.(CELL(4).EQ.90.0).AND.
     @    (CELL(5).EQ.90.0).AND.(CELL(6).EQ.90.0))ICS=4
      IF ((IG.GE.75).AND.(IG.LE.98).AND.(CELL(1).EQ.CELL(2)).AND.
     1(CELL(4).EQ.90.0).AND.(CELL(5).EQ.90.0).AND.(CELL(6).EQ.90.0))
     2 ICS=5
      IF ((IG.GE.143).AND.(IG.LE.155).AND.(CELL(1).EQ.CELL(2)))THEN
	IF ((CELL(2).EQ.CELL(3)).AND.(CELL(4).EQ.CELL(5)).AND.
     @      (CELL(5).EQ.CELL(6)))ICS=6
	IF ((CELL(4).EQ.90.0).AND.(CELL(5).EQ.90.0).AND.
     @      (CELL(6).EQ.120.0))  ICS=7
	IF ((ICS.EQ.6).AND.((IG.EQ.146).OR.(IG.EQ.155)))IG=IG+512
      ENDIF
      IF ((IG.GE.168).AND.(IG.LE.182).AND.(CELL(1).EQ.CELL(2))
     1   .AND.(CELL(4).EQ.90.0).AND.(CELL(5).EQ.90.0).AND.
     2       (CELL(6).EQ.120.0)) ICS=7
      IF ((IG.GE.195).AND.(IG.LE.214).AND.(CELL(1).EQ.CELL(2))
     1   .AND.(CELL(2).EQ.CELL(3)).AND.(CELL(4).EQ.90.0).AND.
     2        (CELL(5).EQ.90.0).AND.(CELL(6).EQ.90.0))ICS=8
      RETURN
      END
C
C
C
C     ===================================
      SUBROUTINE DCOSFD(ROT,DIRCOS,KAPPA)
C     ===================================
      IMPLICIT NONE
C
C
C       Given a rotation matrix ROTN, expressing a rotation
C       through an angle KAPPA right-handedly about an axis
C       with direction cosines DIRCOS(I),
C       DCOSFD determines DIRCOS() and KAPPA
C       KAPPA is returned in degrees in the range 0 to 180
C
C       Expression for rotation matrix is (see J & J, "Mathl.
C               Phys.", p. 122):-
C
C  cw + n(1)n(1)(1-cw)    n(1)n(2)(1-cw)-n(3)sw  n(1)n(3)(1-cw)+n(3)sw
C  n(1)n(2)(1-cw)+n(3)sw  cw + n(2)n(2)(1-cw)    n(2)n(3)(1-cw)-n(1)sw
C  n(3)n(1)(1-cw)-n(2)sw  n(3)n(2)(1-cw)+n(1)sw  cw + n(3)n(3)(1-cw)
C
C       where cw = cos(KAPPA), sw = sin(KAPPA),
C       & n(1), n(2), n(3) are the direction cosines.
C
C
C
C
C
C
C
C     .. Scalar Arguments ..
      REAL KAPPA
C     ..
C     .. Array Arguments ..
      REAL DIRCOS(3),ROT(3,3)
C     ..
      INTEGER LP,LINOUT
      LOGICAL ONLINE
C     .. Local Scalars ..
      REAL COSKAP,DIFF,PI,R2,R3,SINKAP,TRACE
      INTEGER J,JMX,KNTRL
C     ..
C     .. Local Arrays ..
      REAL D(3),P(3),S(3)
      INTEGER NCS(3),ND(3),NP(3),NS(3)
C     ..
C     .. External Subroutines ..
      EXTERNAL ORDR3
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS,ATAN,ATAN2,SQRT
C     ..
      COMMON /RINOUT/ ONLINE,LP,LINOUT
C
C
      SAVE
C
C
      DIFF = 1.0E-04
      PI = ATAN(1.0)*4.0
      KNTRL = 0
C
C---- Trace = 1 + 2.cos w
C
      TRACE = ROT(1,1) + ROT(2,2) + ROT(3,3)
C
C----       S(1)=2.n(1).sin w
C           S(2)=2.n(2).sin w
C           S(3)=2.n(3).sin w
C
      S(1) = ROT(3,2) - ROT(2,3)
      S(2) = ROT(1,3) - ROT(3,1)
      S(3) = ROT(2,1) - ROT(1,2)
C
C          *****************
      CALL ORDR3(KNTRL,S,NS)
C          *****************
C
C---- Is biggest S() zero (i.e. is sin w = 0)?
C
      IF (ABS(S(NS(1))).GT.DIFF) THEN
        R2 = S(NS(2))/S(NS(1))
        R3 = S(NS(3))/S(NS(1))
        DIRCOS(NS(1)) = 1.0/SQRT(R2**2+1+R3**2)
        DIRCOS(NS(2)) = DIRCOS(NS(1))*R2
        DIRCOS(NS(3)) = DIRCOS(NS(1))*R3
      ELSE
C
C---- Calculation when sin w = 0 (esp. when w = 180').
C       P(1)=n(2).n(3).{0(W=0)or2(w=180)}
C       P(2)=n(3).n(1).{0(W=0)or2(w=180)}
C       P(3)=n(1).n(2).{0(W=0)or2(w=180)}
C
        P(1) = ROT(3,2)
        P(2) = ROT(1,3)
        P(3) = ROT(2,1)
C
C            *****************
        CALL ORDR3(KNTRL,P,NP)
C            *****************
C
C---- Is biggest P() zero (i.e. are all off-diag. terms zero)?
C
        IF (ABS(P(NP(1))).LT.DIFF) THEN
          IF (TRACE.GT.0.0) THEN
C
C---- Matrix is unit matrix.
C
            KAPPA = 0.0
            DIRCOS(1) = 0.0
            DIRCOS(2) = 0.0
            DIRCOS(3) = 1.0
          ELSE
C
C---- Trace -ve, so dyad about x,y or z.
C
            KAPPA = PI
C
C
            DO 10 J = 1,3
              D(J) = ROT(J,J) + 1.0
   10       CONTINUE
C
C                *****************
            CALL ORDR3(KNTRL,D,ND)
C                *****************
C
            DIRCOS(ND(1)) = 1.0
            DIRCOS(ND(2)) = 0.0
            DIRCOS(ND(3)) = 0.0
          END IF
          RETURN
C
C
        ELSE IF (ABS(P(NP(2))).LT.DIFF) THEN
C
C---- One d.c. is zero.
C
          DIRCOS(NP(1)) = 0.0
          DIRCOS(NP(2)) = SQRT((ROT(NP(2),NP(2))+1.0)*0.5)
          DIRCOS(NP(3)) = SQRT((ROT(NP(3),NP(3))+1.0)*0.5)
          IF (P(NP(1)).LT.0.0) DIRCOS(NP(2)) = -DIRCOS(NP(2))
        ELSE
C
C---- All d.c's are nonzero.
C       R2=n(NP(1))/n(NP(2))
C       R3=n(NP(1))/n(NP(3))
C
          R2 = P(NP(2))/P(NP(1))
          R3 = P(NP(3))/P(NP(1))
          DIRCOS(NP(2)) = 1.0/SQRT(R2**2+1+ (R2/R3)**2)
          DIRCOS(NP(3)) = 1.0/SQRT(R3**2+1+ (R3/R2)**2)
          DIRCOS(NP(1)) = SQRT(1.0-DIRCOS(NP(2))**2-DIRCOS(NP(3))**2)
C
C---- Adjust signs of DIRCOS().
C
          JMX = 0
C
C
          DO 20 J = 1,3
            IF (P(J).GT.0.0) THEN
              IF (JMX.GT.0) JMX = -1
              IF (JMX.EQ.0) JMX = J
            END IF
   20     CONTINUE
C
C
          IF (JMX.GT.0) DIRCOS(JMX) = -DIRCOS(JMX)
          IF (JMX.EQ.0) WRITE (LINOUT,FMT=6000)
          IF (JMX.EQ.0.AND.ONLINE) WRITE (LP,FMT=6000)
        END IF
      END IF
C
C---- Given d.c's, calculate KAPPA.
C
      KNTRL = 1
C
C          ***********************
      CALL ORDR3(KNTRL,DIRCOS,NCS)
C          ***********************
C
C---- Find KAPPA.
C
      SINKAP = ROT(NCS(3),NCS(2)) - ROT(NCS(2),NCS(3))
      SINKAP = 0.5*SINKAP/DIRCOS(NCS(1))
      COSKAP = (TRACE-1.0)*0.5
      KAPPA = ATAN2(SINKAP,COSKAP)
      KAPPA = KAPPA*180.0/PI
C
C---- If kappa negative, negate kappa and invert DIRCOS
C
      IF (KAPPA.LT.0.0) THEN
        KAPPA = -KAPPA
        DIRCOS(1) = -DIRCOS(1)
        DIRCOS(2) = -DIRCOS(2)
        DIRCOS(3) = -DIRCOS(3)
      END IF
C
C---- Format statements
C
 6000 FORMAT (' All P()s. are negative or zero')
C
C
      END
C
C
C
C     ========================
      SUBROUTINE DECOMP(A,U,B)
C     ========================
      IMPLICIT NONE
C
C
C
C---- Calculate U and B given A.
C
C
C
C
C---- Orientation matrix given explicitly
C
C     Set UMAT to (UB)transpose
C
C     .. Array Arguments ..
      REAL A(3,3),B(3,3),U(3,3)
C     ..
C     .. Scalars in Common ..
      REAL CCOM,CCX,CCY,DPHI,F,FLAMDA,ORGX,ORGY,Q,THRESH,DXY
      INTEGER IGROUP,FIXF
      LOGICAL DCOMP,FILM,LCAMC,TARGET
      INTEGER LP,LINOUT
      LOGICAL ONLINE
C     ..
C     .. Arrays in Common ..
      REAL ACHSE,CELL,ED,S0,TARMAT
C     ..
C     .. Local Scalars ..
      REAL D
      INTEGER I
C     ..
C     .. Local Arrays ..
      REAL CELLC(6),GMAT(3,3),RCELL(6),XMAT(3,3)
C     ..
C     .. External Subroutines ..
      EXTERNAL BMATRX,CHECKU,CLCALC,INVERS,RFMATMUL,TRANSP
C     ..
C     .. Common blocks ..
      COMMON /REFCOM/IGROUP,FLAMDA,CELL(6),F,THRESH,Q,DPHI,ED(3,3),
     +       ACHSE(3),S0(3),ORGX,ORGY,FIXF,TARMAT(3,3),TARGET,DCOMP,
     +       LCAMC,CCX,CCY,CCOM,FILM,DXY,FIXCELL
      LOGICAL FIXCELL
      COMMON /RINOUT/ ONLINE,LP,LINOUT
C     ..
      SAVE
C
C
C          ***********
      CALL TRANSP(U,A)
C          ***********
C
C---- Get reciprocal metric tensor G**-1 in GMAT, = (UB)T.(UB)
C
C          ****************
      CALL RFMATMUL(U,A,GMAT)
C          ****************
C
C---- Get reciprocal cell dimensions RCELL
C
C          ******************
      CALL CLCALC(RCELL,GMAT)
C          ******************
C
C---- Invert to get real metric tensor G in UMAT
C
C          ****************
      CALL INVERS(GMAT,U,D)
C          ****************
C
C      IF (ABS(D).LE.0.000001) THEN
      IF (D.EQ.0.0) THEN
        WRITE (LINOUT,FMT=6000)
        IF (ONLINE) WRITE (LP,FMT=6000)
      ELSE
C
C---- Get real cell dimensions from metric tensor
C
C            ***************
        CALL CLCALC(CELLC,U)
C            ***************
C
        DO 10 I = 1,3
          CELLC(I) = CELLC(I)*FLAMDA
   10   CONTINUE
C
C---- Rebuild cell orthogonalization matrix B in BMAT
C
C            ****************************
        CALL BMATRX(B,RCELL,CELLC,FLAMDA)
C            ****************************
C
C---- Get matrix U = (UB).(B**-1) to UMAT
C
C            ****************
        CALL INVERS(B,XMAT,D)
        CALL RFMATMUL(A,XMAT,U)
        CALL CHECKU(U)
C            *****************
C
      END IF
C
C---- Format statements
C
 6000 FORMAT (//' !!!! Zero reciprocal cell volume from orientation ma',
     +       'trix !!!!',//)
C
C
      END
C
C
C
C
C     ===========================================================
      SUBROUTINE DIFVEC(NRFL,V,GRID,SEPMIN,MXSPOT,N,MXY,MZ,TABLE,
     @                  VD,WEIGHT,NSPOT)
C     ===========================================================
      IMPLICIT NONE
C
C
C
C*****
C***** OBTAIN LIST OF DIFFERENCE VECTOR CLUSTERS
C*****
C*****        W.KABSCH       NEW VERSION  11-1988
C*****
C          description of calling parameters 
C
C  NRFL  - NUMBER OF REFLECTIONS IN ARRAY V                      (GIVEN)
C   V    - REAL ARRAY(3,*) OF REFLECTION COORDINATES             (GIVEN)
C  GRID  - GRID SPACING SUCH THAT  V(I,J)/GRID  ARE GRID         (GIVEN)
C          COORDINATES OF VECTOR #J
C SEPMIN - MINIMAL ALLOWED DISTANCE BETWEEN DIFFERENT SPOTS      (GIVEN)
C          (IN UNITS OF GRID-SIZE DEFINED BY "GRID" ABOVE)
C MXSPOT - MAXIMUM NUMBER OF DIFFERENCE VECTOR CLUSTERS.         (GIVEN)
C          IT DEFINES DIMENSIONS OF ARRAYS VD,WEIGHT
C  N     - DEFINES SIZE OF SEARCH BOX WHEN LOOKING FOR           (GIVEN)
C          DIFFERENCE VECTOR CLUSTERS.
C  MXY,  - SPECIFIES DIMENSIONS IN ARRAY TABLE                   (GIVEN)
C   MZ                                                           (GIVEN)
C TABLE  - INTEGER*2 ARRAY(MXY*MXY*MZ) TO ACCUMULATE SHORT     (CHANGED)
C          DIFFERENCE VECTORS BETWEEN REFLECTION COORDINATES
C   VD   - REAL ARRAY(3,MXSPOT) CONTAINING RECIPROCAL SPACE     (RESULT)
C          COORDINATES OF DIFFERENCE VECTOR CLUSTERS. THE
C          ARRAY IS SORTED IN DECREASING NUMBER OF DIFFERENCE
C          VECTORS BELONGING TO A CLUSTER.
C WEIGHT - REAL ARRAY(MXSPOT). ON RETURN IT CONTAINS THE       (CHANGED)
C          NUMBER OF DIFFERENCE VECTORS IN EACH CLUSTER.
C NSPOT  - NUMBER OF DIFFERENCE VECTOR CLUSTERS FOUND           (RESULT)
C
C***********************************************************************
C
C          SUBROUTINES REQUIRED: CORTEX,QSORT2
C
C***********************************************************************
      INTEGER    MXSPOT,ISPOT,NSPOT,MXY,MZ,N,NXY,NXY1,NZ,NZ1,JX,JY,JZ,
     1           IX,IY,IZ,JRFL,KRFL,NRFL,ICUT,NV
      INTEGER*2  TABLE(*)
      INTEGER*4  IADR,IADR0,MMXY,I,J
      REAL       V(3,*),VD(3,MXSPOT),WEIGHT(MXSPOT),XYZ(3),
     @           GRID,SEPMIN,DD,P,R,S,W,X,Y,Z
      LOGICAL DEBUG
C
C
C
C
      DEBUG = .FALSE.
      IF (DEBUG) WRITE(6,*) ' NRFL,GRID,SEPMIN,MXSPOT,N',
     +                   NRFL,GRID,SEPMIN,MXSPOT,N
      IF (DEBUG) WRITE(6,*) ' MXY,MZ', MXY,MZ
      IF (DEBUG) WRITE(6,*) 'VECTOR 1',V(1,1),V(2,1),V(3,1)
      IF (DEBUG) WRITE(6,*) 'VECTOR 2',V(1,2),V(2,2),V(3,2)
      IF (DEBUG) WRITE(6,*) 'VECTOR 3',V(1,3),V(2,3),V(3,3)
      DD=SEPMIN**2
      MMXY=MXY
      MMXY=MXY*MMXY
      NSPOT=0
      NXY=(MXY-1)/2
      NXY1=NXY+1
      NZ=(MZ-1)/2
      NZ1=NZ+1
      IADR0=NXY1+MXY*NXY+MMXY*NZ
      IF ((GRID.LE.0.0).OR.(NRFL.LT.2).OR.(MXY.LT.3))RETURN
      IF ((MXSPOT.LT.1).OR.(MZ.LT.1))RETURN
      IF ((N.LT.1).OR.(N.GE.NXY))RETURN
      IADR=0
      DO 10 IZ=1,MZ
      DO 10 IY=1,MXY
      DO 10 IX=1,MXY
      IADR=IADR+1
10    TABLE(IADR)=0
      DO 30 JRFL=1,NRFL-1
      DO 20 KRFL=JRFL+1,NRFL
      X=(V(1,JRFL)-V(1,KRFL))/GRID
      JX=NINT(X)
      IF (ABS(JX).GT.NXY)GO TO 20
      Y=(V(2,JRFL)-V(2,KRFL))/GRID
      JY=NINT(Y)
      IF (ABS(JY).GT.NXY)GO TO 20
      Z=(V(3,JRFL)-V(3,KRFL))/GRID
      JZ=NINT(Z)
      IF (ABS(JZ).GT.NZ)GO TO 20
      IF ((X**2+Y**2+Z**2).LE.DD)GO TO 20
      IADR=JX+MXY*JY+MMXY*JZ
      I=TABLE(IADR+IADR0)
      IF (I.LT.32767)I=I+1
      TABLE(IADR+IADR0)=I
      IADR=-IADR
      I=TABLE(IADR+IADR0)
      IF (I.LT.32767)I=I+1
      TABLE(IADR+IADR0)=I
20    CONTINUE
30    CONTINUE
C
C----  find difference vector clusters
C
      ICUT=1
      CALL CORTEX(MXSPOT,SEPMIN,ICUT,N,N,N,MXY,MXY,MZ,TABLE,NSPOT,VD,
     @            WEIGHT)
      IF (NSPOT.LT.1)RETURN
C
C---- transform back to reciprocal space
C
      J=0
      DO 70 ISPOT=1,NSPOT
      X=(VD(1,ISPOT)-NXY1)*GRID
      Y=(VD(2,ISPOT)-NXY1)*GRID
      Z=(VD(3,ISPOT)-NZ1)*GRID
      IF (Z)70,40,60
40    IF (Y)70,50,60
50    IF (X.LE.0.0)GO TO 70
60    J=J+1
      VD(1,J)=X
      VD(2,J)=Y
      VD(3,J)=Z
70    CONTINUE
      NSPOT=MIN0(J,MXSPOT/2)
      DO 80 ISPOT=1,NSPOT
      WEIGHT(ISPOT+NSPOT)=0.0
      DO 80 I=1,3
80    VD(I,ISPOT+NSPOT)=0.0
C
C---- determine number of difference vectors in each cluster
C
      NV=0
      P=(N*GRID)**2
      DO 140 JRFL=1,NRFL-1
      DO 130 KRFL=JRFL+1,NRFL
      XYZ(1)=V(1,JRFL)-V(1,KRFL)
      IF (ABS(XYZ(1)).GE.(NXY*GRID))GO TO 130
      XYZ(2)=V(2,JRFL)-V(2,KRFL)
      IF (ABS(XYZ(2)).GE.(NXY*GRID))GO TO 130
      XYZ(3)=V(3,JRFL)-V(3,KRFL)
      IF (ABS(XYZ(3)).GE.(NZ*GRID))GO TO 130
      DO 120 ISPOT=1,NSPOT
      S=-1.0
      DO 110 J=1,2
      S=-S
      R=0.0
      DO 90 I=1,3
90    R=R+(S*XYZ(I)-VD(I,ISPOT))**2
      IF (R.GT.P)GO TO 110
      DO 100 I=1,3
100   VD(I,ISPOT+NSPOT)=VD(I,ISPOT+NSPOT)+S*XYZ(I)
      WEIGHT(ISPOT+NSPOT)=WEIGHT(ISPOT+NSPOT)+1.0
      GO TO 130
110   CONTINUE
120   CONTINUE
130   CONTINUE
140   CONTINUE
      DO 160 ISPOT=NSPOT+1,NSPOT+NSPOT
      W=WEIGHT(ISPOT)
      IF (W.LT.1.0)GO TO 160
      NV=NV+1
      DO 150 I=1,3
150   VD(I,NV)=VD(I,ISPOT)/W
      WEIGHT(NV)=W
160   CONTINUE
      NSPOT=NV
C
C---- sort list of difference vectors in decreasing population
C
      CALL QSORT2(NSPOT,VD,WEIGHT)
      RETURN
      END
C
C
C
C
C     ===============================================
      SUBROUTINE FITZEL(RB,LATCH,BT,IDXB,CELLB,W,IER)
C     ===============================================
      IMPLICIT NONE
C
C
C
C***********************************************************************
C
C     TESTS THE 44 LATTICE CHARACTERS AGAINST A GIVEN REDUCED BASE
C                     W.KABSCH 10-1991
C
C***********************************************************************
C
C     REFERENCE: INTERNATIONAL TABLES FOR CRYSTALLOGRAPHY
C                Volume A, SPACE-GROUP SYMMETRY
C                KLUWER ACADEMIC PUBLISHERS, DORDRECHT/BOSTON/LONDON
C                Second, revised edition  1989, p. 746
C     COMMENTS:  BRAVAIS-TYPE mI DOES NOT OCCUR IN THE OLDER EDITION
C                OF THE INTERNATIONAL TABLES. mI (Lattice character 43)
C                CORRESPONDS TO CELL CHOICE 3 IN SPACE GROUP C2 WITH
C                THE REFLECTION CONDITION h+k+l=even. XDS IS UNABLE
C                TO DEAL WITH THIS CASE DIRECTLY. INSTEAD OF THE
C                CORRECT TRANSFORMATION -100/-1-1-2/0-10 FROM THE
C                REDUCED CELL TO THE CONVENTIONAL BASIS, THE TRANS-
C                FORMATION 110/112/0-10 IS USED WHICH MAINTAINS
C                THE REFLECTION CONDITION h+k=even AS REQUIRED FOR
C                SPACE GROUP C2 IN THE XDS-PROGRAM. AS A CONSEQUENCE
C                THE MONOCLINIC CELL BASIS MAY NOT CORRESPOND TO THE
C                NEW STANDARD.
C                THE TRANSFORMATION FOR LATTICE CHARACTER 17 GIVEN IN
C                TABLE 9.3.1 IN THE INTERNATIONAL TABLES IS WRONG:
C                INSTEAD OF 1-10/110/-10-1 (determinant -2) IT MUST
C                BE 1-10/-1-10/-10-1.
C
C***********************************************************************
C   RB   - BASIS VECTORS OF A REDUCED CELL ("BURGER-CELL")       (GIVEN)
C          WHICH IS DEFINED BY THE SHORTEST THREE LINEAR
C          INDEPENDENT LATTICE VECTORS FORMING A RIGHT-HANDED
C          SET. THE THREE VECTORS ARE SORTED IN INCREASING
C          LENGTH AND ARE STORED ROW-WISE ! NOTE ALSO THAT
C          THE REDUCED CELL AS DEFINED HERE MAY NOT BE UNIQUE !
C LATCH  - INTEGER*2 ARRAY(44) OF LATTICE CHARACTERS            (RESULT)
C   BT   - CHARACTER*2 ARRAY(44) CONTAINING THE BRAVAIS-TYPE    (RESULT)
C          FOR EACH OF THE 44 LATTICE CHARACTERS.
C  IDXB  - INTEGER*2 ARRAY(12,44) OF REINDEXING TRANSFORMATIONS (RESULT)
C          FOR EACH OF THE 44 LATTICE CHARACTERS.
C          A REFLECTION WITH INDICES H,K,L WITH RESPECT TO THE
C          GIVEN REDUCED CELL "RB" HAS THE NEW INDICES H',K',L'
C          WITH RESPECT TO EACH LATTICE CHARACTER SUCH THAT
C          H' =IDXB(1,.)*H+IDXB( 2,.)*K+IDXB( 3,.)*L+IDXB( 4,.)
C          K' =IDXB(5,.)*H+IDXB( 6,.)*K+IDXB( 7,.)*L+IDXB( 8,.)
C          L' =IDXB(9,.)*H+IDXB(10,.)*K+IDXB(11,.)*L+IDXB(12,.)
C CELLB  - REAL*4 ARRAY(6,44) OF CELL PARAMETERS FOR EACH OF    (RESULT)
C          THE 44 LATTICE CHARACTERS. (ANGSTROEM & DEGREES)
C   W    - REAL*4 ARRAY(44) CONTAINING A QUALITY MEASURE OF     (RESULT)
C          EXPLANATION OF THE OBSERVED REDUCED CELL BY EACH
C          OF THE 44 LATTICE CHARACTERS. A SMALL VALUE MEANS
C          A GOOD EXPLANATION.
C   IER  - ERROR FLAG: 0:NO ERROR, -1:ILLEGAL REDUCED CELL      (RESULT)
C***********************************************************************
      INTEGER      MAXIDX,NMAX,IER,II,IH,IK,IL,M1,M2,IXJH,IXJK,IXJL,
     1             I,J,K,M,N,L1,L2
      PARAMETER    (MAXIDX=1,NMAX=26)
      CHARACTER*2  BT(44)
      CHARACTER*44 BRAVT(2)
      INTEGER*2    IHKL(3,NMAX),IDXB(12,44),TCB(9*44),T1(9*22),T2(9*22),
     1             LATCH(44),LATCH0(44)
      REAL         QNORM(NMAX),CELLB(6,44),W(44),P(44),SS(25),S(6),
     1             RB(3,3),A(3,3),B(3,3),BOUND(3),Q,CUT
      PARAMETER    (CUT=0.2)
      EQUIVALENCE  (TCB,T1),(TCB(1+9*22),T2(1))
      DATA T1/  1,-1, 1, 1, 1,-1,-1, 1, 1,   1,-1, 0,-1, 0, 1,-1,-1,-1,
     1          1, 0, 0, 0, 1, 0, 0, 0, 1,   1, 0, 1, 1, 1, 0, 0, 1, 1,
     2          1,-1, 0,-1, 0, 1,-1,-1,-1,   0, 1, 1, 1, 0, 1, 1, 1, 0,
     3          1, 0, 1, 1, 1, 0, 0, 1, 1,  -1,-1, 0,-1, 0,-1, 0,-1,-1,
     4          1, 0, 0,-1, 1, 0,-1,-1, 3,   1, 1, 0, 1,-1, 0, 0, 0,-1,
     5          1, 0, 0, 0, 1, 0, 0, 0, 1,   1, 0, 0, 0, 1, 0, 0, 0, 1,
     6          1, 1, 0,-1, 1, 0, 0, 0, 1,   1, 0, 0, 0, 1, 0, 1, 1, 2,
     7         -1,-1, 0, 1,-1, 0, 1, 1, 2,   1, 1, 0,-1, 1, 0, 0, 0, 1,
     8          1,-1, 0,-1,-1, 0,-1, 0,-1,   0,-1, 1, 1,-1,-1, 1, 0, 0,
     9         -1, 0, 0, 0,-1, 1,-1, 1, 1,   0, 1, 1, 0, 1,-1,-1, 0, 0,
     A          0, 1, 0, 0, 0, 1, 1, 0, 0,   0, 1, 0, 0, 0, 1, 1, 0, 0/
      DATA T2/  0, 1, 1, 0,-1, 1, 1, 0, 0,   1, 2, 1, 0,-1, 1, 1, 0, 0,
     C          0, 1, 1, 0,-1, 1, 1, 0, 0,   1, 0, 0,-1, 2, 0,-1, 0, 2,
     D         -1, 2, 0,-1, 0, 0, 0,-1, 1,  -1, 0, 0,-1, 0, 2, 0, 1, 0,
     E          1, 0, 0, 1,-2, 0, 0, 0,-1,   0, 1, 0, 0, 1,-2,-1, 0, 0,
     F          1, 0, 0, 0, 1, 0, 0, 0, 1,   1, 0, 0, 0, 1, 0, 0, 0, 1,
     G          0,-1, 0, 0, 1, 2,-1, 0, 0,   0,-1, 0,-1, 0, 0, 0, 0,-1,
     H          1, 0, 0,-1, 0,-2, 0, 1, 0,   1, 0, 0, 0, 1, 0, 0, 0, 1,
     I         -1, 0, 0, 1, 2, 0, 0, 0,-1,  -1, 0, 0, 0, 0,-1, 0,-1, 0,
     J         -1, 0, 0, 0,-1, 0, 1, 1, 2,   0,-1,-2, 0,-1, 0,-1, 0, 0,
     K          1, 0, 2, 1, 0, 0, 0, 1, 0,  -1,-2, 0,-1, 0, 0, 0, 0,-1,
     L          1, 1, 0, 1, 1, 2, 0,-1, 0,   1, 0, 0, 0, 1, 0, 0, 0, 1/
      DATA BRAVT/'cFhRcPcIhRtItIoIhRmCtPhPoCtIoFmCmCtIoImCtPhP',
     1           'oChRmCoFmCmCmCmCaPoPoCmPoCmPoCmPoImCmCmCmIaP'/
      DATA LATCH0/1,2,3,5,4,6,7,8, 9,10,11,12,13,15,16,14,17,
     1           18,19,20,21,22,23,24,25, 26,27,28,29,30,31,
     2           32,40,35,36,33,38,34,42,41,37,39,43,44/
C
C
C
C
C----  check reduced cell for singularity
C
      CALL INVERS(RB,A,Q)
      IF (Q.LE.0.0)GO TO 350
C
C---- set bounds for possible basis vectors
C      of the "true" reduced cell
C
      S(1)=RB(1,1)**2+RB(1,2)**2+RB(1,3)**2
      S(2)=RB(2,1)**2+RB(2,2)**2+RB(2,3)**2
      S(3)=RB(3,1)**2+RB(3,2)**2+RB(3,3)**2
      BOUND(1)=AMIN1(S(1),S(2),S(3))
      BOUND(3)=AMAX1(S(1),S(2),S(3))
      BOUND(2)=S(1)*S(2)*S(3)/(BOUND(1)*BOUND(3))
C
C---- generate a list of possible basis vectors of the "true" cell
C
      N=0
      DO 100 IH=-MAXIDX,MAXIDX
      DO 100 IK=-MAXIDX,MAXIDX
      DO 90  IL=-MAXIDX,MAXIDX
      IF ((IH.EQ.0).AND.(IK.EQ.0).AND.(IL.EQ.0))GO TO 90
C
C----- ih,ik,il must be relative prime
C
      I=2
10    IF (I.GT.MAXIDX)GO TO 20
      IF ((IH.EQ.I*(IH/I)).AND.(IK.EQ.I*(IK/I)).AND.(IL.EQ.I*(IL/I)))
     @GO TO 90
      I=I+1
      GO TO 10
C
C----- calculate squared length of vector
C
20    Q=0.0
      DO 30 I=1,3
30    Q=Q+(RB(1,I)*IH+RB(2,I)*IK+RB(3,I)*IL)**2
      IF (Q.GT.((1.0+CUT)*BOUND(3)))GO TO 90
      IF (N.GE.NMAX)GO TO 40
      N=N+1
      GO TO 50
40    IF (Q.GE.QNORM(N))GO TO 90
50    QNORM(N)=Q
      IHKL(1,N)=IH
      IHKL(2,N)=IK
      IHKL(3,N)=IL
C
C----- sort in increasing vector length
C
      IF (N.LT.2)GO TO 90
60    II=0
      DO 80 M1=1,N-1
      DO 80 M2=M1+1,N
      IF (QNORM(M1).LE.QNORM(M2))GO TO 80
      Q=QNORM(M1)
      QNORM(M1)=QNORM(M2)
      QNORM(M2)=Q
      DO 70 II=1,3
      M=IHKL(II,M1)
      IHKL(II,M1)=IHKL(II,M2)
70    IHKL(II,M2)=M
80    CONTINUE
      IF (II.NE.0)GO TO 60
90    CONTINUE
100   CONTINUE
C
C---- find the best fitting "true" reduced base
C        for each of the 44 lattice characters
C
      DO 110 I=1,44
110   W(I)=1.0E+30
      DO 250 I=1,N
C
C----- check length of first vector
C
      IF (ABS(QNORM(I)-BOUND(1)).GT.CUT*BOUND(1))GO TO 250
      DO 150 II=1,3
150   B(1,II)=RB(1,II)*IHKL(1,I)+RB(2,II)*IHKL(2,I)+RB(3,II)*IHKL(3,I)
      DO 240 J=1,N
C
C----- check length of second vector
C
      IF (ABS(QNORM(J)-BOUND(2)).GT.CUT*BOUND(2))GO TO 240
C
C----- test first two vectors for collinearity
C
      IXJH=IHKL(2,I)*IHKL(3,J)-IHKL(3,I)*IHKL(2,J)
      IXJK=IHKL(3,I)*IHKL(1,J)-IHKL(1,I)*IHKL(3,J)
      IXJL=IHKL(1,I)*IHKL(2,J)-IHKL(2,I)*IHKL(1,J)
      IF ((IXJH.EQ.0).AND.(IXJK.EQ.0).AND.(IXJL.EQ.0))GO TO 240
      DO 160 II=1,3
160   B(2,II)=RB(1,II)*IHKL(1,J)+RB(2,II)*IHKL(2,J)+RB(3,II)*IHKL(3,J)
      DO 230 K=1,N
C
C----- check length of third vector
C
      IF (ABS(QNORM(K)-BOUND(3)).GT.CUT*BOUND(3))GO TO 230
C
C----- check determinant to assure that cell volume remains conserved
C
      IF ((IXJH*IHKL(1,K)+IXJK*IHKL(2,K)+IXJL*IHKL(3,K)).NE.1)GO TO 230
C
C----- triplett is considered as a potential reduced cell
C
      DO 170 II=1,3
170   B(3,II)=RB(1,II)*IHKL(1,K)+RB(2,II)*IHKL(2,K)+RB(3,II)*IHKL(3,K)
C
C----- calculate the metric tensor
C
      DO 180 M1=2,3
      DO 180 M2=1,M1-1
      II=6/(M1*M2)
      S(II)  =B(II,1)*B(II,1)+B(II,2)*B(II,2)+B(II,3)*B(II,3)
180   S(II+3)=B(M1,1)*B(M2,1)+B(M1,2)*B(M2,2)+B(M1,3)*B(M2,3)
C
C----- calculate cost function in each lattice for this triplett
C
      DO 190 II=1,6
190   SS(II)=ABS(S(II))
      SS(7)=ABS(S(1)-S(2))
      SS(8)=ABS(S(2)-S(3))
      SS(9)=ABS(S(4)-S(5))
      SS(10)=ABS(S(5)-S(6))
      SS(11)=ABS(S(4)-S(1)/2)
      SS(12)=ABS(S(4)+S(1)/2)
      SS(13)=ABS(S(4)+S(1)/3)
      SS(14)=ABS(S(4)-S(1)/4)
      SS(15)=ABS(S(4)+S(2)/2)
      SS(16)=ABS(S(4)-S(5)/2)
      SS(17)=ABS(S(4)-S(6)/2)
      SS(18)=ABS(S(4)-S(2)/2)+ABS(S(5)-S(6)/2)
      SS(19)=ABS(S(5)+S(1)/2)
      SS(20)=ABS(S(5)-S(1)/2)
      SS(21)=ABS(S(5)+S(1)/3)
      SS(22)=ABS(S(6)-S(1)/2)
      SS(23)=ABS(S(6)+S(1)/2)
      SS(24)=ABS(ABS(2*S(4)+S(6))-S(2))
      SS(25)=ABS(2*ABS(S(4)+S(5)+S(6))-(S(1)+S(2)))
      P(31)=AMAX1(0.0,S(1)-S(2))+AMAX1(0.0,S(2)-S(3))
     1     +AMAX1(0.0,2*SS(4)-S(2))+AMAX1(0.0,2*SS(5)-S(1))
     2     +AMAX1(0.0,2*SS(6)-S(1))
      P(44)=P(31)+AMAX1(0.0,2*(SS(4)+SS(5)+SS(6))-S(1)-S(2))
     @      +AMAX1(0.0,S(4))+AMAX1(0.0,S(5))+AMAX1(0.0,S(6))
      P(31)=P(31)+AMAX1(0.0,-S(4))+AMAX1(0.0,-S(5))+AMAX1(0.0,-S(6))
      P(43)=P(44)+SS(25)+SS(24)+AMAX1(0.0,S(1)-2*SS(5)-SS(6))
      P(42)=P(44)+SS(5)+SS(23)
      P(41)=P(44)+SS(6)+SS(19)
      P(40)=P(44)+SS(6)+SS(15)
      P(39)=P(40)+SS(19)
      P(38)=P(44)+SS(4)+SS(5)
      P(37)=P(42)+SS(4)
      P(36)=P(44)+SS(4)+SS(6)
      P(35)=P(41)+SS(4)
      P(34)=P(44)+SS(5)+SS(6)
      P(33)=P(34)+SS(15)
      P(32)=P(34)+SS(4)
      P(30)=P(31)+SS(18)
      P(29)=P(31)+SS(16)+SS(22)
      P(28)=P(31)+SS(17)+SS(20)
      P(27)=P(31)+SS(20)+SS(22)+AMAX1(0.0,S(6)-2*S(4))
      P(26)=P(27)+SS(14)
      P(25)=P(44)+SS(8)+SS(10)
      P(24)=P(25)+SS(21)+SS(25)
      P(23)=P(34)+SS(8)
      P(22)=P(23)+SS(15)
      P(21)=P(23)+SS(4)
      P(20)=P(31)+SS(8)+SS(10)
      P(19)=P(27)+SS(8)
      P(18)=P(26)+SS(8)
      P(17)=P(44)+SS(7)+SS(25)+AMAX1(0.0,S(1)-2*SS(5)-SS(6))
     @     +AMAX1(0.0,SS(4)-SS(5))
      P(16)=P(44)+SS(7)+SS(9)
      P(15)=P(17)+SS(9)
      P(14)=P(41)+SS(7)+SS(12)
      P(13)=P(38)+SS(7)
      P(12)=P(37)+SS(7)
      P(11)=P(32)+SS(7)
      P(10)=P(31)+SS(7)+SS(9)
      P( 9)=P(27)+SS(7)+SS(11)
      P( 8)=P(17)+SS(8)+AMAX1(0.0,SS(5)-SS(6))
      P( 7)=P( 8)+SS(10)
      P( 6)=P( 8)+SS(9)
      P( 5)=P(16)+SS(8)+SS(10)
      P( 4)=P( 5)+SS(13)
      P( 3)=P( 5)+SS(4)
      P( 2)=P(10)+SS(8)+SS(10)
      P( 1)=P( 2)+SS(11)
      DO 220 II=1,44
      IF (P(II).GT.W(II))GO TO 220
      W(II)=P(II)
      L1=0
      L2=9*(II-1)
      DO 210 M1=1,3
      DO 200 M2=1,3
200   IDXB(M2+L1,II)=TCB(1+L2)*IHKL(M2,I)+TCB(2+L2)*IHKL(M2,J)
     @              +TCB(3+L2)*IHKL(M2,K)
      L1=L1+4
      L2=L2+3
210   IDXB(L1,II)=0
220   CONTINUE
230   CONTINUE
240   CONTINUE
250   CONTINUE
C
C---- calculate cell parameters for each lattice character
C
      DO 330 N=1,44
      LATCH(N)=LATCH0(N)
      W(N)=AMIN1(100.0*W(N)/(CUT*BOUND(1)),999.0)
      M=0
      DO 280 J=1,3
      DO 270 I=1,3
      Q=0.0
      DO 260 K=1,3
260   Q=Q+RB(K,I)*IDXB(K+M,N)
270   B(J,I)=Q
280   M=M+4
      CALL METRIC(B,S,IER)
      IF (IER.NE.0)GO TO 310
      DO 290 I=1,6
290   CELLB(I,N)=S(I)
      GO TO 330
310   DO 320 I=1,6
320   CELLB(I,N)=0.0
330   CONTINUE
      DO 340 I=1,22
      BT(I   )=BRAVT(1)(2*I-1:2*I)
340   BT(I+22)=BRAVT(2)(2*I-1:2*I)
      IER=0
      RETURN
350   IER=-1
      RETURN
      END
C
C
C
C
C
      SUBROUTINE GELS(R,A,M,N,EPS,IER,AUX)
      IMPLICIT NONE
C***********************************************************************
C     PURPOSE
C        TO SOLVE A SYSTEM OF SIMULTANEOUS LINEAR EQUATIONS WITH
C        SYMMETRIC COEFFICIENT MATRIX UPPER TRIANGULAR PART OF
C        WHICH IS ASSUMED TO BE STORED COLUMNWISE.
C
C     DESCRIPTION OF PARAMETERS
C        R      - M BY N RIGHT HAND SIDE MATRIX. (DESTROYED)
C                 ON RETURN R CONTAINS THE SOLUTION OF THE EQUATIONS.
C        A      - UPPER TRIANGULAR PART OF THE SYMMETRIC M BY M
C                 COEFFICIENT MATRIX. (DESTROYED)
C        M      - THE NUMBER OF EQUATIONS IN THE SYSTEM.
C        N      - THE NUMBER OF RIGHT HAND SIDE VECTORS.
C        EPS    - AN INPUT CONSTANT WHICH IS USED AS RELATIVE
C                 TOLERANCE FOR TEST ON LOSS OF SIGNIFICANCE.
C        IER    - ERROR PARAMETER CODED AS FOLLOWS
C                 IER=0   NO ERROR
C                 IER=-1  NO RESULT BECAUSE OF M LESS THAN 1 OR
C                         PIVOT ELEMENT AT ANY ELIMINATION STEP
C                         EQUAL TO 0.
C                 IER=K   WARNING DUE TO POSSIBLE LOSS OF
C                         SIGNIFICANCE INDICATED AT ELIMINATION STEP
C                         K+1, WHERE PIVOT ELEMENT WAS LESS THAN
C                         THE INTERNAL TOLERANCE EPS TIMES THE
C                         ABSOLUTE GREATEST MAIN DIAGONAL ELEMENT
C                         OF MATRIX A.
C        AUX    - AN  AUXILIARY STORAGE ARRAY OF DIMENSION M-1.
C
C     REMARKS
C        UPPER TRIANGULAR PART OF MATRIX A IS ASSUMED TO BE STORED
C        COLUMNWISE IN M*(M+1)/2 SUCCESSIVE STORAGE LOCATIONS,
C        RIGHT HAND SIDE MATRIX R COLUMNWISE IN N*M SUCCESSIVE
C        STORAGE LOCATIONS. ON RETURN SOLUTION MATRIX R IS STORED
C        COLUMNWISE TOO.
C
C     METHOD
C        SOLUTION IS DONE BY MEANS OF GAUSS-ELIMINATION WITH PIVOTING
C        IN MAIN DIAGONAL, IN ORDER TO PRESERVE SYMMETRY IN REMAINING
C        COEFFICIENT MATRICES.
C
C************************************************************************
C
      INTEGER   IER,I,II,J,K,L,LL,LR,LLD,LLST,LST,LT,LEND,M,NM,N
      REAL      A(*),R(*),AUX(*),EPS,PIV,PIVI,TOL,TB,ZERO,ONE,HALF
      PARAMETER (ZERO=0.0, ONE=1.0, HALF=0.5)
      IF (M.LT.1)GO TO 200
C
C---- search for greatest main diagonal element
C
      IER=0
      PIV=ZERO
      L=0
      DO 10 K=1,M
      L=L+K
      TB=ABS(A(L))
      IF (TB.LE.PIV)GO TO 10
      PIV=TB
      I=L
      J=K
10    CONTINUE
      TOL=EPS*PIV
C
C---- start elimination loop
C
      LST=0
      NM=N*M
      LEND=M-1
      DO 110 K=1,M
C
C---- test on usefulness of symmetric algorithm
C
      IF (PIV.LE.ZERO)GO TO 200
      IF (IER.NE.0)GO TO 20
      IF (PIV.GT.TOL)GO TO 20
      IER=K-1
20    LT=J-K
      LST=LST+K
C
C---- pivot row reduction and row interchange in right hand side r
C
      PIVI=ONE/A(I)
      DO 30 L=K,NM,M
      LL=L+LT
      TB=PIVI*R(LL)
      R(LL)=R(L)
30    R(L)=TB
C
C---- check if elimination is terminated
C
      IF (K.GE.M)GO TO 120
C
C---- row and column interchange and pivot row reduction in matrix a.
C     elements of pivot column are saved in auxiliary vector aux.
C
      LR=LST+(LT*(K+J-1))/2
      LL=LR
      L=LST
      DO 80 II=K,LEND
      L=L+II
      LL=LL+1
      IF (L-LR)60,40,50
40    A(LL)=A(LST)
      TB=A(L)
      GO TO 70
50    LL=L+LT
60    TB=A(LL)
      A(LL)=A(L)
70    AUX(II)=TB
80    A(L)=PIVI*TB
C
C---- save column interchange information
C
      A(LST)=LT
C
C---- element reduction and search for next pivot
C
      PIV=ZERO
      LLST=LST
      LT=0
      DO 110 II=K,LEND
      PIVI=-AUX(II)
      LL=LLST
      LT=LT+1
      DO 90 LLD=II,LEND
      LL=LL+LLD
      L=LL+LT
90    A(L)=A(L)+PIVI*A(LL)
      LLST=LLST+II
      LR=LLST+LT
      TB=ABS(A(LR))
      IF (TB.LE.PIV)GO TO 100
      PIV=TB
      I=LR
      J=II+1
100   DO 110 LR=K,NM,M
      LL=LR+LT
110   R(LL)=R(LL)+PIVI*R(LR)
C
C---- back substitution and back interchange
C
120   IF (LEND)200,160,130
130   II=M
      DO 150 I=2,M
      LST=LST-II
      II=II-1
      L=A(LST)+HALF
      DO 150 J=II,NM,M
      TB=R(J)
      LL=J
      K=LST
      DO 140 LT=II,LEND
      LL=LL+1
      K=K+LT
140   TB=TB-A(K)*R(LL)
      K=J+L
      R(J)=R(K)
150   R(K)=TB
160   RETURN
C
C---- error return
C
200   IER=-1
      RETURN
      END
C
C
C
C
C     ======================================
      SUBROUTINE GENABS(ABSTYP,IH,IK,IL,IDX)
C     ======================================
      IMPLICIT NONE
C
C
C
C
C      TEST A REFLECTION IH,IK,IL FOR GENERAL SYSTEMATIC ABSENCE
C
C                        VERSION 10-1986
C
C*************** DESCRIBTION OF CALLING PARAMETERS *********************
C
C  ABSTYP  - AN INTEGER VALUE DESCRIBING CONDITIONS LIMITING     (GIVEN)
C            POSSIBLE REFLECTIONS
C            0: NO CONDITIONS ON h,k,l
C            1: h+k MUST BE EVEN
C            2: h+l MUST BE EVEN
C            3: k+l MUST BE EVEN
C            4: h+k+l MUST BE EVEN
C            5: -h+k+l MUST BE A MULTIPLE OF 3
C            6: h+k and h+l MUST BE EVEN
C IH,IK,IL - REFLECTION INDICES                                  (GIVEN)
C   IDX    - INTEGER SPECIFYING RESULT OF TEST                  (RESULT)
C            ZERO:     REFLECTION IS ALLOWED
C            NOT ZERO: REFLECTION IS GENERALLY ABSENT
C****************** DECLARATION OF VARIABLES ***************************
      INTEGER    ABSTYP,IH,IK,IL,IDX
C***********************************************************************
      IDX=0
      IF (ABSTYP.LT.1)GO TO 80
      IF (ABSTYP.GT.6)GO TO 80
      GO TO (10,20,30,40,60,70),ABSTYP
10    IDX=IH+IK
      GO TO 50
20    IDX=IH+IL
      GO TO 50
30    IDX=IK+IL
      GO TO 50
40    IDX=IH+IK+IL
50    IDX=IDX-2*(IDX/2)
      GO TO 80
60    IDX=IK+IL-IH
      IDX=IDX-3*(IDX/3)
      GO TO 80
70    IDX=IH+IK
      IDX=IDX-2*(IDX/2)
      IF (IDX)80,20,80
80    RETURN
      END
C
C
C
C
      SUBROUTINE GONSYS(ACHSE,S0L,S0G,EG,IER)
      IMPLICIT NONE
      INTEGER    IER,I
      REAL       ACHSE(3),S0L(3),S0G(3),EG(3,3)
      DO 10 I=1,3
      EG(I,2)=ACHSE(I)
10    EG(I,3)=S0L(I)
      CALL UNORM(EG,IER)
      DO 20 I=1,3
20    S0G(I)=EG(1,I)*S0L(1)+EG(2,I)*S0L(2)+EG(3,I)*S0L(3)
      RETURN
      END
C
C
C
C
      SUBROUTINE GRIDIDX(N,V,RBASE,ERRINT,MAXIDX,IP,IQ,IW,IH,IK,IL,NACC)
      IMPLICIT NONE
C***********************************************************************
C
C  INDEX A GRID OF POINTS BY THE LOCAL INDEXING METHOD.  W.KABSCH 8-1992
C  THE IMPLEMENTATION IS BASED ON DIJKSTRA'S ALGORITHM
C  OF FINDING THE SHORTEST SUBSPANNING TREE.
C
C*************** DESCRIPTION OF CALLING PARAMETERS *********************
C
C    N    - NUMBER OF REFLECTIONS IN ARRAY V                     (GIVEN)
C    V    - REAL ARRAY(3,*) OF REFLECTION COORDINATES            (GIVEN)
C  RBASE  - REAL ARRAY(3,3) OF BASE VECTORS OF THE GRID.         (GIVEN)
C  ERRINT - TOLERANCE VALUE FOR GRID INDICES DEVIATING           (GIVEN)
C           FROM INTEGRAL VALUES.
C  MAXIDX - THE MAXIMUM ABSOLUTE VALUE OF AN INDEX ASSIGNED TO   (GIVEN)
C           ANY DIFFERENCE VECTOR.
C IP,IQ,IW- INTEGER*2 ARRAY(N) USED FOR STORING POINTERS TO     (RESULT)
C           GRID POINTS OF THE SHORTEST SUBSPANNING TREE.
C IH,IK,IL- INTEGER*2 ARRAY(N) CONTAINING INDICES OF THE        (RESULT)
C           GRID POINTS. INDICES 0,0,0 INDICATE A POINT
C           OUTSIDE THE GRID BY MORE THAN THE VALUE OF "ERRINT".
C   NACC  - INTEGER*4 VARIABLE CONTAINING THE NUMBER OF         (RESULT)
C           INDEXED GRID POINTS. AN ERROR CONDITION IS
C           INDICATED BY
C           NACC=-1 IF (N>32767) OR (N<2) OR (DET(RBASE)<=0)
C
C***********************************************************************
C
C        SUBROUTINES REQUIRED: INVERS,WIDX
C
C***********************************************************************
      INTEGER    MHKL(3),MAXIDX,LARGE,J,LCR,NR,SUV,P,Q,H
      INTEGER*4  N,NACC
      INTEGER*2  IH(N),IK(N),IL(N),IP(N),IQ(N),IW(N),LEN,MINLEN,AUX
      REAL       V(3,N),RBASE(3,3),BASE(3,3),T(3),ERRINT,X,Y,Z,RR
      PARAMETER  (LARGE=32767)
C***********************************************************************
      NACC=-1
      IF ((N.GT.32767).OR.(N.LT.2))RETURN
      CALL INVERS(RBASE,BASE,RR)
      IF (RR.LE.0.0)RETURN
C
C----  find the shortest subspanning tree (dijkstra)
C      connect all points with a virtual point 0 at infinite distance
C
      DO 10 J=1,N
      IP(J)=0
      IQ(J)=J
10    IW(J)=LARGE
C
C----- select point n that is initially coloured red
C
      LCR=N
C
C----- number of red points is nr=1
C
      NR=1
20    IF (NR.EQ.N)GO TO 60
      SUV=0
      MINLEN=LARGE
      H=NR
C
C----- find the shortest ultraviolet branch
C
30    IF (H.EQ.N)GO TO 50
      J=IQ(H)
      X=V(1,J)-V(1,LCR)
      Y=V(2,J)-V(2,LCR)
      Z=V(3,J)-V(3,LCR)
      T(1)=BASE(1,1)*X+BASE(1,2)*Y+BASE(1,3)*Z
      T(2)=BASE(2,1)*X+BASE(2,2)*Y+BASE(2,3)*Z
      T(3)=BASE(3,1)*X+BASE(3,2)*Y+BASE(3,3)*Z
      CALL WIDX(MAXIDX,ERRINT,T,MHKL,RR)
      LEN=NINT((1.0-RR)*10000)
      IF (LEN.LE.IW(H))THEN
	 IW(H)=LEN
	 IP(H)=LCR
      ELSE
	 LEN=IW(H)
      ENDIF
      IF (LEN.GE.MINLEN)GO TO 40
      MINLEN=LEN
      SUV=H
40    H=H+1
      GO TO 30
C
C----- record points connected by the selected branch
C
50    AUX=IP(NR)
      IP(NR)=IP(SUV)
      IP(SUV)=AUX
      AUX=IQ(NR)
      IQ(NR)=IQ(SUV)
      IQ(SUV)=AUX
C
C----- update length array of ultraviolet branches
C
      AUX=IW(NR)
      IW(NR)=IW(SUV)
      IW(SUV)=AUX
C
C----- set point last coloured red
C
      LCR=IQ(NR)
C
C----- increment number of red points
C
      NR=NR+1
      GO TO 20
C
C----  index all points
C
60    IH(N)=0
      IK(N)=0
      IL(N)=0
      DO 70 J=1,N-1
      P=IP(J)
      Q=IQ(J)
      X=V(1,Q)-V(1,P)
      Y=V(2,Q)-V(2,P)
      Z=V(3,Q)-V(3,P)
      T(1)=BASE(1,1)*X+BASE(1,2)*Y+BASE(1,3)*Z
      T(2)=BASE(2,1)*X+BASE(2,2)*Y+BASE(2,3)*Z
      T(3)=BASE(3,1)*X+BASE(3,2)*Y+BASE(3,3)*Z
      CALL WIDX(MAXIDX,ERRINT,T,MHKL,RR)
      IW(J)=NINT(RR*10000.0)
      IH(Q)=IH(P)+MHKL(1)
      IK(Q)=IK(P)+MHKL(2)
70    IL(Q)=IL(P)+MHKL(3)
C
C---- remove bad spots
C
      DO 80 J=1,N-1
      IF (IW(J).GT.8000)GO TO 80
      Q=IQ(J)
      IH(Q)=LARGE
80    CONTINUE
C
C---- find origin of indices
C
      NACC=0
      DO 90 J=1,3
90    T(J)=0.0
      DO 110 Q=1,N
      IF (IH(Q).EQ.LARGE)GO TO 110
      NACC=NACC+1
      X=IH(Q)
      Y=IK(Q)
      Z=IL(Q)
      DO 100 J=1,3
100   T(J)=T(J)+RBASE(J,1)*X+RBASE(J,2)*Y+RBASE(J,3)*Z-V(J,Q)
110   CONTINUE
      IF (NACC.LT.1)RETURN
      X=T(1)/NACC
      Y=T(2)/NACC
      Z=T(3)/NACC
      MHKL(1)=NINT(BASE(1,1)*X+BASE(1,2)*Y+BASE(1,3)*Z)
      MHKL(2)=NINT(BASE(2,1)*X+BASE(2,2)*Y+BASE(2,3)*Z)
      MHKL(3)=NINT(BASE(3,1)*X+BASE(3,2)*Y+BASE(3,3)*Z)
      DO 120 Q=1,N
      IF (IH(Q).EQ.LARGE)THEN
	  IH(Q)=0
	  IK(Q)=0
	  IL(Q)=0
      ELSE
	  IH(Q)=IH(Q)-MHKL(1)
	  IK(Q)=IK(Q)-MHKL(2)
	  IL(Q)=IL(Q)-MHKL(3)
      ENDIF
120   CONTINUE
      RETURN
      END
C
C
C
C
C
      SUBROUTINE INDIX(ABSTYP,Q,ORGX,ORGY,F,ED,ACHSE,S0L,RCELL,U,MXRFL,
     @      NRFL0,NRFL,IX,IY,IPHI,IH,IK,IL,NACC,NOVLAP,NFAR,SDPHI,SDXY)
      IMPLICIT NONE
C
C
C
C*******                                                       *********
C*******    INDEX A LIST OF SPOTS GIVEN THEIR DETECTOR         *********
C*******    COORDINATES AND SPINDLE POSITIONS.                 *********
C*******           WOLFGANG KABSCH    6-1986, revised 11-1987  *********
C*******                                                       *********
C***********************************************************************
C
C  SUBROUTINES REQUIRED: GENABS,GONSYS,INVERS,RFMATMUL,RFSETMAT
C
C***********************************************************************
C ABSTYP - CONSTRAINT NUMBER FOR GENERAL CONDITIONS LIMITING     (GIVEN)
C          POSSIBLE REFLECTIONS.
C   Q    - LENGTH OF A PIXEL IN MILLIMETERS                      (GIVEN)
C ORGX   - X- AND Y-COORDINATES (PIXELS) OF ORIGIN ON DETECTOR   (GIVEN)
C ORGY   - PLANE.                                                (GIVEN)
C   F    - CRYSTAL TO DETECTOR DISTANCE (MM).                    (GIVEN)
C   ED   - REAL ARRAY(3,3) SPECIFYING LAB COORDINATES OF         (GIVEN)
C          DETECTOR AXES.
C ACHSE  - ARRAY(3) SPECIFYING LAB COORDINATES OF ROTATION AXIS  (GIVEN)
C  S0L   - LAB COORDINATES OF INCIDENT X-RAY BEAM WAVE VECTOR.   (GIVEN)
C          LENGTH OF S0L IS 1.0/LAMBDA. ( RECIPROCAL ANGSTROEM )
C RCELL  - ARRAY OF LENGTH 6 OF RECIPROCAL UNIT CELL PARAMETERS  (GIVEN)
C          IN RECIPROCAL ANGSTROEM AND DEGREES.
C   U    - ARRAY(3,3) CONTAINING ORIENTATION MATRIX              (GIVEN)
C MXRFL  - DIMENSION OF ARRAYS IH,IK,IL,IPHI,IX,IY               (GIVEN)
C NRFL0  - DEFINES POSITION IN ARRAYS IH,IK,IL,... WHERE         (GIVEN)
C          INDEXING SHOULD START. THE FIRST ADDRESS IS
C          MOD(NRFL0,MXRFL)+1 ,   THE LAST  ADDRESS IS
C          MOD(NRFL0+NRFL-1,MXRFL)+1
C  NRFL  - NUMBER OF REFLECTIONS TO BE INDEXED                   (GIVEN)
C   IX   - INTEGER*2 ARRAY SPECIFYING X-POSITION ON DETECTOR     (GIVEN)
C          FOR EACH SPOT IN THE LIST ( TENTH OF A PIXEL)
C   IY   - INTEGER*2 ARRAY SPECIFYING Y-POSITION ON DETECTOR     (GIVEN)
C          FOR EACH SPOT IN THE LIST ( TENTH OF A PIXEL)
C  IPHI  - INTEGER*2 ARRAY SPECIFYING ANGULAR POSITION OF        (GIVEN)
C          SPINDLE. THE VALUES ARE GIVEN IN UNITS OF A
C          HUNDRETH OF A DEGREE. IPHI(JRFL) REFERS TO THE
C          SPOT LOCATED AT IX(JRFL),IY(JRFL).
C   IH   - INTEGER*2 ARRAY SPECIFYING H-INDICES FOR THE SPOTS   (RESULT)
C          LOCATED AT IX,IY,IPHI
C   IK   - INTEGER*2 ARRAY SPECIFYING K-INDICES FOR THE SPOTS   (RESULT)
C          LOCATED AT IX,IY,IPHI.
C   IL   - INTEGER*2 ARRAY SPECIFYING L-INDICES FOR THE SPOTS   (RESULT)
C          LOCATED AT IX,IY,IPHI.
C  NACC  - NUMBER OF INDEXED SPOTS. AN ERROR IS INDICATED IF    (RESULT)
C          NACC<=0.
C           >0 : NO ERROR.
C            0 : INSUFFICIENT NUMBER OF ACCEPTED REFLECTIONS
C           -1 : Q IS NOT POSITIVE
C           -2 : F IS ZERO
C           -3 : ILLEGAL CELL PARAMETERS
C           -4 : ILLEGAL ROTATION AXIS OR DIRECT BEAM WAVE VECTOR
C NOVLAP - NUMBER OF SPOTS WHICH COULD NOT BE INDEXED BECAUSE   (RESULT)
C          MORE THAN ONE PREDICTED POSITION WAS FOUND TO BE
C          WITHIN 3*SDXY AND 3*SDPHI. TO INDICATE THIS CASE
C          REFLECTION INDICES 0,0,0 ARE ASSIGNED.
C  NFAR  - NUMBER OF SPOTS WHICH COULD NOT BE INDEXED BECAUSE   (RESULT)
C          OF A DISTANCE GREATER THAN 3*SDXY OR 3*SDPHI TO ANY
C          POSSIBLE PREDICTED POSITION. TO INDICATE THIS CASE
C          REFLECTION INDICES 0,0,0 ARE ASSIGNED.
C SDPHI  - STANDARD DEVIATION OF ANGULAR POSITION OF SPINDLE  (MODIFIED)
C          ( DEGREES ). A POSITIVE INPUT VALUE IS USED TO
C          COMPARE DIFFERENCES BETWEEN OBSERVED AND CALCULATED
C          SPINDLE POSITIONS OF THE REFLECTIONS.
C          A NON-POSITIVE VALUE INDICATES THAT A DEFAULT
C          VALUE OF 0.1 DEGREES SHOULD BE USED.
C          ON RETURN, SDPHI CONTAINS THE ESTIMATED STANDARD
C          DEVIATION OF THE SPINDLE ANGLE AT WHICH THE
C          REFLECTIONS WERE DIFFRACTING.
C  SDXY  - STANDARD DEVIATION OF SPOT POSITION ON DETECTOR    (MODIFIED)
C          (PIXELS). A POSITIVE INPUT VALUE IS USED TO
C          COMPARE DIFFERENCES BETWEEN OBSERVED AND CALCULATED
C          SPOT POSITIONS OF THE REFLECTIONS.
C          A NON-POSITIVE VALUE INDICATES THAT A DEFAULT
C          VALUE OF 3 PIXELS SHOULD BE USED.
C          ON RETURN, SDXY CONTAINS THE ESTIMATED STANDARD
C          DEVIATION OF THE SPOT POSITIONS ON THE DETECTOR.
C
C***********************************************************************
      INTEGER*2 IH(*),IK(*),IL(*),IPHI(*),IX(*),IY(*),I2PHI
      INTEGER*4 NRFL0
      INTEGER   MXRFL,NRFL,JRFL,NACC,IHKL(6),J,K,I1,I2,I3,
     @          J1,J2,J3,IDX,NY,NIX,NFAR,NOVLAP,ABSTYP
      REAL      U(3,3),A0(3,3),A(3,3),B(3,3),RCELL(6),ACHSE(3),ED(3,3),
     1          EG(3,3),S0L(3),S0G(3),X0L(3),X0G(3),XL(3),XG(3),SL(3),
     2          SD(3),PD(3),Q,F,ORGX,ORGY,R,RR,RHOQ,SS,X,Y,Z,FH,FK,FL,
     3          XOBS,YOBS,CPHI,SPHI,CPHIC,SPHIC,DELTA0,DELTA,SDPHI,
     4          SDXY,DELPHI,DELXY,ERRXY,ERRPHI,WPHI,WXY,RAD,RAD100,CUT
      PARAMETER (RAD=57.29578, RAD100=100.0*RAD , CUT=5.0)
C
C----  check calling parameters
C
      IF ((MXRFL.LT.1).OR.(NRFL0.LT.0).OR.(NRFL.LT.1))THEN
	 NACC=0
	 RETURN
      ENDIF
      IF (Q.LE.0.0)THEN
	 NACC=-1
	 RETURN
      ENDIF
      IF (F.EQ.0.0)THEN
	 NACC=-2
	 RETURN
      ENDIF
C
C----  calculate setting matrix and check for positive volume
C
      CALL RFSETMAT(RCELL,A0)
      CALL RFMATMUL(U,A0,A)
      CALL INVERS(A,B,R)
      IF (R.LE.0.0)THEN
	 NACC=-3
	 RETURN
      ENDIF
C
C----  define goniostat system
C
      CALL GONSYS(ACHSE,S0L,S0G,EG,J)
      SS=S0L(1)**2+S0L(2)**2+S0L(3)**2
      IF ((J.NE.0).OR.(SS.LE.0.0))THEN
	 NACC=-4
	 RETURN
      ENDIF
C
C----  get test values to compare differences between observed
C      and predicted quantities.
C
      R=0.1
      IF (SDPHI.GT.0.0)R=SDPHI
      WPHI=(RAD/R)**2
      WXY =1.0/(3.0*Q)**2
      IF (SDXY.GT.0.0)WXY=1.0/(SDXY*Q)**2
C
C----  indexing loop 
C
      NACC=0
      NFAR=0
      NOVLAP=0
      SDXY=0.0
      SDPHI=0.0
      I2PHI=0
      CPHI=1.0
      SPHI=0.0
      DO 100 JRFL=1,NRFL
      NY=MOD(JRFL-1+NRFL0,MXRFL)+1
      XOBS=(IX(NY)/10.0-ORGX)*Q
      YOBS=(IY(NY)/10.0-ORGY)*Q
      IF (I2PHI.NE.IPHI(NY))THEN
	I2PHI=IPHI(NY)
	R=I2PHI/RAD100
	CPHI=COS(R)
	SPHI=SIN(R)
      ENDIF
      X=ED(1,1)*XOBS+ED(1,2)*YOBS+ED(1,3)*F
      Y=ED(2,1)*XOBS+ED(2,2)*YOBS+ED(2,3)*F
      Z=ED(3,1)*XOBS+ED(3,2)*YOBS+ED(3,3)*F
      R=SQRT((X*X+Y*Y+Z*Z)/SS)
      X=X/R-S0L(1)
      Y=Y/R-S0L(2)
      Z=Z/R-S0L(3)
      R=(X*ACHSE(1)+Y*ACHSE(2)+Z*ACHSE(3))*(1.0-CPHI)
      X0L(1)=X*CPHI+R*ACHSE(1)-SPHI*(ACHSE(2)*Z-ACHSE(3)*Y)
      X0L(2)=Y*CPHI+R*ACHSE(2)-SPHI*(ACHSE(3)*X-ACHSE(1)*Z)
      X0L(3)=Z*CPHI+R*ACHSE(3)-SPHI*(ACHSE(1)*Y-ACHSE(2)*X)
      DO 10 J=1,3
      R=B(J,1)*X0L(1)+B(J,2)*X0L(2)+B(J,3)*X0L(3)
      K=R+SIGN(0.5,R)
      IHKL(J)=K
      IF (R.LT.K)K=K-2
10    IHKL(J+3)=K+1
      DELTA0=1.0E+06
      NIX=0
      DO 50 I1=1,6,3
      J1=IHKL(I1)
      FH=J1
      DO 50 I2=2,6,3
      J2=IHKL(I2)
      FK=J2
      DO 50 I3=3,6,3
      J3=IHKL(I3)
      FL=J3
      CALL GENABS(ABSTYP,J1,J2,J3,IDX)
      IF (IDX.NE.0)GO TO 50
C
C----  get laboratory coordinates of reflection at phi=0
C
      DO 20 J=1,3
20    X0L(J)=A(J,1)*FH+A(J,2)*FK+A(J,3)*FL
C
C----  calculate diffraction geometry for this reflection
C
      CALL REFLEX(EG,CPHI,SPHI,S0L,S0G,X0L,X0G,XL,XG,SL,CPHIC,SPHIC,
     @            RR,RHOQ,IDX)
      IF (IDX.NE.0)GO TO 50
C
C----  get detector coordinates of diffracted beam wavevector
C
      DO 30 J=1,3
30    SD(J)=ED(1,J)*SL(1)+ED(2,J)*SL(2)+ED(3,J)*SL(3)
      IF (SD(3).EQ.0.0)GO TO 50
C
C----  get detector coordinates of intersection point of diffracted
C      beam with detector surface
C
      DO 40 J=1,3
40    PD(J)=F*SD(J)/SD(3)
      DELXY=WXY*((PD(1)-XOBS)**2+(PD(2)-YOBS)**2)
      IF (DELXY.GT.CUT)GO TO 50
      DELPHI=WPHI*((CPHI-CPHIC)**2+(SPHI-SPHIC)**2)*RHOQ/RR
      IF (DELPHI.GT.CUT)GO TO 50
      DELTA=DELPHI+DELXY
      IF (DELTA.LT.DELTA0)THEN
	DELTA0=DELTA
	ERRXY=DELXY
	ERRPHI=DELPHI
	NIX=NIX+1
	IH(NY)=J1
	IK(NY)=J2
	IL(NY)=J3
      ENDIF
50    CONTINUE
      IF (NIX-1)60,70,80
60    NFAR=NFAR+1
      GO TO 90
70    NACC=NACC+1
      SDXY=SDXY+ERRXY
      SDPHI=SDPHI+ERRPHI
      GO TO 100
80    NOVLAP=NOVLAP+1
90    IH(NY)=0
      IK(NY)=0
      IL(NY)=0
100   CONTINUE
      IF (NACC.LT.1)GO TO 110
      SDXY=SQRT(SDXY/(WXY*NACC))/Q
      SDPHI=SQRT(SDPHI/(WPHI*NACC))*RAD
110   RETURN
      END
C
C
C
C
C     ===============================
      SUBROUTINE INVCEL(CELL,RCELL,V)
C     ===============================
      IMPLICIT NONE
C
C
C
C---- Calculate reciprocal cell parameters from unit cell constants.
C     This routine may also be used to calculate the unit cell
C
C    Parameters from the reciprocal cell constants.
C
C  CELL  - unit cell constants : a,b,c,alfa,beta,gamma           (given)
C          in angstroem and degrees
C RCELL  - calculated reciprocal cell parameters                (result)
C          in reciprocal angstroem and degrees
C   V    - calculated unit cell volume in angstroem**3 .        (result)
C          v<=0.0 indicates an error situation.
C
C
      INTEGER I,J,K
      REAL    CELL(6),RCELL(6),CA(3),SA(3),ARG,V
C
C
C
      DO 10 I=1,3
      ARG=CELL(I+3)/57.29578
      CA(I)=COS(ARG)
10    SA(I)=SIN(ARG)
C
C
      V=CELL(1)*CELL(2)*CELL(3)*
     @  SQRT(1.0+2.0*CA(1)*CA(2)*CA(3)-CA(1)**2-CA(2)**2-CA(3)**2)
      IF (V.LE.0.0)GO TO 30
C
C
      DO 20 I=1,3
      J=MOD(I,3)+1
      K=MOD(I+1,3)+1
      RCELL(I)=CELL(J)*CELL(K)*SA(I)/V
      ARG=57.29578*ACOS((CA(J)*CA(K)-CA(I))/(SA(J)*SA(K)))
      J=NINT(ARG)
      IF (ABS(ARG-J).LT.0.0009)ARG=J
20    RCELL(I+3)=ARG
C
C
30    RETURN
      END
C
C
C
C     ==========================
      SUBROUTINE INVERS(A,B,DET)
C     ==========================
      IMPLICIT NONE
C
C
C
C      A    - 3 x 3 matrix                                       (given)
C      B    - 3 x 3 matrix is calculated inverse matrix of a    (result)
C      DET  - calculated determinant of given matrix a          (result)
C
C
C
      INTEGER   I,J,K
      REAL      A(3,3),B(3,3),DET
C
C
C
      DO 1 I=1,3
      J=I+1
      IF (J.GT.3)J=J-3
      K=I+2
      IF (K.GT.3)K=K-3
      B(I,1)=A(2,J)*A(3,K)-A(2,K)*A(3,J)
      B(I,2)=A(3,J)*A(1,K)-A(3,K)*A(1,J)
1     B(I,3)=A(1,J)*A(2,K)-A(1,K)*A(2,J)
C
C
      DET=A(1,1)*B(1,1)+A(1,2)*B(2,1)+A(1,3)*B(3,1)
      IF (DET.EQ.0.0)GO TO 3
C
C
      DO 2 I=1,3
      DO 2 J=1,3
2     B(I,J)=B(I,J)/DET
3     RETURN
      END
C
C
C
C
C     =====================================
      SUBROUTINE LAUESY(CELL,IGROUP,NEQ,ML)
C     =====================================
      IMPLICIT NONE
C
C
C
C
C
C  Obtain equivalent positions of laue-group from space-group number.
C  The space-group number for your crystal can be looked up in the
C  International tables for x-ray crystallography vol.i
C
C                 W.KABSCH    7-1986
C
C
C  CELL  - unit cell parameters in angstroem and degrees         (given)
C IGROUP - space group number as obtained from the international (given)
C          tables for x-ray crystallography vol.i
C   NEQ  - number of equivalent positions in laue group         (result)
C          derived from space-group number. a value of zero
C          indicates an illegal space-group number or illegal
C          unit cell parameters. otherwise neq assumes values
C          between 1 and 24.
C   ML   - integer array of length at least neq*9 specified     (result)
C          in the main program, to describe symmetry. all
C          friedel related positions are omitted. the largest
C          number of neq is 24, as mentioned. therefore, the
C          calling program should declare
C          integer ml(216)  to handle all possible cases!!!
C          the operators returned by this subroutine are
C          proper rotations. to obtain the complete laue-group
C          you only have to add the 'neq' friedel mates to
C          the matrices given by this routine. usually this is
C          not wanted.
C          each operator is represented by 9 consecutive
C          numbers as follows:
C          if x',y',z' is an equivalent position of x,y,z then
C          x'=x*ml(1)+y*ml(2)+z*ml(3)
C          y'=x*ml(4)+y*ml(5)+z*ml(6)
C          z'=x*ml(7)+y*ml(8)+z*ml(9)
C          the next operator occupies positions ml(10)...ml(18),
C          and so on...
C
C
C
C
      REAL      CELL(6),EPS
      INTEGER   ML(*),NEQ,IGROUP,IG,I,J,K,L,M
      INTEGER*2 MAT(288),MATN(56),NM(14),NA(14)
      PARAMETER (EPS=0.001)
      DATA MAT/ 1,3*0,1,3*0,1,  -1,3*0,-1,3*0,1,  1,3*0,-1,3*0,-1,
     1         -1,3*0,1,3*0,-1,  0,1,0,-1,4*0,1,  0,-1,0,1,4*0,1,
     2          0,-1,0,-1,4*0,-1,  0,1,0,1,4*0,-1,  0,0,1,1,3*0,1,0,
     3          0,0,1,-1,3*0,-1,0,  0,1,3*0,1,1,0,0,  0,1,3*0,-1,-1,0,0,
     4        0,0,-1,1,3*0,-1,0,  0,0,-1,-1,3*0,1,0,  0,-1,3*0,1,-1,0,0,
     5      0,-1,3*0,-1,1,0,0,  -1,4*0,-1,0,-1,0,  0,0,-1,0,-1,0,-1,0,0,
     6          -1,4*0,1,0,1,0,  0,0,-1,0,1,0,1,0,0,  1,4*0,-1,0,1,0,
     7      0,0,1,0,-1,0,1,0,0,  1,4*0,1,0,-1,0,  0,0,1,0,1,0,-1,0,0,
     8        0,-1,0,1,-1,3*0,1,  -1,1,0,-1,4*0,1,  -1,0,0,-1,1,3*0,-1,
     9         1,-1,0,0,-1,3*0,-1,  0,1,0,-1,1,3*0,1,  1,-1,0,1,4*0,1,
     $         1,0,0,1,-1,3*0,-1,  -1,1,0,0,1,3*0,-1/
      DATA MATN/1,4,3,2,9,10,11,12,13,14,15,16,
     1          5,6,7,8,17,18,19,20,21,22,23,24,
     2          1,2,5,6,3,4,7,8,
     3          1,25,26,8,27,28,  1,9,11,7,17,18,
     4          1,25,26,2,29,30,  7,31,32,8,27,28/
      DATA NM/  1,2,4,12,24, 2,4,8, 3,6, 3,6, 6,12/
      DATA NA/  0,0,0,0,0,  24,24,24, 32,32,  38,38, 44,44/
C
C
C
C----  check unit cell parameters
C
      IG=0
      NEQ=0
      DO 10 J=1,6
      IF (CELL(J).LE.0.0)GO TO 30
10    CONTINUE
C
C----  find laue group from space-group number and unit cell parameters
C
C       ..... triclinic axes
C
      IF ((IGROUP.GT.0).AND.(IGROUP.LT.3))IG=1
C
C       ..... monoclinic axes
C
      IF ((IGROUP.GT.2).AND.(IGROUP.LT.16).AND.
     @    (ABS(CELL(4)-90.0).LT.EPS))THEN
	 IF (ABS(CELL(5)-90.0).LT.EPS)IG=6
	 IF (ABS(CELL(6)-90.0).LT.EPS)IG=2
      ENDIF
C
C       ..... orthorhombic axes
C
      IF ((ABS(CELL(4)-90.0).LT.EPS).AND.(ABS(CELL(5)-90.0).LT.EPS)
     @    .AND.(ABS(CELL(6)-90.0).LT.EPS))THEN
	 IF ((IGROUP.GT.15).AND.(IGROUP.LT.75))IG=3
C
C        ..... tetragonal axes
C
	 IF (ABS(CELL(1)-CELL(2)).LT.EPS)THEN
	    IF ((IGROUP.GT.74).AND.(IGROUP.LT.89))IG=7
	    IF ((IGROUP.GT.88).AND.(IGROUP.LT.143))IG=8
C
C         ..... cubic axes
C
	    IF (ABS(CELL(1)-CELL(3)).LT.EPS)THEN
	       IF ((IGROUP.GT.194).AND.(IGROUP.LT.207))IG=4
	       IF ((IGROUP.GT.206).AND.(IGROUP.LT.231))IG=5
	    ENDIF
	 ENDIF
      ENDIF
C
C         ..... hexagonal axes
C
      IF ((ABS(CELL(1)-CELL(2)).LT.EPS).AND.(ABS(CELL(4)-90.0).LT.EPS)
     @ .AND.(ABS(CELL(5)-90.0).LT.EPS).AND.(ABS(CELL(6)-120.0).LT.EPS))
     & THEN
	 IF ((IGROUP.GT.142).AND.(IGROUP.LT.149))IG=9
	 IF ((IGROUP.GT.148).AND.(IGROUP.LT.168))IG=10
	 IF ((IGROUP.GT.167).AND.(IGROUP.LT.177))IG=13
	 IF ((IGROUP.GT.176).AND.(IGROUP.LT.195))IG=14
      ENDIF
C
C           ..... rhombohedral axes
C
      IF ((ABS(CELL(1)-CELL(2)).LT.EPS).AND.
     1    (ABS(CELL(1)-CELL(3)).LT.EPS).AND.
     2    (ABS(CELL(4)-CELL(5)).LT.EPS).AND.
     3    (ABS(CELL(4)-CELL(6)).LT.EPS))THEN
	 IF ((IGROUP.EQ.146).OR.(IGROUP.EQ.148))IG=11
	 IF ((IGROUP.EQ.155).OR.(IGROUP.EQ.160).OR.(IGROUP.EQ.161).OR.
     @       (IGROUP.EQ.166).OR.(IGROUP.EQ.167))IG=12
      ENDIF
C
C----  get matrices of equivalent positions for laue group
C
      IF (IG.LT.1)GO TO 30
      NEQ=NM(IG)
      K=NA(IG)
      I=0
      DO 20 J=1,NEQ
      L=9*(MATN(J+K)-1)
      DO 20 M=1,9
      I=I+1
20    ML(I)=MAT(M+L)
30    RETURN
      END
C
C
C
C     ======================
      SUBROUTINE MATCOP(A,B)
C     ======================
      IMPLICIT NONE
C
C
C
      REAL    A(3,3),B(3,3)
      INTEGER I,J
C
C
      DO 1 I=1,3
      DO 1 J=1,3
1     B(I,J)=A(I,J)
C
C
      RETURN
      END
C
C
C
C
C     =============================
      SUBROUTINE METRIC(B,CELL,IER)
C     =============================
      IMPLICIT NONE
C
C
C
C
C     Calculates cell parameters from unit cell basis vectors
C                     W.KABSCH 10-1991
C
C
C   B   - basis vectors of the unit cell (stored row-wise)       (given)
C  CELL - cell parameters (angstrom & degrees)                  (result)
C  IER  - error flag: 0:no error, -1:illegal basis vectors      (result)
C
C
C
      INTEGER    IER,I,J,K
      REAL       B(3,3),CELL(6),R
C
C
C
C
      IER=-1
      DO 10 I=1,3
10    CELL(I)=SQRT(B(I,1)*B(I,1)+B(I,2)*B(I,2)+B(I,3)*B(I,3))
      DO 20 I=2,3
      DO 20 J=1,I-1
      R=CELL(I)*CELL(J)
      IF (R.LE.0.0)GO TO 30
      R=(B(I,1)*B(J,1)+B(I,2)*B(J,2)+B(I,3)*B(J,3))/R
      IF (ABS(R).GE.1.0)GO TO 30
      K=3+6/(I*J)
20    CELL(K)=57.29578*ACOS(R)
      IER=0
30    RETURN
      END
C
C
C
C     ============================
      SUBROUTINE ORDR3(KNTRL,Q,NQ)
C     ============================
      IMPLICIT NONE
C
C
C
C       Find NQ(1) so that |Q(NQ(1)| is biggest Q.
C       If KNTRL=1, make NQ(1),NQ(2),NQ(3) a positive permutn.
C       If KNTRL= anything else,
C       find nos. NQ() so that|Q(NQ(1)|>|Q(NQ(2))|>|Q(NQ(3))|
C
C
C
C
C
C---- Find no. NQ(1) of Q() with largest |Q()|.
C
C     .. Scalar Arguments ..
      INTEGER KNTRL
C     ..
C     .. Array Arguments ..
      REAL Q(3)
      INTEGER NQ(3)
C     ..
C     .. Local Scalars ..
      INTEGER J
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS,MOD
C     ..
      SAVE
C
C
      NQ(1) = 1
      IF (ABS(Q(2)).GT.ABS(Q(1))) NQ(1) = 2
      IF (ABS(Q(3)).GT.ABS(Q(NQ(1)))) NQ(1) = 3
C
C---- Find nos. for other two Q()'s & order so |Q(NQ(2))|>|Q(NQ(3))|
C
      NQ(2) = MOD(NQ(1),3) + 1
      NQ(3) = MOD(NQ(2),3) + 1
      IF (KNTRL.NE.1) THEN
C
C
        IF (ABS(Q(NQ(3))).GT.ABS(Q(NQ(2)))) THEN
          J = NQ(3)
          NQ(3) = NQ(2)
          NQ(2) = J
        END IF
      END IF
      RETURN
C
C
      END
C
C
C
C
C     ================================================================
      SUBROUTINE PREREF(Q,ORGX,ORGY,F,ED,FLAMDA,ACHSE,NRFL,IX,IY,IPHI,
     @                  IH,IK,IL,V,S,SD,S0,A,NACC)
C     ================================================================
      IMPLICIT NONE
C
C
C
C
C
C    Robust pre-refinement procedure for reciprocal cell setting      
C    Matrix, direct beam, and index off-set. bad reflections are      
C    Recognized and marked by indices 0,0,0.                          
C                W.KABSCH    11-1992                                   
C
C
C
C
C   Q    - length of a pixel in millimeters                      (given)
C ORGX   - x- and y-coordinates (pixels) of origin on detector   (given)
C ORGY   - plane.                                                (given)
C   F    - crystal to detector distance (mm).                    (given)
C   ED   - real array(3,3) specifying lab coordinates of         (given)
C          detector axes.
C FLAMDA - wavelength (angstroem)                                (given)
C ACHSE  - array(3) specifying lab coordinates of rotation axis  (given)
C  NRFL  - number of reflections                                 (given)
C   IX   - integer*2 array specifying x-position on detector     (given)
C          for each spot in the list ( tenth of a pixel)
C   IY   - integer*2 array specifying y-position on detector     (given)
C          for each spot in the list ( tenth of a pixel)
C  IPHI  - integer*2 array specifying angular position of        (given)
C          spindle. the values are given in units of a
C          hundreth of a degree. iphi(jrfl) refers to the
C          spot located at ix(jrfl),iy(jrfl).
C   IH   - integer*2 array specifying h-indices for the spots  (updated)
C          located at ix,iy,iphi
C   IK   - integer*2 array specifying k-indices for the spots  (updated)
C          located at ix,iy,iphi.
C   IL   - integer*2 array specifying l-indices for the spots  (updated)
C          located at ix,iy,iphi.
C   V    - real*4 array(3,nrfl) used for scratch              (modified)
C  S,SD  - real*4 arrays(3) of mean and standard deviations     (result)
C          of computed real numbered indices minus given
C          reflection indices as obtained by "grididx".
C   S0   - lab coordinates of incident x-ray beam wave vector. (updated)
C          length of s0 is 1.0/lambda. ( reciprocal angstroem )
C   A    - real*4 array(3,3) of reciprocal lattice vectors      (result)
C          stored columnwise
C  NACC  - number of indexed spots. an error is indicated if    (result)
C          nacc<=0.
C           >0 : no error.
C            0 : insufficient number of accepted reflections
C           -1 : (q<=0)or(f=0)or(flamda<=0)or(length of "achse"=0)
C           -2 : singular recipr. cell setting matrix or normal matrix
C                or lagrange multiplier <=0
C           -3 : rank of normal matrix less than 9
C
C
C
C
      INTEGER*2  IH(*),IK(*),IL(*),IX(*),IY(*),IPHI(*)
      INTEGER    IOFF(3),IOFFB(3),NACC,I,J,K,L,ICYCLE,IA,IA1,IA2,IER,NV,
     @           NRFL,HOFF,KOFF,LOFF
      REAL*4     V(3,*),H(3),S(3),SD(3),D(3,3),HH(3,3),SDH(3,3),
     1           DH(3,3,3),ED(3,3),AA(3,3),A(3,3),B(3,3),ROT(3,3),
     2           ACHSE(3),S0(3),S1(3),HKL(3),S00(3),S0B(3),RH(9),
     3           QM(45),SCALE(9),AUX(8)
      REAL*4     Q,F,ORGX,ORGY,FLAMDA,CPHI,SPHI,R,RX,RY,X,Y,Z,EBEST,
     1           E,LMULT,EPS,RAD100
      PARAMETER  (RAD100=100.0*57.29578,EPS=0.5E-6)
C
C
C
C
      IF ((Q.LE.0.0).OR.(F.EQ.0.0).OR.(FLAMDA.LE.0.0))GO TO 410
      IF (NRFL.LT.25)GO TO 400
C
C----  calculate transformation from pixel to MM
C
      CALL RFPXTOMM(Q,F,ED,AA)
C
C
C
      DO 230 ICYCLE=1,3
      DO 10 I=1,3
      H(I) =0.0
      S(I) =0.0
      SD(I)=0.0
      DO 10 J=1,3
      D(I,J)  =0.0
      HH(I,J) =0.0
      SDH(I,J)=0.0
      DO 10 K=1,3
10    DH(I,J,K)=0.0
C
C----  step through all reflections
C
      NACC=0
      DO 40 NV=1,NRFL
      IF ((ABS(IH(NV))+ABS(IK(NV))+ABS(IL(NV))).EQ.0)GO TO 40
      R=IPHI(NV)/RAD100
      CPHI=COS(R)
      SPHI=SIN(R)
      CALL RFROTMAT(ACHSE,CPHI,SPHI,ROT,IER)
      IF (IER.NE.0)GO TO 410
      RX=IX(NV)/10.0-ORGX
      RY=IY(NV)/10.0-ORGY
      X=AA(1,1)*RX+AA(1,2)*RY+AA(1,3)
      Y=AA(2,1)*RX+AA(2,2)*RY+AA(2,3)
      Z=AA(3,1)*RX+AA(3,2)*RY+AA(3,3)
      R=SQRT(X*X+Y*Y+Z*Z)*FLAMDA
      IF (R.GT.0.0)GO TO 20
      IH(NV)=0
      IK(NV)=0
      IL(NV)=0
      GO TO 40
20    NACC=NACC+1
      S1(1)=X/R
      S1(2)=Y/R
      S1(3)=Z/R
      HKL(1)=IH(NV)
      HKL(2)=IK(NV)
      HKL(3)=IL(NV)
      DO 30 I=1,3
      S(I)=S(I)+S1(I)
      H(I)=H(I)+HKL(I)
      R=S1(1)*ROT(1,I)+S1(2)*ROT(2,I)+S1(3)*ROT(3,I)
      SD(I)=SD(I)+R
      DO 30 J=1,3
      D(I,J)=D(I,J)+ROT(I,J)
      SDH(I,J)=SDH(I,J)+R*HKL(J)
      HH(I,J)=HH(I,J)+HKL(I)*HKL(J)
      DO 30 K=1,3
30    DH(I,J,K)=DH(I,J,K)+ROT(I,J)*HKL(K)
40    CONTINUE
      IF (NACC.LT.25)GO TO 400
C
C----  set up normal equations for the reciprocal cell setting matrix
C
      IA=0
      IA1=0
      DO 70 I=1,3
      DO 70 J=1,3
      IA1=IA1+1
      RH(IA1)=NACC*SDH(I,J)-
     @(S(1)*DH(1,I,J)+S(2)*DH(2,I,J)+S(3)*DH(3,I,J))
      IA2=0
      DO 50 K=1,3
      IF (I.EQ.K)THEN
	 R=NACC
      ELSE
	 R=0.0
      ENDIF
      DO 50 L=1,3
      IA2=IA2+1
      IF (IA2.GT.IA1)GO TO 60
      IA=IA+1
      QM(IA)=HH(J,L)*R-
     @(DH(1,I,J)*DH(1,K,L)+DH(2,I,J)*DH(2,K,L)+DH(3,I,J)*DH(3,K,L))
50    CONTINUE
60    CONTINUE
70    CONTINUE
C
C----  rescale system of equations
C
      IA=0
      DO 80 IA1=1,9
      IA=IA+IA1
      R=QM(IA)
      IF (R.LE.0.0)GO TO 420
80    SCALE(IA1)=1.0/SQRT(R)
      IA=0
      DO 90 IA1=1,9
      RH(IA1)=RH(IA1)*SCALE(IA1)
      DO 90 IA2=1,IA1
      IA=IA+1
90    QM(IA)=QM(IA)*SCALE(IA1)*SCALE(IA2)
C
C----  solve normal equations to get reciprocal cell setting matrix
C
      CALL GELS(RH,QM,9,1,EPS,IER,AUX)
      IF (IER.EQ.-1)GO TO 420
      IF (IER.NE. 0)GO TO 430
      IA=0
      DO 100 I=1,3
      DO 100 J=1,3
      IA=IA+1
100   A(I,J)=RH(IA)*SCALE(IA)
C
C----  determine s0 and the index off-set
C
      DO 110 I=1,3
      DO 110 J=1,3
110   B(I,J)=A(1,I)*A(1,J)+A(2,I)*A(2,J)+A(3,I)*A(3,J)
      EBEST=1.0E+30
      DO 160 HOFF=-2,2
      IOFF(1)=HOFF
      DO 160 KOFF=-2,2
      IOFF(2)=KOFF
      DO 160 LOFF=-2,2
      IOFF(3)=LOFF
      DO 120 I=1,3
      S00(I)=S(I)
      DO 120 J=1,3
      DO 120 K=1,3
120   S00(I)=S00(I)-A(J,K)*(DH(I,J,K)-D(I,J)*IOFF(K))
      LMULT=FLAMDA*SQRT(S00(1)**2+S00(2)**2+S00(3)**2)
      IF (LMULT.LE.0.0)GO TO 420
      R=0.0
      DO 130 I=1,3
      S00(I)=S00(I)/LMULT
130   R=R+(S0(I)-S00(I))**2
      E=(NACC-LMULT)/FLAMDA**2
      DO 140 I=1,3
      DO 140 J=1,3
140   E=E-A(I,J)*(SDH(I,J)-SD(I)*IOFF(J))+0.5*B(I,J)*
     @   (HH(I,J)-H(I)*IOFF(J)-H(J)*IOFF(I)+NACC*IOFF(I)*IOFF(J))
      E=2*E/NACC+R
      IF (E.LT.EBEST)THEN
	 EBEST=E
	 DO 150 I=1,3
	 IOFFB(I)=IOFF(I)
150      S0B(I)=S00(I)
      ENDIF
160   CONTINUE
C
C----  get unit cell setting matrix
C
      CALL INVERS(A,B,R)
      IF (R.LE.0.0)GO TO 420
C
C----  determine error probability distribution of individual spots
C
      DO 170 I=1,3
      S(I)=0.0
170   SD(I)=0.0
      NACC=0
      DO 190 NV=1,NRFL
      IF ((ABS(IH(NV))+ABS(IK(NV))+ABS(IL(NV))).EQ.0)GO TO 190
      R=IPHI(NV)/RAD100
      CPHI=COS(R)
      SPHI=SIN(R)
      RX=IX(NV)/10.0-ORGX
      RY=IY(NV)/10.0-ORGY
      X=AA(1,1)*RX+AA(1,2)*RY+AA(1,3)
      Y=AA(2,1)*RX+AA(2,2)*RY+AA(2,3)
      Z=AA(3,1)*RX+AA(3,2)*RY+AA(3,3)
      R=SQRT(X*X+Y*Y+Z*Z)*FLAMDA
      IF (R.LE.0.0)GO TO 190
      NACC=NACC+1
      X=X/R-S0B(1)
      Y=Y/R-S0B(2)
      Z=Z/R-S0B(3)
      R=(X*ACHSE(1)+Y*ACHSE(2)+Z*ACHSE(3))*(1.0-CPHI)
      S1(1)=X*CPHI+R*ACHSE(1)-SPHI*(ACHSE(2)*Z-ACHSE(3)*Y)
      S1(2)=Y*CPHI+R*ACHSE(2)-SPHI*(ACHSE(3)*X-ACHSE(1)*Z)
      S1(3)=Z*CPHI+R*ACHSE(3)-SPHI*(ACHSE(1)*Y-ACHSE(2)*X)
      IH(NV)=IH(NV)-IOFFB(1)
      IK(NV)=IK(NV)-IOFFB(2)
      IL(NV)=IL(NV)-IOFFB(3)
      V(1,NV)=B(1,1)*S1(1)+B(1,2)*S1(2)+B(1,3)*S1(3)-IH(NV)
      V(2,NV)=B(2,1)*S1(1)+B(2,2)*S1(2)+B(2,3)*S1(3)-IK(NV)
      V(3,NV)=B(3,1)*S1(1)+B(3,2)*S1(2)+B(3,3)*S1(3)-IL(NV)
      DO 180 I=1,3
      S(I)=S(I)+V(I,NV)
180   SD(I)=SD(I)+V(I,NV)**2
190   CONTINUE
      IF (NACC.LT.1)GO TO 400
      DO 200 I=1,3
      S(I)=S(I)/NACC
      SD(I)=SD(I)/NACC-S(I)**2
      IF (SD(I).GT.0.0)THEN
	  SD(I)=SQRT(SD(I))
      ELSE
	  SD(I)=0.0001
      ENDIF
200   CONTINUE
C
C----  mark bad spots
C
      NACC=0
      DO 220 NV=1,NRFL
      IF ((ABS(IH(NV))+ABS(IK(NV))+ABS(IL(NV))).EQ.0)GO TO 220
      DO 210 I=1,3
      R=(V(I,NV)-S(I))/SD(I)
      IF (ABS(R).GT.2.5)THEN
	 IH(NV)=0
	 IK(NV)=0
	 IL(NV)=0
	 GO TO 220
      ENDIF
210   CONTINUE
      NACC=NACC+1
220   CONTINUE
230   CONTINUE
      DO 240 I=1,3
240   S0(I)=S0B(I)
      RETURN
C
C----  error returns
C
400   NACC=0
      RETURN
410   NACC=-1
      RETURN
420   NACC=-2
      RETURN
430   NACC=-3
      RETURN
      END
C
C
C
C     =============================
      SUBROUTINE QSORT2(N,V,WEIGHT)
C     =============================
      IMPLICIT NONE
C
C
C
C
C
C---- non-recursive version of quicksort algorithm (c.a.r. hoare)
C
C   N    - number of items to be sorted                          (given)
C   V    - real array(3,*) containing cluster coordinates      (updated)
C          indices. arrays v,weight are sorted to decreasing
C          cluster occupancies.
C WEIGHT - real*4    array of cluster occupancies              (updated)
C
C
      INTEGER   ISTACK(32,2),N,J,JL,JR,IL,IR,K,JJ
      REAL      V(3,*),WEIGHT(*),WK,WL,WR,W
C
C
C
      IF (N.LT.2)RETURN
      J=1
      ISTACK(1,1)=1
      ISTACK(1,2)=N
C
C---- take top request from stack
C
10    JL=ISTACK(J,1)
      JR=ISTACK(J,2)
      J=J-1
C
C---- split jl...jr
C
20    IL=JL
      IR=JR
      K=(JL+JR)/2
      WK=-WEIGHT(K)
30    WL=-WEIGHT(IL)
      IF (WL.GE.WK)GO TO 40
      IL=IL+1
      IF (IL.LE.JR)GO TO 30
      IL=JR
40    WR=-WEIGHT(IR)
      IF (WK.GE.WR)GO TO 50
      IR=IR-1
      IF (IR.GE.JL)GO TO 40
      IR=JL
50    IF (IL.GT.IR)GO TO 60
      W=WEIGHT(IL)
      WEIGHT(IL)=WEIGHT(IR)
      WEIGHT(IR)=W
      DO 55 JJ=1,3
      W=V(JJ,IL)
      V(JJ,IL)=V(JJ,IR)
55    V(JJ,IR)=W
      IL=IL+1
      IR=IR-1
      IF (IL.LE.IR)GO TO 30
60    IF ((IR-JL).GE.(JR-IL))GO TO 80
C
C---- stack request for sorting right partition
C
      IF (IL.GE.JR)GO TO 70
      J=J+1
      IF (J.GT.32) CALL CCPERR(1, ' Stack overflow in "qsort2" ')
      ISTACK(J,1)=IL
      ISTACK(J,2)=JR
C
C---- continue sorting left partition
C
70    JR=IR
      GO TO 100
C
C---- stack request for sorting left partition
C
80    IF (JL.GE.IR)GO TO 90
      J=J+1
      IF (J.GT.32) CALL CCPERR(1, ' Stack overflow in "qsort2" ')
      ISTACK(J,1)=JL
      ISTACK(J,2)=IR
C
C---- continue sorting right partition
C
90    JL=IL
100   IF (JL.LT.JR)GO TO 20
      IF (J.GT.0)GO TO 10
      RETURN
      END
C
C
C
C     ===============================
      SUBROUTINE QSORT5(N,IHKL,QNORM)
C     ===============================
      IMPLICIT NONE
C
C
C
C
C
C---- non-recursive version of quicksort algorithm (c.a.r. hoare)
C
C   N    - number of items to be sorted                          (given)
C IHKL   - integer*2 array(3,*) containing indices.            (updated)
C          arrays ihkl,qnorm are sorted to increasing
C          vector lengths.
C QNORM  - real*4  array of squared vector lengths             (updated)
C
C
      INTEGER   ISTACK(32,2),N,J,JL,JR,IL,IR,K,JJ
      INTEGER*2 IHKL(3,*),IW
      REAL      QNORM(*),WK,WL,WR,W
C
C
C
      IF (N.LT.2)RETURN
      J=1
      ISTACK(1,1)=1
      ISTACK(1,2)=N
C
C---- take top request from stack
C
10    JL=ISTACK(J,1)
      JR=ISTACK(J,2)
      J=J-1
C
C---- split jl...jr
C
20    IL=JL
      IR=JR
      K=(JL+JR)/2
      WK=QNORM(K)
30    WL=QNORM(IL)
      IF (WL.GE.WK)GO TO 40
      IL=IL+1
      IF (IL.LE.JR)GO TO 30
      IL=JR
40    WR=QNORM(IR)
      IF (WK.GE.WR)GO TO 50
      IR=IR-1
      IF (IR.GE.JL)GO TO 40
      IR=JL
50    IF (IL.GT.IR)GO TO 60
      W=QNORM(IL)
      QNORM(IL)=QNORM(IR)
      QNORM(IR)=W
      DO 55 JJ=1,3
      IW=IHKL(JJ,IL)
      IHKL(JJ,IL)=IHKL(JJ,IR)
55    IHKL(JJ,IR)=IW
      IL=IL+1
      IR=IR-1
      IF (IL.LE.IR)GO TO 30
60    IF ((IR-JL).GE.(JR-IL))GO TO 80
C
C---- stack request for sorting right partition
C
      IF (IL.GE.JR)GO TO 70
      J=J+1
      IF (J.GT.32) CALL CCPERR(1, ' Stack overflow in "qsort2" ')
      ISTACK(J,1)=IL
      ISTACK(J,2)=JR
C
C---- continue sorting left partition
C
70    JR=IR
      GO TO 100
C
C---- stack request for sorting left partition
C
80    IF (JL.GE.IR)GO TO 90
      J=J+1
      IF (J.GT.32) CALL CCPERR(1, ' Stack overflow in "qsort2" ')
      ISTACK(J,1)=JL
      ISTACK(J,2)=IR
C
C---- continue sorting right partition
C
90    JL=IL
100   IF (JL.LT.JR)GO TO 20
      IF (J.GT.0)GO TO 10
      RETURN
      END
C
C
C
C     ==================================================================
      SUBROUTINE REDUCE(VOLMIN,ERRINT,MAXIDX,NSPOT,VC,WEIGHT,RBAS,IRANK)
C     ==================================================================
      IMPLICIT NONE
C
C
C
C
C
C     REDUCE A SET OF GIVEN DIFFERENCE VECTOR CLUSTERS TO THREE
C     LINEAR INDEPENDENT BASIS VECTORS.        W.KABSCH 10-1991
C                                              revised   9-1992
C
C*************** DESCRIPTION OF CALLING PARAMETERS *********************
C
C VOLMIN - MINIMUM ALLOWED RECIPROCAL CELL VOLUME OF GRID        (GIVEN)
C ERRINT - TOLERANCE VALUE FOR GRID INDICES DEVIATING            (GIVEN)
C          FROM INTEGRAL VALUES.
C MAXIDX - THE ABSOLUTE VALUE OF AN INDEX ASSIGNED TO ANY        (GIVEN)
C          DIFFERENCE VECTOR CLUSTER IS NOT ALLOWED TO EXCEED
C          "MAXIDX" DURING THE SEARCH FOR THE BEST SET OF BASIS
C          VECTORS EXPLAINING THE GIVEN LIST OF CLUSTER VECTORS.
C NSPOT  - NUMBER OF DIFFERENCE VECTOR CLUSTERS                  (GIVEN)
C   VC   - REAL ARRAY(3,MXSPOT) CONTAINING RECIPROCAL SPACE      (GIVEN)
C          COORDINATES OF DIFFERENCE VECTOR CLUSTERS. THE
C          ARRAY IS SORTED IN DECREASING NUMBER OF DIFFERENCE
C          VECTORS BELONGING TO A CLUSTER.
C WEIGHT - REAL ARRAY(MXSPOT). IT CONTAINS THE NUMBER OF         (GIVEN)
C          DIFFERENCE VECTORS BELONGING TO EACH CLUSTER.
C  RBAS  - BEST SET OF BASIS VECTORS EXPLAINING THE GIVEN       (RESULT)
C          LIST OF DIFFERENCE VECTOR CLUSTERS. THE VECTORS
C          ARE STORED COLUMNWISE.
C IRANK  - NUMBER OF LINEAR INDEPENDENT BASIS VECTORS, WHICH    (RESULT)
C          MUST BE 3. IRANK<3 INDICATES AN ERROR CONDITION.
C
C***********************************************************************
C
C          SUBROUTINES REQUIRED: INVERS,RFMATMUL,REDZEL,WIDX
C
C***********************************************************************
      INTEGER    NSPOT,I,J,K,L,M,N,IRANK,MAXIDX,MHKL(3)
      REAL       VC(3,*),WEIGHT(*),BAS(3,3),RBAS(3,3),A(3,3),B(3,3),
     1           C(3,3),FHKL(3),H0(3),V0(3),VOLMIN,S,W,Z,ERRINT
C***********************************************************************
      IF ((NSPOT.LT.3).OR.(VOLMIN.LE.0.0).OR.(ERRINT.LE.0.0))GO TO 200
      S=0.0
      DO 70 I=  1,NSPOT-2
      C(1,1)=VC(1,I)
      C(2,1)=VC(2,I)
      C(3,1)=VC(3,I)
      DO 60 J=I+1,NSPOT-1
      C(1,2)=VC(1,J)
      C(2,2)=VC(2,J)
      C(3,2)=VC(3,J)
      DO 50 K=J+1,NSPOT
      C(1,3)=VC(1,K)
      C(2,3)=VC(2,K)
      C(3,3)=VC(3,K)
      CALL INVERS(C,BAS,Z)
      IF (ABS(Z).LT.VOLMIN)GO TO 50
      Z=0.0
      DO 20 L=1,NSPOT
      DO 10 M=1,3
10    FHKL(M)=BAS(M,1)*VC(1,L)+BAS(M,2)*VC(2,L)+BAS(M,3)*VC(3,L)
      CALL WIDX(MAXIDX,ERRINT,FHKL,MHKL,W)
      IF (W.EQ.0.0)GO TO 20
      IF ((MHKL(1).EQ.0).AND.(MHKL(2).EQ.0).AND.(MHKL(3).EQ.0))GO TO 20
      Z=Z+W*WEIGHT(L)
20    CONTINUE
      IF (Z.LE.S)GO TO 40
      IRANK=3
      S=Z
      DO 30 M=1,3
      DO 30 N=1,3
30    RBAS(M,N)=C(M,N)
40    CONTINUE
50    CONTINUE
60    CONTINUE
70    CONTINUE
C
C----  refine reciprocal basis
C
      IF (IRANK.NE.3)GO TO 200
      CALL INVERS(RBAS,BAS,Z)
      DO 80 I=1,3
      H0(I)=0.0
      V0(I)=0.0
      DO 80 J=1,3
      A(I,J)=0.0
80    B(I,J)=0.0
      S=0.0
      DO 110 L=1,NSPOT
      DO 90 M=1,3
90    FHKL(M)=BAS(M,1)*VC(1,L)+BAS(M,2)*VC(2,L)+BAS(M,3)*VC(3,L)
      CALL WIDX(MAXIDX,ERRINT,FHKL,MHKL,W)
      IF ((MHKL(1).EQ.0).AND.(MHKL(2).EQ.0).AND.(MHKL(3).EQ.0))GO TO 110
      S=S+W
      DO 100 I=1,3
      H0(I)=H0(I)+W*MHKL(I)
      V0(I)=V0(I)+W*VC(I,L)
      DO 100 J=1,3
      A(I,J)=A(I,J)+W*MHKL(I)*MHKL(J)
100   B(I,J)=B(I,J)+W*VC(I,L)*MHKL(J)
110   CONTINUE
      DO 120 I=1,3
      DO 120 J=1,3
      A(I,J)=A(I,J)-H0(I)*H0(J)/S
120   B(I,J)=B(I,J)-V0(I)*H0(J)/S
      CALL INVERS(A,C,Z)
      CALL RFMATMUL(B,C,RBAS)
      IF (NINT(Z).EQ.0)GO TO 200
C
C----  find a reduced cell
C
      CALL REDZEL(0,RBAS,BAS,I)
      IF (I.NE.0)GO TO 200
C
C----  get reciprocal basis vectors of reduced cell
C
      CALL INVERS(BAS,RBAS,Z)
      IF (Z.EQ.0.0)GO TO 200
C
C----  index all difference vector clusters
C
      DO 190 L=1,NSPOT
      K=0
      DO 140 M=1,3
      Z=BAS(M,1)*VC(1,L)+BAS(M,2)*VC(2,L)+BAS(M,3)*VC(3,L)
      Z=Z-NINT(Z)
      FHKL(M)=Z
      MHKL(M)=0
      S=ABS(Z)
      DO 130 J=2,2
      Z=FHKL(M)*J
      Z=Z-NINT(Z)
      IF (ABS(Z).GT.S)GO TO 130
      S=ABS(Z)
      IF (FHKL(M).LT.0.0)THEN
	  MHKL(M)=-J
      ELSE
	  MHKL(M)= J
      ENDIF
130   CONTINUE
C
C----  cluster cannot be indexed at all
C
      IF (S.GT.ERRINT)GO TO 190
      K=K+ABS(MHKL(M))
140   CONTINUE
C
C----  cluster can be indexed with respect to current basis
C
      IF (K.LT.1)GO TO 190
C
C----  cluster can be indexed with half integral indices
C
      DO 150 J=1,3
150   V0(J)=0.0
      DO 170 I=1,3
      IF (MHKL(I).EQ.0)GO TO 170
      K=I
      DO 160 J=1,3
160   V0(J)=V0(J)+RBAS(J,I)/MHKL(I)
170   CONTINUE
C
C----  replace vector #k by v0
C
      DO 180 I=1,3
180   RBAS(I,K)=V0(I)
C
C----  find new reduced cell
C
      CALL REDZEL(0,RBAS,BAS,I)
      IF (I.NE.0)GO TO 200
C
C----  get new reciprocal basis vectors of reduced cell
C
      CALL INVERS(BAS,RBAS,Z)
      IF (Z.EQ.0.0)GO TO 200
190   CONTINUE
      RETURN
200   IRANK=0
      RETURN
      END
C
C
C
C
C     ==================================
      SUBROUTINE REDZEL(ABSTYP,A,RB,IER)
C     ==================================
      IMPLICIT NONE
C
C
C
C
C
C   Determine a reduced cell  ("burger-cell") defined by the shortest
C   three linear independent  lattice vectors  forming a right-handed
C   set. the three vectors are sorted in increasing length and stored
C   row-wise !  note that the reduced cell as defined here may not be
C   unique !       w.kabsch         original version 10-1991
C
C
C
C ABSTYP - an integer value describing conditions limiting       (given)
C          possible reflections in a given reciprocal lattice
C            0: no conditions on H,K,L
C            1: H+K must be even
C            2: H+L must be even
C            3: K+L must be even
C            4: H+K+L must be even
C            5: -H+K+L must be a multiple of 3
C            6: H+K AND H+L must be even
C    A   - basis of reciprocal cell vectors (stored column-wise) (given)
C          describing the given reciprocal lattice.
C   RB   - basis vectors of the reduced cell.                   (result)
C          the vectors are stored row-wise !
C   IER  - the reduction was successful if ier=0.               (result)
C          a singular input matrix "a" is present if ier=-1
C
C
C
C
      INTEGER    ABSTYP,MAXIDX,NMAX,II,IH,IK,IL,IXJH,IXJK,IXJL,
     1           I,J,K,N,LOOP,IER,ID,IDET(7)
      PARAMETER  (MAXIDX=5,NMAX=MAXIDX*(MAXIDX*(4*MAXIDX+6)+3) )
      INTEGER*2  IHKL(3,NMAX)
      REAL       A(3,3),B(3,3),C(3,3),RB(3,3),QNORM(NMAX),RMS,Q
      DATA       IDET/1,2,2,2,2,3,4/
C
C
C
C
      IER=-1
      DO 160 LOOP=1,2
      IF (LOOP.EQ.1)THEN
	  ID=IDET(ABSTYP+1)
      ELSE
	  ID=1
      ENDIF
C
C----  generate list of possible indices
C
      N=0
      DO 90 IH=0,MAXIDX
      DO 80 IK=-MAXIDX,MAXIDX
      IF ((IH.EQ.0).AND.(IK.LT.0))GO TO 80
      DO 70 IL=-MAXIDX,MAXIDX
      IF ((IH.EQ.0).AND.(IK.EQ.0).AND.(IL.LE.0))GO TO 70
      RMS=0.0
      IF (LOOP.NE.1)GO TO 20
      CALL GENABS(ABSTYP,IH,IK,IL,I)
      IF (I.NE.0)GO TO 70
      DO 10 I=1,3
10    RMS=RMS+(A(I,1)*IH+A(I,2)*IK+A(I,3)*IL)**2
      GO TO 40
20    DO 30 I=1,3
30    RMS=RMS+(B(1,I)*IH+B(2,I)*IK+B(3,I)*IL)**2
40    IF (N.GE.NMAX)GO TO 50
      N=N+1
      GO TO 60
50    IF (RMS.GE.QNORM(N))GO TO 70
60    QNORM(N)=RMS
      IHKL(1,N)=IH
      IHKL(2,N)=IK
      IHKL(3,N)=IL
C
C----  sort in increasing vector length
C
      IF (N.EQ.NMAX)CALL QSORT5(N,IHKL,QNORM)
70    CONTINUE
80    CONTINUE
90    CONTINUE
C
C----  sort in increasing vector length
C
      IF (N.LT.NMAX)CALL QSORT5(N,IHKL,QNORM)
C
C----  generate list of independent reflection triplets
C
      DO 150 I=1,N-2
      DO 140 J=I+1,N-1
      IXJH=IHKL(2,I)*IHKL(3,J)-IHKL(3,I)*IHKL(2,J)
      IXJK=IHKL(3,I)*IHKL(1,J)-IHKL(1,I)*IHKL(3,J)
      IXJL=IHKL(1,I)*IHKL(2,J)-IHKL(2,I)*IHKL(1,J)
      IF ((IXJH.EQ.0).AND.(IXJK.EQ.0).AND.(IXJL.EQ.0))GO TO 140
      DO 130 K=J+1,N
C
C----  check determinant
C
      IF (ABS(IXJH*IHKL(1,K)+IXJK*IHKL(2,K)+IXJL*IHKL(3,K)).NE.ID)
     @GO TO 130
C
C----  triplett is ok.
C
      IF (LOOP.NE.1)GO TO 110
      DO 100 II=1,3
      C(II,1)=A(II,1)*IHKL(1,I)+A(II,2)*IHKL(2,I)+A(II,3)*IHKL(3,I)
      C(II,2)=A(II,1)*IHKL(1,J)+A(II,2)*IHKL(2,J)+A(II,3)*IHKL(3,J)
100   C(II,3)=A(II,1)*IHKL(1,K)+A(II,2)*IHKL(2,K)+A(II,3)*IHKL(3,K)
      GO TO 160
110   DO 120 II=1,3
      C(1,II)=B(1,II)*IHKL(1,I)+B(2,II)*IHKL(2,I)+B(3,II)*IHKL(3,I)
      C(2,II)=B(1,II)*IHKL(1,J)+B(2,II)*IHKL(2,J)+B(3,II)*IHKL(3,J)
120   C(3,II)=B(1,II)*IHKL(1,K)+B(2,II)*IHKL(2,K)+B(3,II)*IHKL(3,K)
      GO TO 160
130   CONTINUE
140   CONTINUE
150   CONTINUE
C
C----  assert that this statement is never reached
C
      CALL CCPERR(1, ' !!! ERROR !!! PROGRAMMING ERROR IN "REDZEL"')
C
C----  invert basis
C
160   CALL INVERS(C,B,Q)
      IF (Q.EQ.0.0)RETURN
      Q=SIGN(1.0,Q)
      DO 170 I=1,3
      DO 170 J=1,3
170   RB(I,J)=Q*C(I,J)
      IER=0
      RETURN
      END
C
C
C
C     =================
      BLOCK DATA REFBLK
C     =================
C
C
C
C
C     .. Scalars in Common ..
      REAL CCOM,CCX,CCY,DPHI,DXY,F,FLAMDA,ORGX,ORGY,Q,THRESH
      INTEGER FIXF,IGROUP
      LOGICAL DCOMP,FILM,LCAMC,TARGET
C     ..
C     .. Arrays in Common ..
      REAL ACHSE,CELL,ED,S0,TARMAT
C     ..
C     .. Common blocks ..
      COMMON /REFCOM/IGROUP,FLAMDA,CELL(6),F,THRESH,Q,DPHI,ED(3,3),
     +       ACHSE(3),S0(3),ORGX,ORGY,FIXF,TARMAT(3,3),TARGET,DCOMP,
     +       LCAMC,CCX,CCY,CCOM,FILM,DXY,FIXCELL
      LOGICAL FIXCELL
      COMMON /DISTOR/ ROFF,TOFF
      REAL ROFF,TOFF
      COMMON /OUTPUT/ IBRIEF,BRIEF,XDSOUT
      LOGICAL BRIEF,XDSOUT
      INTEGER IBRIEF
CC     ..
      SAVE
C     .. Data statements ..
C
C---- Data values are appropriate for MOSFLM axis convention,
C     with X along X-ray beam, and Z along rotation axis.
C
C
C---- For prototype hamburg image plates on synchrotron
C     RASTER (Q) = 0.187, beam centres are orgx,orgy values
C     depending on scanner program version
C
C                
C
ccc       Q/0.050/
      DATA IGROUP/0/,FLAMDA/1.5418/,CELL/3*0.0,3*90.0/,F/0.0/,
     +     THRESH/0.0/,S0/1.0,0.0,0.0/,ACHSE/0.0,0.0,1.0/,ED/0.0,1.0,
     +     0.0,0.0,0.0,1.0,3*0.0/,FIXF/1/,DPHI/1.0/,Q/0.150/,
     +     ORGX/-999.0/,ORGY/-999.0/,DXY/1.0/
      DATA TARGET/.FALSE./,DCOMP/.FALSE./,FILM/.FALSE./,LCAMC/.FALSE./,
     +     XDSOUT/.FALSE./,BRIEF/.FALSE./
      DATA ROFF/0.0/,TOFF/0.0/
C     ..
C
C
      END
C
C
C
C
C     =================================================================
      SUBROUTINE REFINE(NCYCLE,REIDX,N,IH,IK,IL,IX,IY,IPHI,ACHSE,IC,ICS,
     @           Q,ORGX,ORGY,F,S0L,ED,U,RCELL,SDU,SDCELL,SDPHI,SDXY,IER)
C     =================================================================
      IMPLICIT NONE
C
C
C
C*******                                                       *********
C*******            LEAST-SQUARES REFINEMENT OF                *********
C*******          DETECTOR AND CRYSTAL PARAMETERS              *********
C*******                                                       *********
C***********************************************************************
C*******                                                       *********
C*******            W. KABSCH    September 1991                *********
C*******           derived from version 11-1987                *********
C*******                                                       *********
C***********************************************************************
C
C  SUBROUTINES REQUIRED: DGELS,GONSYS,INVERS,MATCOP,RFMATMUL,METRIC,UNORM
C
C***********************************************************************
C
C NCYCLE - NUMBER OF REFINEMENT CYCLES                           (GIVEN)
C  REIDX - INTEGER*2 ARRAY(12) PROVIDING A POSSIBILITY OF        (GIVEN)
C          REINDEXING THE REFLECTIONS.
C          THE MEANING OF THE 12 NUMBERS IS DEFINED AS:
C          H' =REIDX(1)*H+REIDX( 2)*K+REIDX( 3)*L+REIDX( 4)
C          K' =REIDX(5)*H+REIDX( 6)*K+REIDX( 7)*L+REIDX( 8)
C          L' =REIDX(9)*H+REIDX(10)*K+REIDX(11)*L+REIDX(12)
C          WHERE H',K',L' ARE THE NEW INDICES.
C    N   - NUMBER OF REFLECTIONS  (INTEGER*4)                    (GIVEN)
C   IH   - INTEGER*2 ARRAY SPECIFYING H-INDICES FOR A LIST       (GIVEN)
C          OF N REFLECTIONS.
C   IK   - INTEGER*2 ARRAY SPECIFYING K-INDICES FOR A LIST       (GIVEN)
C          OF N REFLECTIONS.
C   IL   - INTEGER*2 ARRAY SPECIFYING L-INDICES FOR A LIST       (GIVEN)
C          OF N REFLECTIONS.
C   IX   - INTEGER*2 ARRAY SPECIFYING X-POSITION ON DETECTOR     (GIVEN)
C          FOR EACH SPOT IN THE LIST ( TENTH OF A PIXEL)
C   IY   - INTEGER*2 ARRAY SPECIFYING Y-POSITION ON DETECTOR     (GIVEN)
C          FOR EACH SPOT IN THE LIST ( TENTH OF A PIXEL)
C  IPHI  - INTEGER*2 ARRAY SPECIFYING ANGULAR POSITION OF        (GIVEN)
C          SPINDLE WHERE REFLECTION WITH INDICES IH,IK,IL
C          WAS DIFFRACTING. THE VALUES ARE GIVEN IN UNITS
C          OF A HUNDRETH OF A DEGREE.
C  ACHSE - ARRAY(3) SPECIFYING LAB COORDINATES OF ROTATION AXIS  (GIVEN)
C   IC   - NUMBER SPECIFYING A SUBSET OF PARAMETERS WHICH        (GIVEN)
C          ARE TO BE REFINED. (UNIT CELL PARAMETERS ARE
C          TREATED SEPARATELY BY THE VALUE OF "ICS".)
C           1: REFINE ALL PARAMETERS
C           2: FIX THE ORIENTATION OF THE DETECTOR
C           3: FIX THE ORIENTATION OF THE DETECTOR AND THE
C              DISTANCE BETWEEN DETECTOR AND CRYSTAL.
C           4: FIX THE ORIENTATION OF THE DETECTOR AND THE
C              DIRECTION OF THE DIRECT BEAM.
C           5: FIX THE ORIENTATION OF THE DETECTOR, THE
C              DISTANCE BETWEEN DETECTOR AND CRYSTAL, AND
C              THE DIRECTION OF THE DIRECT BEAM.
C           6: FIX THE DIRECTION OF THE DIRECT BEAM AND THE
C              ORIENTATION OF THE UNIT CELL.
C           7: FIX THE DISTANCE BETWEEN DETECTOR AND CRYSTAL,
C              THE ORIENTATION OF THE DETECTOR, THE DIRECTION
C              OF THE DIRECT BEAM AND THE ORIENTATION OF THE
C              UNIT CELL.
C  ICS   - NUMBER SPECIFYING REFINEMENT CONSTRAINTS ON THE       (GIVEN)
C          UNIT CELL PARAMETERS ARISING FROM SYMMETRY.
C           0: DO NOT REFINE CELL PARAMETERS.
C          >0: REFINE INDEPENDENT CELL PARAMETERS. THE
C              INDEPENDENT PARAMETERS ARE DERIVED FROM
C              THE VALUE OF "ICS".
C           1: TRICLINIC
C           2: MONOCLINIC FIRST SETTING
C           3: MONOCLINIC SECOND SETTING
C           4: ORTHORHOMBIC
C           5: TETRAGONAL
C           6: TRIGONAL
C           7: HEXAGONAL
C           8: CUBIC
C   Q    - LENGTH OF A PIXEL IN MILLIMETERS                      (GIVEN)
C ORGX   - X- AND Y-COORDINATES (PIXELS) ON DETECTOR SUCH      (UPDATED)
C ORGY   - THAT THE DETECTOR NORMAL WOULD INTERSECT THE        (UPDATED)
C          CRYSTAL
C   F    - CRYSTAL TO DETECTOR DISTANCE (MM).                  (UPDATED)
C  S0L   - COORDINATES OF INCIDENT X-RAY BEAM WAVE VECTOR.     (UPDATED)
C          ONLY THE DIRECTION OF S0L IS REFINED.
C          LENGTH OF S0L IS 1.0/LAMBDA. ( RECIPROCAL ANGSTROEM )
C  ED    - REAL ARRAY(3,3) SPECIFYING LAB COORDINATES OF       (UPDATED)
C          DETECTOR AXES.
C   U    - ARRAY(3,3) CONTAINING ORIENTATION MATRIX            (UPDATED)
C RCELL  - ARRAY OF LENGTH 6 OF RECIPROCAL UNIT CELL PARAMETERS(UPDATED)
C          IN RECIPROCAL ANGSTROEM AND DEGREES.
C  SDU   - ESTIMATED STANDARD DEVIATION (DEGREES)               (RESULT)
C          FOR ORIENTATION MATRIX U
C SDCELL - ARRAY(6) OF STANDARD DEVIATIONS                      (RESULT)
C          ( RECIPROCAL ANGSTROEM AND DEGREES ) FOR
C          RECIPROCAL UNIT CELL PARAMETERS.
C SDPHI  - STANDARD DEVIATION OF ANGULAR POSITION OF SPINDLE   (UPDATED)
C          ( DEGREES ). A POSITIVE INPUT VALUE IS
C          USED TO CALCULATE THE WEIGHTS OF THE OBSERVED
C          SPINDLE POSITIONS OF THE REFLECTIONS.
C          A NON-POSITIVE VALUE INDICATES THAT A DEFAULT
C          VALUE OF 0.1 DEGREES SHOULD BE USED.
C          ON RETURN, SDPHI CONTAINS THE ESTIMATED STANDARD
C          DEVIATION OF THE SPINDLE ANGLE AT WHICH THE
C          REFLECTIONS WERE DIFFRACTING.
C  SDXY  - STANDARD DEVIATION OF SPOT POSITION ON DETECTOR     (UPDATED)
C          (PIXELS). A POSITIVE INPUT VALUE IS USED TO
C          CALCULATE THE WEIGHTS OF THE OBSERVED SPOT
C          POSITIONS OF THE REFLECTIONS.
C          A NON-POSITIVE VALUE INDICATES THAT A DEFAULT
C          VALUE OF ONE PIXEL SHOULD BE USED.
C          ON RETURN, SDXY CONTAINS THE ESTIMATED STANDARD
C          DEVIATION OF THE SPOT POSITIONS ON THE DETECTOR.
C  IER   - ERROR INDICATOR SET BY SUBROUTINE . NORMALLY IER IS  (RESULT)
C          NUMBER OF ACCEPTED REFLECTIONS.
C           >0 : NO ERROR.
C            0 : INSUFFICIENT NUMBER OF ACCEPTED REFLECTIONS
C           -1 : Q IS NOT POSITIVE
C           -2 : F IS ZERO OR ILLEGAL DETECTOR ORIENTATION
C           -3 : ILLEGAL CELL PARAMETERS
C           -4 : ILLEGAL ROTATION AXIS OR DIRECT BEAM WAVE VECTOR
C           -5 : ILLEGAL CRYSTAL ORIENTATION MATRIX U
C           -6 : NCYCLE MUST BE BETWEEN 1 AND 10
C           -7 : REINDEXING TRANSFORMATION IS SINGULAR
C
C***********************************************************************
      INTEGER   M,IC,ICS,NCYCLE,ICYCLE,MXFREE,MMFREE,NRIGHT,MXRIGHT,
     1          MFREE,IRANK,I,J,MM,MY1,MY2,SPLIT
      INTEGER*4 N,NY,IER,NACC,SEED
      PARAMETER (MXFREE=14,MMFREE=(MXFREE*MXFREE+MXFREE)/2,NRIGHT=11,
     1           MXRIGHT=MXFREE*NRIGHT)
      INTEGER*2 IH(*),IK(*),IL(*),IPHI(*),IX(*),IY(*),IP(6,8),MCS(8),
     1          VAR(MXFREE,7),REIDX(12)
      REAL*8    QD(MMFREE),RD(MXRIGHT),AVGX(MXFREE),AVGY(MXFREE),
     1          AVX(NRIGHT),AVY(NRIGHT),Z,EPS,ONE,ZERO
      REAL      DXCALC(MXFREE),DYCALC(MXFREE),DELX(NRIGHT),DELY(NRIGHT),
     1          ESD(MXFREE),DCPHIC(MXFREE),DSPHIC(MXFREE),RCPHI(NRIGHT),
     2          RSPHI(NRIGHT),B(6),ZELLE(6),RZELLE(6),RCELL(6),CELL(6),
     3          SDCELL(6),ACHSE(3),S0L(3),S0G(3),DS0G(3),A0(3,3),A(3,3),
     4          DA(3,3,6),U(3,3),UG(3,3),DUG(3,3,3),EG(3,3),ED(3,3),
     5          EDG(3,3),EDG0(3,3),DEDG(3,3,3),BASIS(3,3),XG(3),X0G(3),
     6          DX0G(3,MXFREE),DXG(3),SG(3),DSG(3),SD(3),DSD(3),WPHI,
     7          WXY,ESDPHI,ESDXY,SDPHI0,SDXY0,SDPHI,SDXY,SDU,ERROR,Q,F,
     8          ORGX,ORGY,FH,FK,FL,XOBS,YOBS,XCALC,YCALC,CPHI,SPHI,
     9          CPHIC,SPHIC,RHOQ,DRHOQ,R,RR,DRR,T1,T2,T3,T4,RAD,RAD100
      PARAMETER (RAD=57.29578,RAD100=100.0*RAD,
     1           ZERO=0.0D+0,ONE=1.0D+0,EPS=1.0D-05)
C***********************************************************************
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
      DATA      IP/ 1,2,3,4,5,6,  1,2,3,0,0,4,
     1              1,2,3,0,4,0,  1,2,3,0,0,0,
     2              1,1,2,0,0,0,  1,1,1,2,2,2,
     3              1,1,2,0,0,0,  1,1,1,0,0,0/
      DATA      MCS/  6,4,4,3,2,2,2,1/
      DATA      VAR/ 1,1,1,1,1,1,1,1,6*1,    1,0,1,0,1,1,1,1,6*1,
     1               0,0,1,0,1,1,1,1,6*1,    1,0,0,0,0,1,1,1,6*1,
     2               0,0,0,0,0,1,1,1,6*1,    1,1,1,1,0,0,0,0,6*1,
     3               0,0,0,0,0,0,0,0,6*1/
C
C
C
C
      IER=-3
      SDU=0.0
      DO 10 MY1=1,6
      IF (RCELL(MY1).LE.0.0)GO TO 650
      IF ((MY1.GT.3).AND.(RCELL(MY1).GT.179.0))GO TO 650
10    SDCELL(MY1)=0.0
C
C----  get number of independent parameters
C
      IF ((ICS.GT.0).AND.(ICS.LT.9))THEN
	  M=MCS(ICS)
      ELSE
	  M=0
      ENDIF
      MFREE=M+8
C
C----  check for sufficient number of reflections
C
      IER=0
      IF (N.LE.MFREE)GO TO 650
C
C----  check if crystal orientation and cell parameters
C      should be separated
C
      IF (IC.LT.1)IC=1
      IF (IC.GT.7)IC=7
      IF ((ICS.EQ.1).AND.(IC.LT.6))THEN
	 SPLIT=0
      ELSE
	 SPLIT=1
      ENDIF
C
C----  check q,f
C
      IF (Q.LE.0.0)IER=-1
      IF (F.EQ.0.0)IER=-2
      IF (IER.LT.0)GO TO 650
C
C----  get weights for observational equations
C
      IF (SDPHI.LE.0.0)SDPHI=0.1
      SDPHI0=SDPHI/RAD
      WPHI=1.0/SDPHI0**2
      IF (SDXY.LE.0.0)SDXY=1.0
      SDXY0=SDXY*Q
      WXY=1.0/SDXY0**2
C
C----  check number of refine cycles
C
      IER=-6
      IF ((NCYCLE.LT.1).OR.(NCYCLE.GT.10))GO TO 650
C
C----  check reindexing transformation
C
      IER=-7
      I=REIDX(1)*(REIDX(6)*REIDX(11)-REIDX(7)*REIDX(10))
     1 -REIDX(2)*(REIDX(5)*REIDX(11)-REIDX(7)*REIDX( 9))
     2 +REIDX(3)*(REIDX(5)*REIDX(10)-REIDX(6)*REIDX( 9))
      IF (I.EQ.0)GO TO 650
C
C----  define goniostat system
C
      CALL GONSYS(ACHSE,S0L,S0G,EG,I)
      IF (I.NE.0)THEN
	 IER=-4
	 GO TO 650
      ENDIF
C
C----  renormalize crystal orientation matrix to orthogonal form to
C      prevent accumulation of rounding errors.
C
      CALL UNORM(U,I)
      IF (I.NE.0)THEN
	 IER=-5
	 GO TO 650
      ENDIF
C
C----  get representation of crystal orientation matrix
C      with respect to goniostat system
C
      CALL INVERS(EG,A,R)
      CALL RFMATMUL(A,U,UG)
c      write(*,fmt=1750)((ug(i,j),j=1,3),i=1,3)
c      write(iout,fmt=1750)((ug(i,j),j=1,3),i=1,3)
c 1750 format('+++++ UG (Refix) +++++',/,3(3f12.6,/))
C
C----  get representation of detector orientation matrix
C    * with respect to goniostat system
C
      CALL UNORM(ED,I)
      IF (I.NE.0)THEN
	 IER=-2
	 GO TO 650
      ENDIF
      CALL RFMATMUL(A,ED,EDG)
c      write(*,fmt=1749)((edg(i,j),j=1,3),i=1,3)
c      write(iout,fmt=1749)((edg(i,j),j=1,3),i=1,3)
c 1749 format('+++++ EDG (Refix) +++++',/,3(3f12.6,/))
CC
C----  save original detector orientation matrix
C
      CALL MATCOP(EDG,EDG0)
C
C----  refinement loop 
C
C     derivatives of sin/cos of spindle position with respect to
C     distance and orientation of the detector are always zero.
C
      DO 20 J=1,4
      DSPHIC(J)=0.0
20    DCPHIC(J)=0.0
      DO 570 ICYCLE=1,NCYCLE
      ESDPHI=0.0
      ESDXY =0.0
C
C----  clear normal matrix and right hand sides
C
      DO 30 MY1=1,MMFREE
30    QD(MY1)=ZERO
      DO 40 MY1=1,MXRIGHT
40    RD(MY1)=ZERO
      DO 50 MY1=1,MXFREE
      AVGX(MY1)=ZERO
50    AVGY(MY1)=ZERO
      DO 60 MY1=1,NRIGHT
      AVX(MY1)=ZERO
60    AVY(MY1)=ZERO
C
C----  calculate derivative of detector orientation matrix
C
      DO 70 J=1,3
      DEDG(1,J,1)= 0.0
      DEDG(2,J,1)=-EDG(3,J)
      DEDG(3,J,1)= EDG(2,J)
      DEDG(1,J,2)= EDG(3,J)
      DEDG(2,J,2)= 0.0
      DEDG(3,J,2)=-EDG(1,J)
      DEDG(1,J,3)=-EDG(2,J)
      DEDG(2,J,3)= EDG(1,J)
70    DEDG(3,J,3)= 0.0
C
C----  calculate derivatives of direct beam wavevector
C
      DS0G(1)= 0.0
      DS0G(2)=-S0G(3)
      DS0G(3)= S0G(2)
C
C----  calculate derivative of crystal orientation matrix
C
      IF (SPLIT.EQ.0)GO TO 90
      DO 80 J=1,3
      DUG(1,J,1)= 0.0
      DUG(2,J,1)=-UG(3,J)
      DUG(3,J,1)= UG(2,J)
      DUG(1,J,2)= UG(3,J)
      DUG(2,J,2)= 0.0
      DUG(3,J,2)=-UG(1,J)
      DUG(1,J,3)=-UG(2,J)
      DUG(2,J,3)= UG(1,J)
80    DUG(3,J,3)= 0.0
C
C----  calculate setting matrix
C
90    DO 100 I=1,3
      R=RCELL(I+3)/RAD
      B(I)  =COS(R)
      B(I+3)=SIN(R)
      DO 100 J=1,3
      A0(I,J)=0.0
      DO 100 MY1=1,6
100   DA(I,J,MY1)=0.0
      A0(1,1)=RCELL(1)*B(5)
      A0(1,2)=RCELL(2)*(B(3)-B(1)*B(2))/B(5)
      A0(2,2)=SQRT((RCELL(2)*B(4))**2-A0(1,2)**2)
      A0(3,1)=RCELL(1)*B(2)
      A0(3,2)=RCELL(2)*B(1)
      A0(3,3)=RCELL(3)
      IF ((M.LT.1).OR.(SPLIT.EQ.0))GO TO 160
C
C----  calculate derivatives of setting matrix with respect to
C       independent cell parameters
C
      DA(1,1,1)=B(5)
      DA(3,1,1)=B(2)
      DA(1,2,2)=A0(1,2)/RCELL(2)
      DA(2,2,2)=A0(2,2)/RCELL(2)
      DA(3,2,2)=A0(3,2)/RCELL(2)
      DA(3,3,3)=1.0
      DA(1,2,4)=RCELL(2)*B(4)*B(2)/B(5)
      DA(2,2,4)=(A0(3,2)*B(4)-A0(1,2)*DA(1,2,4))/A0(2,2)
      DA(3,2,4)=-RCELL(2)*B(4)
      DA(1,1,5)=A0(3,1)
      DA(3,1,5)=-A0(1,1)
      DA(1,2,5)=A0(3,2)-A0(1,2)*B(2)/B(5)
      DA(2,2,5)=-A0(1,2)*DA(1,2,5)/A0(2,2)
      DA(1,2,6)=-RCELL(2)*B(6)/B(5)
      DA(2,2,6)=-A0(1,2)*DA(1,2,6)/A0(2,2)
      DO 130 I=1,3
      DO 130 J=1,3
      DO 110 MY1=1,M
110   B(MY1)=0.0
      DO 120 MY1=1,6
      MY2=IP(MY1,ICS)
      IF (MY2.GT.0)B(MY2)=B(MY2)+DA(I,J,MY1)
120   CONTINUE
      DO 130 MY1=1,M
130   DA(I,J,MY1)=B(MY1)
      DO 150 MY1=1,M
      DO 140 I=1,3
      DO 140 J=1,3
140   A(I,J)=UG(I,1)*DA(1,J,MY1)+UG(I,2)*DA(2,J,MY1)+UG(I,3)*DA(3,J,MY1)
      DO 150 I=1,3
      DO 150 J=1,3
150   DA(I,J,MY1)=A(I,J)
160   CALL RFMATMUL(UG,A0,A)
C
C----  enter contributions of observational equations 
C
      NACC=0
      SEED=1009
      DO 330 NY=1,N
C
C----  apply reindexing
C
      IF ((IH(NY).EQ.0).AND.(IK(NY).EQ.0).AND.(IL(NY).EQ.0))GO TO 330
      FH=REIDX(1)*IH(NY)+REIDX( 2)*IK(NY)+REIDX( 3)*IL(NY)+REIDX( 4)
      FK=REIDX(5)*IH(NY)+REIDX( 6)*IK(NY)+REIDX( 7)*IL(NY)+REIDX( 8)
      FL=REIDX(9)*IH(NY)+REIDX(10)*IK(NY)+REIDX(11)*IL(NY)+REIDX(12)
      XOBS=(IX(NY)/10.0-ORGX)*Q
      YOBS=(IY(NY)/10.0-ORGY)*Q
      R=IPHI(NY)/RAD100
      CPHI=COS(R)
      SPHI=SIN(R)
C
C----  get goniostat coordinates of reflection at phi=0
C
      DO 170 I=1,3
170   X0G(I)=A(I,1)*FH+A(I,2)*FK+A(I,3)*FL
C
C----  get goniostat coordinates of reflection at diffraction
C
      RR=X0G(1)**2+X0G(2)**2+X0G(3)**2
      RHOQ=RR-X0G(2)**2
      XG(3)=-(RR*0.5+X0G(2)*S0G(2))/S0G(3)
      XG(2)=X0G(2)
      XG(1)=RHOQ-XG(3)**2
      IF (XG(1).LE.0.0)GO TO 330
      XG(1)=SQRT(XG(1))
      IF ((X0G(1)*CPHI+X0G(3)*SPHI).LT.0.0)XG(1)=-XG(1)
C
C----  calculate sin/cos of spindle position at diffraction
C
      CPHIC=(XG(1)*X0G(1)+XG(3)*X0G(3))/RHOQ
      SPHIC=(XG(1)*X0G(3)-XG(3)*X0G(1))/RHOQ
C
C----  get goniostat coordinates of diffracted beam wavevector
C
      DO 180 I=1,3
180   SG(I)=S0G(I)+XG(I)
C
C----  get detector coordinates of diffracted beam wavevector
C
      DO 190 I=1,3
190   SD(I)=EDG(1,I)*SG(1)+EDG(2,I)*SG(2)+EDG(3,I)*SG(3)
      IF (SD(3).EQ.0.0)GO TO 330
C
C----  get detector coordinates of intersection point of diffracted
C       beam with detector surface
C
      XCALC=F*SD(1)/SD(3)
      YCALC=F*SD(2)/SD(3)
      if(debug(70))then
 1751    format('+++++ REFIX ++++++',/,
     $        '   H   K   L   IP(X)  IP(Y)    X(obs)      Y(obs)',
     $        '      X(calc)     Y(calc)')
 1752    format(3I4,2I7,4F12.5)
         if (ny.eq.1) then
            write(*,fmt=1751)         
            write(iout,fmt=1751) 
         endif
c         if (ny.le.10) then
            write(*,fmt=1752)ih(ny),ik(ny),il(ny),ix(ny),iy(ny),
     $           xobs,yobs,xcalc,ycalc
            write(iout,fmt=1752)ih(ny),ik(ny),il(ny),ix(ny),
     $           iy(ny),xobs,yobs,xcalc,ycalc
c         endif
      endif
      NACC=NACC+1
C
C----  derivatives with respect to f
C
      DXCALC(1)=SD(1)/SD(3)
      DYCALC(1)=SD(2)/SD(3)
C
C----  derivatives with respect to detector orientation
C
      DO 200 MY1=1,3
      T1=DEDG(1,1,MY1)*SG(1)+DEDG(2,1,MY1)*SG(2)+DEDG(3,1,MY1)*SG(3)
      T2=DEDG(1,2,MY1)*SG(1)+DEDG(2,2,MY1)*SG(2)+DEDG(3,2,MY1)*SG(3)
      T3=DEDG(1,3,MY1)*SG(1)+DEDG(2,3,MY1)*SG(2)+DEDG(3,3,MY1)*SG(3)
      DXCALC(MY1+1)=(T1*F-T3*XCALC)/SD(3)
200   DYCALC(MY1+1)=(T2*F-T3*YCALC)/SD(3)
C
C----  derivatives with respect to kappa
C           ..... derivatives of goniostat coordinates "xg"
C
      DXG(3)=X0G(2)-XG(3)*S0G(2)/S0G(3)
      DXG(1)=-XG(3)*DXG(3)/XG(1)
C
C          ..... derivatives of sin/cos of spindle position
C
      DSPHIC(5)=(DXG(1)*X0G(3)-DXG(3)*X0G(1))/RHOQ
      DCPHIC(5)=(DXG(1)*X0G(1)+DXG(3)*X0G(3))/RHOQ
C
C         ..... derivatives of goniostat coordinates of "sg"
C
      DSG(1)=DXG(1)
      DSG(2)=-S0G(3)
      DSG(3)=DXG(3)+S0G(2)
C
C            ..... detector coordinates of derivatives of 
C            diffracted beam wavevector
C
      DO 210 I=1,3
210   DSD(I)=EDG(1,I)*DSG(1)+EDG(2,I)*DSG(2)+EDG(3,I)*DSG(3)
C
C           ..... derivatives of calculated detector coordinates
C
      DXCALC(5)=(DSD(1)*F-DSD(3)*XCALC)/SD(3)
      DYCALC(5)=(DSD(2)*F-DSD(3)*YCALC)/SD(3)
C
C----  derivatives with respect to reciprocal cell setting matrix
C
      IF (SPLIT.EQ.1)GO TO 240
      DO 220 I=1,3
      DO 220 J=1,M+3
220   DX0G(I,J)=0.0
      DO 230 I=1,3
      DX0G(I,I  )=FH
      DX0G(I,I+3)=FK
230   DX0G(I,I+6)=FL
      GO TO 260
C
C----  derivatives with respect to unit cell orientation
C
240   DX0G(1,1)= 0.0
      DX0G(2,1)=-X0G(3)
      DX0G(3,1)= X0G(2)
      DX0G(1,2)= X0G(3)
      DX0G(2,2)= 0.0
      DX0G(3,2)=-X0G(1)
      DX0G(1,3)=-X0G(2)
      DX0G(2,3)= X0G(1)
      DX0G(3,3)= 0.0
      IF (M.LT.1)GO TO 260
C
C        ..... derivatives with respect to independent cell parameters
C
      DO 250 MY1=1,M
      DO 250 I=1,3
250   DX0G(I,MY1+3)=DA(I,1,MY1)*FH+DA(I,2,MY1)*FK+DA(I,3,MY1)*FL
C
C         ..... derivatives with respect to unit cell orientation and
C                independent cell parameters
C
260   DO 280 J=1,M+3
      DRR=X0G(1)*DX0G(1,J)+X0G(2)*DX0G(2,J)+X0G(3)*DX0G(3,J)
      DXG(3)=-(DRR+S0G(2)*DX0G(2,J))/S0G(3)
      DXG(1)=(DRR-X0G(2)*DX0G(2,J)-XG(3)*DXG(3))/XG(1)
      DRHOQ=2.0*(X0G(1)*DX0G(1,J)+X0G(3)*DX0G(3,J))
      DSPHIC(J+5)=(DXG(1)*X0G(3)+XG(1)*DX0G(3,J)
     @            -DXG(3)*X0G(1)-XG(3)*DX0G(1,J)-SPHIC*DRHOQ)/RHOQ
      DCPHIC(J+5)=(DXG(1)*X0G(1)+XG(1)*DX0G(1,J)
     @            +DXG(3)*X0G(3)+XG(3)*DX0G(3,J)-CPHIC*DRHOQ)/RHOQ
C
C         ..... derivatives of goniostat coordinates of "sg"
C
      DSG(1)=DXG(1)
      DSG(2)=DX0G(2,J)
      DSG(3)=DXG(3)
C
C          ..... detector coordinates of derivatives of 
C                diffracted beam wavevector
C
      DO 270 I=1,3
270   DSD(I)=EDG(1,I)*DSG(1)+EDG(2,I)*DSG(2)+EDG(3,I)*DSG(3)
C
C          ..... derivatives of calculated detector coordinates
C
      DXCALC(J+5)=(DSD(1)*F-DSD(3)*XCALC)/SD(3)
280   DYCALC(J+5)=(DSD(2)*F-DSD(3)*YCALC)/SD(3)
C
C----  calculate residuals
C
      RCPHI(1)=CPHIC-CPHI
      RSPHI(1)=SPHIC-SPHI
      DELX(1)=XCALC-XOBS
      DELY(1)=YCALC-YOBS
C
C----  add normally distributed random errors to residuals
C
      R=SQRT(RR/RHOQ)*SDPHI0
      DO 290 MY1=2,NRIGHT
      SEED=MOD(151*SEED+1,20011)
      ERROR=(SEED/20011.0-0.5)*R
      RCPHI(MY1)=RCPHI(1)+SPHI*ERROR
      RSPHI(MY1)=RSPHI(1)-CPHI*ERROR
      SEED=MOD(151*SEED+1,20011)
      DELX(MY1)=DELX(1)-(SEED/20011.0-0.5)*SDXY0
      SEED=MOD(151*SEED+1,20011)
290   DELY(MY1)=DELY(1)-(SEED/20011.0-0.5)*SDXY0
C
C----  add contributions to determine root-mean-square of residuals
C
      ESDPHI=ESDPHI+(RCPHI(1)**2+RSPHI(1)**2)*RHOQ/RR
      ESDXY=ESDXY+DELX(1)**2+DELY(1)**2
C
C----  add contribution of this reflection to normal equations
C
      MM=0
      DO 310 MY1=1,MFREE
      AVGX(MY1)=AVGX(MY1)+DXCALC(MY1)
      AVGY(MY1)=AVGY(MY1)+DYCALC(MY1)
      T1=DSPHIC(MY1)*WPHI*RHOQ/RR
      T2=DCPHIC(MY1)*WPHI*RHOQ/RR
      T3=DXCALC(MY1)*WXY
      T4=DYCALC(MY1)*WXY
      J=MY1
      DO 300 MY2=1,NRIGHT
      RD(J)=RD(J)-RSPHI(MY2)*T1-RCPHI(MY2)*T2-DELX(MY2)*T3-DELY(MY2)*T4
300   J=J+MFREE
      DO 310 MY2=1,MY1
      MM=MM+1
310   QD(MM)=QD(MM)+T1*DSPHIC(MY2)+T2*DCPHIC(MY2)
     @           +T3*DXCALC(MY2)+T4*DYCALC(MY2)
      DO 320 MY2=1,NRIGHT
      AVX(MY2)=AVX(MY2)+DELX(MY2)
320   AVY(MY2)=AVY(MY2)+DELY(MY2)
330   CONTINUE
C
C---- get estimated standard deviations of observed reflection
C       positions and angles
C
      IF (NACC.LE.MFREE)THEN
	 IER=0
	 GO TO 650
      ENDIF
      SDPHI=RAD*SQRT(ESDPHI/(NACC-MFREE))
      SDXY=SQRT(ESDXY/(NACC-MFREE))/Q
C
C----  get mean-values of residuals
C
      DO 340 MY2=1,NRIGHT
      AVX(MY2)=AVX(MY2)/NACC
340   AVY(MY2)=AVY(MY2)/NACC
C
C----  get mean-values of gradients
C
      DO 350 MY1=1,MFREE
      AVGX(MY1)=AVGX(MY1)/NACC
350   AVGY(MY1)=AVGY(MY1)/NACC
C
C----  correct origin
C
      ORGX=ORGX-AVX(1)/Q
      ORGY=ORGY-AVY(1)/Q
C
C----  early termination because goal has already been achieved
C
      IF ((SDPHI.LT.0.01).AND.(SDXY.LE.0.05))GO TO 600
C
C----  subtract mean-values of residuals from right-hand side
C      and tensor product of mean gradients from normal matrix
C
      MM=0
      DO 370 MY1=1,MFREE
      J=MY1
      DO 360 MY2=1,NRIGHT
      RD(J)=RD(J)+WXY*NACC*(AVX(MY2)*AVGX(MY1)+AVY(MY2)*AVGY(MY1))
360   J=J+MFREE
      DO 370 MY2=1,MY1
      MM=MM+1
370   QD(MM)=QD(MM)-WXY*NACC*(AVGX(MY1)*AVGX(MY2)+AVGY(MY1)*AVGY(MY2))
C
C----  rescale system of equations
C
      MM=0
      DO 380 MY1=1,MFREE
      MM=MM+MY1
      Z=QD(MM)
      IF (Z.GT.ZERO)Z=ONE/DSQRT(Z)
      AVGX(MY1)=Z
      ESD(MY1)=Z
      J=MY1
      DO 380 MY2=1,NRIGHT
      RD(J)=RD(J)*Z
380   J=J+MFREE
      MM=0
      DO 390 MY1=1,MFREE
      DO 390 MY2=1,MY1
      MM=MM+1
390   QD(MM)=QD(MM)*AVGX(MY1)*AVGX(MY2)
C
C----  remove fixed parameters from the normal equations
C
      MM=0
      DO 430 MY1=1,MFREE
      IF (VAR(MY1,IC).NE.0)GO TO 410
      J=MY1
      DO 400 MY2=1,NRIGHT
      RD(J)=ZERO
400   J=J+MFREE
410   DO 420 MY2=1,MY1
      MM=MM+1
      IF (((VAR(MY1,IC).EQ.0).OR.(VAR(MY2,IC).EQ.0)).AND.(MY2.NE.MY1))
     @   QD(MM)=ZERO
420   CONTINUE
      QD(MM)=ONE
430   CONTINUE
C
C----  solve normal equations
C
      CALL DGELS(RD,QD,MFREE,NRIGHT,EPS,IRANK,AVGX)
      DO 450 MY1=1,MFREE
      Z=ZERO
      MM=MY1
      DO 440 MY2=1,NRIGHT
      RD(MM)=RD(MM)*ESD(MY1)
      Z=Z+(RD(MM)-RD(MY1))**2
440   MM=MM+MFREE
450   ESD(MY1)=DSQRT(Z/(NRIGHT-1))
C
C----  get scaling factor for standard deviations of cell parameters
C
      T1=SDPHI/SQRT(SDPHI**2+(SDPHI0*RAD)**2)
C
C     t2=sdxy/sqrt(sdxy**2+(sdxy0/q)**2)
C
C----  apply corrections and calculate estimated standard deviations
C        for the refined parameters
C
C            ..... detector distance
C
      F=F+RD(1)
C
C            ..... detector orientation
C
      DO 460 J=1,3
      DO 460 I=1,3
460   EDG(I,J)=EDG(I,J)
     @        +RD(2)*DEDG(I,J,1)+RD(3)*DEDG(I,J,2)+RD(4)*DEDG(I,J,3)
      CALL UNORM(EDG,I)
      IF (I.NE.0)THEN
	  IER=-2
	  GO TO 650
      ENDIF
C
C              .....incident x-ray beam (kappa)
C
      R=RD(5)
      CPHI=COS(R)
      SPHI=SIN(R)
      R=S0G(2)*CPHI-S0G(3)*SPHI
      S0G(3)=S0G(3)*CPHI+S0G(2)*SPHI
      S0G(2)=R
      IF (SPLIT.EQ.0)GO TO 510
C
C             .....orientation matrix
C
      DO 470 J=1,3
      DO 470 I=1,3
470   UG(I,J)=UG(I,J)+RD(6)*DUG(I,J,1)+RD(7)*DUG(I,J,2)+RD(8)*DUG(I,J,3)
      CALL UNORM(UG,I)
      IF (I.NE.0)THEN
	  IER=-5
	  GO TO 650
      ENDIF
      SDU=RAD*SQRT(ESD(6)**2+ESD(7)**2+ESD(8)**2)
C
C            .....reciprocal cell dimensions
C
      DO 480 MY1=1,6
      B(MY1)=RCELL(MY1)
      RZELLE(MY1)=RCELL(MY1)
480   SDCELL(MY1)=0.0
      IF (M.LT.1)GO TO 570
      DO 500 I=1,NRIGHT
      DO 490 MY1=1,6
      MY2=IP(MY1,ICS)
      IF (MY2.LE.0)GO TO 490
      IF (MY1.LT.4)THEN
	  R=RD(MY2+8+MFREE*(I-1))
      ELSE
	  R=RAD*RD(MY2+8+MFREE*(I-1))
      ENDIF
      RZELLE(MY1)=B(MY1)+R
490   CONTINUE
      CALL INVCEL(RZELLE,ZELLE,R)
      DO 500 MY1=1,6
      IF (I.EQ.1)THEN
	 CELL(MY1)=ZELLE(MY1)
	 RCELL(MY1)=RZELLE(MY1)
      ELSE
	 SDCELL(MY1)=SDCELL(MY1)+(ZELLE(MY1)-CELL(MY1))**2
      ENDIF
500   CONTINUE
      GO TO 540
C
C----    update rec. setting matrix and extract cell parameters and
C        crystal orientation
C
510   DO 530 MY1=1,NRIGHT
      DO 520 I=1,3
      DO 520 J=1,3
520   A0(I,J)=A(I,J)+RD(I+3*(J-1)+5+MFREE*(MY1-1))
      IF (MY1.EQ.1)CALL MATCOP(A0,U)
      CALL INVERS(A0,BASIS,R)
      CALL METRIC(BASIS,ZELLE,IER)
      CALL INVCEL(ZELLE,RZELLE,R)
      DO 530 I=1,6
      IF (MY1.EQ.1)THEN
	 CELL(I)=ZELLE(I)
	 RCELL(I)=RZELLE(I)
      ELSE
	 SDCELL(I)=SDCELL(I)+(ZELLE(I)-CELL(I))**2
      ENDIF
530   CONTINUE
      CALL RFSETMAT(RCELL,A)
      CALL INVERS(A,BASIS,R)
      CALL RFMATMUL(U,BASIS,UG)
540   DO 550 I=1,6
550   SDCELL(I)=SQRT(T1*SDCELL(I)/(NRIGHT-1))
570   CONTINUE
C
C----  end of refinement loop 
C
C
600   IF (IC.EQ.5)GO TO 630
C
C----  transform back to laboratory coordinate system
C
      CPHI=0.0
      SPHI=0.0
      DO 610 I=1,3
      CPHI=CPHI+EDG0(3,I)*EDG(3,I)+EDG0(1,I)*EDG(1,I)
610   SPHI=SPHI+EDG0(1,I)*EDG(3,I)-EDG0(3,I)*EDG(1,I)
      R=SQRT(CPHI**2+SPHI**2)
      CPHI=CPHI/R
      SPHI=SPHI/R
      DO 620 I=1,3
      R=EG(1,I)*CPHI+EG(3,I)*SPHI
      EG(3,I)=EG(3,I)*CPHI-EG(1,I)*SPHI
620   EG(1,I)=R
630   CALL RFMATMUL(EG,EDG,ED)
      CALL RFMATMUL(EG,UG,U)
      DO 640 I=1,3
640   S0L(I)=EG(I,2)*S0G(2)+EG(I,3)*S0G(3)
      IER=NACC
650   RETURN
      END
C***********************************************************************
C                                                                      *
C                       REFIX                        VERSION 9-1992    *
C                                                                      *
C***********************************************************************
C                                                                      *
C                DETERMINES CRYSTAL PARAMETERS FROM A                  *
C                LIST OF OBSERVED REFLECTION POSITIONS                 *
C                                                                      *
C***********************************************************************
C                                                                      *
C***** Please do not redistribute the program but contact the author ***
C                                                                      *
C      WOLFGANG KABSCH                                                 *
C      MAX-PLANCK-INSTITUTE FOR MEDICAL RESEARCH                       *
C      DEPARTMENT OF BIOPHYSICS                                        *
C      JAHNSTRASSE 29                                                  *
C      6900 HEIDELBERG   FRG                                           *
C                                                                      *
C***********************************************************************
C                                                                      *
C                         REFERENCES                                   *
C                                                                      *
C 1."Automatic Processing of Rotation Diffraction Data from Crystals   *
C    of Initially Unknown Symmetry and Cell Constants"                 *
C    Kabsch,W. (1993),J.Appl.Cryst. submitted                          *
C 2."AUTOMATIC INDEXING OF ROTATION DIFFRACTION PATTERNS"              *
C    Kabsch,W. (1988),J.Appl.Cryst.21,67-71.                           *
C                                                                      *
C***********************************************************************
C
C  Changes
C  =======
C
C  Sep 94 Add BEAMSEARCH option. Change format of spots file, but allow
C         reading old format if logical NEW is set FALSE in S/R AUTOIX.
C
C  Oct 94 Add TWOTHETA option for detectors on two-theta arm
C
C
C  9/5/95 Correct error which set twotheta to the space group number.
C         Fix to UMAT code which would not work correctly in some
C         circumstances (eg P21)
C
C***********************************************************************
C                                                                      *
C                      FILES USED BY THIS ROUTINE                      *
C                                                                      *
C   FILE NAME                   DESCRIPTION                     STATUS *
C                                                                      *
C  REFIX.DATA   - DATA CARDS FOR THE PROGRAM                    (GIVEN)*
C   SPOT.LIST   - A LIST OF SPOTS. ON RETURN INDICES         (MODIFIED)*
C                 ARE ATTACHED TO EACH SPOT.                           *
C  REFIX.PARM   - REFINED DIFFRACTION PARAMETERS               (RESULT)*
C   REFIX.LP    - PRINTED MESSAGES AND RESULTS                 (RESULT)*
C                                                                      *
C***********************************************************************
C                                                                      *
C             DESCRIPTION OF INPUT PARAMETERS                          *
C                                                                      *
C The input parameters necessary to run this program are assumed to    *
C be present in the sequential formatted file "REFIX.DATA" in the      *
C current directory. The laboratory frame can be any (!) orthonormal   *
C right-handed coordinate system chosen by the user.                   *
C                                                                      *
C line #                            contents                           *
C   1      FLAMDA- x-ray wavelength (Angstroem)                        *
C          S0    - x,y,z components of the direct beam wavevector with *
C                  respect to the laboratory coordinate system.        *
C                  Direction of "S0" is from X-ray source towards the  *
C                  crystal.                                            *
C          ACHSE - x,y,z components of rotation axis with respect to   *
C                  laboratory system.                                  *
C   2      IGROUP- Space-group number of crystal. The numbers          *
C                  corresponding to each possible space-group          *
C                  are defined in the "INTERNATIONAL TABLES I".        *
C                  At present, only the 65 enantiomorphic space groups *
C                  are implemented. A value of zero for IGROUP         *
C                  indicates that space group and cell parameters      *
C                  are unknown.                                        *
C          CELL  - Unit cell parameters a,b,c (Angstroem) and          *
C                  alpha,beta,gamma (degrees). In case of IGROUP=0     *
C                  these 6 numbers may all be 0.0                      *
C   3      Q     - Length of a detector pixel (mm).                    *
C          F     - Signed distance between crystal and detector (mm).  *
C                  Note that "F" may be negative depending upon "ED".  *
C          ORGX  - Detector X-coordinate (pixels) of origin,           *
C          ORGY  - Detector Y-coordinate (pixels) of origin.           *
C          ED    - Orientation matrix of the detector with respect to  *
C                  the laboratory system. The lab coordinates of       *
C                  a point  IX,IY (pixels) on the detector are :       *
C                  x=Q*(IX-ORGX)*ED(1,1)+Q*(IY-ORGY)*ED(1,2)+F*ED(1,3) *
C                  y=Q*(IX-ORGX)*ED(2,1)+Q*(IY-ORGY)*ED(2,2)+F*ED(2,3) *
C                  z=Q*(IX-ORGX)*ED(3,1)+Q*(IY-ORGY)*ED(3,2)+F*ED(3,3) *
C                  Only the following values must be given:            *
C                  ED(1,1),ED(2,1),ED(3,1),ED(1,2),ED(2,2),ED(3,2)     *
C                  The third unit vector is then calculated by the     *
C                  program as  ED(.,3)=ED(.,1) X ED(.,2)               *
C   4      FIXF  - Refinement control variable                         *
C                  0: refine detector to crystal distance, direct      *
C                     beam direction and unit cell orientation.        *
C                     The cell parameters are fixed.                   *
C                  1: fix detector to crystal distance and refine      *
C                     direct beam direction, unit cell orientation     *
C                     and independent cell parameters.                 *
C          DPHI  - Expected error (degrees) of spindle position of     *
C                  the spots given on file "SPOT.LIST"                 *
C          DXY   - Expected error (pixels) of spot positions.          *
C                                                                      *
C***********************************************************************
C                                                                      *
C                DESCRIPTION OF RESULT FILES                           *
C                                                                      *
C   FILE NAME                   DESCRIPTION                            *
C                                                                      *
C   SPOT.LIST   - Sequential formatted file. Each record consists of   *
C                 3 real and 3 integer numbers as follows:             *
C                 X     - X-coordinate (pixels) of observed spot       *
C                 Y     - Y-coordinate (pixels) of observed spot       *
C                 PHI   - Spindle position (degrees) of observed spot  *
C                 On return indices are attached to each spot          *
C                 IH     - h-index of spot                             *
C                 IK     - k-index of spot                             *
C                 IL     - l-index of spot                             *
C                 A spot which could not be indexed has IH=IK=IL=0.    *
C                 On input only the first 3 numbers need to be present.*
C                 A minimum of 25 neighbouring spots is required but   *
C                 more spots will lead to better parameter estimates.  *
C                 The program accepts up to 3000 spots and ignores the *
C                 rest. The spots should all be selected from a narrow *
C                 oscillation range of about 5 degrees. In case the    *
C                 spots are from a single oscillation film set all     *
C                 values "PHI" equal to the spindle angle at the center*
C                 of the oscillation range.                            *
C   REFIX.PARM  - Refined diffraction parameters written as a single   *
C                 formatted sequential record.                         *
C                 ACHSE  - real(3)    lab coordinates of rotation axis *
C                 ED     - real(3,3)  lab coordinates of detector      *
C                                     orientation matrix.              *
C                 ORGX   - real       X-origin on film                 *
C                 ORGY   - real       Y-origin on film                 *
C                 F      - real       crystal to film distance         *
C                 S0     - real(3)    direct beam wavevector           *
C                 RCELL  - real(6)    reciprocal cell parameters       *
C                 U      - real(3,3)  orientation  matrix of crystal   *
C                 SDU    - real       standard deviation of U          *
C                 SDXY   - real       standard deviation of spot       *
C                                     locations (pixels)               *
C                 SDPHI  - real       standard deviation of spindle    *
C                                     positions (degrees)              *
C                 SDCELL - real(6)    standard deviations of reciprocal*
C                                     unit cell parameters             *
C   REFIX.LP    - Printed messages and results                         *
C                                                                      *
C***********************************************************************
C                                                                      *
C            SPECIAL CASE OF A SUPPER-ROTATION CAMERA                  *
C                                                                      *
C  The lab coordinate system used is described in the reference.       *
C                                                                      *
C  The rotation axis has coordinates: 0.0 , 1.0 , 0.0                  *
C                                                                      *
C  Using data frames as produced by the HARVARD software               *
C  we have  for a detector swing angle CHI                             *
C     ED(1,1)=-cos(CHI)   ED(2,1)= 0   ED(3,1)= sin(CHI)               *
C     ED(1,2)= 0          ED(2,2)=-1   ED(3,2)= 0                      *
C                                                                      *
C  Since the vector ED(.,3) is pointing from the crystal towards the   *
C  detector we usually get a positive sign for "F".                    *
C                                                                      *
C***********************************************************************
C                                                                      *
C                     SAMPLE INPUT DATA                                *
C                                                                      *
C 1.5418 0.0 0.0 1.0     0.0 1.0 0.0                                   *
C 19 133.0 56.4 110.0 90.0  90.0  90.0                                 *
C 0.2  120.0 256.5  237.3  -1.0  0.0  0.0     0.0 -1.0 0.0             *
C  1  0.45 1.5                                                         *
C***********************************************************************
C************************* GLOBAL PARAMETERS ***************************
C***********************************************************************
C ERRINT - MAXIMUM ALLOWED DEVIATION OF COMPUTED INDICES OF A GRID     *
C          POINT FROM THE NEAREST INTEGER NUMBER. ("AUTOIX")           *
C ERRZEL - MAXIMUM ALLOWED RELATIVE ERROR IN CELL CONSTANTS AS         *
C          SPECIFIED ON "REFIX.DATA". ("AUTOIX")                       *
C MAXIDX - THE ABSOLUTE VALUE OF AN INDEX ASSIGNED TO ANY DIFFERENCE   *
C          VECTOR CLUSTER IS NOT ALLOWED TO EXCEED THE VALUE OF        *
C          "MAXIDX" DURING THE SEARCH FOR THE BEST SET OF BASIS        *
C          VECTORS EXPLAINING THE GIVEN LIST OF CLUSTER VECTORS.       *
C          (USED BY "AUTOIX" IN SUBROUTINE "REDUCE")                   *
C MXBEST - MAXIMUM NUMBER OF BEST POSSIBLE UNIT CELL ORIENTATIONS      *
C          REMEMBERED ("AUTOIX").                                      *
C  MXRFL - MAXIMUM NUMBER OF SPOTS IN THE INITIAL SPOT LIST ("AUTOIX") *
C MXSPOT - MAXIMUM NUMBER OF DIFFERENCE VECTOR CLUSTERS ("AUTOIX").    *
C  MXY,  - DEFINES SIZE OF TABLE TO COLLECT DIFFERENCE VECTOR CLUSTERS *
C  MZ      ("AUTOIX").                                                 *
C NCYCLE - NUMBER OF REFINEMENT CYCLES TO DETERMINE DIFFRACTION        *
C          PARAMETERS ("AUTOIX").                                      *
C************* TYPE DEFINITIONS OF VARIABLES AND CONSTANTS *************
C
      SUBROUTINE REFIX(DEBUG)
C
      IMPLICIT NONE
      LOGICAL DEBUG
      INTEGER      CDR,SPOT,XPARM,
     @             MXRFL,MXSPOT,MXY,MZ,MXBEST,NCYCLE,MAXIDX
      REAL         ERRINT,ERRZEL
C********************* FORTRAN DEVICE UNIT NUMBERS *********************
      PARAMETER    (CDR=7,SPOT=15)
C********************** GLOBAL PARAMETERS VALUES ***********************
      PARAMETER    (ERRINT=0.1,ERRZEL=0.1,MAXIDX=5,MXBEST=4,MXRFL=3000,
     1              MXSPOT=120,MXY=101,MZ=101,NCYCLE=6)
C************* DEFINITION OF ARRAYS USED IN SUBROUTINE "AUTOIX" ********
      REAL         ORGXB(MXBEST),ORGYB(MXBEST),UB(3,3,MXBEST),
     1             FB(MXBEST),EDB(3,3,MXBEST),S0B(3,MXBEST),
     2             RCELLB(6,MXBEST),ESDCEL(6,MXBEST),ESDU(MXBEST),
     3             ESDXY(MXBEST),ESDPHI(MXBEST),ESD(MXBEST),RMS(MXBEST),
     4             VC(3,MXSPOT),POP(MXSPOT),COOR(3,MXRFL)
      INTEGER*2    I2X(MXRFL),I2Y(MXRFL),I2PHI(MXRFL),
     1             I2H(MXRFL),I2K(MXRFL),I2L(MXRFL),IP(MXRFL),
     2             IQ(MXRFL),IW(MXRFL),TABLE(MXY*MXY*MZ),NACCB(MXBEST),
     3             IXST(MXRFL),IYST(MXRFL),IPHIST(MXRFL),IRADST(MXRFL),
     4             IORD(MXRFL)
      LOGICAL ONLINE
      INTEGER LP,LINOUT
      COMMON /RINOUT/ ONLINE,LP,LINOUT
C     ..
C     .. External Subroutines ..
      EXTERNAL CCPERR
C***********************************************************************
      CALL AUTOIX(CDR,SPOT,XPARM,ERRINT,ERRZEL,MAXIDX,NCYCLE,MXSPOT,
     1            MXY,MZ,MXBEST,MXRFL,ORGXB,ORGYB,FB,UB,EDB,S0B,RCELLB,
     2            ESDCEL,ESDU,ESDXY,ESDPHI,ESD,RMS,COOR,VC,POP,NACCB,
     3            I2X,I2Y,I2PHI,I2H,I2K,I2L,IP,IQ,IW,IXST,IYST,IRADST,
     4            IPHIST,IORD,TABLE,DEBUG)
CAL      CALL CCPERR(0, ' Normal termination for REFIX')
      RETURN
      END
C
C
C
C
C     ========================================================
      SUBROUTINE REFLEX(EG,CPHI,SPHI,S0L,S0G,X0L,X0G,XL,XG,SL,
     @                  CPHIC,SPHIC,RR,RHOQ,IER)
C     ========================================================
      IMPLICIT NONE
C
C
C
C
C*****                                                             *****
C*****       CALCULATE DIFFRACTION GEOMETRY FOR A REFLECTION       *****
C*****                                                             *****
C***********************************************************************
C
C   EG   - REAL ARRAY(3,3) SPECIFYING GONIOSTAT SYSTEM           (GIVEN)
C          EG(I,1)=LAB COORDINATES OF UNIT VECTOR ALONG VECTOR
C           CROSS PRODUCT BETWEEN SPINDLE AXIS AND DIRECT BEAM.
C          EG(I,2)=LAB COORDINATES OF UNIT VECTOR ALONG SPINDLE.
C          EG(I,3)=LAB COORDINATES OF EG(I,1) X EG(I,2).
C  CPHI  - COSINE OF OBSERVED SPINDLE POSITION AT DIFFRACTION    (GIVEN)
C  SPHI  -   SINE OF OBSERVED SPINDLE POSITION AT DIFFRACTION    (GIVEN)
C   S0L  - LAB COORDINATES OF DIRECT BEAM WAVEVECTOR             (GIVEN)
C   S0G  - COORDINATES OF S0L WITH RESPECT TO EG                 (GIVEN)
C   X0L  - LAB COORDINATES OF REFLECTION AT PHI=0                (GIVEN)
C   X0G  - GONIOSTAT COORDINATES OF X0L AT PHI=0                (RESULT)
C   XL   - LAB COORDINATES OF REFLECTION AT DIFFRACTION         (RESULT)
C   XG   - GONIOSTAT COORDINATES OF REFLECTION AT DIFFRACTION   (RESULT)
C   SL   - LAB COORDINATES OF DIFFRACTED BEAM WAVEVECTOR        (RESULT)
C CPHIC  - COSINE OF CALCULATED SPINDLE POSITION AT DIFFRACTION (RESULT)
C SPHIC  -   SINE OF CALCULATED SPINDLE POSITION AT DIFFRACTION (RESULT)
C   RR   - SQUARE OF X0L                                        (RESULT)
C  RHOQ  - SQUARE OF DISTANCE OF X0L TO SPINDLE AXIS            (RESULT)
C   IER  - RESULT INDICATOR   0: O.K.     -1:BLIND REFLECTION   (RESULT)
C
C***********************************************************************
      INTEGER    I,IER
      REAL       EG(3,3),S0L(3),S0G(3),X0L(3),X0G(3),XL(3),XG(3),SL(3),
     @           CPHI,SPHI,CPHIC,SPHIC,RR,RHOQ
C
C
C
C
      IER=-1
      IF (S0G(3).EQ.0.0)GO TO 30
C
C----  get goniostat coordinates of reflection at phi=0
C
      DO 10 I=1,3
10    X0G(I)=EG(1,I)*X0L(1)+EG(2,I)*X0L(2)+EG(3,I)*X0L(3)
C
C----  get goniostat coordinates of reflection at diffraction
C
      RR=X0L(1)**2+X0L(2)**2+X0L(3)**2
      RHOQ=RR-X0G(2)**2
      XG(3)=-(RR*0.5+X0G(2)*S0G(2))/S0G(3)
      XG(2)=X0G(2)
      XG(1)=RHOQ-XG(3)**2
      IF (XG(1).LE.0.0)GO TO 30
      XG(1)=SQRT(XG(1))
      IF ((X0G(1)*CPHI+X0G(3)*SPHI).LT.0.0)XG(1)=-XG(1)
C
C----  calculate sin/cos of spindle position at diffraction
C
      CPHIC=(XG(1)*X0G(1)+XG(3)*X0G(3))/RHOQ
      SPHIC=(XG(1)*X0G(3)-XG(3)*X0G(1))/RHOQ
      DO 20 I=1,3
C
C----  get laboratory coordinates of reflection at diffraction
C
      XL(I)=EG(I,1)*XG(1)+EG(I,2)*XG(2)+EG(I,3)*XG(3)
C
C----  get laboratory coordinates of diffracted beam wavevector
C
20    SL(I)=S0L(I)+XL(I)
C
C----  return
C
      IER=0
30    RETURN
      END
C
C
C
C     ================================================
      SUBROUTINE RFCROSS(A,ASTT,BSTT,CSTT,VOLUME,WLAMDA)
C     ================================================
      IMPLICIT NONE
C
C
C---- To calculate C = A cross B
C
C
C
C     .. Scalar Arguments ..
      REAL VOLUME,WLAMDA
C     ..
C     .. Array Arguments ..
      REAL A(3,3),ASTT(3),BSTT(3),CSTT(3)
C     ..     
CAL      SAVE                         
C
C
      ASTT(1) = ( A(2,2)*A(3,3) - A(2,3)*A(3,2) ) *WLAMDA*VOLUME
      ASTT(2) = ( A(2,3)*A(3,1) - A(2,1)*A(3,3) ) *WLAMDA*VOLUME
      ASTT(3) = ( A(2,1)*A(3,2) - A(2,2)*A(3,1) ) *WLAMDA*VOLUME
      BSTT(1) = ( A(3,2)*A(1,3) - A(3,3)*A(1,2) ) *WLAMDA*VOLUME
      BSTT(2) = ( A(3,3)*A(1,1) - A(3,1)*A(1,3) ) *WLAMDA*VOLUME
      BSTT(3) = ( A(3,1)*A(1,2) - A(3,2)*A(1,1) ) *WLAMDA*VOLUME
      CSTT(1) = ( A(1,2)*A(2,3) - A(1,3)*A(2,2) ) *WLAMDA*VOLUME
      CSTT(2) = ( A(1,3)*A(2,1) - A(1,1)*A(2,3) ) *WLAMDA*VOLUME
      CSTT(3) = ( A(1,1)*A(2,2) - A(1,2)*A(2,1) ) *WLAMDA*VOLUME
C
C
      END
C
C
C
C     ========================
      SUBROUTINE RFMATMUL(A,B,C)
C     ========================
      IMPLICIT NONE
C
C
      REAL    A(3,3),B(3,3),C(3,3)
      INTEGER I,J
C
C
      DO 1 I=1,3
      DO 1 J=1,3
1     C(I,J)=A(I,1)*B(1,J)+A(I,2)*B(2,J)+A(I,3)*B(3,J)
      RETURN
      END
C
C
C
C     =============================
      SUBROUTINE RFPXTOMM(Q,F,ED,QED)
C     =============================
      IMPLICIT NONE
C
C
C
      INTEGER    I
      REAL       ED(3,3),QED(3,3),Q,F
      DO 10 I=1,3
      QED(I,1)=Q*ED(I,1)
      QED(I,2)=Q*ED(I,2)
10    QED(I,3)=F*ED(I,3)
      RETURN
      END
C
C
C
C     ========================================
      SUBROUTINE RFROTMAT(ACHSE,CPHI,SPHI,V,IER)
C     ========================================
      IMPLICIT NONE
C
C
C
C----   calculate rotation matrix from given rotation axis and angle
C
C
C
      INTEGER    IER,I,J
      REAL       V(3,3),ACHSE(3),U(3),CPHI,SPHI,R
C
C
C
C
      IER=-1
      R=ACHSE(1)**2+ACHSE(2)**2+ACHSE(3)**2
      IF (R.LE.0.0)RETURN
      R =SQRT(R)
      DO 10 I=1,3
10    U(I)=ACHSE(I)/R
      DO 30 I=1,3
      DO 20 J=1,3
20    V(I,J)=U(I)*U(J)*(1.0-CPHI)
30    V(I,I)=V(I,I)+CPHI
      V(3,2)=V(3,2)+U(1)*SPHI
      V(2,3)=V(2,3)-U(1)*SPHI
      V(1,3)=V(1,3)+U(2)*SPHI
      V(3,1)=V(3,1)-U(2)*SPHI
      V(2,1)=V(2,1)+U(3)*SPHI
      V(1,2)=V(1,2)-U(3)*SPHI
      IER=0
      RETURN
      END
C
C
C
C     ==========================
      SUBROUTINE RFSETMAT(RCELL,A)
C     ==========================
      IMPLICIT NONE
C
C
C
C----  calculate setting matrix from reciprocal unit cell.
C
C RCELL  - RECIPROCAL UNIT CELL PARAMETERS                       (GIVEN)
C          IN RECIPROCAL ANGSTROEM AND DEGREES.
C   A    - SETTING MATRIX IN STANDARD ORIENTATION               (RESULT)
C
C
C
C
C
      INTEGER I
      REAL    RCELL(6),A(3,3),RC(3),RS(3),ARG
      DO 10 I=1,3
      ARG=RCELL(I+3)/57.29578
      RC(I)=COS(ARG)
10    RS(I)=SIN(ARG)
      A(1,1)=RCELL(1)*RS(2)
      A(1,2)=RCELL(2)*(RC(3)-RC(1)*RC(2))/RS(2)
      A(1,3)=0.0
      A(2,1)=0.0
      A(2,2)=SQRT((RCELL(2)*RS(1))**2-A(1,2)**2)
      A(2,3)=0.0
      A(3,1)=RCELL(1)*RC(2)
      A(3,2)=RCELL(2)*RC(1)
      A(3,3)=RCELL(3)
      RETURN
      END
C
C
C
C
C     =================================
      SUBROUTINE RTUMAT(ASTV,BSTV,CSTV)
C     =================================
      IMPLICIT NONE
C
C
C       Given the setting matrix found by auto-indexing, this routine
C       operates the point group matrices on it to find the one which
C       gives the smallest misetting angles which respect to a defined
C       U matrix.
C
C        The routine DCOSFD is used to work out the unit vector defining
C       the axis of rotation and the angle. If we find such vectors for
C       each matrix, the test matrix which gives the largest dot product
C       with the axis of the target matrix  should have the most similar
C       rotation axis. But there may be an ambiguity about its sense.
C       This can be resolved by finding the matrix with the most
C       similar angle of  rotation about the axis.
C
C
C       NOTES ON ROBUSTNESS:
C     We often find two solutions with dot product of the axis vectors
C    which are identical. But because of rounding errors in REAL*4
C    representation these errors are compounded over the matrix operations
C    and conspire to reduce the identity of these products. Here we allow
C    a tolerance to the fourth decimal place. For added robustness RFMATMUL
C    and INVERS should be double precision. At present single precision
C    seems adequate but in certain unforseen circumstances the wrong
C    solution may be chosen. Either reduce 1E-4 below or use double
C    precision routines from the NAG library.PMcL
C
C
C----  External subroutines required
C
C
C       DECOMP,INVERS,RFMATMUL,MATCOP,LAUSEY,RTOMISSET,DCOSFD,UNORM
C
C
C
C
cc        IMPLICIT NONE
C     .. Array Arguments ..
      REAL ASTV(3),BSTV(3),CSTV(3)
C     ..
C     .. Scalars in Common ..
      REAL CCOM,CCX,CCY,DPHI,F,FLAMDA,ORGX,ORGY,Q,THRESH,DXY
      INTEGER FIXF,IGROUP
      LOGICAL DCOMP,FILM,LCAMC,TARGET
      INTEGER LP,LINOUT
      LOGICAL ONLINE
C     ..
C     .. Arrays in Common ..
      REAL ACHSE,CELL,ED,S0,TARMAT
C     ..
C     .. Local Scalars ..
      DOUBLE PRECISION BEST,PROD
      REAL BESTA,D,TEST,TRACE,TRACEU
      INTEGER IBEST,IER,J,J1,K,K1,K2,NEQ
C     ..
C     .. Local Arrays ..
      REAL AMAT(3,3),ANG(3,24),BINV(3,3),BMAT(3,3),DUM(3,3),EUTAR(3),
     +     EUTEST(3),I(3,3),L(3,3),LBINV(3,3),LINV(3,3),LUINV(3,3),
     +     PHI(3),RMAT(3,3),UINV(3,3),UMAT(3,3),UTAR(3,3),UTEST(3,3)
      INTEGER MLAUE(432)
C     ..
C     .. External Subroutines ..
      EXTERNAL DCOSFD,DECOMP,INVERS,LAUESY,MATCOP,RFMATMUL,RTOMISSET,
     +         UNORM
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS
C     ..
C     .. Common blocks ..
      COMMON /REFCOM/IGROUP,FLAMDA,CELL(6),F,THRESH,Q,DPHI,ED(3,3),
     +       ACHSE(3),S0(3),ORGX,ORGY,FIXF,TARMAT(3,3),TARGET,DCOMP,
     +       LCAMC,CCX,CCY,CCOM,FILM,DXY,FIXCELL
      LOGICAL FIXCELL
      COMMON /RINOUT/ ONLINE,LP,LINOUT
C     ..
      SAVE
C     .. Data statements ..
C
C
      DATA I/1,0,0,0,1,0,0,0,1/
      DATA MLAUE/432*0/
      DATA BEST/1.0E-12/
C     ..
C
C
C
C
C---- Make BEST negative, as in P21 both solutions can have -ve dot product
C     so no solution is chosen !
C
CAL      BEST = 1.0E-12
      BEST = -999.0
C
      DO 10 K = 1,3
        AMAT(K,1) = ASTV(K)
        AMAT(K,2) = BSTV(K)
        AMAT(K,3) = CSTV(K)
   10 CONTINUE
C
C---- DECOMP decomposes AMAT into UMAT*BMAT
C
C          **********************
      CALL DECOMP(AMAT,UMAT,BMAT)
C          **********************
C
C---- If the target matrix was given as an A MATRIX
C     then decompose it to get UTAR
C
      IF (DCOMP) THEN
C
C            ***********************
        CALL DECOMP(TARMAT,UTAR,DUM)
C            ***********************
C
CAL        IF (ONLINE) WRITE (LP,FMT=6000) ((UTAR(K,J),J=1,3),K=1,3)
CAL 6000   FORMAT('U-MATRIX DERIVED FROM INPUT A-MATRIX',/,
CAL     +   3(1X,3F10.5,/))
CAL        WRITE (LINOUT,FMT=6000) ((UTAR(K,J),J=1,3),K=1,3)
      ELSE 
C 
C            *******************
        CALL MATCOP(TARMAT,UTAR)
C            *******************
C
      END IF
C
C          *******************
      CALL MATCOP(UTAR,TARMAT)
      CALL INVERS(UTAR,UINV,D)
      CALL INVERS(BMAT,BINV,D)
C          *******************
C
C---- Get unit vector along axis of rotation (EUTAR) and
C     angle of rotation about that axis (TRACEU) from the
C     target setting matrix UTAR
C
C          *************************
      CALL DCOSFD(UTAR,EUTAR,TRACEU)
C          *************************
C
C---- Read Permutation Matrices for the Point Group
C
C          *****************************
      CALL LAUESY(CELL,IGROUP,NEQ,MLAUE)
C          ******************************
C
C---- Main loop over the point group matrices
C
      J1 = 0
CAL      WRITE (LINOUT,FMT=6030)
CAL 6030 FORMAT(//,1X,
CAL     +     'LAUE OPERATOR    PHIX    PHIY    PHIZ')
CAL      IF (ONLINE) WRITE (LP,FMT=6030)
C
C
      DO 50 K = 1,NEQ
C
C---- Gather point group matrix number K into L(3,3)
C
        DO 30 K1 = 1,3
          DO 20 K2 = 1,3
            J1 = J1 + 1
            L(K2,K1) = MLAUE(J1)
   20     CONTINUE
   30   CONTINUE
C
C---- Calculate the UMAT given this point group matrix.
C
C            ********************
        CALL INVERS(L,LINV,D)
        CALL RFMATMUL(L,UINV,LUINV)
        CALL RFMATMUL(UMAT,LUINV,RMAT)
        CALL RTOMISSET(RMAT,PHI,1)
        CALL RFMATMUL(L,BINV,LBINV)
        CALL RFMATMUL(AMAT,LBINV,UTEST)
C            ************************
C
C---- Renormalise UTEST to reduce errors built up by matrix
C      concatenation.
C
C            ****************
        CALL UNORM(UTEST,IER)
C            ****************
C
C---- Calculate how similar this UMAT  is to the target matrix.
C
C     Get unit vector along axis of rotation for the candidate
C     matrix and the angle of rotation about this axis
C
C            *************************
        CALL DCOSFD(UTEST,EUTEST,TRACE)
C            **************************
C
        TEST = ABS(TRACE-TRACEU)
C
C
        PROD = EUTEST(1)*EUTAR(1) + EUTEST(2)*EUTAR(2) +
     +         EUTEST(3)*EUTAR(3)
C
C---- If the dot product of the axis vectors are larger than the
C     best so far, make the current the best. If they are similar
C     to the fourth decimal place, then take the one describing
C     the smaller angle of rotation
C
C---- Following code changed 9/5/95, previous version would not work
C     correctly in some circumstances (eg p21)
C
        IF (DABS(PROD-BEST).GT.1.0E-4) THEN
C
C---- This is a different solution
C
          IF (PROD.GT.BEST) THEN
            BESTA = TEST
            BEST = PROD
            IBEST = K
          END IF
C
        ELSE
C
C---- This is a similar solution
C
          IF (TEST.LT.BESTA) THEN
            BESTA = TEST
            BEST = PROD
            IBEST = K
          END IF
        END IF
cal   Following is original code
cal     IF ((PROD-BEST).GT.1.0E-4) THEN
cal       BESTA = ABS(TEST)
cal       BEST = DABS(PROD)
cal       IBEST = K
cal     ELSE IF (DABS(PROD-BEST).LE.1.0E-4 .AND.
cal  +           DABS(PROD-BEST).GT.0.0) THEN
cal       IF (TEST.LT.BESTA) THEN
cal         BESTA = ABS(TEST)
cal         BEST = DABS(PROD)
cal         IBEST = K
cal       END IF
cal     END IF
C
C
        DO 40 K1 = 1,3
          ANG(K1,K) = PHI(K1)
   40   CONTINUE
C
C
CAL        WRITE (LINOUT,FMT='(10X,I2,2x,3(f8.2),/)') 
CAL   +                     K,PHI
CAL      IF (ONLINE) WRITE (LP,FMT='(10X,I2,2x,3(f8.2),/)') K,PHI
C
CAL      WRITE (LINOUT,fmt=6010) IBEST,K,((RMAT(K1,J),J=1,3),K1=1,3) 
CAL      IF (ONLINE) WRITE(LP,fmt=6010) IBEST,K,
CAL   +        ((RMAT(K1,J),J=1,3),K1=1,3)
C 6010   FORMAT(1X,'IBEST,K ', 2I5,'  RMAT IS',/,3(1X,3F10.4,/))
   50 CONTINUE
C
C---- End of Main Loop
C
C---- Now operate the IBEST Laue group matrix on the
C     input A matrix
C
      J1 = (IBEST-1)*9
C
C
      DO 70 K1 = 1,3
        DO 60 K2 = 1,3
          J1 = J1 + 1
          L(K2,K1) = MLAUE(J1)
   60   CONTINUE
   70 CONTINUE
C
C          ******************
      CALL RFMATMUL(AMAT,L,DUM)
C          ******************
C
      DO 80 K = 1,3
        ASTV(K) = DUM(K,1)
        BSTV(K) = DUM(K,2)
        CSTV(K) = DUM(K,3)
   80 CONTINUE
C
C
      END
C
C
C
C
C     ============================================
      SUBROUTINE U3BEST(W,X,Y,N,MODE,RMS,U,T,IER)
C     ============================================
      IMPLICIT NONE
C
C
C
C---- calculates a best rotation & translation between two vector sets
C      such that u*x+t is the closest approximation to y.
C      the calculated best superposition may not be unique as indicated
C      by a result value ier=-1. however it is garantied that within
C      numerical tolerances no other superposition exists giving a
C      smaller value for rms.
C
C---- this version of the algorithm is optimized for three-dimensional
C      real vector space.
C
C**** USE OF THIS ROUTINE IS RESTRICTED TO NON-PROFIT ACADEMIC
C**** APPLICATIONS.
C**** PLEASE REPORT ERRORS TO
C**** PROGRAMMER:  W.KABSCH  MAX-PLANCK-INSTITUTE FOR MEDICAL RESEARCH
C                            JAHNSTRASSE 29, 6900 HEIDELBERG, FRG.
C**** REFERENCES:  W.KABSCH  ACTA CRYST.(1978).A34,827-828
C                  W.KABSCH  ACTA CRYST.(1976).A32,922-923
C
C  W     - W(M) IS WEIGHT FOR ATOM PAIR  # M                     (GIVEN)
C  X     - X(I,M) ARE COORDINATES OF ATOM # M IN SET X           (GIVEN)
C  Y     - Y(I,M) ARE COORDINATES OF ATOM # M IN SET Y           (GIVEN)
C  N     - N IS NUMBER OF ATOM PAIRS                             (GIVEN)
C  MODE  - 0:CALCULATE RMS ONLY                                  (GIVEN)
C          1:CALCULATE RMS,U,T   (TAKES LONGER)
C          2:CALCULATE RMS,U,T=0 (TAKES LONGER)
C  RMS   - SUM OF W*(UX+T-Y)**2 OVER ALL ATOM PAIRS             (RESULT)
C  U     - U(I,J) IS   ROTATION  MATRIX FOR BEST SUPERPOSITION  (RESULT)
C  T     - T(I)   IS TRANSLATION VECTOR FOR BEST SUPERPOSITION  (RESULT)
C  IER   - 0: A UNIQUE OPTIMAL SUPERPOSITION HAS BEEN DETERMINED(RESULT)
C         -1: SUPERPOSITION IS NOT UNIQUE BUT OPTIMAL
C         -2: NO RESULT OBTAINED BECAUSE OF NEGATIVE WEIGHTS W
C             OR ALL WEIGHTS EQUAL TO ZERO.
C
C
C
C
C
      INTEGER    IP(9),IP2312(4),I,J,K,L,M1,M,IER,N,MODE
      REAL       W(*),X(3,*),Y(3,*),U(3,3),T(3),RMS,SIGMA
      REAL*8     R(3,3),XC(3),YC(3),WC,A(3,3),B(3,3),E0,
     1 E(3),E1,E2,E3,D,SPUR,DET,COF,H,G,CTH,STH,SQRTH,P,TOL,
     2 RR(6),RR1,RR2,RR3,RR4,RR5,RR6,SS(6),SS1,SS2,SS3,SS4,SS5,SS6,
     3 ZERO,ONE,TWO,THREE,SQRT3
      EQUIVALENCE (RR1,RR(1)),(RR2,RR(2)),(RR3,RR(3)),
     1            (RR4,RR(4)),(RR5,RR(5)),(RR6,RR(6)),
     2            (SS1,SS(1)),(SS2,SS(2)),(SS3,SS(3)),
     3            (SS4,SS(4)),(SS5,SS(5)),(SS6,SS(6)),
     4            (E1,E(1)),(E2,E(2)),(E3,E(3))
      DATA SQRT3,TOL/1.73205080756888D+00, 1.0D-2/
      DATA ZERO,ONE,TWO,THREE/0.0D+00, 1.0D+00, 2.0D+00, 3.0D+00/
      DATA IP/1,2,4,  2,3,5,  4,5,6/
      DATA IP2312/2,3,1,2/
      WC=ZERO
      RMS=0.0
      E0=ZERO
      DO 1 I=1,3
      E(I)=ONE
      XC(I)=ZERO
      YC(I)=ZERO
      T(I)=0.0
      DO 1 J=1,3
      D=ZERO
      IF (I.EQ.J)D=ONE
      U(I,J)=D
      A(I,J)=D
1     R(I,J)=ZERO
      IER=-1
      IF (N.LT.1)RETURN
      IF (MODE.EQ.2)GO TO 4
C
C----  determine centroids of both vector sets x and y
C
      IER=-2
      DO 2 M=1,N
      IF (W(M).LT.0.0)RETURN
      WC=WC+W(M)
      DO 2 I=1,3
      XC(I)=XC(I)+W(M)*X(I,M)
2     YC(I)=YC(I)+W(M)*Y(I,M)
      IF (WC.LE.ZERO)RETURN
      DO 3 I=1,3
      XC(I)=XC(I)/WC
3     YC(I)=YC(I)/WC
C
C----  determine correlation matrix r between vector sets y and x
C
4     DO 6 M=1,N
      DO 6 I=1,3
      E0=E0+W(M)*((X(I,M)-XC(I))**2+(Y(I,M)-YC(I))**2)
      D=W(M)*(Y(I,M)-YC(I))
      DO 6 J=1,3
6     R(I,J)=R(I,J)+D*(X(J,M)-XC(J))
C
C----  calculate determinant of r(i,j)
C
      SIGMA=R(1,1)*(R(2,2)*R(3,3)-R(2,3)*R(3,2))
     1     -R(1,2)*(R(2,1)*R(3,3)-R(2,3)*R(3,1))
     2     +R(1,3)*(R(2,1)*R(3,2)-R(2,2)*R(3,1))
C
C----  form upper triangle of transposed(r)*r
C
      M=0
      DO 7 J=1,3
      DO 7 I=1,J
      M=M+1
7     RR(M)=R(1,I)*R(1,J)+R(2,I)*R(2,J)+R(3,I)*R(3,J)
C
C----  rescale matrix such that the sum of the new main diagonal
C      elements becomes 3.
C
      SPUR=(RR1+RR3+RR6)/THREE
      IF (SPUR.LE.ZERO)GO TO 40
      DO 8 M=1,6
8     RR(M)=RR(M)/SPUR
C
C----  eigenvalues 
C
C
C      form characteristic cubic  x**3-3*x**2+3*cof*x-det=0
C
C
      COF=(RR3*RR6-RR5*RR5+RR1*RR6-RR4*RR4+RR1*RR3-RR2*RR2)/THREE
      DET=RR1*(RR3*RR6-RR5*RR5)-RR2*(RR2*RR6-RR5*RR4)
     @   +RR4*(RR2*RR5-RR3*RR4)
C
C---- reduce cubic to standard form y**3-3hy+2g=0 by putting x=y+one
C
      H=ONE-COF
      G=(COF-DET)/TWO-H
C
C----  solve cubic. roots are e1,e2,e3 in decreasing order
C
      IF (H.LE.ZERO)GO TO 9
      SQRTH=DSQRT(H)
      D=G/(H*SQRTH)
      P=(ONE-D)*(ONE+D)
      IF (P.LT.ZERO)THEN
	 P=ZERO
      ELSE
	 P=DSQRT(P)
      ENDIF
      D=DATAN2(P,-D)/THREE
      CTH=SQRTH*DCOS(D)
      STH=SQRTH*SQRT3*DSIN(D)
      E1=ONE+CTH+CTH
      E2=ONE-CTH+STH
      E3=ONE-CTH-STH
      IF (MODE)10,50,10
C
C---- handle special case of 3 identical roots
C
9     IF (MODE)30,50,30
C
C----  eigenvectors 
C
10    DO 15 L=1,3,2
      D=E(L)
      SS1=(D-RR3)*(D-RR6)-RR5*RR5
      SS2=(D-RR6)*RR2+RR4*RR5
      SS3=(D-RR1)*(D-RR6)-RR4*RR4
      SS4=(D-RR3)*RR4+RR2*RR5
      SS5=(D-RR1)*RR5+RR2*RR4
      SS6=(D-RR1)*(D-RR3)-RR2*RR2
      J=1
      IF (DABS(SS1).GE.DABS(SS3))GO TO 12
      J=2
      IF (DABS(SS3).GE.DABS(SS6))GO TO 13
11    J=3
      GO TO 13
12    IF (DABS(SS1).LT.DABS(SS6))GO TO 11
13    D=ZERO
      J=3*(J-1)
      DO 14 I=1,3
      K=IP(I+J)
      A(I,L)=SS(K)
14    D=D+SS(K)*SS(K)
      IF (D.GT.ZERO)D=ONE/DSQRT(D)
      DO 15 I=1,3
15    A(I,L)=A(I,L)*D
      D=A(1,1)*A(1,3)+A(2,1)*A(2,3)+A(3,1)*A(3,3)
      M1=3
      M=1
      IF ((E1-E2).GT.(E2-E3))GO TO 16
      M1=1
      M=3
16    P=ZERO
      DO 17 I=1,3
      A(I,M1)=A(I,M1)-D*A(I,M)
17    P=P+A(I,M1)**2
      IF (P.LE.TOL)GO TO 19
      P=ONE/DSQRT(P)
      DO 18 I=1,3
18    A(I,M1)=A(I,M1)*P
      GO TO 21
19    P=ONE
      DO 20 I=1,3
      IF (P.LT.DABS(A(I,M)))GO TO 20
      P=DABS(A(I,M))
      J=I
20    CONTINUE
      K=IP2312(J)
      L=IP2312(J+1)
      P=DSQRT(A(K,M)**2+A(L,M)**2)
      IF (P.LE.TOL)GO TO 40
      A(J,M1)=ZERO
      A(K,M1)=-A(L,M)/P
      A(L,M1)= A(K,M)/P
21    A(1,2)=A(2,3)*A(3,1)-A(2,1)*A(3,3)
      A(2,2)=A(3,3)*A(1,1)-A(3,1)*A(1,3)
      A(3,2)=A(1,3)*A(2,1)-A(1,1)*A(2,3)
C
C---- rotation matrix 
C
30    DO 32 L=1,2
      D=ZERO
      DO 31 I=1,3
      B(I,L)=R(I,1)*A(1,L)+R(I,2)*A(2,L)+R(I,3)*A(3,L)
31    D=D+B(I,L)**2
      IF (D.GT.ZERO)D=ONE/DSQRT(D)
      DO 32 I=1,3
32    B(I,L)=B(I,L)*D
      D=B(1,1)*B(1,2)+B(2,1)*B(2,2)+B(3,1)*B(3,2)
      P=ZERO
      DO 33 I=1,3
      B(I,2)=B(I,2)-D*B(I,1)
33    P=P+B(I,2)**2
      IF (P.LE.TOL)GO TO 35
      P=ONE/DSQRT(P)
      DO 34 I=1,3
34    B(I,2)=B(I,2)*P
      GO TO 37
35    P=ONE
      DO 36 I=1,3
      IF (P.LT.DABS(B(I,1)))GO TO 36
      P=DABS(B(I,1))
      J=I
36    CONTINUE
      K=IP2312(J)
      L=IP2312(J+1)
      P=DSQRT(B(K,1)**2+B(L,1)**2)
      IF (P.LE.TOL)GO TO 40
      B(J,2)=ZERO
      B(K,2)=-B(L,1)/P
      B(L,2)= B(K,1)/P
37    B(1,3)=B(2,1)*B(3,2)-B(2,2)*B(3,1)
      B(2,3)=B(3,1)*B(1,2)-B(3,2)*B(1,1)
      B(3,3)=B(1,1)*B(2,2)-B(1,2)*B(2,1)
      DO 39 I=1,3
      DO 39 J=1,3
39    U(I,J)=B(I,1)*A(J,1)+B(I,2)*A(J,2)+B(I,3)*A(J,3)
C
C----  translation vector 
C
40    DO 41 I=1,3
41    T(I)=YC(I)-U(I,1)*XC(1)-U(I,2)*XC(2)-U(I,3)*XC(3)
C
C----  rms error
C
50    DO 51 I=1,3
      D=E(I)*SPUR
      IF (D.LT.ZERO)D=ZERO
51    E(I)=DSQRT(D)
      IER=0
      IF (E2.LE.(E1*1.0D-05))IER=-1
      D=E3
      IF (SIGMA.GE.0.0)GO TO 52
      D=-D
      IF ((E2-E3).LE.(E1*1.0D-05))IER=-1
52    D=D+E2+E1
      RMS=E0-D-D
      IF (RMS.LT.0.0)RMS=0.0
      RETURN
      END
C
C
C
C
      SUBROUTINE UNORM(U,IER)
      IMPLICIT NONE
C
C----  normalize matrix u(3,3) to orthogonal form
C
C
      INTEGER    IER,J
      REAL       U(3,3),P,Q
      IER=-1
      P=U(1,2)**2+U(2,2)**2+U(3,2)**2
      Q=U(1,2)*U(1,3)+U(2,2)*U(2,3)+U(3,2)*U(3,3)
      DO 1 J=1,3
1     U(J,3)=U(J,3)*P-U(J,2)*Q
      Q=SQRT(U(1,3)**2+U(2,3)**2+U(3,3)**2)
      IF (Q.LT.0.000001)GO TO 3
      P=SQRT(P)
      DO 2 J=1,3
      U(J,2)=U(J,2)/P
2     U(J,3)=U(J,3)/Q
      U(1,1)=U(2,2)*U(3,3)-U(2,3)*U(3,2)
      U(2,1)=U(3,2)*U(1,3)-U(3,3)*U(1,2)
      U(3,1)=U(1,2)*U(2,3)-U(1,3)*U(2,2)
      IER=0
3     RETURN
      END
C
C
C
C      =========================================
       SUBROUTINE WIDX(MAXIDX,ERRINT,FHKL,MHKL,W)
C      =========================================
      IMPLICIT NONE
C
C
C
C
C
C  MAXIDX -  the maximum absolute value of an index assigned to  (given)
C            any grid point.
C  ERRINT -  tolerance value for grid indices deviating          (given)
C            from integral values.
C  FHKL   -  real array(3) of grid indices                       (given)
C  MHKL   -  integer array(3) of grid indices                   (result)
C    W    -  weight (reliability) of grid indices               (result)
C
C
      INTEGER    MHKL(3),MAXIDX,I,L
      REAL       FHKL(3),ERRINT,W,D
C
C----  find indices and weights for this grid point
C
      W=0.0
      DO 10 L=1,3
      D=FHKL(L)
      I=NINT(D)
      MHKL(L)=I
      D=ABS(D-I)-ERRINT
      IF (D.GT.0.0)W=W+(D/ERRINT)**2
      D=ABS(I)-MAXIDX
      IF (D.GT.0.0)W=W+D**2
10    CONTINUE
      IF (W.EQ.0.0)GO TO 30
      IF (W.GT.6.9)GO TO 20
      W=EXP(-2.0*W)
      RETURN
20    W=0.0
      RETURN
30    W=1.0
      RETURN
      END
