c     add_spots.f
c     maintained by G.Winter
c     27th November 2002
c     
c     A subroutine to allow the positions of spots to be inputted 
c     so that the spot list can be edited at the GUI end.
c     
c     
c     
c     
c     
c     
c     
c     
c     $Id: add_spots.f,v 1.2 2002/11/27 14:34:46 graeme Exp $
c     

      subroutine add_spots(argc, argv, types, values)

      implicit none

C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C&&*&& include  ../inc/gui.f
c     gui.h
c     maintained by G.Winter
c     16th April 2002
c     $Id: gui.f,v 1.16 2003/04/04 14:22:01 harry Exp $
c     
c     This defines the variables and common blocks which are used by the
c     new gui control routine. This will also be used in xdisp and control,
c     to switch the new gui on!
c     
c     

      logical gui_switch, refine_cell(6), refine_detector(11),
     +     autocomplete, autoreturn, newmatstore
      integer nargs
      integer imageno, nstart
      parameter (nargs = 200)

c     refine_detector logical block index:
c     1: beam x 2: beam y 3: ccomega 4: yscale
c     5: distance 6: tilt 7: twist 8: roff 9: toff
c     
c     refine_cell logical block index:
c     1: a 2: b 3: c
c     4: alpha 5: beta 6: gamma
c     
c     
c     

      integer keep_phi_segments, keep_phi_start(20), 
     +     keep_phi_end(20)

      real storemeanmult

      common /gui/ gui_switch, imageno, refine_cell, refine_detector,
     +     autocomplete, nstart, autoreturn, newmatstore

      common /keep_phi/ keep_phi_segments, keep_phi_start, 
     +     keep_phi_end, storemeanmult


c     refine_cell(i) is true if you wish to refine cell(i)
C&&*&& end_include  ../inc/gui.f
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C&&*&& include  ../inc/spots.f
C
C $Id: spots.f,v 1.1 2002/05/02 10:47:18 harry Exp $
C
C--- awk generated include file  spots.h
C---- START of include file spots.h
C
C     XSPT,YSPT,ISPT store spot coordinates (in mm) and intensity
C
C     These arrays hold the complete list of spots found on ALL images.
C     Pointers to the first and last spot in each image are kept in arrays
C
C     XSPT....  X coordinates (in mm) of spots in total spot list for
C               all images.
C
C     YSPT....  Y coordinates (in mm) of spots in total spot list for
C               all images.
C
C     ISPT....  Intensity of spots in total spot list for
C               all images.
C
C     ISDSPT..  Standard deviations of intensities
C
C     INDX...   Stores a pointer into arrays XSPT,YSPT,ISPT for the I'th
C               displayed spot (only spots above current threshold are
C               displayed).
C
C     ISTIMG(IMAG)...  Pointer to first spot for image IMAG in arrays
C                      XSPT,YSPT,ISPT
C     IENDIMG(IMAG)...  Pointer to last spot for image IMAG in arrays
C                      XSPT,YSPT,ISPT
C
C     IXSPT,IYSPT...   Spot coordinates in display pixels for current image
C     SELECT....       True for images selected for autoindexing
C     SPOTFND....      True for images on which spots have been found
C     ITHRESH          I/sig(I) threshold for spots to be used in autoindexing
C
C     .. Scalars in Common Block /SPOTS/ ..
        REAL XF,YF,XFID1,YFID1,XFID2,YFID2,XFID3,YFID3,PHIIMG,
     +       LPIXEL,LYSCALE,LOMEGA,LXCEN,LYCEN
        INTEGER NSPT,ISPOT,ITHRESH,IRSCAL,LIXLEN,LIYLEN,INVFLAG,
     +       LISWUNG
        CHARACTER*100 SPTNAM,NSPTNAM

C     ..
C     .. Arrays in common /SPOTS/ ..
        REAL XSPT(NSPOTS),YSPT(NSPOTS)
        INTEGER ISPT(NSPOTS),IXSPT(NSPOTS),IYSPT(NSPOTS),
     +          ISTIMG(MAXIMG),IENDIMG(MAXIMG),ISDSPT(NSPOTS)
        INTEGER*2 INDX(NSPOTS)
        LOGICAL SELECT(MAXIMG),SPOTFND(MAXIMG)
C     ..
C     .. Common Block /SPOTS/ ..
        COMMON /SPOTS/ XF,YF,XFID1,YFID1,XFID2,YFID2,XFID3,YFID3,
     +                 XSPT,YSPT,ISPT,IXSPT,IYSPT,INDX,ISPOT,NSPT,
     +                 ITHRESH,PHIIMG,IRSCAL,LPIXEL,LYSCALE,LOMEGA,
     +                 LIXLEN,LIYLEN,LXCEN,LYCEN,INVFLAG,LISWUNG,
     +                 ISTIMG,IENDIMG,SELECT,ISDSPT,SPOTFND
C
        COMMON /CSPOTS/ SPTNAM,NSPTNAM

C&&*&& end_include  ../inc/spots.f
C&&*&& include  ../inc/spots2.f
C
C $Id: spots2.f,v 1.3 2003/11/10 13:16:25 harry Exp $
C
C--- awk generated include file  spots.h
C---- START of include file spots.h
C
C---- These stores variables associated with spot-finding routines.
C     Note that the final coordinates are kept in XSPT,YSPT in /SPOTS/
C
C     XSPOT...  X coordinates (in mm) of all spots found on current
C               image, before rejections based on spot size
C     YSPOT...  Y coordinates (in mm) of all spots found on current
C               image, before rejections based on spot size
C     INSPOT... Intensities of all spots found on current
C               image, before rejections based on spot size
C     ISIGSP... Standard deviations of intensities
C     NOIMG     The pack or image number.
C     PHI..     Phi value of the mid-point of the image
C     NIMAG     Total number of images read in (for autoindexing)
C     NEWSPT    If TRUE, new format spot coordinate file, otherwise old
C               format.
C     MEDWXSPOT Median spot size in pixels in X determined in PICKSPOTS
C     MEDWYSPOT Median spot size in pixels in Y determined in PICKSPOTS
C     IRSTRT    Number of the image on which to restart after an abort
C
C     SPXMIN    Minimum X coord (relative to direct beam position) for
C               spots
C     SPYMIN    Minimum Y coord (relative to direct beam position) for
C               spots
C     NSPTD     Number of displayed spots
C     THRESH    Threshold for pixel to be considered part of a spot,
C               is (background + THRESH*sigma)
C
C     .. Scalars in Common Block /SPOTS2/ and /SPOTS2C/ ..
      REAL CUTPIXMAX,CUTPIXMIN,CUTWXMAX,CUTWXMIN,CUTWYMAX,CUTWYMIN,
     +     XSPLIT,YSPLIT,YOFFSET,XOFFSET,THRESH,RMINSP,RMAXSP,
     +     RMINSRCH,RMAXSRCH,SCALSRCH,SPXMIN,SPYMIN,THRESHMIN,
     +     THRESHMAX
      INTEGER NBINR,NBINT,IBINLIM,NPIXMIN,NPIXMAX,IIMAG,NIMAG,
     +     MEDWXSPOT,MEDWYSPOT,NSEARCH,ITHSET,ISAFE,IRSTRT,
     +     NSPTD
      LOGICAL RADX,RADY,NEWSPT,DOFIND,FOUND
      CHARACTER IMGTEMPL*100,IMGFN*100,IMGNUM*6
C     ..
C     .. Arrays in common /SPOTS2/  and /SPOTS2C/ ....
      INTEGER NPIX,IWXSPOT,IWYSPOT,IORDER,INSPOT,NOIMG,ISDSPOT
      REAL BGOD,PHI,XSPOT,YSPOT,RSPOT,PHISTIM,BGODA2
C     ..
C     .. Common Block /SPOTS2/  and /SPOTS2C/ ....
c      COMMON /SPOTS2/XSPLIT,YSPLIT,NBINR,NBINT,
c     +       IBINLIM,PHI(MAXIMG),NPIXMIN,NPIXMAX,CUTPIXMIN,CUTPIXMAX,
c     +       CUTWXMIN,CUTWXMAX,CUTWYMIN,CUTWYMAX,
c     +       BGOD(IXWDTH),YOFFSET,XOFFSET,RADX,RADY,THRESH,IIMAG,NIMAG,
c     +       NPIX(MXSPOT),IWXSPOT(MXSPOT),IWYSPOT(MXSPOT),
c     +       IORDER(MXSPOT),INSPOT(MXSPOT),XSPOT(MXSPOT),
c     +       YSPOT(MXSPOT),RSPOT(MXSPOT),RMINSP,RMAXSP,NOIMG(MAXIMG),
c     +       NEWSPT,DOFIND,ISDSPOT(MXSPOT),MEDWXSPOT,MEDWYSPOT,
c     +       PHISTIM(MAXIMG),RMINSRCH,RMAXSRCH,NSEARCH,SCALSRCH,
c     +       ITHSET,ISAFE,IRSTRT,SPXMIN,SPYMIN,THRESHMIN,THRESHMAX,
c     +       NSPTD
       common /spots2/CUTPIXMAX,CUTPIXMIN,CUTWXMAX,CUTWXMIN,CUTWYMAX,
     +     CUTWYMIN,XSPLIT,YSPLIT,YOFFSET,XOFFSET,THRESH,RMINSP,RMAXSP,
     +     RMINSRCH,RMAXSRCH,SCALSRCH,SPXMIN,SPYMIN,THRESHMIN,
     +     THRESHMAX,NBINR,NBINT,IBINLIM,NPIXMIN,NPIXMAX,IIMAG,NIMAG,
     +     MEDWXSPOT,MEDWYSPOT,NSEARCH,ITHSET,ISAFE,IRSTRT,
     +     NSPTD,RADX,RADY,NEWSPT,DOFIND,FOUND,
     $  NPIX(MXSPOT),IWXSPOT(MXSPOT),IWYSPOT(MXSPOT),
     $  IORDER(MXSPOT),INSPOT(MXSPOT),NOIMG(MAXIMG),ISDSPOT(MXSPOT),
     $  BGOD(IXWDTH),PHI(MAXIMG),XSPOT(MXSPOT),YSPOT(MXSPOT),
     $  RSPOT(MXSPOT),PHISTIM(MAXIMG),BGODA2(21,21,3)

      COMMON /SPOTS2C/ IMGTEMPL,IMGFN,IMGNUM
C&&*&& end_include  ../inc/spots2.f

      integer argc, types(nargs)
      real values(nargs)
      character*80 argv(nargs)

      integer ipx, ipy, i, istat
      integer spot_count

      integer ixspwdth, iyspwdth, ixspbox, iyspbox

      if(argc .eq. 1) then
c     complain that this is insufficient input
         return
      end if

      ixspwdth = medwxspot
      iyspwdth = medwyspot
      ixspbox = 2 * ixspwdth
      iyspbox = 2 * iyspwdth

c     check for an even number of arguments.

      spot_count = (argc - 1) / 2

      if(spot_count * 2 + 1 .ne. argc) then
c     complain
         return
      end if

      do i = 2, argc, 2
         ipx = nint(values(i))
         ipy = nint(values(i + 1))

         call addspot(ipx,ipy,image(istart*iylen+1),
     +        nrec,iylen,ixspwdth,iyspwdth,ixspbox,iyspbox,istat)

c     check istat

      end do

      return
      end
C
C
C
      SUBROUTINE ADDKBB(LINE)
C     =======================
C
c  Add line to keyboard buffer
C
      IMPLICIT NONE
C
      CHARACTER*(*) LINE
C
C&&*&& include  ../inc/mxdkbb.f
C
C $Id: mxdkbb.f,v 1.1 2002/05/02 10:47:00 harry Exp $
C
C--- awk generated include file  mxdkbb.h
C---- START of include file mxdkbb.h
C
c
c**********  mxdkbb  *************
c
c  Keyboard input buffer
c
c     kbdbuf(0:maxkbb-1)       rotating line buffer
c     ip1kbb                   read pointer (= -1 is no lines to read)
c     ip2kbb                   write pointer
c     markbb                   mark point (= -1 if unset)
c
      integer maxkbb
      parameter (maxkbb = 10)
      character*80 kbdbuf(0:maxkbb-1)
      integer ip1kbb, ip2kbb, markbb
c  
      common /kbblin/ kbdbuf
      common /kbbptr/ ip1kbb, ip2kbb, markbb
c
      save /kbblin/, /kbbptr/
c
C&&*&& end_include  ../inc/mxdkbb.f
C
C
      KBDBUF(IP2KBB) = LINE
c  Set pointer to read line if unset
      IF (IP1KBB .LT. 0) THEN
         IP1KBB = IP2KBB
      ELSEIF (IP2KBB .EQ. IP1KBB) THEN
c  Just overwritten next read line, so reset (increment) read pointer
         IP1KBB = MOD(IP1KBB+1,MAXKBB)
      ENDIF
c  Update write pointer
      IP2KBB = MOD(IP2KBB+1, MAXKBB)
C
      RETURN
      END
      SUBROUTINE ADDSPOT(IXP,IYP,IMAGE,NXPIX,NYPIX,
     +                   IXSPWDTH,IYSPWDTH,IXSPBOX,IYSPBOX,ISTAT)
C     ============================================================
C
      IMPLICIT NONE
C
C---- To allow manual addition of spots to the spot list, selected by
C     the mouse cursor.
C
C     IXP,IYP      	Cursor position (image pixels)
C     IMAGE             Image array
C     NXPIX              Size of image array in slow direction
C     NYPIX             Size of image array in fast direction
C     IXSPWDTH          Sise of spot in X direction
C     IYSPWDTH          Sise of spot in Y direction
C     IXSPBOX           Size of box to be extracted in X direction
C     IYSPBOX           Size of box to be extracted in Y direction
C     ISTAT             Error flag -1 if too many spots
C     DEBUG(67)
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C
C     ..
C     .. Scalar Arguments ..
      INTEGER IXP,IYP,NXPIX,NYPIX,IXSPWDTH,IYSPWDTH,IXSPBOX,IYSPBOX,
     +        ISTAT
C
C     ..
C     .. Array Arguments ..
      INTEGER*2 IMAGE(NYPIX,NXPIX)
C     ..
C     .. Local Scalars ..
      INTEGER I,II,J,JJ,IXP2,IYP2,IXST,IXEND,IYST,IYEND,IOD,IHXSP,
     +        IHYSP,IXMIN,IXMAX,IYMIN,IYMAX,IHX,IHY,IXSIZ,IYSIZ,
     +        IMAX,JMAX,IODMAX,MODEDISP,NPREV
      REAL SUM,SUMX,SUMY,XSP,YSP
C     ..
C     .. Local Arrays ..
      INTEGER ISPBOX(MAXDIM,MAXDIM)
C     ..
C     .. External Functions ..
C     ..
C     .. External Subroutines ..
      INTEGER INTPXL
      EXTERNAL INTPXL
C     ..
C     .. Intrinsic Functions ..
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C&&*&& include  ../inc/spots.f
C
C $Id: spots.f,v 1.1 2002/05/02 10:47:18 harry Exp $
C
C--- awk generated include file  spots.h
C---- START of include file spots.h
C
C     XSPT,YSPT,ISPT store spot coordinates (in mm) and intensity
C
C     These arrays hold the complete list of spots found on ALL images.
C     Pointers to the first and last spot in each image are kept in arrays
C
C     XSPT....  X coordinates (in mm) of spots in total spot list for
C               all images.
C
C     YSPT....  Y coordinates (in mm) of spots in total spot list for
C               all images.
C
C     ISPT....  Intensity of spots in total spot list for
C               all images.
C
C     ISDSPT..  Standard deviations of intensities
C
C     INDX...   Stores a pointer into arrays XSPT,YSPT,ISPT for the I'th
C               displayed spot (only spots above current threshold are
C               displayed).
C
C     ISTIMG(IMAG)...  Pointer to first spot for image IMAG in arrays
C                      XSPT,YSPT,ISPT
C     IENDIMG(IMAG)...  Pointer to last spot for image IMAG in arrays
C                      XSPT,YSPT,ISPT
C
C     IXSPT,IYSPT...   Spot coordinates in display pixels for current image
C     SELECT....       True for images selected for autoindexing
C     SPOTFND....      True for images on which spots have been found
C     ITHRESH          I/sig(I) threshold for spots to be used in autoindexing
C
C     .. Scalars in Common Block /SPOTS/ ..
        REAL XF,YF,XFID1,YFID1,XFID2,YFID2,XFID3,YFID3,PHIIMG,
     +       LPIXEL,LYSCALE,LOMEGA,LXCEN,LYCEN
        INTEGER NSPT,ISPOT,ITHRESH,IRSCAL,LIXLEN,LIYLEN,INVFLAG,
     +       LISWUNG
        CHARACTER*100 SPTNAM,NSPTNAM

C     ..
C     .. Arrays in common /SPOTS/ ..
        REAL XSPT(NSPOTS),YSPT(NSPOTS)
        INTEGER ISPT(NSPOTS),IXSPT(NSPOTS),IYSPT(NSPOTS),
     +          ISTIMG(MAXIMG),IENDIMG(MAXIMG),ISDSPT(NSPOTS)
        INTEGER*2 INDX(NSPOTS)
        LOGICAL SELECT(MAXIMG),SPOTFND(MAXIMG)
C     ..
C     .. Common Block /SPOTS/ ..
        COMMON /SPOTS/ XF,YF,XFID1,YFID1,XFID2,YFID2,XFID3,YFID3,
     +                 XSPT,YSPT,ISPT,IXSPT,IYSPT,INDX,ISPOT,NSPT,
     +                 ITHRESH,PHIIMG,IRSCAL,LPIXEL,LYSCALE,LOMEGA,
     +                 LIXLEN,LIYLEN,LXCEN,LYCEN,INVFLAG,LISWUNG,
     +                 ISTIMG,IENDIMG,SELECT,ISDSPT,SPOTFND
C
        COMMON /CSPOTS/ SPTNAM,NSPTNAM

C&&*&& end_include  ../inc/spots.f
C&&*&& include  ../inc/spots2.f
C
C $Id: spots2.f,v 1.3 2003/11/10 13:16:25 harry Exp $
C
C--- awk generated include file  spots.h
C---- START of include file spots.h
C
C---- These stores variables associated with spot-finding routines.
C     Note that the final coordinates are kept in XSPT,YSPT in /SPOTS/
C
C     XSPOT...  X coordinates (in mm) of all spots found on current
C               image, before rejections based on spot size
C     YSPOT...  Y coordinates (in mm) of all spots found on current
C               image, before rejections based on spot size
C     INSPOT... Intensities of all spots found on current
C               image, before rejections based on spot size
C     ISIGSP... Standard deviations of intensities
C     NOIMG     The pack or image number.
C     PHI..     Phi value of the mid-point of the image
C     NIMAG     Total number of images read in (for autoindexing)
C     NEWSPT    If TRUE, new format spot coordinate file, otherwise old
C               format.
C     MEDWXSPOT Median spot size in pixels in X determined in PICKSPOTS
C     MEDWYSPOT Median spot size in pixels in Y determined in PICKSPOTS
C     IRSTRT    Number of the image on which to restart after an abort
C
C     SPXMIN    Minimum X coord (relative to direct beam position) for
C               spots
C     SPYMIN    Minimum Y coord (relative to direct beam position) for
C               spots
C     NSPTD     Number of displayed spots
C     THRESH    Threshold for pixel to be considered part of a spot,
C               is (background + THRESH*sigma)
C
C     .. Scalars in Common Block /SPOTS2/ and /SPOTS2C/ ..
      REAL CUTPIXMAX,CUTPIXMIN,CUTWXMAX,CUTWXMIN,CUTWYMAX,CUTWYMIN,
     +     XSPLIT,YSPLIT,YOFFSET,XOFFSET,THRESH,RMINSP,RMAXSP,
     +     RMINSRCH,RMAXSRCH,SCALSRCH,SPXMIN,SPYMIN,THRESHMIN,
     +     THRESHMAX
      INTEGER NBINR,NBINT,IBINLIM,NPIXMIN,NPIXMAX,IIMAG,NIMAG,
     +     MEDWXSPOT,MEDWYSPOT,NSEARCH,ITHSET,ISAFE,IRSTRT,
     +     NSPTD
      LOGICAL RADX,RADY,NEWSPT,DOFIND,FOUND
      CHARACTER IMGTEMPL*100,IMGFN*100,IMGNUM*6
C     ..
C     .. Arrays in common /SPOTS2/  and /SPOTS2C/ ....
      INTEGER NPIX,IWXSPOT,IWYSPOT,IORDER,INSPOT,NOIMG,ISDSPOT
      REAL BGOD,PHI,XSPOT,YSPOT,RSPOT,PHISTIM,BGODA2
C     ..
C     .. Common Block /SPOTS2/  and /SPOTS2C/ ....
c      COMMON /SPOTS2/XSPLIT,YSPLIT,NBINR,NBINT,
c     +       IBINLIM,PHI(MAXIMG),NPIXMIN,NPIXMAX,CUTPIXMIN,CUTPIXMAX,
c     +       CUTWXMIN,CUTWXMAX,CUTWYMIN,CUTWYMAX,
c     +       BGOD(IXWDTH),YOFFSET,XOFFSET,RADX,RADY,THRESH,IIMAG,NIMAG,
c     +       NPIX(MXSPOT),IWXSPOT(MXSPOT),IWYSPOT(MXSPOT),
c     +       IORDER(MXSPOT),INSPOT(MXSPOT),XSPOT(MXSPOT),
c     +       YSPOT(MXSPOT),RSPOT(MXSPOT),RMINSP,RMAXSP,NOIMG(MAXIMG),
c     +       NEWSPT,DOFIND,ISDSPOT(MXSPOT),MEDWXSPOT,MEDWYSPOT,
c     +       PHISTIM(MAXIMG),RMINSRCH,RMAXSRCH,NSEARCH,SCALSRCH,
c     +       ITHSET,ISAFE,IRSTRT,SPXMIN,SPYMIN,THRESHMIN,THRESHMAX,
c     +       NSPTD
       common /spots2/CUTPIXMAX,CUTPIXMIN,CUTWXMAX,CUTWXMIN,CUTWYMAX,
     +     CUTWYMIN,XSPLIT,YSPLIT,YOFFSET,XOFFSET,THRESH,RMINSP,RMAXSP,
     +     RMINSRCH,RMAXSRCH,SCALSRCH,SPXMIN,SPYMIN,THRESHMIN,
     +     THRESHMAX,NBINR,NBINT,IBINLIM,NPIXMIN,NPIXMAX,IIMAG,NIMAG,
     +     MEDWXSPOT,MEDWYSPOT,NSEARCH,ITHSET,ISAFE,IRSTRT,
     +     NSPTD,RADX,RADY,NEWSPT,DOFIND,FOUND,
     $  NPIX(MXSPOT),IWXSPOT(MXSPOT),IWYSPOT(MXSPOT),
     $  IORDER(MXSPOT),INSPOT(MXSPOT),NOIMG(MAXIMG),ISDSPOT(MXSPOT),
     $  BGOD(IXWDTH),PHI(MAXIMG),XSPOT(MXSPOT),YSPOT(MXSPOT),
     $  RSPOT(MXSPOT),PHISTIM(MAXIMG),BGODA2(21,21,3)

      COMMON /SPOTS2C/ IMGTEMPL,IMGFN,IMGNUM
C&&*&& end_include  ../inc/spots2.f
C     ..
C     .. Equivalences ..
      SAVE
C     ..
C     .. Data ..
C     ..
C
      IHX = IXSPBOX/2
      IHY = IYSPBOX/2
C
C---- Set up limits for box to be extracted from IMAGE array
C
      IXMIN = MAX(1,IXP-IHX)
      IXMAX = MIN(NXPIX,IXP+IHX)
      IYMIN = MAX(1,IYP-IHY)
      IYMAX = MIN(NYPIX,IYP+IHY)
      IXSIZ = IXMAX - IXMIN + 1
      IYSIZ = IYMAX - IYMIN + 1
C
      IMAX = 0
      JMAX = 0
      IODMAX = 0
      II = 0
      DO 20 I = IXMIN,IXMAX
        II = II + 1
        JJ = 0
        DO 10 J = IYMIN,IYMAX
          JJ = JJ + 1
          IOD =  INTPXL(IMAGE(J,I))
          IF (IOD.GT.IODMAX) THEN
            IMAX = II
            JMAX = JJ
            IODMAX = IOD
          END IF
          ISPBOX(JJ,II) = IOD
 10     CONTINUE
 20   CONTINUE
C
      IF (DEBUG(67)) THEN
        WRITE(IOUT,FMT=6000) IXMIN,IXMAX,IYMIN,IYMAX,IMAX,JMAX,IODMAX
        IF (ONLINE) WRITE(ITOUT,FMT=6000) IXMIN,IXMAX,IYMIN,IYMAX,
     +                          IMAX,JMAX,IODMAX
 6000   FORMAT(1X,'Limits of box in X',2I6,' in Y',2I6,/,1X,
     +     'Max counts at X=',I5,' Y=',I5,' with value',I8)
      END IF
C
C---- Now find c. of g. of a box of size IXSPWDTH,IYSPWDTH centred on
C     the maximum value
C
      IHXSP = IXSPWDTH/2
      IHYSP = IYSPWDTH/2
C
C---- Check box is within extracted box
C
      IF (((IMAX-IHXSP).LT.1).OR.((IMAX+IHXSP).GT.IXSIZ)
     +    .OR.((JMAX-IHYSP).LT.1).OR.((JMAX+IHYSP).GT.IYSIZ)) THEN
C
C---- Set up limits for new box to be extracted from IMAGE array
C
        IXP2 = IXMIN + IMAX - 1
        IYP2 = IYMIN + JMAX - 1
C
C----- If this box lies outside image array, reduce its size
C
        IF ((IXP2 - IHX).LT.1) THEN
          IHX = IXP2 - 1
        ELSE IF ((IXP2 + IHX).GT.NXPIX) THEN
          IHX = NXPIX - IXP2
        ELSE IF ((IYP2 - IHY).LT.1) THEN
          IHY = IYP2 - 1
        ELSE IF ((IYP2 + IHY).GT.NYPIX) THEN
          IHY = NYPIX - IYP2
        END IF

        IXMIN = IXP2 - IHX
        IXMAX = IXP2 + IHX
        IYMIN = IYP2 - IHY
        IYMAX = IYP2 + IHY
        IXSIZ = IXMAX - IXMIN + 1
        IYSIZ = IYMAX - IYMIN + 1
C
        IF (DEBUG(67)) THEN
          WRITE(IOUT,FMT=6002) IXMIN,IXMAX,IYMIN,IYMAX
          IF (ONLINE) WRITE(ITOUT,FMT=6002) IXMIN,IXMAX,IYMIN,IYMAX
 6002     FORMAT(1X,'Extract a new box, new limits of box in X',
     +            2I6,' in Y',2I6)
        END IF
        IODMAX = 0
        II = 0
        DO 40 I = IXMIN,IXMAX
          II = II + 1
          JJ = 0
          DO 30 J = IYMIN,IYMAX
            JJ = JJ + 1
            IOD =  INTPXL(IMAGE(J,I))
            IF (IOD.GT.IODMAX) THEN
              IMAX = II
              JMAX = JJ
              IODMAX = IOD
            END IF
            ISPBOX(JJ,II) = IOD
 30       CONTINUE
 40     CONTINUE
C
      END IF
C
C---- Now find the c. of g.
C
      SUMX = 0
      SUMY = 0
      SUM = 0
      IXST = IMAX - IHXSP
      IXEND = IMAX + IHXSP
      IYST = JMAX - IHYSP
      IYEND = JMAX + IHYSP
C
C---- Try to trap failuers
C
      IF ((IXST.LT.1).OR.(IYST.LT.1)) RETURN
      DO 60 I = IXST,IXEND
        DO 50 J = IYST,IYEND
          IOD = ISPBOX(J,I)
          SUMX = SUMX + REAL(I*IOD)
          SUMY = SUMY + REAL(J*IOD)
          SUM = SUM + REAL(IOD)
 50     CONTINUE
 60   CONTINUE
C
      IF (SUM.GT.0) THEN
        SUMX = SUMX/SUM
        SUMY = SUMY/SUM
      END IF
C
C---- Convert to mm, corrected for YSCAL
C
      XSP = (SUMX + IXMIN - 1)*RAST
      YSP = (SUMY + IYMIN - 1)*RAST/YSCAL
C
C---- Add this spot to the total. NSPT is initially the number found
C     by the automatic search, but is incremented for manually added spots.
C
C
      IF (NIMAG.EQ.1) THEN
        NPREV = 0
      ELSE 
        NPREV = IENDIMG(NIMAG-1)
      END IF
C
      IF (NPREV+NSPT.LT.NSPOTS) THEN
        IF (ISTIMG(NIMAG).EQ.0) THEN
          IF (NIMAG.EQ.1) THEN
            ISTIMG(NIMAG) = 1
            IENDIMG(NIMAG) = 0
          ELSE
            ISTIMG(NIMAG) = NPREV + 1
          END IF
        END IF
        NSPT = NSPT + 1
        XSPT(NPREV+NSPT) = XSP
        YSPT(NPREV+NSPT) = YSP
        ISPT(NPREV+NSPT) = SUM
        ISDSPT(NPREV+NSPT) = MAX(NINT(0.001*SUM),1)
        ISPT(NPREV+NSPT) = 1000*ISDSPT(NPREV+NSPT)
        IENDIMG(NIMAG) = NPREV + NSPT
        IF (DEBUG(67)) THEN
          WRITE(IOUT,FMT=6010) SUMX,SUMY,SUM,XSP,YSP,NSPT,NIMAG
          IF (ONLINE) WRITE(ITOUT,FMT=6010) SUMX,SUMY,SUM,XSP,YSP,
     +                 NSPT,NIMAG
 6010   FORMAT(1X,'Centre of gravity',2F8.2,' Total intensity',F8.0,
     +         /,1x,'mm coords',2F8.2,' added as spot number',I5,
     +          ' on image',I3)
        END IF
      ELSE
        ISTAT = -1
        RETURN
      END IF
C
C---- display this spot
C
      MODEDISP = 1
      CALL DSPSPT(MODEDISP)
      END
      SUBROUTINE ADJREF(IX,IY,IFLAG)
C
C---- Calculates the rotation, scale factor and translation required
C     to superimpose the spots whose predicted and observed positions
C     have been entered using the mouse and are stored in IX,IY in
C     image pixels
C
C     IX(4),IY(4)     Coordinates of the 4 points
C     IFLAG = 0 Calculated shift accepted for all images
C           = 1 Calculated shift accepted for current image only
C           = 2 Reject calculated shift (AND TRY AGAIN)
C
      IMPLICIT NONE
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C&&*&& include  ../inc/mxdinc.f
C
C $Id: mxdinc.f,v 1.1 2002/05/02 10:47:00 harry Exp $
C
C--- awk generated include file  mxdinc.h
C---- START of include file mxdinc.h
C
C
c common block for mxd routines: various parameters for XDL routines
c
c     base_width    width of base frame
c     base_height   height of base frame
c     men_x,men_y   position of menu area
c     par_x,par_y   position of parameter area
C     

C     IORDER    (R)   Order of the data in the input image 
c                with respect to two local axes ax1, ax2 e.g.
c                (xf, yf) as a number from 1 to 8.
c                    1   +ax1 slow   +ax2 fast    (+xf, +yf)
c                    2   +ax1 slow   -ax2 fast    (+xf, -yf)
c                    3   -ax1 slow   +ax2 fast    (-xf, +yf)
c                    4   -ax1 slow   -ax2 fast    (-xf, -yf)
c                    5   +ax2 slow   +ax1 fast    (+yf, +xf)
c                    6   +ax2 slow   -ax1 fast    (+yf, -xf)
c                    7   -ax2 slow   +ax1 fast    (-yf, +xf)
c                    8   -ax2 slow   -ax1 fast    (-yf, -xf)
c
c
c     JORDER    (R)   Display order with respect to the two
c                local axes (1 to 8) along the X-windows
c                axes X horizontal (left to right), Y vertical 
c                (top to bottom ) with origin at top left
c                1  +ax1 X (horiz)   +ax2 Y (vert)   (+xf, +yf)
c                2  +ax1 X (horiz)   -ax2 Y (vert)   (+xf, -yf)
c                3  -ax1 X (horiz)   +ax2 Y (vert)   (-xf, +yf)
c                4  -ax1 X (horiz)   -ax2 Y (vert)   (-xf, -yf)
c                5  +ax2 X (horiz)   +ax1 Y (vert)   (+yf, +xf)
c                6  +ax2 X (horiz)   -ax1 Y (vert)   (+yf, -xf)
c                7  -ax2 X (horiz)   +ax1 Y (vert)   (-yf, +xf)
c                8  -ax2 X (horiz)   -ax1 Y (vert)   (-yf, -xf)
c                    
c                    (2 was standard for Laue programs)
c
c     nxp_cmp       number of pixels compressed to 1 in horizontal
c                   display direction
c     nyp_cmp       number of pixels compressed to 1 in vertical
c                   display direction
c     nxdpx         number of horizontal pixels in displayed image
c     nydpx         number of vertical pixels in displayed image
c     img_horiz     image direction for horizontal display (=1 fast, 2 slow)
c     img_vert      image direction for vertical display   (=1 fast, 2 slow)
c     img_map(4)    mapping of image to display
c                    imgmap(1)   1st point on fast axis (Yms)
c                    imgmap(2)   1st point on slow axis (Zms)
c                    imgmap(3)   increment on fast axis
c                    imgmap(4)   increment on slow
c     img_x,img_y   x, y position of image
c     men_x, men_y  x, y position of menu
c     par_x, par_y  x, y position of parameter table
c     io_x, io_y    x, y position of IO area
c     not_x, not_y    x, y position of notice area (parameter table
c                     with no values)
c     pmn_x, pmn_y  x, y position of popup abort menu
c     ppb_x, ppb_y  x, y position of popup progress bar
c     busy_x, busy_y x, y position of busy window
c     img_width,img_height   width, height of image window
c     men_width, men_height  width, height of menu window  
c     par_width, par_height  width, height of parameter window
c     io_width, io_height    width, height of IO window
c     not_width, not_height  width, height of notice area
c     pmn_width, pmn_height  width, height of Abort menu
c     ppb_width              width of progress bar
c     busy_width, busy_height  width, height of busy box
c     sub_process    .true. if program is sub-process of eg clips, .false.
c                    if standalone
c
C     IFTYPE      1 = unsigned byte data
C                 2 = unsigned two-byte data (i2)
C                 3 = signed integer data
C                 4 = 'squashed i2' data (if Intensity>32767 
C                    store as 65536-Intensity/8)
      INTEGER BASE_WIDTH,BASE_HEIGHT,
     $     IMAGE_ORDER,JIMAGE_ORDER,NXP_CMP,NYP_CMP,
     $     NXDPX,NYDPX,
     $     IMG_HORIZ,IMG_VERT,IMG_MAP(4),
     $     IMG_X,IMG_Y,MEN_X,MEN_Y,PAR_X,PAR_Y,IO_X,IO_Y,
     $     NOT_X,NOT_Y,PMN_X, PMN_Y,PPB_X, PPB_Y, BUSY_X, BUSY_Y,
     $     BUSY_Y2,IFTYPE
      INTEGER IMG_WIDTH, IMG_HEIGHT, MEN_WIDTH, MEN_HEIGHT,
     $     PAR_WIDTH, PAR_HEIGHT, IO_WIDTH, IO_HEIGHT,
     $     NOT_WIDTH, NOT_HEIGHT, PMN_WIDTH, PMN_HEIGHT,
     $     PPB_WIDTH, BUSY_WIDTH, BUSY_HEIGHT
      LOGICAL SUB_PROCESS, BLANK
C

c  DON'T forget to declare function xdlstr as integer
      INTEGER XDLSTR
      EXTERNAL XDLSTR

c
c     ivhbas        view object handle for base frame
c     ivhimg        view object handle for image
c     ivhpar        view object handle for parameter table
c     ivhmen        view object handle for menu
c     ivhio         view object handle for io area
c     ivhio2        view object handle for second io area (pick option)
c     ivhio3        view object handle for third io area (output)
c     ivhnot        view object handle for notice area (parameter table)
c     ivhpmn        view object handle for popup wait menu
c     ivhppb        view object handle for popup progress bar
c     ivhblank      view object handle for blank object
c     ivhbusy       view object handle for busy object
c     ivhbusy2      view object handle for second (2 line) busy object
      INTEGER IVHBAS, IVHIMG, IVHPAR, IVHMEN, IVHIO, IVHNOT, IVHPMN,
     $     IVHPPB, IVHBLANK, IVHBUSY, IVHIO2, IVHBUSY2, IVHIO3
      PARAMETER (IVHBAS=1, IVHIMG=2, IVHPAR=3, IVHMEN=4, IVHIO=5,
     $     IVHNOT=6, IVHPMN=7, IVHPPB=8, IVHBLANK=9, IVHBUSY=10,
     $     IVHIO2=11, IVHBUSY2=12, IVHIO3=13)

c  Border  boundary between windows
      INTEGER BORDER
      PARAMETER (BORDER = 3)

c     icset   colour set number
      INTEGER ICSET
      PARAMETER (ICSET=1)
c
c     iord    axis order of image
c             = 1  xf slow, yf fast
      INTEGER IORD
      PARAMETER (IORD = 1)
c
c     minw,minh   minimum width and height for image display object
      INTEGER MINW,MINH
      PARAMETER (MINW=0, MINH=0)
c
c     ixopix, iyopix      pixel origin of displayed part
      INTEGER IXOPIX,IYOPIX
      PARAMETER (IXOPIX=1, IYOPIX=1)
c
c     ibg     background menu, =0 for none
      INTEGER IBG
      PARAMETER (IBG=0)
c
c     iovly   overlay option
      INTEGER IOVLY
      PARAMETER (IOVLY=1)
c
c     max_pixel   maximum number of pixels to use for image display:
c                 this will be used to control possible compression
c                 of the image
      INTEGER MAX_PIXEL
      PARAMETER (MAX_PIXEL = 600)
c  Image stuff
c     disp_img        true if image has been displayed
c
      LOGICAL DISP_IMG
c
c     ifd     file descriptor, = -1 for no file
      INTEGER IFD
      PARAMETER (IFD=0)
c

c  Parameter table stuff
c     max_par_col     maximum number of parameter columns
c     max_par_rows    maximum number of parameter rows
c     max_par_name    maximum length of name
c     max_par_str     maximum value length
c     par_title       = -1 no title +1 title present
c     par_font        font (3=medium)
c     par_menu        = 1 if popup menus allowed
c     disp_par        true if parameter table hsa been displayed
c
      LOGICAL DISP_PAR
      INTEGER MAX_PAR_COL, MAX_PAR_ROWS, MAX_PAR_NAME, MAX_PAR_STR,
     $        PAR_TITLE, PAR_FONT, PAR_MENU
      PARAMETER (MAX_PAR_COL = 1, MAX_PAR_ROWS = 50,
     $           MAX_PAR_NAME = 17, MAX_PAR_STR = 7,
     $           PAR_TITLE = 1, PAR_FONT = 2, PAR_MENU = 0)
C
c  Menu stuff
c     max_men_itms    maximum number of menu items
c     max_men_name    maximum number of characters in menu item
c     men_font        menu font number (3=medium)
c     men_quit_flag   = 1 to allow for quit box
c     max_men_title   maximum length of menu title
c     disp_menu       true if menu displayed
      LOGICAL DISP_MENU
      INTEGER MAX_MEN_ITMS, MAX_MEN_NAME, MEN_FONT, MEN_QUIT_FLAG,
     $        MAX_MEN_TITLE 
      PARAMETER (MAX_MEN_ITMS = 19, MAX_MEN_NAME = 19, MEN_FONT = 2,
     $     MEN_QUIT_FLAG = 1, MAX_MEN_TITLE = 9)

c
c IO area stuff
c     io_font         font number
c     disp_io         true if io area displayed
c     disp_io2        true if SECOND io area displayed
c     disp_io3        true if THIRD io area displayed
C     NSCROLL         number of pages to hold for scrolling
      LOGICAL DISP_IO,DISP_IO2,DISP_IO3
      INTEGER IO_FONT,NSCROLL
      PARAMETER (IO_FONT=2)
      PARAMETER (NSCROLL=0)


c  Notice area stuff (notice area is a parameter table with no values)
c     max_not_col     maximum number of parameter columns
c     max_not_rows    maximum number of parameter rows
c     max_not_name    maximum length of name
c     max_not_str     maximum value length
c     not_title       = -1 no title +1 title present
c     not_font        font (3=medium)
c     not_menu        = 1 if popup menus allowed
c     disp_not       true if menu displayed
      LOGICAL DISP_NOT
      INTEGER MAX_NOT_COL, MAX_NOT_ROWS, MAX_NOT_NAME, MAX_NOT_STR,
     $        NOT_TITLE, NOT_FONT, NOT_MENU
      PARAMETER (MAX_NOT_COL = 1, MAX_NOT_ROWS = 18,
     $           MAX_NOT_NAME = 23,
     $           MAX_NOT_STR = 0,
     $           NOT_TITLE = +1, NOT_FONT = 1, NOT_MENU = 0)
c
c  Menu stuff for Abort menu
c     max_pmn_itms    maximum number of menu items
c     max_pmn_name    maximum number of characters in menu item
c     pmn_font        menu font number (3=medium)
c     pmn_quit_flag   = 1 to allow for quit box
c     max_pmn_title   maximum length of menu title
      INTEGER MAX_PMN_ITMS, MAX_PMN_NAME, PMN_FONT, PMN_QUIT_FLAG,
     $        MAX_PMN_TITLE 
      PARAMETER (MAX_PMN_ITMS = 0, MAX_PMN_NAME = 12, PMN_FONT = 2,
     $     PMN_QUIT_FLAG = 1, MAX_PMN_TITLE = 15)

c   Stuff for progress bar
c     ppb_font   font number (3=medium)
c     ppb_colr   colour
      INTEGER PPB_FONT, PPB_COLR
      PARAMETER (PPB_FONT = 2, PPB_COLR=3)

c   Busy box
      INTEGER BUSY_FONT
      PARAMETER (BUSY_FONT = 2)
c
c len_dialog    length of dialog box
      INTEGER LEN_DIALOG
      PARAMETER (LEN_DIALOG = 60)

c
c  Overlays
c
c  Circles
c     cir_ivec    vector set number for circles
c     cir_colr    colour for circles
c     cir_iovl    overlay number for circles
c     cir_symb   symbol for centre
      INTEGER CIR_IVEC, CIR_COLR, CIR_IOVL, CIR_SYMB
      PARAMETER (CIR_IVEC=3, CIR_COLR=6, CIR_IOVL=2, CIR_SYMB=4)

C
C---- Residual vectors
C     IRV_VEC Vector set number
C     IRV_COL Colour  (1 red, 2 yellow, 3 green)
C     IRV_OVL Overlay number
      INTEGER IRV_VEC, IRV_COL, IRV_OVL
      PARAMETER (IRV_VEC=4, IRV_COL=1, IRV_OVL=2)
c  Measure
c
c     mes_colr    colour for measure crosses
      INTEGER MES_COLR
      PARAMETER (MES_COLR=1)

c   Vertical Crosses
c     cross_iovl    overlay number for circles
c     cross_symb   symbol for centre
      INTEGER CROSS_IOVL, CROSS_SYMB
      PARAMETER (CROSS_IOVL=2, CROSS_SYMB=3)
c  Boxes
c     box_iovl    overlay number for boxes
c     box_symb   symbol for centre
      INTEGER BOX_IOVL, BOX_SYMB, BOX_VEC
      PARAMETER (BOX_VEC=2,BOX_IOVL=2, BOX_SYMB=13)
c  Circles
c     CIRC_iovl    overlay number for circles
c     CIRC_symb   symbol for centre
      INTEGER CIRC_IOVL, CIRC_VEC
      PARAMETER (CIRC_VEC=5,CIRC_IOVL=2)
c   Crosses
c     cross_iovl    overlay number for circles
c     cross_symb   symbol for centre
      INTEGER XCROSS_IOVL, XCROSS_SYMB
      PARAMETER (XCROSS_IOVL=2, XCROSS_SYMB=13)
C
C---- common block last of all
C
      COMMON /MXDCMI/ BASE_WIDTH,BASE_HEIGHT,
     $     IMAGE_ORDER,JIMAGE_ORDER,NXP_CMP,NYP_CMP,
     $     NXDPX,NYDPX,
     $     IMG_HORIZ,IMG_VERT,IMG_MAP,
     $     IMG_X,IMG_Y,MEN_X,MEN_Y,PAR_X,PAR_Y,IO_X,IO_Y,
     $     NOT_X,NOT_Y,PMN_X, PMN_Y,PPB_X, PPB_Y, BUSY_X, BUSY_Y,
     $     BUSY_Y2, IFTYPE,
     $     IMG_WIDTH, IMG_HEIGHT, MEN_WIDTH, MEN_HEIGHT,
     $     PAR_WIDTH, PAR_HEIGHT, IO_WIDTH, IO_HEIGHT,
     $     NOT_WIDTH, NOT_HEIGHT, PMN_WIDTH, PMN_HEIGHT,
     $     PPB_WIDTH, BUSY_WIDTH, BUSY_HEIGHT,
     $     SUB_PROCESS,BLANK,DISP_IMG,DISP_PAR,DISP_MENU,
     $     DISP_IO,DISP_IO2,DISP_IO3,DISP_NOT
  
C&&*&& end_include  ../inc/mxdinc.f
C
      INTEGER NPARM
      PARAMETER (NPARM = 200)
C
C     .. Scalar Arguments ..
      INTEGER IFLAG
C
C     .. ARRAY Arguments ..
      INTEGER IX(4),IY(4)
C     ..
C     .. Local Scalars ..
      REAL ANGLE,COSA,COSOM,DELX,DELY,DXCAL,DXOBS,DYCAL,DYOBS,OMEGA0,R,
     +     RCOS,RSIN,SINA,SINOM,SPSI,SCDX,SCDY,SSINOM0,SCOSOM0,SXTOFRA,
     +     CDX,CDY,SXCEN,SYCEN,DRSQ,X,X1,X2
      INTEGER I,NDISP,MODE
      CHARACTER LINE*80,LLINE*80,STR1*4
C     ..
C     .. Local Arrays ..
C
C---- Things for parser
C
      INTEGER IBEG(NPARM),IDEC(NPARM),IEND(NPARM),ITYP(NPARM)
      REAL VALUE(NPARM)
      INTEGER NTOK
C     ..
C     .. External Subroutines ..
      EXTERNAL MXDWIO,MXDCIO,DSPPRD
C     ..
C     .. Extrinsic Functions ..
      INTEGER  LENSTR
      EXTERNAL  LENSTR
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ATAN2,SQRT
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/graphics.f
C
C $Id: graphics.f,v 1.1 2002/05/02 10:46:48 harry Exp $
C
C--- awk generated include file  graphics.h
C---- START of include file graphics.h
C
C
C     .. Scalars in common /GRAPHICS/ ..
      REAL GRFACT,DISPLAY
      INTEGER NGR,NGX,NGY,NHX,NHY,NLI
C     ..
C     .. Common block /GRAPHICS/ ..
      COMMON /GRAPHICS/GRFACT,DISPLAY,NGR,NGX,NGY,NHX,NHY,NLI
C     ..
C
C
C&&*&& end_include  ../inc/graphics.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
C&&*&& include  ../inc/precession.f
C
C $Id: precession.f,v 1.1 2002/05/02 10:47:08 harry Exp $
C
C--- awk generated include file  precession.h
C---- START of include file precession.h
C
C
C     .. Scalars in common block /PRECESSION/ ..
      REAL D1,D2,PHIPREC,PSIPREC,PCTOFD,XLAMBDA
      LOGICAL PRECESS
C     ..
C     .. Common Block /PRECESSION/ ..
      COMMON /PRECESSION/D1,D2,PHIPREC,PSIPREC,PCTOFD,XLAMBDA,PRECESS
C     ..
C
C
C&&*&& end_include  ../inc/precession.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C     ..
      SAVE
      IFLAG = 0
      MODE = 0
      SXTOFRA = XTOFRA
      SPSI = PSIPREC
      SSINOM0 = SINOM0
      SCOSOM0 = COSOM0
      SXCEN = XCEN
      SYCEN = YCEN
      SCDX = CDX
      SCDY = CDY
C
C---- Move coords so they are relative to direct beam position
C
      DO 10 I = 1,4
        IX(I) = IX(I) - XCEN*FACT
        IY(I) = IY(I) - YCEN*FACT
   10 CONTINUE
C
      DXOBS = IX(2) - IX(4)
      DYOBS = IY(2) - IY(4)
      DXCAL = IX(1) - IX(3)
      DYCAL = IY(1) - IY(3)
      DRSQ =  (DXCAL**2+DYCAL**2)
      X1 = DXOBS*DXCAL+DYOBS*DYCAL
      X2 = DYOBS*DXCAL-DXOBS*DYCAL
      X = X1**2 + X2**2
C
      IF ((DRSQ.LT.1.0E-5).OR.(X.LT.1.0E-5)) THEN
        LINE = '                                                       '
        WRITE (LINE,FMT=6020)
 6020   FORMAT (1X,'Points too close to allow adjustment')
        CALL MXDWIO(LINE, 1)
        LINE = '                                                       '
        WRITE (LINE, 6022) 
 6022   FORMAT (1X, 'Do you want to try again ? (Y)')
        CALL MXDWIO(LINE, 1)
        CALL MXDRIO(LLINE)
C
C---- Parse reply
C
C                    ******************************************
        CALL MPARSE(LLINE,IBEG,IEND,ITYP,VALUE,IDEC,NTOK)
C                    ******************************************
        IF (NTOK.EQ.0) THEN
          STR1 = 'Y'
        ELSE
          STR1 = LLINE(IBEG(1):IEND(1))
          CALL CCPUPC(STR1)
        END IF
        IF (STR1.EQ.'Y') THEN
          IFLAG = 2
          RETURN
        ELSE
          CALL MXDCIO(1,0,0,0,0)
          RETURN
        END IF
      END IF
C
      RCOS = (DXOBS*DXCAL+DYOBS*DYCAL)/ DRSQ
      RSIN = (DYOBS*DXCAL-DXOBS*DYCAL)/ DRSQ
      R = SQRT(RCOS**2+RSIN**2)
      XTOFRA = XTOFRA*R
      COSA = RCOS/R
      SINA = RSIN/R
      ANGLE = ATAN2(RSIN,RCOS)*180.0/3.14159
C
C
        COSOM = COSOM0*COSA - SINOM0*SINA
        SINOM = COSOM0*SINA + SINOM0*COSA
        SINOM0 = SINOM
        COSOM0 = COSOM
        OMEGA0 = ATAN2(SINOM0,COSOM0)*180.0/3.14159
C
C
C---- FACT converts image  pixels back to 10micron units
C
      DELX = (IY(1)*RSIN+IX(2)-IX(1)*RCOS)/FACT
      XCEN = XCEN + DELX
      DELY = (IY(2)-IY(1)*RCOS-IX(1)*RSIN)/FACT
      YCEN = YCEN + DELY
      WRITE (LINE,FMT=6000) R
 6000 FORMAT(1X,'Scale factor =',F6.3)
      CALL MXDWIO(LINE, 2)
      LINE = '                                                       '
      WRITE (LINE,FMT=6002) ANGLE
 6002 FORMAT (1X,'Rotation of calculated pattern=',F6.2,' Deg.')
      CALL MXDWIO(LINE, 2)
      LINE = '                                                       '
      WRITE (LINE,FMT=6004) 0.01*DELX,0.01*DELY
 6004 FORMAT (1X,'Shift in Centre =',2F6.1,'mm')
      CALL MXDWIO(LINE, 2)
C
C
C---- Check for continuation
C
      LINE = '                                                       '
      WRITE (LINE, 6018) 
 6018 FORMAT (1X, 'Do you wish to accept this ? (Y)')
      CALL MXDWIO(LINE, 1)
      CALL MXDRIO(LLINE)
C
C---- Parse reply
C
C                    ******************************************
      CALL MPARSE(LLINE,IBEG,IEND,ITYP,VALUE,IDEC,NTOK)
C                    ******************************************
      IF (NTOK.EQ.0) THEN
        STR1 = 'Y'
      ELSE
        STR1 = LLINE(IBEG(1):IEND(1))
        CALL CCPUPC(STR1)
      END IF
      IF (STR1.EQ.'Y') THEN
C
C---- Delete old prediction, put up new one
C
        CALL MXDDVN(BOX_VEC)
        CALL DSPPRD(NDISP,MODE)
      ELSE
C
C---- Restore original values
C
        XTOFRA = SXTOFRA
        PSIPREC = SPSI
        SINOM0 = SSINOM0
        COSOM0 = SCOSOM0
        XCEN = SXCEN
        YCEN = SYCEN
        CDX = SCDX
        CDY = SCDY
      END IF
C
C
C----  Apply to all images ?
C
      LINE = '                                                       '
      WRITE (LINE, 6024) 
 6024 FORMAT (1X, 'Update beam coordinates for all images ? (Y)')
      CALL MXDWIO(LINE, 1)
      CALL MXDRIO(LLINE)
C
C---- Parse reply
C
C                    ******************************************
      CALL MPARSE(LLINE,IBEG,IEND,ITYP,VALUE,IDEC,NTOK)
C                    ******************************************
      IF (NTOK.EQ.0) THEN
        STR1 = 'Y'
      ELSE
        STR1 = LLINE(IBEG(1):IEND(1))
        CALL CCPUPC(STR1)
      END IF
      IF (STR1.EQ.'Y') THEN
        IFLAG = 0
      ELSE
        IFLAG = 1
      END IF
      CALL MXDCIO(1,0,0,0,0)
      END
C== ALIGN ==
C
      SUBROUTINE ALIGN(JAXIS,IUNIQ)
C     ============================
C
      IMPLICIT NONE
C
C---- To determine the orientation of the real space axes wrt the laboratory
C     frame and the rotation required to bring real space axes into the plane
C     containing the rotation axis and the X-ray beam
C     Used in STRATEGY option
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C
C     ..
C     .. Scalar Arguments ..
C
C     ..
C     .. Local Scalars ..
      INTEGER I,IAXIS,JAXIS,J,IUNIQ
      REAL DTOR,ANGMIN,THETAMAX,THETAUNIQ,THADD,TRUANG
      CHARACTER ABCSTR(3)*1, LINE*80
      LOGICAL NOCUSP,NULINE,HIGHSYM
C     ..
C     .. Local Arrays ..
      REAL AREAL(3),
     +     BREAL(3),CREAL(3),AANG(3),BANG(3),CANG(3),ZANG(3),
     +     ABCREAL(3,3),THETA(3),DELPHIL(3),ANGTOX(3)
C     ..
C     .. External Subroutines ..
      EXTERNAL WINDIO,ALIGN2,MXDWIO
C     ..
C     .. Intrinsic Functions ..
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/cell.f
C
C $Id: cell.f,v 1.2 2003/06/16 16:41:13 harry Exp $
C
C--- awk generated include file  cell.h
C---- START of include file cell.h
C
C     CELL cell dimensions (real space)
C     RCELL reciprocal cell parameters in dimensionless rlu
C
C     .. Arrays in Common /CELLCOM/ ..
      REAL UMAT,BMAT,GMAT,CELL,RCELL,UMATCELL,SOFTCELL
      INTEGER LCELL,ICRYST,NUMSPG,NLAUE
C     ..
C     .. Common Block /CELLCOM/ ..
      COMMON /CELLCOM/UMAT(3,3),BMAT(3,3),GMAT(3,3),CELL(6),RCELL(6),
     $       UMATCELL(6),SOFTCELL,LCELL(6),ICRYST,NUMSPG,NLAUE
C     ..
C
C
C&&*&& end_include  ../inc/cell.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/dsplyc.f
C
C $Id: dsplyc.f,v 1.1 2002/05/02 10:46:46 harry Exp $
C
C--- awk generated include file  dsplyc.h
C---- START of include file dsplyc.h
C
C*******************************************************************
C
C  COMMON  /DSPLYC/
C
C	IMGLOW, IMGHI	low & high values of 16-bit image for scaling
C			integer*2 to byte: IMGLOW maps to  0; 
C			IMGHI to maximum. Note that these are not
C			necessarily the actual limits of the data
C	JDSPWD		.LT. 0  before image window has been created
C                       = +-1 for image display that can be panned
C                       = +-2 for non-interactive image display
C       MAXDEN          highest level in colour table to fill up to
C                       must be less than ~240 - number of overlay colours
C       LDSPSG          if .true., treat image as signed, ie after dark
C                          subtraction
C                       if .false., treat image as unsigned
C       NZOOM           zoom factor for image, = 0 if no zoom
C       JYZOOM, JZZOOM  1st pixel in zoomed image
C
C----   WINOPEN Flag for whether or not window is open. Do not
C               confuse with DISPMENU (/CONDATA/)which is true if the run was
C               started with a IMAGE keyword.
C
C
C       CDSPTL          banner title
C
      INTEGER IMGLOW, IMGHI, JDSPWD, MAXDEN,
     $     NZOOM, JYZOOM, JZZOOM
      LOGICAL LDSPSG,WINOPEN,LPAUSE,LHELP
      COMMON /DSPLYC/ IMGLOW, IMGHI, JDSPWD,
     *     MAXDEN, NZOOM, JYZOOM, JZZOOM, LDSPSG,WINOPEN,LPAUSE,LHELP
C
      CHARACTER  CDSPTL*200
      COMMON /DSPLCC/  CDSPTL
C                                                           
C
C*******************************************************************


C&&*&& end_include  ../inc/dsplyc.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/ioosum.f
C
C $Id: ioosum.f,v 1.2 2004/08/16 13:26:27 harry Exp $
C
C--- awk generated include file  ioosum.h
C---- START of include file ioosum.h
C
C     .. Scalars in common block /IOOSUM/
      INTEGER NLSUM1,NLSUM2,NSUMSTART1,NSUMSTART2
C
C     .. Arrays in common block /IOOSUMC/ ..
      CHARACTER*150 LINESUM1(MAXPAX),LINESUM2(MAXPAX)
      CHARACTER*101  IOLINE(100)
C     ..
C     .. Common block /IOOSUM/ ..
      COMMON /IOOSUM/ NLSUM1,NLSUM2,NSUMSTART1,NSUMSTART2
C     ..
C     .. Common block /IOOSUMC/ ..
      COMMON /IOOSUMC/ LINESUM1,LINESUM2,IOLINE
C&&*&& end_include  ../inc/ioosum.f
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/strat.f
C--- awk generated include file  strat.h
C---- START of include file strat.h
C
C---- Stores variables for use in STRATEGY option
C     IROTAX is the axis closest to the rotation axis
C     PHIROTAX is the angle this axis makes with the rotation axis
C
C     PHIZONE is the phi value at which axis "IZONEAX" is along the
C     X-ray beam. (IZONEAX = 1 is a, =2 is b, =3 is c)
C     PHIPAD  is the rotation to be added to PHILAUE to ensure generation
C             of all unique data, and will depend on angle between the
C             unique axis and the rotation axis.
C     AUTANOM if true tries to maximise number of anomalous pairs
C     CELLSCAL is the scale factor applied to the cell edges to
C              speed up the calculation.
C     SHRUNK   is TRUE if the cell has been scaled by CELLSCAL
C     ISTRUN   is used to increment input phi angles by multiples of
C              360 degrees, so that phi values in different parts can
C              be recognised. It starts at zero.
C     FIRSTRAT Starts as TRUE (set in MOSDATA) and is set to FALSE once
C              the MTZ file has been opened for a STRATEGY run.
C              Reset TRUE after EXITing from STRATGEY prompt.
C
C     .. Scalars in common /STRAT/ ..
      INTEGER NSEGM,IPCKCUR,NSTRAT,NUNIQ,NSTRUN,ISTRUN,NSEGAUTO,
     +        IZONEAX,IROTAX,NLAST,NNPACKS,NLASTPACK
      LOGICAL STRATEGY,AUTO,SIZESET,AUTANOM,SHRUNK,FIRSTRAT,
     +         NEWSTRAT,WAITINP,OFFPHI
      REAL ROTAUTO,PHILAUE,PHIPAD,PHIZONE,PHIROTAX,CELLSCAL
C     ..
C     .. Arrays in common /STRAT/ ..
      REAL PHIST,PHIFIN,PHIINC,PHIADD,PHISEGA
      INTEGER IFIRSTONE
C     ..
C     .. Common Block /STRAT/ ..
      COMMON /STRAT/ PHIST(NSEGMAX),PHIFIN(NSEGMAX),PHIINC(NSEGMAX),
     +       PHIADD(NSEGMAX),PHISEGA(NSEGMAX),ROTAUTO,PHILAUE,PHIPAD,
     $       PHIZONE,PHIROTAX,CELLSCAL,IFIRSTONE(NSEGMAX),
     $       NSEGM,IPCKCUR,NSTRAT,NUNIQ,
     +       NSTRUN,ISTRUN,NSEGAUTO,
     +       IZONEAX,IROTAX,NLAST,NNPACKS,NLASTPACK,
     +       STRATEGY,AUTO,SIZESET,AUTANOM,SHRUNK,
     +       FIRSTRAT,NEWSTRAT,WAITINP,
     +       OFFPHI
C     ..
C
C


      
C&&*&& end_include  ../inc/strat.f
C     ..
C     .. Equivalences ..
      EQUIVALENCE (AREAL(1),ABCREAL(1,1)),(BREAL(1),ABCREAL(1,2)),
     +            (CREAL(1),ABCREAL(1,3))
      SAVE
C     ..
C     .. Data ..
      DATA ABCSTR/'a','b','c'/
C     ..
      DTOR = ATAN(1.0)*4.0/180.0
      NULINE = .TRUE.
C
      CALL ALIGN2(DELPHI,AMAT,AREAL,BREAL,CREAL)
C
C---- Get angles with lab X,Y,Z axes
C
       DO 20 I = 1,3
         AANG(I) = ACOS(AREAL(I))/DTOR
         BANG(I) = ACOS(BREAL(I))/DTOR
         CANG(I) = ACOS(CREAL(I))/DTOR
         DELPHIL(I) = DELPHI(I)
 20    CONTINUE
C
C
      WRITE(IOUT,FMT=6010) (AANG(I),I=1,3),(BANG(I),I=1,3),
     +                           (CANG(I), I=1,3)
      IF (ONLINE) WRITE(ITOUT,FMT=6010) (AANG(I),I=1,3),
     +                           (BANG(I),I=1,3),(CANG(I), I=1,3)
 6010 FORMAT(1X,'Angles between a axis and X,Y,Z axes',3F8.3/,
     +       1X,'Angles between b axis and X,Y,Z axes',3F8.3,/,
     +       1X,'Angles between c axis and X,Y,Z axes',3F8.3)
C
C---- Find axis closest to the rotation (Z) axis
C
       ZANG(1) = ABS(MIN(AANG(3),180-AANG(3)))
       ZANG(2) = ABS(MIN(BANG(3),180-BANG(3)))
       ZANG(3) = ABS(MIN(CANG(3),180-CANG(3)))
C
       ANGMIN = 200.0
       DO 30 I = 1,3
        IF (ZANG(I).LT.ANGMIN) THEN
          ANGMIN = ZANG(I)
          IAXIS = I
        END IF 
 30    CONTINUE
C
      WRITE(IOUT,FMT=6020) ABCSTR(IAXIS),ANGMIN
      IF (ONLINE) WRITE(ITOUT,FMT=6020) ABCSTR(IAXIS),ANGMIN
 6020 FORMAT(1X,'The ',A,' axis is closest to the rotation axis ',
     +       '(angle',F6.2,')')
      IROTAX = IAXIS
      PHIROTAX = 2*(NINT(ANGMIN)/2)
C
C---- Find the actual angle, needed for orthorhombic choices
C
      IF (IAXIS.EQ.1) THEN
         TRUANG = AANG(3)
      ELSE IF (IAXIS.EQ.2) THEN
         TRUANG = BANG(3)
      ELSE
         TRUANG = CANG(3)
      END IF
C
      IF (WINOPEN) THEN
        LINE = ' '
        WRITE(LINE,FMT=6060) (AANG(I),I=1,3)
 6060 FORMAT('Angles between a axis and X,Y,Z axes',3F8.3)
        CALL MXDWIO(LINE,1)
        LINE = ' '
        WRITE(LINE,FMT=6062) (BANG(I),I=1,3)
 6062   FORMAT('Angles between b axis and X,Y,Z axes',3F8.3)
        CALL MXDWIO(LINE,1)
        LINE = ' '
        WRITE(LINE,FMT=6064) (CANG(I),I=1,3)
 6064   FORMAT('Angles between c axis and X,Y,Z axes',3F8.3)
        CALL MXDWIO(LINE,1)
        LINE = ' '
        WRITE(LINE,FMT=6066) ABCSTR(IAXIS),ANGMIN
 6066   FORMAT('The ',A,' axis is closest to the rotation axis ',
     +       '(angle',F6.2,')')
        CALL MXDWIO(LINE,1)
      END IF
C
C---- Find rotation angle required to bring other axes into XZ plane
C
      ANGMIN = 200.0
      DO 40 I = 1,3
        IF (I.EQ.IAXIS) GOTO 40
        IF (ABCREAL(1,I).EQ.0.0) THEN
          THETA(I) = 90.0
        ELSE
          THETA(I) = ATAN(-ABCREAL(2,I)/ABCREAL(1,I))/DTOR
        END IF
        IF (ABS(THETA(I)).LT.ANGMIN) THEN
          ANGMIN = ABS(THETA(I))
          JAXIS = I
        END IF
        WRITE(IOUT,FMT=6030) ABCSTR(I),THETA(I)
        IF (ONLINE) WRITE(ITOUT,FMT=6030) ABCSTR(I),THETA(I)
 6030   FORMAT(1X,'Rotation angle to get the ',A,' axis in XZ plane',
     +         F8.2)
        IF (WINOPEN) THEN
          LINE = ' '
          WRITE(LINE,FMT=6068) ABCSTR(I),THETA(I)
 6068     FORMAT('Rotation angle to get the ',A,' axis in XZ plane',
     +         F8.2)
          CALL MXDWIO(LINE,1)
        END IF
 40   CONTINUE
C
C---- Rotation to get the principle axis in the YZ plane
C
      IF (NLAUE.EQ.4) THEN
        IUNIQ = 2
      ELSE
        IUNIQ = 3
      END IF
C
      IF (ABCREAL(1,IUNIQ).EQ.0.0) THEN
        THETAUNIQ = 0.0
      ELSE 
        IF (ABCREAL(2,IUNIQ).EQ.0.0) THEN
          THETAUNIQ = 90.0
        ELSE
          THETAUNIQ = ATAN(ABCREAL(1,IUNIQ)/ABCREAL(2,IUNIQ))/DTOR
        END IF
      END IF
C
C---- Use THETAUNIQ for trigonal or higher symmetry only (gives
C     incorrect results for orthorhombic)
C
      HIGHSYM = (NLAUE.GT.6)
C
C---- Now need to discriminate whether to use THETAUNIQ or THETAUNIQ+180
C
      IF (HIGHSYM) THEN

        DELPHIL(3) = DELPHI(3) + THETAUNIQ
        CALL ALIGN2(DELPHIL,AMAT,AREAL,BREAL,CREAL)
        DO 50 I = 1,3
          AANG(I) = ACOS(AREAL(I))/DTOR
          BANG(I) = ACOS(BREAL(I))/DTOR
          CANG(I) = ACOS(CREAL(I))/DTOR
 50     CONTINUE
        IF (AANG(3).LE.90.0) THEN
          IF (AANG(2).LE.90.0) THETAUNIQ = THETAUNIQ + 180.0
        ELSE
          IF (AANG(2).GT.90.0) THETAUNIQ = THETAUNIQ + 180.0
        END IF
C
        WRITE(IOUT,FMT=6070) ABCSTR(IUNIQ), THETAUNIQ
        IF (ONLINE) WRITE(ITOUT,FMT=6070) ABCSTR(IUNIQ), THETAUNIQ
 6070   FORMAT(/,1X,'Unique axis is: ',A,/,1X,'Rotation angle to',
     +         ' get the unique axis into the YZ plane:',F7.1)
        IF (WINOPEN) THEN
          LINE = ' '
          WRITE(LINE,FMT=6072) ABCSTR(IUNIQ)
 6072     FORMAT('Unique axis is: ',A)
          CALL MXDWIO(LINE,1)
          LINE = ' '
          WRITE(LINE,FMT=6074) THETAUNIQ
 6074     FORMAT('Rotation angle to get the unique axis into the',
     +           ' YZ plane:',F7.1)
          CALL MXDWIO(LINE,1)
        END IF
      ELSE
C
C---- For orthorhombic space groups, need to find best starting phi
C     Find the solution for which axis to put in the XZ plane as the
C     one which gives the smallest possible angle between a real space
C     axis and the X-axis.
C
        ANGMIN = 200
        DO 70 I = 1,3
          IF (I.EQ.IAXIS) GOTO 70
          DELPHIL(3) = DELPHI(3) + THETA(I)
          CALL ALIGN2(DELPHIL,AMAT,AREAL,BREAL,CREAL)
          ANGTOX(1) = ACOS(AREAL(1))/DTOR
          ANGTOX(2) = ACOS(BREAL(1))/DTOR
          ANGTOX(3) = ACOS(CREAL(1))/DTOR
          DO 60 J = 1,3
            IF (ANGTOX(J).GT.90.0) ANGTOX(J) = 180.0 - ANGTOX(J)
            IF (ANGTOX(J).LT.ANGMIN) THEN
              ANGMIN = ANGTOX(J)
              JAXIS = I
            END IF
 60       CONTINUE
C
          IF (DEBUG(60)) THEN
            WRITE(IOUT,FMT=6080) ABCSTR(I),(ANGTOX(J),J=1,3),JAXIS
            IF (ONLINE) WRITE(ITOUT,FMT=6080) ABCSTR(I),
     +                  (ANGTOX(J),J=1,3),JAXIS
 6080       FORMAT(1X,'Testing axis ',A,' angles of a,b,c to X axis',
     +                ' are:',3F6.0,'  JAXIS chosen as',I2)
          END IF
 70     CONTINUE
C
C---- Have now chosen which axis is to go in XZ plane, now need to select
C     between this angle and this angle plus 180. Choose the one which
C     places the axis closest to the rotation axis at less than 90 degrees
C     from Y.
C
        THADD = 0.0
        DO 80 I = 1,2
          DELPHIL(3) = DELPHI(3) + THETA(JAXIS)
          IF (I.EQ.2) DELPHIL(3) = DELPHIL(3) + 180
          CALL ALIGN2(DELPHIL,AMAT,AREAL,BREAL,CREAL)
          ANGTOX(1) = ACOS(AREAL(2))/DTOR
          ANGTOX(2) = ACOS(BREAL(2))/DTOR
          ANGTOX(3) = ACOS(CREAL(2))/DTOR
          IF (ANGTOX(IAXIS).LE.90.0) THEN
            IF (I.EQ.1) THEN
              THADD = 0.0
            ELSE
              THADD = 180.0
            END IF
            IF (TRUANG.LE.90.0) THADD = THADD - 180.0
          END IF
          IF (DEBUG(60)) THEN
            WRITE(IOUT,FMT=6082) I,IAXIS,JAXIS,ABCSTR(IAXIS),
     +                        ANGTOX(IAXIS),THADD
            IF (ONLINE) WRITE(ITOUT,FMT=6082) I,IAXIS,JAXIS,
     +              ABCSTR(IAXIS),ANGTOX(IAXIS),THADD
 6082       FORMAT(1X,'I=',I3,'  IAXIS=',I2,'  JAXIS=',I2,'  Angle ',
     +           'between ',A,' axis and Y axis',F6.1,'  THADD',F6.0)
          END IF
 80     CONTINUE

      END IF
C
C---- Test for possibility of missing CUSP data
C
      THETAMAX = ASIN(DSTMAX/2.0)/DTOR
C
C---- Triclinc...always cusp data
C
      IF (NLAUE.EQ.3) THEN
        WRITE(IOUT,FMT=6050)     
        IF (ONLINE) WRITE(ITOUT,FMT=6050)     
 6050   FORMAT(/,1X,'***** WARNING *****',/,1X,'***** WARNING *****',
     +     /,1X,'***** WARNING *****',/,1X,'***** WARNING *****',/,1X,
     +        'In triclinc space groups',
     +         ' it is not possible to collect 100% complete',/,1X,
     +         'data rotating about a single axis, some data will ',
     +         'always be lost in the cusp',/)
        IF (WINOPEN) THEN
          WRITE(IOLINE,FMT=6050)
          CALL WINDIO(NULINE)
        END IF
      ELSE IF (NLAUE.EQ.4) THEN
C
C---- Monoclinic, need 2-fold to lie between thetamax and 90-thetamax 
C     away from the rotation axis.
C      
        NOCUSP = ((90.0-THETAMAX.GE.ZANG(2)).AND.(ZANG(2).GE.THETAMAX))
        IF (.NOT.NOCUSP) THEN
        WRITE(IOUT,FMT=6052) 90.0-THETAMAX, THETAMAX
        IF (ONLINE) WRITE(ITOUT,FMT=6052) 90.0-THETAMAX, THETAMAX
        IF (WINOPEN) THEN
          WRITE(IOLINE,FMT=6052) 90.0-THETAMAX, THETAMAX
          CALL WINDIO(NULINE)
        END IF
        END IF
 6052   FORMAT(/,1X,'***** WARNING *****',/,1X,'***** WARNING *****',
     +     /,1X,'***** WARNING *****',/,1X,'***** WARNING *****',/,1X
     +        ,'With the crystal in the current orientation it is not',
     =        ' possible to collect',/,1X,'100% of the data, some ',
     +        'will be lost in the cusp.',/,1X,'To avoid a cusp, the',
     +        ' b-axis must be at an angle between',F5.1,' and',F5.1,
     +        ' degrees',/,1X,'away from the rotation axis (Z)',
     +        /,1X,'You may want to adjust the orientation with the',
     +        ' goniometer arcs.',/)
      ELSE IF (NLAUE.EQ.6) THEN
C
C---- Orthorhombic, a,b or c must lie between thetamax and 90-thetamax
C     away from the rotation axis.
C     
        NOCUSP =(((90.0-THETAMAX.GE.ZANG(1)).AND.(ZANG(1).GE.THETAMAX))
     +            .OR.
     +          ((90.0-THETAMAX.GE.ZANG(2)).AND.(ZANG(2).GE.THETAMAX))
     +            .OR.
     +          ((90.0-THETAMAX.GE.ZANG(3)).AND.(ZANG(3).GE.THETAMAX)))
        IF (.NOT.NOCUSP) THEN
        WRITE(IOUT,FMT=6054) 90.0-THETAMAX, THETAMAX
        IF (ONLINE) WRITE(ITOUT,FMT=6054) 90.0-THETAMAX, THETAMAX
        IF (WINOPEN) THEN
          WRITE(IOLINE,FMT=6054) 90.0-THETAMAX, THETAMAX
          CALL WINDIO(NULINE)
        END IF
        END IF
 6054   FORMAT(/,1X,'***** WARNING *****',/,1X,'***** WARNING *****',
     +     /,1X,'***** WARNING *****',/,1X,'***** WARNING *****',/,1X
     +       ,'With the crystal in the current orientation it is not',
     =        ' possible to collect',/,1X,'100% of the data, some ',
     +        'will be lost in the cusp.',/,1X,'To avoid a cusp, the',
     +        ' a,b or c axes must be at an angle between',F5.1,' and',
     +        F5.1,' degrees',/,1X,'away from the rotation axis (Z)',
     +        /,1X,'You may want to adjust the orientation with the',
     +        ' goniometer arcs.',/)
C
      ELSE IF ((NLAUE.EQ.7).OR.(NLAUE.EQ.9).OR.(NLAUE.EQ.12)) THEN
C
C---- Laue groups 3/m,4/m,6/m (ie one unique axis), the unqie axis must 
C     lie betweeen 90-thetmax and thetamax from rotn axis.
        NOCUSP = ((90.0-THETAMAX.GE.ZANG(3)).AND.(ZANG(3).GE.THETAMAX))
        IF (.NOT.NOCUSP) THEN
        WRITE(IOUT,FMT=6056) 90.0-THETAMAX, THETAMAX
        IF (ONLINE) WRITE(ITOUT,FMT=6056) 90.0-THETAMAX, THETAMAX
        IF (WINOPEN) THEN
          WRITE(IOLINE,FMT=6056) 90.0-THETAMAX, THETAMAX
          CALL WINDIO(NULINE)
        END IF
        END IF
 6056   FORMAT(/,1X,'***** WARNING *****',/,1X,'***** WARNING *****',
     +     /,1X,'***** WARNING *****',/,1X,'***** WARNING *****',/,1X
     +        ,'With the crystal in the current orientation it is not',
     =        ' possible to collect',/,1X,'100% of the data, some ',
     +        'will be lost in the cusp.',/,1X,'To avoid a cusp, the',
     +        ' c-axis must be at an angle between',F5.1,' and',F5.1,
     +        ' degrees',/,1X,'away from the rotation axis (Z)',
     +        /,1X,'You may want to adjust the orientation with the',
     +        ' goniometer arcs.',/)

      END IF        
C
C---- PHIZONE must be an integral number of degrees
C
      PHIZONE = REAL(NINT(THETA(JAXIS))) + THADD
      IF (PHIZONE.GT.360.0) PHIZONE = PHIZONE - 360.0
      IF (PHIZONE.LT.0.0) PHIZONE = PHIZONE + 360.0
      IF (NEWSTRAT) PHIZONE = PHIZONE + 180.0
      IZONEAX = JAXIS
      IF (HIGHSYM) THEN
        PHIZONE = REAL(NINT(THETAUNIQ))
        IZONEAX = IUNIQ
      END IF
      END
C== ALIGN2 ==
C
      SUBROUTINE ALIGN2(DELPHI,AMAT,AREAL,BREAL,CREAL)
C     ================================================
C
      IMPLICIT NONE
C
C---- To determine the orientation of the real space axes wrt the laboratory
C     frame and the rotation requiredto bring real space axes into the plane
C     containing the rotation axis and the X-ray beam
C     Called from ALIGN
C
C     ..
C     .. Scalar Arguments ..
C     ..
C     .. Array Arguments ..
      REAL DELPHI(3),AMAT(3,3),AREAL(3),BREAL(3),CREAL(3)
C
C     ..
C     .. Local Scalars ..
      INTEGER I,J
C     ..
C     .. Local Arrays ..
      REAL RMAT(3,3),WORK(3,3),ASTAR(3),BSTAR(3),CSTAR(3),v1(3)
C     ..
C     .. External Subroutines ..
C     ..
C     .. Intrinsic Functions ..
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C     ..
C     ..
C     .. Equivalences ..
      SAVE
C     ..
C     .. Data ..
C     ..
C
C---- Form product of misseting angles and A matrix. 
C     First convert missets to a rotation matrix
C
       CALL ROTMAT(DELPHI,WORK,1)
C
C---- Form product with AMAT (A=BC)
C
       CALL MATMUL3(RMAT,WORK,AMAT)
C
C---- Get A*,B*,C* vectors       
C
       V1(1) = 1
       V1(2) = 0
       V1(3) = 0
       CALL MATVEC(ASTAR,RMAT,V1)
       V1(1) = 0
       V1(2) = 1
       V1(3) = 0
       CALL MATVEC(BSTAR,RMAT,V1)
       V1(1) = 0
       V1(2) = 0
       V1(3) = 1
       CALL MATVEC(CSTAR,RMAT,V1)
CAL       WRITE(6,*),'ASTAR,BSTAR,CSTAR',ASTAR,BSTAR,CSTAR
C
C---- Convert to unit vectors
C
       CALL UNIT(ASTAR)
       CALL UNIT(BSTAR)
       CALL UNIT(CSTAR)
C
C---- Get unit vectors along real space axes a,b,c
C
       CALL CROSS(AREAL,BSTAR,CSTAR)
       CALL CROSS(BREAL,CSTAR,ASTAR)
       CALL CROSS(CREAL,ASTAR,BSTAR)
C
C---- Convert to unit vectors
C
       CALL UNIT(AREAL)
       CALL UNIT(BREAL)
       CALL UNIT(CREAL)
CAL       WRITE(6,*),'AREAL,BREAL,CREAL',AREAL,BREAL,CREAL
      IF (DEBUG(60)) THEN
       WRITE(IOUT,FMT=6000) (DELPHI(I),I=1,3),
     +                       ((WORK(I,J),J=1,3),I=1,3),
     +                       ((RMAT(I,J),J=1,3),I=1,3),
     +      ASTAR,BSTAR,CSTAR,AREAL,BREAL,CREAL
       IF (ONLINE) WRITE(ITOUT,FMT=6000) (DELPHI(I),I=1,3),
     +                       ((WORK(I,J),J=1,3),I=1,3),
     +                       ((RMAT(I,J),J=1,3),I=1,3),
     +      ASTAR,BSTAR,CSTAR,AREAL,BREAL,CREAL
 6000  FORMAT(1X,'Missets ',3F10.3,/,1X,'Corresponding matrix:',/,
     +        3(1X,3F10.7/),/,1X,'Modified AMAT',/,
     +        3(1X,3F10.7/),/,1X,'Unit vectors along a*:',3F10.5,/,1X,
     +        '             along b*:',3F10.5,/,1X,
     +        '             along c*:',3F10.5,/,1X,
     +        '             along a :',3F10.5,/,1X,
     +        '             along b :',3F10.5,/,1X,
     +        '             along b :',3F10.5)
      END IF
C
C---- Get angles with lab X,Y,Z axes
C
       DO 20 I = 1,3
         IF (ABS(AREAL(I)).GT.1.0) AREAL(I) = SIGN(1.0,AREAL(I))
         IF (ABS(BREAL(I)).GT.1.0) BREAL(I) = SIGN(1.0,BREAL(I))
         IF (ABS(CREAL(I)).GT.1.0) CREAL(I) = SIGN(1.0,CREAL(I))
 20    CONTINUE
C
C
      END
C
C Routine to allow different integration of different resolution limits in 
C each of three reciprocal axis directions; an ellipsoid is calculated with 
C its long principal axis coaxial with the longest reciprocal axis, and the
C shorter axes orthogonal to this. The observant will notice that the code 
C is derived from the CCP4 subroutine RBFR01.
C
C     ===============================
      SUBROUTINE ANIRES(ORTMAT)
C     ===============================
C
C
C   ORTMAT    (O)  (REAL(3,3))   Standard orthogonisational matrix
C
C  this generates the various orthogonalising matrices
C     ' NCODE =1 -  ORTHOG AXES ARE DEFINED TO HAVE'
C                    A PARALLEL TO XO   CSTAR PARALLEL TO ZO'
C
C   SET UP MATRICES TO ORTHOGONALISE H K L AND X Y Z FOR THIS CELL.
C
C
C---- Returned arrays
C
      REAL ORTMAT(3,3)
C
C---- Local arrays
C
C     RECELL is wavelength independent reciprocal cell
C
      REAL RECELL(6)
C     
C---- Local Scalars
C
      REAL A,ALPH,B,BET,C,GAMM,DTOR,COSA,COSAS,COSB,COSBS,SINBS,
     +     COSG,COSGS,SINGS,FCT,SINA,SINB,SING,SUM,V,VOL,PI
      INTEGER I,J
C
C---- include files
C
C&&*&& include  ../inc/cell.f
C
C $Id: cell.f,v 1.2 2003/06/16 16:41:13 harry Exp $
C
C--- awk generated include file  cell.h
C---- START of include file cell.h
C
C     CELL cell dimensions (real space)
C     RCELL reciprocal cell parameters in dimensionless rlu
C
C     .. Arrays in Common /CELLCOM/ ..
      REAL UMAT,BMAT,GMAT,CELL,RCELL,UMATCELL,SOFTCELL
      INTEGER LCELL,ICRYST,NUMSPG,NLAUE
C     ..
C     .. Common Block /CELLCOM/ ..
      COMMON /CELLCOM/UMAT(3,3),BMAT(3,3),GMAT(3,3),CELL(6),RCELL(6),
     $       UMATCELL(6),SOFTCELL,LCELL(6),ICRYST,NUMSPG,NLAUE
C     ..
C
C
C&&*&& end_include  ../inc/cell.f
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C
C---- Intrinsic Functions
C
      INTRINSIC ATAN,ATAN2,COS,SIN,SQRT
C
C---- External routines
C
      EXTERNAL RECCEL
C
C---- Remember we're using the wavelength independent reciprocal cell...
C
      CALL RECCEL(RECELL,CELL,1.00)
      PI = ATAN(1.0)*4.0
      DTOR = PI/180.0
      FCT = 8.0*PI*PI
      ALPH = RECELL(4)*DTOR
      BET = RECELL(5)*DTOR
      GAMM = RECELL(6)*DTOR
      SUM = (ALPH+BET+GAMM)*0.5
      V = SQRT(SIN(SUM-ALPH)*SIN(SUM-BET)*SIN(SUM-GAMM)*SIN(SUM))
      VOL = 2.0*RECELL(1)*RECELL(2)*RECELL(3)*V
      SINA = SIN(ALPH)
      COSA = COS(ALPH)
      SINB = SIN(BET)
      COSB = COS(BET)
      SING = SIN(GAMM)
      COSG = COS(GAMM)
      COSAS = (COSG*COSB-COSA)/ (SINB*SING)
      SINAS = SQRT(1.0-COSAS*COSAS)
      COSBS = (COSA*COSG-COSB)/ (SINA*SING)
      SINBS = SQRT(1.0-COSBS*COSBS)
      COSGS = (COSA*COSB-COSG)/ (SINA*SINB)
      SINGS = SQRT(1.0-COSGS*COSGS)
      A = RECELL(1)*RESANI(1)
      B = RECELL(2)*RESANI(2)
      C = RECELL(3)*RESANI(3)
C
C---- Zero matrices
C
        DO 30 I = 1,3
          DO 20 J = 1,3
            ORTMAT(I,J) = 0.0
   20     CONTINUE
   30   CONTINUE
        IF ((C.GT.A).AND.(C.GT.B)) THEN
C
C----  c* longest
C
           ORTMAT(1,1) = A
           ORTMAT(1,2) = B*COSG
           ORTMAT(1,3) = C*COSB
           ORTMAT(2,2) = B*SING
           ORTMAT(2,3) = -C*SINB*COSAS
           ORTMAT(3,3) = C*SINB*SINAS
        ELSE IF ((A.GT.B).AND.(A.GT.C))THEN
C
C----  a* longest
C
           ORTMAT(1,1) = A*COSG
           ORTMAT(1,2) = B
           ORTMAT(1,3) = C*COSA
           ORTMAT(2,1) = -A*SING*COSBS
           ORTMAT(2,3) = C*SINA
           ORTMAT(3,1) = A*SING*SINBS
        ELSE
C
C----  b* longest or equal to either a* or c*
C
           ORTMAT(1,1) = A*COSB
           ORTMAT(1,2) = B*COSA
           ORTMAT(1,3) = C
           ORTMAT(2,1) = A*SINB
           ORTMAT(2,2) = -B*SINA*COSGS
           ORTMAT(3,2) = B*SINA*SINGS
        ENDIF
C
C
C
      RETURN
      END


C
C              
C== AREA ==
      REAL FUNCTION AREA(XYP,XY)
C     ..
C     .. Array Arguments ..
      REAL XYP(2),XY(2,4)
C
C     .. Local scalars
      REAL A,AR
      INTEGER I,J
C
C     .. Local arrays
      REAL DXY(2,4)
C     ..                      
C     .. External Subroutines ..
      EXTERNAL V2SUB,V2CROSS
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS
C
      DO 10 I=1,4
        CALL V2SUB(XYP,XY(1,I),DXY(1,I))
 10   CONTINUE
      A = 0.0
      DO 20 I = 1,4
        J = I + 1
        IF (J.GT.4) J = 1
        CALL V2CROSS(DXY(1,I),DXY(1,J),AR)
        A = A + AR
 20   CONTINUE
      AREA = ABS(0.5*A)
      END         
C
C         
C== AREAQ ==
      REAL FUNCTION AREAQ(XY)
C     ..
C     .. Array Arguments ..
      REAL XY(2,4)
C
C     .. Local scalars
      INTEGER I
      REAL XG,YG
C
C     .. Local arrays
      REAL XYG(2)
C     ..
C     .. External Functions ..    
      REAL AREA
      EXTERNAL AREA
      XG = 0.0
      YG = 0.0
      DO 10 I=1,4
        XG = XG + XY(1,I)
        YG = YG + XY(2,I)
 10   CONTINUE
      XYG(1) = XG/4.0
      XYG(2) = YG/4.0
      AREAQ = AREA(XYG,XY)
      END
C     
C     $Id: automatch.f,v 1.15 2004/06/02 14:15:04 harry Exp $
C==   AUTOMATCH == 
C     HRP restructured - last original version in CVS v 1.13 2003/12/11 
C     
      SUBROUTINE AUTOMATCH(DOPROFILE,NSIG,IXSHIFT,IYSHIFT,NPROFL,LIMIT,
     +     SEP,VLIM,FAIL,LIST,USEBOX,
     +     ADDPART,RWEIGHT,PTMIN,
     +     REFREJ,THICK,FIRSTFILM,NUMBLOCK,MOSEST,IERR)
C     =================================================================
      IMPLICIT NONE
C     
C---- Last modified 11/05/04 - restructure so that HRP can understand
C     the flow - remove all gotos and use DO...WHILE loops. 
C     
C---- Last modified 8/6/93 replace SUMPART by ADDPART, SUMPART no longer
C     used
C---- Last modified 26/8/92 for mosaic spread refinement
C---- Last modified 16/10/91 for TRUECCOM etc
C---- Last modified 11/7/89 change params for S/R NEXT (Add PARTLS)
C     Last modified 6/10/88
C     
C---- This subroutine allows automatic pattern matching using
C     a modified version of the convolution technique described
C     by Rossmann (1978).
C     
C     Works with missetting angles PSIX,PSIY,PSIZ rather than
C     PHIX,PHIY,PHIZ.
C     
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      REAL VLIM,SEP,PTMIN,REFREJ,THICK
      INTEGER IXSHIFT,IYSHIFT,LIMIT,NPROFL,NSIG,NUMBLOCK,IERR
      LOGICAL DOPROFILE,FAIL,LIST,USEBOX,ADDPART,RWEIGHT,
     +     FIRSTFILM,NEWPREF,NUSPOT,MOSEST
C     
C     .. Local Scalars ..
      REAL DELPSI,DTOR,ETANEW,OMEGA0,OSCRANGE,PHIAV,PI,R,RESOL,
     +     SDGN,SDLO,SECT,SHIFT,SHIFTM,SHIFTT,SHMAXM,SHMAXT,
     +     TEMP,TH,VAR,X,AELIMIT2,AELIMIT3,DELETA,SCALE,
     +     AWELIMIT,XLIMIT,LPTMIN,FVAR,SIGX,SIGX2,SIGY,SIGXY
      INTEGER I,ICYC,IDELX,IDELY,IFAIL,IGAIND,ILOST,INT,
     +     INTGAIN,INTLOST,INTMAX,INTMIN,IPASS,IS,ISDGAIN,ISDLOST,
     +     ISNEG,ISPOS,ISTEP,IYZ,JSTEP,MINREF,MODE,
     +     NBIG,NC,NGAIN,NLOST,NM,NPR,NRJ,NRM,NRX,NRY,NXS,NYS,
     +     NRSOLD,IFLAG,MEANINT,IDDUM,iii,lastrec,ierr2
      LOGICAL BADSTART,CENTRE,FORCE,GENLIST,INTERPOL,OLDLIST,OVRLDS,
     +     PARTLS,PRECESS,LPROFILE,RESCAN,YES,LPOSTREF,FINAL,
     +     DPOWDER,RRWEIGHT,USEWEIGHT,REFETA,OKREF,LCENTRAL,
     +     LLAST,LMULTISEG,INTCHK,PROCEED,REPEAT,LRESID,REPEST,
     $     BIGSHIFT,AGAIN,REP_20,REP_40
C     ..
C     .. Local Arrays ..
      REAL PSI(3),RDELPHI(3),SHPSI(3),SPSI(3),XDELPHI(3),ETASTEP(41)
      INTEGER IGN(-20:20),ILO(-20:20),INTTOT(-20:20,2:3),
     +     ISDGN(-20:20),
     +     ISDLO(-20:20),ISDTOT(-20:20,2:3),NGL(-20:20),IRSAVE(62)
      CHARACTER PSISTR(6)*4
C     ..
C     .. External Subroutines ..
      EXTERNAL CENTRS,GENSORT,
     +     MEAS,NEWLIST,NEXT,PHITOPSI,PSITOPHI,RDIST,REFLMATCH,
     +     SECTOR,SETMAT,YESNO
      INTEGER LENSTR, XDLSTR
      EXTERNAL LENSTR, XDLSTR
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS,ASIN,ATAN,ATAN2,COS,MAX,MIN,SIN,SQRT,TAN
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/amatch.f
C
C $Id: amatch.f,v 1.1 2002/05/02 10:46:40 harry Exp $
C
C--- awk generated include file  amatch.h
C---- START of include file amatch.h
C
C
C     .. Scalars in Common /AMATCH/ ..
C     ..
      REAL RCONV,OVRLAP,RESOL1,RESOL2,AELIMIT,ARMSLIM,
     +     SECANGLE,DAMP,TRUECCOM,ETAMAX,AWRMSLIM,MOSNEW,
     $     SLOPE,INTERCEPT
      INTEGER NSTEP,NCYCA,NPASS,N2,N3,N4,N5,N6,N7,N8,N9,N10,NBEAM
      LOGICAL MATCH,NOCENT,NOREFINE,RMOSAIC
C     ..
C     .. Common block /AMATCH/  ..
      COMMON /AMATCH/RCONV,OVRLAP,RESOL1,RESOL2,AELIMIT,ARMSLIM,
     +     SECANGLE,DAMP,TRUECCOM,ETAMAX,AWRMSLIM,MOSNEW,
     $     SLOPE,INTERCEPT,NSTEP,NCYCA,NPASS,N2,N3,N4,N5,N6,N7,
     $     N8,N9,N10,NBEAM,MATCH,NOCENT,NOREFINE,RMOSAIC
C     ..
C
C
C&&*&& end_include  ../inc/amatch.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/fid.f
C
C $Id: fid.f,v 1.1 2002/05/02 10:46:47 harry Exp $
C
C--- awk generated include file  fid.h
C---- START of include file fid.h
C
C     XCENF,YCENF  Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame).
C                  For IP data this comes from the defined
C                  direct beam coordinates, for film data it is the
C                  midpoint of fiducials 1 and 3.
C
C     CCX,CCY      The difference (in 10 micron units) between the
C                  refined position of the direct beam (XCEN,YCEN) and
C                  the ideal direct beam coordinates (XCENF,YCENF),
C                  in the SCANNER coordinate frame.
C                  CCX,CCY are updated in RDIST. They are in "pixels"
C                  rather than mm (but expressed in 10micron units).
C
C     DTOFD        The distance (in 10 micron units) from the crystal
C                  to the detector along a normal to the detector.
C                  For flat, unswung detectors, or swung on a 2 theta arm,
C                  this is the same as CTOFD and XTOFD. It differs for
C                  Vee shaped cassettes. Assigned in START and never changed.
C                  Only actually used in RMAXR for calculating box sizes.
C
C     .. Arrays in common /FID/ ..
      REAL CCOMABC
      INTEGER FSPOS,CCXABC,CCYABC
C     ..
C     .. Scalars in common /FID/ ..
      REAL OMEGAF,CCOM,DTOFD,XCENF,YCENF
      INTEGER MM,MMDB,NFID,CCX,CCY,IYOFF
C     ..
C     .. Common block /FID/ ..
      COMMON /FID/CCOMABC(3),OMEGAF,CCOM,DTOFD,XCENF,YCENF,FSPOS(4,2),
     +       CCXABC(3),CCYABC(3),MM,MMDB,NFID,CCX,CCY,IYOFF
C     ..
C
C
C&&*&& end_include  ../inc/fid.f
C&&*&& include  ../inc/gendata.f
C
C $Id: gendata.f,v 1.2 2003/01/10 16:17:53 andrew Exp $
C
C--- awk generated include file  gendata.h
C---- START of include file gendata.h
C
C     IMG       Partiality indicator. 0 for full reflections, 1 to 100
C                   for partials. Negative for partials at the start of the
C                   rotation range, +ve for partials at the end of the 
C                   rotation. Set in subroutine REEK using DELEPS calculated
C                   in subroutine DSTAR
C
C     IRG       Reflection flag  (Set by SPTEST called from DSTAR)
C               =  0  Spot can be measured
C               =  1  Outside R, X, Y limits
C               =  2  Overlapping spot (set later)
C               =  3  Too wide in phi (more than NWMAX images)
C               =  4  DST .GT. DSTMAX  Not included in final film list -
C                       used only to check for overlaps at edge of film.
C               = 10  Spot is within cusp, but will be observed...not included
C                     in final spot list but must be included in predicted
C                      pattern
C
C               =  21  Spot present on 2 images, this is 1st
C               =  22  Spot present on 2 images, this is 2nd
C
C               =  31  Spot present on 3 images, this is 1st
C               =  32  Spot present on 3 images, this is 2nd
C               =  33  Spot present on 3 images, this is 3rd
C
C               =  41  Spot present on 4 images, this is 1st
C               =  42  Spot present on 4 images, this is 2nd
C               =  43  Spot present on 3 images, this is 3rd
C               =  44  Spot present on 4 images, this is 4th
C
C                 etc etc
C
C     XG        Virtual detector X coordinate in 10 micron units, relative to
C               an origin at the direct beam position. X is parallel to the
C               Y axis in the laboratory frame, ie orthogonal to the rotation
C               axis.
C
C     YG        Virtual detector Y coordinate in 10 micron units, relative to
C               an origin at the direct beam position. Y is parallel to the
C               Z axis in the laboratory frame, ie  the rotation axis.
C
C     IX,IY     are the coordinates of the reflection in pixels
C               (integers) wrt the first pixel in the image (lower left corner
C               cameramans view). For testing for spot overlap, these
C               coordinates are in 10 micron units. Also used for display
C               pixel coordinates when displaying predicted pattern.
C
C     IREC      Pointer to the record number of a particular spot in the
C               list of generated reflections.
C
C
C     ..
C     .. Arrays in common /GENDATA/ ..
      REAL FRACG,PHIG,PHIWG,XG,YG,GOODFIT
      INTEGER INTG,IPRO,IX,IY,IREC
      INTEGER*2 IRG,IMG,IGFLAG,ISDPRO,ISDG,IHG,IKG,ILG,IMPARTG,
     +          MISYMG
C     .. Scalars in common /GENDATA/ ..
      INTEGER IPACKREC,IPACKHEAD,IRECLAST
C     ..
C     .. Common block /GENDATA/ ..
      COMMON /GENDATA/FRACG(NREFLS),PHIG(NREFLS),PHIWG(NREFLS),
     $       XG(NREFLS),YG(NREFLS),INTG(NREFLS),IPRO(NREFLS),
     $       IX(NREFLS),IY(NREFLS),IREC(NREFLS),IRG(NREFLS),IMG(NREFLS),
     +       IGFLAG(NREFLS),ISDPRO(NREFLS),ISDG(NREFLS),
     +       IHG(NREFLS),IKG(NREFLS),ILG(NREFLS),IMPARTG(NREFLS),
     +       MISYMG(NREFLS),GOODFIT(NREFLS),IPACKREC,IPACKHEAD,
     +       IRECLAST
C     ..
C
C

C&&*&& end_include  ../inc/gendata.f
C&&*&& include  ../inc/graphics.f
C
C $Id: graphics.f,v 1.1 2002/05/02 10:46:48 harry Exp $
C
C--- awk generated include file  graphics.h
C---- START of include file graphics.h
C
C
C     .. Scalars in common /GRAPHICS/ ..
      REAL GRFACT,DISPLAY
      INTEGER NGR,NGX,NGY,NHX,NHY,NLI
C     ..
C     .. Common block /GRAPHICS/ ..
      COMMON /GRAPHICS/GRFACT,DISPLAY,NGR,NGX,NGY,NHX,NHY,NLI
C     ..
C
C
C&&*&& end_include  ../inc/graphics.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/iosp.f
C
C $Id: iosp.f,v 1.1 2002/05/02 10:46:53 harry Exp $
C
C--- awk generated include file  iosp.h
C---- START of include file iosp.h
C
C
C     .. Scalars in common block /IOSP/ ..
      INTEGER NSPOT,NFULL,NOUTGEN
C     ..
C     .. Common Block /IOSP/ ..
      COMMON /IOSP/NSPOT,NFULL,NOUTGEN
C     ..
C
C
C&&*&& end_include  ../inc/iosp.f
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/mcs.f
C $Id: mcs.f,v 1.1 2002/05/02 10:46:56 harry Exp $
C
C
C--- awk generated include file  mcs.h
C---- START of include file mcs.h
C
C
C     .. Scalars in common block /MCS/ ..
      REAL BASEOD,G1OD,CURV
      INTEGER FILM,FILMS,CTOFD,PCKIDX,TOSPT,N1OD,XSCMIN,XSCMAX
      LOGICAL VEE,VALONGX
C     ..
C     .. Common block /MCS/ ..
      COMMON /MCS/BASEOD,G1OD,CURV,FILM,FILMS,CTOFD,PCKIDX,TOSPT,
     $            N1OD,XSCMIN,XSCMAX,VEE,VALONGX
C     ..
C     CTOFD.... This was the crystal to detector distance (10 micron units)
C               but it has now been replaced by XTOFD in common block /XY/
C
C&&*&& end_include  ../inc/mcs.f
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
C&&*&& include  ../inc/ras.f
C
C $Id: ras.f,v 1.1 2002/05/02 10:47:10 harry Exp $
C
C--- awk generated include file  ras.h
C---- START of include file ras.h
C
C
C     .. Scalars in common block /RAS/ ..
      INTEGER NEWRAS,MINT
C     ..
C     .. Arrays in common block /RAS/ ..
      INTEGER IRAS
      REAL VARAS
C     ..
C     .. Common Block /RAS/ ..
      COMMON /RAS/VARAS(5),IRAS(5),NEWRAS,MINT
C     ..
C
C
C&&*&& end_include  ../inc/ras.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/reflist.f
C
C $Id: reflist.f,v 1.1 2002/05/02 10:47:12 harry Exp $
C
C--- awk generated include file  reflist.h
C---- START of include file reflist.h
C
C
C     .. Arrays in common block /REFLIST/ ..
      INTEGER XREF,YREF,INTREF,ISDREF
C     ..
C     .. Common Block /REFLIST/ ..
      COMMON /REFLIST/XREF(NREFLS),YREF(NREFLS),INTREF(NREFLS),
     +       ISDREF(NREFLS)
C     ..
C
C
C&&*&& end_include  ../inc/reflist.f
C&&*&& include  ../inc/rfs.f
C
C $Id: rfs.f,v 1.1 2002/05/02 10:47:15 harry Exp $
C
C--- awk generated include file  rfs.h
C---- START of include file rfs.h
C
C
C
C     .. Scalars in common block /RFS/ ..
      REAL FDIST,ESTART,RMSRES,WRMSRES,WESTART
      INTEGER MAXREF,MAXX,MAXY,NRS,MAXR,NREJS
C     ..
C     .. Arrays in common block /RFS/ ..
      REAL XRS,YRS,WXRS,WYRS
      INTEGER RRS,IHKLR
C     ..
C     .. Common Block /RFS/ ..
      COMMON /RFS/XRS(62),YRS(62),WXRS(62),WYRS(62),FDIST,ESTART,
     $       RMSRES,WRMSRES,WESTART,RRS(62),IHKLR(3,62),MAXREF,MAXX,
     +       MAXY,NRS,MAXR,NREJS
C     ..
C
C
C&&*&& end_include  ../inc/rfs.f
C&&*&& include  ../inc/saveit.f
C
C $Id: saveit.f,v 1.1 2002/05/02 10:47:16 harry Exp $
C
C--- awk generated include file  saveit.h
C---- START of include file saveit.h
C
C
C     .. Scalars in common block /SAVEIT/ ..
      REAL SETA,SDIVH,SDIVV
C     ..
C     .. Arrays in common block /SAVEIT/ ..
      REAL SDELPHI
C     .. Common Block /SAVEIT/ ..
      COMMON /SAVEIT/SDELPHI(3),SETA,SDIVH,SDIVV
C     ..
C
C
C&&*&& end_include  ../inc/saveit.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C&&*&& include  ../inc/xy.f
C
C $Id: xy.f,v 1.1 2002/05/02 10:47:25 harry Exp $
C
C--- awk generated include file  xy.h
C---- START of include file xy.h
C
C     .. Scalars in common block /XY/ ..
      REAL XTOFD,SINV,COSV,TANV,TWOTHETA
      INTEGER ICASS
C     ..
C     .. Common Block /XY/ ..
      COMMON /XY/XTOFD,SINV,COSV,TANV,TWOTHETA,ICASS
C     ..
C
C     XTOFD....  Crystal to detector distance in 10 micron units. Read from
C                keyworded input and never changed.
C
C                Spot positions are calculated in S/R XYSPOT (Called from
C                REEK) and are for an "ideal" detector at a distance of XTOFD.
C                These are converted into pixel positions in S/R MMTOPX
C                which applies the multiplicative factor XTOFRA to allow
C                for refinement of the distance. XTOFRA is the parameter
C                that is actually refined (in RDIST), rather than XTOFD.
C                The refined distance that is printed in the logfile is
C                actually XTOFRA*XTOFD
C
C     ICASS....  Indicates detector type:
C                0     Flat film
C                1     Vee shaped cassettes
C                2     FAST detector (only used in TESTGEN mode of OSCGEN)
C                3     Swung out FAST (ditto)
C                4     IP detector
C     TWOTHETA   Detector swing angle (degrees)
C&&*&& end_include  ../inc/xy.f
C     ..
C     .. Equivalences ..
      EQUIVALENCE (IRAS(1),NXS), (IRAS(2),NYS), (IRAS(3),NC)
      EQUIVALENCE (IRAS(4),NRX), (IRAS(5),NRY)
C     ..
      SAVE
C     .. Data statements ..
      DATA PSISTR/'PSIX','PSIY','PSIZ','DIV ','DIVH','DIVV'/
      DATA AWELIMIT/2.0/
C     ..
C     
C     
      IDDUM = 0
      DPOWDER = .FALSE.
      LPOSTREF = .FALSE.
      LLAST = .FALSE.
      MATCH = .TRUE.
      FAIL = .FALSE.
      FORCE = .FALSE.
      LIST = .FALSE.
      PRECESS = .FALSE.
      LPROFILE = .FALSE.
      INTERPOL = .FALSE.
      RESCAN = .TRUE.
      REFETA = .FALSE.
      LMULTISEG = .FALSE.
      INTCHK = .FALSE.
C     
C     aelimit=20.
C     armslim=20.
C     
      PI = ATAN(1.0)*4.0
      DTOR = PI/180.0
C     
C     
C---- Convert phi to psi
C     
      PHIAV = (PHIBEG+PHIEND)*0.5 + DELPHI(3)
C     
C     **************************
      CALL PHITOPSI(DELPHI,PSI,PHIAV)
C     **************************
C     
C---- Save these psi and starting delphi values
C     
      DO 10 I = 1,3
        XDELPHI(I) = DELPHI(I)
        SDELPHI(I) = DELPHI(I)
        SPSI(I) = PSI(I)
 10   CONTINUE
C     
C     
      SETA = ETA
      SDIVH = DIVH
      SDIVV = DIVV
C     
C     
      IF (DEBUG(30)) THEN
        IF (ONLINE) WRITE (ITOUT,FMT=6000) DELPHI,PSI,PHIAV,2*ETA/DTOR,
     +       2*DIVH/DTOR,2*DIVV/DTOR
 6000   FORMAT ('  Entering AUTOMATCH',/1X,'DELPHI ',3F6.2,5X,'DELPSI ',
     +       3F6.2,5X,'PHIAV ',F6.2,' ETA ',F6.3,' DIVH,V ',2F6.3)
        WRITE (IOUT,FMT=6000) DELPHI,PSI,PHIAV,2*ETA/DTOR,
     +       2*DIVH/DTOR,2*DIVV/DTOR
      END IF
C     
C---- Do initial call to set up standard profiles and to RMAXR to
C     calculate box sizes, as these are needed by NEXT. For IP data,
C     only need to do this once, but for film data the position of
C     the direct beam in the digitised image can vary from one
C     pack to the next, so need to set it up for every pack.
C     (Same will be true for IP data from an offline scanner)
C     
      IF (.NOT.IMGP) THEN
        CALL PRSETUP
        ierr = 0
C     ***********************
        IF (FIRSTFILM) CALL RMAXR(LIMIT,THICK,IERR)
C     ***********************
      ELSE
        IF (FIRSTFILM.AND.NUMBLOCK.EQ.1) THEN
          CALL PRSETUP
          CALL RMAXR(LIMIT,THICK,IERR)
        END IF
      END IF
C     
C---- Skip centrs if in mode 2 operation
C     
      IF (.NOT.NOCENT)THEN
C     
C---- Initialise variables for centrs
C     
        PARTLS = .TRUE.
        OVRLDS = .TRUE.
        GENLIST = .FALSE.
        MINREF = 8
        LPTMIN = 0.1
C     
C---- Test if oscillation range is large enough to get
C     sufficient overlap of calculated patterns and real
C     pattern with missetting equal to the desired range of
C     convergence
C     
        OSCRANGE = ABS(PHIEND-PHIBEG)
        IF (OSCRANGE.GT.360.0) OSCRANGE = OSCRANGE - 360.0
C     
C     
C---- Calculate resolution based on 'limit'
C     
      ENDIF
C     ..
C     .. REP_20 means repeat the block starting at the now non-existent
C     label 20, REP_40 at label 40.
      REP_20 = .TRUE.
      REP_40 = .TRUE.
      DO 260 WHILE(REP_20.OR.REP_40)

        IF(.NOT.NOCENT)THEN
          IF(REP_20)THEN
            REP_20 = .FALSE.
            R = LIMIT*1.4142
            IF (VEE) R = SQRT(LIMIT**2+VLIM**2)
            TH = ATAN(R/XTOFD)*0.5
            RESOL = 0.5*WAVE/SIN(TH)
            IF (OSCRANGE.LT. (RCONV+OVRLAP)) THEN
C     
C---- Not enough overlap, regenerate with increased mosaic spread
C     
              ETANEW = (RCONV+OVRLAP) - OSCRANGE
C     
              IF (ONLINE) WRITE (ITOUT,FMT=6002) OSCRANGE,RCONV,OVRLAP,
     +             ETANEW
 6002         FORMAT (/,' OSC Range of ',F5.1
     $             ,' Degrees is TOO SMALL to give '
     $             ,'a radius of convergence'/,1X,'of',F5.2
     $             ,' degrees with an',' overlap of',F6.1,' degrees.',
     $             /1X,'ETA increased to',F5.2,' degrees')
              WRITE (IOUT,FMT=6002) OSCRANGE,RCONV,OVRLAP,ETANEW
            ELSE
              ETANEW = SETA/DTOR
            END IF
C     
            IFLAG = 0
C     
C     ***********************************
            CALL NEWLIST(ETANEW,PSI,PHIAV,RESOL,IFLAG,IERR)
C     ***********************************
C     
C---- Now run centrs to locate spots in central region of film
C     note that fulls and partials will be used in centrs for the
C     first (low resolution) pass
C     
C     
C---- Store DELPHI values used at CENTRS time
C     
          ENDIF
 40       CONTINUE
          REP_40 = .FALSE.
          REPEAT = .TRUE.
          DO 100 WHILE(REPEAT)
            REPEAT = .FALSE.
C     
C     
            DO 50 I = 1,3
              XDELPHI(I) = DELPHI(I)
 50         CONTINUE
C     
C---- Now do CENTRS refinement
C     
            DO 70 ICYC = 1,NCYCA
              FINAL = (ICYC.EQ.NCYCA)
              IF (ONLINE) THEN
C     
C     
                WRITE (ITOUT,FMT=6004) ICYC
 6004           FORMAT (/,' Refinement Cycle',I3)
              END IF
C     
C     
              WRITE (IOUT,FMT=6004) ICYC
C     
C---- In centrs, the background definition of the measurement box
C     is not used to determine the centre of gravity (the c of g over
C     the whole measurement box is calculated...this gives a greater
C     range of convergence). in second and subsequent cycles, if the
C     final residual of the previous cycle is less then rmslim
C     (default value 6.0, can be changed by keyword "resid"), use the
C     same list of reflections and s/r 'next' to evaluate the true
C     c of g for these reflections
C     
              IF (RRWEIGHT) THEN
                OKREF = (WRMSRES.LE.AWRMSLIM)
              ELSE
                OKREF = (RMSRES.LE.ARMSLIM)
              END IF
              IF ((ICYC.GT.1) .AND. (OKREF) .AND.
     +             (.NOT.DOPROFILE)) THEN
                LIST = .TRUE.
C     
C---- Restore original list of reflections from CENTRS so they are 
C     all remeasured by NEXT
C     
                NRS = NRSOLD
                DO 106 I = 1,NRS
                  RRS(I) = IRSAVE(I)
 106            CONTINUE
                IF (ONLINE) WRITE (ITOUT,FMT=6006) NRS
 6006           FORMAT (/,' Repeating refinement using the same list of'
     $               ,I3,' R','eflections')
                WRITE (IOUT,FMT=6006) NRS
                USEWEIGHT = .TRUE.
                LCENTRAL = .TRUE.
C     
C     *****************************************************
                CALL NEXT(LIST,IXSHIFT,IYSHIFT,PRECESS,MATCH,IFAIL
     $               ,PARTLS,ADDPART,LCENTRAL)
C     ******************************************************
C     
              ELSE
                OLDLIST = (ICYC.NE.1)
                USEWEIGHT = .TRUE.
                IF (.NOT.USEBOX) THEN
                  USEWEIGHT = .FALSE.
C     
C---- If doing weighted refinement, set RMSLIM high so that on next
C     cycle it will use the measurement box
C     
                  IF (RWEIGHT) ARMSLIM = 100.0
                END IF
C     
C     ********************************************************
                CALL CENTRS(DOPROFILE,NSIG,IXSHIFT,IYSHIFT,NPROFL,LIMIT
     $               ,SEP,VLIM,MATCH,PARTLS,OVRLDS,MINREF,OLDLIST
     $               ,GENLIST,USEBOX,ADDPART,LPTMIN)
C     ********************************************************
                NRSOLD = NRS
C     
C---- Save this list of reflections for use in subsequent refinement
C     using
C     NEXT
C     
                DO 108 I = 1,NRS
                  IRSAVE(I) = RRS(I)
 108            CONTINUE
C     
              END IF
C     
C     
              IF (NRS.LE.MINREF) THEN
                WRITE (IOUT,FMT=6008) NRS
 6008           FORMAT (//1X,'**** ONLY',I3,' Refinement spots found,',
     &               ' Processing Refinement spots found, Processing',
     &               ' abandoned ***') 
                IF (ONLINE) WRITE (ITOUT,FMT=6008) NRS
                FAIL = .TRUE.
C     
C---- reset divergences and mosaic spread, return
C     
                ETA = SETA
                DIVH = SDIVH
                DIVV = SDIVV
                RETURN
              ENDIF
C     
C---- Refinement
C     
 60           CONTINUE
              TEMP = DISPLAY
C     
C---- In centrs, only spots within 'limit' 10 micron units (default 25mm
C     )
C     of film centre are used except for vee when 'vlim' (default 40mm)
C     is the limit.
C     these limits can be changed by keywords 'limit' and 'vlimit' or
C     in centrs if all central reflections are overloads.
C     
              DISPLAY = LIMIT/100.0
              IF (VEE) DISPLAY = VLIM/100.0
C     
              DISPLAY = TEMP
              CENTRE = .TRUE.
C     
C     
              IF (VEE) THEN
C     
              ELSE
C     
                RRWEIGHT = (RWEIGHT.AND.USEWEIGHT)
C     ******************************************
                CALL RDIST(CENTRE,FINAL,AWELIMIT,AELIMIT,AELIMIT2
     $               ,AELIMIT3,BADSTART,RRWEIGHT,REFREJ)
C     ******************************************
C     
              END IF
C     
C     
              CENTRE = .FALSE.
 70         CONTINUE
C     
C---- End of loop over refinement cycles
C     
            LRESID = .FALSE.
            IF (RWEIGHT) THEN 
              IF (WRMSRES.LT.AWRMSLIM) THEN
                LRESID = .TRUE.
              ENDIF
            ELSE
              IF (RMSRES.LT.ARMSLIM) THEN
                LRESID = .TRUE.
              ENDIF
            END IF
            IF(.NOT.LRESID)THEN
C     
C---- If online, optionall call filmplot
C     
              IF (ONLINE) THEN
     &             
C     
                IF (RWEIGHT) THEN
                  WRITE (ITOUT,FMT=6011) AWRMSLIM
                  IF (BRIEF) WRITE (IBRIEF,FMT=6011) AWRMSLIM
 6011             FORMAT(1X,'Weighted residual is GREATER than limit (',
     &                 F5.1,')',/,1X,'Set by RESID on AUTOMATCH card',/,
     &                 1X,'Do you want to proceed anyway (Y/N)? ')
                ELSE
                  WRITE (ITOUT,FMT=6010) ARMSLIM
                  IF (BRIEF) WRITE (IBRIEF,FMT=6010) ARMSLIM
 6010             FORMAT ('  Residual is GREATER than limit (',F5.1,')',
     +                 /1X,'Set by RESID on AUTOMATCH card',/,1X,'Do y',
     +                 'ou want to proceed anyway (Y/N)? ')
                END IF
C     
C     **********
                CALL YESNO(YES)
C     **********
C     
                PROCEED = .FALSE.
                IF (YES) THEN
                  PROCEED = .TRUE.
                ELSE
                  WRITE (ITOUT,FMT=6012)
 6012             FORMAT ('  Do you want to repeat refinement (Y/N) ? ')
C     
C     **********
                  CALL YESNO(YES)
C     **********
C     
                  IF (YES) THEN
                    REPEAT = .TRUE.
C     GO_TO 40
                  END IF
                END IF
              END IF
              IF(.NOT.PROCEED.AND..NOT.REPEAT)THEN
                FAIL = .TRUE.
                IF (RWEIGHT) THEN
                  WRITE(IOUT,FMT=6015) AWRMSLIM
                  IF (ONLINE) WRITE(ITOUT,FMT=6015) AWRMSLIM
 6015             FORMAT(//1X
     $                 ,'Residual following refinement is greater '
     $                 ,'than ',F6.1,' (subkeyword RESID on AUTO)',
     $                 /,1X,'Processing abandoned')
                ELSE
                  WRITE(IOUT,FMT=6017) ARMSLIM
                  IF (ONLINE) WRITE(ITOUT,FMT=6017) ARMSLIM
 6017             FORMAT(//1X
     $                 ,'Residual following refinement is greater '
     $                 ,'than ',F6.1,' (subkeyword RESID on AUTO)',
     $                 /,1X,'Processing abandoned')
                END IF
C     
C---- reset divergences and mosaic spread, return
C     
                ETA = SETA
                DIVH = SDIVH
                DIVV = SDIVV
                RETURN
C     
C---- If centrs has already been repeated due to poor initial residual
C     do not allow a second repeat.
C     
              ENDIF
            ENDIF
            IF(.NOT.REPEAT)THEN
              PROCEED = .FALSE.
              IF (BADSTART)THEN
                PROCEED = .TRUE.
              ENDIF
              IF(.NOT.PROCEED)THEN
                IF (RWEIGHT) THEN
                  BADSTART = (WESTART.GT.AWELIMIT)
                  XLIMIT = AWELIMIT
                ELSE
                  BADSTART = (ESTART.GT.AELIMIT)
                  XLIMIT = AELIMIT
                END IF
C     
C---- Repeat centrs if initial residual high
C     
                IF (BADSTART) THEN
                  WRITE (IOUT,FMT=6016) XLIMIT
 6016             FORMAT (/
     $                 ,' Repeat refinement because initial residual is'
     $                 ,' GREATER than',F5.1)
                  IF (ONLINE) WRITE (ITOUT,FMT=6016) XLIMIT
                  REPEAT = .TRUE.
                END IF
C     
C---- Centrs refinement successful
C     update psix by the refined value of (ccomega-trueccom)
C     and adjust the value of OMEGA0 to reflect the change is PSIX
C     Remember only SINOM0, COSOM0 carried in common ORI
C     
              ENDIF
            ENDIF
 100      ENDDO
          IF (.NOT.NOREFINE)THEN
            IF (ONLINE) WRITE (ITOUT,FMT=6018) PSI,DELPHI
 6018       FORMAT (/,' Starting orientation refinement',/1X,
     $           'Initial MISSE','TTING Angles ',/1X,'in PSI',
     $           3F8.3,/1X,'in PHI',3F8.3)
            WRITE (IOUT,FMT=6018) PSI,DELPHI
            PSI(1) = PSI(1) + (CCOM - TRUECCOM)
            SPSI(1) = PSI(1)
            SHPSI(1) = CCOM - TRUECCOM
            OMEGA0 = ATAN2(SINOM0,COSOM0) - (CCOM - TRUECCOM)*DTOR
            SINOM0 = SIN(OMEGA0)
            COSOM0 = COS(OMEGA0)
            CCOM = TRUECCOM
          ENDIF
C     
C---- Now generate the big list of reflections to be used
C     in the pattern matching. the mosaic spread is increased
C     to give the specified radius of convergence 'rconv'
C     
        ENDIF
C     .. 
C        REP_110 = .TRUE.
C     Go through this block again if we are repeating the refinement
C     for the beam divergence.
C     
        AGAIN = .TRUE.
        DO 250 WHILE (AGAIN)
C          REP_110 = .FALSE.
          BIGSHIFT = .FALSE.
          AGAIN = .FALSE.
          ETANEW = 2*RCONV
          IFLAG = 0
C     
C---- If refining divergences, set appropriate ETANEW and IFLAG
C     If not refining orientation, start with divergence refinement
C     
          IF (RMOSAIC.AND.NOREFINE) REFETA = .TRUE.
          IF (REFETA) THEN
            ETANEW = ETAMAX
            IFLAG = 4
C     
C---- Must set ETA to zero, so that total (beam divergence + mosaic
C     spread)
C     increases from zero
C     
            ETA = 0.0
          END IF
C     
C     ************************************
          CALL NEWLIST(ETANEW,PSI,PHIAV,RESOL1,IFLAG,IERR)
C     ************************************
C     
          IF (DEBUG(31)) THEN
            NPR = MIN(NSPOT,30)
            IF (ONLINE) WRITE (ITOUT,FMT=6020) (I,XG(I),YG(I),I=1,NPR)
 6020       FORMAT (/,' Coordinates of reflections from REEKE',
     +           / (1X,I3,3X,2F7.1))
            WRITE (IOUT,FMT=6020) (I,XG(I),YG(I),I=1,NPR)
          END IF
C     
C---- Measure intensities of all reflections in the big list
C     first convert film coordinates to sorted scanner coordinates
C     
          MAXR = 1000
          MODE = 6
C     
C     *****************************************************
          CALL GENSORT(MODE,FORCE,LIMIT,VLIM,NRM,ADDPART,LPTMIN,LLAST)
C     *****************************************************
C     
          NBIG = NRM
          WRITE (IOUT,FMT=6022) SHPSI(1),TRUECCOM
 6022     FORMAT ('  PSIX changed by',F6.2,' Degrees and CCOMEGA set to'
     $         ,F6.3)
          IF (ONLINE) WRITE (ITOUT,FMT=6022) SHPSI(1),TRUECCOM
C     
C     
          IF (DEBUG(30)) THEN
            IF (ONLINE) WRITE (ITOUT,FMT=6024) NSPOT,ETANEW,RESOL1,NRM
 6024       FORMAT (/1X,I5,' Spots generated in big list with ETA=',F5.2
     &           ,' O','ut to',F5.1,' Angstroms',/1X,I5
     &           ,' of these selected by G','ENSORT')
            WRITE (IOUT,FMT=6024) NSPOT,ETANEW,RESOL1,NRM
          END IF
C     
C---- Now measure reflections
C     
C     *******************************************************
          IERR = 0
          CALL MEAS(MAXR,LPROFILE,INTERPOL,IXSHIFT,IYSHIFT,ADDPART,
     +         LPOSTREF,IDDUM,LMULTISEG,lastrec,NEWPREF,NUSPOT,IERR)
C     *******************************************************
C     
          IF (DEBUG(31)) THEN
            NPR = MIN(NRM,30)
            IF (ONLINE) WRITE (ITOUT,FMT=6026) (I,XREF(I),YREF(I),I=1
     $           ,NPR)
 6026       FORMAT (/,' Coordinates after storing in XREF,YREF',
     +           / (1X,I3,3X,2I6))
            WRITE (IOUT,FMT=6026) (I,XREF(I),YREF(I),I=1,NPR)
          END IF
C     
C---- Now the fun bit.
C     reset mosaic spread to its correct value.
C     vary first psiz from -rconv to +rconv in steps of
C     rconv/nstep. for each value of psiz, calculate a
C     new reflection list, and go through the big list
C     and pick up the intensity and sd for these reflections.
C     print statistics on number and intensity of
C     reflections lost and gained.
C     repeat the whole procedure varying psiy at the optimum
C     value of psiz.
C     if necessary, iterate the procedure.
C     If refining mosaic spread, then increase divergence(s) from 0
C     to ETAMAX in (2*NSTEP+1) steps
C     
          ETANEW = 0.0
          DELPSI = RCONV/NSTEP
C     
C---- Set error limits for matching reflections to half box size
C     
          IDELX = IRAS(1)*0.5
          IDELY = IRAS(2)*0.5
          IF (REFETA) THEN
            IDELX = (IRAS(1)-2*IRAS(4))*0.5 + 1
            IDELY = (IRAS(2)-2*IRAS(5))*0.5 + 1
          END IF
C     
C     
          DO 120 I = 2,3
            SHPSI(I) = 0.0
 120      CONTINUE
C     
C---- For divergence refinement, set number of passes to number of
C     parameters being refined
C     
          IF (REFETA) THEN
            NPASS = 1
            DELETA = ETAMAX/(2*NSTEP)
          END IF
C     ..
C     .. loop around mosaicity estimation (REPEST = REPeat ESTimation),
C     but we need to go through here anyway, which is why we can't just
C     test for MOSEST.
          REPEST = .TRUE.
          DO 225 WHILE (REPEST)
            REPEST = .FALSE.
            DO 220 IPASS = 1,NPASS
C     
C     
              IF (REFETA) THEN
                WRITE (IOUT,FMT=6027)
 6027           FORMAT (/1X,'Beam divergence refinement') 
                IF (ONLINE) WRITE (ITOUT,FMT=6027)
              ELSE
                WRITE (IOUT,FMT=6028) IPASS
 6028           FORMAT (/1X,'Orientation refinement pass',I3)
                IF (ONLINE) WRITE (ITOUT,FMT=6028) IPASS
C     
C---- Decrease delpsi by factor damp on each pass
C     
                IF (IPASS.NE.1) DELPSI = DELPSI*DAMP
                ETANEW = DELPSI*NSTEP*0.5
              END IF
C     
C     
              DO 210 IYZ = 3,2,-1
C     
C---- Only one parameter (IYZ) if only one beam divergence being refined
C     
                IF (.NOT.REFETA.OR.(NBEAM.NE.1).OR.(IYZ.EQ.3))THEN
                  INTMAX = 0
C     
C     
                  IF (IYZ.EQ.3) THEN
                    SECT = 0.0
                  ELSE
                    SECT = 90.0
                  END IF
C     
C     
                  JSTEP = 0
                  IF (REFETA) ETANEW = -DELETA
C     
C     
                  DO 140 ISTEP = -NSTEP,NSTEP
                    JSTEP = JSTEP + 1
                    IF (REFETA) THEN
C     
C---- Divergence refinement
C     
                      ETANEW = ETANEW + DELETA
                      ETASTEP(JSTEP) = ETANEW
                      IF (NBEAM.EQ.1) THEN
                        IFLAG = 4
                      ELSE
                        IFLAG = 3 + IYZ
                      END IF
                    ELSE
C     
C---- Orientation refinement
C     
                      PSI(IYZ) = SPSI(IYZ) + ISTEP*DELPSI
                      IFLAG = IYZ
                    END IF                          
C     
C     **************************************
                    CALL NEWLIST(ETANEW,PSI,PHIAV,RESOL1,IFLAG,IERR)
C     **************************************
C     
                    IF (DEBUG(31)) THEN
                      NPR = MIN(NSPOT,30)
                      IF (ONLINE) WRITE (ITOUT,FMT=6020) (I,XG(I),YG(I),
     &                     I=1,NPR)
                      WRITE (IOUT,FMT=6020) (I,XG(I),YG(I),I=1,NPR)
                    END IF
C     
C---- Flag reflections outside required sector (secangle around
C     sect=0 for psiz, around sect=90 for psiy refinement.
C     
C     *******************************
                    CALL SECTOR(SECT,SECANGLE,NSPOT,NRJ)
C     *******************************
C     
C---- Match reflections in small list to those in big list
C     
C     ****************************************************
                    CALL REFLMATCH(INT,FVAR,NBIG,NSPOT,NM,IDELX,IDELY
     $                   ,FORCE,LIMIT,VLIM,JSTEP,INTGAIN,ISDGAIN,INTLOST
     $                   ,ISDLOST,NGAIN,NLOST,ADDPART,LPTMIN,IERR2)
C     ****************************************************
C---- Check if error return due to too many spots lost/gained, change
C     resolution limit and do it again from automatch, but only three
C     times. 
C     
                    IF((IERR2.GE.1000).AND.(IERR2.LE.1002))THEN
                      IERR = IERR2
                      RETURN
                    ENDIF
                    NGL(ISTEP) = NGAIN + NLOST
                    IGN(ISTEP) = INTGAIN
                    ISDGN(ISTEP) = ISDGAIN
                    ILO(ISTEP) = INTLOST
                    ISDLO(ISTEP) = ISDLOST
                    INTTOT(ISTEP,IYZ) = INT/100
                    ISDTOT(ISTEP,IYZ) = SQRT(0.0001*FVAR)
                    MEANINT = 0
                    IF (NM.NE.0) MEANINT = INT/NM
C     
C     
                    IF (DEBUG(30)) THEN
                      IF (ONLINE) WRITE (ITOUT,FMT=6030) IYZ,ISTEP,PSI,
     $                     NSPOT,RESOL1,NM,IDELX,IDELY,INT,MEANINT,
     $                     SECANGLE,SECT,NRJ
 6030                 FORMAT (1X,'VARY PSI',I2,' ISTEP',I3,/,1X,'PSI',
     &                     3F8.2,' NSPOT',I5,' RESOL1',F5.1,' NMATCH',I5
     $                     ,' DX,DY',2I5,/1X,'Total ','intensity',I12
     $                     ,' Mean intensityper spot',I8,/,1X
     $                     ,'Number rejected by sector angleof',F5.1
     $                     ,' Degrees at PSI=',F5.0, ' is',I5)
                      WRITE (IOUT,FMT=6030) IYZ,ISTEP,PSI,NSPOT,RESOL1
     $                     ,NM,IDELX,IDELY,INT,MEANINT,SECANGLE,SECT,NRJ
                    END IF
C     
C     
                    IF (INT.GE.INTMAX)THEN
                      INTMAX = INT
                      IS = ISTEP
                    ENDIF
 140              CONTINUE
C     
C---- Don't attempt to find optimum for mosaic spread refinement
C     
                  IF (.NOT.REFETA)THEN
C---- Now find the best match. starting at the maximum intensity,
C     work outwards to find the two points where there is a
C     significant (gt. 15*sigma) change in the gained/lost
C     intensities.
C     
                    ISTEP = IS + 1
                    ILOST = 0
                    VAR = 0.0
                    SDLO = 99999.99
                    DO 150 WHILE((ISTEP.LE.NSTEP).AND.
     $                   (FLOAT(ILOST).LE.15.0*SDLO))
                      IF (ISTEP.LE.NSTEP) THEN
                        ILOST = ILO(ISTEP) + ILOST
                        VAR = FLOAT(ISDLO(ISTEP)) * 
     $                       FLOAT(ISDLO(ISTEP)) + VAR
                        SDLO = SQRT(VAR)
                        IF (DEBUG(30)) THEN
                          WRITE(IOUT,FMT=6031) ISTEP,ILO(ISTEP),
     $                         ISDLO(ISTEP),IGN(ISTEP),ISDGN(ISTEP),
     $                         ILOST,SDLO
 6031                     FORMAT(1X,'ISTEP=',I2,' intensity lost and sd'
     $                         ,I6,I4,'  Intensity gained and sd',I6,I4,
     $                         /,1X,'Total intensity lost and sd',I6,F5
     $                         .0)
                          IF (ONLINE) WRITE(ITOUT,FMT=6031) ISTEP,
     $                         ILO(ISTEP),ISDLO(ISTEP),IGN(ISTEP),
     $                         ISDGN(ISTEP),ILOST,SDLO
                        END IF
                      ENDIF
                      ISTEP = ISTEP + 1
 150                ENDDO
C     
C---- Significant point found stepping positive, now go negative
C     
                    ISPOS = ISTEP
                    ISTEP = IS
                    VAR = 0.0
                    IGAIND = 0
                    SDGN = 99999.99
                    DO 170 WHILE((ISTEP.GE.- (NSTEP-1)).AND.
     $                   (FLOAT(IGAIND).LE.15.0*SDGN))
                      IGAIND = IGN(ISTEP) + IGAIND
                      VAR = FLOAT(ISDGN(ISTEP)*ISDGN(ISTEP)) + VAR
                      SDGN = SQRT(VAR)
                      IF (DEBUG(30)) THEN
                        WRITE(IOUT,FMT=6031) ISTEP,ILO(ISTEP)
     $                       ,ISDLO(ISTEP),IGN(ISTEP),ISDGN(ISTEP),ILOST
     $                       ,SDLO
                        IF (ONLINE) WRITE(ITOUT,FMT=6031) ISTEP
     $                       ,ILO(ISTEP),ISDLO(ISTEP),IGN(ISTEP)
     $                       ,ISDGN(ISTEP),ILOST,SDLO
                      END IF
                      ISTEP = ISTEP - 1
 170                ENDDO           
                  ENDIF
C     
C---- Find  median
C     
                  ISNEG = ISTEP - 1
                  X = (ISPOS+ISNEG)*0.5
C     
C---- Scale INTTOT if necessary
C     
                  SCALE = 1.0
C     IF (INTMAX.GT.9999900) SCALE = 9999900/REAL(INTMAX)
                  IF(INTMAX.NE.0)SCALE = 9999900/REAL(INTMAX)
C     
C---- Next bit for mosaicity estimation only 
C     
                  IF(MOSEST)THEN
C     
C---- work out slope etc here
C     
                    SIGX = 0.0
                    SIGY = 0.0
                    SIGXY = 0.0
                    SIGX2 = 0.0
                    DO 3 ISTEP=NSTEP-5,NSTEP
                      SIGX = SIGX + ETASTEP(ISTEP+NSTEP)
                      SIGY = SIGY + NINT(SCALE*INTTOT(ISTEP,IYZ))
                      SIGXY = SIGXY + (ETASTEP(ISTEP+NSTEP)*
     $                     NINT(SCALE*INTTOT(ISTEP,IYZ)))
                      SIGX2 = SIGX2 + 
     $                     (ETASTEP(ISTEP+NSTEP)*ETASTEP(ISTEP+NSTEP))
c     PRINT*,ISTEP,ETASTEP(ISTEP+NSTEP),NINT(SCALE*INTTOT(ISTEP,IYZ))
 3                  ENDDO
                    SLOPE = MAX(0.0,((SIGX*SIGY)-(6*SIGXY))/
     $                   ((SIGX*SIGX)-(6*SIGX2)))
C     INTERCEPT = ((SIGX*SIGXY)-(SIGX2*SIGY))/
C     $              ((SIGX*SIGX)-(11*SIGX2))
C     
C---  end of slope calculations
C     
                    INTMIN = NINT((SCALE*INTTOT(-NSTEP,IYZ)/8.0)+
     $                   (700000.0/8.0))
                    DO 1342 III=1,2*NSTEP+1
C     PRINT*,NINT(SCALE*INTTOT(III-1-(NSTEP),IYZ)
C     $        +(ETASTEP(III)*SLOPE))
                      IF(INTMIN.LT.NINT(SCALE*INTTOT(III-1-(NSTEP),IYZ)
     $                     +(ETASTEP(III)*SLOPE)).AND.
     $                     (.NOT.INTCHK))THEN
C     
C---  linear interpolation to give estimate of mosaicity

                        MOSNEW =  ETASTEP(III-1)+ETASTEP(2)*
     $                       (INTMIN-NINT(SCALE*
     $                       INTTOT(III-2-(NSTEP),IYZ)))/
     $                       (NINT(SCALE*INTTOT(III-1-(NSTEP),IYZ)-
     $                       (NINT(SCALE* 
     $                       INTTOT(III-2-(NSTEP),IYZ)))))
                        MOSNEW = (NINT(MOSNEW * 100.0))/100.0
                        INTCHK = .TRUE.
                      ENDIF
 1342               ENDDO
                  ENDIF
C     
C---- if the mosaicity is largish, we need to expand the range that we
C     test.
C     Only do this up to 4 degrees!
C     
                  IF(MOSNEW.GT.0.4*ETAMAX.AND.MOSEST.AND.
     $                 ETAMAX.LT.4.0)THEN
                    ETAMAX = ETAMAX*2.0
                    DELETA = DELETA*2.0
                    INTCHK = .FALSE. 
                    REPEST = .TRUE.
                  ELSE
                    IF(ETAMAX.GE.4.0)MOSNEW = 999.0
                    MOSEST = .FALSE.
C     
C---- must set INTCHK anyway
C     
                    INTCHK = .TRUE.
                    IF (ONLINE) THEN
                      IF (REFETA) DELPSI = DELETA
                      WRITE (ITOUT,FMT=6032) PSISTR(IFLAG),DELPSI
 6032                 FORMAT (/,' Refining ',A,' with stepsize',F6.2
     $                     ,' Degrees')
                      IF (REFETA) THEN
                        WRITE(ITOUT,FMT=6037) (ETASTEP(JSTEP),
     +                       JSTEP=1,2*NSTEP+1)
                        WRITE(ITOUT,FMT=6039) (NGL(ISTEP),ISTEP=-NSTEP,
     $                       NSTEP)
                      ELSE
                        WRITE(ITOUT,FMT=6033) (ISTEP,ISTEP=-NSTEP,
     $                       NSTEP)
                        WRITE(ITOUT,FMT=6034) (NGL(ISTEP),ISTEP=-NSTEP,
     $                       NSTEP)
                      END IF
                      WRITE(ITOUT,FMT=6035) (NINT(SCALE*INTTOT(ISTEP,IYZ
     $                     )),ISTEP = -NSTEP,NSTEP)
                      WRITE(ITOUT,FMT=6036) (NINT(SCALE*ISDTOT(ISTEP,IYZ
     $                     )),ISTEP = -NSTEP,NSTEP)
 6033                 FORMAT(1X,'Step number    ',19I6)
 6037                 FORMAT(1X,'Divergence     ',19F6.3)
 6034                 FORMAT(1X,'No gained/lost ',19I6)
 6039                 FORMAT(1X,'No gained      ',19I6)
 6035                 FORMAT(1X,'Total intensity',19I6)
 6036                 FORMAT(1X,'SD of intensity',19I6)
                    ENDIF
                    IF(DEBUG(30))THEN
                      write(iout,*)'here are the values'
                      write(iout,fmt=666)(ETASTEP(ISTEP+NSTEP+1),
     +                     NINT(SCALE*INTTOT(ISTEP,IYZ)), 
     +                     ISTEP = -NSTEP,NSTEP)
 666                  format(F8.3,1X,I6)
                    endif
C     
C     
                    IF (.NOT.REFETA) WRITE (ITOUT,FMT=6038) IS,X
     $                   ,PSISTR(IFLAG),SPSI(IYZ),SPSI(IYZ) + X*DELPSI,X
     $                   *DELPSI
 6038               FORMAT (/,' Optimum step number is ',I3
     $                   ,' Median shift',F5.1,/1X,A,' Old value ',
     $                   F7.2,' New value ',F7.2,'  SHIFT',F6.2)
C     
C     
                    WRITE (IOUT,FMT=6032) PSISTR(IFLAG),DELPSI
                    IF (REFETA) THEN
                      WRITE(IOUT,FMT=6037) (ETASTEP(JSTEP),
     +                     JSTEP=1,2*NSTEP+1)
                      WRITE(IOUT,FMT=6039) (NGL(ISTEP),ISTEP = -NSTEP
     $                     ,NSTEP)
                    ELSE
                      WRITE(IOUT,FMT=6033) (ISTEP,ISTEP = -NSTEP,NSTEP)
                      WRITE(IOUT,FMT=6034) (NGL(ISTEP),ISTEP = -NSTEP
     $                     ,NSTEP)
                    END IF
                    WRITE(IOUT,FMT=6035) (NINT(SCALE*INTTOT(ISTEP,IYZ))
     $                   ,ISTEP = -NSTEP,NSTEP)
                    WRITE(IOUT,FMT=6036) (NINT(SCALE*ISDTOT(ISTEP,IYZ)),
     +                   ISTEP = -NSTEP,NSTEP)
C     
C     
                    IF (.NOT.REFETA) THEN
                      WRITE (IOUT,FMT=6038) IS,X,PSISTR(IYZ),
     +                     SPSI(IYZ),SPSI(IYZ) + X*DELPSI,X*DELPSI
C     
C---- Update psi angle to optimum value
C     
                      SPSI(IYZ) = SPSI(IYZ) + X*DELPSI
                      SHPSI(IYZ) = SHPSI(IYZ) + X*DELPSI
                      PSI(IYZ) = SPSI(IYZ)
                    ENDIF
                  ENDIF
                ENDIF
 210          CONTINUE
C     
C---- End of loop over two psi angles OR divergences
C     
 220        CONTINUE
 225      ENDDO
C     
C---- End of loop over passes
C     
          IF (REFETA)THEN
C     
C---- reset divergences, resolution and mosaic spread and return
C     
            ETA = SETA
            DIVH = SDIVH
            DIVV = SDIVV
            DSTMAX = DSTMAXS
            RETURN
          ELSE
C     
C---- Convert psi to phi
C     
C     ****************************
            CALL PSITOPHI(SPSI,RDELPHI,PHIAV)
C     ****************************
C     
            IF (ONLINE) WRITE (ITOUT,FMT=6040) SPSI,RDELPHI
 6040       FORMAT (/,' FINAL Refined Missetting angles ',/1X,'in PSI',
     $           3F8.3,/1X,'in PHI',3F8.3)
            WRITE (IOUT,FMT=6040) SPSI,RDELPHI
C     
C---- Update stored DELPHI values
C     
            DO 230 I = 1,3
              DELPHI(I) = RDELPHI(I)
 230        CONTINUE
C     
C---- If shift in psix or psiy gt 0.6 degrees or rconv/2
C     or if the sum of the three shifts is greater than
C     1.5 degrees or rconv/2, then
C     repeat centrs and refinement at this resolution.
C     
            SHIFTM = MAX(SHPSI(1),SHPSI(2))
            SHIFTT = ABS(SHPSI(1)) + ABS(SHPSI(2)) + ABS(SHPSI(3))
            SHMAXM = MIN(0.5*RCONV,0.75)
            SHMAXT = MIN(0.5*RCONV,1.5)
C     
C     
            IF ((SHIFTM.GE.SHMAXM) .OR. (SHIFTT.GT.SHMAXT)) THEN
              IF (ONLINE) WRITE (ITOUT,FMT=6044) SHIFTM,SHIFTT,SHMAXM,
     $             SHMAXT
 6044         FORMAT (/,' MAX Shift in PSIX,PSIY of',F6.2,' or TOTAL ',
     &             'Shift of',F6.2,' Degrees is greater than allowed ',
     &             'limits of ',F6.2,' and',F6.2,' Degrees',/1X,'Repe',
     &             'at refinement using new orientation')
              WRITE (IOUT,FMT=6044) SHIFTM,SHIFTT,SHMAXM,SHMAXT
              BIGSHIFT = .TRUE.
            END IF
            IF(.NOT.BIGSHIFT)THEN
C     
C---- Repeat at higher resolution if required
C     
              IF ((RESOL2.NE.0.0) .AND. (RESOL2.NE.RESOL1)) THEN
C     
C---- Assume current solution is correct to within 2.0 steps
C     
                IF (ONLINE) WRITE (ITOUT,FMT=6046) RESOL2
 6046           FORMAT (//1X,'Repeat orientation refinement with ', 
     $               'resolution extended to ',F5.1,' Angstroms')
                WRITE (IOUT,FMT=6046) RESOL2
                RCONV = 2.0*DELPSI
                RESOL1 = RESOL2
C     
C---- If total shift is greater than 0.25 degrees, since last CENTRS
C     repeat CENTRS
C     
                SHIFT = 0.0
C     
C     
                DO 240 I = 1,3
                  SHIFT = ABS(RDELPHI(I)-XDELPHI(I)) + SHIFT
 240            CONTINUE
C     
C     
                IF (SHIFT.GT.0.25 .AND. (.NOT.NOCENT)) THEN
C     
C---- Calculate resolution based on 'limit'
C     
                  R = LIMIT*1.4142
                  IF (VEE) R = SQRT(LIMIT**2+VLIM**2)
                  TH = ATAN(R/XTOFD)*0.5
                  R = 0.5*WAVE/SIN(TH)
                  IYZ = 0
                  ETANEW = RCONV
C     
C     *******************************
                  CALL NEWLIST(ETANEW,PSI,PHIAV,R,IYZ,IERR)
C     *******************************
C     
                  IF (ONLINE) WRITE (ITOUT,FMT=6048) SHIFT
 6048             FORMAT (/,' Total shift of',F6.2,
     $                 ' Degrees requires NEW CENTRS ','Refinement')
                  WRITE (IOUT,FMT=6048) SHIFT
C     
C     
                  IF (DEBUG(30)) THEN
                    IF (ONLINE) WRITE (ITOUT,FMT=6050) NSPOT,ETANEW,R
 6050               FORMAT (1X,I5,
     $                   ' Reflections generated with MOSAIC SPREAD ',
     $                   'set to',F5.2,' To resolution limit of',F5.1,
     $                   ' Angstroms')
                    WRITE (IOUT,FMT=6050) NSPOT,ETANEW,R
                  END IF
C     
C---- Initialise variables. Still have to allow partials because
C     enlarged mosaic spread means that there may not be enough
C     fully recorded reflections in central region
C     
                  PARTLS = .TRUE.
                  MINREF = 20
                  REP_40 = .TRUE.
                  REP_20 = .FALSE.
                ELSE
C     
C---- Do not repeat CENTRS if shift less than 0.25
C     
C                IF(.NOT.REP_40)THEN
                  BIGSHIFT = .TRUE.
                  AGAIN = .TRUE.
                ENDIF
              END IF
            ENDIF
C     ..
C     .. moved from above
            IF(BIGSHIFT.AND..NOT.AGAIN.AND..NOT.REP_40)THEN
              IF(NOCENT)THEN
                AGAIN = .TRUE.
              ELSE
                REP_20 = .TRUE.
              ENDIF
            ENDIF
C     
C---- Do beam divergence refinement if required
C     
            IF (RMOSAIC.AND..NOT.(REP_20.OR.REP_40)) THEN 
              BIGSHIFT = .TRUE.
              REFETA = .TRUE.
              AGAIN = .TRUE.
            END IF
C            IF(AGAIN)REP_110 = .TRUE.
C     
C---- reset divergences, resolution and mosaic spread
C     
          ENDIF
 250    ENDDO
 260  ENDDO
      ETA = SETA
      DIVH = SDIVH
      DIVV = SDIVV
      DSTMAX = DSTMAXS
C     
C     
      RETURN
      END
C== BADSPOT ==
C
      SUBROUTINE BADSPOT(IRECG,BADTOG,IERR)
C
C---- Changes status of a reflection, bad to good and vice-versa.
C     Don't allow change for overloads or off edge reflections.
C
      IMPLICIT NONE
C     ..
C     .. Scalar Arguments ..
      INTEGER IRECG,IERR
      LOGICAL BADTOG
C     ..
C     .. Array Arguments ..
C
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Local Scalars ..
      INTEGER IFLAG
C     ..
C     .. Local Arrays ..
C     ..
C     .. External Subroutines ..
      EXTERNAL GETHKL,ASUGET
C     ..
C     .. Extrinsic Functions ..
C     ..

C     .. Intrinsic Functions ..
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/gendata.f
C
C $Id: gendata.f,v 1.2 2003/01/10 16:17:53 andrew Exp $
C
C--- awk generated include file  gendata.h
C---- START of include file gendata.h
C
C     IMG       Partiality indicator. 0 for full reflections, 1 to 100
C                   for partials. Negative for partials at the start of the
C                   rotation range, +ve for partials at the end of the 
C                   rotation. Set in subroutine REEK using DELEPS calculated
C                   in subroutine DSTAR
C
C     IRG       Reflection flag  (Set by SPTEST called from DSTAR)
C               =  0  Spot can be measured
C               =  1  Outside R, X, Y limits
C               =  2  Overlapping spot (set later)
C               =  3  Too wide in phi (more than NWMAX images)
C               =  4  DST .GT. DSTMAX  Not included in final film list -
C                       used only to check for overlaps at edge of film.
C               = 10  Spot is within cusp, but will be observed...not included
C                     in final spot list but must be included in predicted
C                      pattern
C
C               =  21  Spot present on 2 images, this is 1st
C               =  22  Spot present on 2 images, this is 2nd
C
C               =  31  Spot present on 3 images, this is 1st
C               =  32  Spot present on 3 images, this is 2nd
C               =  33  Spot present on 3 images, this is 3rd
C
C               =  41  Spot present on 4 images, this is 1st
C               =  42  Spot present on 4 images, this is 2nd
C               =  43  Spot present on 3 images, this is 3rd
C               =  44  Spot present on 4 images, this is 4th
C
C                 etc etc
C
C     XG        Virtual detector X coordinate in 10 micron units, relative to
C               an origin at the direct beam position. X is parallel to the
C               Y axis in the laboratory frame, ie orthogonal to the rotation
C               axis.
C
C     YG        Virtual detector Y coordinate in 10 micron units, relative to
C               an origin at the direct beam position. Y is parallel to the
C               Z axis in the laboratory frame, ie  the rotation axis.
C
C     IX,IY     are the coordinates of the reflection in pixels
C               (integers) wrt the first pixel in the image (lower left corner
C               cameramans view). For testing for spot overlap, these
C               coordinates are in 10 micron units. Also used for display
C               pixel coordinates when displaying predicted pattern.
C
C     IREC      Pointer to the record number of a particular spot in the
C               list of generated reflections.
C
C
C     ..
C     .. Arrays in common /GENDATA/ ..
      REAL FRACG,PHIG,PHIWG,XG,YG,GOODFIT
      INTEGER INTG,IPRO,IX,IY,IREC
      INTEGER*2 IRG,IMG,IGFLAG,ISDPRO,ISDG,IHG,IKG,ILG,IMPARTG,
     +          MISYMG
C     .. Scalars in common /GENDATA/ ..
      INTEGER IPACKREC,IPACKHEAD,IRECLAST
C     ..
C     .. Common block /GENDATA/ ..
      COMMON /GENDATA/FRACG(NREFLS),PHIG(NREFLS),PHIWG(NREFLS),
     $       XG(NREFLS),YG(NREFLS),INTG(NREFLS),IPRO(NREFLS),
     $       IX(NREFLS),IY(NREFLS),IREC(NREFLS),IRG(NREFLS),IMG(NREFLS),
     +       IGFLAG(NREFLS),ISDPRO(NREFLS),ISDG(NREFLS),
     +       IHG(NREFLS),IKG(NREFLS),ILG(NREFLS),IMPARTG(NREFLS),
     +       MISYMG(NREFLS),GOODFIT(NREFLS),IPACKREC,IPACKHEAD,
     +       IRECLAST
C     ..
C
C

C&&*&& end_include  ../inc/gendata.f
C     ..
C     .. Equivalences ..
C     ..
      SAVE
C
      IERR = 0
      IF (IRECG.LE.0) RETURN
      IFLAG = IGFLAG(IRECG)
      IF ((ABS(IFLAG).EQ.32).OR.(ABS(IFLAG).EQ.64)) THEN
        IERR = ABS(IFLAG)
        RETURN
      END IF
      IF (IFLAG.LT.0) THEN
C
C---- Convert bad spot to OK
C
        IGFLAG(IRECG) = 1
        BADTOG = .TRUE.
      ELSE
C
C---- Convert good spot to bad
C
        IGFLAG(IRECG) = -128
        BADTOG = .FALSE.
      END IF
      RETURN
      END
C== BELL ==
C
C
C
      SUBROUTINE BELL
C     ===============
C
C
C
C
C     .. Local Scalars ..
      CHARACTER PING*1
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC CHAR
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C     ..
      SAVE
C     ..
C
C
      PING = CHAR(7)
      WRITE (ITOUT,FMT='(1X,A)') PING
C
C
      END
C== BESTMASK ==
      SUBROUTINE BESTMASK(OD,LRAS,NPBOX,MODE,PQSUMS,MASKREJ,BGKSIG,
     +                    IFLAG,CTOT,NRXMIN,NRYMIN,NCMIN,LTOL)
C     =================================================================
      IMPLICIT NONE
C
C---- Finds the optimum background rim and corner cutoff parameters
C     for the measurement box suppiled in OD. 
C
C     OD      the measurement box containing the pixel values (input).
C
C     LRAS    Starting raster parameters: these are updated.
C
C     NPBOX   The profile box number when called from BGREJECT (MODE=1)
C
C     MODE    =0 when called from CHKRAS, so there is no list of rejected 
C                background pixels. In this case inflate BGSIG for first
C                two cycles, then use true BGSIG
C             =1 when called from BGREJECT from PROCESS, when there is
C                a list of rejected pixels. In this case do only two
C                cycles and use true BGSIG.
C
C     MASKREJ When this subroutine is called from subroutine PROCESS to
C             optimise the standard profiles, this array initially 
C             contains the list of rejected background pixels which
C             are overlapped by neighbouring spots as calculated by MASKIT.
C             It is UPODATED to include pixels rejected from the background
C             plane fit. Note that this is 99 sigma when forming the standard
C             profiles so there should not be many !
C
C             When called by subroutine CHKRAS to optimise the average
C             spot profile for the centre of the image, there is no
C             list of rejected pixels.
C
C     PQSUMS  Contains various sums for the background pixels allowing
C             for rejected background pixels. It has been calculated in
C             MASKIT for each standard mask, but it is recalculated here
C             in calls to SETSM2, and is set to the appropriate values
C             for the optimised raster parameters and the merged pixel
C             rejection list in a final call to SETSM2
C
C     IFLAG   is returned as negative if the procedure fails. This is NOT
C             YET IMPLEMENTED (It always works !!)
C
C     CTOT    This is the background plane constant, needed for averaged
C             profiles where the background has already been subtracted.
C
C     NRXMIN  The minimum value for the X-background rim to be used in the
C             optimisation. When called from CHKRAS (avergae spot profile
C             for centre of image) this is determined by a call to PKRIM.
C             When called by BGREJECT (standard profiles) it is 1, and 
C             a call to CHECKMASK in this S/R is used to reject values.
C
C     NRYMIN  The minimum value for the Y-background rim to be used in the
C             optimisation. See NRXMIN
C
C     NCMIN  The minimum value for the corner cutoff to be used in the
C             optimisation. See NRXMIN
C
C     LTOL    is the tolerance for this profile
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      REAL BGKSIG,CTOT,LTOL
      INTEGER NPBOX,IFLAG,MODE,NRXMIN,NRYMIN,NCMIN
C     ..
C     .. Array Arguments ..
      INTEGER OD(MAXBOX),LRAS(5),MASKREJ(NREJMAX)
      REAL PQSUMS(6)
C     ..
C     .. Local Scalars ..
      INTEGER I,J,K,IDR,NREF,NREJ,NRMAX,IPT,NXX,NYY,NRXMAX,NRYMAX,
     +        IR,ISDBSI,IBEST,NRMIN,ICYC,NCMAX,ISIGN,IB,NBREJ,NTOT,
     +        IL,NP,NL,NCYCLES,NBADPIX,NBADMAX,IBLAST,HX,HY,
     +        IBESTST
      LOGICAL FULL,EQUAL
      REAL TBGND,TPEAK,SPOTW,BGND,RMSBG,DELX,DELY,AX,
     +      SIGFAC,SIGFACMAX,FRAC,SPOTWMAX,BGSIGP,PX,RMSBGN,BGSIGL
      CHARACTER CALLEDFROM*80
C     ..
C     .. Local Arrays ..
      INTEGER MASK(MAXBOX),LMASKREJ(NREJMAX),ISTORE(NREJMAX),
     +         LRASSAVE(5)
      REAL PQVAL(6),SPOTI(40),PQSUMINV(9),FRACA(40)
      CHARACTER STR(3)*3
C     ..
C     .. External Functions ..
C     ..
C     .. External Subroutines ..
      EXTERNAL SETMASK2,SETSM2,INTEG3,CHECKMASK,SHUTDOWN
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC NINT
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/backg.f
C
C $Id: backg.f,v 1.1 2002/05/02 10:46:40 harry Exp $
C
C--- awk generated include file  backg.h
C---- START of include file backg.h
C
C
C
C     .. Scalars in common block /BACKG/ ..
      REAL BGFRAC
      INTEGER NBGMIN
C     ..
C     .. Common Block /BACKG/ ..
      COMMON /BACKG/ BGFRAC,NBGMIN
C     ..
C
C
C&&*&& end_include  ../inc/backg.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/myprof.f
C
C $Id: myprof.f,v 1.1 2002/05/02 10:47:01 harry Exp $
C
C--- awk generated include file  myprof.h
C---- START of include file myprof.h
C
C
C     .. Arrays in Common Block /MYPROF/ ..
      REAL PRSCALE,XPMAX,YPMAX,XLINE,YLINE,WPROFL,WPRSUMS
      INTEGER ISIZE,NRFBOX,IPROFL,IBOX,IXBOX,IYBOX,NPFIRST
      LOGICAL BOX
C     ..
C     .. Scalars in Common Block /MYPROF/
      REAL TOL,BGPKRAT,FRACREJ,BADTOL,TOLMIN,RECLEVEL
      INTEGER NXLINE,NYLINE,NUMBOX,IBOUND,ITRIM,NOVERLAP
      LOGICAL HIGHRES,LOWRES,PRSET,OFFDET,PROPT,FIXBOX,LINESET,
     +        PROPTCEN,RECOVER,NOFIXBOX
C     ..
C     .. Common Block /MYPROF/ ..
      COMMON /MYPROF/PRSCALE(NMASKS,2),XPMAX(NMASKS),YPMAX(NMASKS),
     $       XLINE(NNLINE),YLINE(NNLINE),
     +       WPROFL(MAXBOX,NMASKS),WPRSUMS(MAXBOX,NMASKS),TOL,
     +       BGPKRAT,FRACREJ,BADTOL,TOLMIN,RECLEVEL,
     $       ISIZE(NMASKS,2),NRFBOX(NMASKS),
     +       IPROFL(MAXBOX,NMASKS+1),IBOX(0:NNLINE,0:NNLINE),
     +       IXBOX(NMASKS,2),IYBOX(NMASKS,2),
     +       NPFIRST(NNLINE-1),NXLINE,NYLINE,NUMBOX,IBOUND,ITRIM,
     $       NOVERLAP,BOX(NMASKS),HIGHRES,LOWRES,PRSET,OFFDET,
     +       PROPT,FIXBOX,LINESET,PROPTCEN,RECOVER,NOFIXBOX
C     ..
C
C
C&&*&& end_include  ../inc/myprof.f
C&&*&& include  ../inc/sums.f
C
C $Id: sums.f,v 1.1 2002/05/02 10:47:21 harry Exp $
C
C--- awk generated include file  sums.h
C---- START of include file sums.h
C
C
C     Elements of ASPOT
C     1 = Summation integration intensity
C     2 = Total background counts under peak assuming peak has mm symmetry
C     3 = Rms variation in background, after rejecting background points.
C         This is evaluated in BGSOLVE called from EVAL.
C     4 = Centre of gravity in X direction (in pixels)
C     5 = Centre of gravity in Y direction (in pixels)
C         These are wrt an origin at the centre of the measurement box
C     6 = sum p*iod for background pixels
C     7 = sum q*iod for background pixels
C     8 = sum iod for background pixels
C     9 = Background plane constant a (gradient in X direction)
C    10 = Background plane constant b (gradient in Y direction)
C    11 = Background plane constant c 
C    12 = Largest deviation from background plane, excluding rejected pixels
C    13 = Profile fitted intensity
C    14 = Variance of profile fitted intensity = sum (deltasq) for peak
C         pixels only. Used to calculate PKRATIO and also profile fitted
C         sigma(I) in unweighted case only.
C    15 = Number of rejected background pixels
C    16 = Variance of profile fitted intensity in weighted case (default)
C    17 = sum W*DELTA**2 for profile fit
C    18   unused
C     .. Arrays in common block /SUMS/ ..
      REAL ASPOT
C     ..
C     .. Common Block /SUMS/ ..
      COMMON /SUMS/ASPOT(18)
C     ..
C
C
C&&*&& end_include  ../inc/sums.f
C       
C     .. Equivalences ..
      EQUIVALENCE (ASPOT(1),SPOTW), (ASPOT(2),BGND),
     +            (ASPOT(3),RMSBG)
      EQUIVALENCE (ASPOT(4),DELX), (ASPOT(5),DELY)
C
      SAVE
C                       
      DATA STR/'NRX','NRY','NC '/
      CALLEDFROM = 'BESTMASK'
C
C----- Save the input raster parameters
C
      DO 2 I=1,5
        LRASSAVE(I) = LRAS(I)
 2    CONTINUE
C
C---- First vary the X rim, then do the same for the Y rim.
C
C---- Set corner cutoff to one (effectively no corner cutoff because
C     either NRX or NRY is always at least 1. Code in setmask/setmask2
C     DOES NOT WORK for NC = 0
C
      NXX = LRAS(1)
      NYY = LRAS(2)
C
C---- If calling from BGREJECT (ie caled from process to handle the standard
C     profiles), set the maximum number of allowed "bad"
C     pixels as a function of number of peak pixels of the starting
C     raster parameters. "Bad" pixels are those which lie in the peak
C     of both the active spot and of a neighbouring spot. This is
C     calculated for each combination of raster parameters below in
C     a call to CHECKMASK, and those combinations which produce too
C     many "bad" pixels are excluded from the optimisation
C
      IF (MODE.EQ.1) THEN
        CALL SETMASK2(MASK,LRAS,MASKREJ)
        CALL SETSM2(MASK,LRAS,PQVAL,PQSUMS,PQSUMINV)
        NBADMAX = BADTOL*PQVAL(5)
      END IF
      NBREJ = MASKREJ(1)
      LRAS(3) = 1
C
C---- BGKSIG negative flags background subtracted spots
C
      ISIGN = 1
      IF (BGKSIG.LT.0.0) ISIGN = -1
      BGKSIG = ABS(BGKSIG)
C                       
C---- Set maximum rim ( *** assumes minimum peak size of 5 pixels ***)
      NRXMAX = (NXX-5)/2
      NRYMAX = (NYY-5)/2                   
      NCMAX = MIN(NXX,NYY) - 2
      FULL = .TRUE.
      IDR = 1
      NREF = 1
      NCYCLES = 2
      IF (MODE.EQ.0) NCYCLES = 4
      BGSIGL = BGKSIG
C
      IF (DEBUG(42)) THEN
        NBREJ = MASKREJ(1)
        WRITE(IOUT,FMT=6000) NPBOX,MODE,LRAS,NBREJ,(MASKREJ(I),I=2,11)
        IF (ONLINE) WRITE(ITOUT,FMT=6000) NPBOX,MODE,LRAS,NBREJ,
     +                           (MASKREJ(I),I=2,11)
 6000 FORMAT(//1X,'Debug output from BESTMASK for box',I3,' MODE=',I3,
     +            /,1X,'Starting raster',
     +            5I3,/,1X,'Number rejected background pixels',I4,
     +            '  First ten are:',10I4)
      END IF
      DO 40 ICYC = 1,NCYCLES
C
C---- Set BGSIG depending on MODE and cycle number
C
      IF ((MODE.EQ.0).AND.(ICYC.LE.2)) THEN
        BGSIGP = 10000.0
      ELSE
        BGSIGP = BGSIGL
      END IF
C
 10   IF (DEBUG(42)) THEN
        WRITE(IOUT,FMT=6002) ICYC,BGSIGP
        IF (ONLINE) WRITE(ITOUT,FMT=6002) ICYC,BGSIGP
      END IF
 6002 FORMAT(/1X,'CYCLE',I3,' For this cycle BGSIG=',F8.1)
C
C---- Vary first Xrim, then Yrim then corner cutoff
C
      DO 30 J = 1,3
       IF (J.EQ.1) THEN
         NRMAX = NRXMAX
         NRMIN = NRXMIN
         IPT = 4
       ELSE IF (J.EQ.2) THEN
         NRMAX = NRYMAX
         NRMIN = NRYMIN
         IPT = 5
       ELSE
         NRMAX = NCMAX
         NRMIN = MAX(NCMIN,1)
         IPT = 3
       END IF
      IF (DEBUG(42)) THEN
        WRITE(IOUT,FMT=6004) STR(J),NRMIN,NRMAX
        IF (ONLINE) WRITE(ITOUT,FMT=6004) STR(J),NRMIN,NRMAX
      END IF
 6004 FORMAT(/1X,'Optimising ',A,' Range',I3,' to',I3,/,1X,' NC RX RY',
     +     ' NBG NPK REJ      I          BKG       sigma I/sigma',
     +     ' IBEST')
      SIGFACMAX = 0.0
      SPOTWMAX = -1000000.0
      DO 20 IR = NRMIN,NRMAX
        LRAS(IPT) = IR
C          ************************
C---- Use SETMASK2,SETSM2 which allows for rejected pixels
C
        CALL SETMASK2(MASK,LRAS,MASKREJ)
        CALL SETSM2(MASK,LRAS,PQVAL,PQSUMS,PQSUMINV)
C
C---- Check, using known spot separations calculated in MASKIT, that
C     the current set of parameters does not result in too many peak
C     pixels common to this and neighbouring spots being closer to the
C     centre of the neighbouring spot than to this one.
C
        IF (MODE.EQ.1) THEN
          CALL CHECKMASK(MASK,LRAS,NPBOX,NBADPIX)
          IF (NBADPIX.GT.NBADMAX) THEN
            IF (DEBUG(42)) THEN
              WRITE(IOUT,FMT=6005) IR,NBADPIX,NBADMAX
              IF (ONLINE) WRITE(ITOUT,FMT=6005) IR,NBADPIX,NBADMAX
 6005         FORMAT(1X,'IR=',I2,' rejected because of',I6,
     +               ' bad pixels (closer to an adjacent spot',
     +               ' than the current spot (limit is',I4,')')
            END IF
C
C---- If this is the first cycle and the rim parameter is getting
C     unreasonably large it is probably because the corner rim has been
C     set to one, so set IBEST to the input starting and go on to test
C     the next rim parameter
C
            IF ((ICYC.EQ.1).AND.((IR - LRASSAVE(IPT).GT.2))) THEN
              IBEST = LRASSAVE(IPT)
              GOTO 24
            END IF
            SPOTI(IR) = 0.0
            GOTO 20
          END IF
        END IF
C                  **********************************************
        CALL INTEG3(OD(1),LRAS,MASK,PQVAL,PQSUMS,PQSUMINV,NBREJ,
     +              LMASKREJ,ISIGN*BGSIGP,DEBUG(42))
C                  **********************************************
        TPEAK = PQVAL(5)
        TBGND = PQVAL(6)
C
C---- Get integrated intensity, sigma and I/sigma
C     Need TBGND and TPEAK
        NREJ = NINT(ASPOT(15))
C
C---- Must update number of background points to allow for rejected 
C     pixels. 
C
       TBGND = TBGND - NREJ
C
C                       
C                       
C---- Test that it has not rejected an unacceptable number of
C     background points, there must be NBGMIN points left (set by
C     subkeyword MINB under keyword REJECTION. If too many rejected
C     reflection is flagged with ASPOT(1)=-9999
C
        IF (ASPOT(1).EQ.-9999.0) THEN
          SPOTI(IR) = 0.0
          GOTO 20
        END IF
C
C---- Give debug output if no background pixels and not trapped by above test
C
CAL       IF (TBGND.LE.0.0) WRITE(6,*),'****** tbgnd,nrej,tpeak,LRAS,aspot',
CAL     +          TBGND,
CAL     +          NREJ,TPEAK,LRAS,ASPOT
C
C---- Calculate standard deviation of intensity
C
C                        
C
C---- This sigma does not include instrument error correction
C     BGND is the total background under the peak, ie 
C     (number of peak pixels)*c
C     If this is an averaged profile (ISIGN.eq.-1), the background has 
C     been subtracted so need to add it back in.
C
        IF (ISIGN.EQ.-1) BGND = TPEAK*CTOT
        AX = GAIN*(SPOTW+BGND+BGND*TPEAK/TBGND)
        ISDBSI=SQRT(AX) + 0.5
        ISDBSI = MAX(ISDBSI,1)
        SIGFAC = SPOTW/FLOAT(ISDBSI)
        IF (SPOTW.GT.SPOTWMAX) SPOTWMAX = SPOTW
        SPOTI(IR) = SPOTW
        IF (SIGFAC.GE.SIGFACMAX) THEN
          IBEST = IR
          SIGFACMAX = SIGFAC
        END IF
      IF (DEBUG(42)) THEN
      WRITE(IOUT,FMT=6008) (LRAS(K),K=3,5),NINT(TBGND),NINT(TPEAK),
     +                NREJ,SPOTW,BGND,ISDBSI,SIGFAC,IBEST
      IF (ONLINE) WRITE(ITOUT,FMT=6008) (LRAS(K),K=3,5),NINT(TBGND),
     +      NINT(TPEAK),NREJ,SPOTW,BGND,ISDBSI,SIGFAC,IBEST
 6008 FORMAT(1X,3I3,3I4,2F12.0,I8,F8.0,I6)
      END IF
C
 20   CONTINUE
C
C---- Check that it has not rejected all possible raster values
C     because too many background points are rejected. This can happen
C     if the initial overall dimensions of the measurement box are too
C     small.If this is the first cycle then NC will be zero, so just set
C     the rim to the smallest value (NRMIN) and keep going
C
      IF (SPOTWMAX.EQ.0) THEN
        IF (ICYC.EQ.1) THEN
          IBEST = NRMIN
          GOTO 24
        END IF
C
C---- If not the first cycle, increase BGSIGP and try again
C
        BGSIGP = 2.0*BGSIGL
        BGSIGL = BGSIGP
        IF (BGSIGL.GT.200) THEN
          WRITE(IOUT,FMT=6013)
          IF (ONLINE) WRITE(ITOUT,FMT=6013)
 6013     FORMAT(1X,'***** FATAL ERROR *****',/,1X,
     +     'BGSIG too large, check prediction is OK.')
          NSHUTERR = 1
          CALL SHUTDOWN(CALLEDFROM)
        END IF
C
        WRITE(IOUT,FMT=6015) BGSIGP
        IF (ONLINE) WRITE(ITOUT,FMT=6015) BGSIGP
 6015   FORMAT(/,1X,'*** WARNING ***',/,1X,'Too many background ',
     +         'points rejected as outliers to allow',/,1X,
     +         'optimisation. Increasing BGSIG to',F7.1,'(see',
     +         ' BACKGROUND kewyord in "Help" library.',/,1X,
     +         'BGSIG will be reset to original value when ',
     +         'integrating images.')
        GOTO 10
C
CAL        WRITE(IOUT,FMT=6009) LRAS
CAL        IF (ONLINE) WRITE(ITOUT,FMT=6009) LRAS
 6009   FORMAT(//1X,'***** ERROR *****',/,1X,'With the given raster',
     +  ' (measurement box) parameters (',5I3,')',/,1X,'too many ',
     +  'background pixels are being rejected to permit optimisation.',
     +  /,1X,'Try increasing the overall box size (NXS,NYS) and rerun',
     +  ','/,1X,'but first check (using the graphics option) that the',
     +   ' pattern is being',/,1X,'correctly predicted')
CAL        CALL SHUTDOWN(CALLEDFROM)
      END IF
C
C---- Check loss in intensity wrt max for the "best" value. If more
C     than "TOL" go up to IBOUND pixels further out in NRX,NRY,or NC
C     Initialise IBLAST to 1, so no extrapolation for IBEST occurs
C
      IBESTST = IBEST
      IBLAST = 0
      DO 22 IB = 1,IBOUND
        FRAC = ( SPOTWMAX - SPOTI(IBEST) )/SPOTWMAX
        FRACA(IB) = FRAC
        IF (DEBUG(42)) THEN
          WRITE(IOUT,FMT=6012) IB,FRAC,IBEST
          IF (ONLINE) WRITE(ITOUT,FMT=6012) IB,FRAC,IBEST
        END IF
 6012   FORMAT(1X,'Cycle',I2,' Frac=',F6.3,' IBEST=',I2)
        IF (FRAC.GT.LTOL) THEN
          IBEST = MAX(IBEST-1,1)
        ELSE
          IBLAST = IB
          GOTO 24
        END IF
 22   CONTINUE
C
C---- Interpolate between last two values of IB to get the "best" value
C
 24   IF (IBLAST.GE.2) THEN
        PX = 0.0
        IF (FRACA(IBLAST).LT.FRACA(IBLAST-1))
     +    PX = (LTOL - FRACA(IBLAST))/(FRACA(IBLAST-1)-FRACA(IBLAST))
        IBEST = NINT(REAL(IBEST) + PX)
C
C---- Do not allow IBEST to go beyond IBOUND
C
        IF ((IBESTST-IBEST).GT.(IBOUND-1)) IBEST = IBEST + 1
      ELSE IF (IBLAST.EQ.1) THEN
C
C---- The BEST value also has frac,tol so just choose it
C     IBEST should be incremented by one.
C
        CONTINUE
      ELSE IF (IBLAST.EQ.0) THEN
C
C---- All possible values have given frac > tol. See if
C     IBEST should be incremented by one.
C
        PX = (FRACA(IBOUND-1) - FRACA(IBOUND))
        IF (ABS((FRACA(IBOUND) - PX) - LTOL) .GT. 
     +      ABS(FRACA(IBOUND) - LTOL)) IBEST = IBEST + 1
      END IF
C
C
C---- If this is the first cycle, decrease IBEST for NC by one, otherwise
C     can get  poor discrimination in NX and NY in next cycle
C     if NC is overestimated. However, only do this if frac was < tol
C
      IF (DEBUG(42)) THEN
        WRITE(IOUT,FMT=6011) LTOL,IBEST
        IF (ONLINE) WRITE(ITOUT,FMT=6011) LTOL,IBEST
 6011   FORMAT(1X,'After interpolation, final IBEST for TOL=',F5.3,
     +         ' is',I3)
      END IF
CAL      IF ((J.EQ.3).AND.(ICYC.EQ.1).AND.(IBLAST.GT.0)) THEN
CAL        IBEST = IBEST - 1
CAL        IF (DEBUG(42)) THEN
CAL          WRITE(IOUT,FMT=6013) IBEST
CAL          IF (ONLINE) WRITE(ITOUT,FMT=6013) IBEST
CAL 6013   FORMAT(1X,'Because this is NC and first cycle, IBEST',
CAL     +         ' reset to',I3)
CAL        END IF
CAL      END IF
 
C
 26   LRAS(IPT) = IBEST
 30   CONTINUE
C
      IF (DEBUG(42)) THEN
        WRITE(IOUT,FMT=6010) ICYC,LRAS,FRAC
        IF (ONLINE) WRITE(ITOUT,FMT=6010) ICYC,LRAS,FRAC
      END IF            
 6010 FORMAT(1X,'Final raster parameters for cycle',I3,' are',5I4,
     +        '   Frac was',F6.3)
 40   CONTINUE
CAL      IF (DEBUG(42)) THEN
CAL        DEBUG(33) = .TRUE.
CAL        DEBUG(34) = .TRUE.
CAL        SPOT = .TRUE.
CAL      END IF
C
C---- Make final call to INTEG with optimum parameters so that MASKREJ,
C     PQSUMS are correctly set up
C
C          ************************
C---- Use SETMASK2,SETSM2 which allows for rejected pixels
C
        CALL SETMASK2(MASK,LRAS,MASKREJ)
        CALL SETSM2(MASK,LRAS,PQVAL,PQSUMS,PQSUMINV)
        CALL INTEG3(OD(1),LRAS,MASK,PQVAL,PQSUMS,PQSUMINV,NBREJ,
     +              LMASKREJ,ISIGN*BGSIGP,DEBUG(42))
C          **********************************************
C
      IF (DEBUG(42)) THEN
        WRITE(IOUT,FMT=6018) ASPOT,PQSUMS
        IF (ONLINE) WRITE(ITOUT,FMT=6018) ASPOT,PQSUMS
 6018   FORMAT(1X,'Final values in ASPOT',/,1X,9F12.0,/,1X,9F12.0,
     +         /,1X,'Current PQSUMS ',9F12.0)
CAL        DEBUG(33) = .FALSE.
CAL        DEBUG(34) = .FALSE.
CAL        SPOT = .FALSE.
      END IF
C                       
C---- Test that it has not rejected an unacceptable number of
C     background points, there must be NBGMIN points left (set by
C     subkeyword MINB under keyword REJECTION. If too many rejected
C     reflection is flagged with ASPOT(1)=-9999
C
        IF (ASPOT(1).EQ.-9999.0) THEN
          IF (BRIEF) WRITE(IBRIEF,6020) BGSIGP,NBGMIN
          WRITE(IOUT,6020) BGSIGP,NBGMIN
          IF (ONLINE) WRITE(ITOUT,6020) BGSIGP,NBGMIN
 6020     FORMAT(//1X,'With the current BGSIG factor of',F6.2,
     +     ' there are fewer than ',I3,' background pixels remaining',
     +     /,1X,'for this profile after rejecting outliers',/,1X,
     +     'Check if things are seriously wrong or rerun ',
     +     'with a larger value for BGSIG ',/,1X,
     +     'on BACKGROUND keyword')
          NSHUTERR = 2
           CALL SHUTDOWN(CALLEDFROM)
        END IF
C
C---- Now calculate a new RMSBG (used to test if standard profile needs
C     averaging) omitting background points next to peak pixels or next
C     to overlapped background pixels
C
      HX = LRAS(1)/2
      HY = LRAS(2)/2
      CALL NEWRMS(OD,HX,HY,MASK,LMASKREJ,RMSBGN)
      IF (RMSBGN.NE.0) RMSBG = RMSBGN
C
C---- Now have to merge the list of rejected pixels due to overlap of
C     neighbouring reflections (Stored in MASKREJ) with the list
C     of pixels which deviate from the beast background plane (stored in
C     LMASKREJ)
C
        NBREJ = MASKREJ(1)
        NREJ = LMASKREJ(1)
        I = 0
        IL = 0
        NTOT = 0
C
C---- Set EQUAL true so that on first entry it assigns both I and IL
C
        EQUAL = .TRUE.
 50     I = I + 1
        IF (I.GT.NBREJ) GOTO 60
        NP = MASKREJ(I+1)
        IF (.NOT.EQUAL) GOTO 54
 52     IL = IL + 1
        IF (IL.GT.NREJ) GOTO 64
        EQUAL = .FALSE.
        NL = LMASKREJ(IL+1)
 54     NTOT = NTOT + 1
        IF (NL.LT.NP) THEN
         ISTORE(NTOT+1) = NL
         GOTO 52
        ELSE IF (NP.LT.NL) THEN
         ISTORE(NTOT+1) = NP
         GOTO 50
        ELSE 
         ISTORE(NTOT+1) = NL
         EQUAL = .TRUE.
         GOTO 50
        END IF
C
C----Gets here if list in MASKREJ is exhausted first
C    If the last two pixels had the same number, need to increment IL
C    by one before copying rest of list. Note this also deals with the
C    case when NBREJ=0, because EQUAL is initialised to be TRUE.
C
 60     IF (EQUAL) IL = IL + 1
        IF (IL.GT.NREJ) GOTO 68
        DO 62 J = IL,NREJ
          NTOT = NTOT + 1
          ISTORE(NTOT+1) = LMASKREJ(J+1)
 62     CONTINUE
        GOTO 68
C
C----Gets here if list in LMASKREJ is exhausted first
C
 64     DO 66 J = I,NBREJ
          NTOT = NTOT + 1
          ISTORE(NTOT+1) = MASKREJ(J+1)
 66    CONTINUE
C
 68    ISTORE(1) = NTOT
C
        IF (DEBUG(42)) THEN
          WRITE(IOUT,FMT=6030) NBREJ
          IF (NBREJ.NE.0) WRITE(IOUT,FMT=6031) (MASKREJ(I),I=2,NBREJ+1)
          WRITE(IOUT,FMT=6032) NREJ
          IF (NREJ.NE.0) WRITE(IOUT,FMT=6031) (LMASKREJ(I),I=2,NREJ+1)
          WRITE(IOUT,FMT=6034) NTOT
          IF (NTOT.NE.0) WRITE(IOUT,FMT=6031) (ISTORE(I),I=2,NTOT+1)
          IF (ONLINE) THEN
            WRITE(ITOUT,FMT=6030) NBREJ
            IF (NBREJ.NE.0) WRITE(ITOUT,FMT=6031)
     +                      (MASKREJ(I),I=2,NBREJ+1)
            WRITE(ITOUT,FMT=6032) NREJ
            IF (NREJ.NE.0) WRITE(ITOUT,FMT=6031)
     +                      (LMASKREJ(I),I=2,NREJ+1)
            WRITE(ITOUT,FMT=6034) NTOT
            IF (NTOT.NE.0) WRITE(ITOUT,FMT=6031)
     +                      (ISTORE(I),I=2,NTOT+1)
          END IF
        END IF
 6030   FORMAT(1X,'Number of rejected pixels in MASKREJ',I4)
 6031   FORMAT(1X,' Values:',
     +        /,(1X,30I4))
 6032   FORMAT(1X,'Number in LMASKREJ',I4)
 6034   FORMAT(1X,'Number after merging',I4)
C
C
      DO 70 I = 1,NTOT+1
        MASKREJ(I) = ISTORE(I)
 70   CONTINUE
C
C---- Now need to set up PQSUMS to reflect the merged rejected pixel list
C     This is returned to BGREJECT.
C
      CALL SETMASK2(MASK,LRAS,MASKREJ)
      CALL SETSM2(MASK,LRAS,PQVAL,PQSUMS,PQSUMINV)
C      WRITE(6,*),'End of BESTMASK, number rej, PQSUMS',MASKREJ(1),PQSUMS
      RETURN
      END
C $Id: bexpan4.f,v 1.3 2004/06/02 14:11:37 harry Exp $
C== BEXPAN4 ==                           
C
      SUBROUTINE BEXPAN4(A,IA,NXY)
C     ===========================
C
C  This version for image plate data (I*2 pixel values)
C  It simply transfers values from array A to array IA (where A is
C  I*2 but IA is I*4). Note that this differs from BEXPAN only in that
C  the output array is I*4 rather than I*2. Two versions are required 
C  because subroutine CGFIND called from CENTRS does a sort on the pixel 
C  values and the sort routine expects I*2 arrays because it deals
C  primarily with the generate file data. However in CGFIT we want to use 
C  the BGTEST and BGSOLVE subroutines to eliminate bad background pixels 
C  and these require I*4 arrays.
C  If the dynamic range is extended to 16 bits we must cope
C  with the fact that values will be unsigned
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C
C     .. Scalar Arguments ..
      INTEGER NXY
C     ..
C     .. Array Arguments ..
      INTEGER*2 A(NXY)
      INTEGER  IA(NXY)
C     ..
C     .. Local Scalars ..
      INTEGER I
      INTEGER*2 IOD
C     ..
C     .. Extrinsic Functions ..
      INTEGER  INTPXL
      EXTERNAL  INTPXL
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C     ..
      SAVE
C
C
      DO 10 I = 1,NXY
        IOD = A(I)
        IA(I) = INTPXL(IOD)
   10 CONTINUE
      END
C $Id: bgreject.f,v 1.3 2003/04/30 14:01:37 harry Exp $
C== BGREJECT ==
      SUBROUTINE BGREJECT(OD,MASK,LRAS,NPBOX,MASKREJ,PQVAL,PQSUMS,
     +         PQSUMINV,BGKSIG,CHANGEMASK,FULL,NRBX,IOPTRAS,CTOT,LTOL,
     +         DENSE)
C     ===============================================================
C
      IMPLICIT NONE
C
C
C****** DEBUG(24) FOR THIS SUBROUTINE ******
C
C---- MASK and LRAS are updated by this subroutine if raster optimisation
C     is requested (PROPT true)
C
C
C
C     .. Parameters ..                                
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C
C
C     .. Scalar Arguments ..
      INTEGER NRBX,NPBOX
      REAL BGKSIG,CTOT,LTOL
      LOGICAL CHANGEMASK,FULL,DENSE
C     ..
C     .. Array Arguments ..
      REAL PQSUMINV(9),PQSUMS(6),PQVAL(6)
      INTEGER LRAS(5),MASK(MAXBOX),MASKREJ(NREJMAX),OD(MAXBOX),
     +        IOPTRAS(3)
C     ..
C     .. Local Scalars ..
C      REAL SCALE
      INTEGER K,NBREJ,NXX,NYY,IFLAG,NREJ,I,IL,NTOT,NP,NL,J,MODE,
     +        IHX,IHY,NRXMIN,NRYMIN,NCMIN,IMODE,MAXPIX
      LOGICAL EQUAL
C     ..
C     .. Local Arrays ..
      INTEGER LMASKREJ(NREJMAX),ISTORE(NREJMAX)
      REAL SPOTPQSUM(6)
C     ..
C     .. External Subroutines ..
      EXTERNAL PQINV,BESTMASK,SETMASK,SETSUMS,INTEG,ODPLOT4,PKRIM
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/backg.f
C
C $Id: backg.f,v 1.1 2002/05/02 10:46:40 harry Exp $
C
C--- awk generated include file  backg.h
C---- START of include file backg.h
C
C
C
C     .. Scalars in common block /BACKG/ ..
      REAL BGFRAC
      INTEGER NBGMIN
C     ..
C     .. Common Block /BACKG/ ..
      COMMON /BACKG/ BGFRAC,NBGMIN
C     ..
C
C
C&&*&& end_include  ../inc/backg.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/myprof.f
C
C $Id: myprof.f,v 1.1 2002/05/02 10:47:01 harry Exp $
C
C--- awk generated include file  myprof.h
C---- START of include file myprof.h
C
C
C     .. Arrays in Common Block /MYPROF/ ..
      REAL PRSCALE,XPMAX,YPMAX,XLINE,YLINE,WPROFL,WPRSUMS
      INTEGER ISIZE,NRFBOX,IPROFL,IBOX,IXBOX,IYBOX,NPFIRST
      LOGICAL BOX
C     ..
C     .. Scalars in Common Block /MYPROF/
      REAL TOL,BGPKRAT,FRACREJ,BADTOL,TOLMIN,RECLEVEL
      INTEGER NXLINE,NYLINE,NUMBOX,IBOUND,ITRIM,NOVERLAP
      LOGICAL HIGHRES,LOWRES,PRSET,OFFDET,PROPT,FIXBOX,LINESET,
     +        PROPTCEN,RECOVER,NOFIXBOX
C     ..
C     .. Common Block /MYPROF/ ..
      COMMON /MYPROF/PRSCALE(NMASKS,2),XPMAX(NMASKS),YPMAX(NMASKS),
     $       XLINE(NNLINE),YLINE(NNLINE),
     +       WPROFL(MAXBOX,NMASKS),WPRSUMS(MAXBOX,NMASKS),TOL,
     +       BGPKRAT,FRACREJ,BADTOL,TOLMIN,RECLEVEL,
     $       ISIZE(NMASKS,2),NRFBOX(NMASKS),
     +       IPROFL(MAXBOX,NMASKS+1),IBOX(0:NNLINE,0:NNLINE),
     +       IXBOX(NMASKS,2),IYBOX(NMASKS,2),
     +       NPFIRST(NNLINE-1),NXLINE,NYLINE,NUMBOX,IBOUND,ITRIM,
     $       NOVERLAP,BOX(NMASKS),HIGHRES,LOWRES,PRSET,OFFDET,
     +       PROPT,FIXBOX,LINESET,PROPTCEN,RECOVER,NOFIXBOX
C     ..
C
C
C&&*&& end_include  ../inc/myprof.f
C&&*&& include  ../inc/sums.f
C
C $Id: sums.f,v 1.1 2002/05/02 10:47:21 harry Exp $
C
C--- awk generated include file  sums.h
C---- START of include file sums.h
C
C
C     Elements of ASPOT
C     1 = Summation integration intensity
C     2 = Total background counts under peak assuming peak has mm symmetry
C     3 = Rms variation in background, after rejecting background points.
C         This is evaluated in BGSOLVE called from EVAL.
C     4 = Centre of gravity in X direction (in pixels)
C     5 = Centre of gravity in Y direction (in pixels)
C         These are wrt an origin at the centre of the measurement box
C     6 = sum p*iod for background pixels
C     7 = sum q*iod for background pixels
C     8 = sum iod for background pixels
C     9 = Background plane constant a (gradient in X direction)
C    10 = Background plane constant b (gradient in Y direction)
C    11 = Background plane constant c 
C    12 = Largest deviation from background plane, excluding rejected pixels
C    13 = Profile fitted intensity
C    14 = Variance of profile fitted intensity = sum (deltasq) for peak
C         pixels only. Used to calculate PKRATIO and also profile fitted
C         sigma(I) in unweighted case only.
C    15 = Number of rejected background pixels
C    16 = Variance of profile fitted intensity in weighted case (default)
C    17 = sum W*DELTA**2 for profile fit
C    18   unused
C     .. Arrays in common block /SUMS/ ..
      REAL ASPOT
C     ..
C     .. Common Block /SUMS/ ..
      COMMON /SUMS/ASPOT(18)
C     ..
C
C
C&&*&& end_include  ../inc/sums.f
C     ..
C     ..
      SAVE
      MAXPIX = 0
C
C
C---- If not enough background pixels left, get some more !
C
C
        IF  ((NINT(PQSUMS(6)).LT.RECLEVEL*NBGMIN)
     +                                          .AND.(RECOVER)) THEN
          CALL GETMOREBG(OD,LRAS,MASK,MASKREJ,PQSUMS,PQSUMINV,NPBOX)
        END IF

C---- Copy pqsums to a local array because they will be updated in
C     BGTEST called from EVAL called from INTEG.
C
      DO 10 K = 1,6
        SPOTPQSUM(K) = PQSUMS(K)
   10 CONTINUE
      IF (PROPT) THEN
C
C---- Get optimised raster box parameters (rim and corner cutoff)
C     This S/R also gets rejected points
         MODE = 1
C
C---- First see if neighbouring spots intrude
C
         IHX = LRAS(1)/2
         IHY = LRAS(2)/2
         IMODE = 1
         CALL PKRIM(OD,CTOT,IHX,IHY,IMODE,NRXMIN,NRYMIN,NCMIN)
C
C
C---- While testing CHECKMASK set all min values to 1
C
         NRXMIN = 1
         NRYMIN = 1
         NCMIN = 1
C
C---- If working in DENSE mode, limit allowable change in rim parameters
C
         IF (DENSE) THEN
           NRXMIN = MAX(LRAS(4) - 2,1)
           NRYMIN = MAX(LRAS(5) - 2,1)
           NCMIN = MAX(LRAS(3) - 2,1)    
         END IF
         CALL BESTMASK(OD(1),LRAS,NPBOX,MODE,SPOTPQSUM,MASKREJ(1),
     +                BGKSIG,IFLAG,CTOT,NRXMIN,NRYMIN,NCMIN,LTOL)
         IOPTRAS(1) = LRAS(3)         
         IOPTRAS(2) = LRAS(4)
         IOPTRAS(3) = LRAS(5)
C
C---- Must update PQSUMS to reflect the optimised mask, irrespective of
C     whether we are using CHANGEMASK option
C
C            **********************************
        CALL SETMASK(MASK(1),LRAS)
        CALL SETSUMS(MASK(1),LRAS,PQVAL)
C            **********************************
C
C---- Set up background sums for this box
C
        PQSUMS(1) = PQVAL(2)
        PQSUMS(2) = PQVAL(4)
        PQSUMS(6) = PQVAL(6)
C
C
      ELSE
C
C---- *****************************************************************
C---- Not optimising raster parameters. Still use rejected pixel list
C     of calculated overlap from MASKIT
C---- *****************************************************************
C
C---- Use SETMASK2,SETSM2 which allows for rejected pixels
C
C            ***************************************************
        NBREJ = MASKREJ(1)
        CALL SETMASK2(MASK,LRAS,MASKREJ)
        CALL SETSM2(MASK,LRAS,PQVAL,SPOTPQSUM,PQSUMINV)
        CALL INTEG3(OD(1),LRAS,MASK,PQVAL,SPOTPQSUM,PQSUMINV,NBREJ,
     +              LMASKREJ,BGKSIG,DEBUG(24))
C            ***************************************************
C
C---- Now have to merge the list of rejected pixels due to overlap of
C     neighbouring reflections (Stored in MASKREJ) with the list
C     of pixels which deviate from the best background plane (stored in
C     LMASKREJ)
C
          NBREJ = MASKREJ(1)
          NREJ = LMASKREJ(1)
          I = 0
          IL = 0
          NTOT = 0
C
C---- Set EQUAL true so that on first entry it assigns both I and IL
C
          EQUAL = .TRUE.
 50       I = I + 1
          IF (I.GT.NBREJ) GOTO 60
          NP = MASKREJ(I+1)
          IF (.NOT.EQUAL) GOTO 54
 52       IL = IL + 1
          IF (IL.GT.NREJ) GOTO 64
          EQUAL = .FALSE.
          NL = LMASKREJ(IL+1)
 54       NTOT = NTOT + 1
          IF (NL.LT.NP) THEN
           ISTORE(NTOT+1) = NL
           GOTO 52
          ELSE IF (NP.LT.NL) THEN
           ISTORE(NTOT+1) = NP
           GOTO 50
          ELSE 
           ISTORE(NTOT+1) = NL
           EQUAL = .TRUE.
           GOTO 50
          END IF
C
C----Gets here if list in MASKREJ is exhausted first
C    If the last two pixels had the same number, need to increment IL
C    by one before copying rest of list. Note this also deals with the
C    case when NBREJ=0, because EQUAL is initialised to be TRUE.
C
 60       IF (EQUAL) IL = IL + 1
          IF (IL.GT.NREJ) GOTO 68
          DO 62 J = IL,NREJ
              NTOT = NTOT + 1
              ISTORE(NTOT+1) = LMASKREJ(J+1)
 62       CONTINUE
          GOTO 68
C
C----Gets here if list in LMASKREJ is exhausted first
C
 64       DO 66 J = I,NBREJ
            NTOT = NTOT + 1
            ISTORE(NTOT+1) = MASKREJ(J+1)
 66    CONTINUE
C
 68    ISTORE(1) = NTOT
C
          IF (DEBUG(24)) THEN
            WRITE(IOUT,FMT=6030) NBREJ,(MASKREJ(I),I=2,NBREJ+1)
            WRITE(IOUT,FMT=6032) NREJ,(LMASKREJ(I),I=2,NREJ+1)
            WRITE(IOUT,FMT=6034) NTOT,(ISTORE(I),I=2,NTOT+1)
            IF (ONLINE) THEN
              WRITE(IOUT,FMT=6030) NBREJ,(MASKREJ(I),I=2,NBREJ+1)
              WRITE(IOUT,FMT=6032) NREJ,(LMASKREJ(I),I=2,NREJ+1)
              WRITE(IOUT,FMT=6034) NTOT,(ISTORE(I),I=2,NTOT+1)
            END IF
          END IF
 6030   FORMAT(1X,'Number of rejected pixels in MASKREJ',I4,' Values:',
     +        /,(1X,30I4))
 6032   FORMAT(1X,'Number in LMASKREJ',I4,' Values:',
     +        /,(1X,30I4))
 6034   FORMAT(1X,'Number after merging',I4,' Values:',
     +        /,(1X,30I4))
C
C
        DO 70 I = 1,NTOT+1
          MASKREJ(I) = ISTORE(I)
 70     CONTINUE
C
C---- Now need to set up PQSUMS to reflect the merged rejected pixel list
C
        CALL SETMASK2(MASK,LRAS,MASKREJ)
        CALL SETSM2(MASK,LRAS,PQVAL,SPOTPQSUM,PQSUMINV)
C
C          ******************************************************
C***        CALL INTEG(OD(1),LRAS,MASK(1),PQVAL,1,FULL,BGKSIG,MASKREJ(1),
C***     +           SPOTPQSUM,NRBX)
C          ******************************************************
      END IF
C
C---- If background area of mask is to be changed on basis of
C     bad points in the background of the standard profile,
C     copy SPOTPQSUM back into PQSUMS
C     Also store the inverted matrix for solving for background plane
C     when integrating all spots in final pass.
C
        NREJ = MASKREJ(1)
C
        IF (CHANGEMASK.AND.(NREJ.NE.0)) THEN
C
C
          DO 20 K = 1,6
            PQSUMS(K) = SPOTPQSUM(K)
   20     CONTINUE
C
C              ****************************
          CALL PQINV(PQSUMS(1),PQSUMINV(1))
C              ****************************
C
        END IF
C
      IF (DEBUG(24)) THEN
        NXX = LRAS(1)
        NYY = LRAS(2)
        IF (SPOT) CALL ODPLOT4(OD(1),NXX,NYY,1,MAXPIX)
        IF (ONLINE) WRITE(ITOUT,6000) LRAS,SPOTPQSUM,NREJ,
     +         (MASKREJ(K),K=2,NREJ+1)
        WRITE(IOUT,6000) LRAS,SPOTPQSUM,NREJ,(MASKREJ(K),K=2,NREJ+1)
 6000   FORMAT(/1X,'At end of BGREJECT',/,1X,
     +        'RASTER',5I5,/,1X,'ARRAY SPOTPQSUM ',6F10.0,
     +        /,1X,'NUMBER OF REJECTED BACKGROUND',
     +         ' POINTS',I4,' NUMBERS',/,(1X,10I5,/))
      END IF
C
C
      END
C== BGSOLVE ==
      SUBROUTINE BGSOLVE(OD,MASK,IRAS,MASKREJ,PQSUMS)
C     ===============================================
C
C     Solves for the background plane constants after rejecting outliers
C     in BGTEST (which also updates the background sums in PQSUMS).
C     Evaluates the new rms variation in the background and the largest
C     deviation from the new plane (excluding rejected pixels). Thes are
C     passed back via ASPOT (as are the plane constants).
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C
C
C
C
C     .. Array Arguments ..
      REAL PQSUMS(6)
      INTEGER IRAS(5),MASK(MAXBOX),MASKREJ(NREJMAX),OD(MAXBOX)
C     ..
C     .. Local Scalars ..
      REAL A,APC,B,C,DET,DEV,DIFFMAX,RMSBG,SD,SP,SPQ,SQ
      INTEGER HX,HY,IJ,NR,P,Q
      LOGICAL DEBUG,FINISH
C     ..
C     .. Local Arrays ..
      REAL ABC(3),PQ(3,3),PQINV(3,3),SPQOD(3)
C     ..
C     .. External Subroutines ..
      EXTERNAL MATVEC,MINV33
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS,MAX,SQRT
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/sums.f
C
C $Id: sums.f,v 1.1 2002/05/02 10:47:21 harry Exp $
C
C--- awk generated include file  sums.h
C---- START of include file sums.h
C
C
C     Elements of ASPOT
C     1 = Summation integration intensity
C     2 = Total background counts under peak assuming peak has mm symmetry
C     3 = Rms variation in background, after rejecting background points.
C         This is evaluated in BGSOLVE called from EVAL.
C     4 = Centre of gravity in X direction (in pixels)
C     5 = Centre of gravity in Y direction (in pixels)
C         These are wrt an origin at the centre of the measurement box
C     6 = sum p*iod for background pixels
C     7 = sum q*iod for background pixels
C     8 = sum iod for background pixels
C     9 = Background plane constant a (gradient in X direction)
C    10 = Background plane constant b (gradient in Y direction)
C    11 = Background plane constant c 
C    12 = Largest deviation from background plane, excluding rejected pixels
C    13 = Profile fitted intensity
C    14 = Variance of profile fitted intensity = sum (deltasq) for peak
C         pixels only. Used to calculate PKRATIO and also profile fitted
C         sigma(I) in unweighted case only.
C    15 = Number of rejected background pixels
C    16 = Variance of profile fitted intensity in weighted case (default)
C    17 = sum W*DELTA**2 for profile fit
C    18   unused
C     .. Arrays in common block /SUMS/ ..
      REAL ASPOT
C     ..
C     .. Common Block /SUMS/ ..
      COMMON /SUMS/ASPOT(18)
C     ..
C
C
C&&*&& end_include  ../inc/sums.f
C     ..
C     .. Equivalences ..
      EQUIVALENCE (ASPOT(3),RMSBG), (ASPOT(6),SPQOD(1)),
     +            (ASPOT(9),ABC(1))
      SAVE
C     ..
C
C
C
C       debug=.true.
C
      DEBUG = .FALSE.
C
C
      SPQ = PQSUMS(3)
      SP = PQSUMS(4)
      SQ = PQSUMS(5)
C
C---- Solve for new background plane, now need full 3*3 matrix because
C     if points have been rejected the background box will no longer
C     be symmetric.
C
      PQ(1,1) = PQSUMS(1)
      PQ(2,2) = PQSUMS(2)
      PQ(3,3) = PQSUMS(6)
      PQ(1,2) = SPQ
      PQ(2,1) = SPQ
      PQ(1,3) = SP
      PQ(3,1) = SP
      PQ(2,3) = SQ
      PQ(3,2) = SQ
C
C          ***********************
      CALL MINV33(PQINV,PQ,DET)
      CALL MATVEC(ABC,PQINV,SPQOD)
C          ***********************
C
      IF (DEBUG) WRITE (ITOUT,FMT=6000) PQ,PQINV,SPQOD,ABC
C
C---- Reevaluate rmsbg
C
      A = ABC(1)
      B = ABC(2)
      C = ABC(3)
      HX = IRAS(1)/2
      HY = IRAS(2)/2
      IJ = 0
      SD = 0.0
      NR = 2
      DIFFMAX = 0.0
      NREJP1 = MASKREJ(1) + 1
      FINISH = .FALSE.
C
C
      DO 20 P = -HX,HX
        APC = A*P + C
        DO 10 Q = -HY,HY
          IJ = IJ + 1
          IF (MASK(IJ).LT.0) THEN
C
C---- Background points
C     omit rejected points
C
            IF ((.NOT.FINISH).AND.(IJ.EQ.MASKREJ(NR))) THEN
                NR = NR + 1
                FINISH = (NR.GT.NREJP1)
            ELSE
              DEV = OD(IJ) - (B*Q+APC)
              DIFFMAX = MAX(DIFFMAX,ABS(DEV))
              SD = DEV*DEV + SD
            END IF
          END IF
   10   CONTINUE
   20 CONTINUE
C
C
      IF (DEBUG) THEN
        WRITE (IOUT,FMT=6002) NR - 2
        WRITE (ITOUT,FMT=6002) NR - 2
      END IF
C
C
      RMSBG = SQRT(SD/PQSUMS(6))
      ASPOT(12) = DIFFMAX
C
C---- Format statements
C
 6000 FORMAT (/1X,'MATRIX PQ',9E8.2,/1X,'MATRIX PQINV',9E8.2,/1X,'VECT',
     +       'OR SPQOD ',3E10.2,/1X,'VECTOR ABC',3E10.2,//)
 6002 FORMAT (1X,'IN BGSOLVE,',I3,' BACKGROUND POINTS OMITTED')
C
C
      END
C== BGSUMS ==
      SUBROUTINE BGSUMS(MASK,LMASK,OD,NHX,NHY,PQSUMS,SPQOD)
      IMPLICIT NONE
C
C---- Calculate sums for background allowing for overlapped pixels.
C     MASK    Peak background mask set up by SETMASK
C     LMASK   Mask where overlapped pixels are non-zero
C     OD      Array of pixel values
C     NHX     Box half-width in X
C     NHY     Box half-width in Y
C     PQSUMS:
C     p,q are pixel coords wrt centre of box, all sums are for background
C        points ONLY. 
C
C     1 = sum p*p  
C     2 = sum q*q
C     3 = sum p*q
C     4 = sum p
C     5 = sum q
C     6 = number of background pixels
C
C     SPQOD   Background sums 
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      INTEGER NHX,NHY
C     ..
C     .. Array Arguments ..
      INTEGER MASK(MAXBOX),LMASK(MAXBOX),OD(MAXBOX)
      REAL PQSUMS(6),SPQOD(3)
C     ..
C     .. Local Scalars ..
      INTEGER IJ,P,Q,IOD
      REAL SP,SQ,SPQ,SPP,SQQ,S,SBGOD,SBGPOD,SBGQOD
C
      IJ = 0
      SP = 0.0
      SQ = 0.0
      SPQ = 0.0
      SPP = 0.0
      SQQ = 0.0
      S = 0.0
      SBGOD = 0.0
      SBGPOD = 0
      SBGQOD = 0
C
      DO 74 P = -NHX,NHX
        DO 72 Q = -NHY,NHY
          IJ = IJ + 1
          IOD = OD(IJ)
C
C---- NOTE: Only consider background pixels for these sums
C
          IF ((MASK(IJ).EQ.-1).AND.(LMASK(IJ).EQ.0)) THEN
CAL            IF (DEBUG(44).AND.XDEBUG) WRITE(6,*),'P,Q',P,Q
C
C---- Sums for background
C
            SBGOD = SBGOD + IOD
            SBGPOD = P*IOD + SBGPOD
            SBGQOD = Q*IOD + SBGQOD
            S = S + 1
            SP = P + SP
            SQ = Q + SQ
            SPP = P*P + SPP
            SQQ = Q*Q + SQQ
            SPQ = P*Q + SPQ
          END IF
 72     CONTINUE
 74   CONTINUE
      PQSUMS(1) = SPP
      PQSUMS(2) = SQQ
      PQSUMS(3) = SPQ
      PQSUMS(4) = SP
      PQSUMS(5) = SQ
      PQSUMS(6) = S
      SPQOD(1) = SBGPOD
      SPQOD(2) = SBGQOD
      SPQOD(3) = SBGOD
C
      RETURN
      END


C== BGTEST ==
      SUBROUTINE BGTEST(OD,MASK,IRAS,MASKREJ,PQSUMS,BGMAX)
C     ====================================================
C
C---- Test background points, reject those more than bgmax from
C     least squares plane.
C     for rejected points, update background sums in PQSUMS.
C     NBREJ is number of background points rejected and is stored
C     in MASKREJ(1)
C
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C
C
C
C     .. Scalar Arguments ..
      REAL BGMAX
C     ..
C     .. Array Arguments ..
      REAL PQSUMS(6)
      INTEGER IRAS(5),MASK(MAXBOX),MASKREJ(NREJMAX),OD(MAXBOX)
C     ..
C     .. Local Scalars ..
      REAL A,APC,B,C,DEV,SOD,SPOD,SQOD
      INTEGER HX,HY,IJ,NBREJ,ODIJ,P,Q
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/sums.f
C
C $Id: sums.f,v 1.1 2002/05/02 10:47:21 harry Exp $
C
C--- awk generated include file  sums.h
C---- START of include file sums.h
C
C
C     Elements of ASPOT
C     1 = Summation integration intensity
C     2 = Total background counts under peak assuming peak has mm symmetry
C     3 = Rms variation in background, after rejecting background points.
C         This is evaluated in BGSOLVE called from EVAL.
C     4 = Centre of gravity in X direction (in pixels)
C     5 = Centre of gravity in Y direction (in pixels)
C         These are wrt an origin at the centre of the measurement box
C     6 = sum p*iod for background pixels
C     7 = sum q*iod for background pixels
C     8 = sum iod for background pixels
C     9 = Background plane constant a (gradient in X direction)
C    10 = Background plane constant b (gradient in Y direction)
C    11 = Background plane constant c 
C    12 = Largest deviation from background plane, excluding rejected pixels
C    13 = Profile fitted intensity
C    14 = Variance of profile fitted intensity = sum (deltasq) for peak
C         pixels only. Used to calculate PKRATIO and also profile fitted
C         sigma(I) in unweighted case only.
C    15 = Number of rejected background pixels
C    16 = Variance of profile fitted intensity in weighted case (default)
C    17 = sum W*DELTA**2 for profile fit
C    18   unused
C     .. Arrays in common block /SUMS/ ..
      REAL ASPOT
C     ..
C     .. Common Block /SUMS/ ..
      COMMON /SUMS/ASPOT(18)
C     ..
C
C
C&&*&& end_include  ../inc/sums.f
C     ..
C     .. Equivalences ..
      EQUIVALENCE (ASPOT(6),SPOD), (ASPOT(7),SQOD), (ASPOT(8),SOD),
     +            (ASPOT(9),A), (ASPOT(10),B), (ASPOT(11),C)
C     ..
      SAVE
C
C
      HX = IRAS(1)/2
      HY = IRAS(2)/2
      NBREJ = 0
      IJ = 0
C
C
      DO 20 P = -HX,HX
        APC = A*P + C
C
C
        DO 10 Q = -HY,HY
          IJ = IJ + 1
C
C
          IF (MASK(IJ).LT.0) THEN
C
C---- Background points
C
            DEV = FLOAT(OD(IJ)) - (B*FLOAT(Q) + APC)
C
C
            IF (ABS(DEV).GT.BGMAX) THEN
              NBREJ = NBREJ + 1
C
C
              IF (NBREJ.GT.NREJMAX-1) THEN
                GO TO 30
              ELSE
                ODIJ = OD(IJ)
                MASKREJ(NBREJ+1) = IJ
                PQSUMS(1) = PQSUMS(1) - P*P
                PQSUMS(2) = PQSUMS(2) - Q*Q
                PQSUMS(3) = PQSUMS(3) - P*Q
                PQSUMS(4) = PQSUMS(4) - P
                PQSUMS(5) = PQSUMS(5) - Q
                PQSUMS(6) = PQSUMS(6) - 1
                SPOD = SPOD - ODIJ*P
                SQOD = SQOD - ODIJ*Q
                SOD = SOD - ODIJ
              END IF
            END IF
          END IF
   10   CONTINUE
   20 CONTINUE
C
C
      MASKREJ(1) = NBREJ
      RETURN
   30 MASKREJ(1) = -999
C
C
      END
C== BMATRX ==
C
C
C
      SUBROUTINE BMATRX(B,R,C,WAVE)
C     =============================
C
C---- Build cell orthogonalization matrix B.
C         R are the recip cell parameters
C     and C the real cell parameters.
C
C  Ref: W.R.Busing & H.A.Levy, Acta Cryst. (1967) 22, 457-464
C
C       B =  ( a*       b* cos gamma*   c* cos beta*            )
C            ( 0        b* sin gamma*  -c* sin beta* cos alpha  )
C            ( 0             0            lambda / c            )
C
C
C
C
C
C     .. Scalar Arguments ..
      REAL WAVE
C     ..
C     .. Array Arguments ..
      REAL B(3,3),C(6),R(6)
C     ..
C     .. Local Scalars ..
      REAL DTOR
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC COS,SIN
C     ..
C
C
      DTOR = ATAN(1.0)*4.0/180.0
C
      B(1,1) = R(1)
      B(1,2) = COS(DTOR*R(6))*R(2)
      B(1,3) = COS(DTOR*R(5))*R(3)
      B(2,1) = 0.0
      B(2,2) = SIN(DTOR*R(6))*R(2)
      B(2,3) = -SIN(DTOR*R(5))*R(3)*COS(DTOR*C(4))
      B(3,1) = 0.0
      B(3,2) = 0.0
      B(3,3) = WAVE/C(3)
C
C
      END
C== BSWAP ==                            
C
C
      SUBROUTINE BSWAP(K1,K2,IP)
C     =========================
C
C     Image plate version
C---- Moves I*2 words K1:K2 from IMAGE in /PEL/ to IDUM in /PRO/
C     starting at IP in IDUM
C
C
C
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      INTEGER IP,K1,K2
C     .. Local Scalars ..
      INTEGER I1,I2,K
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/pro.f
C
C $Id: pro.f,v 1.1 2002/05/02 10:47:09 harry Exp $
C
C--- awk generated include file  pro.h
C---- START of include file pro.h
C
C
C     .. Arrays in common block /PRO/ ..
      INTEGER*2 IDUM
C     ..
C     .. Common Block /PRO/ ..
      COMMON /PRO/IDUM(MAXBUFF)
C     ..
C
C
C&&*&& end_include  ../inc/pro.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C     ..
      SAVE
C
C
      I1 = K1 + IPOINT - 1
      I2 = K2 + IPOINT - 1
C
C
      DO 10 K = I1,I2
      IDUM(IP) = IMAGE(K)
      IP = IP + 1
   10 CONTINUE
C
C
      END
C== BSWAP2 ==                            
C
      SUBROUTINE BSWAP2(K1,K2,IP)
C     =========================
      IMPLICIT NONE
C
C     Image plate version
C---- Moves I*2 words K1:K2 from the next image, stored in array
C     IMAGE in /PEL/
C     and add them into the values already in IDUM in /PRO/ starting at IP 
C     in IDUM
C
C     This is to allow summation of partially recorded reflections
C     from adjoining images.
C
C---- Modify 12/9/81 to allow for extended dynamic range to 64K
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      INTEGER IP,K1,K2
C     .. Local Scalars ..
      INTEGER I1,I2,K,ISUM,ICOUNT,ICOUNT2,IADD
C     ..
C     .. Extrinsic Functions ..
      INTEGER  INTPXL,PUTPXL
      EXTERNAL  INTPXL,PUTPXL
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/pro.f
C
C $Id: pro.f,v 1.1 2002/05/02 10:47:09 harry Exp $
C
C--- awk generated include file  pro.h
C---- START of include file pro.h
C
C
C     .. Arrays in common block /PRO/ ..
      INTEGER*2 IDUM
C     ..
C     .. Common Block /PRO/ ..
      COMMON /PRO/IDUM(MAXBUFF)
C     ..
C
C
C&&*&& end_include  ../inc/pro.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C     ..
      SAVE
C
C                    
C  Set up the pointer. Note that we are reading from the SECOND image
C  here, not the one currently being processed. ISTART is the location
C  of the first strip of data for the image currently being processed
C  in IMAGE, IADD is the pointer to the first strip of the second image
C
      IF (ISTART.EQ.0) THEN
        IADD = NREC*IYLEN
      ELSE IF (ISTART.EQ.NREC) THEN
        IADD = -NREC*IYLEN
      END IF                             
C
C	WRITE(6,*),'ISTART,NREC,IYLEN,IADD',ISTART,NREC,IYLEN,IADD
      I1 = K1 + IPOINT - 1 +IADD
      I2 = K2 + IPOINT - 1 +IADD
C
C
      DO 10 K = I1,I2
      ICOUNT = INTPXL(IDUM(IP))
      ICOUNT2 = INTPXL(IMAGE(K))
      ISUM = ICOUNT + ICOUNT2
      IDUM(IP) = PUTPXL(ISUM)
      IP = IP + 1
   10 CONTINUE
C
C
      END
C $Id: cbf_info.f,v 1.8 2004/01/29 11:11:27 harry Exp $
      SUBROUTINE CBF_INFO(ODFILE,MODEOP,OFFSET)
C
C---- Gets information from a CBF file via Paul Ellis's C routines and
C     puts them into a form that FORTRAN programs can deal with. 
C
C     DEBUG(69) this routine
C
      IMPLICIT NONE
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C
C---- arguments
C
      INTEGER MODEOP
C
C---- Local scalars
C
      INTEGER I,II,IERR,J,JJ,NSTRIP,CHKSTRP
      CHARACTER DETECTOR_CHARACTER
      CHARACTER DETECTOR_ID(64)
      CHARACTER ASL_INDEX(2)
      CHARACTER*200 ODFILE
      REAL DTOR,OMEGAFD,TOL
      INTEGER OFFSET
C
C---- list of variables which are not used at present but might be
C     sometime in the future!
C     INTEGER MAXPIX, MINPIX, MINX, MINY, MAXX, MAXY,IOD,pixmin,pixmax
C     INTEGER OVERLOAD, DIMENSION(2), PRECEDENCE(2)
C     INTEGER ID, INDEX
C     INTEGER COLUMN, ROW
C     CHARACTER*80 ARGV
C     CHARACTER DIRECTION(2), ARRAY_ID, RADIATION
C     CHARACTER DETECTOR
C     
C---- The following is used for transferring values between the C stuff
C     and Fortran for CBF images
C
C&&*&& include  ../inc/cbfinc.f
C
C---- The following are used for transferring values between the C stuff
C     and Fortran for CBF images (see wrapper.f for assignments)
C
       DOUBLE PRECISION CBF_DOUBLE(16)
       INTEGER*4 CBF_INT4(16)
       INTEGER CBF_INT(16)
       CHARACTER*24 CBF_CHAR(16)
       LOGICAL CBF_LOG(16)
       COMMON /CBF_PAR/ CBF_DOUBLE,CBF_INT4,CBF_INT,CBF_CHAR,CBF_LOG
C&&*&& end_include  ../inc/cbfinc.f
C&&*&& include  ../inc/condata.f
C
C $Id: condata.f,v 1.14 2004/07/20 12:40:18 harry Exp $
C
C--- awk generated include file condata.h 
C---- START of include file condata.h 
C 
C
C     FIXSWAP     Forces reversal of normal byte-swapping choice.
C
C---- SUMPART True if two images are to be stored in memory at the
C               same time. This will be the case if post-refinement
C               (other than POSTHOC post-refinement for off-line
C               scanners) is being performed. Note that SUMPART is NOT
C               used to determine if partials should be added across
C               images (this is ADDPART)
C
C---- NEWPREF True if allowing partials over multiple images in post-
C             refinement.
C
C---- ADDPART True if partials are to be summed across images. This is
C               only appropriate for fixed origin (ie on-line)
C               scanners where the X-ray dose is identical for
C               each image.
C     Direct beam coordinates
C             These are read into XMM(3), YMM(3) where (3) is for A,B,C packs
C             Immediately on reading in, these values are transferred
C             into XCENMM, YCENMM, XCENMMIN(J,3) where J=1->MAXPAX.
C
C             If an IMAGE keyword has been given, XCENMM(1,1)=XMM(1) and
C             YCENMM(1)=YSCAL*YMM(1). If swung out, YCENMM(1,1) is updated.
C             If a BEAM keyword has not been given, XMM,YMM, XCENMM,YCENMM,
C             XCENMMIN are all set to the middle of the image.


C             Then, when reflecting input to logfile, it AGAIN sets up
C             XCENMM,YCENMM for all images using XMM,YMM, this time
C             using YSCAL to set up YCENMM, and updating YCENMM if the
C             detctor is swung out. (label 708), DO loop 710. If image
C             is "inverted", corrects XCENMM for all images.


C             XCEN,YCEN are set in "mosflm" to XCENF, YCENF plus
C             camera constants, and XCENF,YCENF are in turn set from
C             XCENMM,YCENMM. Thus XCENMM,YCENMM are what is actually
C             used to define the beam position.

C
C     LPREF   If TRUE, return to display after refinement over entire
C             image. Only active when integrating interactively. Set by
C             toggle button in Parameter window.
C

C     LOVERLAP  If TRUE, do not call the OVERLAP subroutine

C     ALLOUT  If TRUE, all reflections (whether measured or not, or
C             classified as BADSPOTS or not, will be written to the
C             output MTZ file.
C
C     NTDIG   Number of digits in image number, returned as zero if
C             there is an error in the template. Only used if TEMPLATE
C             keyword given.
C
C     TEMPLATE is TRUE if a TEMPLATE keyword has been given.
C
C     NOLP    If TRUE, do NOT apply the Lorentz Polarisation corrections
C
C     MULTIMTZ True if writing each "block" of images to a separate MTZ file
C
C     DISPMENU True if the run was started with a IMAGE keyword. Not to be
C              confused with WINOPEN which is true if the X-window display
C              is being used, but this is not necessarily starting with
C              a "IMAGE" keyword.
c     newgui - this means that we're talking through the new GUI.
c              except that we can't have it here because the prsummary 
c              subroutine, where we REALLY want it, clashes with this common
C
C     HACTIVEMASK,LACTIVEMASK,LACTIVE - only for Rigaku images which 
C     contain a compressed "active mask" (size=HACTIVEMASK bytes)
C     at the end of the image. Compression uses a modified run length encoding
C     at present (10.01.2003).
C
C     ..
C     .. Arrays in common /CONDATA/ ..
      REAL XCENMM,YCENMM,THFOIL,PHIBEGA,PHIENDA,RSYM,XMM,YMM,
     +     XCENMMIN,YCENMMIN
      REAL RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +     PHIRNG,YSCALIN,FULLFRAC,WTIME
C     ..
C     .. Arrays in common /CONDATA/ ..
      INTEGER IDPACK,NFPACK,NFIRST,ICASSET
      INTEGER IPACK1A,IPACK2A,ISERAR
      LOGICAL AVPROF,FILMPLOT,FORCEB,FORCEC
C
C     .. Scalars in common /CONDATA/ ..
C     ..
      INTEGER NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX
      INTEGER IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK
      LOGICAL FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF,ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW, 
     +        spostref,newgui,LACTIVEMASK,USERSPOT,HEADONLY
C     ..
C real arrays, then scalars, integer arrays, scalars, logicals
      COMMON /CONDATA/
     $       XCENMM(MAXPAX,3),
     +       YCENMM(MAXPAX,3), THFOIL(3),PHIBEGA(MAXPAX),
     $       PHIENDA(MAXPAX),RSYM(4,4,96),XMM(3),YMM(3),
     $       XCENMMIN(MAXPAX),YCENMMIN(MAXPAX),
     $       RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +       PHIRNG,YSCALIN,FULLFRAC,WTIME,
     $        IDPACK(MAXPAX),NFPACK(MAXPAX),NFIRST(MAXPAX),
     +        ICASSET(MAXPAX),IPACK1A(50),
     +        IPACK2A(50),ISERAR(50),
     $        AVPROF(MAXPAX),FILMPLOT(MAXPAX),FORCEB(MAXPAX),
     +        FORCEC(MAXPAX),
     $        NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX,
     $        IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK,
     $        FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF, spostref, ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW,
     $        newgui,LACTIVEMASK,USERSPOT,HEADONLY


C&&*&& end_include  ../inc/condata.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/fid.f
C
C $Id: fid.f,v 1.1 2002/05/02 10:46:47 harry Exp $
C
C--- awk generated include file  fid.h
C---- START of include file fid.h
C
C     XCENF,YCENF  Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame).
C                  For IP data this comes from the defined
C                  direct beam coordinates, for film data it is the
C                  midpoint of fiducials 1 and 3.
C
C     CCX,CCY      The difference (in 10 micron units) between the
C                  refined position of the direct beam (XCEN,YCEN) and
C                  the ideal direct beam coordinates (XCENF,YCENF),
C                  in the SCANNER coordinate frame.
C                  CCX,CCY are updated in RDIST. They are in "pixels"
C                  rather than mm (but expressed in 10micron units).
C
C     DTOFD        The distance (in 10 micron units) from the crystal
C                  to the detector along a normal to the detector.
C                  For flat, unswung detectors, or swung on a 2 theta arm,
C                  this is the same as CTOFD and XTOFD. It differs for
C                  Vee shaped cassettes. Assigned in START and never changed.
C                  Only actually used in RMAXR for calculating box sizes.
C
C     .. Arrays in common /FID/ ..
      REAL CCOMABC
      INTEGER FSPOS,CCXABC,CCYABC
C     ..
C     .. Scalars in common /FID/ ..
      REAL OMEGAF,CCOM,DTOFD,XCENF,YCENF
      INTEGER MM,MMDB,NFID,CCX,CCY,IYOFF
C     ..
C     .. Common block /FID/ ..
      COMMON /FID/CCOMABC(3),OMEGAF,CCOM,DTOFD,XCENF,YCENF,FSPOS(4,2),
     +       CCXABC(3),CCYABC(3),MM,MMDB,NFID,CCX,CCY,IYOFF
C     ..
C
C
C&&*&& end_include  ../inc/fid.f
C&&*&& include  ../inc/header.f
C
C $Id: header.f,v 1.7 2003/07/24 13:11:41 harry Exp $
C
C--- awk generated include file  header.h
C---- START of include file header.h
C     .. Scalars in common block /HEADER/
      REAL HDIST,HWAVE,HPHIS,HPHIE,HRAST,HTWOTHETA,HTOR,HOMEGA,
     $     HPHI,HKAPPA,HCHI,HBEAMX,HBEAMY,HCCOMEGA,HTWIST,HTILT
      INTEGER NHEAD,NTAIL,HNULLPIX,HSERIAL,HYEAR,HDATE,HCOMPR,HOVER(3),
     $     HBIAS,SUMBYTES,HUNDER,HDATEC
      LOGICAL USEHDR,USETAIL,USEDIST,USEWAVE,USEPHI,HDRSIZE
C     ..
C     .. Arrays in common block /HEADER/
      INTEGER*4 IHEAD
C     ..
C     .. Common Block /HEADER/
      COMMON /HEADER/ HDIST,HWAVE,HPHIS,HPHIE,HRAST,HTWOTHETA,HTOR,
     $     HOMEGA,HPHI,HKAPPA,HCHI,HBEAMX,HBEAMY,HCCOMEGA,HTWIST,HTILT,
     $     IHEAD(MAXHEAD),NHEAD,NTAIL,HNULLPIX,HSERIAL,HYEAR,HDATE,
     +     HCOMPR,HOVER,HBIAS,SUMBYTES,HUNDER,HDATEC,USEHDR,USETAIL,
     +     USEDIST,USEWAVE,USEPHI,HDRSIZE
C     ..
      CHARACTER HCOMPRESS*3,HMONTH*3,HOSCAXIS*6
      COMMON /CHEADER/ HCOMPRESS,HMONTH,HOSCAXIS
C&&*&& end_include  ../inc/header.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
C&&*&& include  ../inc/parm1.f
C
C $Id: parm1.f,v 1.1 2002/05/02 10:47:05 harry Exp $
C
C--- awk generated include file  parm1.h
C---- START of include file parm1.h
C
C
C
C     .. Scalars in common block /PARM1/ ..
      REAL BGSIG,EFAC,EFACSQ,BGFREJ,GRADMAX,GRADMAXR,BGRAT,PKRAT,
     +     RESD,RESDLOW
      INTEGER CUTOFF,NOVPIX,NDSTART,NDTOT,IXDMIN,IXDMAX,IYDMIN,IYDMAX,
     +     IDMIN,IDMAX
      LOGICAL DUMPSPOT,BADPLOT,DUMPALL,BADPLOT2
C     ..
C     .. Common Block /PARM1/ ..
      COMMON /PARM1/BGSIG,EFAC,EFACSQ,BGFREJ,GRADMAX,GRADMAXR,
     +              BGRAT,PKRAT,RESD,RESDLOW,CUTOFF,NOVPIX,
     +              NDSTART,NDTOT,IXDMIN,IXDMAX,IYDMIN,IYDMAX,
     +              IDMIN,IDMAX,DUMPSPOT,BADPLOT,DUMPALL,BADPLOT2
C     ..
C
C
C&&*&& end_include  ../inc/parm1.f
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/savall.f
C
C $Id: savall.f,v 1.1 2002/05/02 10:47:15 harry Exp $
C
C---- START of include file savall.h
C
C      NSAVIMG      Number of images used in autoindexing
C      ISAVIMG      Array storing image numbers used in last autoindexing
C      NSAVSEG      Number of segments used in last postref run
C      ISFIRST      Array storing image number of the first image
C                   in all segments of last postref run.
C      SAVMATSR     Indicates whether last matrix was determined by
C                   autoindexing (Autoindexing) or by postref (Post refinement)
C      SAVMATNAM    Name of the matrix file
C      SAVENAM      Name of savefile
C      SVSCN        SCANNER keyword
C      SVSITE       SITE keyword
C      RES          High resolution limit given on RESOL keyword
C      RESLOW       Low resolution limit given on RESOL keyword
C
C     .. Scalars in common block /SAVALL/ ..
      REAL RES,RESLOW
      INTEGER NSAVIMG,NDIR,NSAVSEG
      CHARACTER SAVMATSTR*80,SAVMATNAM*80,SAVENAM*80,SVSCN*80,
     +          SVSITE*80
      LOGICAL IISCN,IISITE,IIWAVE,IIDIV,IIDISP,IINULL,IIRAST,IISEP,
     +        IIOVER,IIPIX,IIBACK,IIRES
C     ..
C     .. Arrays in common block /SAVALL/ ..
C
      INTEGER ISAVIMG(MAXIMG),ISFIRST(100)
C     .. Common Block /SAVALL/ ..
      COMMON /SAVALL/ RES,RESLOW,ISAVIMG,ISFIRST,NSAVIMG,NDIR,NSAVSEG,
     +       IISCN,IISITE,IIWAVE,IIDIV,IIDISP,IINULL,IIRAST,IISEP,
     +        IIOVER,IIPIX,IIBACK,IIRES
C
C
      COMMON /SAVALLC/ SAVMATSTR,SAVMATNAM,SAVENAM,SVSCN,SVSITE
C     ..
C
C
C&&*&& end_include  ../inc/savall.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C&&*&& include  ../inc/xy.f
C
C $Id: xy.f,v 1.1 2002/05/02 10:47:25 harry Exp $
C
C--- awk generated include file  xy.h
C---- START of include file xy.h
C
C     .. Scalars in common block /XY/ ..
      REAL XTOFD,SINV,COSV,TANV,TWOTHETA
      INTEGER ICASS
C     ..
C     .. Common Block /XY/ ..
      COMMON /XY/XTOFD,SINV,COSV,TANV,TWOTHETA,ICASS
C     ..
C
C     XTOFD....  Crystal to detector distance in 10 micron units. Read from
C                keyworded input and never changed.
C
C                Spot positions are calculated in S/R XYSPOT (Called from
C                REEK) and are for an "ideal" detector at a distance of XTOFD.
C                These are converted into pixel positions in S/R MMTOPX
C                which applies the multiplicative factor XTOFRA to allow
C                for refinement of the distance. XTOFRA is the parameter
C                that is actually refined (in RDIST), rather than XTOFD.
C                The refined distance that is printed in the logfile is
C                actually XTOFRA*XTOFD
C
C     ICASS....  Indicates detector type:
C                0     Flat film
C                1     Vee shaped cassettes
C                2     FAST detector (only used in TESTGEN mode of OSCGEN)
C                3     Swung out FAST (ditto)
C                4     IP detector
C     TWOTHETA   Detector swing angle (degrees)
C&&*&& end_include  ../inc/xy.f
C
C     Key to contents of arrays (but N.B. these may well change before 
C     final implementation):
C
C    CBF_INT(1)      = horizontal direction precedence
C    CBF_INT(2)      = vertical direction precedence
C    CBF_INT(3)      = dimension of horizontal pixels
C    CBF_INT(4)      = dimension of vertical  pixels
C    CBF_INT(5)      = unused so far 
C    CBF_INT(6)      = unused so far 
C    CBF_INT(7)      = unused so far 
C    CBF_INT(8)      = unused so far 
C    CBF_INT(9)      = unused so far 
C    CBF_INT(10)     = unused so far 
C    CBF_INT(11)     = unused so far 
C    CBF_INT(12)     = unused so far 
C    CBF_INT(13)     = unused so far 
C    CBF_INT(14)     = unused so far 
C    CBF_INT(15)     = unused so far 
C    CBF_INT(16)     = unused so far
C
C    CBF_INT4(1)     = overload value
C
C    CBF_DOUBLE(1)   = wavelength (Angstroms)
C    CBF_DOUBLE(2)   = crystal to detector distance (metres)
C    CBF_DOUBLE(3)   = pixel size in horizontal direction (metres)
C    CBF_DOUBLE(4)   = pixel size in vertical direction (metres)
C    CBF_DOUBLE(5)   = detector gain
C    CBF_DOUBLE(6)   = Oscillation angle about PHI start
C    CBF_DOUBLE(7)   = Oscillation angle about PHI end
C    CBF_DOUBLE(8)   = Oscillation angle about PHI range
C    CBF_DOUBLE(9)   = Polarization ratio of the radiation but unused so far
C    CBF_DOUBLE(10)  = unused so far
C    CBF_DOUBLE(11)  = unused so far
C    CBF_DOUBLE(12)  = unused so far
C    CBF_DOUBLE(13)  = unused so far
C    CBF_DOUBLE(14)  = unused so far
C    CBF_DOUBLE(15)  = unused so far
C    CBF_DOUBLE(16)  = unused so far
C
C    CBF_CHAR(1)     = horizontal direction of change (increasing or decreasing)
C    CBF_CHAR(2)     = vertical direction of change (increasing or decreasing)
C    CBF_CHAR(3)     = unused so far
C    CBF_CHAR(4)     = oscillation axis (expect PHI!)
C    CBF_CHAR(5)     = Radiation source (synchrotron, rotating anode...)
C    CBF_CHAR(6)     = Detector name
C    CBF_CHAR(7)     = Collimation string but unuseed so far
C    CBF_CHAR(8)     = unused so far
C    CBF_CHAR(9)     = unused so far
C    CBF_CHAR(10)    = unused so far
C    CBF_CHAR(11)    = unused so far
C    CBF_CHAR(12)    = unused so far
C    CBF_CHAR(13)    = unused so far
C    CBF_CHAR(14)    = unused so far
C    CBF_CHAR(15)    = unused so far
C    CBF_CHAR(16)    = unused so far
C
C    CBF_LOG(1)      = corresponds to INVERTX
C    CBF_LOG(2)      = unused so far
C    CBF_LOG(3)      = unused so far
C    CBF_LOG(4)      = unused so far
C    CBF_LOG(5)      = unused so far
C    CBF_LOG(6)      = unused so far
C    CBF_LOG(7)      = unused so far
C    CBF_LOG(8)      = unused so far
C    CBF_LOG(9)      = unused so far
C    CBF_LOG(10)     = unused so far
C    CBF_LOG(11)     = unused so far
C    CBF_LOG(12)     = unused so far
C    CBF_LOG(13)     = unused so far
C    CBF_LOG(14)     = unused so far
C    CBF_LOG(15)     = unused so far
C    CBF_LOG(16)     = unused so far
C
C    CBF_IMAGE()     = image data

      PARAMETER(TOL=1.0E-3)
      DTOR = ATAN(1.0)*4.0/180.0
      I = 1
      DO 1010 WHILE (ODFILE(i:i).ne.' ')
         I= I + 1
 1010 ENDDO
C
C make last character of filename CHAR NULL for the C routines
C
      ODFILE(i:i) = char(0)
      IERR = 0 
      CALL CBFWRAP(IERR,CBF_INT,CBF_INT4,CBF_DOUBLE,CBF_CHAR,
     $     ODFILE,IMAGE,OFFSET,MODEOP)
CAL      IF(MODEOP.EQ.2)THEN
C
C---- call to get image size only; I'm not sure if this is necessary at all
C
CAL         NREC    = CBF_INT(3)
CAL         IYLEN   = CBF_INT(4)
CAL      ENDIF
      IF(IERR.EQ.1)THEN
C         WRITE(IOUT,FMT=120) 
C         IF(ONLINE)WRITE(ITOUT,FMT=120) 
 120     FORMAT('Image file is not in CBF format! I guess its a Mar')
         RETURN
      ELSE IF(IERR.GT.1)THEN
         WRITE(IOUT,FMT=130) 
         IF(ONLINE)WRITE(ITOUT,FMT=130)             
 130     FORMAT('CBF file not found!')
      ELSE
         MACHINE = 'CBF '
         MODEL   = 'UNKNOWN'
         HEADINFO = .TRUE.
         USEHDR = .TRUE.
         NREC   = CBF_INT(3)
         IYLEN  = CBF_INT(4)
         CUTOFF = CBF_INT4(1)
         WAVE = CBF_DOUBLE(1)
         HWAVE = WAVE
         IF(WAVE.GT.0.0)THEN
            IIWAVE = .TRUE.
            IWAVE = 2
         ENDIF
C
C---- Detector model aliases
C
         IF (CBF_CHAR(6).EQ.'MAR180') THEN
           MODEL = 'MAR180'
         ELSEIF (CBF_CHAR(6).EQ.'MAR300') THEN
           MODEL = 'MAR300'
         ELSEIF (CBF_CHAR(6).EQ.'MAR345') THEN
           MODEL = 'MAR345'
         ELSEIF ((CBF_CHAR(6).EQ.'ADSCQUANTUM4').OR.
     +           (CBF_CHAR(6).EQ.'ADSCQUANTUM4R').OR.
     +           (CBF_CHAR(6).EQ.'ADSCQ4').OR.
     +           (CBF_CHAR(6).EQ.'ADSCQ4R')) THEN
           MODEL = 'ADSCQ4'
         ELSEIF ((CBF_CHAR(6).EQ.'MARCCD').OR.
     +           (CBF_CHAR(6).EQ.'MARCCD165')) THEN
           MODEL = 'MARCCD'
         ELSEIF (CBF_CHAR(6).EQ.'ADSCQ105') THEN
           MODEL = 'ADSCQ105'
         ELSEIF (CBF_CHAR(6).EQ.'ADSCQ210') THEN
           MODEL = 'ADSCQ210'
         ELSEIF (CBF_CHAR(6).EQ.'ADSCQ315') THEN
           MODEL = 'ADSCQ315'
         ELSEIF (CBF_CHAR(6).EQ.'RAXIS') THEN
           MODEL = 'RAXIS'
         ELSEIF ((CBF_CHAR(6).EQ.'RAXISII').OR.
     +           (CBF_CHAR(6).EQ.'RAXIS2')) THEN
           MODEL = 'RAXISII'
         ELSEIF ((CBF_CHAR(6).EQ.'RAXISIV').OR.
     +           (CBF_CHAR(6).EQ.'RAXIS4')) THEN
           MODEL = 'RAXISIV'
         ELSEIF ((CBF_CHAR(6).EQ.'RAXISV').OR.
     +           (CBF_CHAR(6).EQ.'RAXIS5')) THEN
           MODEL = 'RAXISV'
         ELSEIF ((CBF_CHAR(6).EQ.'FUJI2000').OR.
     +           (CBF_CHAR(6).EQ.'BAS2000').OR.
     +           (CBF_CHAR(6).EQ.'BA100').OR.
     +           (CBF_CHAR(6).EQ.'FUJIBAS2000').OR.
     +           (CBF_CHAR(6).EQ.'FUJIBA100')) THEN
           MODEL = 'FUJI'
         ELSEIF ((CBF_CHAR(6).EQ.'DIP2000').OR.
     +           (CBF_CHAR(6).EQ.'DIP2020').OR.
     +           (CBF_CHAR(6).EQ.'DIP2030').OR.
     +           (CBF_CHAR(6).EQ.'DIP2040')) THEN
           MODEL = 'DIP20X0'
         ELSEIF ((CBF_CHAR(6).EQ.'SBC1CCD').OR.
     +           (CBF_CHAR(6).EQ.'OXFORDCCD').OR.
     +           (CBF_CHAR(6).EQ.'OXFORD3X3CCD')) THEN
           MODEL = 'SBC1CCD'
         ELSEIF (CBF_CHAR(6).EQ.'SBC2CCD') THEN
           MODEL = 'SBC2CCD'
         ELSEIF (CBF_CHAR(6).EQ.'ESRFCCD') THEN
           MODEL = 'ESRFCCD'
         ELSEIF (CBF_CHAR(6).EQ.'ESRFLIPS') THEN
           MODEL = 'LIPS'
         ELSEIF ((CBF_CHAR(6).EQ.'MD').OR.
     +           (CBF_CHAR(6).EQ.'MOLECULARDYNAMICS')) THEN
           MODEL = 'MD'
         ELSEIF (CBF_CHAR(6).EQ.'PRINCETONCCD') THEN
           MODEL = 'CCD1'
         ELSEIF (CBF_CHAR(6).EQ.'JUPITER') THEN
           MODEL = 'JUPITER'
         ELSEIF (CBF_CHAR(6).EQ.'SATURN') THEN
           MODEL = 'SATURN'
         ELSEIF (CBF_CHAR(6).EQ.'MERCURY') THEN
           MODEL = 'MERCURY'
         ELSE
           MODEL = 'UNKNOWN'
         ENDIF
C     
C---- distance in MOSFLM is 10 micron units, CBF files have it in metres
C
         IF(CBF_DOUBLE(2).NE.-999.0)THEN
            XTOFD   = CBF_DOUBLE(2)*1E5
            HDIST   = XTOFD/100.0
            IF(XTOFD.GT.0)IDIST = 1
         ELSE
            WRITE(IOUT,140)
            if(ONLINE)WRITE(ITOUT,140)
 140        FORMAT('**** WARNING! CBF file does not include ',
     $           'crystal to detector distance! *****')
         endif
C
C---- Pixel size, horizontal and vertical, calculate YSCALE
C
         IF(CBF_DOUBLE(3).NE.-999.0)THEN
            RAST    = CBF_DOUBLE(3)
            IF(RAST.GT.0)IIRAST = .TRUE.
         ELSE
            WRITE(IOUT,150)
            if(ONLINE)WRITE(ITOUT,150)
 150        FORMAT('**** ERROR! CBF file does not include ',
     $           'horizontal pixel size! *****')
         endif
         IF(CBF_DOUBLE(3).LE.TOL)THEN
            WRITE(IOUT,160)CBF_DOUBLE(3)/100
            IF(ONLINE)WRITE(ITOUT,160)CBF_DOUBLE(3)/100
 160        FORMAT('**** ERROR! CBF file has a horizontal ',
     $           'pixel size which is too small (',F8.4,
     $           ' mm')
         ELSEIF(CBF_DOUBLE(4).NE.-999.0)THEN
            YSCAL   = CBF_DOUBLE(4)/CBF_DOUBLE(3)
         ELSE
            WRITE(IOUT,170)
            if(ONLINE)WRITE(ITOUT,170)
 170        FORMAT('**** ERROR! CBF file does not include ',
     $           'vertical pixel size! *****')
         endif
C
C---- detector gain
C
         IF(CBF_DOUBLE(5).NE.-999.0)THEN
            GAIN    = CBF_DOUBLE(5)
         ELSE
            WRITE(IOUT,180)
            if(ONLINE)WRITE(ITOUT,180)
 180        FORMAT('**** WARNING! CBF file does not include ',
     $           'detector gain! *****')
         endif
         IF((CBF_DOUBLE(6).NE.-999.0).and.
     $        (CBF_DOUBLE(7).NE.-999.0).and.
     $        (CBF_DOUBLE(8).NE.-999.0))THEN
            HPHIS   = CBF_DOUBLE(6)
            HPHIE   = CBF_DOUBLE(7)
            IF(CBF_DOUBLE(7)-CBF_DOUBLE(6)-CBF_DOUBLE(8).GT.TOL)THEN
               WRITE(IOUT,FMT=100)
               IF(ONLINE)WRITE(ITOUT,FMT=100)
 100           FORMAT('INPUT oscillation angles obtained from the ',
     $              'CBF file contain errors !! Check these values ',
     $              'carefully')
            ENDIF
         ELSE
            WRITE(IOUT,190)
            if(ONLINE)WRITE(ITOUT,190)
 190        FORMAT('**** WARNING! CBF file does not include ',
     $           'information about the oscillation ',
     $           'range! *****')
         endif
C     
C---- Polarization not defined yet in imgCIF dictionary
C
C         IF(CBF_DOUBLE(7).NE.-999.0)THEN
C            TOR = CBF_DOUBLE(7)
C         ELSE
C            WRITE(IOUT,200)
C            if(ONLINE)WRITE(ITOUT,200)
C 200        FORMAT('**** INFORMATION! CBF file does not include ',
C     $           'polarization figure! *****')
C         endif
C     
C---- now work out OMEGAFD and INVERTX
C
         IF(CBF_DOUBLE(10).NE.-999.0)THEN
            OMEGAFD = CBF_DOUBLE(10)
         ELSE
            WRITE(IOUT,210)
            IF(ONLINE)WRITE(ITOUT,210)
 210        FORMAT('**** WARNING! CBF file does not include ',
     $           'rotation axis orientation! *****')
         ENDIF

         INVERTX = .FALSE.
         OMEGAF = OMEGAFD * DTOR
C
C----
C
         IF(DEBUG(69))THEN
            write(iout,fmt=1000)NREC,IYLEN,CUTOFF,WAVE,XTOFD/100,
     $           XTOFD,RAST,RAST*YSCAL,GAIN,OMEGAFD,INVERTX
            write(itout,fmt=1000)NREC,IYLEN,CUTOFF,WAVE,XTOFD/100,
     $           XTOFD,RAST,RAST*YSCAL,GAIN,OMEGAFD,INVERTX
 1000       format(80('*'),/,'The image is ',I4,' by ',I4,' pixels ',
     $           'in size with an overload cutoff of ',I8,/,'The ',
     $           'wavelength is ',F9.6,' Angstroms, and the ',/,
     $           'crystal to ',
     $           'detector distance is ',F7.2,'mm or ',F9.0,
     $           'microns.'/,'The pixels are ',F8.4,' by ',F8.4,'mm',
     $           'and the detector gain is ',F5.2,/,'Omega is ',F5.1,
     $           ' and INVERTX is ',L1,/,/,80('='))
         ENDIF
C     
C---- Check to see if it's a tiled detector with a stripe 
C     of nulls which can adversely affect the background measurement in spot-
C     finding; for the moment this is only in the middle of a detector with
C     stripes across the middle, so if it's swung out this won't adjust 
C     properly.
C
         NSTRIP = 0
         NTILEY = 1
         NTILEX = 1
         CHKSTRP = 0
         DO 1030 I=(IYLEN/2)-10,(IYLEN/2)+10,1
            IF(IMAGE(I).LE.ICONST.AND.IMAGE(I).GE.0)THEN
               IF(CHKSTRP.EQ.I)THEN
C     
C---- STRIP ALREADY CHECKED
C     
                  CHKSTRP = I + 1
                  NSTRIP = 0
               ELSE
C     
C---- NEW STRIP
C     
                  NSTRIP = 0
                  DO 1020 J=1,NREC-1,1
                     JJ = I+IYLEN*J
                     IF(IMAGE(JJ).LE.ICONST.AND.IMAGE(JJ).GE.0)THEN
                        NSTRIP = NSTRIP + 1
                     ENDIF
 1020             ENDDO
               ENDIF
            ENDIF
            IF(NSTRIP.GT.0.5*NREC)THEN
               NTILEX = NTILEX + 1
               CHKSTRP = I+1
            ENDIF
 1030    ENDDO
         CHKSTRP = 0
         DO 1050 II=(NREC/2)-10,(NREC/2+10),1
            I = II*IYLEN
            IF(IMAGE(I).LE.ICONST.AND.IMAGE(I).GE.0)THEN
               IF(CHKSTRP.EQ.I)THEN
C     
C---- strip already checked
C
                  CHKSTRP = I + IYLEN
                  NSTRIP = 0
               ELSE
C     
C---- new strip
C     
                  NSTRIP = 0
                  DO 1040 J=1,IYLEN,1
                     JJ = I+IYLEN
                     IF(IMAGE(JJ).LE.ICONST.AND.IMAGE(JJ).GE.0)THEN
                        NSTRIP = NSTRIP + 1
                     ENDIF
 1040             ENDDO
               ENDIF
            ENDIF
            IF(NSTRIP.GT.0.5*NREC)THEN
               NTILEY = NTILEY + 1
               CHKSTRP = I + IYLEN
            ENDIF
 1050    ENDDO
         IF(NTILEX.GT.1.OR.NTILEY.GT.1)THEN
            TILED = .TRUE.
            DO 1060 I=1,NTILEX-1,1
               TILEX(I)=NREC/NTILEX
               TILEWX(I)=10
 1060       ENDDO
            DO 1070 I=1,NTILEY-1,1
               TILEY(I)=NREC/NTILEY
               TILEWY(I)=10
 1070       ENDDO
         ENDIF
      ENDIF
      RETURN
      END
C== CBYTE ==                            
      SUBROUTINE CBYTE(I)
C     ===================
C
      IMPLICIT NONE
C     Image plate version
C---- Get the I'th I*2 word for the current strip (IPOINT'th)
C     from IMAGE and pass it back through /PEL/.
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      INTEGER I
C     ..
C     .. Extrinsic Functions ..
      INTEGER  INTPXL
      EXTERNAL  INTPXL
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/pro.f
C
C $Id: pro.f,v 1.1 2002/05/02 10:47:09 harry Exp $
C
C--- awk generated include file  pro.h
C---- START of include file pro.h
C
C
C     .. Arrays in common block /PRO/ ..
      INTEGER*2 IDUM
C     ..
C     .. Common Block /PRO/ ..
      COMMON /PRO/IDUM(MAXBUFF)
C     ..
C
C
C&&*&& end_include  ../inc/pro.f
C     ..
      SAVE
C
C
      IBA = INTPXL(IMAGE(IPOINT+I-1))
C   
      END
C== CBYTE2 ==                           
      SUBROUTINE CBYTE2(I)
C     ====================
      IMPLICIT NONE
C
C     Image plate version
C---- Get the I'th I*2 word from the ods stored in BOXOD IN /PEL/
C     and pass it back through IBA in /PEL/. Note that this calls 
C     INTPXL2 which applies a non-linearity correction.
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      INTEGER I
C     ..
C     .. Extrinsic Functions ..
      INTEGER  INTPXL2
      EXTERNAL  INTPXL2
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/pro.f
C
C $Id: pro.f,v 1.1 2002/05/02 10:47:09 harry Exp $
C
C--- awk generated include file  pro.h
C---- START of include file pro.h
C
C
C     .. Arrays in common block /PRO/ ..
      INTEGER*2 IDUM
C     ..
C     .. Common Block /PRO/ ..
      COMMON /PRO/IDUM(MAXBUFF)
C     ..
C
C
C&&*&& end_include  ../inc/pro.f
C     ..
      SAVE
C
C
      IBA = INTPXL2(BOXOD(I))
      END
C== CELLCHK ==
      SUBROUTINE  CELLCHK(ICRYST,CELL,IFLAG)
C     ======================================
      IMPLICIT NONE
C
C---- Check cell is consistent with symmetry. ICRYST values 1 to 8
C     corresponds to triclinic to cubic symmetry
C
C
C     ..
C     .. Scalar Arguments ..
      INTEGER IFLAG,ICRYST
C     ..
C     .. Array Arguments ..
      REAL CELL(6)
C     ..
C     .. Local Scalars ..
      INTEGER I
C
      IF (ICRYST.EQ.1) THEN
C
C---- Triclinic
C
        CONTINUE
      ELSE IF (ICRYST.EQ.2) THEN
C
C---- Monoclinic
C
        DO 10 I = 4,6,2
          IF (ABS(CELL(I)-90.0).GT.0.002) IFLAG = 1
 10     CONTINUE
      ELSE IF (ICRYST.EQ.3) THEN
C
C---- Orthorhombic
C
        DO 20 I = 4,6
          IF (ABS(CELL(I)-90.0).GT.0.002) IFLAG = 1
 20     CONTINUE
      ELSE IF (ICRYST.EQ.4) THEN
C
C---- Tetragonal
C
        DO 30 I = 4,6
          IF (ABS(CELL(I)-90.0).GT.0.002) IFLAG = 1
 30     CONTINUE
        IF (ABS(CELL(1)-CELL(2)).GT.0.01) IFLAG = 1
      ELSE IF ((ICRYST.EQ.5).OR.(ICRYST.EQ.6)) THEN
C
C---- Trigonal or hexagonal
C
        DO 40 I = 4,5
          IF (ABS(CELL(I)-90.0).GT.0.002) IFLAG = 1
 40     CONTINUE
        IF (ABS(CELL(6)-120.0).GT.0.002) IFLAG = 1
        IF (ABS(CELL(1)-CELL(2)).GT.0.01) IFLAG = 1
      ELSE IF (ICRYST.EQ.7) THEN
C
C---- Cubic
C
        DO 50 I = 4,6
          IF (ABS(CELL(I)-90.0).GT.0.002) IFLAG = 1
 50     CONTINUE
        IF (ABS(CELL(1)-CELL(2)).GT.0.01) IFLAG = 1
        IF (ABS(CELL(2)-CELL(3)).GT.0.01) IFLAG = 1
        IF (ABS(CELL(1)-CELL(3)).GT.0.01) IFLAG = 1
      ELSE IF (ICRYST.EQ.8) THEN
C
C---- Rhombohedral cell, rhombohedral rather than hexagonal setting
C
        IF (ABS(CELL(1)-CELL(2)).GT.0.01) IFLAG = 1
        IF (ABS(CELL(2)-CELL(3)).GT.0.01) IFLAG = 1
        IF (ABS(CELL(1)-CELL(3)).GT.0.01) IFLAG = 1
        IF (ABS(CELL(4)-CELL(5)).GT.0.01) IFLAG = 1
        IF (ABS(CELL(4)-CELL(6)).GT.0.01) IFLAG = 1
        IF (ABS(CELL(5)-CELL(6)).GT.0.01) IFLAG = 1
      ELSE
C
C---- Unrecognised crystal class
C
        IFLAG = 1
      END IF
      END
C== CELLFIX ==
      SUBROUTINE  CELLFIX(XCELL)
C     ======================================
      IMPLICIT NONE
C
C---- Check cell is consistent with symmetry and if not, correct
C     it by setting angles to nearest integer and cell edges equal
C
C---- 05.06.2003: added a softening factor so that if angles
C     are a long way from regular, they don't suddenly jump and cause an
C     error; angles seem to be much more sensitive than cell edges...
C     ..
C     .. Scalar Arguments ..
C     ..
C     .. Array Arguments ..
      REAL XCELL(6)
C     ..
C     .. Local Scalars ..
      INTEGER I
      REAL ANG,D1,D2
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/cell.f
C
C $Id: cell.f,v 1.2 2003/06/16 16:41:13 harry Exp $
C
C--- awk generated include file  cell.h
C---- START of include file cell.h
C
C     CELL cell dimensions (real space)
C     RCELL reciprocal cell parameters in dimensionless rlu
C
C     .. Arrays in Common /CELLCOM/ ..
      REAL UMAT,BMAT,GMAT,CELL,RCELL,UMATCELL,SOFTCELL
      INTEGER LCELL,ICRYST,NUMSPG,NLAUE
C     ..
C     .. Common Block /CELLCOM/ ..
      COMMON /CELLCOM/UMAT(3,3),BMAT(3,3),GMAT(3,3),CELL(6),RCELL(6),
     $       UMATCELL(6),SOFTCELL,LCELL(6),ICRYST,NUMSPG,NLAUE
C     ..
C
C
C&&*&& end_include  ../inc/cell.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C
      IF (ICRYST.EQ.1) THEN
C
C---- Triclinic
C
        CONTINUE
      ELSE IF (ICRYST.EQ.2) THEN
C
C---- Monoclinic
C
        DO 10 I = 4,6,2
c          XCELL(I) = 90.000
          XCELL(I) = XCELL(I) - ((XCELL(I) - 90.0) * SOFTCELL)
 10     CONTINUE
      ELSE IF (ICRYST.EQ.3) THEN
C
C---- Orthorhombic
C
        DO 20 I = 4,6
C          XCELL(I) = 90.000
          XCELL(I) = XCELL(I) - ((XCELL(I) - 90.0) * SOFTCELL)
 20     CONTINUE
      ELSE IF (ICRYST.EQ.4) THEN
C
C---- Tetragonal
C
        DO 30 I = 4,6
c          XCELL(I) = 90.000
          XCELL(I) = XCELL(I) - ((XCELL(I) - 90.0) * SOFTCELL)
 30     CONTINUE
        D1 = (XCELL(1) + XCELL(2))/2
        XCELL(1) = D1
        XCELL(2) = D1
      ELSE IF ((ICRYST.EQ.5).OR.(ICRYST.EQ.6)) THEN
C
C---- Trigonal or hexagonal

C
        DO 40 I = 4,5
          XCELL(I) = XCELL(I) - ((XCELL(I) - 90.0) * SOFTCELL)
c          XCELL(I) = 90.00
 40     CONTINUE
        ANG = XCELL(6)
        D1 = ABS(ANG-60.0)
        D2 = ABS(ANG-120.0)
        IF (D1.LT.D2) THEN
c          XCELL(6) = 60.00
          XCELL(6) = XCELL(6) - ((XCELL(6) - 60.0) * SOFTCELL)
        ELSE
c          XCELL(6) = 120.0
          XCELL(6) = XCELL(6) - ((XCELL(6) - 120.0) * SOFTCELL)
        END IF
        D1 = (XCELL(1) + XCELL(2))/2.0
        XCELL(1) = D1
        XCELL(2) = D1
      ELSE IF (ICRYST.EQ.7) THEN
C
C---- Cubic
C
        DO 50 I = 4,6
          XCELL(I) = XCELL(I) - ((XCELL(I) - 90.0) * SOFTCELL)
c          XCELL(I) = 90.00
 50     CONTINUE
        D1 = (XCELL(1) + XCELL(2) + XCELL(3))/3.0
        XCELL(1) = D1
        XCELL(2) = D1
        XCELL(3) = D1
      ELSE IF (ICRYST.EQ.8) THEN
C
C---- Rhombohedral cell, rhombohedral rather than hexagonal setting
C
        D1 = (XCELL(1) + XCELL(2) + XCELL(3))/3.0
        XCELL(1) = D1
        XCELL(2) = D1
        XCELL(3) = D1
        D2 = (XCELL(4) + XCELL(5) + XCELL(6))/3.0
        IF(SOFTCELL.GE.0.999)THEN
          XCELL(4) = D2
          XCELL(5) = D2
          XCELL(6) = D2
        ELSE
          XCELL(4) = XCELL(4) - ((XCELL(4) - D2) * SOFTCELL)
          XCELL(5) = XCELL(5) - ((XCELL(5) - D2) * SOFTCELL)
          XCELL(6) = XCELL(6) - ((XCELL(6) - D2) * SOFTCELL)
        ENDIF
      ELSE
        WRITE(IOUT,FMT=6000) ICRYST
        IF (ONLINE) WRITE(ITOUT,FMT=6000) ICRYST
 6000   FORMAT(//1X,'**** WARNING ****',/,1X,
     +         'Cannot check cell parameters for unknown crystal',
     +         ' class',I5)
      END IF
      END
C     $Id: cellrefset.f,v 1.12 2003/09/30 16:49:21 harry Exp $
C     
      SUBROUTINE CELLREFSET(IFIRSTPACK,NREPEAT,ISEG,RPTFIRST,
     +     FIRSTTIME,INERR)
C     ===============================
C     
      IMPLICIT NONE
C     
C---- This subroutine both stores and restores parameters required for
C     cell refinement, so that the entire refinement can be repeated if
C     there
C     is a large shift in the cell.
C     On the first cycle, it stores the necessary parameters. For the
C     second
C     or subsequent segments, this requires interpreting stored lines of
C     
C     input that were read in CONTROL.
C     On the second or subsequent cycles, the necessary parameters are
C     restored for each segment.
C     
C     NREPEAT      Number of current cycle, initially zero.
C     ISEG         Number of the current segment (1 to NSEG)
C     
C     .. Parameters ..

c     this is what to change **CHANGEME**

      INTEGER NPARM
      PARAMETER (NPARM=200)
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C     
C     ..
C     .. Scalar Arguments ..
      INTEGER IFIRSTPACK,NREPEAT,ISEG
      LOGICAL INERR,RPTFIRST,FIRSTTIME
C     
C     ..
C     .. Array Arguments ..
C     ..
C     .. Local Scalars ..
      INTEGER I,NSER,NSERRUN,IPACKF,IPACKL,NRLEFT,MINBATCH,NPROCRUN,
     +     ierr,MODE
      LOGICAL BADKEY,NEWREAD
      CHARACTER LINE*400,KEY*4
C     ..
C     .. Local Arrays ..
C     ..
      INTEGER NFLEFT(40),NLLEFT(40),ISERLEFT(40)
      REAL PHILEFT(40),PHISLEFT(40),IFIRSTST(100),
     +     ILASTST(100),RESLOWST(100),RESANIST(3,100),
     $     RESCUTST(100),RESST(100),RESEXLST(10,100),RESEXHST(10,100)
      CHARACTER ODEXTST(100)*8,FDISKST(10,100)*80,IDENTST(100)*40,
     $     TEMPLSTARTST(100)*40,TEMPLENDST(100)*40
      CHARACTER*1024 OUTLINE
      LOGICAL ANITESST(100)
C     
C---- Things for parser
C     
      INTEGER IBEG(NPARM),IDEC(NPARM),IEND(NPARM),ITYP(NPARM)
      REAL VALUE(NPARM)
      INTEGER NTOK
C     
C     .. External Functions ..
      INTEGER LENSTR
      EXTERNAL LENSTR
C     ..
C     .. External Subroutines ..
      EXTERNAL MPARSE,CCPUPC
C     ..
C     .. Intrinsic Functions ..
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/condata.f
C
C $Id: condata.f,v 1.14 2004/07/20 12:40:18 harry Exp $
C
C--- awk generated include file condata.h 
C---- START of include file condata.h 
C 
C
C     FIXSWAP     Forces reversal of normal byte-swapping choice.
C
C---- SUMPART True if two images are to be stored in memory at the
C               same time. This will be the case if post-refinement
C               (other than POSTHOC post-refinement for off-line
C               scanners) is being performed. Note that SUMPART is NOT
C               used to determine if partials should be added across
C               images (this is ADDPART)
C
C---- NEWPREF True if allowing partials over multiple images in post-
C             refinement.
C
C---- ADDPART True if partials are to be summed across images. This is
C               only appropriate for fixed origin (ie on-line)
C               scanners where the X-ray dose is identical for
C               each image.
C     Direct beam coordinates
C             These are read into XMM(3), YMM(3) where (3) is for A,B,C packs
C             Immediately on reading in, these values are transferred
C             into XCENMM, YCENMM, XCENMMIN(J,3) where J=1->MAXPAX.
C
C             If an IMAGE keyword has been given, XCENMM(1,1)=XMM(1) and
C             YCENMM(1)=YSCAL*YMM(1). If swung out, YCENMM(1,1) is updated.
C             If a BEAM keyword has not been given, XMM,YMM, XCENMM,YCENMM,
C             XCENMMIN are all set to the middle of the image.


C             Then, when reflecting input to logfile, it AGAIN sets up
C             XCENMM,YCENMM for all images using XMM,YMM, this time
C             using YSCAL to set up YCENMM, and updating YCENMM if the
C             detctor is swung out. (label 708), DO loop 710. If image
C             is "inverted", corrects XCENMM for all images.


C             XCEN,YCEN are set in "mosflm" to XCENF, YCENF plus
C             camera constants, and XCENF,YCENF are in turn set from
C             XCENMM,YCENMM. Thus XCENMM,YCENMM are what is actually
C             used to define the beam position.

C
C     LPREF   If TRUE, return to display after refinement over entire
C             image. Only active when integrating interactively. Set by
C             toggle button in Parameter window.
C

C     LOVERLAP  If TRUE, do not call the OVERLAP subroutine

C     ALLOUT  If TRUE, all reflections (whether measured or not, or
C             classified as BADSPOTS or not, will be written to the
C             output MTZ file.
C
C     NTDIG   Number of digits in image number, returned as zero if
C             there is an error in the template. Only used if TEMPLATE
C             keyword given.
C
C     TEMPLATE is TRUE if a TEMPLATE keyword has been given.
C
C     NOLP    If TRUE, do NOT apply the Lorentz Polarisation corrections
C
C     MULTIMTZ True if writing each "block" of images to a separate MTZ file
C
C     DISPMENU True if the run was started with a IMAGE keyword. Not to be
C              confused with WINOPEN which is true if the X-window display
C              is being used, but this is not necessarily starting with
C              a "IMAGE" keyword.
c     newgui - this means that we're talking through the new GUI.
c              except that we can't have it here because the prsummary 
c              subroutine, where we REALLY want it, clashes with this common
C
C     HACTIVEMASK,LACTIVEMASK,LACTIVE - only for Rigaku images which 
C     contain a compressed "active mask" (size=HACTIVEMASK bytes)
C     at the end of the image. Compression uses a modified run length encoding
C     at present (10.01.2003).
C
C     ..
C     .. Arrays in common /CONDATA/ ..
      REAL XCENMM,YCENMM,THFOIL,PHIBEGA,PHIENDA,RSYM,XMM,YMM,
     +     XCENMMIN,YCENMMIN
      REAL RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +     PHIRNG,YSCALIN,FULLFRAC,WTIME
C     ..
C     .. Arrays in common /CONDATA/ ..
      INTEGER IDPACK,NFPACK,NFIRST,ICASSET
      INTEGER IPACK1A,IPACK2A,ISERAR
      LOGICAL AVPROF,FILMPLOT,FORCEB,FORCEC
C
C     .. Scalars in common /CONDATA/ ..
C     ..
      INTEGER NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX
      INTEGER IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK
      LOGICAL FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF,ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW, 
     +        spostref,newgui,LACTIVEMASK,USERSPOT,HEADONLY
C     ..
C real arrays, then scalars, integer arrays, scalars, logicals
      COMMON /CONDATA/
     $       XCENMM(MAXPAX,3),
     +       YCENMM(MAXPAX,3), THFOIL(3),PHIBEGA(MAXPAX),
     $       PHIENDA(MAXPAX),RSYM(4,4,96),XMM(3),YMM(3),
     $       XCENMMIN(MAXPAX),YCENMMIN(MAXPAX),
     $       RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +       PHIRNG,YSCALIN,FULLFRAC,WTIME,
     $        IDPACK(MAXPAX),NFPACK(MAXPAX),NFIRST(MAXPAX),
     +        ICASSET(MAXPAX),IPACK1A(50),
     +        IPACK2A(50),ISERAR(50),
     $        AVPROF(MAXPAX),FILMPLOT(MAXPAX),FORCEB(MAXPAX),
     +        FORCEC(MAXPAX),
     $        NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX,
     $        IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK,
     $        FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF, spostref, ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW,
     $        newgui,LACTIVEMASK,USERSPOT,HEADONLY


C&&*&& end_include  ../inc/condata.f
C&&*&& include  ../inc/ccondata.f
C
C $Id: ccondata.f,v 1.3 2003/01/30 13:26:03 harry Exp $
C
C--- awk generated include file  ccondata.h
C---- START of include file ccondata.h
C
C
C     .. Scalars in Common /CCONDATA/ ..
      CHARACTER GENFILE*200,CCFILE*200,ODEXT*8,WAXFN*134,
     +          GTITLE*80,IDENT*40,NEWMATNAM*80,MTZNAM*80,PGNAME*10,
     +          SPGNAM*10,ODFILE*200,SEPCHAR*1,SNEWMATNAM*80,
     +          TEMPLSTART*100,TEMPLEND*100,TEMPLSAV*100,BITMAPTYPE*12,
     $          CCP4VERSION*10
C     ..
C     ..  Arrays in Common /CCONDATA/ ..
      CHARACTER FDISK(10)*80,INLINE(1000)*80
C     ..
C     .. Common block /CCONDATA/ ..
      COMMON /CCONDATA/GENFILE,CCFILE,ODEXT,WAXFN,GTITLE,IDENT,
     +                 NEWMATNAM,MTZNAM,PGNAME,SPGNAM,ODFILE,
     +                 SEPCHAR,SNEWMATNAM,TEMPLSTART,TEMPLEND,
     $                 TEMPLSAV,BITMAPTYPE,CCP4VERSION,FDISK,INLINE
C     ..
C
C
C&&*&& end_include  ../inc/ccondata.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/gui.f
c     gui.h
c     maintained by G.Winter
c     16th April 2002
c     $Id: gui.f,v 1.16 2003/04/04 14:22:01 harry Exp $
c     
c     This defines the variables and common blocks which are used by the
c     new gui control routine. This will also be used in xdisp and control,
c     to switch the new gui on!
c     
c     

      logical gui_switch, refine_cell(6), refine_detector(11),
     +     autocomplete, autoreturn, newmatstore
      integer nargs
      integer imageno, nstart
      parameter (nargs = 200)

c     refine_detector logical block index:
c     1: beam x 2: beam y 3: ccomega 4: yscale
c     5: distance 6: tilt 7: twist 8: roff 9: toff
c     
c     refine_cell logical block index:
c     1: a 2: b 3: c
c     4: alpha 5: beta 6: gamma
c     
c     
c     

      integer keep_phi_segments, keep_phi_start(20), 
     +     keep_phi_end(20)

      real storemeanmult

      common /gui/ gui_switch, imageno, refine_cell, refine_detector,
     +     autocomplete, nstart, autoreturn, newmatstore

      common /keep_phi/ keep_phi_segments, keep_phi_start, 
     +     keep_phi_end, storemeanmult


c     refine_cell(i) is true if you wish to refine cell(i)
C&&*&& end_include  ../inc/gui.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/reprt.f
C--- awk generated include file  reprt.h
C---- START of include file reprt.h
C
C
C
C     .. Scalars in common block /REPRT/ ..
      REAL AVBGRATIO,AVSIG,RFULL,RPART,AVPKRATIO,PKRMAXI,BGRMAXI,
     +     RFACOV,SDRATOV,SDMON,RESCUT,STHCUT
      INTEGER NREF,NOFR,NOLO,MAXBSI,MINBSI,NEDGE,NBOX,NBZERO,NNEG,
     +        NBAD,NBGRJ,NEDGE1,NPARTEND,NSPOVL,NRSYM,NHALF,NSUMPART
      LOGICAL PKACCEPT
C     ..
C     .. Arrays in common block /REPRT/ ..
      REAL RATIO,AVSD,AVSDP,AVSIG1,AVSIG2,AVINTI1,AVINTI2,AVPRI1,
     +     AVPRI2,RMSDELI1,RMSDELI2,ABSDELI1,ABSDELI2,AVPRSIG1,
     +     AVPRSIG2,AVDELSIG1,AVDELSIG2,PKRATIO,RSIGVSM,
     +     FIOVSDP,FIOVSDS,PIOVSDP,PIOVSDS,DBIN
      INTEGER IRANGE,IANAL,IANALF,NRFLS1,NRFLS2,MEANDELI1,MEANDELI2,
     +        NBGRHIST,IVSM,NIVSM,NRESPF,NRESPP,NRESSF,NRESSP,
     +        IRESPF,IRESPP,IRESSF,IRESSP,ISDRESPF,ISDRESPP,
     +        ISDRESSF,ISDRESSP
C     ..
C     .. Common Block /REPRT/ ..
      COMMON /REPRT/RATIO(10),AVSD(10),AVSDP(10),AVSIG1(10,2),
     $       AVSIG2(NMASKS,2),AVINTI1(10,2),AVINTI2(NMASKS,2),
     $       AVPRI1(10,2),AVPRI2(NMASKS,2),RMSDELI1(10,2),
     +       RMSDELI2(NMASKS,2),ABSDELI1(10,2),ABSDELI2(NMASKS,2),
     +       AVPRSIG1(10,2),AVPRSIG2(NMASKS,2),AVDELSIG1(10,2),
     +       AVDELSIG2(NMASKS,2),PKRATIO(10),RSIGVSM(13),FIOVSDP(9),
     $       FIOVSDS(9),PIOVSDP(9),PIOVSDS(9),DBIN(9),
     $       AVBGRATIO,AVSIG,RFULL,RPART,AVPKRATIO,PKRMAXI,BGRMAXI,
     $       RFACOV,SDRATOV,SDMON,RESCUT,STHCUT,
     $       IRANGE(9),IANAL(10),IANALF(10),NRFLS1(10,2),
     +       NRFLS2(NMASKS,2),MEANDELI1(10,2),MEANDELI2(NMASKS,2),
     +       NBGRHIST(32),IVSM(13),NIVSM(13),
     +       NRESPF(9),NRESPP(9),NRESSF(9),NRESSP(9),
     +       IRESPF(9),IRESPP(9),IRESSF(9),IRESSP(9),ISDRESPF(9),
     +       ISDRESPP(9),ISDRESSF(9),ISDRESSP(9),NREF,NOFR,NOLO,
     $       MAXBSI,MINBSI,NEDGE,NBOX,NBZERO,NNEG,NBAD,
     +       NBGRJ,NEDGE1,NPARTEND,NSPOVL,
     +       NRSYM,NHALF,NSUMPART,PKACCEPT
C     ..
C
C
C&&*&& end_include  ../inc/reprt.f
C&&*&& include  ../inc/savall.f
C
C $Id: savall.f,v 1.1 2002/05/02 10:47:15 harry Exp $
C
C---- START of include file savall.h
C
C      NSAVIMG      Number of images used in autoindexing
C      ISAVIMG      Array storing image numbers used in last autoindexing
C      NSAVSEG      Number of segments used in last postref run
C      ISFIRST      Array storing image number of the first image
C                   in all segments of last postref run.
C      SAVMATSR     Indicates whether last matrix was determined by
C                   autoindexing (Autoindexing) or by postref (Post refinement)
C      SAVMATNAM    Name of the matrix file
C      SAVENAM      Name of savefile
C      SVSCN        SCANNER keyword
C      SVSITE       SITE keyword
C      RES          High resolution limit given on RESOL keyword
C      RESLOW       Low resolution limit given on RESOL keyword
C
C     .. Scalars in common block /SAVALL/ ..
      REAL RES,RESLOW
      INTEGER NSAVIMG,NDIR,NSAVSEG
      CHARACTER SAVMATSTR*80,SAVMATNAM*80,SAVENAM*80,SVSCN*80,
     +          SVSITE*80
      LOGICAL IISCN,IISITE,IIWAVE,IIDIV,IIDISP,IINULL,IIRAST,IISEP,
     +        IIOVER,IIPIX,IIBACK,IIRES
C     ..
C     .. Arrays in common block /SAVALL/ ..
C
      INTEGER ISAVIMG(MAXIMG),ISFIRST(100)
C     .. Common Block /SAVALL/ ..
      COMMON /SAVALL/ RES,RESLOW,ISAVIMG,ISFIRST,NSAVIMG,NDIR,NSAVSEG,
     +       IISCN,IISITE,IIWAVE,IIDIV,IIDISP,IINULL,IIRAST,IISEP,
     +        IIOVER,IIPIX,IIBACK,IIRES
C
C
      COMMON /SAVALLC/ SAVMATSTR,SAVMATNAM,SAVENAM,SVSCN,SVSITE
C     ..
C
C
C&&*&& end_include  ../inc/savall.f
C&&*&& include  ../inc/test.f
C--- awk generated include file  test.h
C---- START of include file test.h
C
C    Detector limits, used in SPTEST. All are in 10 micron units.
C    In the virtual detector frame, Y is parallel to the rotation axis
C    and X is orthogonal to the rotation axis.
C
C    In the scanner frame, X is parallel to the slow direction in the
C    image, Y is the fast direction.
C
C    RSCANSQ      Radius**2 of the scanned region of the plate (Mar scanners)
C                 This is different to the other limits because it is
C                 applied to the actual scanner coordinates rather than
C                 the virtual detector coordinates. All other limits apply
C                 to virtual detector coordinates.
C    XSCAN        Maximum X coordinate in detector frame (10 micron units)
C    YSCAN        Maximum Y coordinate in detector frame (10 micron units)
C    RSCANX,RSCANY If non-zero, these are the coordinates (10 micron units)
C                 for the centre of the circle radius RSCAN defining the
C                 useable area of the detector.
C    RMINX,RMINY If non-zero, these are the coordinates (10 micron units)
C                 for the centre of the circle radius RMIN defining the
C                 useable area of the detector.
C    RMXSQD       Maximum radius (squared) in virtual detector frame
C    RMNSQD       Minimum radius (squared) in virtual detector frame
C    XMIN         Minimum X coordinate in  detector frame
C    XMAX         Maximum X coordinate in  detector frame
C    YMIN         Minimum Y coordinate in  detector frame
C    YMAX         Maximum Y coordinate in  detector frame
C
C     .. Scalars in common block /TEST/ ..
      REAL RMXSQD,RMNSQD,XMIN,XMAX,YMIN,YMAX,RSCANSQ,RSCANX,RSCANY,
     +     RMINX,RMINY,XSCAN,YSCAN
      INTEGER NEXCL,NXYEXC
C
C     .. Arrays in common block /TEST/
      REAL RESEXL,RESEXH,XYEXC
C     ..
C     .. Common Block /TEST/ ..
      COMMON /TEST/RESEXL(10),RESEXH(10),XYEXC(4,10),RMXSQD,RMNSQD,
     $             XMIN,XMAX,YMIN,YMAX,RSCANSQ,RSCANX,
     +             RSCANY,RMINX,RMINY,XSCAN,YSCAN,NEXCL,NXYEXC
C     ..
C
C

C&&*&& end_include  ../inc/test.f
C     ..
C     .. Equivalences ..
      SAVE
C     ..
C     .. Data ..
C     ..
C     
c     initialise INERR
      INERR = .false.
C     
C---- First cycle, store parameters, reading saved keywords for second
C     and subsequent segments.
C     Assumes IDPACK, PHIBEGA, PHIENDA, AVPROF, FILMPLOT, NFIRST
C     all set up correctly
C     


      IF (NREPEAT.EQ.0) THEN
        IF (ISEG.EQ.1) THEN
          IF(LENSTR(TEMPLSTART).GT.0)THEN
            templstartst(iseg) = templstart
            templendst(iseg) = templend
          endif
          IDENTST(ISEG) = IDENT
          ODEXTST(ISEG) = ODEXT
          DO 10 I = 1,10
            FDISKST(I,ISEG) = FDISK(I)
 10       CONTINUE
          IFIRSTST(ISEG) = IFIRSTPACK
          ILASTST(ISEG) = NPACK
          NLINE = 1
        ELSE
C     
C---- For second and subsequent segments, need to interpret stored lines
C     of input. 
c     
c     unless we have the matrices etc. already safely stored away.

          if(.not. newmatstore) then
C     
            IFIRSTPACK = NPACK + 1
 20         LINE = INLINE(NLINE)
            NLINE = NLINE + 1
            IF (DEBUG(74)) THEN
              I = LENSTR(LINE)
              IF (I.NE.0) THEN
                WRITE(IOUT,FMT=6000) NLINE-1,LINE(1:LENSTR(LINE))
                IF (ONLINE) WRITE(ITOUT,FMT=6000) NLINE-1,
     +               LINE(1:LENSTR(LINE))
 6000           FORMAT(1X,'In CELLREFSTR, Reading line',I3,
     +               ' from stored input: ',A)
              ELSE
                WRITE(IOUT,FMT=6002) NLINE-1
                IF (ONLINE) WRITE(ITOUT,FMT=6002) NLINE-1
              END IF
            END IF
 6002       FORMAT(1X,'In CELLREFSTR,Reading line',I3,
     +           ' from stored input: ')
C     
C---- Decode this line.
C     
C     ******************************************
            CALL MPARSE(LINE,IBEG,IEND,ITYP,VALUE,IDEC,NTOK)
C     ******************************************
C---- Test for zero tokens (as on a comment card)
C     
            IF (NTOK.EQ.0) GOTO 20
C     
            KEY = LINE(IBEG(1):IEND(1))
            CALL CCPUPC(KEY)
C     
C---- PROCESS
C     
            IF (KEY.EQ.'PROC') THEN
              CALL KWPROC(IBEG,IEND,ITYP,VALUE,
     $             IDEC,NTOK,IFIRSTPACK,NPARM,NSER,
     +             NSERRUN,IPACKF,IPACKL,
     +             INERR,BADKEY,NEWREAD,NFLEFT,
     +             NLLEFT,PHILEFT,PHISLEFT,
     +             ISERLEFT,NRLEFT,MINBATCH,NPROCRUN,LINE)
              IF (INERR) THEN
                WRITE(IOUT,FMT=6004)
                IF (ONLINE) WRITE(ITOUT,FMT=6004)
 6004           FORMAT(1X,'Error in input, job aborted')
                RETURN
              END IF
c     IFIRSTST(ISEG) = IFIRSTPACK
c     ILASTST(ISEG) = NPACK
c     IDENTST(ISEG) = IDENT
c     ODEXTST(ISEG) = ODEXT
              DO 30 I = 1,10
                FDISKST(I,ISEG) = FDISK(I)
 30           CONTINUE
C     
C---- MATRIX
C     
            ELSE IF (KEY.EQ.'MATR') THEN
              CALL KWMATR(IBEG,IEND,ITYP,VALUE,
     $             IDEC,NTOK,NPARM,RPTFIRST,FIRSTTIME,
     +             INERR,LINE)
              IF (INERR) THEN
                WRITE(IOUT,FMT=6004)
                IF (ONLINE) WRITE(ITOUT,FMT=6004)
                RETURN
              END IF
C     
C---- IDENT
C     
            ELSE IF (KEY.EQ.'IDEN') THEN
              CALL KWIDEN(IBEG,IEND,ITYP,VALUE,
     $             IDEC,NTOK,NPARM,
     +             INERR,LINE)
              IF (INERR) THEN
                WRITE(IOUT,FMT=6004)
                IF (ONLINE) WRITE(ITOUT,FMT=6004)
                RETURN
              END IF
C     
C---- TEMPLATE
C     
            ELSE IF (KEY.EQ.'TEMP') THEN
              MODE = 0
              CALL KWTEMP(IBEG,IEND,ITYP,VALUE,
     $             IDEC,NTOK,NPARM,MODE,
     +             INERR,LINE)
              IF (INERR) THEN
                WRITE(IOUT,FMT=6004)
                IF (ONLINE) WRITE(ITOUT,FMT=6004)
                RETURN
              END IF
              TEMPLSTARTST(ISEG) = TEMPLSTART
              TEMPLENDST(ISEG) = TEMPLEND
C     
C---- MISSET
C     
            ELSE IF (KEY.EQ.'ANGL'.OR.KEY.EQ.'MISS') THEN
C     
C     ************************************
              CALL MKEYNM(3,2,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************
C     
C     
              DO 32 I = 1,3
                DELPHI(I) = VALUE(I+1)
C     
C---- Put missets in range -180 to 180
C     
                IF (DELPHI(I).GT.180.00) 
     +               DELPHI(I) = DELPHI(I) - 360.00
 32           CONTINUE
C     
C---- RESOLUTION
C     
            ELSE IF (KEY.EQ.'RESO')THEN
C     ..
              CALL KWRESO(LINE,VALUE,ITYP,IBEG,IEND,NTOK)

C     
C---- RUN
C     
            ELSE IF ((KEY.EQ.'RUN').OR.(KEY.EQ.'GO')) THEN
              IFIRSTST(ISEG) = IFIRSTPACK
              ILASTST(ISEG) = NPACK
              IDENTST(ISEG) = IDENT
              ODEXTST(ISEG) = ODEXT
              GOTO 40
            END IF
C     
            GOTO 20
C     
          else
c     we want to pull stuff from the matrices
            
c     a few format statements - according to error message and
C     subroutine
c     subroutine retrieve_matrix
c     ierr = -1 no matrix or missets
c     human readable messages -> = 1000
            
 1230       format('<?xml version="1.0"?><!DOCTYPE',
     +           ' cell_refine_response><cell_refine_response>',
     +           '<status><code>error</code><message>',
     +           'Either the matrix or the missetting angles', 
     +           ' have not been given',
     +           '</message></status></cell_refine_response>')

 2230       format('Either the matrix or missetting angles',
     +           ' for this segment have not been given')

c     ierr = -2 the new missetting angles are a long way away

 1231       format('<?xml version="1.0"?><!DOCTYPE',
     +           ' cell_refine_response><cell_refine_response>',
     +           '<status><code>error</code><message>',
     +           'The new missetting angles are more than',
     +           ' 20 degrees away from the old ones',
     +           '</message></status></cell_refine_response>')

 2231       format('The new misetting angles are > 20 degrees from',
     +           ' the old ones')

c     subroutine retrieve_segment
c     ierr = -1 failed to read/interpret the template

 1232       format('<?xml version="1.0"?><!DOCTYPE',
     +           ' cell_refine_response><cell_refine_response>',
     +           '<status><code>error</code><message>',
     +           'Failed to read template properly',
     +           '</message></status></cell_refine_response>')

 2232       format('I failed to read the template properly')

c     ierr = -2 no segment information saved

 1233       format('<?xml version="1.0"?><!DOCTYPE',
     +           ' cell_refine_response><cell_refine_response>',
     +           '<status><code>error</code><message>',
     +           'No segment information saved',
     +           '</message></status></cell_refine_response>')

 2233       format('There was no segment information saved',
     +           ' for this segment')

c     ierr = -3 start not set

 1234       format('<?xml version="1.0"?><!DOCTYPE',
     +           ' cell_refine_response><cell_refine_response>',
     +           '<status><code>error</code><message>',
     +           'The start image for this segment was not set',
     +           '</message></status></cell_refine_response>')

 2234       format('The start image for this segment was not set')

c     ierr = -4 end image not set

 1235       format('<?xml version="1.0"?><!DOCTYPE',
     +           ' cell_refine_response><cell_refine_response>',
     +           '<status><code>error</code><message>',
     +           'The end image for this segment was not set',
     +           '</message></status></cell_refine_response>')

 2235       format('The end image for this segment was not set')

c     ierr = -5 one of phi start/range set but not the other

 1236       format('<?xml version="1.0"?><!DOCTYPE',
     +           ' cell_refine_response><cell_refine_response>',
     +           '<status><code>error</code><message>',
     +           'One of the phi start/range was set but not the',
     +           ' other</message></status>',
     +           '</cell_refine_response>')

 2236       format('One of the phi start/range was set from the',
     +           ' command line but not the other')

            ifirstpack = npack + 1
            
            call retrieve_matrix(firsttime, iseg, ierr)
            if(ierr .lt. 0) then
c     something has gone wrong -> write a message to the outside world
              if(ierr .eq. -1) then
                if(socklo) then
                  outline = ' '
                  write(outline, 1230)
                  call write_socket_length(serverfd, 
     +                 lenstr(outline), outline)
                end if
                if(online) then
                  write(itout, 2230)
                end if
                write(iout, 2230)
              else if(ierr .eq. -2) then
                if(socklo) then
                  outline = ' '
                  write(outline, 1231)
                  call write_socket_length(serverfd, 
     +                 lenstr(outline), outline)
                end if
                if(online) then
                  write(itout, 2231)
                end if
                write(iout, 2231)
              end if
              
c     return with an error status - also want to cancel automatic
c     returning
              if(autoreturn) then
                autoreturn = .false.
              end if
              inerr = .true.
              return
              
            end if
            
            call retrieve_segment(iseg, ipackf, ipackl, ierr)
            if(ierr .lt. 0) then
c     something has gone wrong -> write a different message to the 
c     outside world.
              if(ierr .eq. -1) then
                if(socklo) then
                  outline = ' '
                  write(outline, 1232)
                  call write_socket_length(serverfd, 
     +                 lenstr(outline), outline)
                end if
                if(online) then
                  write(itout, 2232)
                end if
                write(iout, 2232)
              else if(ierr .eq. -2) then
                if(socklo) then
                  outline = ' '
                  write(outline, 1233)
                  call write_socket_length(serverfd, 
     +                 lenstr(outline), outline)
                end if
                if(online) then
                  write(itout, 2233)
                end if
                write(iout, 2233)
              else if(ierr .eq. -3) then
                if(socklo) then
                  outline = ' '
                  write(outline, 1234)
                  call write_socket_length(serverfd, 
     +                 lenstr(outline), outline)
                end if
                if(online) then
                  write(itout, 2234)
                end if
                write(iout, 2234)
              else if(ierr .eq. -4) then
                if(socklo) then
                  outline = ' '
                  write(outline, 1235)
                  call write_socket_length(serverfd, 
     +                 lenstr(outline), outline)
                end if
                if(online) then
                  write(itout, 2235)
                end if
                write(iout, 2235)
              else if(ierr .eq. -5) then
                if(socklo) then
                  outline = ' '
                  write(outline, 1236)
                  call write_socket_length(serverfd, 
     +                 lenstr(outline), outline)
                end if
                if(online) then
                  write(itout, 2236)
                end if
                write(iout, 2236)
              end if
              
c     return with an error status
              if(autoreturn) then
                autoreturn = .false.
              end if
              inerr = .true.
              return
              
            end if

            ifirstst(iseg) = ifirstpack
            ilastst(iseg) = npack
            identst(iseg) = ident
            odextst(iseg) = odext
            
          end if
          
        END IF
 40     CONTINUE
C     
C---- added for resolution ranges & exclusions - need to do this for
C     all segments, including the first 
C     
        RESLOWST(ISEG) = RESLOW
        RESANIST(1,ISEG) = RESANI(1)
        RESANIST(2,ISEG) = RESANI(2)
        RESANIST(3,ISEG) = RESANI(3)
        ANITESST(ISEG) = ANITES
        RESCUTST(ISEG) = RESCUT
        RESST(ISEG) = RES
        DO 1752 I=1,10
          RESEXLST(I,ISEG) = RESEXL(I)
          RESEXHST(I,ISEG) = RESEXH(I)
 1752   ENDDO
C     
C---- end of RESOLUTION stuff
C     
        IF (DEBUG(74)) THEN
          WRITE(IOUT,FMT=6100) ISEG,NREPEAT,IFIRSTPACK,NPACK,
     +         IDENT(1:LENSTR(IDENT))
          IF (ONLINE) WRITE(ITOUT,FMT=6100) ISEG,NREPEAT,IFIRSTPACK,
     +         NPACK,IDENT(1:LENSTR(IDENT))
 6100     FORMAT(/,1X,'From CELLREFSET, storing parameters',
     +         ' for segment ISEG=',I3,/,1X,'NREPEAT=',I3,
     +         ' IFIRSTPACK=',I4,' NPACK=',I4,' ident:',A) 
          
        END IF
      ELSE
C     
C---- Doing second or subsequent cycle of cell refinement, restore
C     parameters
C     
        IF(LENSTR(TEMPLSTARTST(ISEG)).GT.0)THEN
          TEMPLSTART = TEMPLSTARTST(ISEG)
          TEMPLEND   = TEMPLENDST(ISEG)
        ENDIF 
        IDENT = IDENTST(ISEG)
        ODEXT = ODEXTST(ISEG)
C
C---- reassigning resolution stuff etc
C
        IF(RESLOWST(ISEG).GT.1E-03)RESLOW = RESLOWST(ISEG)
        IF(RESANIST(1,ISEG).GT.1E-03) RESANI(1) = RESANIST(1,ISEG)
        IF(RESANIST(2,ISEG).GT.1E-03) RESANI(2) = RESANIST(2,ISEG)
        IF(RESANIST(3,ISEG).GT.1E-03) RESANI(3) = RESANIST(3,ISEG)
        ANITES = ANITESST(ISEG)
        IF(RESCUTST(ISEG).GT.1E-03) RESCUT = RESCUTST(ISEG)
        IF(RESST(ISEG).GT.1E-03) RES = RESST(ISEG)
        NEXCL = 0
        DO 50 I = 1,10
          FDISKST(I,ISEG) = FDISK(I)
          IF((RESEXLST(I,ISEG).GT.1E-03).OR.
     &        (RESEXHST(I,ISEG).GT.1E-03))THEN
            RESEXL(I) = RESEXLST(I,ISEG)
            RESEXH(I) = RESEXHST(I,ISEG)
            NEXCL = NEXCL + 1
          ENDIF
 50     CONTINUE
        IF (RES.GT.1E-03) DSTMAX = WAVE/RES
        DSTMAXS = DSTMAX

        IFIRSTPACK = IFIRSTST(ISEG)
        NPACK = ILASTST(ISEG)
        IF (DEBUG(74)) THEN
          WRITE(IOUT,FMT=6110) ISEG,NREPEAT,IFIRSTPACK,NPACK,
     +         IDENT(1:LENSTR(IDENT))
          IF (ONLINE) WRITE(ITOUT,FMT=6110) ISEG,NREPEAT,IFIRSTPACK,
     +         NPACK,IDENT(1:LENSTR(IDENT))
 6110     FORMAT(/,1X,'From CELLREFSET, restoring parameters for',
     +         ' segment ISEG=',I3,/,1X,'NREPEAT=',I3,
     +         ' IFIRSTPACK=',I4,' NPACK=',I4,' ident:',A) 
        END IF
      END IF
      RETURN
      END
      SUBROUTINE CELLVOL(CELL,CVOL)
C     =============================
C
      IMPLICIT NONE
C
C
C     .. Parameters ..
C
C     ..
C     .. Scalar Arguments ..
      REAL CVOL
C
C     ..
C     .. Array Arguments ..
      REAL CELL(6)
C     ..
C     .. Local Scalars ..
      REAL ALPH,BET,GAMM,SUM,V,DTOR
C     ..
C     .. Local Arrays ..
C     ..
C     .. External Functions ..
C     ..
C     .. External Subroutines ..
C     ..
C     .. Intrinsic Functions ..
C     ..
C     .. Common blocks ..
C     ..
C     .. Equivalences ..
      SAVE
C     ..
C     .. Data ..
C     ..
C
      DTOR = ATAN(1.0)*4.0/180.0
      ALPH = CELL(4)*DTOR
      BET = CELL(5)*DTOR
      GAMM = CELL(6)*DTOR
      SUM = (ALPH+BET+GAMM)*0.5
      V = SQRT(SIN(SUM-ALPH)*SIN(SUM-BET)*SIN(SUM-GAMM)*SIN(SUM))
      CVOL = CELL(1)*2.0*CELL(2)*CELL(3)*V
      RETURN
      END
C     $Id: centrs.f,v 1.5 2004/06/02 14:12:52 harry Exp $
C== CENTRS ==
      SUBROUTINE CENTRS(DOPROFILE,NSIG,IXSHIFT,IYSHIFT,NPROFL,LIMIT,SEP,
     +          VLIM,MATCH,PARTLS,OVRLDS,MINREF,OLDLIST,GENLIST,USEBOX,
     +          ADDPART,PTMIN)
C     ==================================================================
C
C
      IMPLICIT NONE
C
C---- Goes through the generate file to
C     find spots suitable for refinement of film centre,
C     crystal to film distance and film orientation
C     If DOPROFILE is true, an average spot profile is
C     accumulated in array IODPROF for display in CHKRAS.
C     See comments in main program about selection of spots
C     for refinement and for average spot profile on vee films.
C
C       MATCH...  true:  Pattern matching, use limited number of
C                        reflections (NSPOT)
C
C       PARTLS... true:  accept partially recorded reflections
C
C       OVRLDS... true:  accept overloaded reflections
C                            
C       MINREF... minimum acceptable number of reflections to be
C                 passed to rdist.
C
C       OLDLIST.. use a list of reflections compiled in a previous
C                 call to centrs
C
C       GENLIST.. select reflections based on intensities measured
C                 on previous film in pack
C
C       USEBOX..  Apply the measurement box peak/background definition
C                 when determining centre of gravity, by calling CGFIT
C                 rather than CGFIND. Usefull if spots are very close.
C
C       ADDPART.. True if partials on adjacent images are added together
C                 during reflection integration.
C                 In this case, if PARTLS is true, select only those
C                 partials at end of current image and add in the other
C                 part of the partial from the next image.
C
C       PTMIN...  If using partials and NOT summing partials (ADDPART)
C                 select ONLY reflections with partiality greater than
C                 PTMIN (range 0 to 1.0)
C---- 12/9/81 Change IWORK to I*4 from I*2, and calls to BEXPAN to BEXPAN4
C     to cope with dynamic range up to 64K
C
C     Reflection flags (IR) (Set by SPTEST called from DSTAR)
C
C       IR      =  0  Spot can be measured
C               =  1  Outside R, X, Y limits
C               =  2  Overlapping spot (set later)
C               =  3  Too wide in phi (more than NWMAX images)
C               =  4  DST .GT. DSTMAX  Not included in final film list -
C                       used only to check for overlaps at edge of film.
C               = 10  Spot is within cusp, but will be observed...not included
C                     in final spot list but must be included in predicted
C                      pattern
C
C               =  21  Spot present on 2 images, this is 1st
C               =  22  Spot present on 2 images, this is 2nd
C
C               =  31  Spot present on 3 images, this is 1st
C               =  32  Spot present on 3 images, this is 2nd
C               =  33  Spot present on 3 images, this is 3rd
C
C               =  41  Spot present on 4 images, this is 1st
C               =  42  Spot present on 4 images, this is 2nd
C               =  43  Spot present on 3 images, this is 3rd
C               =  44  Spot present on 4 images, this is 4th
C
C                 etc etc
C****** DEBUG(6) FOR THIS SUBROUTINE ******
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      REAL VLIM,SEP,PTMIN
      INTEGER IXSHIFT,IYSHIFT,LIMIT,MINREF,NPROFL,NSIG
      LOGICAL DOPROFILE,GENLIST,MATCH,OLDLIST,OVRLDS,PARTLS,USEBOX,
     +        ADDPART
C     ..
C     .. Local Scalars ..
      REAL AM,AVBKG,AVOD,CALCSIG,CALCVAR,DELX,DELY,ODSIG,ODVAR,
     +     SOD,SUMBKG,XC,XCAL,XSIZBIN,YC,YCAL,YSIZBIN,BACK,SDELX,SDELY,
     +     SPTMIN,VARTOT,BGND,AJX,AJY,XLIMIT,XDOV2,VXLIMIT
      INTEGER HWX,HWY,I,IADDR,IBACK,IBLK,IFRST,IHALF,II,
     +        ILAST,IND,INDF,INDL,INDX,INT,ISDR,ISEPN,IIY,J,JADD,JMAX,
     +        JREC,JX,JY,K,KMN,KMX,LASTX,LASTY,MAXB,MAXN,MAXW,MINOD,MJ,
     +        NBKG,NC,NCLOSE,NJ,NN,NOVER,NPEAK,NPOSS,NPOVER,NREF,NRSOLD,
     +        NRX,NRY,NSUM,NWEAK,NXS,NXY,NYS,VLIMIT,NBGBAD,NBGBADG,
     +        IPART,NSDRP,IFLAG,NZPBAD,NHX,NHY,IR,IM,NPARTL,NFULLS,
     +        NREFT,IR1,IR2
      LOGICAL FULL,USEOVRLD,EXPART
      CHARACTER CALLEDFROM*80
C     ..
C     .. Local Arrays ..
      INTEGER ISPOT(100),IWX(500),PNTR(100),IWORK(MAXBOX),X(500),
     +        Y(500),IRECNO(500)
      INTEGER*2 IARR(MAXBUFF/2)
C     ..
C     .. External Subroutines ..
      EXTERNAL BSWAP,CGFIND,ODPLOT,PXYCALC,RDBLK,SIZRAS,SORTUP3,MMTOPX,
     +         BEXPAN4,BSWAP2,SHUTDOWN
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS,MOD,NINT,REAL,SQRT
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/gendata.f
C
C $Id: gendata.f,v 1.2 2003/01/10 16:17:53 andrew Exp $
C
C--- awk generated include file  gendata.h
C---- START of include file gendata.h
C
C     IMG       Partiality indicator. 0 for full reflections, 1 to 100
C                   for partials. Negative for partials at the start of the
C                   rotation range, +ve for partials at the end of the 
C                   rotation. Set in subroutine REEK using DELEPS calculated
C                   in subroutine DSTAR
C
C     IRG       Reflection flag  (Set by SPTEST called from DSTAR)
C               =  0  Spot can be measured
C               =  1  Outside R, X, Y limits
C               =  2  Overlapping spot (set later)
C               =  3  Too wide in phi (more than NWMAX images)
C               =  4  DST .GT. DSTMAX  Not included in final film list -
C                       used only to check for overlaps at edge of film.
C               = 10  Spot is within cusp, but will be observed...not included
C                     in final spot list but must be included in predicted
C                      pattern
C
C               =  21  Spot present on 2 images, this is 1st
C               =  22  Spot present on 2 images, this is 2nd
C
C               =  31  Spot present on 3 images, this is 1st
C               =  32  Spot present on 3 images, this is 2nd
C               =  33  Spot present on 3 images, this is 3rd
C
C               =  41  Spot present on 4 images, this is 1st
C               =  42  Spot present on 4 images, this is 2nd
C               =  43  Spot present on 3 images, this is 3rd
C               =  44  Spot present on 4 images, this is 4th
C
C                 etc etc
C
C     XG        Virtual detector X coordinate in 10 micron units, relative to
C               an origin at the direct beam position. X is parallel to the
C               Y axis in the laboratory frame, ie orthogonal to the rotation
C               axis.
C
C     YG        Virtual detector Y coordinate in 10 micron units, relative to
C               an origin at the direct beam position. Y is parallel to the
C               Z axis in the laboratory frame, ie  the rotation axis.
C
C     IX,IY     are the coordinates of the reflection in pixels
C               (integers) wrt the first pixel in the image (lower left corner
C               cameramans view). For testing for spot overlap, these
C               coordinates are in 10 micron units. Also used for display
C               pixel coordinates when displaying predicted pattern.
C
C     IREC      Pointer to the record number of a particular spot in the
C               list of generated reflections.
C
C
C     ..
C     .. Arrays in common /GENDATA/ ..
      REAL FRACG,PHIG,PHIWG,XG,YG,GOODFIT
      INTEGER INTG,IPRO,IX,IY,IREC
      INTEGER*2 IRG,IMG,IGFLAG,ISDPRO,ISDG,IHG,IKG,ILG,IMPARTG,
     +          MISYMG
C     .. Scalars in common /GENDATA/ ..
      INTEGER IPACKREC,IPACKHEAD,IRECLAST
C     ..
C     .. Common block /GENDATA/ ..
      COMMON /GENDATA/FRACG(NREFLS),PHIG(NREFLS),PHIWG(NREFLS),
     $       XG(NREFLS),YG(NREFLS),INTG(NREFLS),IPRO(NREFLS),
     $       IX(NREFLS),IY(NREFLS),IREC(NREFLS),IRG(NREFLS),IMG(NREFLS),
     +       IGFLAG(NREFLS),ISDPRO(NREFLS),ISDG(NREFLS),
     +       IHG(NREFLS),IKG(NREFLS),ILG(NREFLS),IMPARTG(NREFLS),
     +       MISYMG(NREFLS),GOODFIT(NREFLS),IPACKREC,IPACKHEAD,
     +       IRECLAST
C     ..
C
C

C&&*&& end_include  ../inc/gendata.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/iosp.f
C
C $Id: iosp.f,v 1.1 2002/05/02 10:46:53 harry Exp $
C
C--- awk generated include file  iosp.h
C---- START of include file iosp.h
C
C
C     .. Scalars in common block /IOSP/ ..
      INTEGER NSPOT,NFULL,NOUTGEN
C     ..
C     .. Common Block /IOSP/ ..
      COMMON /IOSP/NSPOT,NFULL,NOUTGEN
C     ..
C
C
C&&*&& end_include  ../inc/iosp.f
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/mcs.f
C $Id: mcs.f,v 1.1 2002/05/02 10:46:56 harry Exp $
C
C
C--- awk generated include file  mcs.h
C---- START of include file mcs.h
C
C
C     .. Scalars in common block /MCS/ ..
      REAL BASEOD,G1OD,CURV
      INTEGER FILM,FILMS,CTOFD,PCKIDX,TOSPT,N1OD,XSCMIN,XSCMAX
      LOGICAL VEE,VALONGX
C     ..
C     .. Common block /MCS/ ..
      COMMON /MCS/BASEOD,G1OD,CURV,FILM,FILMS,CTOFD,PCKIDX,TOSPT,
     $            N1OD,XSCMIN,XSCMAX,VEE,VALONGX
C     ..
C     CTOFD.... This was the crystal to detector distance (10 micron units)
C               but it has now been replaced by XTOFD in common block /XY/
C
C&&*&& end_include  ../inc/mcs.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
C&&*&& include  ../inc/ovrld.f
C
C $Id: ovrld.f,v 1.1 2002/05/02 10:47:03 harry Exp $
C
C--- awk generated include file  ovrld.h
C---- START of include file ovrld.h
C
C
C     .. Scalars in Common Block /OVRLD/ ..
      INTEGER NPMAX
C     ..
C     .. Common Block /OVRLD/ ..
      COMMON /OVRLD/NPMAX
C     ..
C
C
C&&*&& end_include  ../inc/ovrld.f
C&&*&& include  ../inc/params.f
C
C $Id: params.f,v 1.1 2002/05/02 10:47:04 harry Exp $
C
C--- awk generated include file  params.h
C---- START of include file params.h
C
C
C     .. Scalars in common block /PARAMS/ ..
      INTEGER NSDR
C     ..
C     .. Common Block /PARAMS/ ..
      COMMON /PARAMS/NSDR
C     ..
C
C
C
C&&*&& end_include  ../inc/params.f
C&&*&& include  ../inc/parm1.f
C
C $Id: parm1.f,v 1.1 2002/05/02 10:47:05 harry Exp $
C
C--- awk generated include file  parm1.h
C---- START of include file parm1.h
C
C
C
C     .. Scalars in common block /PARM1/ ..
      REAL BGSIG,EFAC,EFACSQ,BGFREJ,GRADMAX,GRADMAXR,BGRAT,PKRAT,
     +     RESD,RESDLOW
      INTEGER CUTOFF,NOVPIX,NDSTART,NDTOT,IXDMIN,IXDMAX,IYDMIN,IYDMAX,
     +     IDMIN,IDMAX
      LOGICAL DUMPSPOT,BADPLOT,DUMPALL,BADPLOT2
C     ..
C     .. Common Block /PARM1/ ..
      COMMON /PARM1/BGSIG,EFAC,EFACSQ,BGFREJ,GRADMAX,GRADMAXR,
     +              BGRAT,PKRAT,RESD,RESDLOW,CUTOFF,NOVPIX,
     +              NDSTART,NDTOT,IXDMIN,IXDMAX,IYDMIN,IYDMAX,
     +              IDMIN,IDMAX,DUMPSPOT,BADPLOT,DUMPALL,BADPLOT2
C     ..
C
C
C&&*&& end_include  ../inc/parm1.f
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/precession.f
C
C $Id: precession.f,v 1.1 2002/05/02 10:47:08 harry Exp $
C
C--- awk generated include file  precession.h
C---- START of include file precession.h
C
C
C     .. Scalars in common block /PRECESSION/ ..
      REAL D1,D2,PHIPREC,PSIPREC,PCTOFD,XLAMBDA
      LOGICAL PRECESS
C     ..
C     .. Common Block /PRECESSION/ ..
      COMMON /PRECESSION/D1,D2,PHIPREC,PSIPREC,PCTOFD,XLAMBDA,PRECESS
C     ..
C
C
C&&*&& end_include  ../inc/precession.f
C&&*&& include  ../inc/pro.f
C
C $Id: pro.f,v 1.1 2002/05/02 10:47:09 harry Exp $
C
C--- awk generated include file  pro.h
C---- START of include file pro.h
C
C
C     .. Arrays in common block /PRO/ ..
      INTEGER*2 IDUM
C     ..
C     .. Common Block /PRO/ ..
      COMMON /PRO/IDUM(MAXBUFF)
C     ..
C
C
C&&*&& end_include  ../inc/pro.f
C&&*&& include  ../inc/pro2.f
C--- awk generated include file  pro2.h
C---- START of include file pro2.h
C
C     .. Scalars in Common /PRO2/ ..
      REAL PRCENSUM
C
C     .. Arrays in Common Block /PRO2/ ..
      INTEGER IODPROF
C     ..
C     .. Common Block /PRO2/ ..
      COMMON /PRO2/PRCENSUM,IODPROF(MAXBOX)
C     ..
C
C
C&&*&& end_include  ../inc/pro2.f
C&&*&& include  ../inc/ras.f
C
C $Id: ras.f,v 1.1 2002/05/02 10:47:10 harry Exp $
C
C--- awk generated include file  ras.h
C---- START of include file ras.h
C
C
C     .. Scalars in common block /RAS/ ..
      INTEGER NEWRAS,MINT
C     ..
C     .. Arrays in common block /RAS/ ..
      INTEGER IRAS
      REAL VARAS
C     ..
C     .. Common Block /RAS/ ..
      COMMON /RAS/VARAS(5),IRAS(5),NEWRAS,MINT
C     ..
C
C
C&&*&& end_include  ../inc/ras.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/rfs.f
C
C $Id: rfs.f,v 1.1 2002/05/02 10:47:15 harry Exp $
C
C--- awk generated include file  rfs.h
C---- START of include file rfs.h
C
C
C
C     .. Scalars in common block /RFS/ ..
      REAL FDIST,ESTART,RMSRES,WRMSRES,WESTART
      INTEGER MAXREF,MAXX,MAXY,NRS,MAXR,NREJS
C     ..
C     .. Arrays in common block /RFS/ ..
      REAL XRS,YRS,WXRS,WYRS
      INTEGER RRS,IHKLR
C     ..
C     .. Common Block /RFS/ ..
      COMMON /RFS/XRS(62),YRS(62),WXRS(62),WYRS(62),FDIST,ESTART,
     $       RMSRES,WRMSRES,WESTART,RRS(62),IHKLR(3,62),MAXREF,MAXX,
     +       MAXY,NRS,MAXR,NREJS
C     ..
C
C
C&&*&& end_include  ../inc/rfs.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C&&*&& include  ../inc/sums.f
C
C $Id: sums.f,v 1.1 2002/05/02 10:47:21 harry Exp $
C
C--- awk generated include file  sums.h
C---- START of include file sums.h
C
C
C     Elements of ASPOT
C     1 = Summation integration intensity
C     2 = Total background counts under peak assuming peak has mm symmetry
C     3 = Rms variation in background, after rejecting background points.
C         This is evaluated in BGSOLVE called from EVAL.
C     4 = Centre of gravity in X direction (in pixels)
C     5 = Centre of gravity in Y direction (in pixels)
C         These are wrt an origin at the centre of the measurement box
C     6 = sum p*iod for background pixels
C     7 = sum q*iod for background pixels
C     8 = sum iod for background pixels
C     9 = Background plane constant a (gradient in X direction)
C    10 = Background plane constant b (gradient in Y direction)
C    11 = Background plane constant c 
C    12 = Largest deviation from background plane, excluding rejected pixels
C    13 = Profile fitted intensity
C    14 = Variance of profile fitted intensity = sum (deltasq) for peak
C         pixels only. Used to calculate PKRATIO and also profile fitted
C         sigma(I) in unweighted case only.
C    15 = Number of rejected background pixels
C    16 = Variance of profile fitted intensity in weighted case (default)
C    17 = sum W*DELTA**2 for profile fit
C    18   unused
C     .. Arrays in common block /SUMS/ ..
      REAL ASPOT
C     ..
C     .. Common Block /SUMS/ ..
      COMMON /SUMS/ASPOT(18)
C     ..
C
C
C&&*&& end_include  ../inc/sums.f
C&&*&& include  ../inc/test.f
C--- awk generated include file  test.h
C---- START of include file test.h
C
C    Detector limits, used in SPTEST. All are in 10 micron units.
C    In the virtual detector frame, Y is parallel to the rotation axis
C    and X is orthogonal to the rotation axis.
C
C    In the scanner frame, X is parallel to the slow direction in the
C    image, Y is the fast direction.
C
C    RSCANSQ      Radius**2 of the scanned region of the plate (Mar scanners)
C                 This is different to the other limits because it is
C                 applied to the actual scanner coordinates rather than
C                 the virtual detector coordinates. All other limits apply
C                 to virtual detector coordinates.
C    XSCAN        Maximum X coordinate in detector frame (10 micron units)
C    YSCAN        Maximum Y coordinate in detector frame (10 micron units)
C    RSCANX,RSCANY If non-zero, these are the coordinates (10 micron units)
C                 for the centre of the circle radius RSCAN defining the
C                 useable area of the detector.
C    RMINX,RMINY If non-zero, these are the coordinates (10 micron units)
C                 for the centre of the circle radius RMIN defining the
C                 useable area of the detector.
C    RMXSQD       Maximum radius (squared) in virtual detector frame
C    RMNSQD       Minimum radius (squared) in virtual detector frame
C    XMIN         Minimum X coordinate in  detector frame
C    XMAX         Maximum X coordinate in  detector frame
C    YMIN         Minimum Y coordinate in  detector frame
C    YMAX         Maximum Y coordinate in  detector frame
C
C     .. Scalars in common block /TEST/ ..
      REAL RMXSQD,RMNSQD,XMIN,XMAX,YMIN,YMAX,RSCANSQ,RSCANX,RSCANY,
     +     RMINX,RMINY,XSCAN,YSCAN
      INTEGER NEXCL,NXYEXC
C
C     .. Arrays in common block /TEST/
      REAL RESEXL,RESEXH,XYEXC
C     ..
C     .. Common Block /TEST/ ..
      COMMON /TEST/RESEXL(10),RESEXH(10),XYEXC(4,10),RMXSQD,RMNSQD,
     $             XMIN,XMAX,YMIN,YMAX,RSCANSQ,RSCANX,
     +             RSCANY,RMINX,RMINY,XSCAN,YSCAN,NEXCL,NXYEXC
C     ..
C
C

C&&*&& end_include  ../inc/test.f
C&&*&& include  ../inc/xy.f
C
C $Id: xy.f,v 1.1 2002/05/02 10:47:25 harry Exp $
C
C--- awk generated include file  xy.h
C---- START of include file xy.h
C
C     .. Scalars in common block /XY/ ..
      REAL XTOFD,SINV,COSV,TANV,TWOTHETA
      INTEGER ICASS
C     ..
C     .. Common Block /XY/ ..
      COMMON /XY/XTOFD,SINV,COSV,TANV,TWOTHETA,ICASS
C     ..
C
C     XTOFD....  Crystal to detector distance in 10 micron units. Read from
C                keyworded input and never changed.
C
C                Spot positions are calculated in S/R XYSPOT (Called from
C                REEK) and are for an "ideal" detector at a distance of XTOFD.
C                These are converted into pixel positions in S/R MMTOPX
C                which applies the multiplicative factor XTOFRA to allow
C                for refinement of the distance. XTOFRA is the parameter
C                that is actually refined (in RDIST), rather than XTOFD.
C                The refined distance that is printed in the logfile is
C                actually XTOFRA*XTOFD
C
C     ICASS....  Indicates detector type:
C                0     Flat film
C                1     Vee shaped cassettes
C                2     FAST detector (only used in TESTGEN mode of OSCGEN)
C                3     Swung out FAST (ditto)
C                4     IP detector
C     TWOTHETA   Detector swing angle (degrees)
C&&*&& end_include  ../inc/xy.f

C     ..
C     .. Equivalences ..
      EQUIVALENCE (IRAS(1),NXS), (IRAS(2),NYS), (IRAS(3),NC)
      EQUIVALENCE (IRAS(4),NRX), (IRAS(5),NRY)
      EQUIVALENCE (IDUM(1),IARR(1))
      EQUIVALENCE (ASPOT(11),BACK)
C     ..
      SAVE
C     .. Data statements ..
      DATA USEOVRLD/.FALSE./
C     ..
C
C
      CALLEDFROM = 'CENTRS'
      IR1 = 2*IPAD + 1
      IR2 = 2*IPAD + 2
      IR2 = 30*IPAD + 30
      EXPART = .FALSE.
      XLIMIT = LIMIT
      VLIMIT = VLIM
      MAXREF = 60
      NBGBAD = 0
      NBGBADG = 0
      NZPBAD = 0
      NHX = NXS/2
      NHY = NYS/2
C
C---- Find number of background points (needed for cgfind)
C
C           ***********************
       CALL SIZRAS(IRAS,NPEAK,NBKG)
C           ***********************
C
C---- If allowing overloads, set npmax to five times the normal limit
C     NOVPIX
C
      IF (OVRLDS .OR. USEOVRLD) THEN
        IF (NOVPIX.GT.0) THEN
          NPMAX = NOVPIX*5
        ELSE
          NPMAX = 0.25*NPEAK
        END IF
      ELSE
        NPMAX = NOVPIX
      END IF
C
C  Convert separation from mm to pixels
      ISEPN = FACT*SEP*100.0
      LASTX = 0
      LASTY = 0
      XDOV2 = XTOFD*XTOFRA/2.0
C
C
      IF (DEBUG(6)) THEN
        IF (ONLINE) WRITE (ITOUT,FMT=6000) DOPROFILE,MATCH,PARTLS,
     +      OVRLDS,GENLIST,OLDLIST,USEOVRLD,NSPOT,ADDPART,USEBOX,
     +      PTMIN
 6000 FORMAT (1X,'Enter CENTRS',/1X,'Logicals DOPROFILE ',L1,' MATCH ',
     +       L1,' PARTLS ',L1,' OVRLDS ',L1,' GENLIST ',L1,' OLDLIST ',
     +        L1,' USEOVRLD ',L1,/,1X,'NSPOT',I5,'  ADDPART ',L1,
     +        '  USEBOX ',L1,'  PTMIN',F5.2)
        WRITE (IOUT,FMT=6000) DOPROFILE,MATCH,PARTLS,OVRLDS,GENLIST,
     +    OLDLIST,USEOVRLD,NSPOT,ADDPART,USEBOX,PTMIN
      END IF
C
C
      IF (DOPROFILE) THEN
C
C
        DO 10 I = 1,MAXBOX
          IODPROF(I) = 0
   10   CONTINUE
C
C
        NPROFL = 0
      END IF
C
C
      IF (OLDLIST) GO TO 180
C
C---- If this call is to calculate average spot profile
C     use previously stored list of reflections, unless this
C     is a vee film, in which case a new list must be created
C     Also, if overloads have been included in the positional
C     refinement, then we need a new reflection list which excludes
C     the overloads.
C
      IF ((.NOT.VEE) .AND. DOPROFILE .AND. (.NOT.USEOVRLD)) GO TO 180
C
C---- Start measuring
C
      IF (GENLIST) GO TO 90
C
C---- Find full spots from generate file and sort
C
C---- Only use every jadd'th spot if more than 500 reflections
C     in central area
C
C---- Set limits for reflection list
C
      JMAX = TOSPT
C
C
      IF (MATCH) THEN
        JMAX = NSPOT
        JADD = NSPOT/500
        GO TO 30
      END IF
C
C
   20 JADD = 0
   30 JADD = JADD + 1
      NREF = 0
      NREFT = 0
C
C
      DO 80 JREC = 1,JMAX,JADD
C
        IR = IRG(JREC)
        IM = IMG(JREC)
C
C
        IF (PARTLS) THEN
C
C
C---- Reject partials and rejected spots, unless partials have been
C     requested.
C     If partials are to be included, then if ADDPART is true only
C     allow partials at end of current oscillation (IM.GT.0) so they can be
C     added in from the next image, if ADDPART is false only
C     allow reflections with a degree of partiality greater than PTMIN
C     In pattern matching, do NOT apply these tests, and note
C     that PTMIN passed in is not the default value but a local variable
C     from subroutine automatch set to 0.1
C
          IF ((IR.EQ.1).OR.(IR.EQ.2).OR.(IR.EQ.4)) GO TO 80
          IF (ADDPART) THEN
            IF ((.NOT.MATCH).AND.((IR.LT.IR1).OR.(IR.GT.IR2))
     +                        .OR.(IM.LT.0)) GOTO 80
          ELSE
            AM = 0.01*ABS(FLOAT(IM))
            IF ((AM.GT.0.0).AND.(AM.LT.PTMIN)) GOTO 80
          END IF
        ELSE
C
C---- Reject all  flagged reflections, don't reject partials yet
C
          IF ((IR.NE.0).AND.(IR.LT.IR1)) GO TO 80
        END IF
C
C
        XC = XG(JREC)
        YC = YG(JREC)
C
C---- For precession photographs, XG,YG are multiples of base
C     vectors and not reflection coordinates,
C     so must calculate coords.
C
        IF (PRECESS) THEN
C
C              ************************
          CALL PXYCALC(XCAL,YCAL,XC,YC)
C              ************************
C
          AJX = ABS(XCAL-XCEN)
          AJY = ABS(YCAL-YCEN)
        ELSE
          AJX = ABS(XC)
          AJY = ABS(YC)
        END IF
C
C
        IF (DEBUG(6) .AND. JREC.LT.NDEBUG(6)) THEN
          IF (ONLINE) WRITE(ITOUT,FMT=6002) JREC,XC,YC,AJX,AJY,XLIMIT,
     +        IR,IM
 6002 FORMAT (1X,'JREC',I5,' X,Y (GENFILE)',2F8.1,'  AJX,Y',2F8.1,
     +       '  LIMIT',F7.1,' IR',I3,' IM',I4)
          WRITE (IOUT,FMT=6002) JREC,XC,YC,AJX,AJY,XLIMIT,IR,IM
        END IF
C
C
        IF (AJY.GT.XLIMIT) GO TO 80
C
C---- Test for area containing unexpanded spots for vee-films.
C
        IF (VEE) GO TO 40
        IF (AJX.GT.XLIMIT) GO TO 80
        GO TO 60
   40   IF (DOPROFILE) GO TO 50
        IF (AJX.GT.VLIMIT) GO TO 80
        GO TO 60
C
   50   IF (ABS(AJX-XDOV2).GT.XLIMIT) GO TO 80
   60   NREFT = NREFT + 1
C
C---- Reject partials now
C
        IF ((.NOT.PARTLS).AND.(IM.NE.0)) GOTO 80
        NREF = NREF + 1
        IRECNO(NREF) = JREC
        IF (IM.NE.0) IRECNO(NREF) = -IRECNO(NREF)
C
C                         ****************************
        IF (.NOT.PRECESS) CALL MMTOPX(XCAL,YCAL,XC,YC)
C                         ****************************
C
C---- Apply box shift. Note that X,Y are spot coordinates in pixels.
C
        X(NREF) = NINT(XCAL*FACT) + IXSHIFT
        Y(NREF) = NINT(YCAL*FACT) + IYSHIFT
C
C---- Test that the edge of the measurement box is not outside the image
C
        IF ((X(NREF)-NHX.LT.6).OR.(X(NREF)+NHX.GT.NREC-5).OR.
     +  (Y(NREF)-NHY.LT.6).OR.(Y(NREF)+NHY.GT.IYLEN-5)) THEN
           NREF = NREF - 1
           GOTO 80
        END IF
        IF (DEBUG(6).AND.NREF.LT.NDEBUG(6))  THEN
          WRITE(IOUT,FMT=6003) NREF,X(NREF),Y(NREF)
          IF (ONLINE) WRITE(ITOUT,FMT=6003) NREF,X(NREF),Y(NREF)
 6003     FORMAT(1X,'SELECTED REFLECTION',I4,' X,Y',2I8)
        END IF
        IF (NREF.EQ.500) GO TO 30
   80 CONTINUE
C
C
      GO TO 200
C
C---- ********** Alternative procedure *************
C     For B and C films using NOFID option,
C     select spots on basis of intensity measured on preceeding film.
C
   90 XSIZBIN = XLIMIT/5.0
      YSIZBIN = XLIMIT/4.0
C
C
      DO 100 I = 1,60
        ISPOT(I) = 0
  100 CONTINUE
C
C---- Search for the strongest full spot in each
C     subdivision of the film
C
  110 CONTINUE
C
C
      DO 140 I = 1,TOSPT
C
C---- Reject partials and rejected spots
C
        IR = IRG(I)
        IM = IMG(I)
        IF ((IR.NE.0).OR.(IM.NE.0)) GO TO 130
C
C---- Reject overloads or unmeasured spots on preceeding film
C     unless we want to use overloads (but not if forming profile)
C     in which case the first overload in the bin is selected
C
        INT = INTG(I)
        IF (USEOVRLD .AND. (INT.EQ.9999) .AND.
     +      (.NOT.DOPROFILE)) GO TO 120
        IF (INT.EQ.9999 .OR. INT.LE.0) GO TO 130
  120   XC = XG(I)
        YC = YG(I)
        JX = XC
        JY = YC
C
C---- For precession photographs, XG,YG are multiples of
C     base vectors and not reflection coordinates,
C     so must calculate coords.
C
        IF (PRECESS) THEN
C
C              ************************
          CALL PXYCALC(XCAL,YCAL,XC,YC)
C              ************************
C
          AJX = ABS(XCAL-XCEN)
          AJY = ABS(YCAL-YCEN)
        ELSE
          AJX = ABS(XC)
          AJY = ABS(YC)
        END IF
C
C
        IF (AJY.GT.XLIMIT) GO TO 130
C
C---- Test for area containing unexpanded spots for vee-films.
C
        IF (VEE) THEN
C
C
          IF (DOPROFILE) THEN
            IF (ABS(AJX-XDOV2).GT.XLIMIT) GO TO 130
          ELSE
            IF (AJX.GT.VLIMIT) GO TO 130
          END IF
C
C
        ELSE
          IF (AJX.GT.XLIMIT) GO TO 130
        END IF
C
C
        K = (XLIMIT+XC)/XSIZBIN
        IF (PRECESS) K = (XLIMIT+XCAL-XCEN)/XSIZBIN
        IF (K.GT.9) K = 9
        J = (XLIMIT+YC)/YSIZBIN
        IF (PRECESS) J = (XLIMIT+YCAL-YCEN)/YSIZBIN
        IF (J.LT.1) J = 1
        IF (J.GT.6) J = 6
        INDX = 6*K + J
C
C
        IF (USEOVRLD .AND. (.NOT.DOPROFILE) .AND. (INT.EQ.9999)) THEN
          ISDR = 500
        ELSE
          ISDR = INT/ISDG(I)
        END IF
C
C
        IF (ISDR.LT.ISPOT(INDX)) GO TO 130
C
C
        IF (DEBUG(6)) THEN
          IF (PRECESS) THEN
            IF (ONLINE) WRITE (ITOUT,FMT=6004) I,INDX,XG(I),YG(I),
     +          NINT(XCAL-XCEN),NINT(YCAL-YCEN),ISDR
 6004 FORMAT (1X,'REFLECTION',I5,'  INDX',I3,'  N,M',2I5,'  IX,IY',2I6,
     +       '  ISDR',I5)
            WRITE (IOUT,FMT=6004) I,INDX,XG(I),YG(I),NINT(XCAL-XCEN),
     +        NINT(YCAL-YCEN),ISDR
          ELSE
            IF (ONLINE) WRITE (ITOUT,FMT=6006) I,INDX,XG(I),YG(I),ISDR
 6006 FORMAT (1X,'REFLECTION',I5,' INDX',I3,' IX,IY',2F8.1,'  ISDR',I5)
            WRITE (IOUT,FMT=6006) I,INDX,XG(I),YG(I),ISDR
          END IF
        END IF
C
C
        ISPOT(INDX) = ISDR
        IRECNO(INDX) = I
C
C                         ****************************
        IF (.NOT.PRECESS) CALL MMTOPX(XCAL,YCAL,XC,YC)
C                         ****************************
C
        X(INDX) = NINT(XCAL*FACT)
        Y(INDX) = NINT(YCAL*FACT)
C
C---- Increase ISPOT for overloads so that first found in bin is kept
C
        IF (USEOVRLD .AND. (.NOT.DOPROFILE)) ISPOT(INDX) = 600
  130   CONTINUE
  140 CONTINUE
C
C---- Count number of spots found and reject those with
C     I/SD.lt.NSDR (defaults to 25)
C
      IF (DEBUG(6)) THEN
        IF (ONLINE) WRITE (ITOUT,FMT=6008)
 6008 FORMAT (//1X,'Selected reflections in CENTRS')
        WRITE (IOUT,FMT=6008)
      END IF
C
C
      NREF = 0
C
C
      DO 170 I = 1,60
C
C---- NSDR set by default to 25, may be changed by keyword ISDR
C
        IF (ISPOT(I).LT.NSDR) GO TO 160
        NREF = NREF + 1
        X(NREF) = X(I)
        Y(NREF) = Y(I)
        IRECNO(NREF) = IRECNO(I)
C
C
        IF (DEBUG(13)) THEN
         IF (ONLINE) WRITE(ITOUT,FMT=6010) NREF,X(I),Y(I)
 6010 FORMAT (1X,'NREF=',I5,'  X,Y',2I6)
         WRITE(IOUT,FMT=6010) NREF,X(I),Y(I)
        END IF
C
C
  160   CONTINUE
  170 CONTINUE
C
C---- If not enough reflections, try including reflections that
C     are overloaded on the A film, and allow them to be overloaded
C     (up to 5*NOVPIX pixels) on this film too.
C
      IF ((NREF.LT.MINREF) .AND. (.NOT.USEOVRLD)) THEN
        WRITE (IOUT,FMT=6012)
 6012 FORMAT (/1X,'** NOT enough reflections found for refinement **',
     +       /1X,'Allow inclusion of overloaded reflections')
        IF (ONLINE) WRITE (ITOUT,FMT=6012)
        USEOVRLD = .TRUE.
        IF (NOVPIX.GT.0) THEN
          NPMAX = NOVPIX*5
        ELSE
          NPMAX = 5
        END IF
        GO TO 110
      END IF
C
C
      IF (NREF.LT.MINREF) THEN
        IF (NSDR.GE.3) THEN
          NSDRP = 0.666*NSDR
          WRITE (IOUT,FMT=6014) NREF,NSDR,NSDRP
 6014 FORMAT (/1X,'ONLY',I3,' Reflections found for refinement in cent',
     +       'ral region of film',/1X,'Cutoff (I/sigma) reduced from',
     +       I4,' to',I4)
          IF (ONLINE) WRITE (ITOUT,FMT=6014) NREF,NSDR,NSDRP
          NSDR = NSDRP
          GOTO 110
        ELSE
          WRITE (IOUT,FMT=6015) NREF,NSDR
          IF (ONLINE) WRITE (ITOUT,FMT=6015) NREF,NSDR
 6015     FORMAT (/1X,'ONLY',I3,' Reflections found for refinement in ',
     +    'central region of film',/1X,'with cutoff (I/sigma) set to',
     +     I3)
          NRS = NREF
          RETURN
        END IF
      END IF
C
C
      GO TO 200
C
C---- Use existing list of refinement spots
C
  180 CONTINUE
C
      NPARTL = 0
C
      DO 190 I = 1,NRS
        JREC = RRS(I)
        IRECNO(I) = JREC
        IF (JREC.LT.0) THEN
          JREC = -JREC
C
C---- Count number of partials in list if forming average spot profile
C
          IF (DOPROFILE.AND.(.NOT.ADDPART)) NPARTL = NPARTL + 1
        END IF
        XC = XG(JREC)
        YC = YG(JREC)
C
        IF (PRECESS) THEN
C
C              ************************
          CALL PXYCALC(XCAL,YCAL,XC,YC)
C              ************************
C
        ELSE
C
C              ***********************
          CALL MMTOPX(XCAL,YCAL,XC,YC)
C              ***********************
C
        END IF
C
C
        X(I) = NINT(XCAL*FACT) + IXSHIFT
        Y(I) = NINT(YCAL*FACT) + IYSHIFT
        IF (DEBUG(6)) THEN
          WRITE(IOUT,FMT=6017) I,RRS(I),XG(JREC),YG(JREC),X(I),Y(I)
          IF (ONLINE) WRITE(ITOUT,FMT=6017) I,RRS(I),XG(JREC),YG(JREC),
     +                                      X(I),Y(I)
 6017     FORMAT(1X,'Reflection',I3,' Record number',I6,' XG,YG',2F8.1,
     +           '  Pixel coords',2I10)
        END IF
  190 CONTINUE
C
C
      NREF = NRS
C
C---- If forming average spot profile, exclude partials (providing this
C     leaves at least MINREF reflections)
C
      IF (DOPROFILE) THEN
        NFULLS = NREF - NPARTL
        EXPART = (NFULLS.GT.MINREF)
        IF (.NOT.EXPART) THEN
          WRITE(IOUT,FMT=6013) MINREF
          IF (ONLINE) WRITE(ITOUT,FMT=6013) MINREF
 6013   FORMAT(1X,'Fewer than',I3,' fully recorded reflections, so',
     +         ' average spot profile will include partials')
        END IF
      END IF
C
 200  IF (PARTLS) THEN
          IF (ADDPART) THEN
            WRITE(IOUT,FMT=6050) NREF
            IF (ONLINE) WRITE(ITOUT,FMT=6050) NREF
 6050 FORMAT(1X,I5,' Fulls and summed partials to be measured')
          ELSE IF (PARTLS.AND.EXPART) THEN
            WRITE(IOUT,FMT=6052) NREF-NPARTL
            IF (ONLINE) WRITE(ITOUT,FMT=6052) NREF-NPARTL
 6052 FORMAT(1X,I5,' Fulls to be measured')
          ELSE
            WRITE(IOUT,FMT=6054) NREF
            IF (ONLINE) WRITE(ITOUT,FMT=6054) NREF
 6054 FORMAT(1X,I5,' Fulls and partials to be measured')
          END IF
      ELSE
          WRITE(IOUT,FMT=6052) NREF
          IF (ONLINE) WRITE(ITOUT,FMT=6052) NREF
      END IF
C
C
      IF (NREF.LT.MINREF) THEN
C
C---- Too few reflections in the list. If necessary, include partials, but
C     first check that this really is because most of the reflections are
C     partial. If not, then increase the size of central area.
C
        IF (.NOT.PARTLS) THEN
C
C---- If total number (fulls plus partials) > 3*MINREF, then include
C     partials
C
          IF (NREFT.GE.3*MINREF) THEN
            WRITE(IOUT,FMT=6060) NREF,PTMIN,MINREF
            IF (ONLINE) WRITE(ITOUT,FMT=6060) NREF,PTMIN,MINREF
 6060     FORMAT(/,1X,'**** WARNING ****',/,1X,'There are only',
     +    I4,' fully recorded reflections in',/,1X,'the central ',
     +    'region, so partials will be included in refinement.',/,1X,
     +    'This is equivalent to including keywords: REFINEMENT ',
     +    'INCLUDE PARTIALS',F4.1,/,1X,'To avoid including partials',
     +    ' you may change the minimum number of reflections',/,1X,
     +    '(currently',I3,') using keywords REFINEMENT NREF 12 say,',
     +    ' or reduce',/,1X,'the threshold using keywords REFINEMENT',
     +    ' NSIG 10 say.')
            PARTLS = .TRUE.
            GOTO 20
          ELSE
C
C---- otherwise expand central limit if possible
C
            IF (LIMIT.LT.XMAX) THEN
              LIMIT = LIMIT + 500
              IF (VEE) VLIMIT = VLIMIT + 500
              XLIMIT = LIMIT
              VXLIMIT = VLIMIT
              WRITE(IOUT,FMT=6063) NREF,NREFT,3*MINREF,2*LIMIT/100
              IF (ONLINE) WRITE(ITOUT,FMT=6063) NREF, NREFT, 3*MINREF,
     +                    2*LIMIT/100
              GOTO 20
 6063         FORMAT(/,1X,'***** WARNING ****',/,1X,'Only',I4,' ',
     +        'fully recorded reflections within central region.',/,1X,
     +        'There are only',I5,' reflections even including ',
     +        'partials (which is less than 3*MINREF,',I4,')',/,1X,
     +        'so increas size of central area to',I4,' mm square.')
            ELSE
C
C---- Cannot expand limit any further, include partials
C
              WRITE(IOUT,FMT=6060) NREF,PTMIN,MINREF
              IF (ONLINE) WRITE(ITOUT,FMT=6060) NREF,PTMIN,MINREF
              PARTLS = .TRUE.
              GOTO 20
            END IF
          END IF
        ELSE
C
C---- IF not using ADDPART, try decreasing PTMIN (to a minimum of 0.01)
C
          IF (.NOT.ADDPART) THEN
            IF (PTMIN.LE.0.01) THEN
              WRITE(IOUT,FMT=6061)
              IF (ONLINE) WRITE(ITOUT,FMT=6061)
 6061         FORMAT(1X,'Still cannot find enough reflections ')
C
C---- otherwise expand central limit if possible
C
              IF (LIMIT.LT.XMAX) THEN
                LIMIT = LIMIT + 500
                IF (VEE) VLIMIT = VLIMIT + 500
                XLIMIT = LIMIT
                VXLIMIT = VLIMIT
                WRITE(IOUT,FMT=6063) NREF,NREFT,3*MINREF,2*LIMIT/100
                IF (ONLINE) WRITE(ITOUT,FMT=6063) NREF, NREFT,3*MINREF,
     +                    2*LIMIT/100
                GOTO 20
              ELSE
C
C---- Cannot expand limit any further, give up (drops down to 6020 below)
C
              END IF
            END IF
            SPTMIN = PTMIN
            PTMIN = PTMIN - 0.1
            IF (PTMIN.LT.0.01) PTMIN = 0.01
            WRITE(IOUT,FMT=6062) SPTMIN,PTMIN
            IF (ONLINE) WRITE(ITOUT,FMT=6062) SPTMIN,PTMIN
 6062       FORMAT(/,1X,'**** WARNING ****',/,1X,'Still too few ',
     +      'reflections, changing minimum fraction recorded',/,1X,
     +      'for partials from',F5.2,' to',F5.2)
            GOTO 20
          END IF
        END IF
        NWRN = NWRN + 1           
        WRITE (IOUT,FMT=6020) MINREF

 6020 FORMAT(///1X,'****** FATAL ERROR *******',/1X,'There are no FUL',
     +    'LY recorded spots in central area of image',/1X,'If this ',
     +   'is really true, either include partials in the refinement',
     +   /,1X,'by adding keywords: REFINEMENT INCLUDE PARTIALS',/,1X,
     +   'or if the cell is small, change the size of this area using',
     +   ' the REFINEMENT LIMIT x keywords')
        IF (ONLINE) WRITE (ITOUT,FMT=6020)
        NSHUTERR = 1
        CALL SHUTDOWN(CALLEDFROM)
      END IF
C
C          **********************
      CALL SORTUP3(NREF,X,Y,IRECNO)
C          **********************
C
      HWX = NXS/2
      HWY = NYS/2
      NXY = NXS*NYS
C
      MAXW = (NXY+1)/2
      IF (IMGP) MAXW = NXY
      MAXB = 2*MAXW
      IF (IMGP) MAXB = MAXW
      MAXN = 0.5*MAXBUFF/MAXW
      IF (MAXN.GT.100) MAXN = 100
C           
      NRSOLD = NRS
  210 IF (.NOT.DOPROFILE) NRS = 0
C
C---- Counters for number of reflections rejected as overloaded,
C     too close, too weak
C
      NOVER = 0
      NCLOSE = 0
      NWEAK = 0
      SUMBKG = 0.0
      NSUM = 0
      IF (VEE .AND. DOPROFILE) NRS = NRSOLD
      IHALF = (60+NRS)/2 + 2
C
C---- Modify IHALF to allow for case of offset detector, where direct beam
C     position may be actually at edge of detector !
C
      IF ((XCEN+LIMIT)*FACT.GT.NREC) THEN
        IHALF = 30 + REAL((XCEN+LIMIT)*FACT-NREC)/REAL(LIMIT*FACT)*30
        IF (DEBUG(6)) THEN
          WRITE(IOUT,FMT=6019) IHALF,NINT((XCEN+LIMIT)*FACT)
          IF (ONLINE) WRITE(ITOUT,FMT=6019)IHALF,NINT((XCEN+LIMIT)*FACT)
 6019     FORMAT(1X,'IHALF changed to',I5,' EDGE OF AREA AT RECORD',I3)
        END IF
      END IF
C
C
      DO 220 I = 1,NREF
        IWX(I) = NXS
  220 CONTINUE
C
C
      INDF = 1
      INDL = 1
      IFRST = 1
      ILAST = 0
      FULL = .FALSE.
  230 CONTINUE
C
C---- Get the start of the raster for the first spot or
C     for a spot after a gap
C
      IBLK = X(INDF) - HWX
C
C--- Test this is inside the scanned area (essential for offset detector,
C    the spot centre may lie on the detector but edge of measurement box 
C    may not.
      IF ((IBLK.LT.XSCMIN).OR.(IBLK.GT.XSCMAX)) THEN
        WRITE(IOUT,FMT=6021) IBLK,INDF,X(INDF),HWX
        IF (ONLINE) WRITE(ITOUT,FMT=6021) IBLK,INDF,X(INDF),HWX
 6021 FORMAT(//1X,'** FATAL ERROR **',/,1X,'When finding reflections ',
     +    'for refinement (CENTRE)',/,1X,'part of the measurement ',
     +    'box lies outside the scanned region of the image',/,
     +    1X,'(trying to read record',I10,')',/,1X,'Restrict the ',
     +    'size of the search area for spots using the:',/,1X,
     +    'REFINEMENT LIMIT x',/,1X,
     +    'keywords which will set the search box size to "x" mm',
     +    ' on either side',/,1X,'of the direct beam')
        NSHUTERR = 2
        CALL SHUTDOWN(CALLEDFROM)
      END IF

C
C---- Test if sorted spot has to be included in
C     this scan
C
C      ****************
  240  CALL RDBLK(IBLK)
C      ****************
C
  250 IF (INDL.EQ.NREF) GO TO 260
      IF (FULL) GO TO 260
      IF (IBLK.LT.X(INDL+1)-HWX) GO TO 260
      INDL = INDL + 1
      IF (INDL-INDF.EQ.MAXN-1) FULL = .TRUE.
      GO TO 250
C
C---- Get results from this scan and start the next one
C
  260 IBLK = IBLK + 1
C
C--- Test this is inside the scanned area (essential for offset detector,
C    the spot centre may lie on the detector but edge of measurement box 
C    may not.
C
      IF ((IBLK.LT.XSCMIN).OR.(IBLK.GT.XSCMAX)) THEN
        WRITE(IOUT,FMT=6021) IBLK
        IF (ONLINE) WRITE(ITOUT,FMT=6021) IBLK
        NSHUTERR = 3
        CALL SHUTDOWN(CALLEDFROM)
      END IF
C---- Store optical densities for all spots included in this scan
C     the actual transfer of ods is done in the call to bswap
C
      IF (INDL.LT.INDF) GO TO 290
C
C
      DO 280 J = INDF,INDL
C
C---- MJ is pointer for reflection J, range 1 to MAXN
C
        MJ = MOD(J-1,MAXN) + 1
        IIY = Y(J)
        KMN = IIY - HWY
        KMX = IIY + HWY
        IF ((KMN.LT.1).OR.(KMX.GT.IYLEN)) THEN
          WRITE(IOUT,FMT=6023) KMN,KMX
          IF (ONLINE) WRITE(ITOUT,FMT=6023) KMN,KMX
 6023 FORMAT(//1X,'** FATAL ERROR **',/,1X,'When finding reflections ',
     +   'for refinement (CENTRE)',/,1X,'part of the measurement ',
     +   'box lies outside the scanned region of the image',/,
     +   1X,'(pixel limits in Y are',2I5,')',/,1X,'Restrict the ',
     +    'size of the search area for spots using the:',/,1X,
     +    'REFINEMENT LIMIT x',/,1X,
     +    'keywords which will set the search box size to "x" mm',
     +    ' on either side',/,1X,'of the direct beam')
        NSHUTERR = 3
          CALL SHUTDOWN(CALLEDFROM)
        END IF
        IF (J.NE.IFRST) GO TO 270
C
C---- If this reflection has just started,
C     set byte pointer (PNTR) into BB.
C
C---- NJ is byte pointer to start address for reflection J (MJ)
C
C---- PNTR(J) gives current address in BB for relection J  (MJ)
C
        NJ = (MJ-1)*MAXB
        PNTR(MJ) = NJ + 1
        IFRST = IFRST + 1
  270   IADDR = PNTR(MJ)
C
C            ********************
        CALL BSWAP(KMN,KMX,IADDR)
C            ********************
C
C---- note IADDR is incremented in BSWAP
C
C---- Add in second part for summed partials
C
        IF (ADDPART.AND.(IRECNO(J).LT.0)) THEN
C
C  Reset IADDR (incremented in BSWAP)
          IADDR = IADDR - (KMX - KMN + 1)
C               *******************
          CALL BSWAP2(KMN,KMX,IADDR)
C               *******************
        END IF
C
        PNTR(MJ) = IADDR
        IWX(J) = IWX(J) - 1
  280 CONTINUE
  290 CONTINUE
C
C---- Check if one or more spots are finished
C
      IF (IWX(INDF).EQ.0) GO TO 300
C
      IF (INDF.LE.INDL) GO TO 240
      FULL = .FALSE.
      GO TO 230
C
  300 IND = ILAST*MAXW + 1
C
C  Use measurement box if USEBOX is true
C
      IF (USEBOX) THEN
C
C---- Extract degree of partiality for CGFIT
C
        II = IRECNO(INDF)
        IF (II.LT.0) II = -II
        IPART = IMG(II)
        IF (ADDPART) IPART = 0
C            **************************************
        CALL CGFIT(IARR(IND),IRAS,+1,DELX,DELY,SOD,SDELX,SDELY,IPART,
     +             IFLAG)
C            **************************************
        IBACK = NINT(BACK)
      ELSE
C          **********************************************************
         CALL CGFIND(IARR(IND),1,NXS,NYS,DELX,DELY,SOD,ODVAR,MINOD,NBKG,
     +            IBACK,NPOVER,IFLAG)
C          **********************************************************
      END IF
C
C
      IF (DEBUG(6)) THEN
        IF (ONLINE) WRITE (ITOUT,FMT=6022) INDF,X(INDF),Y(INDF),NPOVER,
     +      SOD,IRECNO(INDF),IPART,IFLAG
 6022 FORMAT (1X,'INDF=',I4,' X,Y',2I6,'  NPOVER=',I3,'  SOD=',F10.1,
     +        ' IRECNO',I5,' IPART',I4,' IFLAG',I3)
        WRITE (IOUT,FMT=6022) INDF,X(INDF),Y(INDF),NPOVER,SOD,
     +                        IRECNO(INDF),IPART,IFLAG
C                 ********************************
        IF (SPOT) CALL ODPLOT(IARR(IND),NXS,NYS,1)
C                 ********************************
      END IF            
C
C
C---- Reject reflections with too steep gradient
C     (only tested with CGFIT).
      IF (IFLAG.EQ.1) THEN
        NBGBADG = NBGBADG + 1
        GOTO 340
      END IF
C---- Reject reflections with too many background points rejected
C     (only tested with CGFIT)
      IF (IFLAG.EQ.2) THEN
        NBGBAD = NBGBAD + 1
        GOTO 340
      END IF
C
C---- Reject reflections containing zero value pixels (outside scanned
C     area)
      IF (IFLAG.EQ.3) THEN
        NZPBAD = NZPBAD + 1
        GOTO 340
      END IF

C---- Reject overloaded spots (flagged with sod=-9999.)
C     if calculating profile, check NPOVER explicitly as
C     NPMAX may have been changed to find enough refinement spots
C
      IF ((IFLAG.EQ.4).OR.(DOPROFILE.AND.(NPOVER.GT.NOVPIX))) THEN
        NOVER = NOVER + 1
        GO TO 340
      END IF
C
C---- No tests needed if using reflection list from previous film
C
      IF (GENLIST) GO TO 310
C
C---- Form sum for average background level
C
      SUMBKG = SUMBKG + IBACK
      NSUM = NSUM + 1
C
C---- Test on minimum intensity using sigma calculated from
C     counting statistics (Selwyn granularity for film)
C     the variance of the spot ods must be greater than
C     NSIG*SIGMA on the first pass or 0.666*NSIG*SIGMA on the second,
C     where SIGMA is calculated using the average od
C     over the whole spot. NSIG defaults to 6, but can be changed
C     by keyword NSIG
C     When using CGFIT rather than CGFIND, ie using the mask to
C     determine the c. of g., the selection test is that the average
C     background subtracted pixel value for pixels in the peak must
C     be gt NSIG times the sigma value for the background (calculated
C     from counting statistics)
C **** Changed 5/3/97 to use I/sig(I) instead when using CGFIT, NSIG
C     now initialised to 20.
C
      IF (USEBOX) THEN
        IF (SOD.LT.0.0) SOD = 0.0
CAL        AVOD = SOD/NPEAK
CAL        ODSIG = AVOD
CAL        CALCSIG = SQRT(GAIN*BACK)
C
C---- Try using I/sig(I) instead
C
        BGND = BACK*NPEAK
        VARTOT = GAIN*(SOD+BGND+BGND*NPEAK/NBKG)
        IF (VARTOT.LT.0) VARTOT = 0.0
        CALCSIG = SQRT(VARTOT)
        ODSIG = SOD
      ELSE
        ODSIG = SQRT(ODVAR)
        AVOD = SOD/NXY
        CALCVAR = (AVOD+MINOD)*GAIN
        CALCSIG = SQRT(CALCVAR)
      END IF
      IF (DEBUG(6)) THEN
        WRITE (IOUT,FMT=6024) X(INDF),Y(INDF),DELX,DELY,
     +    AVOD,MINOD,IBACK,ODSIG,CALCSIG
 6024 FORMAT (1X,'X=',I5,' Y=',I5,' DELX,DELY',2F5.1,' AVOD=',F6.1,' M',
     +       'INOD=',I4,' IBACK=',I4,'  ODSIG=',F8.1,'  CALCSIG=',F6.1)
        IF (ONLINE) WRITE (ITOUT,FMT=6024) X(INDF),Y(INDF),DELX,DELY,
     +    AVOD,MINOD,IBACK,ODSIG,CALCSIG
      END IF
C
C
      IF (ODSIG.LT.NSIG*CALCSIG) THEN
        NWEAK = NWEAK + 1
        GO TO 340
      END IF
C
C
      IF ((.NOT.VEE) .AND. DOPROFILE) GO TO 310
C
C---- Spots seperated by > 4 mm
C
      IF (ABS(X(INDF)-LASTX).GT.ISEPN) LASTY = 0
C
C
      IF (ABS(Y(INDF)-LASTY).LT.ISEPN) THEN
        NCLOSE = NCLOSE + 1
        GO TO 340
      END IF
C
C---- Limit number of spots on lhs of film
C
      IF (NRS.GT.IHALF .AND. X(INDF).LT.XCEN*FACT) GO TO 340
C
      IF (NRS.EQ.MAXREF) GO TO 360
C
C
C---- Store ods for average spot profile
C
  310 IF (DOPROFILE) THEN
C
C---- Exclude partials if possible
C
        IF (EXPART.AND.((IRECNO(INDF).LT.0).AND.(.NOT.ADDPART)))
     +                                               GOTO 340
C
        NPROFL = NPROFL + 1                                   
C
C     Expand into an integer*2 array - this comment is wrong - BEXPAN4
C     expands into an I*4 array.
C
        CALL BEXPAN4(IARR(IND),IWORK,NXY)
C
        DO 320 II = 1,NXY
          IODPROF(II) = IWORK(II) + IODPROF(II)
  320   CONTINUE
C
C
        GO TO 340
      END IF
C
C
      NRS = NRS + 1
      LASTX = X(INDF)
      LASTY = Y(INDF)
      XRS(NRS) = (X(INDF)+DELX)/FACT
      YRS(NRS) = (Y(INDF)+DELY)/FACT
      RRS(NRS) = IRECNO(INDF)
      WXRS(NRS) = SDELX/FACT
      WYRS(NRS) = SDELY/FACT
      IF (DEBUG(6)) THEN
       WRITE(IOUT,6025) NRS,XRS(NRS),YRS(NRS),SDELX/FACT,SDELY/FACT
       IF (ONLINE) WRITE(ITOUT,6025) NRS,XRS(NRS),YRS(NRS),
     +                               SDELX/FACT,SDELY/FACT
 6025  FORMAT(1X,'Stored as refinement reflection number',I5,' XRS',
     +    F8.1,' YRS',F8.1,'  SIGX,SIGY',2F7.2)
      END IF
C
C---- Store indices if pattern matching
C
      IF (MATCH) THEN
        JREC = IRECNO(INDF)
        IF (JREC.LT.0) JREC = -JREC
C
C
          IHKLR(1,NRS) = IHG(JREC)
          IHKLR(2,NRS) = IKG(JREC)
          IHKLR(3,NRS) = ILG(JREC)
C
C
      END IF
C
C
  340 ILAST = ILAST + 1
      IF (ILAST.EQ.MAXN) ILAST = 0
C
C---- Skip these tests for reflection list from previous film
C
      IF (GENLIST) GO TO 350
C
C---- Test for films with high background (eg intense synchrotron
C     films). If 25% of reflections have been measured, and
C     lt (MINREF/4) refinement spots found, then change NSIG on basis of
C     average background and start over again
C     As this is essentially a dynamic range problem, it should not
C     occur with image plates.
C
      IF (INDF.EQ.NREF/4.AND.(NRS.LT.MINREF/4).AND.(.NOT.IMGP)) THEN
        NN = INDF - NOVER
        IF (NN.NE.0) AVBKG = SUMBKG/NN
C
C
        IF (AVBKG.GT.140 .AND. NSIG.GT.4) THEN
          NSIG = 4                            
          WRITE (IOUT,FMT=6026) AVBKG,NSIG
 6026 FORMAT (//1X,'****** WARNING *****',/1X,'Average background in c',
     +       'entral region is ',F5.1,/2X,'and therefore NSIG has bee',
     +       'n reduced to',I3,' to help find refinement spots')
          IF (ONLINE) WRITE (ITOUT,FMT=6026) AVBKG,NSIG
          GO TO 210
        ELSE IF (AVBKG.GT.180 .AND. NSIG.GT.2) THEN
          NSIG = 2
          WRITE (IOUT,FMT=6026) AVBKG,NSIG
          IF (ONLINE) WRITE (ITOUT,FMT=6026) AVBKG,NSIG
          GO TO 210
        END IF
      END IF
C
C
  350 INDF = INDF + 1
      IF (INDF.LE.NREF) GO TO 290
  360 CONTINUE
C
C---- All reflections found
C
      IF (DOPROFILE) THEN
        IF (NPROFL.GT.0) THEN
          IF (EXPART) THEN
            WRITE (IOUT,FMT=6028) NPROFL
            IF (ONLINE) WRITE (ITOUT,FMT=6028) NPROFL
 6028 FORMAT (/1X,I4,' Reflections included in AVERAGE SPOT PROFILE')
          ELSE
            WRITE (IOUT,FMT=6029) NPROFL,NPARTL
            IF (ONLINE) WRITE (ITOUT,FMT=6029) NPROFL,NPARTL
 6029 FORMAT (/1X,I4,' Reflections included in AVERAGE SPOT PROFILE',
     +         ' including',I3,' partials')
          END IF
        ELSE
          WRITE (IOUT,FMT=6030)
 6030 FORMAT (//1X,'** NO reflections for AVERAGE SPOT PROFILE **')
          IF (ONLINE) WRITE (ITOUT,FMT=6030)
        END IF
        RETURN
      END IF
C
C
      IF (NZPBAD.GT.0) THEN
          WARN(14) = .TRUE.
          WRITE (IOUT,FMT=6070) NZPBAD,NULLPIX
 6070     FORMAT (//1X,I3
     $         ,' reflections have been rejected because the '
     $         ,' measurement box contains',/,1X
     $         ,'pixels with values less or equal to',I5,
     +         ' (assumed to '
     $         ,'be outside the scanned area).',/,1X,
     +        'See warning at end of logfile or in summary file.')
          IF (ONLINE) WRITE (ITOUT,FMT=6070) NZPBAD,NULLPIX
      END IF
      IF (NBGBAD.NE.0) THEN
          WRITE (IOUT,FMT=6031) NBGBAD,BGFREJ
 6031 FORMAT (//1X,I3,' reflections rejected because more than a ',
     1    'fraction',F5.2,' of the background pixels were rejected')
          IF (ONLINE) WRITE (ITOUT,FMT=6031) NBGBAD,BGFREJ
      END IF
      IF (NBGBADG.NE.0) THEN
          WRITE (IOUT,FMT=6033) NBGBADG,GRADMAXR
 6033 FORMAT (//1X,I3,' reflections rejected because the gradient',
     1    '/background is greater then',F6.3)
          IF (ONLINE) WRITE (ITOUT,FMT=6033) NBGBADG,GRADMAXR
      END IF
      IF (NRS.GE.MINREF) RETURN
C
C---- Problems... less than MINREF reflections found
C
      NWRN = NWRN + 1
      WRITE (IOUT,FMT=6032) NRS,NOVER,NWEAK,NSIG,NCLOSE
 6032 FORMAT (/1X,'ONLY',I3,' Suitable reflections found',/1X,'There a',
     +       're',I5,' OVERLOADS',I5,' TOO WEAK (NSIG=',I3,') and',I5,
     +       ' TOO CLOSE')
      IF (ONLINE) WRITE (ITOUT,FMT=6032) NRS,NOVER,NWEAK,NSIG,NCLOSE
C
C---- See if reducing spot separation criterion helps
C
      NPOSS = (NREF-NOVER-NWEAK)
      IF (NCLOSE.GT.MINREF/5) THEN
        SEP = 0.5*SEP
        ISEPN = FACT*SEP*100.0
        WRITE (IOUT,FMT=6034) SEP
 6034 FORMAT (1X,'Spot separation test reduced to ',F3.1,' mm')
        IF (ONLINE) WRITE (ITOUT,FMT=6034) SEP
C
C---- Ensure half of remaining reflections are on each side
C
        IF (NPOSS.LT.60) THEN
          IHALF = NPOSS/2 + 2
          IF (VEE) IHALF = (NPOSS+NRS)/2 + 2
        END IF
C
C
        GO TO 210
C
C     If this is because there are many overloads, allow up to
C     five times the previous limit on the pixels in the peak which can be
C     overloaded before rejecting the reflection.
C     Note NPMAX is passed in common /OVRLD/ to CGFIND,CGFIT
C
      ELSE IF (NOVER.GT.NREF/2 .AND. NPMAX.LT.NOVPIX*5) THEN
        USEOVRLD = .TRUE.
        NPMAX = NOVPIX*5
        WRITE (IOUT,FMT=6036) NPMAX,CUTOFF
 6036 FORMAT (1X,'TOO MANY OVERLOADS in Central box',/1X,'Allow up to',
     +       I3,' Pixels with values greater than',I6,' before ',
     +          'flagging as',
     +       ' overloaded',/2X,'These reflections will not be included',
     +       ' in the AVERAGE SPOT PROFILE ')
        IF (ONLINE) WRITE (ITOUT,FMT=6036) NPMAX,CUTOFF
        GO TO 210
C
C---- Have not got 3*MINREF possible reflections.
C---- If this is because they are all overloads, expand central box,
C     providing it is smaller than the detector size, but before doing this
C     try including partials if this is not already being done
C
      ELSE IF (NREF-NOVER.LT.3*MINREF) THEN
        IF (.NOT.PARTLS) THEN
C
C---- Intensity rejection criterion too high, reduce it (but only down
C     to NSIG=5)
C
          IF (NSIG.GT.5) THEN
            NSIG = NINT(0.666*NSIG)
            WRITE (IOUT,FMT=6040) NSIG
            IF (ONLINE) WRITE (ITOUT,FMT=6040) NSIG
            GO TO 210
          END IF
C
C---- If total number (fulls plus partials) > 3*MINREF, then include
C     partials
C
          IF (NREFT.GE.3*MINREF) THEN
            WRITE(IOUT,FMT=6060) NREF,PTMIN,MINREF
            IF (ONLINE) WRITE(ITOUT,FMT=6060) NREF,PTMIN,MINREF
            PARTLS = .TRUE.
            GOTO 20
          ELSE
C
C---- otherwise expand central limit if possible
C
            IF (LIMIT.LT.XMAX) THEN
              LIMIT = LIMIT + 500
              IF (VEE) VLIMIT = VLIMIT + 500
              XLIMIT = LIMIT
              VXLIMIT = VLIMIT
              WRITE(IOUT,FMT=6063) NREF,NREFT,3*MINREF,2*LIMIT/100
              IF (ONLINE) WRITE(ITOUT,FMT=6063) NREF, NREFT, 3*MINREF,
     +                    2*LIMIT/100
              GOTO 20
            ELSE
C
C---- Cannot expand limit any further, include partials
C
              WRITE(IOUT,FMT=6060) NREF,PTMIN,MINREF
              IF (ONLINE) WRITE(ITOUT,FMT=6060) NREF,PTMIN,MINREF
              PARTLS = .TRUE.
              GOTO 20
            END IF
          END IF
        ELSE
C
C---- IF not using ADDPART, try decreasing PTMIN (to a minimum of 0.01)
C
          IF (.NOT.ADDPART) THEN
            IF (PTMIN.EQ.0.01) GOTO 370
            SPTMIN = PTMIN
            PTMIN = MAX(0.01,PTMIN-0.1)
            WRITE(IOUT,FMT=6062) SPTMIN,PTMIN
            IF (ONLINE) WRITE(ITOUT,FMT=6062) SPTMIN,PTMIN
            GOTO 20
          END IF
        END IF

 370    IF (LIMIT.LT.XMAX) THEN
          LIMIT = LIMIT + 500
          IF (VEE) VLIMIT = VLIMIT + 500
          XLIMIT = LIMIT
          VXLIMIT = VLIMIT
          WRITE (IOUT,FMT=6038) 3*MINREF,2*LIMIT/100
 6038 FORMAT (1X,'Less than',I3,' NON-OVERLOADED Reflections in centra',
     +       'l box',/1X,'Expand central area to',I4,' mm square.')
          IF (ONLINE) WRITE (ITOUT,FMT=6038) 3*MINREF,2*LIMIT/100
          IF (GENLIST) GOTO 90
          GO TO 20
        ELSE
          WRITE (IOUT,FMT=6039) 3*MINREF,MINREF
          IF (ONLINE) WRITE (ITOUT,FMT=6039) 3*MINREF,MINREF
 6039     FORMAT(1X,'Less than',I3,' NON-OVERLOADED Reflections on ',
     +        'entire detector !!',/,1X,'Possible courses of action:',
     +        /,1X,'1) Include overloads in refinement:',/,1X,
     +        'REFINEMENT INCLUDE OVERLOADS',//,1X,'2) Include ',
     +        'partials in refinement:',/,1X,
     +        'REFINEMENT INCLUDE PARTIALS',//,1X,'3) Reduce the',
     +        ' minimum acceptable number of reflections for ',
     +        'refinement',/,1X,'(Currently',I3,'):',/,1X,
     +        'REFINEMENT NREF 10 (say)')
          NSHUTERR = 4
          CALL SHUTDOWN(CALLEDFROM)
        END IF
      ELSE
C
C---- Intensity rejection criterion too high, reduce it (but only down
C     to NSIG=1)
C
        IF (NSIG.EQ.1) RETURN
        NSIG = NINT(0.666*NSIG)
        WRITE (IOUT,FMT=6040) NSIG
 6040 FORMAT (1X,'NSIG Reduced to',I3,' Repeating search')
        IF (ONLINE) WRITE (ITOUT,FMT=6040) NSIG
        GO TO 210
      END IF
      RETURN
      END
C
C== CGFIND ==
C
      SUBROUTINE CGFIND(A,IDR,NX,NY,DELX,DELY,SOD,ODVAR,MINOD,NBKG,
     +                  IBACK,NPOVER,IFLAG)
C      ===========================================================
C
      IMPLICIT NONE
C
C---- Find centre of gravity of spots for centrs, when no
C     background mask is defined.
C     the background (IBACK) is determined by finding the
C     mean density of the "NBKG" (the number of
C     background points defined by the measurement box) pixels
C     with the lowest density. this level is
C     subtracted prior to finding the centre of gravity.
C     ODVAR, the variance in the ods, is used as a criterion for
C     selecting spots in centrs.
C           IFLAG        = 0 Spot is OK
C                        = 4 Overloaded spot
C
C---- 12/9/81 Change IA to I*4 from I*2, and calls to BEXPAN to BEXPAN4
C     SORTUP to SORTUP4 to cope with dynamic range up to 64K
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      REAL DELX,DELY,ODVAR,SOD
      INTEGER IBACK,IDR,MINOD,NBKG,NPOVER,NX,NY,IFLAG
C     ..
C     .. Array Arguments ..
      INTEGER*2 A(*)
C     ..
C     .. Local Scalars ..
      REAL SOD2,SUMOD,SX,SY
      INTEGER HX,HY,I,IBA,IJ,IOD,NXY,P,Q
C     ..
C     .. Local Arrays ..
      INTEGER IS(MAXBOX)
      INTEGER IA(MAXBOX)
C     ..
C     .. External Subroutines ..
      EXTERNAL BEXPAN4,SORTUP4
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC REAL
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/ovrld.f
C
C $Id: ovrld.f,v 1.1 2002/05/02 10:47:03 harry Exp $
C
C--- awk generated include file  ovrld.h
C---- START of include file ovrld.h
C
C
C     .. Scalars in Common Block /OVRLD/ ..
      INTEGER NPMAX
C     ..
C     .. Common Block /OVRLD/ ..
      COMMON /OVRLD/NPMAX
C     ..
C
C
C&&*&& end_include  ../inc/ovrld.f
C&&*&& include  ../inc/parm1.f
C
C $Id: parm1.f,v 1.1 2002/05/02 10:47:05 harry Exp $
C
C--- awk generated include file  parm1.h
C---- START of include file parm1.h
C
C
C
C     .. Scalars in common block /PARM1/ ..
      REAL BGSIG,EFAC,EFACSQ,BGFREJ,GRADMAX,GRADMAXR,BGRAT,PKRAT,
     +     RESD,RESDLOW
      INTEGER CUTOFF,NOVPIX,NDSTART,NDTOT,IXDMIN,IXDMAX,IYDMIN,IYDMAX,
     +     IDMIN,IDMAX
      LOGICAL DUMPSPOT,BADPLOT,DUMPALL,BADPLOT2
C     ..
C     .. Common Block /PARM1/ ..
      COMMON /PARM1/BGSIG,EFAC,EFACSQ,BGFREJ,GRADMAX,GRADMAXR,
     +              BGRAT,PKRAT,RESD,RESDLOW,CUTOFF,NOVPIX,
     +              NDSTART,NDTOT,IXDMIN,IXDMAX,IYDMIN,IYDMAX,
     +              IDMIN,IDMAX,DUMPSPOT,BADPLOT,DUMPALL,BADPLOT2
C     ..
C
C
C&&*&& end_include  ../inc/parm1.f
C     ..
      SAVE
C
      IFLAG = 0
      NXY = NX*NY
      HX = NX/2 
      HY = NY/2
C
C Expand to integer*4 (for films,data is in bytes)
C          ****************
      CALL BEXPAN4(A,IA,NXY)
C          ****************
C
C---- Find minimum and maximum od, and check for overloads and zero
C     value pixels
C
      NPOVER = 0
C
      DO 20 I = 1,NXY
C
        IOD = IA(I)
        IF (IOD.GT.CUTOFF) NPOVER = NPOVER + 1
        IF (NPOVER.GT.NPMAX) GO TO 70
        IF (IOD.LE.NULLPIX) GOTO 80
   20 CONTINUE
C
C  Sort pixels into increasing order
      CALL SORTUP4(NXY,IA,IS)
C
C---- Loop over bins to find mean background level
C
      SUMOD = 0.0
      MINOD = IA(IS(1))
C
C  Don't use any spots which contains a zero pixel (must be in unscanned
C  area of Hendrix image plate)
C
      IF (MINOD.EQ.0) THEN
        ODVAR = 0.0
        SOD = 0.0
        IBACK = 0
        DELX = 0.0
        DELY = 0.0
        NPOVER = 0
        RETURN
      END IF
C
      DO 30 I = 1,NBKG
        SUMOD = IA(IS(I)) + SUMOD
   30 CONTINUE
C
C---- Set background to mean of the NBKG points + 1 (to avoid zero's)
C
      IBACK = SUMOD/NBKG + 1
C
      SX = 0.0
      SY = 0.0
      SOD = 0.0
      SOD2 = 0.0
      IJ = 1
      HX = HX*IDR
C
C
      DO 60 P = -HX,HX,IDR
        DO 50 Q = -HY,HY
          IBA = IA(IJ) - IBACK
          SX = P*IBA + SX
          SY = Q*IBA + SY
          SOD = SOD + IBA
          SOD2 = REAL(IBA)*REAL(IBA) + SOD2
          IJ = IJ + 1
   50   CONTINUE
   60 CONTINUE
C
C---- Calculate first moment
C
      ODVAR = SOD2/NXY - (SOD/NXY)**2
C
      IF (SOD.NE.0.0) THEN
        DELX = SX/SOD
        DELY = SY/SOD
      END IF
      RETURN
C
C
   70 IFLAG = 4
      SOD = 0.0
C
 80   IFLAG = 3
      SOD = 0.0
C
      END
C $Id: cgfit.f,v 1.8 2003/11/27 14:49:34 andrew Exp $
C== CGFIT ==
C
      SUBROUTINE CGFIT(RAS,IRAS,IDR,DELX,DELY,SPOT,SDELX,SDELY,IPART,
     +                 IFLAG)
C     ==============================================================
C
      IMPLICIT NONE
C   Determine the centre of gravity of the spot and its integrated
C   intensity (SPOT)
C   Introduce rejection of background pixels 11/3/91
C
C   Returns:
C           DELX, DELY   c. og g. shift from centre of box
C           SPOT         Integrated intensity
C           SDELX,SDELY  Standard deviations in centre of gravity coords.
C           IFLAG        = 0 Spot is OK
C                        = 1 Too steep background gradient
C                        = 2 Too many background pixels rejected
C                        = 3 Contains zero value pixels
C                        = 4 Overloaded spot
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      REAL DELX,DELY,SPOT,SDELX,SDELY
      INTEGER IDR,IPART,IFLAG
C     ..
C     .. Array Arguments ..
      INTEGER IRAS(5)
      INTEGER*2 RAS(*)
C     ..
C     .. Local Scalars ..
      REAL A,B,C,SOD,SPOD,SPP,SQOD,SQQ,TOD,TPOD,TPP,TQOD,TQQ,GRADM,
     +     SP,SQ,SPQ,BGDEVMAX,RMSBG,XSPOT,XFAC,GRAD,ERR,XMULT
      INTEGER HX,HY,IC,IJ,IOD,IP,IPQ,IQ,IRX,IRY,NXY,NOVER,P,Q,S,T,NBKG,
     +        NRMAX,NRFL,NXX,NYY,I,IODMAX,IODMIN,NPKSIZ,MODE
      LOGICAL P1,P2,DEBG
C     ..
C     .. Local Arrays ..
      INTEGER IA(MAXBOX),MASK(MAXBOX),MASKREJ(NREJMAX)
      REAL PQSUMS(6)
C     ..
C     .. External Subroutines ..
      EXTERNAL BEXPAN4,BGSOLVE,BGTEST
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/ovrld.f
C
C $Id: ovrld.f,v 1.1 2002/05/02 10:47:03 harry Exp $
C
C--- awk generated include file  ovrld.h
C---- START of include file ovrld.h
C
C
C     .. Scalars in Common Block /OVRLD/ ..
      INTEGER NPMAX
C     ..
C     .. Common Block /OVRLD/ ..
      COMMON /OVRLD/NPMAX
C     ..
C
C
C&&*&& end_include  ../inc/ovrld.f
C&&*&& include  ../inc/parm1.f
C
C $Id: parm1.f,v 1.1 2002/05/02 10:47:05 harry Exp $
C
C--- awk generated include file  parm1.h
C---- START of include file parm1.h
C
C
C
C     .. Scalars in common block /PARM1/ ..
      REAL BGSIG,EFAC,EFACSQ,BGFREJ,GRADMAX,GRADMAXR,BGRAT,PKRAT,
     +     RESD,RESDLOW
      INTEGER CUTOFF,NOVPIX,NDSTART,NDTOT,IXDMIN,IXDMAX,IYDMIN,IYDMAX,
     +     IDMIN,IDMAX
      LOGICAL DUMPSPOT,BADPLOT,DUMPALL,BADPLOT2
C     ..
C     .. Common Block /PARM1/ ..
      COMMON /PARM1/BGSIG,EFAC,EFACSQ,BGFREJ,GRADMAX,GRADMAXR,
     +              BGRAT,PKRAT,RESD,RESDLOW,CUTOFF,NOVPIX,
     +              NDSTART,NDTOT,IXDMIN,IXDMAX,IYDMIN,IYDMAX,
     +              IDMIN,IDMAX,DUMPSPOT,BADPLOT,DUMPALL,BADPLOT2
C     ..
C
C
C&&*&& end_include  ../inc/parm1.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C&&*&& include  ../inc/sums.f
C
C $Id: sums.f,v 1.1 2002/05/02 10:47:21 harry Exp $
C
C--- awk generated include file  sums.h
C---- START of include file sums.h
C
C
C     Elements of ASPOT
C     1 = Summation integration intensity
C     2 = Total background counts under peak assuming peak has mm symmetry
C     3 = Rms variation in background, after rejecting background points.
C         This is evaluated in BGSOLVE called from EVAL.
C     4 = Centre of gravity in X direction (in pixels)
C     5 = Centre of gravity in Y direction (in pixels)
C         These are wrt an origin at the centre of the measurement box
C     6 = sum p*iod for background pixels
C     7 = sum q*iod for background pixels
C     8 = sum iod for background pixels
C     9 = Background plane constant a (gradient in X direction)
C    10 = Background plane constant b (gradient in Y direction)
C    11 = Background plane constant c 
C    12 = Largest deviation from background plane, excluding rejected pixels
C    13 = Profile fitted intensity
C    14 = Variance of profile fitted intensity = sum (deltasq) for peak
C         pixels only. Used to calculate PKRATIO and also profile fitted
C         sigma(I) in unweighted case only.
C    15 = Number of rejected background pixels
C    16 = Variance of profile fitted intensity in weighted case (default)
C    17 = sum W*DELTA**2 for profile fit
C    18   unused
C     .. Arrays in common block /SUMS/ ..
      REAL ASPOT
C     ..
C     .. Common Block /SUMS/ ..
      COMMON /SUMS/ASPOT(18)
C     ..
C
C
C&&*&& end_include  ../inc/sums.f
C     ..
C     ..
C     .. Equivalences ..
      EQUIVALENCE (ASPOT(3),RMSBG)
      EQUIVALENCE (ASPOT(6),SPOD)
      EQUIVALENCE (ASPOT(7),SQOD), (ASPOT(8),SOD), (ASPOT(9),A)
      EQUIVALENCE (ASPOT(10),B), (ASPOT(11),C), (ASPOT(12),BGDEVMAX)
C
C
      SAVE
C     .. Data statements ..
C
C
      DATA DEBG/.FALSE./
C
C---- Mode for EVAL (signifies we have not flagged overlapped background
C                     pixels)
      MODE = 0
      NRFL = 1
      IFLAG = 0
      NXX = IRAS(1)
      NYY = IRAS(2)
C      IF (DEBG) CALL ODPLOT(RAS,NXX,NYY,1)
      HX = IRAS(1)/2
      HY = IRAS(2)/2
      NXY = (2*HX+1)* (2*HY+1)
C
C          *******************
      CALL BEXPAN4(RAS,IA,NXY)
C          *******************
C
      IC = HX + HY - IRAS(3)
      IRX = HX - IRAS(4)
      IRY = HY - IRAS(5)
C
C---- Mean spot size (ie peak area of box) in X and Y
      NPKSIZ = 0.25*(NXX + NYY - 2*(IRAS(4) + IRAS(5)))
C
      SP = 0.0
      SQ = 0.0
      SPQ = 0.0
      SPP = 0.0
      SQQ = 0.0
      SPOD = 0.0
      SQOD = 0.0                                
      SOD = 0.0
      TPP = 0.0
      TQQ = 0.0
      TOD = 0.0
      TPOD = 0.0
      TQOD = 0.0
      IODMAX = 0
      IODMIN = 999999
C
C
      S = 0
      T = 0
      IJ = 0
      NOVER = 0
C
C
      DO 10 I=1,6
        PQSUMS(I) = 0.0
 10   CONTINUE
C
      DO 30 P = -HX,HX
        IP = ABS(P)
        P1 = (IP.GT.IRX)
        P2 = (IP.EQ.IRX)
C
C
        DO 20 Q = -HY,HY
          IJ = IJ + 1
          IQ = ABS(Q)
          IOD = IA(IJ)
C
C---- Reject overloads
C
          IF (IOD.GT.CUTOFF) NOVER = NOVER + 1
C
C---- Trap spots that include pixels outside scanned area
C
          IF (IOD.LE.NULLPIX) GOTO 80
          IF (IOD.GT.IODMAX) IODMAX = IOD
          IF (IOD.LT.IODMIN) IODMIN = IOD
C
C
          IF (NOVER.GT.NPMAX) THEN
            GO TO 70
          ELSE
            IPQ = IP + IQ
C
C
            IF (P1 .OR. IPQ.GT.IC .OR. IQ.GT.IRY) THEN
C
              IF (IRAS(3).NE.0 .OR. IP.LT.IRX .OR. IQ.LT.IRY) THEN
C
C
                IF (IRAS(3).GE.0 .OR. IPQ.LE.IC) THEN
C  Background pixels
              S = S + 1
              SP = P + SP
              SQ = Q + SQ
              SPP = P*P + SPP
              SQQ = Q*Q + SQQ
              SPQ = P*Q + SPQ
              SPOD = P*IOD + SPOD
              SQOD = Q*IOD + SQOD
              SOD = SOD + IOD
              MASK(IJ) = -1
                END IF
              END IF
              ELSE
C
C---- Treat pixles around Peak as OK now, as in integration 16/7/98
CAL            ELSE IF (.NOT.P2 .AND. IPQ.NE.IC .AND. IQ.NE.IRY) THEN
C
C  Peak pixels
              T = T + 1
              TPP = P*P + TPP
              TQQ = Q*Q + TQQ
              TPOD = P*IOD + TPOD
              TQOD = Q*IOD + TQOD
              TOD = TOD + IOD
              MASK(IJ) = 1
            END IF
          END IF
   20   CONTINUE
   30 CONTINUE
C
C
C  Background constants (no backgound points rejected)
      A = SPOD/SPP
      B = SQOD/SQQ
      C = SOD/S
C
C  Set up PQSUMS
      PQSUMS(1) = SPP
      PQSUMS(2) = SQQ
      PQSUMS(3) = SPQ
      PQSUMS(4) = SP
      PQSUMS(5) = SQ
      PQSUMS(6) = S
      NBKG = S
C
C   Set maximum allowed number of allowed background pixels to be
C   rejected from background plane determination (as fraction of total)
C
      NRMAX = NINT(BGFREJ*NBKG)
C
C          ******************************************************
      CALL EVAL(IA(1),MASK(1),IRAS,PQSUMS,BGSIG,NRMAX,NRFL,
     +          MASKREJ,DEBG,MODE)
C          ******************************************************
C
C---- Check that not too many background points have been rejected
C     (Flagged by NRMAX=-999)
C
      IF (NRMAX.EQ.-999) GOTO 90
C
C
C  Check maximum gradient not exceeded
C
              IF (C.GT.0.0) THEN
                GRADM = MAX(ABS(A),ABS(B))/C
              ELSE
                GRADM = 0.0
              END IF
      IF (GRADM.GT.GRADMAXR) GOTO 100
C  Recalculate SPOT based on new value of C
C
C
C
      ASPOT(2) = T*C
      SPOT  = TOD - ASPOT(2)
C
C---- Catch zero spots
C
      IF (SPOT.NE.0.0) THEN
        DELX = (TPOD-A*TPP)/SPOT*IDR
        DELY = (TQOD-B*TQQ)/SPOT
      ELSE
        DELX = 0.0
        DELY = 0.0
      END IF
C
C---- Calculate errors in c. of g.
C         
C---- Calculate a crude gradient for this spot, used to boost sigma
C     calculation, assuming a scanner error factor of 0.15
C
      GRAD = (FLOAT(IODMAX-IODMIN))/NPKSIZ
      ERR = (GRAD*0.15)**2
      IF ((MACHINE.EQ.'ADSC') .OR. 
     $     ((MACHINE.EQ.'CBF ').AND.(MODEL(1:4).EQ.'ADSC')))THEN
        ERR = (GRAD*0.20)**2
      ENDIF
      IF ((MACHINE.EQ.'MARC').AND.(MODEL.EQ.'MOSAIC3'))
     +     ERR = (GRAD*0.30)**2
      SDELX = 0.0
      SDELY = 0.0
C
C---- remove next two lines before distribution!!!
C
c      SDELX = 1e-5
c      SDELY = 1e-5
      IJ = 0
      IF (SPOT.EQ.0.0) GOTO 65
C
      XSPOT = SPOT/GAIN
C    
      DO 50 P = -HX,HX
C
          XFAC = (P-DELX)/XSPOT
          XFAC = XFAC*XFAC
C
        DO 40 Q = -HY,HY
          IJ = IJ + 1
          IOD = NINT(IA(IJ)/GAIN)
          IOD = IOD + NINT(ERR)
          IF (MASK(IJ).EQ.1) THEN
            SDELX = SDELX + XFAC*IOD
            SDELY = SDELY + ((Q-DELY)/XSPOT)**2*IOD
          END IF 
 40     CONTINUE
 50   CONTINUE
C
C---- Fudge factor 2.5 boosts sigma estimates to get mean weighted residual
C     of about 1.0. The need for this presumably reflects the fact that the
C     accuracy of the centre of gravity determination is not solely determined
C     by counting statistics. Since the strongest reflections are used in
C     refinement, it may be partially due to scanner errors in regions of
C     high gradients, but this is not yet clear. Another possibility is
C     that the interpolation from the spiral scan to the orthogonal scan
C     introduces errors in Mar Research and Mac Science detectors.
C
      SDELX = 2.5*SQRT(SDELX)
      SDELY = 2.5*SQRT(SDELY)
C
C---- Preliminary tests with RaxisIV images suggest an even larger inflation
C     is required (for 100 micron raster). However, si this just because 
C     the spots are so large that the sd's get unreasonably small ?
C
      IF (((MODEL.EQ.'RAXISIV').OR.(MODEL.EQ.'RAXISV'))
     $     .AND.(RAST.LT.0.15)) THEN
        SDELX = 2.0*SDELX
        SDELY = 2.0*SDELY
      END IF
      IF ((MACHINE.EQ.'ADSC') .OR. 
     $     ((MACHINE.EQ.'CBF ').AND.(MODEL(1:4).EQ.'ADSC')))THEN
        SDELX = 2.0*SDELX
        SDELY = 2.0*SDELY
      END IF
C
C---- Jupiter (Saturn, Mercury) values based only on one set of images
C     from a Jupiter...
C
      IF ((MACHINE.EQ.'JUPI').OR.(MACHINE.EQ.'SATU').OR.
     $     (MACHINE.EQ.'MERC')) THEN
        SDELX = 2.0*SDELX
        SDELY = 2.0*SDELY
      END IF
C
C---- Mar mosaic 3x3 need to inflate sd's
C
      IF ((MACHINE.EQ.'MARC').AND.(MODEL.EQ.'MOSAIC3')) THEN
        SDELX = 3.0*SDELX
        SDELY = 3.0*SDELY
      END IF
C
C---- is this really necessary for Bruker images? temporarily sets sdlx,
C     sdely to non-zero... there's a nasty crash with Bruker images
C     that needs to be located..
C     
C
      IF (MACHINE.EQ.'BRUK') THEN
        SDELX = (2.0*SDELX)+0.01
        SDELY = (2.0*SDELY)+0.01
      END IF
C
C---- Inflate standard deviations for partially recorded reflections. There
C     is no obvious way to do this, so the following is highly empirical
C     and may need to be revised. IPART is zero for fully recorded reflections
C     and lies between 1 and 99 for partials, 1 is least fully recorded, 100
C     is again fully recorded.
C
      IF (IPART.NE.0) THEN
        IF (IPART.LE.25) THEN
          XMULT = 7.0
        ELSE IF (IPART.LE.50) THEN
          XMULT = 5.0
        ELSE IF (IPART.LE.75) THEN
          XMULT = 4.0
        ELSE IF (IPART.LE.90) THEN
          XMULT = 2.0
        ELSE
          XMULT = 1.5
        END IF
        SDELX = XMULT*SDELX
        SDELY = XMULT*SDELY
      END IF
C
 65   CONTINUE
C
C
      RETURN
C
C  Overloaded spots
C
   70 IFLAG = 4
      SPOT = 0.0
      RETURN
C
C  Spots with zero pixel values
C
   80 IFLAG = 3
      SPOT = 0.0
      DELX = 0.0
      DELY = 0.0
      RETURN
C
C  Spots with too many rejected background points
   90 IFLAG = 2
      SPOT = 0.0
      DELX = 0.0
      DELY = 0.0
      RETURN
C
C  Spots with too steep a gradient
  100 IFLAG = 1
      SPOT = 0.0
      DELX = 0.0
      DELY = 0.0
      END
C $Id: char2int.f,v 1.1 2003/07/11 13:34:22 harry Exp $
C---- jiffy subroutine to convert strings to integers - also works with
C     character arrays
C
      SUBROUTINE CHAR2INT(NUMBER,STRING,LENGTH)
      IMPLICIT NONE
C     ..
C     .. scalar arguments
      INTEGER LENGTH,NUMBER
C     ..
C     .. array arguments
      CHARACTER STRING(LENGTH)
C     ..
C     .. local scalars
      INTEGER IDUM,I
      NUMBER = 0
      DO 100 I = 1,LENGTH
        IF((STRING(I).GE.'0').and.(STRING(I).LE.'9'))THEN
          IDUM = ICHAR(STRING(I))-48
          NUMBER = 10*NUMBER+IDUM
        ENDIF
 100  ENDDO
      RETURN
      END
c     check_input.f
c     maintained by G.Winter
c     25th October 2002
c     
c     A subroutine to check a string for spaces, to see if the
c     subroutine mparse is playing silly buggers with the input.
c     
c     This will return .true. if there us a space in the string.
c     
c     
c     
c     
c     
c     $Id: check_input.f,v 1.1 2002/10/25 14:44:19 graeme Exp $
c     

      subroutine check_for_space(string, has_space)

      implicit none
      character*(*) string
      logical has_space
      integer i, length

c     external subroutines
      integer lenstr
      external lenstr

      length = lenstr(string)

      if(length .le. 0) then
c     there must be something wring here...
         has_space = .false.
         return
      end if

      do i = 1,length
         if(string(i:i) .eq. ' ') then
            has_space = .true.
            return
         end if
      end do

      has_space = .false.
      return
      end
C $Id: checkhkl.f,v 1.3 2003/04/30 14:01:38 harry Exp $
C== CHECKHKL ==
      SUBROUTINE CHECKHKL(IHKLSTR,IPU,IPS,IFLAG)
C
C
      IMPLICIT NONE
C
C
C---- Check indices, IFLAG=0 if indices are equal,
C     =1 if unique reflection is next in
C     sorted list, =2 if generated reflection is next.
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C
C     .. Scalar Arguments ..
      INTEGER IPU,IPS,IFLAG
C
C     ..
C     .. Array Arguments ..
      INTEGER*2 IHKLSTR(MCOLSTR,NREFSTR)
C     ..
C     .. Local Scalars ..
      INTEGER IHKLU,IHKLS,IH,IK,IL
C     ..
C     .. Local Arrays ..
C     ..
C     .. External Subroutines ..
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC NINT
C     ..
C     .. Common blocks ..
C     ..
C     .. Equivalences ..
      SAVE
C     ..
      IH = IHKLSTR(1,IPU)
      IK = IHKLSTR(2,IPU)
      IL = IHKLSTR(3,IPU)
      IHKLU = ((IH+256)*512+(IK+256))*512 + IL + 256
      IH = IHKLSTR(1,IPS)
      IK = IHKLSTR(2,IPS)
      IL = IHKLSTR(3,IPS)
      IHKLS = ((IH+256)*512+(IK+256))*512 + IL + 256
      IF (IHKLU.EQ.IHKLS) IFLAG = 0
      IF (IHKLU.LT.IHKLS) IFLAG = 1
      IF (IHKLU.GT.IHKLS) IFLAG = 2
      RETURN
      END
C $Id: checkmask.f,v 1.3 2003/04/30 14:01:38 harry Exp $
C== CHECKMASK  ==
      SUBROUTINE CHECKMASK(MASK,LRAS,NPBOX,NBADPIX)
      IMPLICIT NONE
C 
C---- This subroutine checks for overlapping peak pixels closer to the
C     neighbouring spot than this one using the list of separations from
C     MASKIT
C
C     MASK     is passed in 
C     DEBUG(48) for this S/R
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      INTEGER NPBOX,NBADPIX
C     ..
C     .. Array Arguments ..
      INTEGER MASK(MAXBOX),LRAS(5)
C     ..
C     .. Local Scalars ..
      INTEGER I,NXX,NYY,NHX,NHY,IJ,IOFFSET,IDX,IDY,NRX,NRY,NSEP,
     +        ISEPX,ISEPY,P,Q,NXY,NTOT,NWSUM
      REAL R1SQ,R2SQ
C     ..
C     .. Local Arrays ..
C     ..
C     .. External Functions ..
C     ..
C     .. External Subroutines ..
CAL      EXTERNAL GENSORT,GETSTRIP,GETYIND,GETBOX,PQINV,SETMASK,RASPLOT4
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS,MIN
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C
C
      INTEGER IDXSTORE,IDYSTORE,NUMB,NSTORE
      COMMON /SEPAR/ IDXSTORE(200,NMASKS),IDYSTORE(200,NMASKS),
     +               NUMB(200,NMASKS),NSTORE(NMASKS)
      NBADPIX = 0
      NWSUM = 0
      NTOT = 0
C
C---- How many separations
C
      NSEP = NSTORE(NPBOX)
      IF (NSEP.EQ.0) RETURN
      NXX = LRAS(1)
      NYY = LRAS(2)
      NXY = NXX*NYY
      NHX = NXX/2
      NHY = NYY/2
      NRX = LRAS(4)
      NRY = LRAS(5)
      ISEPX = NHX - NRX
      ISEPY = NHY - NRY
      IF (DEBUG(48)) THEN
         WRITE(IOUT,FMT=6000) NSEP
         IF (ONLINE) WRITE(ITOUT,FMT=6000) NSEP
      END IF
 6000 FORMAT(1X,'CHECKMASK.. number of separations:',I3)
C
C---- Loop over all possible separations
C
      DO 40 I = 1,NSEP
C
C---- Loop over all peak pixels and test if they are also peak pixels
C     in the neighbouring spot, and if so, which spot are they closest
C     to.
C
        NBADPIX = 0
        IDX = IDXSTORE(I,NPBOX)
        IDY = IDYSTORE(I,NPBOX)
        IJ = 0
        IOFFSET = IDX*NYY + IDY
C
        DO 24 P = -NHX,NHX
C
C---- Test for overlap
C
          IF ((IDX - P).GT.ISEPX) THEN
            IJ = IJ + NYY
            GOTO 24
          END IF
          DO 22 Q = -NHY,NHY
            IJ = IJ + 1
            IF ((IDY.GE.0).AND.((IDY - Q).GT.ISEPY)) GOTO 22
            IF ((IDY.LE.0).AND.((IDY - Q).LT.-ISEPY)) GOTO 22
C
C---- Test if this pixel in both this spot and neighbouring spot
C
            IF ((MASK(IJ).EQ.1).AND.(MASK(IJ - IOFFSET).EQ.1)) THEN
              R1SQ = P*P + Q*Q
              R2SQ = (IDX-P)*(IDX-P) + (IDY-Q)*(IDY-Q)
              IF (R1SQ.GT.R2SQ) NBADPIX = NBADPIX + 1
            END IF
 22       CONTINUE
 24    CONTINUE
C
C---- Sums for mean number of bad (overlapped) pixels weighted by
C     number of times this separation occurs
        NWSUM = NWSUM + NBADPIX*NUMB(I,NPBOX)
        NTOT = NTOT + NUMB(I,NPBOX)
        IF (DEBUG(48)) THEN
          WRITE(IOUT,FMT=6002) I,IDX,IDY,IOFFSET,NBADPIX
          IF (ONLINE) WRITE(ITOUT,FMT=6002) I,IDX,IDY,IOFFSET,NBADPIX
 6002     FORMAT(1X,'Separation ',I3,' idx=',I3,' idy=',I3,' ioffset',
     +           '=',I5,' Number bad pixels',I5)
        END IF
C
C---- End of loop over separations
C
  40  CONTINUE
      IF (NTOT.NE.0) NBADPIX = NWSUM/NTOT
      RETURN
      END
C $Id: checku.f,v 1.7 2004/03/08 17:51:15 harry Exp $
C
C== CHECKU ==
C
C
C
      SUBROUTINE CHECKU(U)
C     ====================
C
C---- Check that U is a pure rotation matrix
C
C
C
C
C     .. Array Arguments ..
      REAL U(3,3)
C     ..
C     .. Local Scalars ..
      REAL DET
      INTEGER I,II,J,JJ
      CHARACTER CALLEDFROM*80
      LOGICAL BADMAT
C     ..
C     .. Local Arrays ..
      REAL U_INV(3,3),U_TRANS(3,3),U_TEMP(3,3)
C     ..
C     .. External Subroutines ..
      EXTERNAL MINV33,TRANSP
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS
C     ..
C     .. Common Blocks ..
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C
C
c      SAVE
C
      CALLEDFROM = 'CHECKU'
      BADMAT = .FALSE.
C
C          *******************
      CALL MINV33(U_INV,U,DET)
C          *******************
C
C---- Check the determinant
C
      IF (ABS(DET-1.000).GT.0.001) THEN
C
        WRITE (IOUT,FMT=6000) DET
        WRITE (IOUT,FMT=6002) ((U(II,JJ),JJ=1,3),II=1,3)
        IF(ONLINE)THEN
          WRITE (ITOUT,FMT=6000) DET
          WRITE (ITOUT,FMT=6002) ((U(II,JJ),JJ=1,3),II=1,3)
        ENDIF
C
        NSHUTERR = 1
        CALL SHUTDOWN(CALLEDFROM)
c        STOP
      ELSE
C
C---- Check that the transpose of U is equal to its inverse
C
C            *****************
        CALL TRANSP(U_TRANS,U)
C            *****************
C
        DO 20 J = 1,3
          DO 10 I = 1,3
            U_TEMP(I,J) = U_TRANS(I,J)-U_INV(I,J)
            IF (ABS(U_TEMP(I,J)).GT.0.001) BADMAT = .TRUE.
 10       CONTINUE
 20     CONTINUE
C
C
        IF(BADMAT)THEN
 30       CONTINUE
          WRITE (IOUT,FMT=6004)
          WRITE (IOUT,FMT=6002) ((U(II,JJ),JJ=1,3),
     $         (U_TEMP(II,JJ),JJ=1,3),II=1,3)
          IF(ONLINE)THEN
            WRITE (ITOUT,FMT=6004)
            WRITE (ITOUT,FMT=6002) ((U(II,JJ),JJ=1,3),
     $         (U_TEMP(II,JJ),JJ=1,3),II=1,3)
          ENDIF
          NSHUTERR = 2
          CALL SHUTDOWN(CALLEDFROM)
        ELSE
          RETURN
        ENDIF
c        STOP
      END IF
C
C---- Format statements
C
 6000 FORMAT (/' ** ERROR ** The determinant of U is ',F9.5,' A value ',
     +     'of 1.0 would correspond to a simple rotation.')
 6002 FORMAT (/' The matrix U defining the standard setting is:',
     +     /3 (15X,3F9.5,6X,'|',3F9.5,/))
 6004 FORMAT (/' ** ERROR ** The matrix Umat is not a simple rotation ',
     +     'matrix')
C     
C
      END
      SUBROUTINE CHKBOX(IXS,IYS,IXF,IYF,ISTAT)
C     =========================================
C
      IMPLICIT NONE
C
C
C     .. Parameters ..
C&&*&& include  ../inc/mxdinc.f
C
C $Id: mxdinc.f,v 1.1 2002/05/02 10:47:00 harry Exp $
C
C--- awk generated include file  mxdinc.h
C---- START of include file mxdinc.h
C
C
c common block for mxd routines: various parameters for XDL routines
c
c     base_width    width of base frame
c     base_height   height of base frame
c     men_x,men_y   position of menu area
c     par_x,par_y   position of parameter area
C     

C     IORDER    (R)   Order of the data in the input image 
c                with respect to two local axes ax1, ax2 e.g.
c                (xf, yf) as a number from 1 to 8.
c                    1   +ax1 slow   +ax2 fast    (+xf, +yf)
c                    2   +ax1 slow   -ax2 fast    (+xf, -yf)
c                    3   -ax1 slow   +ax2 fast    (-xf, +yf)
c                    4   -ax1 slow   -ax2 fast    (-xf, -yf)
c                    5   +ax2 slow   +ax1 fast    (+yf, +xf)
c                    6   +ax2 slow   -ax1 fast    (+yf, -xf)
c                    7   -ax2 slow   +ax1 fast    (-yf, +xf)
c                    8   -ax2 slow   -ax1 fast    (-yf, -xf)
c
c
c     JORDER    (R)   Display order with respect to the two
c                local axes (1 to 8) along the X-windows
c                axes X horizontal (left to right), Y vertical 
c                (top to bottom ) with origin at top left
c                1  +ax1 X (horiz)   +ax2 Y (vert)   (+xf, +yf)
c                2  +ax1 X (horiz)   -ax2 Y (vert)   (+xf, -yf)
c                3  -ax1 X (horiz)   +ax2 Y (vert)   (-xf, +yf)
c                4  -ax1 X (horiz)   -ax2 Y (vert)   (-xf, -yf)
c                5  +ax2 X (horiz)   +ax1 Y (vert)   (+yf, +xf)
c                6  +ax2 X (horiz)   -ax1 Y (vert)   (+yf, -xf)
c                7  -ax2 X (horiz)   +ax1 Y (vert)   (-yf, +xf)
c                8  -ax2 X (horiz)   -ax1 Y (vert)   (-yf, -xf)
c                    
c                    (2 was standard for Laue programs)
c
c     nxp_cmp       number of pixels compressed to 1 in horizontal
c                   display direction
c     nyp_cmp       number of pixels compressed to 1 in vertical
c                   display direction
c     nxdpx         number of horizontal pixels in displayed image
c     nydpx         number of vertical pixels in displayed image
c     img_horiz     image direction for horizontal display (=1 fast, 2 slow)
c     img_vert      image direction for vertical display   (=1 fast, 2 slow)
c     img_map(4)    mapping of image to display
c                    imgmap(1)   1st point on fast axis (Yms)
c                    imgmap(2)   1st point on slow axis (Zms)
c                    imgmap(3)   increment on fast axis
c                    imgmap(4)   increment on slow
c     img_x,img_y   x, y position of image
c     men_x, men_y  x, y position of menu
c     par_x, par_y  x, y position of parameter table
c     io_x, io_y    x, y position of IO area
c     not_x, not_y    x, y position of notice area (parameter table
c                     with no values)
c     pmn_x, pmn_y  x, y position of popup abort menu
c     ppb_x, ppb_y  x, y position of popup progress bar
c     busy_x, busy_y x, y position of busy window
c     img_width,img_height   width, height of image window
c     men_width, men_height  width, height of menu window  
c     par_width, par_height  width, height of parameter window
c     io_width, io_height    width, height of IO window
c     not_width, not_height  width, height of notice area
c     pmn_width, pmn_height  width, height of Abort menu
c     ppb_width              width of progress bar
c     busy_width, busy_height  width, height of busy box
c     sub_process    .true. if program is sub-process of eg clips, .false.
c                    if standalone
c
C     IFTYPE      1 = unsigned byte data
C                 2 = unsigned two-byte data (i2)
C                 3 = signed integer data
C                 4 = 'squashed i2' data (if Intensity>32767 
C                    store as 65536-Intensity/8)
      INTEGER BASE_WIDTH,BASE_HEIGHT,
     $     IMAGE_ORDER,JIMAGE_ORDER,NXP_CMP,NYP_CMP,
     $     NXDPX,NYDPX,
     $     IMG_HORIZ,IMG_VERT,IMG_MAP(4),
     $     IMG_X,IMG_Y,MEN_X,MEN_Y,PAR_X,PAR_Y,IO_X,IO_Y,
     $     NOT_X,NOT_Y,PMN_X, PMN_Y,PPB_X, PPB_Y, BUSY_X, BUSY_Y,
     $     BUSY_Y2,IFTYPE
      INTEGER IMG_WIDTH, IMG_HEIGHT, MEN_WIDTH, MEN_HEIGHT,
     $     PAR_WIDTH, PAR_HEIGHT, IO_WIDTH, IO_HEIGHT,
     $     NOT_WIDTH, NOT_HEIGHT, PMN_WIDTH, PMN_HEIGHT,
     $     PPB_WIDTH, BUSY_WIDTH, BUSY_HEIGHT
      LOGICAL SUB_PROCESS, BLANK
C

c  DON'T forget to declare function xdlstr as integer
      INTEGER XDLSTR
      EXTERNAL XDLSTR

c
c     ivhbas        view object handle for base frame
c     ivhimg        view object handle for image
c     ivhpar        view object handle for parameter table
c     ivhmen        view object handle for menu
c     ivhio         view object handle for io area
c     ivhio2        view object handle for second io area (pick option)
c     ivhio3        view object handle for third io area (output)
c     ivhnot        view object handle for notice area (parameter table)
c     ivhpmn        view object handle for popup wait menu
c     ivhppb        view object handle for popup progress bar
c     ivhblank      view object handle for blank object
c     ivhbusy       view object handle for busy object
c     ivhbusy2      view object handle for second (2 line) busy object
      INTEGER IVHBAS, IVHIMG, IVHPAR, IVHMEN, IVHIO, IVHNOT, IVHPMN,
     $     IVHPPB, IVHBLANK, IVHBUSY, IVHIO2, IVHBUSY2, IVHIO3
      PARAMETER (IVHBAS=1, IVHIMG=2, IVHPAR=3, IVHMEN=4, IVHIO=5,
     $     IVHNOT=6, IVHPMN=7, IVHPPB=8, IVHBLANK=9, IVHBUSY=10,
     $     IVHIO2=11, IVHBUSY2=12, IVHIO3=13)

c  Border  boundary between windows
      INTEGER BORDER
      PARAMETER (BORDER = 3)

c     icset   colour set number
      INTEGER ICSET
      PARAMETER (ICSET=1)
c
c     iord    axis order of image
c             = 1  xf slow, yf fast
      INTEGER IORD
      PARAMETER (IORD = 1)
c
c     minw,minh   minimum width and height for image display object
      INTEGER MINW,MINH
      PARAMETER (MINW=0, MINH=0)
c
c     ixopix, iyopix      pixel origin of displayed part
      INTEGER IXOPIX,IYOPIX
      PARAMETER (IXOPIX=1, IYOPIX=1)
c
c     ibg     background menu, =0 for none
      INTEGER IBG
      PARAMETER (IBG=0)
c
c     iovly   overlay option
      INTEGER IOVLY
      PARAMETER (IOVLY=1)
c
c     max_pixel   maximum number of pixels to use for image display:
c                 this will be used to control possible compression
c                 of the image
      INTEGER MAX_PIXEL
      PARAMETER (MAX_PIXEL = 600)
c  Image stuff
c     disp_img        true if image has been displayed
c
      LOGICAL DISP_IMG
c
c     ifd     file descriptor, = -1 for no file
      INTEGER IFD
      PARAMETER (IFD=0)
c

c  Parameter table stuff
c     max_par_col     maximum number of parameter columns
c     max_par_rows    maximum number of parameter rows
c     max_par_name    maximum length of name
c     max_par_str     maximum value length
c     par_title       = -1 no title +1 title present
c     par_font        font (3=medium)
c     par_menu        = 1 if popup menus allowed
c     disp_par        true if parameter table hsa been displayed
c
      LOGICAL DISP_PAR
      INTEGER MAX_PAR_COL, MAX_PAR_ROWS, MAX_PAR_NAME, MAX_PAR_STR,
     $        PAR_TITLE, PAR_FONT, PAR_MENU
      PARAMETER (MAX_PAR_COL = 1, MAX_PAR_ROWS = 50,
     $           MAX_PAR_NAME = 17, MAX_PAR_STR = 7,
     $           PAR_TITLE = 1, PAR_FONT = 2, PAR_MENU = 0)
C
c  Menu stuff
c     max_men_itms    maximum number of menu items
c     max_men_name    maximum number of characters in menu item
c     men_font        menu font number (3=medium)
c     men_quit_flag   = 1 to allow for quit box
c     max_men_title   maximum length of menu title
c     disp_menu       true if menu displayed
      LOGICAL DISP_MENU
      INTEGER MAX_MEN_ITMS, MAX_MEN_NAME, MEN_FONT, MEN_QUIT_FLAG,
     $        MAX_MEN_TITLE 
      PARAMETER (MAX_MEN_ITMS = 19, MAX_MEN_NAME = 19, MEN_FONT = 2,
     $     MEN_QUIT_FLAG = 1, MAX_MEN_TITLE = 9)

c
c IO area stuff
c     io_font         font number
c     disp_io         true if io area displayed
c     disp_io2        true if SECOND io area displayed
c     disp_io3        true if THIRD io area displayed
C     NSCROLL         number of pages to hold for scrolling
      LOGICAL DISP_IO,DISP_IO2,DISP_IO3
      INTEGER IO_FONT,NSCROLL
      PARAMETER (IO_FONT=2)
      PARAMETER (NSCROLL=0)


c  Notice area stuff (notice area is a parameter table with no values)
c     max_not_col     maximum number of parameter columns
c     max_not_rows    maximum number of parameter rows
c     max_not_name    maximum length of name
c     max_not_str     maximum value length
c     not_title       = -1 no title +1 title present
c     not_font        font (3=medium)
c     not_menu        = 1 if popup menus allowed
c     disp_not       true if menu displayed
      LOGICAL DISP_NOT
      INTEGER MAX_NOT_COL, MAX_NOT_ROWS, MAX_NOT_NAME, MAX_NOT_STR,
     $        NOT_TITLE, NOT_FONT, NOT_MENU
      PARAMETER (MAX_NOT_COL = 1, MAX_NOT_ROWS = 18,
     $           MAX_NOT_NAME = 23,
     $           MAX_NOT_STR = 0,
     $           NOT_TITLE = +1, NOT_FONT = 1, NOT_MENU = 0)
c
c  Menu stuff for Abort menu
c     max_pmn_itms    maximum number of menu items
c     max_pmn_name    maximum number of characters in menu item
c     pmn_font        menu font number (3=medium)
c     pmn_quit_flag   = 1 to allow for quit box
c     max_pmn_title   maximum length of menu title
      INTEGER MAX_PMN_ITMS, MAX_PMN_NAME, PMN_FONT, PMN_QUIT_FLAG,
     $        MAX_PMN_TITLE 
      PARAMETER (MAX_PMN_ITMS = 0, MAX_PMN_NAME = 12, PMN_FONT = 2,
     $     PMN_QUIT_FLAG = 1, MAX_PMN_TITLE = 15)

c   Stuff for progress bar
c     ppb_font   font number (3=medium)
c     ppb_colr   colour
      INTEGER PPB_FONT, PPB_COLR
      PARAMETER (PPB_FONT = 2, PPB_COLR=3)

c   Busy box
      INTEGER BUSY_FONT
      PARAMETER (BUSY_FONT = 2)
c
c len_dialog    length of dialog box
      INTEGER LEN_DIALOG
      PARAMETER (LEN_DIALOG = 60)

c
c  Overlays
c
c  Circles
c     cir_ivec    vector set number for circles
c     cir_colr    colour for circles
c     cir_iovl    overlay number for circles
c     cir_symb   symbol for centre
      INTEGER CIR_IVEC, CIR_COLR, CIR_IOVL, CIR_SYMB
      PARAMETER (CIR_IVEC=3, CIR_COLR=6, CIR_IOVL=2, CIR_SYMB=4)

C
C---- Residual vectors
C     IRV_VEC Vector set number
C     IRV_COL Colour  (1 red, 2 yellow, 3 green)
C     IRV_OVL Overlay number
      INTEGER IRV_VEC, IRV_COL, IRV_OVL
      PARAMETER (IRV_VEC=4, IRV_COL=1, IRV_OVL=2)
c  Measure
c
c     mes_colr    colour for measure crosses
      INTEGER MES_COLR
      PARAMETER (MES_COLR=1)

c   Vertical Crosses
c     cross_iovl    overlay number for circles
c     cross_symb   symbol for centre
      INTEGER CROSS_IOVL, CROSS_SYMB
      PARAMETER (CROSS_IOVL=2, CROSS_SYMB=3)
c  Boxes
c     box_iovl    overlay number for boxes
c     box_symb   symbol for centre
      INTEGER BOX_IOVL, BOX_SYMB, BOX_VEC
      PARAMETER (BOX_VEC=2,BOX_IOVL=2, BOX_SYMB=13)
c  Circles
c     CIRC_iovl    overlay number for circles
c     CIRC_symb   symbol for centre
      INTEGER CIRC_IOVL, CIRC_VEC
      PARAMETER (CIRC_VEC=5,CIRC_IOVL=2)
c   Crosses
c     cross_iovl    overlay number for circles
c     cross_symb   symbol for centre
      INTEGER XCROSS_IOVL, XCROSS_SYMB
      PARAMETER (XCROSS_IOVL=2, XCROSS_SYMB=13)
C
C---- common block last of all
C
      COMMON /MXDCMI/ BASE_WIDTH,BASE_HEIGHT,
     $     IMAGE_ORDER,JIMAGE_ORDER,NXP_CMP,NYP_CMP,
     $     NXDPX,NYDPX,
     $     IMG_HORIZ,IMG_VERT,IMG_MAP,
     $     IMG_X,IMG_Y,MEN_X,MEN_Y,PAR_X,PAR_Y,IO_X,IO_Y,
     $     NOT_X,NOT_Y,PMN_X, PMN_Y,PPB_X, PPB_Y, BUSY_X, BUSY_Y,
     $     BUSY_Y2, IFTYPE,
     $     IMG_WIDTH, IMG_HEIGHT, MEN_WIDTH, MEN_HEIGHT,
     $     PAR_WIDTH, PAR_HEIGHT, IO_WIDTH, IO_HEIGHT,
     $     NOT_WIDTH, NOT_HEIGHT, PMN_WIDTH, PMN_HEIGHT,
     $     PPB_WIDTH, BUSY_WIDTH, BUSY_HEIGHT,
     $     SUB_PROCESS,BLANK,DISP_IMG,DISP_PAR,DISP_MENU,
     $     DISP_IO,DISP_IO2,DISP_IO3,DISP_NOT
  
C&&*&& end_include  ../inc/mxdinc.f
C
C
C     .. Scalar Arguments ..
      INTEGER IXS,IYS,IXF,IYF,ISTAT
C
C     ..
C     .. Local Scalars ..
C     ..
C     .. Local Arrays ..
C     ..
C     .. External Subroutines ..
C     ..
C     .. Intrinsic Functions ..
C     ..
C     .. Common blocks ..
C     ..
C     .. Equivalences ..
      SAVE
C     ..
C     .. Data ..
C     ..
C

C
C---- Check for vector extending beyond display area
C
       IF (IXS.LT.1) THEN
         IF (IXF.GT.1) THEN
           IXS = 1
         ELSE 
           ISTAT = 1
         END IF
       END IF
       IF (IXF.GT.NXDPX) THEN
         IF (IXS.LT.NXDPX) THEN
           IXF = NXDPX
         ELSE
           ISTAT = 1
         END IF
       END IF
C
       IF (IYS.LT.1) THEN
         IF (IYF.GT.1) THEN
           IYS = 1
         ELSE 
           ISTAT = 1
         END IF
       END IF
       IF (IYF.GT.NYDPX) THEN
         IF (IYS.LT.NYDPX) THEN
           IYF = NYDPX
         ELSE
           ISTAT = 1
         END IF
       END IF
      RETURN
      END
C $Id: chkras.f,v 1.5 2004/03/08 17:39:50 harry Exp $
C
C This routine DEBUG(15), DEBUG CHKR
C== CHKRAS ==
      SUBROUTINE CHKRAS(AVPROFILE,MAXR,FIRSTFILM,FILM)
C     ================================================================
C
      IMPLICIT NONE
C
C
C     AVPROFILE    True on entry to this subroutine, but set false UNLESS
C                  a new average spot profile is to be determined because
C                  the overall dimensions of the measurement box have 
C                  changed, in which case CENTRS is called again (by MAIN)
C
C     FIRSTFILM    True if this is first image in a block. If raster parameters
C                  are to be optimised, this is done for the first image in
C                  each new block of images.
C
C     FILM         1 for A film, 2,3 for B and C films in pack
C
C---- Calculates average spot profile from
C     measurements made by centrs.
C     displays profile and measurement box on
C     tektronix and allows box parameters to
C     be changed.
C     Optimises the raster parameters (BESTMASK)
C     The summed ods are passed in array IODPROF in /PRO2/
C
C
C
C
C     Elements of PQVAL
C     p,q are pixel coords wrt centre of box
C     These sums are set up by a call to SETSUMS
C     1 = sum p*p  for peak
C     2 = sum p*p  for background
C     3 = sum q*q  for peak
C     4 = sum q*q  for background
C     5 = number of peak pixels
C     6 = number of background pixels
C
C     Elements of PQSUMS
C     p,q are pixel coords wrt centre of box, all sums are for background
C        points ONLY. Note that these sums are set up in INTEG and are
C        updated for every spot based on rejected background pixels
C        in BGTEST.
C     1 = sum p*p  
C     2 = sum q*q
C     3 = sum p*q
C     4 = sum p
C     5 = sum q
C     6 = number of background pixels
C
C
C
C                                                               
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
      INTEGER NPARM
      PARAMETER (NPARM = 200)
C     ..
C     .. Scalar Arguments ..
      INTEGER MAXR,FILM
      LOGICAL AVPROFILE,FIRSTFILM
C     ..
C     .. Local Scalars ..
      REAL BGND,DELX,DELY,ODSCALE,RMSBG,SCALE,SPOTW,TBGND,TPEAK,
     +     RATIOX,RATIOY,PREJX,PREJY,RATIO,VSPOT,VBG,AX,CTOT,
     +     BGSIGL,X
      INTEGER I,ISW2,KXSHIFT,KYSHIFT,MAXOD,MINOD,NC,NRX,NRY,NSIZ,
     +        NXS,NXY,NYS,NRFL,NREJ,IFLAG,NBGOLD,
     +       NBGOLDX,NBGOLDY,ISDBSI,NSIZE,NBGEXTRA,NINC,MODE,IHX,IHY,
     +       NRXMIN,NRYMIN,NCMIN,IMODE,NPBOX,NCPKMIN,MAXPIX,
     +       ICUTX,ICUTY,IXM,IYM,LINELEN,NUMLIN
      LOGICAL FULL,STOPX,STOPY,PASS2,TOOBIG,LDENSE
      CHARACTER JUNK*1,LINE*80,LINE2*80,STR1*1,CALLEDFROM*80
C     ..
C     .. Local Arrays ..
      REAL PQVAL(6),PQSUMS(6)
      INTEGER KRAS(5),MASK(MAXBOX),MASKREJ(NREJMAX),IRBIG(2),
     +        IODBIG(MAXBOX) 
C
C---- Things for parser
C
      INTEGER IBEG(NPARM),IDEC(NPARM),IEND(NPARM),ITYP(NPARM)
      REAL VALUE(NPARM)
      INTEGER NTOK
c
C     ..
C     .. External Subroutines ..
      EXTERNAL BELL,INTEG,NOYES,RASPLOT,SETMASK,SETSUMS,
     +         BESTMASK,EXTRACT,PKRIM
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC MAX,MIN,MOD
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/backg.f
C
C $Id: backg.f,v 1.1 2002/05/02 10:46:40 harry Exp $
C
C--- awk generated include file  backg.h
C---- START of include file backg.h
C
C
C
C     .. Scalars in common block /BACKG/ ..
      REAL BGFRAC
      INTEGER NBGMIN
C     ..
C     .. Common Block /BACKG/ ..
      COMMON /BACKG/ BGFRAC,NBGMIN
C     ..
C
C
C&&*&& end_include  ../inc/backg.f
C&&*&& include  ../inc/condata.f
C
C $Id: condata.f,v 1.14 2004/07/20 12:40:18 harry Exp $
C
C--- awk generated include file condata.h 
C---- START of include file condata.h 
C 
C
C     FIXSWAP     Forces reversal of normal byte-swapping choice.
C
C---- SUMPART True if two images are to be stored in memory at the
C               same time. This will be the case if post-refinement
C               (other than POSTHOC post-refinement for off-line
C               scanners) is being performed. Note that SUMPART is NOT
C               used to determine if partials should be added across
C               images (this is ADDPART)
C
C---- NEWPREF True if allowing partials over multiple images in post-
C             refinement.
C
C---- ADDPART True if partials are to be summed across images. This is
C               only appropriate for fixed origin (ie on-line)
C               scanners where the X-ray dose is identical for
C               each image.
C     Direct beam coordinates
C             These are read into XMM(3), YMM(3) where (3) is for A,B,C packs
C             Immediately on reading in, these values are transferred
C             into XCENMM, YCENMM, XCENMMIN(J,3) where J=1->MAXPAX.
C
C             If an IMAGE keyword has been given, XCENMM(1,1)=XMM(1) and
C             YCENMM(1)=YSCAL*YMM(1). If swung out, YCENMM(1,1) is updated.
C             If a BEAM keyword has not been given, XMM,YMM, XCENMM,YCENMM,
C             XCENMMIN are all set to the middle of the image.


C             Then, when reflecting input to logfile, it AGAIN sets up
C             XCENMM,YCENMM for all images using XMM,YMM, this time
C             using YSCAL to set up YCENMM, and updating YCENMM if the
C             detctor is swung out. (label 708), DO loop 710. If image
C             is "inverted", corrects XCENMM for all images.


C             XCEN,YCEN are set in "mosflm" to XCENF, YCENF plus
C             camera constants, and XCENF,YCENF are in turn set from
C             XCENMM,YCENMM. Thus XCENMM,YCENMM are what is actually
C             used to define the beam position.

C
C     LPREF   If TRUE, return to display after refinement over entire
C             image. Only active when integrating interactively. Set by
C             toggle button in Parameter window.
C

C     LOVERLAP  If TRUE, do not call the OVERLAP subroutine

C     ALLOUT  If TRUE, all reflections (whether measured or not, or
C             classified as BADSPOTS or not, will be written to the
C             output MTZ file.
C
C     NTDIG   Number of digits in image number, returned as zero if
C             there is an error in the template. Only used if TEMPLATE
C             keyword given.
C
C     TEMPLATE is TRUE if a TEMPLATE keyword has been given.
C
C     NOLP    If TRUE, do NOT apply the Lorentz Polarisation corrections
C
C     MULTIMTZ True if writing each "block" of images to a separate MTZ file
C
C     DISPMENU True if the run was started with a IMAGE keyword. Not to be
C              confused with WINOPEN which is true if the X-window display
C              is being used, but this is not necessarily starting with
C              a "IMAGE" keyword.
c     newgui - this means that we're talking through the new GUI.
c              except that we can't have it here because the prsummary 
c              subroutine, where we REALLY want it, clashes with this common
C
C     HACTIVEMASK,LACTIVEMASK,LACTIVE - only for Rigaku images which 
C     contain a compressed "active mask" (size=HACTIVEMASK bytes)
C     at the end of the image. Compression uses a modified run length encoding
C     at present (10.01.2003).
C
C     ..
C     .. Arrays in common /CONDATA/ ..
      REAL XCENMM,YCENMM,THFOIL,PHIBEGA,PHIENDA,RSYM,XMM,YMM,
     +     XCENMMIN,YCENMMIN
      REAL RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +     PHIRNG,YSCALIN,FULLFRAC,WTIME
C     ..
C     .. Arrays in common /CONDATA/ ..
      INTEGER IDPACK,NFPACK,NFIRST,ICASSET
      INTEGER IPACK1A,IPACK2A,ISERAR
      LOGICAL AVPROF,FILMPLOT,FORCEB,FORCEC
C
C     .. Scalars in common /CONDATA/ ..
C     ..
      INTEGER NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX
      INTEGER IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK
      LOGICAL FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF,ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW, 
     +        spostref,newgui,LACTIVEMASK,USERSPOT,HEADONLY
C     ..
C real arrays, then scalars, integer arrays, scalars, logicals
      COMMON /CONDATA/
     $       XCENMM(MAXPAX,3),
     +       YCENMM(MAXPAX,3), THFOIL(3),PHIBEGA(MAXPAX),
     $       PHIENDA(MAXPAX),RSYM(4,4,96),XMM(3),YMM(3),
     $       XCENMMIN(MAXPAX),YCENMMIN(MAXPAX),
     $       RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +       PHIRNG,YSCALIN,FULLFRAC,WTIME,
     $        IDPACK(MAXPAX),NFPACK(MAXPAX),NFIRST(MAXPAX),
     +        ICASSET(MAXPAX),IPACK1A(50),
     +        IPACK2A(50),ISERAR(50),
     $        AVPROF(MAXPAX),FILMPLOT(MAXPAX),FORCEB(MAXPAX),
     +        FORCEC(MAXPAX),
     $        NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX,
     $        IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK,
     $        FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF, spostref, ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW,
     $        newgui,LACTIVEMASK,USERSPOT,HEADONLY


C&&*&& end_include  ../inc/condata.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/dsplyc.f
C
C $Id: dsplyc.f,v 1.1 2002/05/02 10:46:46 harry Exp $
C
C--- awk generated include file  dsplyc.h
C---- START of include file dsplyc.h
C
C*******************************************************************
C
C  COMMON  /DSPLYC/
C
C	IMGLOW, IMGHI	low & high values of 16-bit image for scaling
C			integer*2 to byte: IMGLOW maps to  0; 
C			IMGHI to maximum. Note that these are not
C			necessarily the actual limits of the data
C	JDSPWD		.LT. 0  before image window has been created
C                       = +-1 for image display that can be panned
C                       = +-2 for non-interactive image display
C       MAXDEN          highest level in colour table to fill up to
C                       must be less than ~240 - number of overlay colours
C       LDSPSG          if .true., treat image as signed, ie after dark
C                          subtraction
C                       if .false., treat image as unsigned
C       NZOOM           zoom factor for image, = 0 if no zoom
C       JYZOOM, JZZOOM  1st pixel in zoomed image
C
C----   WINOPEN Flag for whether or not window is open. Do not
C               confuse with DISPMENU (/CONDATA/)which is true if the run was
C               started with a IMAGE keyword.
C
C
C       CDSPTL          banner title
C
      INTEGER IMGLOW, IMGHI, JDSPWD, MAXDEN,
     $     NZOOM, JYZOOM, JZZOOM
      LOGICAL LDSPSG,WINOPEN,LPAUSE,LHELP
      COMMON /DSPLYC/ IMGLOW, IMGHI, JDSPWD,
     *     MAXDEN, NZOOM, JYZOOM, JZZOOM, LDSPSG,WINOPEN,LPAUSE,LHELP
C
      CHARACTER  CDSPTL*200
      COMMON /DSPLCC/  CDSPTL
C                                                           
C
C*******************************************************************


C&&*&& end_include  ../inc/dsplyc.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/myprof.f
C
C $Id: myprof.f,v 1.1 2002/05/02 10:47:01 harry Exp $
C
C--- awk generated include file  myprof.h
C---- START of include file myprof.h
C
C
C     .. Arrays in Common Block /MYPROF/ ..
      REAL PRSCALE,XPMAX,YPMAX,XLINE,YLINE,WPROFL,WPRSUMS
      INTEGER ISIZE,NRFBOX,IPROFL,IBOX,IXBOX,IYBOX,NPFIRST
      LOGICAL BOX
C     ..
C     .. Scalars in Common Block /MYPROF/
      REAL TOL,BGPKRAT,FRACREJ,BADTOL,TOLMIN,RECLEVEL
      INTEGER NXLINE,NYLINE,NUMBOX,IBOUND,ITRIM,NOVERLAP
      LOGICAL HIGHRES,LOWRES,PRSET,OFFDET,PROPT,FIXBOX,LINESET,
     +        PROPTCEN,RECOVER,NOFIXBOX
C     ..
C     .. Common Block /MYPROF/ ..
      COMMON /MYPROF/PRSCALE(NMASKS,2),XPMAX(NMASKS),YPMAX(NMASKS),
     $       XLINE(NNLINE),YLINE(NNLINE),
     +       WPROFL(MAXBOX,NMASKS),WPRSUMS(MAXBOX,NMASKS),TOL,
     +       BGPKRAT,FRACREJ,BADTOL,TOLMIN,RECLEVEL,
     $       ISIZE(NMASKS,2),NRFBOX(NMASKS),
     +       IPROFL(MAXBOX,NMASKS+1),IBOX(0:NNLINE,0:NNLINE),
     +       IXBOX(NMASKS,2),IYBOX(NMASKS,2),
     +       NPFIRST(NNLINE-1),NXLINE,NYLINE,NUMBOX,IBOUND,ITRIM,
     $       NOVERLAP,BOX(NMASKS),HIGHRES,LOWRES,PRSET,OFFDET,
     +       PROPT,FIXBOX,LINESET,PROPTCEN,RECOVER,NOFIXBOX
C     ..
C
C
C&&*&& end_include  ../inc/myprof.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
C&&*&& include  ../inc/over.f
C
C $Id: over.f,v 1.1 2002/05/02 10:47:03 harry Exp $
C
C--- awk generated include file  over.h
C---- START of include file over.h
C
C
C     .. Scalars in Common Block /OVER/ ..
C
C     ..
C     .. Scalars in common /OVER/ ..
      INTEGER MINDTX,MINDTY,NPOVL,IXSEP,IYSEP
C     ..
C     .. ARRAYS in common /OVER/ ..
      INTEGER HKLPOVL
C     ..
C     .. Common Block /OVER/ ..
      COMMON /OVER/MINDTX,MINDTY,NPOVL,IXSEP,IYSEP,HKLPOVL(NREFLS/2)
C     ..
C
C
C&&*&& end_include  ../inc/over.f
C&&*&& include  ../inc/parm1.f
C
C $Id: parm1.f,v 1.1 2002/05/02 10:47:05 harry Exp $
C
C--- awk generated include file  parm1.h
C---- START of include file parm1.h
C
C
C
C     .. Scalars in common block /PARM1/ ..
      REAL BGSIG,EFAC,EFACSQ,BGFREJ,GRADMAX,GRADMAXR,BGRAT,PKRAT,
     +     RESD,RESDLOW
      INTEGER CUTOFF,NOVPIX,NDSTART,NDTOT,IXDMIN,IXDMAX,IYDMIN,IYDMAX,
     +     IDMIN,IDMAX
      LOGICAL DUMPSPOT,BADPLOT,DUMPALL,BADPLOT2
C     ..
C     .. Common Block /PARM1/ ..
      COMMON /PARM1/BGSIG,EFAC,EFACSQ,BGFREJ,GRADMAX,GRADMAXR,
     +              BGRAT,PKRAT,RESD,RESDLOW,CUTOFF,NOVPIX,
     +              NDSTART,NDTOT,IXDMIN,IXDMAX,IYDMIN,IYDMAX,
     +              IDMIN,IDMAX,DUMPSPOT,BADPLOT,DUMPALL,BADPLOT2
C     ..
C
C
C&&*&& end_include  ../inc/parm1.f
C&&*&& include  ../inc/pro.f
C
C $Id: pro.f,v 1.1 2002/05/02 10:47:09 harry Exp $
C
C--- awk generated include file  pro.h
C---- START of include file pro.h
C
C
C     .. Arrays in common block /PRO/ ..
      INTEGER*2 IDUM
C     ..
C     .. Common Block /PRO/ ..
      COMMON /PRO/IDUM(MAXBUFF)
C     ..
C
C
C&&*&& end_include  ../inc/pro.f
C&&*&& include  ../inc/pro2.f
C--- awk generated include file  pro2.h
C---- START of include file pro2.h
C
C     .. Scalars in Common /PRO2/ ..
      REAL PRCENSUM
C
C     .. Arrays in Common Block /PRO2/ ..
      INTEGER IODPROF
C     ..
C     .. Common Block /PRO2/ ..
      COMMON /PRO2/PRCENSUM,IODPROF(MAXBOX)
C     ..
C
C
C&&*&& end_include  ../inc/pro2.f
C&&*&& include  ../inc/ras.f
C
C $Id: ras.f,v 1.1 2002/05/02 10:47:10 harry Exp $
C
C--- awk generated include file  ras.h
C---- START of include file ras.h
C
C
C     .. Scalars in common block /RAS/ ..
      INTEGER NEWRAS,MINT
C     ..
C     .. Arrays in common block /RAS/ ..
      INTEGER IRAS
      REAL VARAS
C     ..
C     .. Common Block /RAS/ ..
      COMMON /RAS/VARAS(5),IRAS(5),NEWRAS,MINT
C     ..
C
C
C&&*&& end_include  ../inc/ras.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C&&*&& include  ../inc/sums.f
C
C $Id: sums.f,v 1.1 2002/05/02 10:47:21 harry Exp $
C
C--- awk generated include file  sums.h
C---- START of include file sums.h
C
C
C     Elements of ASPOT
C     1 = Summation integration intensity
C     2 = Total background counts under peak assuming peak has mm symmetry
C     3 = Rms variation in background, after rejecting background points.
C         This is evaluated in BGSOLVE called from EVAL.
C     4 = Centre of gravity in X direction (in pixels)
C     5 = Centre of gravity in Y direction (in pixels)
C         These are wrt an origin at the centre of the measurement box
C     6 = sum p*iod for background pixels
C     7 = sum q*iod for background pixels
C     8 = sum iod for background pixels
C     9 = Background plane constant a (gradient in X direction)
C    10 = Background plane constant b (gradient in Y direction)
C    11 = Background plane constant c 
C    12 = Largest deviation from background plane, excluding rejected pixels
C    13 = Profile fitted intensity
C    14 = Variance of profile fitted intensity = sum (deltasq) for peak
C         pixels only. Used to calculate PKRATIO and also profile fitted
C         sigma(I) in unweighted case only.
C    15 = Number of rejected background pixels
C    16 = Variance of profile fitted intensity in weighted case (default)
C    17 = sum W*DELTA**2 for profile fit
C    18   unused
C     .. Arrays in common block /SUMS/ ..
      REAL ASPOT
C     ..
C     .. Common Block /SUMS/ ..
      COMMON /SUMS/ASPOT(18)
C     ..
C
C
C&&*&& end_include  ../inc/sums.f
C     ..
C     .. Equivalences ..
      EQUIVALENCE (IRAS(1),NXS), (IRAS(2),NYS), (IRAS(3),NC)
      EQUIVALENCE (IRAS(4),NRX), (IRAS(5),NRY)
      EQUIVALENCE (ASPOT(1),SPOTW), (ASPOT(2),BGND),
     +            (ASPOT(3),RMSBG)
      EQUIVALENCE (ASPOT(4),DELX), (ASPOT(5),DELY)
C     ..
      SAVE                        
      DATA PASS2/.FALSE./,TOOBIG/.FALSE./
C
      CALLEDFROM = 'CHKRAS'
      NRFL = 1                      
      CTOT = 0.0
      NPBOX = 1
      LDENSE = .FALSE.
C
      IF (DEBUG(15).AND.SPOT) THEN
        WRITE(IOUT,FMT=6032) NXS,NYS
        IF (ONLINE) WRITE(ITOUT,FMT=6032) NXS,NYS
        MAXPIX = 0
        CALL ODPLOT4(IODPROF(1),NXS,NYS,1,MAXPIX)
6032    FORMAT(/1X,'In CHKRAS, summed counts for average spot profile',
     +         ' box size',2I3,/)
      END IF
C
C
C---- PASS2 is TRUE if the best rim and corner parameters have already
C     been determined, but the overall box was too small to get a satisfactory
C     ratio of background to peak pixels. Under these circumstances CENTRS is
C     called again with a large box, and this box is used to determine the
C     best box size.
C
      IF (PASS2) GOTO 20
C
C
      NXY = NXS*NYS
      IF (NXY.LE.MAXBOX) GO TO 10
      NWRN = NWRN + 1
      IF (ONLINE) WRITE (ITOUT,FMT=6000) MAXBOX
      WRITE (IOUT,FMT=6000) MAXBOX
      GO TO 50
   10 CONTINUE
      NSIZ = (NXY+1)/2
C
C---- Find max od, scale raster sum
C                                                           
      MAXOD = 0
      MINOD = 100000000
C
C
      DO 12 I = 1,NXY
        MAXOD = MAX(MAXOD,IODPROF(I))
        MINOD = MIN(MINOD,IODPROF(I))
   12 CONTINUE
C
C
      SCALE = 255.0/ (MAXOD-MINOD)
C
C
      IF (DEBUG(15)) THEN
        IF (ONLINE) WRITE (ITOUT,6030) MINOD, MAXOD, SCALE
        WRITE (IOUT,6030) MINOD,MAXOD,SCALE
6030    FORMAT(/1X,' In CHKRAS, MINOD = ',I10,' MAXOD = ',I20,
     +         ' SCALE = ',F12.6)
      END IF
C                                         
C
C---- Find average spot shape and plot
C
      IF (BRIEF) WRITE (IBRIEF,FMT=6002)
      IF (ONLINE) WRITE (ITOUT,FMT=6002)
      WRITE (IOUT,FMT=6002)
C
C          ************************
      CALL SETMASK(MASK,IRAS)
      CALL SETSUMS(MASK,IRAS,PQVAL)
C          ************************
C
      TPEAK = PQVAL(5)
      TBGND = PQVAL(6)
      FULL = .TRUE.
      BGSIGL = BGSIG
C
C                  **********************************************
 13   CALL INTEG(IODPROF,IRAS,MASK,PQVAL,1,FULL,
     +                   BGSIGL,MASKREJ,PQSUMS,NRFL)
C                  **********************************************
C                       
C---- Test that it has not rejected an unacceptable number of
C     background points, there must be NBGMIN points left (set by
C     subkeyword MINB under keyword REJECTION. If too many rejected
C     reflection is flagged with ASPOT(1)=-9999
C
        IF (ASPOT(1).EQ.-9999.0) THEN
          X = 2*BGSIGL
          IF (BRIEF) WRITE(IBRIEF,6020) BGSIGL,NBGMIN,X
          WRITE(IOUT,6020) BGSIG,NBGMIN,X
          IF (ONLINE) WRITE(ITOUT,6020) BGSIGL,NBGMIN,X
 6020     FORMAT(//1X,'With the current BGSIG factor of',F6.2,
     +     ' there are fewer than ',I3,' background',/,1X,
     +     'pixels remaining ',
     +     'for this profile after rejecting outliers.',/,1X,
     +     'Increasing BGSIG to ',F6.2,' to allow determination ',
     +     'of average spot profile',/,1X,'and optimisation of',
     +     ' measurement box',/,1X,'BGSIG will be reset to its ',
     +     'original value for integration.')
           BGSIGL = X
           IF (BGSIGL.GT.100) THEN
             WRITE(IOUT,6021) BGSIGL
             IF (ONLINE) WRITE(ITOUT,6021) BGSIGL
             NSHUTERR = 1
             CALL SHUTDOWN(CALLEDFROM)
           END IF
           GOTO 13
        END IF
C
C---- Get integrated intensity, sigma and I/sigma
C     Need TBGND and TPEAK
        NREJ = ASPOT(15)
C
C---- Must update number of background points to allow for rejected 
C     pixels. 
C
       TBGND = TBGND - NREJ
C                       
C---- Calculate standard deviation of intensity
C
        VSPOT = GAIN*SPOTW
        VBG = TPEAK*RMSBG*RMSBG
C                        
C
C---- This sigma does not include instrument error correction
C     (added later) unless the scanner error factor has been set explicitly
C
C *** Change this to counting statistics based value
C        ISDBSI = SQRT(2*VBG+ABS(VSPOT))*SCAI + 0.5
      AX = GAIN*(SPOTW+BGND+BGND*TPEAK/TBGND)
      ISDBSI=SQRT(AX) + 0.5
      IF (.NOT.PROPTCEN) THEN
        WRITE(IOUT,FMT=6100) TBGND,TPEAK,NREJ,SPOTW,BGND,ISDBSI,
     +                     SPOTW/FLOAT(ISDBSI)
        IF (ONLINE) WRITE(ITOUT,FMT=6100) TBGND,TPEAK,NREJ,SPOTW,BGND,
     +                     ISDBSI,SPOTW/FLOAT(ISDBSI)
      END IF
 6100 FORMAT(1X,'No backgnd points',F5.0,' Number peak pixels',F5.0,
     +      /,1X,'Number background rejected',I4,/,1X,'Intensity',
     +      f10.0,' BACKGROUND',F12.0,' sigma',I6,'  I/sig',F6.0)
C
      IF (PROPTCEN.AND.FIRSTFILM.AND.(FILM.EQ.1)) THEN
C
C---- First optimise the rim and corner parameters using the supplied
C     overall measurement box size. IRAS is updated by this call.
C     IFLAG is returned negative if BESTMASK fails, but this is not yet
C     coded.
C
C---- Set MASKREJ(1) to zero as this is now used by BESTMASK when setting
C     up the masks
C
        MASKREJ(1) = 0
        MODE = 0
C
C---- First see if neighbouring spots intrude
C
        IHX = NXS/2
        IHY = NYS/2
        IMODE = 0
        CALL PKRIM(IODPROF,CTOT,IHX,IHY,IMODE,NRXMIN,NRYMIN,NCMIN)
C
C---- Now test that the values of NRXMIN, NRYMIN, NCMIN are sensible...
C     if ther is a very large error in the orientation, so the peak is
C     not in the centre of the box for the average spot profile,
C     the number returned can be meaningless. Ensure the resulting peak
C     is at least 5 pixels across.
C
        IF (NRXMIN.GT.IHX-2) NRXMIN = IHX - 2
        IF (NRYMIN.GT.IHY-2) NRYMIN = IHY - 2
        AX = NXS**2 + NYS**2
        NCPKMIN = NINT(0.5*SQRT(AX) - 3)
        IF (NCMIN.GT.NCPKMIN) NCMIN = NCPKMIN
        CALL BESTMASK(IODPROF,IRAS,NPBOX,MODE,PQSUMS,MASKREJ,BGSIGL,
     +                IFLAG,CTOT,NRXMIN,NRYMIN,NCMIN,TOLMIN)
C
C---- Now optimise the overall size to get the desired ratio of background
C     pixels to peak pixels (default 2)
        IF (.NOT.FIXBOX) THEN    
C
C---- First get number of peak/background for current box
C
C         *****************************************
          CALL SETMASK(MASK,IRAS)
          CALL SETSUMS(MASK,IRAS,PQVAL)
 15       CALL INTEG(IODPROF,IRAS,MASK,PQVAL,1,FULL,
     +                   BGSIGL,MASKREJ,PQSUMS,NRFL)
C         ******************************************
C                       
C---- Test that it has not rejected an unacceptable number of
C     background points, there must be NBGMIN points left (set by
C     subkeyword MINB under keyword REJECTION. If too many rejected
C     reflection is flagged with ASPOT(1)=-9999
C
          IF (ASPOT(1).EQ.-9999.0) THEN
            X = 2*BGSIGL
            IF (BRIEF) WRITE(IBRIEF,6020) BGSIG,NBGMIN,X
            WRITE(IOUT,6020) BGSIG,NBGMIN,X
            IF (ONLINE) WRITE(ITOUT,6020) BGSIG,NBGMIN,X
           BGSIGL = X
           IF (BGSIGL.GT.100) THEN
             WRITE(IOUT,6021) BGSIGL
             IF (ONLINE) WRITE(ITOUT,6021) BGSIGL
 6021        FORMAT(/,/,1X,'***** FATAL ERROR *****',/,1X,
     +       'Value of ',F8.1,' for BGSIG is unreasonbable.')
             NSHUTERR = 2
             CALL SHUTDOWN(CALLEDFROM)
           END IF
           GOTO 15
          END IF
          NBGOLD = NINT(PQSUMS(6))
          RATIO = PQSUMS(6)/PQVAL(5)
          IF (DEBUG(15)) THEN
            NREJ = ASPOT(15) 
            WRITE(IOUT,FMT=6024) RATIO,BGPKRAT,PQSUMS(6),PQVAL(5),NREJ
            IF (ONLINE) WRITE(ITOUT,FMT=6024) RATIO,BGPKRAT,PQSUMS(6),
     +                                        PQVAL(5),NREJ
 6024       FORMAT(1X,'Background/peak ratio actual, min',2F7.2,1X,
     +               ' numbers',2F5.0,' NREJ',I5)
          END IF
          IF (RATIO.LT.BGPKRAT) THEN
C
C---- Need to determine how big a box will be needed to get desired ratio
C
            NSIZE = MIN(NXS,NYS)
            NBGEXTRA = BGPKRAT*PQVAL(5) - PQSUMS(6)
            NINC = NBGEXTRA/(NSIZE*2)
C
C---- Actually expand the box to get at least 1.5 times as many extra
C     background pixels as are required (to allow for rejection)
C     Change this, merely add 1
C            NINC = NINT(1.5*NINC) + 1
            NINC = NINC + 1
            IRAS(1) = IRAS(1) + 2*NINC
            IRAS(2) = IRAS(2) + 2*NINC
 14         NXY = IRAS(1)*IRAS(2)
            IF (NXY.GT.MAXBOX) THEN
              TOOBIG = .TRUE.
              IRAS(1) = IRAS(1) - 2
              IRAS(2) = IRAS(2) - 2
              NINC = NINC - 1
              GOTO 14
            END IF
C
C---- Now check that box size does not exceed MAXDIM. If it does, try
C     to increase the box size in the other direction, but check total size
C     does not exceed MAXBOX
C
            ICUTX = 0
            ICUTY = 0
 16         IF (IRAS(1).GT.MAXDIM) THEN
              IRAS(1) = IRAS(1) - 2
              IF (IRAS(2).LT.MAXDIM) THEN
                IRAS(2) = IRAS(2) + 2
                ICUTY = ICUTY - 1
                NXY = IRAS(1)*IRAS(2)
                IF (NXY.GT.MAXBOX) THEN
                  IRAS(2) = IRAS(2) - 2
                  ICUTY = ICUTY + 1
                END IF
              END IF
              ICUTX = ICUTX + 1
              GOTO 16
            END IF
 17         IF (IRAS(2).GT.MAXDIM) THEN
              IRAS(2) = IRAS(2) - 2
              IF (IRAS(1).LT.MAXDIM) THEN
                IRAS(1) = IRAS(1) + 2
                ICUTX = ICUTX - 1
                NXY = IRAS(1)*IRAS(2)
                IF (NXY.GT.MAXBOX) THEN
                  IRAS(1) = IRAS(1) - 2
                  ICUTX = ICUTX + 1
                END IF
              END IF
              ICUTY = ICUTY + 1
              GOTO 17
            END IF
C
C---- Increase corner cutoff and rims so peak size remains the same
C
            IF ((ICUTX.EQ.0).AND.(ICUTY.EQ.0)) THEN
              DO 18 I = 3,5
                IRAS(I) = IRAS(I) + NINC
 18           CONTINUE
            ELSE
              IRAS(3) = IRAS(3) + NINC - ICUTX
              IRAS(4) = IRAS(4) + NINC - ICUTX
              IRAS(5) = IRAS(5) + NINC - ICUTY
            END IF
C
            PASS2 = .TRUE.
            IF (DEBUG(15)) THEN
              WRITE(IOUT,FMT=6025) NBGEXTRA,2*NINC,IRAS
              IF (ONLINE) WRITE(ITOUT,FMT=6025) NBGEXTRA,2*NINC,IRAS
 6025         FORMAT(1X,I5,' Extra background points required, box',
     +               ' expanded by',I3,' pixels in X and Y',/,1X,
     +               'New raster parameters',5I5)
            END IF
C
C---- Give warning if desired background:peak ratio could not be achieved
C     because of limitations on the total box size.
C
            IF (TOOBIG) THEN
              WRITE(IOUT,FMT=6050) BGPKRAT,MAXBOX
              IF (ONLINE) WRITE(ITOUT,FMT=6050) BGPKRAT,MAXBOX
 6050   FORMAT(/,1X,' *** WARNING ***',/,1X,'Cannot achieve a ',
     +        'ratio of ',F4.0,' in the number of background',
     +        ' to peak',/,1X,'pixels because',
     +        ' the maximum boxsize (',I5,') is too small.',/,1X,
     +        'If you need this ratio, recompile the program after',
     +        ' increasing PARAMETER MAXBOX',/,1X,'with a global edit')
              TOOBIG = .FALSE.
            END IF
            RETURN
          END IF 
        END IF
      END IF
C
C---- Now go to display profile
C
      GOTO 46
C
C---- Only come this route if the average spot profile has been recollected
C     using an enlarged box (PASS2 true). Now find the best box size to
C     give desired background to peak ratio.
C
 20   PASS2 = .FALSE.
      IRBIG(1) = NXS
      IRBIG(2) = NYS
      NXY = NXS*NYS
C
C---- Reset IRAS to original values
C
      NXS = NXS - 2*NINC
      NYS = NYS - 2*NINC
      DO 22 I = 3,5
        IRAS(I) = IRAS(I) - NINC
 22   CONTINUE
C
C---- Transfer the enlarged box pixel values to IODBIG
C
      DO 34 I = 1,NXY
        IODBIG(I) = IODPROF(I)
 34   CONTINUE
C
C---- Find which direction (X or Y) gives greatest number of additional
C     background points (after allowing for rejections).
C     First try X, reset NXX, X rim, corner cutoff
 36   IRAS(1) = IRAS(1) + 2
      IRAS(3) = IRAS(3) + 1
      IRAS(4) = IRAS(4) + 1
C
C---- Must stop X expanding beyond maximum value
C
      IF (IRAS(1).GT.IRBIG(1)) THEN
        STOPX = .TRUE.
        GOTO 37
      END IF
C     *****************************************
      CALL SETMASK(MASK,IRAS)
      CALL SETSUMS(MASK,IRAS,PQVAL)
      CALL EXTRACT(IODBIG,IRBIG,IRAS,IODPROF)
      CALL INTEG(IODPROF,IRAS,MASK,PQVAL,1,FULL,
     +               BGSIG,MASKREJ,PQSUMS,NRFL)
C     ******************************************
C                       
C---- Test that it has not rejected an unacceptable number of
C     background points, there must be NBGMIN points left (set by
C     subkeyword MINB under keyword REJECTION. If too many rejected
C     reflection is flagged with ASPOT(1)=-9999
C
       IF (ASPOT(1).EQ.-9999.0) THEN
         STOPX = .TRUE.
         PREJX = 0.0
         GOTO 37
       END IF
C
C---- See what percentage of new background pixels were accepted
C
      NBGOLDX = NINT(PQSUMS(6))
      PREJX = (PQSUMS(6) - NBGOLD)/(2.0*NYS)
      RATIOX = PQSUMS(6)/PQVAL(5)
      STOPX = (PREJX.LT.FRACREJ)
C
      IF (DEBUG(15)) THEN
        NREJ = ASPOT(15)
        WRITE(IOUT,FMT=6022) IRAS,PREJX,RATIOX,NBGOLD,NREJ,STOPX
        IF (ONLINE) WRITE(ITOUT,FMT=6022) IRAS,PREJX,RATIOX,
     +                                    NBGOLD,NREJ,STOPX
 6022 FORMAT(1X,'Changing X, raster',5I4,' acceptance ratio, bk/pk',
     +       2F6.2,'  NBGOLD',I5,' NREJ',I5,' STOPX:',L2)
      END IF
C
C---- Now try Y, first reset NXX and X rim
C
 37   IRAS(1) = IRAS(1) - 2
      IRAS(4) = IRAS(4) - 1
C
C---- Increment NYY and Y rim
C
 38   IRAS(2) = IRAS(2) + 2
      IRAS(5) = IRAS(5) + 1
C
C---- Must stop Y expanding beyond maximum value
C
      IF (IRAS(2).GT.IRBIG(2)) THEN
        IF (.NOT.STOPX) THEN
          IRAS(2) = IRAS(2) - 2
          IRAS(5) = IRAS(5) - 1
        END IF
        STOPY = .TRUE.
        GOTO 39
      END IF
C     *****************************************
      CALL SETMASK(MASK,IRAS)
      CALL SETSUMS(MASK,IRAS,PQVAL)
      CALL EXTRACT(IODBIG,IRBIG,IRAS,IODPROF)
      CALL INTEG(IODPROF,IRAS,MASK,PQVAL,1,FULL,
     +         BGSIG,MASKREJ,PQSUMS,NRFL)
C     ******************************************
C                       
C---- Test that it has not rejected an unacceptable number of
C     background points, there must be NBGMIN points left (set by
C     subkeyword MINB under keyword REJECTION. If too many rejected
C     reflection is flagged with ASPOT(1)=-9999
C
       IF (ASPOT(1).EQ.-9999.0) THEN
         STOPY = .TRUE.
         PREJY = 0.0
         GOTO 39
       END IF
C
C---- See what percentage of new background pixels were accepted
C
      NBGOLDY = NINT(PQSUMS(6))
      PREJY = (PQSUMS(6) - NBGOLD)/(2.0*NXS)
      RATIOY = PQSUMS(6)/PQVAL(5)
      STOPY = (PREJY.LT.FRACREJ)
      IF (DEBUG(15)) THEN
        NREJ = ASPOT(15)
        WRITE(IOUT,FMT=6026) IRAS,PREJY,RATIOY,NBGOLD,NREJ,STOPY
        IF (ONLINE) WRITE(ITOUT,FMT=6026) IRAS,PREJY,RATIOY,
     +                                    NBGOLD,NREJ,STOPY
 6026 FORMAT(1X,'Changing Y, raster',5I4,' acceptance ratio, bk/pk',
     +       2F6.2,'  NBGOLD',I5,' NREJ',I5,' STOPY:',L2)
      END IF
C
C---- Give up if both fail FRACREJ limit. Need to reset Y parameters
C     and NC
C
 39   IF (STOPX.AND.STOPY) THEN
C
C---- Rather than giving up, want to decrease FRACREJ and try again
C     but don't reduce it beyond 0.1
C
        IRAS(2) = IRAS(2) -2
        IRAS(3) = IRAS(3) -1
        IRAS(5) = IRAS(5) -1
        IF (FRACREJ.GT.0.1) THEN
          FRACREJ = MAX(FRACREJ-0.1,0.100)
          IF (DEBUG(15)) THEN
            WRITE(IOUT,FMT=6027) FRACREJ,IRAS
            IF (ONLINE) WRITE(ITOUT,FMT=6027) FRACREJ,IRAS
 6027       FORMAT(1X,'Decrease FRACREJ to',F4.2,' IRAS',5I5)
          END IF
          GOTO 36
        ELSE
          GOTO 42
        END IF
      END IF
C                       
C---- IS X or Y better ?
C
      IF (PREJX.GT.PREJY.AND.(.NOT.STOPX)) THEN
C
C--- X is better, set raster parameters to those used for expansion in X
C
        IRAS(1) = IRAS(1) + 2
        IRAS(2) = IRAS(2) - 2
        IRAS(4) = IRAS(4) + 1
        IRAS(5) = IRAS(5) - 1
        NBGOLD = NBGOLDX
C
C---- Jump out if ratio now OK
C
        IF (RATIOX.GT.BGPKRAT) GOTO 42
        GOTO 36
      ELSE
C
C---- Y is best, jump out if ratio now OK, or too many points have
C     been rejected in Y
C
        IF ((RATIOY.GT.BGPKRAT).OR.(STOPY)) GOTO 42
        NBGOLD = NBGOLDY
C
C---- Go back and try X again, unless too many points rejected in X
        IF (.NOT.STOPX) THEN
          GOTO 36
        ELSE
          GOTO 38
        END IF
      END IF
C
C---- Call INTEG again so that the rejected background pixels in MASKREJ
C     are those for selected raster parameters
C
C     *****************************************
 42   CALL SETMASK(MASK,IRAS)
      CALL SETSUMS(MASK,IRAS,PQVAL)
      CALL EXTRACT(IODBIG,IRBIG,IRAS,IODPROF)
      CALL INTEG(IODPROF,IRAS,MASK,PQVAL,1,FULL,
     +         BGSIG,MASKREJ,PQSUMS,NRFL)
C     ******************************************
C
      IF (DEBUG(15)) THEN
        WRITE(IOUT,FMT=6040) IRAS,PQSUMS(6),MASKREJ(1)
        IF (ONLINE) WRITE(ITOUT,FMT=6040) IRAS,PQSUMS(6),MASKREJ(1)
 6040   FORMAT(1X,'Final raster parameters',5I4,/1X,'Number of ',
     +        'background points used',F5.0,' Number rejected',I4)
        IF (SPOT) THEN
          WRITE(IOUT,FMT=6042) NXS,NYS
          IF (ONLINE) WRITE(ITOUT,FMT=6042) NXS,NYS
          MAXPIX = 0
          CALL ODPLOT4(IODPROF(1),NXS,NYS,1,MAXPIX)
 6042   FORMAT(/1X,'In CHKRAS, summed counts for average spot profile',
     +         ' box size',2I3,/)
        END IF
      END IF
C                       
C---- Test that it has not rejected an unacceptable number of
C     background points, there must be NBGMIN points left (set by
C     subkeyword MINB under keyword REJECTION. If too many rejected
C     reflection is flagged with ASPOT(1)=-9999
C
        IF (ASPOT(1).EQ.-9999.0) THEN
          IF (BRIEF) WRITE(IBRIEF,6020) BGSIG,NBGMIN
          WRITE(IOUT,6020) BGSIG,NBGMIN
          IF (ONLINE) WRITE(ITOUT,6020) BGSIG,NBGMIN
          NSHUTERR = 3
          CALL SHUTDOWN(CALLEDFROM)
        END IF
C
C---- Need to rescale with new box. Find max od, scale raster sum
C                                                           
      MAXOD = 0
      MINOD = 100000000
C
C
      DO 44 I = 1,NXY
        MAXOD = MAX(MAXOD,IODPROF(I))
        MINOD = MIN(MINOD,IODPROF(I))
   44 CONTINUE
C
C
      SCALE = 255.0/ (MAXOD-MINOD)
C

C
C---- Now display the final profile with the best mask parameters and box size
C
 46   CONTINUE
C          ************************
      CALL SETMASK(MASK,IRAS)
      CALL SETSUMS(MASK,IRAS,PQVAL)
C          ************************
C
      DO 48 I = 1,NXY
        IODPROF(I) = (IODPROF(I)-MINOD)*SCALE + 0.5
   48 CONTINUE
      DELX = (DELX+IXSHIFT)/FACT
      DELY = (DELY+IYSHIFT)/FACT
      IF (PROPTCEN.AND.FIRSTFILM.AND.(FILM.EQ.1)) THEN
        WRITE (IOUT,FMT=6003) IRAS,NINT(PQVAL(5)),NINT(PQSUMS(6))
        IF (ONLINE) WRITE (ITOUT,FMT=6003) IRAS,NINT(PQVAL(5)),
     +                                     NINT(PQSUMS(6))
        IF (BRIEF) WRITE (IBRIEF,FMT=6003) IRAS,NINT(PQVAL(5)),
     +                                     NINT(PQSUMS(6))
C
C---- Calculate spot size in X and Y in mm
C
        XWARN(1,1) = RAST*(IRAS(1)-2*IRAS(4))
        XWARN(2,1) = RAST*(IRAS(2)-2*IRAS(5))
C
C---- If a SEPARATION keyword was not given and the separation was
C     therefore worked out from the median spot size, update the 
C     separation parameters using this spot size. In this case,
C     do NOT add on the saftey factor of 2 pixels
C
        IF (ISEP.NE.2) THEN
          IXSEP = 100.0*XWARN(1,1)
          IYSEP = 100.0*XWARN(2,1)
          MINDTX = NINT(ABS(IXSEP*COSOM0 + IYSEP*SINOM0))
          MINDTY = NINT(ABS(IYSEP*COSOM0 + IXSEP*SINOM0))
          WRITE(IOUT,FMT=6007) 0.01*IXSEP,0.01*IYSEP
          IF (ONLINE) WRITE(ITOUT,FMT=6007) 0.01*IXSEP,0.01*IYSEP
        END IF
      END IF
      WRITE (IOUT,FMT=6004) 0.01*DELX,0.01*DELY,RMSBG*SCALE
      IF (ONLINE)WRITE (ITOUT,FMT=6004) 0.01*DELX,0.01*DELY,RMSBG*SCALE
      IF (BRIEF)WRITE (IBRIEF,FMT=6004) 0.01*DELX,0.01*DELY,RMSBG*SCALE
      ODSCALE = 1.0
C                                       
C          ***************************************
      CALL RASPLOT(IODPROF,NXS,NYS,MASK,MASKREJ,1,ODSCALE)
C          ***************************************
C
      IF (PROPTCEN.AND.FIRSTFILM.AND.(FILM.EQ.1)) THEN
        WRITE(IOUT,FMT=6005)
        IF (ONLINE) WRITE(ITOUT,FMT=6005)
 6005 FORMAT(/,1X,'If the peak region is too large, supply two',
     +       ' values on the PROFILE TOLERANCE keyword.',/,1X,'The ',
     +       'first value is used for the centre of the image, and',
     +       ' the second for the',/,1X,'outermost profiles. See ',
     +       'the helpfile for details.')
      END IF
C
      IF (.NOT.ONLINE) THEN
        AVPROFILE = .FALSE.
        GO TO 999
      END IF
C
C                 *********
      IF (ONLINE.AND.LBELL) CALL BELL
C                 *********
C
      IF (PROPTCEN) THEN
        AVPROFILE = .FALSE.
        GO TO 80
      END IF
C
C---- If not optimising the profile, and running interactively, give the
C     opportunity to manually change the measurement box parameters
C     but ONLY for the first image in each block
C
      IF (.NOT.FIRSTFILM) GOTO 80
C
      IF (WINOPEN) THEN
          IXM = 200
          IYM = 200
          LINELEN = 75
          NUMLIN = 15
C     
C     Create IO window
C
          CALL MXDCIO(0,LINELEN, NUMLIN, IXM,IYM)

C---- Do you want to 
C
 52       LINE = ' '
          WRITE(LINE,FMT=6060)
 6060     FORMAT('Do you want to change the measurement box',
     +          ' parameters (N):')
          CALL MXDWIO(LINE, 1)
          CALL MXDRIO(LINE2)
C
C---- Parse reply
C
C                ******************************************
          CALL MPARSE(LINE2,IBEG,IEND,ITYP,VALUE,IDEC,NTOK)
C                ******************************************
          IF (NTOK.EQ.0) THEN
            STR1 = 'N'
          ELSE
            STR1 = LINE2(IBEG(1):IEND(1))
            CALL CCPUPC(STR1)
          END IF
          IF (STR1.EQ.'Y') THEN
            WRITE(LINE,FMT=6062) IRAS
 6062       FORMAT('Current parameters are:',5I5)
            CALL MXDWIO(LINE, 1)
            WRITE(LINE,FMT=6064)
 6064       FORMAT('Give new parameters:')
            CALL MXDWIO(LINE,1)
            CALL MXDRIO(LINE2)
C
C---- Get numbers using PARSER
C
C                    ******************************************
            CALL MPARSE(LINE2,IBEG,IEND,ITYP,VALUE,IDEC,NTOK)
C                    ******************************************
            IF (NTOK.EQ.0) THEN
               GOTO 54
            ELSE IF (NTOK.EQ.5) THEN
               CALL MKEYNM(2,1,LINE2,IBEG,IEND,ITYP,NTOK)
               IF (IOERR) GOTO 52
               NEWRAS = 1
               IRAS(1) = NINT(VALUE(1))
               IRAS(2) = NINT(VALUE(2))
               IRAS(3) = NINT(VALUE(3))
               IRAS(4) = NINT(VALUE(4))
               IRAS(5) = NINT(VALUE(5))
            ELSE
               GOTO 52
            END IF
C
C---- various tests on supplied parameters
C
            IF (((MOD(NXS,2).NE.1) .OR. (NXS.GT.MAXDIM)) .OR.
     +            ((MOD(NYS,2).NE.1) .OR. (NYS.GT.MAXDIM))) THEN
              WRITE(LINE,6066) MAXDIM
 6066        FORMAT('NXS, NYS (first two values) must be ODD and less',
     +             ' than',I3)
              CALL MXDWIO(LINE,1)
              GOTO 52
            END IF
            IF (NC.LE.0) THEN 
              WRITE(LINE,6067) 
 6067         FORMAT('NC (third value) must be > 0')
              CALL MXDWIO(LINE,1)
              GOTO 52
            END IF
            DO 56 I = 1,5
              IF (IRAS(I).LE.0) THEN
                WRITE(LINE,6068) 
 6068           FORMAT('All values must be > zero')
                CALL MXDWIO(LINE,1)
                GOTO 52
              END IF 
 56         CONTINUE
C
C---- Return to form new profile
C
            CALL MXDCIO(1,0,0,0,0)
            RETURN
          END IF 
 54       CALL MXDCIO(1,0,0,0,0)
          GOTO 80
      END IF
C
C---- If window not open
C
      IF (BRIEF) WRITE (IBRIEF,FMT=6006)
      WRITE (ITOUT,FMT=6006)
      READ (ITIN,FMT=6008,END=80) JUNK
C
C          ****************   
      CALL NOYES(JUNK,ISW2)
C          ****************
C ISW2 returned as 1 if Y or y, otherwise 0
C
      IF (ISW2.EQ.0) THEN
        AVPROFILE = .FALSE.
        GO TO 80
      END IF
   50 WRITE (IOUT,FMT=6010)
C
C                 *********
      IF (ONLINE.AND.LBELL) CALL BELL
C                 *********
C
      IF (BRIEF) WRITE (IBRIEF,FMT=6010)
      WRITE (ITOUT,FMT=6010)
      IF (BRIEF) WRITE (IBRIEF,FMT=6012) IRAS,IXSHIFT,IYSHIFT
      WRITE (ITOUT,FMT=6012) IRAS,IXSHIFT,IYSHIFT
      WRITE (IOUT,FMT=6012) IRAS,IXSHIFT,IYSHIFT
      READ (ITIN,FMT=6014) KRAS,KXSHIFT,KYSHIFT
      WRITE (IOUT,FMT=6015) KRAS,KXSHIFT,KYSHIFT
 6015 FORMAT(1X,7I5)
C
C
      DO 70 I = 1,5
        IF (KRAS(I).EQ.0) GO TO 60
        NEWRAS = 1
C
C---- A value of 99 is interpreted as zero
C
        IF (KRAS(I).EQ.99) THEN
          IRAS(I) = 0
        ELSE
          IRAS(I) = KRAS(I)
        END IF
C
C
   60     CONTINUE
   70   CONTINUE
C
      IF (KXSHIFT.NE.0) IXSHIFT = KXSHIFT
      IF (KXSHIFT.EQ.99) IXSHIFT = 0
      IF (KYSHIFT.NE.0) IYSHIFT = KYSHIFT
      IF (KYSHIFT.EQ.99) IYSHIFT = 0
C
      IF (((MOD(NXS,2).NE.1) .OR. (NXS.GT.MAXDIM))
     +   .OR.((MOD(NYS,2).NE.1) .OR. (NYS.GT.MAXDIM))) THEN
         WRITE (ITOUT,FMT=6016) MAXDIM
         IF (BRIEF) WRITE (IBRIEF,FMT=6016) MAXDIM
         GO TO 50
      END IF
      RETURN
C
   80 CONTINUE
C
C---- Update maxr for precession photographs (done in s/r rmaxr for
C     oscillation films)
C
      IF (FIRSTFILM) MAXR = NXS*NYS
C
C
 999  AVPROFILE = .FALSE.
C
C---- Reset profile to original values but subtract background, then set
C     to zero at all background points, as this average
C     profile is used to provide the weights when deriving best standard
C     profiles over the whole detector in S/R PROCESS
      NXY = NXS*NYS
      PRCENSUM = 0.0
      DO 92 I = 1,NXY
        IF (MASK(I).LT.0) THEN
          IODPROF(I) = 0
        ELSE
          IODPROF(I) = REAL(IODPROF(I))/SCALE + MINOD - ASPOT(11) + 0.5
          IF (MASK(I).GT.0) PRCENSUM = PRCENSUM + IODPROF(I)
        END IF
 92   CONTINUE
      IF (DEBUG(15).AND.SPOT) THEN
        WRITE(IOUT,FMT=6028)
        IF (ONLINE) WRITE(ITOUT,FMT=6028)
        MAXPIX = 0
        CALL ODPLOT4(IODPROF(1),NXS,NYS,1,MAXPIX)
6028    FORMAT(/1X,' Background subtracted, background zeroed average',
     +        ' spot profile for weighting',/)
      END IF
C
C---- Format statements
C
 6000 FORMAT (/' Measurement box dimensions too large to display avera',
     +       'ge spot profile',/1X,'NXS*NYS Must be less than or equal',
     +       ' to ',I5)
 6002 FORMAT (1X,'Average spot profile for central region.',/,1X,
     +     'Rejected background ',
     +     'pixels flagged by "*", true background by "-"')
 6003 FORMAT (1X,'Final optimised raster parameters:',5I5,/,1X,
     +        'This gives',I4,' pixels in the peak and',I4,
     +        ' in background after rejecting outliers.',/,1X,
     +        'Note that the number of background pixels rejected',
     +        ' on any individual spot',/,1X,'may be much smaller ',
     +        'than the number rejected here.')
 6004 FORMAT (1X,'C. of G. SHIFTS =',2F7.3,'mm  Background residual='
     +        ,F5.1,' (peak scaled to 255)')
 6006 FORMAT (/' Do you want to change the measurement box ?(y/n)')
 6007 FORMAT(/,1X,'Separation parameters updated to ',F6.2,'mm in X',
     +            ' and',F6.2,'mm in Y')
 6008 FORMAT (A1)
 6010 FORMAT (' Raster parameters and box shift:-',/2X,'NXS  NYS   NC ',
     +       ' NRX  NRY  XSH  YSH  (ENTER 99 TO GET 0)')
 6012 FORMAT (1X,I4,6I5,'      ?  Give new values in I5 format')
 6014 FORMAT (1X,I4,6I5)
 6016 FORMAT (' ***NXS and NYS MUST be ODD Integers < or = to ',I3)
C
C
      END
C $Id: clcalc.f,v 1.2 2003/02/25 12:49:48 harry Exp $
C== CLCALC ==
C
C
C
      SUBROUTINE CLCALC(CELL,A)
C     ========================
      IMPLICIT NONE
C
C
C
C---- Calculate cell (real or reciprocal) from metric tensor A
C     Angles in degrees
C
C
C
C
C     .. Array Arguments ..
      REAL A(3,3),CELL(6)
C     ..
C     .. Local Scalars ..
      INTEGER I
      REAL DTOR,X
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC SQRT,ACOS
C     ..
C
C
      DTOR = ATAN(1.0)*4.0/180.0
C
C
      DO 10 I = 1,3
        CELL(I) = SQRT(A(I,I))
   10 CONTINUE
C
      X = A(2,3)/ (CELL(2)*CELL(3))
      IF (ABS(X).GT.1.0) X = SIGN(1.0,X)
      CELL(4) = ACOS(X)/DTOR
      X = A(1,3)/ (CELL(1)*CELL(3))
      IF (ABS(X).GT.1.0) X = SIGN(1.0,X)
      CELL(5) = ACOS(X)/DTOR
      X = A(1,2)/ (CELL(1)*CELL(2))
      IF (ABS(X).GT.1.0) X = SIGN(1.0,X)
      CELL(6) = ACOS(X)/DTOR
C
C
      END
C== CLEAR  ==
      SUBROUTINE CLEAR(A)
C     ==================
C
C     .. Array Arguments ..
      REAL A(9)
C     ..
C     .. Local Scalars ..
      INTEGER I
C     ..
C
C
      DO 10 I = 1,9
        A(I) = 0.0
   10 CONTINUE
C
C
      END
      SUBROUTINE CNVPIX(IX,IY,ISTAT)
C     =====================================
C
c  Check that image pixel with coord IX,IY is within image.
c
c
c  Output
c     istat             = 1 if outside display, else = 0 (OK)
c

      IMPLICIT NONE
C
      INTEGER IX,IY,ISTAT
C&&*&& include  ../inc/mxdinc.f
C
C $Id: mxdinc.f,v 1.1 2002/05/02 10:47:00 harry Exp $
C
C--- awk generated include file  mxdinc.h
C---- START of include file mxdinc.h
C
C
c common block for mxd routines: various parameters for XDL routines
c
c     base_width    width of base frame
c     base_height   height of base frame
c     men_x,men_y   position of menu area
c     par_x,par_y   position of parameter area
C     

C     IORDER    (R)   Order of the data in the input image 
c                with respect to two local axes ax1, ax2 e.g.
c                (xf, yf) as a number from 1 to 8.
c                    1   +ax1 slow   +ax2 fast    (+xf, +yf)
c                    2   +ax1 slow   -ax2 fast    (+xf, -yf)
c                    3   -ax1 slow   +ax2 fast    (-xf, +yf)
c                    4   -ax1 slow   -ax2 fast    (-xf, -yf)
c                    5   +ax2 slow   +ax1 fast    (+yf, +xf)
c                    6   +ax2 slow   -ax1 fast    (+yf, -xf)
c                    7   -ax2 slow   +ax1 fast    (-yf, +xf)
c                    8   -ax2 slow   -ax1 fast    (-yf, -xf)
c
c
c     JORDER    (R)   Display order with respect to the two
c                local axes (1 to 8) along the X-windows
c                axes X horizontal (left to right), Y vertical 
c                (top to bottom ) with origin at top left
c                1  +ax1 X (horiz)   +ax2 Y (vert)   (+xf, +yf)
c                2  +ax1 X (horiz)   -ax2 Y (vert)   (+xf, -yf)
c                3  -ax1 X (horiz)   +ax2 Y (vert)   (-xf, +yf)
c                4  -ax1 X (horiz)   -ax2 Y (vert)   (-xf, -yf)
c                5  +ax2 X (horiz)   +ax1 Y (vert)   (+yf, +xf)
c                6  +ax2 X (horiz)   -ax1 Y (vert)   (+yf, -xf)
c                7  -ax2 X (horiz)   +ax1 Y (vert)   (-yf, +xf)
c                8  -ax2 X (horiz)   -ax1 Y (vert)   (-yf, -xf)
c                    
c                    (2 was standard for Laue programs)
c
c     nxp_cmp       number of pixels compressed to 1 in horizontal
c                   display direction
c     nyp_cmp       number of pixels compressed to 1 in vertical
c                   display direction
c     nxdpx         number of horizontal pixels in displayed image
c     nydpx         number of vertical pixels in displayed image
c     img_horiz     image direction for horizontal display (=1 fast, 2 slow)
c     img_vert      image direction for vertical display   (=1 fast, 2 slow)
c     img_map(4)    mapping of image to display
c                    imgmap(1)   1st point on fast axis (Yms)
c                    imgmap(2)   1st point on slow axis (Zms)
c                    imgmap(3)   increment on fast axis
c                    imgmap(4)   increment on slow
c     img_x,img_y   x, y position of image
c     men_x, men_y  x, y position of menu
c     par_x, par_y  x, y position of parameter table
c     io_x, io_y    x, y position of IO area
c     not_x, not_y    x, y position of notice area (parameter table
c                     with no values)
c     pmn_x, pmn_y  x, y position of popup abort menu
c     ppb_x, ppb_y  x, y position of popup progress bar
c     busy_x, busy_y x, y position of busy window
c     img_width,img_height   width, height of image window
c     men_width, men_height  width, height of menu window  
c     par_width, par_height  width, height of parameter window
c     io_width, io_height    width, height of IO window
c     not_width, not_height  width, height of notice area
c     pmn_width, pmn_height  width, height of Abort menu
c     ppb_width              width of progress bar
c     busy_width, busy_height  width, height of busy box
c     sub_process    .true. if program is sub-process of eg clips, .false.
c                    if standalone
c
C     IFTYPE      1 = unsigned byte data
C                 2 = unsigned two-byte data (i2)
C                 3 = signed integer data
C                 4 = 'squashed i2' data (if Intensity>32767 
C                    store as 65536-Intensity/8)
      INTEGER BASE_WIDTH,BASE_HEIGHT,
     $     IMAGE_ORDER,JIMAGE_ORDER,NXP_CMP,NYP_CMP,
     $     NXDPX,NYDPX,
     $     IMG_HORIZ,IMG_VERT,IMG_MAP(4),
     $     IMG_X,IMG_Y,MEN_X,MEN_Y,PAR_X,PAR_Y,IO_X,IO_Y,
     $     NOT_X,NOT_Y,PMN_X, PMN_Y,PPB_X, PPB_Y, BUSY_X, BUSY_Y,
     $     BUSY_Y2,IFTYPE
      INTEGER IMG_WIDTH, IMG_HEIGHT, MEN_WIDTH, MEN_HEIGHT,
     $     PAR_WIDTH, PAR_HEIGHT, IO_WIDTH, IO_HEIGHT,
     $     NOT_WIDTH, NOT_HEIGHT, PMN_WIDTH, PMN_HEIGHT,
     $     PPB_WIDTH, BUSY_WIDTH, BUSY_HEIGHT
      LOGICAL SUB_PROCESS, BLANK
C

c  DON'T forget to declare function xdlstr as integer
      INTEGER XDLSTR
      EXTERNAL XDLSTR

c
c     ivhbas        view object handle for base frame
c     ivhimg        view object handle for image
c     ivhpar        view object handle for parameter table
c     ivhmen        view object handle for menu
c     ivhio         view object handle for io area
c     ivhio2        view object handle for second io area (pick option)
c     ivhio3        view object handle for third io area (output)
c     ivhnot        view object handle for notice area (parameter table)
c     ivhpmn        view object handle for popup wait menu
c     ivhppb        view object handle for popup progress bar
c     ivhblank      view object handle for blank object
c     ivhbusy       view object handle for busy object
c     ivhbusy2      view object handle for second (2 line) busy object
      INTEGER IVHBAS, IVHIMG, IVHPAR, IVHMEN, IVHIO, IVHNOT, IVHPMN,
     $     IVHPPB, IVHBLANK, IVHBUSY, IVHIO2, IVHBUSY2, IVHIO3
      PARAMETER (IVHBAS=1, IVHIMG=2, IVHPAR=3, IVHMEN=4, IVHIO=5,
     $     IVHNOT=6, IVHPMN=7, IVHPPB=8, IVHBLANK=9, IVHBUSY=10,
     $     IVHIO2=11, IVHBUSY2=12, IVHIO3=13)

c  Border  boundary between windows
      INTEGER BORDER
      PARAMETER (BORDER = 3)

c     icset   colour set number
      INTEGER ICSET
      PARAMETER (ICSET=1)
c
c     iord    axis order of image
c             = 1  xf slow, yf fast
      INTEGER IORD
      PARAMETER (IORD = 1)
c
c     minw,minh   minimum width and height for image display object
      INTEGER MINW,MINH
      PARAMETER (MINW=0, MINH=0)
c
c     ixopix, iyopix      pixel origin of displayed part
      INTEGER IXOPIX,IYOPIX
      PARAMETER (IXOPIX=1, IYOPIX=1)
c
c     ibg     background menu, =0 for none
      INTEGER IBG
      PARAMETER (IBG=0)
c
c     iovly   overlay option
      INTEGER IOVLY
      PARAMETER (IOVLY=1)
c
c     max_pixel   maximum number of pixels to use for image display:
c                 this will be used to control possible compression
c                 of the image
      INTEGER MAX_PIXEL
      PARAMETER (MAX_PIXEL = 600)
c  Image stuff
c     disp_img        true if image has been displayed
c
      LOGICAL DISP_IMG
c
c     ifd     file descriptor, = -1 for no file
      INTEGER IFD
      PARAMETER (IFD=0)
c

c  Parameter table stuff
c     max_par_col     maximum number of parameter columns
c     max_par_rows    maximum number of parameter rows
c     max_par_name    maximum length of name
c     max_par_str     maximum value length
c     par_title       = -1 no title +1 title present
c     par_font        font (3=medium)
c     par_menu        = 1 if popup menus allowed
c     disp_par        true if parameter table hsa been displayed
c
      LOGICAL DISP_PAR
      INTEGER MAX_PAR_COL, MAX_PAR_ROWS, MAX_PAR_NAME, MAX_PAR_STR,
     $        PAR_TITLE, PAR_FONT, PAR_MENU
      PARAMETER (MAX_PAR_COL = 1, MAX_PAR_ROWS = 50,
     $           MAX_PAR_NAME = 17, MAX_PAR_STR = 7,
     $           PAR_TITLE = 1, PAR_FONT = 2, PAR_MENU = 0)
C
c  Menu stuff
c     max_men_itms    maximum number of menu items
c     max_men_name    maximum number of characters in menu item
c     men_font        menu font number (3=medium)
c     men_quit_flag   = 1 to allow for quit box
c     max_men_title   maximum length of menu title
c     disp_menu       true if menu displayed
      LOGICAL DISP_MENU
      INTEGER MAX_MEN_ITMS, MAX_MEN_NAME, MEN_FONT, MEN_QUIT_FLAG,
     $        MAX_MEN_TITLE 
      PARAMETER (MAX_MEN_ITMS = 19, MAX_MEN_NAME = 19, MEN_FONT = 2,
     $     MEN_QUIT_FLAG = 1, MAX_MEN_TITLE = 9)

c
c IO area stuff
c     io_font         font number
c     disp_io         true if io area displayed
c     disp_io2        true if SECOND io area displayed
c     disp_io3        true if THIRD io area displayed
C     NSCROLL         number of pages to hold for scrolling
      LOGICAL DISP_IO,DISP_IO2,DISP_IO3
      INTEGER IO_FONT,NSCROLL
      PARAMETER (IO_FONT=2)
      PARAMETER (NSCROLL=0)


c  Notice area stuff (notice area is a parameter table with no values)
c     max_not_col     maximum number of parameter columns
c     max_not_rows    maximum number of parameter rows
c     max_not_name    maximum length of name
c     max_not_str     maximum value length
c     not_title       = -1 no title +1 title present
c     not_font        font (3=medium)
c     not_menu        = 1 if popup menus allowed
c     disp_not       true if menu displayed
      LOGICAL DISP_NOT
      INTEGER MAX_NOT_COL, MAX_NOT_ROWS, MAX_NOT_NAME, MAX_NOT_STR,
     $        NOT_TITLE, NOT_FONT, NOT_MENU
      PARAMETER (MAX_NOT_COL = 1, MAX_NOT_ROWS = 18,
     $           MAX_NOT_NAME = 23,
     $           MAX_NOT_STR = 0,
     $           NOT_TITLE = +1, NOT_FONT = 1, NOT_MENU = 0)
c
c  Menu stuff for Abort menu
c     max_pmn_itms    maximum number of menu items
c     max_pmn_name    maximum number of characters in menu item
c     pmn_font        menu font number (3=medium)
c     pmn_quit_flag   = 1 to allow for quit box
c     max_pmn_title   maximum length of menu title
      INTEGER MAX_PMN_ITMS, MAX_PMN_NAME, PMN_FONT, PMN_QUIT_FLAG,
     $        MAX_PMN_TITLE 
      PARAMETER (MAX_PMN_ITMS = 0, MAX_PMN_NAME = 12, PMN_FONT = 2,
     $     PMN_QUIT_FLAG = 1, MAX_PMN_TITLE = 15)

c   Stuff for progress bar
c     ppb_font   font number (3=medium)
c     ppb_colr   colour
      INTEGER PPB_FONT, PPB_COLR
      PARAMETER (PPB_FONT = 2, PPB_COLR=3)

c   Busy box
      INTEGER BUSY_FONT
      PARAMETER (BUSY_FONT = 2)
c
c len_dialog    length of dialog box
      INTEGER LEN_DIALOG
      PARAMETER (LEN_DIALOG = 60)

c
c  Overlays
c
c  Circles
c     cir_ivec    vector set number for circles
c     cir_colr    colour for circles
c     cir_iovl    overlay number for circles
c     cir_symb   symbol for centre
      INTEGER CIR_IVEC, CIR_COLR, CIR_IOVL, CIR_SYMB
      PARAMETER (CIR_IVEC=3, CIR_COLR=6, CIR_IOVL=2, CIR_SYMB=4)

C
C---- Residual vectors
C     IRV_VEC Vector set number
C     IRV_COL Colour  (1 red, 2 yellow, 3 green)
C     IRV_OVL Overlay number
      INTEGER IRV_VEC, IRV_COL, IRV_OVL
      PARAMETER (IRV_VEC=4, IRV_COL=1, IRV_OVL=2)
c  Measure
c
c     mes_colr    colour for measure crosses
      INTEGER MES_COLR
      PARAMETER (MES_COLR=1)

c   Vertical Crosses
c     cross_iovl    overlay number for circles
c     cross_symb   symbol for centre
      INTEGER CROSS_IOVL, CROSS_SYMB
      PARAMETER (CROSS_IOVL=2, CROSS_SYMB=3)
c  Boxes
c     box_iovl    overlay number for boxes
c     box_symb   symbol for centre
      INTEGER BOX_IOVL, BOX_SYMB, BOX_VEC
      PARAMETER (BOX_VEC=2,BOX_IOVL=2, BOX_SYMB=13)
c  Circles
c     CIRC_iovl    overlay number for circles
c     CIRC_symb   symbol for centre
      INTEGER CIRC_IOVL, CIRC_VEC
      PARAMETER (CIRC_VEC=5,CIRC_IOVL=2)
c   Crosses
c     cross_iovl    overlay number for circles
c     cross_symb   symbol for centre
      INTEGER XCROSS_IOVL, XCROSS_SYMB
      PARAMETER (XCROSS_IOVL=2, XCROSS_SYMB=13)
C
C---- common block last of all
C
      COMMON /MXDCMI/ BASE_WIDTH,BASE_HEIGHT,
     $     IMAGE_ORDER,JIMAGE_ORDER,NXP_CMP,NYP_CMP,
     $     NXDPX,NYDPX,
     $     IMG_HORIZ,IMG_VERT,IMG_MAP,
     $     IMG_X,IMG_Y,MEN_X,MEN_Y,PAR_X,PAR_Y,IO_X,IO_Y,
     $     NOT_X,NOT_Y,PMN_X, PMN_Y,PPB_X, PPB_Y, BUSY_X, BUSY_Y,
     $     BUSY_Y2, IFTYPE,
     $     IMG_WIDTH, IMG_HEIGHT, MEN_WIDTH, MEN_HEIGHT,
     $     PAR_WIDTH, PAR_HEIGHT, IO_WIDTH, IO_HEIGHT,
     $     NOT_WIDTH, NOT_HEIGHT, PMN_WIDTH, PMN_HEIGHT,
     $     PPB_WIDTH, BUSY_WIDTH, BUSY_HEIGHT,
     $     SUB_PROCESS,BLANK,DISP_IMG,DISP_PAR,DISP_MENU,
     $     DISP_IO,DISP_IO2,DISP_IO3,DISP_NOT
  
C&&*&& end_include  ../inc/mxdinc.f
C
C check if in allowed display area
      ISTAT = 0
      IF (IX .LT. 1. OR. IX .GT. NXDPX .OR.
     $    IY .LT. 1. OR. IY .GT. NYDPX) ISTAT = 1
      RETURN
      END
C     
C     $Id: complete.f,v 1.33 2004/07/20 12:15:51 harry Exp $
C     
C==   COMPLETE ==
      SUBROUTINE COMPLETE(IHKLSTR,NTOTAL,IORDER)
C     
      IMPLICIT NONE
C     
C     LAST LABEL 470, FORMAT 6320
C     Program to compile statistics on completeness of a data set
C     
C     The reflection list is stored in memory. For each unique reflection
C     the following are stored:
C     
C     For each reflection: ADATA(6)
C     1-3       h,k,l
C     4          -999 (Identifier)
C     5         ICENT =0 centric
C     =1 acentric
C     6         zero (not used)
C     
C     For generated reflections:
C     ===========================
C     H,K,L,BATCH,PHI,IC
C     
C     "BATCH" is 9999 for generated data (-999 for unique reflections)
C     
C     "PHI" is the phi value for the reflection. This is stored as an integer,
C     and will be the truncated real phi (ie 4.8 will become 4)
C     
C     "IC" is modulo 2 of the number of the symmetry operation used
C     to generate the correct indices, plus 1. Friedel pairs will
C     therefore have values of 1 and 2. This is used to calculate the
C     number of Friedel pairs.
C     
C     
C     
C     Originally coded by A.G.W. LESLIE NOV 1984
C     
C     
C     
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
      INTEGER NPARM, istatus
      PARAMETER (NPARM=200)
C     IHKLSTR      Array containing the reflections
C     
C     Need to use IHKLSTR(1,NTOTAL) onwards are working array
C     ..
C     .. Scalar Arguments ..
      INTEGER NTOTAL
C     
C     ..
C     .. Array Arguments ..
      INTEGER*2 IHKLSTR(MCOLSTR,NREFSTR)
chrp28.04.2003 changed iorder to i*2 - NO. must be I*4
      INTEGER IORDER(NTOTAL)
C     ..      
      CHARACTER LINE*400,KEY*4,SUBKEY*4,HLPMOS*400
      character xmlline2*1024, xmlline3*1024, dnahs*80
C     ..
C     .. local scalars
      INTEGER ICOMM,IERR
      LOGICAL HARRY
C     ..
C     .. External Functions ..
      INTEGER LENSTR
      LOGICAL HKLEQ
      EXTERNAL LENSTR,HKLEQ
C     ..
C     .. External Subroutines ..
      EXTERNAL SORTUP2,MKEYNM,MPARSER,CCPUPC,MOSHLP,TESTOVER,SETMAT,
     +     LWCLOS,WINDIO
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC NINT,REAL,SQRT
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/completedata.f
C     ..      
C     .. Local Scalars ..
      REAL PC,PC1,PHIFINI,PHIINCI,PHISTI,SN,SN2,STH,DTR,XSEP,YSEP,
     +     SMAX,SMIN,RESMAX,RESMIN,SRESOL,STHINC,STHLMIN,STHLMAX,
     +     DMAX,DMIN,DSTSQ,S,PHI1,PHI2,PHIINCR,CPHISTART,CPHIEND,
     +     PHISEG,PHIFINAL,PHISTAUTO,X,PHITOT,PPHISTI,PPHIFINI,
     +     AUTOINC,PHIADDAUTO,SUM1,SUM2
      INTEGER I,IBATCH,IBIN,ICEN,IFLAG,IPHI,IPKF,IPKS,IREF,ISEG,J,K,
     +     KPACK,MAXMLT,MULT,MULTPACK,N,N1,N2,NACROSS,NANO,
     +     NANOMT,NBITS,NDIFFPACK,NEXTRA,NIN,NIN1,NIN2,
     +     NMULT,NNPACK,NPACK,NPACK1,NPACK2,NPRINT,NRESO,NSEGIN,
     +     NTOTPACK,NUNI,NUNIANOT,NLPRGI,IPRINT,NBIN,NBIT,
     +     NTOK,IFSEG,IH,IK,IL,ITINS,JJ,ICOUNT,KK,ISTA,IFIN,IP,
     +     IMODE,ICLEAR,IRUN,IRUNOLD,JRUN,IBINOLD,ICOMB,IROT,
     +     NSEGSTART,ISTAFLG,IENDFLG,NDBG,ICENOLD,ISIZE,
     +     IMAT,IUMAT,ICELL,ICHECK,MTZPRT,NCH
      LOGICAL DUMPSPOT,EOF,MONITOR,COMREAD,STARTOK,ENDOK,RESET,LAST,
     +     NEWRUN,DONETEST,INERR,NULINE

C     ..                   
C     .. Local Arrays ..
      REAL D(NRESBIN),PCENT(NRESBIN),PCENTANO(NRESBIN),CPHIFI(NSEGMAX),
     +     CPHIFIN(MAXPAX),CPHIST(NSEGMAX),CPHIINC(NSEGMAX),
     +     CPHISTA(MAXPAX),SPHIFI(NSEGMAX),CPHIADD(NSEGMAX),
     +     SPHIINC(NSEGMAX),SPHIST(NSEGMAX),ADATA1(MCOLSTR),
     +     ADATA2(MCOLSTR),KH(3),LH(3),VALUE(NPARM),PRSTA(MAXPAX),
     +     PRFIN(MAXPAX),PHSBEST(NSEGMAX),PCUNIQA(MAXPAX),XMULT(MAXPAX)
      INTEGER IPACK(MULTMAX),HKL1(3),HKL2(3),
     +     IPFSEG(MAXPAX),IPKFI(NSEGMAX),
     +     IPKST(NSEGMAX),IPSSEG(MAXPAX),ISPKFI(NSEGMAX),
     +     ISPKST(NSEGMAX),JPACK(MAXDIFF+1,2),
     +     LOOKUP(MCOLSTR),NANOM(NRESBIN),NISYM(MULTMAX),
     +     NOBSRES(MAXPAX,NRESBIN),NTIMES(MAXPAX,MULTMAX),
     +     NTOT(MAXPAX),NTOTRES(NRESBIN),NUNIANO(NRESBIN),
     +     NUNIQA(MAXPAX),NUNIRES(NRESBIN),IBEG(NPARM),IDEC(NPARM),
     +     IEND(NPARM),ITYP(NPARM),IFIRST(NSEGMAX),ICRUN(NSEGMAX)
      INTEGER*2 JORDER(NSEGMAX),IPHIA(NSEGMAX)
      
      COMMON /noddyblka/ PC,PC1,PHIFINI,PHIINCI,PHISTI,SN,SN2,
     +     STH,DTR,XSEP,YSEP,
     +     SMAX,SMIN,RESMAX,RESMIN,SRESOL,STHINC,STHLMIN,STHLMAX,
     +     DMAX,DMIN,DSTSQ,S,PHI1,PHI2,PHIINCR,CPHISTART,CPHIEND,
     +     PHISEG,PHIFINAL,PHISTAUTO,X,PHITOT,PPHISTI,PPHIFINI,
     +     AUTOINC,PHIADDAUTO,SUM1,SUM2

      common /noddyblkb/ I,IBATCH,IBIN,ICEN,IFLAG,IPHI,IPKF,IPKS,
     +     IREF,ISEG,J,K,
     +     KPACK,MAXMLT,MULT,MULTPACK,N,N1,N2,NACROSS,NANO,
     +     NANOMT,NBITS,nunianot,NDIFFPACK,NEXTRA,NIN,NIN1,NIN2,
     +     NMULT,NNPACK,NPACK,NPACK1,NPACK2,NPRINT,NRESO,NSEGIN,
     +     NTOTPACK,NUNI,NLPRGI,IPRINT,NBIN,NBIT,
     +     NTOK,IFSEG,IH,IK,IL,ITINS,JJ,ICOUNT,KK,ISTA,IFIN,IP,
     +     IMODE,ICLEAR,IRUN,IRUNOLD,JRUN,IBINOLD,ICOMB,IROT

      common /noddyblkc/ NSEGSTART,ISTAFLG,IENDFLG,NDBG,ICENOLD,ISIZE,
     +     IMAT,IUMAT,ICELL,ICHECK,MTZPRT,NCH,
     +     DUMPSPOT,EOF,MONITOR,COMREAD,STARTOK,ENDOK,RESET,LAST,
     +     NEWRUN,DONETEST,INERR,NULINE,
     +     D,PCENT,PCENTANO,CPHIFI,CPHIFIN,CPHIST,CPHIINC,
     +     CPHISTA,SPHIFI,CPHIADD,
     +     SPHIINC,SPHIST,ADATA1,
     +     ADATA2,VALUE,PRSTA

      common /noddyblkd/ PRFIN,PHSBEST,PCUNIQA,
     +     XMULT, IPACK,HKL1,HKL2,
     +     IPFSEG,IPKFI,
     +     IPKST,IPSSEG,ISPKFI,
     +     ISPKST,JPACK,
     +     LOOKUP,NANOM,NISYM,
     +     NOBSRES,NTIMES,
     +     NTOT,NTOTRES,NUNIANO,
     +     NUNIQA,NUNIRES,IBEG,IDEC,
     +     IEND,ITYP,IFIRST,ICRUN,
     +     JORDER,IPHIA
C&&*&& end_include  ../inc/completedata.f
C&&*&& include  ../inc/cell.f
C
C $Id: cell.f,v 1.2 2003/06/16 16:41:13 harry Exp $
C
C--- awk generated include file  cell.h
C---- START of include file cell.h
C
C     CELL cell dimensions (real space)
C     RCELL reciprocal cell parameters in dimensionless rlu
C
C     .. Arrays in Common /CELLCOM/ ..
      REAL UMAT,BMAT,GMAT,CELL,RCELL,UMATCELL,SOFTCELL
      INTEGER LCELL,ICRYST,NUMSPG,NLAUE
C     ..
C     .. Common Block /CELLCOM/ ..
      COMMON /CELLCOM/UMAT(3,3),BMAT(3,3),GMAT(3,3),CELL(6),RCELL(6),
     $       UMATCELL(6),SOFTCELL,LCELL(6),ICRYST,NUMSPG,NLAUE
C     ..
C
C
C&&*&& end_include  ../inc/cell.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/dsplyc.f
C
C $Id: dsplyc.f,v 1.1 2002/05/02 10:46:46 harry Exp $
C
C--- awk generated include file  dsplyc.h
C---- START of include file dsplyc.h
C
C*******************************************************************
C
C  COMMON  /DSPLYC/
C
C	IMGLOW, IMGHI	low & high values of 16-bit image for scaling
C			integer*2 to byte: IMGLOW maps to  0; 
C			IMGHI to maximum. Note that these are not
C			necessarily the actual limits of the data
C	JDSPWD		.LT. 0  before image window has been created
C                       = +-1 for image display that can be panned
C                       = +-2 for non-interactive image display
C       MAXDEN          highest level in colour table to fill up to
C                       must be less than ~240 - number of overlay colours
C       LDSPSG          if .true., treat image as signed, ie after dark
C                          subtraction
C                       if .false., treat image as unsigned
C       NZOOM           zoom factor for image, = 0 if no zoom
C       JYZOOM, JZZOOM  1st pixel in zoomed image
C
C----   WINOPEN Flag for whether or not window is open. Do not
C               confuse with DISPMENU (/CONDATA/)which is true if the run was
C               started with a IMAGE keyword.
C
C
C       CDSPTL          banner title
C
      INTEGER IMGLOW, IMGHI, JDSPWD, MAXDEN,
     $     NZOOM, JYZOOM, JZZOOM
      LOGICAL LDSPSG,WINOPEN,LPAUSE,LHELP
      COMMON /DSPLYC/ IMGLOW, IMGHI, JDSPWD,
     *     MAXDEN, NZOOM, JYZOOM, JZZOOM, LDSPSG,WINOPEN,LPAUSE,LHELP
C
      CHARACTER  CDSPTL*200
      COMMON /DSPLCC/  CDSPTL
C                                                           
C
C*******************************************************************


C&&*&& end_include  ../inc/dsplyc.f
C&&*&& include  ../inc/gui.f
c     gui.h
c     maintained by G.Winter
c     16th April 2002
c     $Id: gui.f,v 1.16 2003/04/04 14:22:01 harry Exp $
c     
c     This defines the variables and common blocks which are used by the
c     new gui control routine. This will also be used in xdisp and control,
c     to switch the new gui on!
c     
c     

      logical gui_switch, refine_cell(6), refine_detector(11),
     +     autocomplete, autoreturn, newmatstore
      integer nargs
      integer imageno, nstart
      parameter (nargs = 200)

c     refine_detector logical block index:
c     1: beam x 2: beam y 3: ccomega 4: yscale
c     5: distance 6: tilt 7: twist 8: roff 9: toff
c     
c     refine_cell logical block index:
c     1: a 2: b 3: c
c     4: alpha 5: beta 6: gamma
c     
c     
c     

      integer keep_phi_segments, keep_phi_start(20), 
     +     keep_phi_end(20)

      real storemeanmult

      common /gui/ gui_switch, imageno, refine_cell, refine_detector,
     +     autocomplete, nstart, autoreturn, newmatstore

      common /keep_phi/ keep_phi_segments, keep_phi_start, 
     +     keep_phi_end, storemeanmult


c     refine_cell(i) is true if you wish to refine cell(i)
C&&*&& end_include  ../inc/gui.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/ioosum.f
C
C $Id: ioosum.f,v 1.2 2004/08/16 13:26:27 harry Exp $
C
C--- awk generated include file  ioosum.h
C---- START of include file ioosum.h
C
C     .. Scalars in common block /IOOSUM/
      INTEGER NLSUM1,NLSUM2,NSUMSTART1,NSUMSTART2
C
C     .. Arrays in common block /IOOSUMC/ ..
      CHARACTER*150 LINESUM1(MAXPAX),LINESUM2(MAXPAX)
      CHARACTER*101  IOLINE(100)
C     ..
C     .. Common block /IOOSUM/ ..
      COMMON /IOOSUM/ NLSUM1,NLSUM2,NSUMSTART1,NSUMSTART2
C     ..
C     .. Common block /IOOSUMC/ ..
      COMMON /IOOSUMC/ LINESUM1,LINESUM2,IOLINE
C&&*&& end_include  ../inc/ioosum.f
CAL      include '../inc/ioomtz.f'
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
C&&*&& include  ../inc/over.f
C
C $Id: over.f,v 1.1 2002/05/02 10:47:03 harry Exp $
C
C--- awk generated include file  over.h
C---- START of include file over.h
C
C
C     .. Scalars in Common Block /OVER/ ..
C
C     ..
C     .. Scalars in common /OVER/ ..
      INTEGER MINDTX,MINDTY,NPOVL,IXSEP,IYSEP
C     ..
C     .. ARRAYS in common /OVER/ ..
      INTEGER HKLPOVL
C     ..
C     .. Common Block /OVER/ ..
      COMMON /OVER/MINDTX,MINDTY,NPOVL,IXSEP,IYSEP,HKLPOVL(NREFLS/2)
C     ..
C
C
C&&*&& end_include  ../inc/over.f
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/strat.f
C--- awk generated include file  strat.h
C---- START of include file strat.h
C
C---- Stores variables for use in STRATEGY option
C     IROTAX is the axis closest to the rotation axis
C     PHIROTAX is the angle this axis makes with the rotation axis
C
C     PHIZONE is the phi value at which axis "IZONEAX" is along the
C     X-ray beam. (IZONEAX = 1 is a, =2 is b, =3 is c)
C     PHIPAD  is the rotation to be added to PHILAUE to ensure generation
C             of all unique data, and will depend on angle between the
C             unique axis and the rotation axis.
C     AUTANOM if true tries to maximise number of anomalous pairs
C     CELLSCAL is the scale factor applied to the cell edges to
C              speed up the calculation.
C     SHRUNK   is TRUE if the cell has been scaled by CELLSCAL
C     ISTRUN   is used to increment input phi angles by multiples of
C              360 degrees, so that phi values in different parts can
C              be recognised. It starts at zero.
C     FIRSTRAT Starts as TRUE (set in MOSDATA) and is set to FALSE once
C              the MTZ file has been opened for a STRATEGY run.
C              Reset TRUE after EXITing from STRATGEY prompt.
C
C     .. Scalars in common /STRAT/ ..
      INTEGER NSEGM,IPCKCUR,NSTRAT,NUNIQ,NSTRUN,ISTRUN,NSEGAUTO,
     +        IZONEAX,IROTAX,NLAST,NNPACKS,NLASTPACK
      LOGICAL STRATEGY,AUTO,SIZESET,AUTANOM,SHRUNK,FIRSTRAT,
     +         NEWSTRAT,WAITINP,OFFPHI
      REAL ROTAUTO,PHILAUE,PHIPAD,PHIZONE,PHIROTAX,CELLSCAL
C     ..
C     .. Arrays in common /STRAT/ ..
      REAL PHIST,PHIFIN,PHIINC,PHIADD,PHISEGA
      INTEGER IFIRSTONE
C     ..
C     .. Common Block /STRAT/ ..
      COMMON /STRAT/ PHIST(NSEGMAX),PHIFIN(NSEGMAX),PHIINC(NSEGMAX),
     +       PHIADD(NSEGMAX),PHISEGA(NSEGMAX),ROTAUTO,PHILAUE,PHIPAD,
     $       PHIZONE,PHIROTAX,CELLSCAL,IFIRSTONE(NSEGMAX),
     $       NSEGM,IPCKCUR,NSTRAT,NUNIQ,
     +       NSTRUN,ISTRUN,NSEGAUTO,
     +       IZONEAX,IROTAX,NLAST,NNPACKS,NLASTPACK,
     +       STRATEGY,AUTO,SIZESET,AUTANOM,SHRUNK,
     +       FIRSTRAT,NEWSTRAT,WAITINP,
     +       OFFPHI
C     ..
C
C


      
C&&*&& end_include  ../inc/strat.f
C&&*&& include  ../inc/tgen.f
C
C $Id: tgen.f,v 1.1 2002/05/02 10:47:23 harry Exp $
C
C--- awk generated include file  tgen.h
C---- START of include file tgen.h
C
C---- Stores variables for use in TESTGEN option
C
C     .. Arrays in common /TGEN/ ..
c      REAL XOVER
c      INTEGER ISTATS
C
C     .. Scalars in common /TGEN/ ..
      REAL XOVER,PHSTART,PHEND,PHSTEP,OSCMIN,OSCMAX,SDIVH,SDIVV,
     +     SDELCOR,SDELAMB,SETA,OSCANG,PCMAX
      INTEGER ISTATS
      LOGICAL TESTGEN,TESTRAT
C     ..
C     ..
C     .. Common Block /TGEN/ ..
      COMMON /TGEN/XOVER(2),PHSTART,PHEND,PHSTEP,OSCMIN,OSCMAX,
     +     SDIVH,SDIVV,SDELCOR,SDELAMB,SETA,OSCANG,PCMAX,
     $     ISTATS(MAXPAX,3),TESTGEN,TESTRAT

C&&*&& end_include  ../inc/tgen.f
C     ..
C     .. Equivalences ..
      EQUIVALENCE (KH(1),ADATA1(1)), (LH(1),ADATA2(1))
C     ..                                          
c     SAVE
C     ..
C     

c     data nunianot/0/
      HARRY = .TRUE.
      IF (DEBUG(57)) THEN
         WRITE(IOUT,FMT=6160) AUTO,NSTRUN,NSEGM,
     +        NSEGAUTO,CELLSCAL,SHRUNK
         IF (ONLINE) WRITE(ITOUT,FMT=6160) AUTO,NSTRUN,NSEGM,NSEGAUTO,
     +        CELLSCAL,SHRUNK
 6160    FORMAT(//,1X,'Entering COMPLETE, AUTO',L2,', NSTRUN',I3,
     +        ' NSEGM',I3,' NSEGAUTO',I3,' CELLSCAL',F7.4,
     +        ' SHRUNK',L2)
      END IF
      RESET = .FALSE.
      LAST = .FALSE.
      NEWRUN = .FALSE.
      IF (AUTO) NEWRUN = .TRUE.
      DONETEST = .FALSE.
      ITINS = ITIN
      DTR = ATAN(1.0)/45.0
      MONITOR = .TRUE.
      COMREAD = .FALSE.
      PHIINCR = 0.0
      NULINE = .TRUE.
C     
C---- Turn STATS off
C     
      IMODE = 0
C     
      DUMPSPOT = .FALSE.
      NBIN = 8
      NACROSS = 4
C     
C---- Auto mode, generate the phi segments to be tested
C     
      IF (.NOT.AUTO) GOTO 2
C     
C---- First, if there is more than one run, generate all segments for
C     all runs up to the last one, and add up the total rotation angle
C     
 1    NSEGIN = 0
      PHITOT = 0.0
      IF (NSTRUN.GT.1) THEN
         DO 390 JRUN = 1,NSTRUN-1
            DO 380 I = 1,NSEGM
               IRUN = NINT(PHIST(I))/360 + 1
               IF (IRUN.EQ.JRUN) THEN
                  NSEGIN = NSEGIN + 1
                  IF (NSEGIN.GT.NSEGMAX) THEN
                     WRITE(IOUT,FMT=6004) NSEGMAX
                     IF (ONLINE) WRITE(ITOUT,FMT=6004) NSEGMAX
                     GOTO 20
                  END IF
                  CPHIST(NSEGIN) = PHIST(I)
                  CPHIFI(NSEGIN) = PHIFIN(I)
                  ICRUN(NSEGIN) = JRUN
C     
C---- Only want one segment, set increment to entire phi range
C     
                  CPHIINC(NSEGIN) = PHIFIN(I) - PHIST(I)
                  PHITOT = PHITOT + (PHIFIN(I)-PHIST(I))
                  IF (DEBUG(57)) THEN
                     WRITE(IOUT,FMT=6162) NSEGIN,JRUN,
     +                    CPHIST(NSEGIN),CPHIFI(NSEGIN),CPHIINC(NSEGIN)
                     IF (ONLINE) WRITE(ITOUT,FMT=6162) NSEGIN,JRUN,
     +                    CPHIST(NSEGIN),CPHIFI(NSEGIN),CPHIINC(NSEGIN)
 6162                FORMAT(1X,'Set up segment',I3,' for run',I3,
     +                    ' start phi',F6.1,'  end phi',F6.1,
     +                    '  increment',F5.1)
                  END IF
               END IF
 380        CONTINUE
 390     CONTINUE
      END IF
C     
C---- NSEGIN.... Total number of segments, both from initial runs (if any)
C     plus the number of segments in AUTO search
C     NSEGSTART. Segment number for the first of the AUTO segments
C     NSEGAUTO.. Number of AUTO segments
C     
      NSEGSTART = NSEGIN + 1
      NSEGIN = NSEGIN + NSEGAUTO
      ICOMB = 0
C     
C---- If rotation angle for AUTO has not been assigned, set it to the
C     angle required for complete data for this Laue group minus the
C     total rotation angle of previous runs
C     
      IF (ROTAUTO.EQ.0) ROTAUTO = PHILAUE - PHITOT
C     
C---- Set up the rotation angle for each AUTO segment
C     Try initially to make them all equal
C     
      AUTOINC = 1.0
C     
      IF (.not. SIZESET) then
C     
         X = ROTAUTO/REAL(NSEGAUTO)
         I = NINT(X/AUTOINC)
         IF (ABS(I*AUTOINC-X).GT.0.1) THEN
C     
C---- Cannot divide them up equally
C     set first segment to nearest number of "steps"
C     
            PHISEGA(1) = I*AUTOINC
            X = (ROTAUTO-PHISEGA(1))/REAL(NSEGAUTO-1)
            I = NINT(X/AUTOINC)
            IF (ABS(I*AUTOINC-X).GT.0.1) THEN
C     
C---- Cannot divide remaining rotation equally, set the second segment
C     
               PHISEGA(2) = I*AUTOINC
               X = (ROTAUTO-PHISEGA(1)-PHISEGA(2))/REAL(NSEGAUTO-2)
               I = NINT(X/AUTOINC)
               PHISEGA(3) = I*AUTOINC
               PHISEGA(4) = (ROTAUTO - PHISEGA(1)-
     +              PHISEGA(2)-PHISEGA(3))
            ELSE
               DO 430 ISEG = 2,NSEGAUTO
                  PHISEGA(ISEG) = I*AUTOINC
 430           end do
            END IF
         ELSE           
            DO 432 ISEG = 1,NSEGAUTO
               PHISEGA(ISEG) = I*AUTOINC
 432        end do
         END IF

      end if

 434  continue
      IF (DEBUG(57)) THEN
         WRITE(IOUT,FMT=6150) NSEGAUTO,(PHISEGA(I),I=1,NSEGAUTO)
         IF (ONLINE) WRITE(ITOUT,FMT=6150) NSEGAUTO,
     +        (PHISEGA(I),I=1,NSEGAUTO)
 6150    FORMAT(1X,'The segment widths for the',I2,' AUTO segments',
     +        ' are:',/,1X,10F6.1)
      END IF
C     
C---- PHIFINAL is the end of the AUTO generated phi range
C     
      PHIFINAL = PHIFIN(NSEGM)
C     
C---- PHISTAUTO is the start of the AUTO generated phi range
C     
      PHISTAUTO = PHIST(NSEGM)
      PHIADDAUTO = PHIADD(NSEGM)
      PCMAX = 0.0
C     
 400  CONTINUE
C     
      IF (WINOPEN) CALL MXD_FLU(I)
      ICOMB = ICOMB + 1
      IF (ICOMB.EQ.1) THEN
         DO 402 ISEG = 1,NSEGAUTO      
            IF (ISEG.EQ.1) THEN
               CPHIST(NSEGSTART) = PHISTAUTO
               CPHIFI(NSEGSTART) = PHISTAUTO + PHISEGA(ISEG)
               CPHIADD(NSEGSTART) = PHIADDAUTO
               ICRUN(NSEGSTART) = NSTRUN
            ELSE
               CPHIST(NSEGSTART+ISEG-1) =  CPHIFI(NSEGSTART+ISEG-2)
               CPHIFI(NSEGSTART+ISEG-1) = CPHIST(NSEGSTART+ISEG-1) + 
     +              PHISEGA(ISEG)
               CPHIADD(NSEGSTART+ISEG-1) =  PHIADDAUTO
               ICRUN(NSEGSTART+ISEG-1) = NSTRUN
            END IF
 402     CONTINUE
         IF (DEBUG(57)) THEN
            WRITE(IOUT,FMT=6164) ICOMB,NSEGSTART,NSEGIN,PHISTAUTO,
     +           PHIFINAL,PHIADDAUTO,(CPHIST(I),I=NSEGSTART,NSEGIN)
            IF (ONLINE) WRITE(ITOUT,FMT=6164) ICOMB,NSEGSTART,NSEGIN,
     +           PHISTAUTO,PHIFINAL,PHIADDAUTO,
     +           (CPHIST(I),I=NSEGSTART,NSEGIN)
         END IF
 6164    FORMAT(//1X,'ICOMB ',I5,'  NSEGSTART',I3,' NSEGIN',I3,
     +        ' PHISTAUTO',F7.1,' PHIFINAL',F7.1,' PHIADDAUTO',F7.1,
     +        ' Phi start values',/,(1X,10F6.1))
      ELSE
C     
C---- Set up phi values for next combination of AUTO generated runs
C     Increment the start angle of the LAST segment by PHIINC(NSEGM)
C     (since the AUTO must always be the last segment to be input) and check
C     that the end of the last segment is within the allowed phi
C     range. If it goes beyond it, then increment the last but one
C     auto segment and try again, and so on until all possible combinations
C     have been tried.
C     
         DO 412 I = 1,NSEGAUTO
            CPHIST(NSEGIN-I+1) = CPHIST(NSEGIN-I+1) + PHIINC(NSEGM)
            CPHIFI(NSEGIN-I+1) = CPHIST(NSEGIN-I+1) + 
     +           PHISEGA(NSEGAUTO-I+1)
            IF (I.ne.1) then
C     
C---- If I>1, this is because incrementing just the last segment took
C     phi beyond the allowed range. Now an earlier segment has been
C     incremented, and all following segments must be reset to their
C     starting positions. This is done below.
               
C     
               DO 406 J = NSEGIN-(I-2),NSEGIN
                  CPHIST(J) = CPHIST(J-1) + PHISEGA(J-NSEGSTART)
                  CPHIFI(J) = CPHIST(J) + PHISEGA(J-NSEGSTART+1)
 406           end do
C     
C---- See if end of last segment is within range
C     
            end if
c     this must have been a goto target
 408        continue

            IF (DEBUG(57)) THEN
               WRITE(IOUT,FMT=6164) ICOMB,NSEGSTART,NSEGIN,PHISTAUTO,
     +              PHIFINAL,PHIADDAUTO,(CPHIST(J),J=NSEGSTART,NSEGIN)
               IF (ONLINE) WRITE(ITOUT,FMT=6164) ICOMB,NSEGSTART,
     +              NSEGIN, PHISTAUTO,PHIFINAL,PHIADDAUTO,
     +              (CPHIST(J),J=NSEGSTART,NSEGIN)
            END IF
c     have to have this goto as there is no way to break
c     fortran loops...
            IF ((CPHIST(NSEGIN)+PHISEGA(NSEGAUTO)).LE.PHIFINAL) 
     +           GOTO 414
 412     end do
C     
C---- No other possible segments
C     
         LAST = .TRUE.
         IF (AUTANOM) THEN
c     
c---- added so that we can have a TESTGEN line on the Strategy line
c     
            IF(TESTRAT)THEN
               AUTO = .false.
               testgen = .true.
               phstart = PHSBEST(1)-360*ISTRUN-PHIADDAUTO
               phend = PHSBEST(1)+PHISEGA(1)-360*ISTRUN-PHIADDAUTO
               if(xover(1).lt.-1)xover(1) = 10.0
            endif
            if(socklo .and. .not. testrat) then

c     trying this with some happy dna xml.

 6254          format('<?xml version="1.0"?>',
     +              '<           !DOCTYPE strategy_response>',
     $              '<strategy_response><status><code>ok</code>',
     $              '</status>',
     $              '<completeness><anomolous>', F4.1, '</anomolous>',
     $              '</completeness>',
     $              '<stepsize>', F4.1, '</stepsize>')
               
 6255          format('<?xml version="1.0"?>',
     +              '<!DOCTYPE strategy_response>',
     $              '<strategy_response><status><code>ok</code>',
     $              '</status>',
     $              '<completeness><standard>', F4.1, '</standard>',
     $              '</completeness>',
     $              '<stepsize>', F4.1, '</stepsize>')

 6256          format('<segment><oscillation_sequence><start>', 
     $              F5.1, '</start><end>', 
     $              F5.1, '</end></oscillation_sequence></segment>')

               xmlline3 = ' '
               write(xmlline3, fmt = 6254) pcmax, phiinci
               call write_socket_section(serverfd, lenstr(xmlline3), 
     $              xmlline3)

               do i = 1, nsegauto
                  xmlline2 = ' '
                  write(xmlline2, fmt = 6256) 
     +                 phsbest(i) - 360 * istrun -
     $                 phiaddauto, phsbest(i) + phisega(i) - 
     +                 360 * istrun
     $                 -phiaddauto
                  call write_socket_section(serverfd, 
     +                 lenstr(xmlline2), xmlline2)
               end do
               xmlline3 = '</strategy_response>'
               call write_socket_length(serverfd, lenstr(xmlline3), 
     $              xmlline3)
               

            ENDIF

c     dna bits....

 911        format('strategy_segment_', i1)
 912        format('strategy_segment_', i2)

            do i = 1, nsegauto
               if(i .lt. 10) then
                  write(dnahs, 911) i
               else
                  write(dnahs, 912) i
               end if
               
               call dna_output_table_start(dnahs(1:lenstr(dnahs)))
               call dna_output_list_start('segment')
               call dna_output_real_item('anomolous_completeness', 
     +              pcmax)
               call dna_output_real_item('phi_start',
     +              phsbest(i) - 360*istrun - phiaddauto)
               call dna_output_real_item('phi_end', 
     +              phsbest(i) + phisega(i) - 360 * 
     +              istrun - phiaddauto)
               call dna_output_list_end
               call dna_output_table_end
            end do


            WRITE(IOUT,FMT=6141) PCMAX,(PHSBEST(I)-360*ISTRUN-
     +           PHIADDAUTO,
     +           PHSBEST(I)+PHISEGA(I)-360*ISTRUN-PHIADDAUTO,
     +           I = 1,NSEGAUTO)
            IF (ONLINE) WRITE(ITOUT,FMT=6141) PCMAX,
     +           (PHSBEST(I)-360*ISTRUN
     +           -PHIADDAUTO,PHSBEST(I)+PHISEGA(I)-360*ISTRUN-
     +           PHIADDAUTO, I = 1,NSEGAUTO)
            IF (WINOPEN) THEN
               LINE = ' '
               WRITE(LINE,FMT=6240) PCMAX
 6240          FORMAT('Optimum rotation gives',F6.1,'% of anomalous',
     +              ' pairs.')
               CALL MXDWIO(LINE,1)
               LINE = ' '
               WRITE(LINE,FMT=6242)
 6242          FORMAT('This corresponds to the following ',
     +              'rotation range(s) .')
               CALL MXDWIO(LINE,1)
               DO 440 I = 1,NSEGAUTO
                  LINE = ' '
                  WRITE(LINE,FMT=6244) PHSBEST(I)-360*ISTRUN-
     +                 PHIADDAUTO,
     +                 PHSBEST(I)+PHISEGA(I)-360*ISTRUN-PHIADDAUTO
 6244             FORMAT('From ',F6.1,' to',F6.1,' degrees')
                  CALL MXDWIO(LINE,1)
 440           end do
               LINE = ' '
               WRITE(LINE,FMT=6246)
 6246          FORMAT('Type "STATS" at prompt for full statistics.')
               CALL MXDWIO(LINE,3)
            END IF
         ELSE
c     
c---- added so that we can have a TESTGEN line on the Strategy line
c     
            IF(TESTRAT)THEN
               AUTO = .false.
               testgen = .true.
               phstart = PHSBEST(1)-360*ISTRUN-PHIADDAUTO
               phend = PHSBEST(1)+PHISEGA(1)-360*ISTRUN-PHIADDAUTO
               if(xover(1).lt.-1) xover(1) = 10.0
            endif

            do i = 1, nsegauto
               if(i .lt. 10) then
                  write(dnahs, 911) i
               else
                  write(dnahs, 912) i
               end if
               
               call dna_output_table_start(dnahs(1:lenstr(dnahs)))
               call dna_output_list_start('segment')
               call dna_output_real_item('standard_completeness', 
     +              pcmax)
               call dna_output_real_item('phi_start',
     +              phsbest(i) - 360*istrun - phiaddauto)
               call dna_output_real_item('phi_end', 
     +              phsbest(i) + phisega(i) - 360 * 
     +              istrun - phiaddauto)
               call dna_output_list_end
               call dna_output_table_end
            end do



            WRITE(IOUT,FMT=6140) PCMAX,(PHSBEST(I)-360*ISTRUN-
     +           PHIADDAUTO,
     +           PHSBEST(I)+PHISEGA(I)-360*ISTRUN-PHIADDAUTO,
     +           I = 1,NSEGAUTO)
            IF (ONLINE) WRITE(ITOUT,FMT=6140) PCMAX,
     +           (PHSBEST(I)-360*ISTRUN
     +           -PHIADDAUTO,PHSBEST(I)+PHISEGA(I)-360*ISTRUN-
     +           PHIADDAUTO,
     +           I = 1,NSEGAUTO)

            if(socklo .and. .not. testrat) then
               xmlline3 = ' '
               write(xmlline3, fmt = 6255) pcmax, phiinci
               call write_socket_section(serverfd, lenstr(xmlline3), 
     $              xmlline3)

               do i = 1, nsegauto
                  xmlline2 = ' '
                  write(xmlline2, fmt = 6256) phsbest(i) - 
     +                 360 * istrun -
     $                 phiaddauto, phsbest(i) + phisega(i) - 
     +                 360 * istrun
     $                 -phiaddauto
                  call write_socket_section(serverfd, 
     +                 lenstr(xmlline2), xmlline2)
               end do
               xmlline3 = '</strategy_response>'
               call write_socket_length(serverfd, lenstr(xmlline3), 
     $              xmlline3)
               

            ENDIF
            IF (WINOPEN) THEN
               LINE = ' '
               WRITE(LINE,FMT=6220) PCMAX
 6220          FORMAT('Optimum rotation gives',F6.1,'% of unique',
     +              ' data.')
               CALL MXDWIO(LINE,1)
               LINE = ' '
               WRITE(LINE,FMT=6222)
 6222          FORMAT('This corresponds to the following ',
     +              'rotation range(s):')
               CALL MXDWIO(LINE,1)
               DO 442 I = 1,NSEGAUTO
                  LINE = ' '
                  WRITE(LINE,FMT=6224) PHSBEST(I)-360*ISTRUN-
     +                 PHIADDAUTO,
     +                 PHSBEST(I)+PHISEGA(I)-360*ISTRUN-PHIADDAUTO
 6224             FORMAT('From ',F6.1,' to',F6.1,' degrees')
                  CALL MXDWIO(LINE,1)
 442           CONTINUE
               LINE = ' '
               WRITE(LINE,FMT=6246)
               CALL MXDWIO(LINE,3)
            END IF
         END IF
         WRITE (IOUT,FMT=6143)
         IF (ONLINE) WRITE (ITOUT,FMT=6143)
 6140    FORMAT(//,1X,'Optimum rotation gives',F6.1,'% of unique',
     +        ' data',/,1X,'This corresponds to the following ',
     +        'rotation range(s):',/,
     +        (1X,'From ',F6.1,' to',F6.1,' degrees'))
 6141    FORMAT(//,1X,'Optimum rotation gives',F6.1,'% of anomalous',
     +        ' pairs',/,1X,'This corresponds to the following ',
     +        'rotation range(s):',/,
     +        (1X,'From ',F6.1,' to',F6.1,' degrees'))
 6143    FORMAT(1X,'Type "STATS" for full statistics.')
C     
C---- Set up these angles to get full statistics if more than one
C     run has been made
C     
         I = 0
         DO 413 ISEG = NSEGSTART,NSEGIN
            I = I + 1
            CPHIST(ISEG) = PHSBEST(I)
            CPHIFI(ISEG) = CPHIST(ISEG) + PHISEGA(I)
 413     end do
         IF (ICOMB.EQ.2) THEN
            AUTO = .FALSE.
            LAST = .FALSE.
            WRITE(IOUT,FMT=6080)
            IF (ONLINE) WRITE(ITOUT,FMT=6080)
            WRITE(IOUT,FMT=6081)
            IF (ONLINE) WRITE(ITOUT,FMT=6081)
            IF (WINOPEN) THEN
               WRITE(IOLINE,FMT=6081)
               CALL WINDIO(NULINE)
            END IF
c     go to read input
            GOTO 16
         END IF
         GOTO 414
      END IF
C     
C---- Set up
C     
C     
C---- Modify phi values to reflect run number
C     
 414  continue
      IF (DEBUG(57)) THEN
         WRITE(IOUT,FMT=6170) (CPHIST(ISEG),CPHIFI(ISEG),
     +        ISEG=1,NSEGIN)
         IF (ONLINE) WRITE(ITOUT,FMT=6170) (CPHIST(ISEG),
     +        CPHIFI(ISEG),ISEG=1,NSEGIN)
 6170    FORMAT(1X,'Start and end values for the segments ',
     +        'to be tested',
     +        /,(1X,2F6.0))
      END IF
      DO 420 ISEG = NSEGSTART,NSEGIN
C     AL        IF (IRUN.EQ.0) IRUN = 1
C     AL        CPHIST(ISEG) = CPHIST(ISEG) + 360.0*(IRUN-1)
C     AL        CPHIFI(ISEG) = CPHIFI(ISEG) + 360.0*(IRUN-1)
C     
C---- Find which of the original input segments this corresponds to
C     
C---- Find which of the original input segments this corresponds to
C     and check that it is a valid segment (ie one originally generated)
C     
         IFSEG = 0
         DO 418 I = 1,NSEGM
            IF ((CPHIST(ISEG).GE.PHIST(I)).AND.
     +           (CPHIFI(ISEG).LE.PHIFIN(I)).AND.
     +           (IFIRST(ISEG).EQ.IFIRSTONE(I))) THEN
               IFSEG = I
            END IF
 418     end do
         IF (IFSEG.EQ.0) THEN
            WRITE(IOUT,FMT=6008)
            IF (ONLINE) WRITE(ITOUT,FMT=6008)
            IF (WINOPEN) THEN
               LINE = ' '
               WRITE(LINE,FMT=6260)
               CALL MXDWIO(LINE,1)
               LINE = ' '
               WRITE(LINE,FMT=6262)
               CALL MXDWIO(LINE,1)
            END IF
            IF (AUTO) AUTO = .FALSE.
            GOTO 16
         END IF
         CPHIINC(ISEG) = PHIINC(IFSEG)
C     AL        WRITE(6,*),'This is new,old segment,inc',ISEG,IFSEG,
C     AL     +                 CPHIINC(ISEG)
 420  end do
C     
C---- Initialise
C     
 2    NPACK = 0
      IF (.NOT.AUTO) NSEGIN = 0      
      NUNIANOT = 0
      NIN1 = 0
      NUNI = 0
      NRESO = 0
      NEXTRA = 0
      NIN = 0
      NANOMT = 0
      ICLEAR = 1
      DO 4 I = 1,NRESBIN
         NUNIRES(I) = 0
         NUNIANO(I) = 0
         NANOM(I) = 0
         NTOTRES(I) = 0
 4    end do
      DO 10 I = 1,MAXPAX
         NTOT(I) = 0
         NUNIQA(I) = 0
         DO 6 J = 1,NRESBIN
            NOBSRES(I,J) = 0
 6       end do
         DO 8 J = 1,MULTMAX
            NTIMES(I,J) = 0
 8       end do
 10   end do
      DO 12 I = 1,MAXDIFF+1
         JPACK(I,1) = 0
         JPACK(I,2) = 0
 12   end do
      DO 14 I = 1,NSEGMAX
         IFIRST(I) = 0
         IPKST(I) = 0
         IPKFI(I) = MAXPAX
 14   end do
C     
c     target 20 is call complete_engine - this is where all of the 
c     actual calculations are performed => the limits must have 
c     been determined in rotate
      IF (AUTO) GOTO 20
C     
      IF (RESET) THEN
         RESET = .FALSE.
         GOTO 15
      END IF
      WRITE(IOUT,FMT=6000)
      IF (ONLINE) WRITE(ITOUT,FMT=6000)
      IF (ONLINE) WRITE(ITOUT,FMT=6001)
 6000 FORMAT(//1X,'COMPLETE option',/,1X,'===============')
 6001 FORMAT(1X,'Give the segments of data to be tested, in the form:',
     +     /,1X,'START 0 END 20 (RUN 1)',/,1X,'(The RUN keyword is',
     +     ' required if more than one run of the STRATEGY',/,1X,
     +     'option has been given)',/,1X,'Alternatively, RUN 1 will',
     +     ' include all the data from the first run.',/,1X,
     +     'Give all the desired',
     +     ' segments, then give RUN or GO keyword',/,1X,'To exit',
     +     ' give keyword EXIT',/,1X,'To get full statistics',
     +     ' after every run type STATS ON (cancel with STATS OFF)')
      IF (WINOPEN) THEN
         LINE = ' '
         WRITE(LINE,FMT=6280)
 6280    FORMAT('Give the segments of data to be tested, in the form:')
         CALL MXDWIO(LINE,1)
         LINE = ' '
         WRITE(LINE,FMT=6282)
 6282    FORMAT('START 0 END 20 (RUN 1)')
         CALL MXDWIO(LINE,1)
         LINE = ' '
         WRITE(LINE,FMT=6284)
 6284    FORMAT('(The RUN keyword is',
     +        ' required if more than one part has been generated)')
         CALL MXDWIO(LINE,1)
         LINE = ' '
         WRITE(LINE,FMT=6286)
 6286    FORMAT('Alternatively, RUN 1 will',
     +        ' include all the data from the first run')
         CALL MXDWIO(LINE,1)
         LINE = ' '
         WRITE(LINE,FMT=6288)
 6288    FORMAT('Give all the desired',
     +        ' segments, then give RUN or GO keyword')
         CALL MXDWIO(LINE,1)
         LINE = ' '
         WRITE(LINE,FMT=6290)
 6290    FORMAT('Type STATS ON to get full statistics (OFF to cancel)')
         CALL MXDWIO(LINE,3)
      END IF

c     this is no longer relevant, since the `guts' of the routine
c     have been moved to a separate subroutine

      if(autocomplete) then
c     copy input from common blocks??
      else
c     read in keyworded input ...
      end if

 16   IF (ONLINE) WRITE (ITOUT,FMT=6007)
 6007 FORMAT (1X,'STRATEGY => ',$)
c     
c---- to fool the program if this is a STRATEGY TESTGEN run
c     

c     gw this hack will no longer be needed when I'm finished :o)
c     further, I think taht I'd like to get the statistics out too,
c     which would mean an autostat thing too....

      if(testrat)then
         key='TEST'
         ntok = 1
      else
C     
         IF (WINOPEN) THEN
            IF ((IOERR).OR.(INERR)) THEN
               LINE = ' '
               WRITE(LINE,FMT=6230)
 6230          FORMAT('Error in input, please repeat.')
               CALL MXDWIO(LINE,2)
            END IF
            LINE = ' '
            WRITE(LINE,FMT=6232)
 6232       FORMAT('STRATEGY => ')
            CALL MXDWIO(LINE,0)
            CALL MXDRIO(LINE)
            NCH = LENSTR(LINE)
            IF (NCH.GT.0) THEN
               WRITE(IOUT,FMT=6234) LINE(1:NCH)
               IF (ONLINE) WRITE(ITOUT,FMT=6234) LINE(1:NCH)
            END IF
 6234       FORMAT(1X,'STRATEGY => ',A)
C     
C---- Decode this line.
C     
C     ******************************************
            CALL MPARSE(LINE,IBEG,IEND,ITYP,VALUE,IDEC,NTOK)
C     ******************************************
            IF (NTOK.EQ.0) GOTO 16
            GOTO 450
         END IF        

C     
C---- Read next keyword
C     
C     ******************************************************
         CALL MPARSER(ITIN,IOUT,LINE,IBEG,IEND,ITYP,VALUE,
     $        IDEC,NTOK)
C     ******************************************************
      endif
C     
C---- eof ?
C     
 450  INERR = .FALSE.
      IF (NTOK.EQ.-1) THEN
         IF (COMREAD) THEN
            COMREAD = .FALSE.
            ITIN = ITINS
C     CLOSE (UNIT=ICOMM)
         END IF
         WRITE(IOUT,FMT=6080)
         IF (ONLINE) WRITE(ITOUT,FMT=6080)
         STRATEGY = .FALSE.
         NSTRUN = 0
         NSEGM = 0
         FIRSTRAT = .TRUE.
         NSTRAT = 0
         NLAST = 1
         NNPACKS = 0
         NLASTPACK = 1
         ISTRUN = 0
         IF (SHRUNK) THEN
            SHRUNK = .FALSE.
            DO 38 I = 1,3
               CELL(I) = CELL(I)*CELLSCAL
 38         CONTINUE
            IMAT = 1
            IUMAT = 0
            ICELL = 1
            ICHECK = 0
            CALL SETMAT(IMAT,IUMAT,ICELL,ICHECK)
            WRITE(IOUT,FMT=6078) CELL
            IF (ONLINE) WRITE(ITOUT,FMT=6078) CELL
         END IF
         RETURN
      ELSE IF (NTOK.EQ.0) THEN
         GOTO 16
      END IF
C     
      IF (COMREAD) WRITE (ITOUT,FMT=6002) LINE(1:MIN(IEND(NTOK),120))
 6002 FORMAT (1X,'STRATEGY => ',A)
C     
C     
C---- first 4 chars
C     
      KEY = LINE(IBEG(1) :IEND(1))
C     
C---- convert to upper case
C     
C     ***********
      CALL CCPUPC(KEY)
C     ***********
C---- If statistics have been accumulated, and not printed, and this
C     is not a request for statistics, reset arrays
C     
      IF ((ICLEAR.EQ.0).AND.(IMODE.NE.3).AND.KEY.NE.'STAT') THEN
         RESET = .TRUE.
         GOTO 2
      END IF
 15   IF (KEY.EQ.'STAR') THEN
         INERR = .FALSE.
         IF (IMODE.NE.3) IMODE = 0
         NSEGIN = NSEGIN + 1
         IF (NSEGIN.GT.NSEGMAX) THEN
            WRITE(IOUT,FMT=6004) NSEGMAX
            IF (ONLINE) WRITE(ITOUT,FMT=6004) NSEGMAX
 6004       FORMAT(//,1X,'***** FATAL ERROR *****',/,1X,
     +           'Only',I5,' segments allowed in STRATEGY option')
            GOTO 20
         END IF
         ISTA = 0
         IFIN = 0
         JRUN = 0
         TESTGEN = .FALSE.
         CPHIINC(NSEGIN) = 0.0
C     
C---- Reset ETA in case it has been read in by MOSAIC keyword for
C     a TESTGEN run
C     
         ETA = 0.00000001
         ICOUNT = 2
C     *******************************************
         CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     *******************************************
         IF (IOERR) INERR = .TRUE.
         CPHIST(NSEGIN) = VALUE(ICOUNT)
         ISTA = 1
 18      ICOUNT = ICOUNT + 1
         IF (ICOUNT.GT.NTOK) GOTO 460
         SUBKEY = LINE(IBEG(ICOUNT):IEND(ICOUNT))
C     **************
         CALL CCPUPC(SUBKEY)
C     **************
         IF (SUBKEY.EQ.'END') THEN
            ICOUNT = ICOUNT + 1
C     
C     ************************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************************        
            IF (IOERR) INERR = .TRUE.
            CPHIFI(NSEGIN) = VALUE(ICOUNT) 
            IFIN = 1
         ELSE IF (SUBKEY.EQ.'STEP') THEN
            ICOUNT = ICOUNT + 1
C     
C     ************************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************************        
            IF (IOERR) INERR = .TRUE.
            CPHIINC(NSEGIN) = ABS(VALUE(ICOUNT))
C     
C---- RUN
C     
         ELSE IF ((SUBKEY.EQ.'RUN').OR.(SUBKEY.EQ.'PART')) THEN
            ICOUNT = ICOUNT + 1
C     
C     ************************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************************        
            IF (IOERR) INERR = .TRUE.
            JRUN = 1
            IRUN = ABS(VALUE(ICOUNT))
            ICRUN(NSEGIN) = IRUN
C     
C     Not recognised
C     
         ELSE
            INERR = .TRUE.
            WRITE (IOUT,FMT=6006) SUBKEY
            IF (ONLINE) WRITE (ITOUT,FMT=6006) SUBKEY
 6006       FORMAT (//1X,'********** Sub-keyword NOT Recognised:',A)
         END IF
         IF (ICOUNT.LT.NTOK) GOTO 18
C     
C---  Check both START and END given
C     
 460     IF (INERR) THEN
            WRITE(IOUT,FMT=6118)
            IF (ONLINE) WRITE(ITOUT,FMT=6118)
 6118       FORMAT(1X,'*** Because there was an input ',
     +           'error, the whole',
     +           ' line has been ignored ***')
            LINE = ' '
            NSEGIN = NSEGIN -1
            GOTO 16
         END IF
         IF ((ISTA.NE.1).OR.(IFIN.NE.1)) THEN
            WRITE(IOUT,FMT=6003)
            IF (ONLINE) WRITE(ITOUT,FMT=6003)
 6003       FORMAT(1X,'***** ERROR *****',/,1X,
     +           'Must enter both START and END values')
            IF (WINOPEN) THEN
               LINE = ' '
               WRITE(LINE,FMT=6121)
 6121          FORMAT('Must give both START and END, please repeat.')
               CALL MXDWIO(LINE,2)
            END IF
            NSEGIN = NSEGIN - 1
            GOTO 16
         END IF
C     
C---- Test RUN number given, if there only is one run then set up ICRUN
C     else give warning
C     
         IF (JRUN.EQ.0) THEN
            IF (NSTRUN.GT.1) THEN
               WRITE(IOUT,FMT=6120)
               IF (ONLINE) WRITE(ITOUT,FMT=6120)
 6120          FORMAT(1X,'***** ERROR *****',/,1X,
     +              'Must specify the RUN number for this phi range')
               IF (WINOPEN) THEN
                  LINE = ' '
                  WRITE(LINE,FMT=6123)
 6123             FORMAT('Must specify the RUN number for ',
     +                 'this phi range')
                  CALL MXDWIO(LINE,2)
               END IF
               NSEGIN = NSEGIN - 1
               GOTO 16
            ELSE
               DO 17 I = 1,NSEGIN
                  ICRUN(I) = 1
 17            CONTINUE
            END IF
         END IF
C     
C---- Modify phi values to reflect run number
C     
         IF (IRUN.EQ.0) IRUN = 1
         CPHIST(NSEGIN) = CPHIST(NSEGIN) + 360.0*(IRUN-1)
         CPHIFI(NSEGIN) = CPHIFI(NSEGIN) + 360.0*(IRUN-1)
C     
C---- Find which of the original input segments this corresponds to
C     and check that it is a valid segment (ie one originally generated)
C     
         IFSEG = 0
         DO 19 I = 1,NSEGM
            IF (DEBUG(57)) THEN
               WRITE(IOUT,FMT=6310) I,NSEGIN,CPHIST(NSEGIN),
     +              CPHIFI(NSEGIN),PHIST(I),PHIFIN(I),PHIADD(I)
               IF (ONLINE) WRITE(ITOUT,FMT=6310) I,NSEGIN,
     +              CPHIST(NSEGIN),CPHIFI(NSEGIN),PHIST(I),
     +              PHIFIN(I),PHIADD(I)
 6310          FORMAT(1X, 'SEGMENT,NSEG',2I5,' CPHIST, CPHIFIN,',
     +              'PHIST,FIN,PHIADD',5F10.2)
            END IF
            IF ((CPHIST(NSEGIN).GE.PHIST(I)-PHIADD(I)).AND.
     +           (CPHIFI(NSEGIN).LE.PHIFIN(I)-PHIADD(I)).AND.
     +           (IFIRST(NSEGIN).EQ.IFIRSTONE(I))) THEN
               IFSEG = I
               CPHIST(NSEGIN) = CPHIST(NSEGIN) + PHIADD(I)
               CPHIFI(NSEGIN) = CPHIFI(NSEGIN) + PHIADD(I)
               CPHIADD(NSEGIN) = PHIADD(I)
            END IF
 19      CONTINUE
         IF (IFSEG.EQ.0) THEN
            WRITE(IOUT,FMT=6008)
            IF (ONLINE) WRITE(ITOUT,FMT=6008)
 6008       FORMAT(1X,'***** ERROR *****',/,1X,
     +           'Cannot match this rotation range with any of the ',
     +           'generated segments',/,1X,'This will happen if the ',
     +           ' requested rotated range is greater than',
     +           /,1X,'that ',
     +           'generated by the original STRATEGY keywords',/,1X,
     +           'or if you have specified a phi range that was not',
     +           ' generated by the',/,1X,'original STRATEGY keyword')
            IF (WINOPEN) THEN
               LINE = ' '
               WRITE(LINE,FMT=6260)
 6260          FORMAT('*** ERROR in given phi range, try again ***')
               CALL MXDWIO(LINE,1) 
               LINE = ' '
               WRITE(LINE,FMT=6262)
 6262          FORMAT('(See terminal window for more information)')
               CALL MXDWIO(LINE,3)
            END IF
            NSEGIN = NSEGIN - 1
            IF (AUTO) AUTO = .FALSE.
            GOTO 16
         END IF

C---- Default segment size (for analysis) to 5 degrees

         IF (CPHIINC(NSEGIN).EQ.0) CPHIINC(NSEGIN) = 5.0

C---- DEBUG

      ELSE IF (KEY.EQ.'DEBU' ) THEN
         IF (NTOK.EQ.1) THEN
            DEBUG(56) = .TRUE.
            DEBUG(57) = .TRUE.
         ELSE
            DEBUG(56) = .FALSE.
            DEBUG(57) = .FALSE.
         END IF
C     
C     
C---- MOSAIC
C     
      ELSE IF (KEY.EQ.'MOSA' ) THEN
C     
C     ************************************
         CALL MKEYNM(1,2,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************
C     
         SETA = VALUE(2)
         SETA = 0.5*DTR*SETA
C     
C---- SEPAration x x
C     
      ELSE IF (KEY.EQ.'SEPA') THEN
C     
C     ************************************
         CALL MKEYNM(2,2,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************
C     
C---- Input in mms - stored as an integer in 10 microns units
C     
         IXSEP = NINT(VALUE(2)*100.0)
         IYSEP = NINT(VALUE(3)*100.0)
C     
C---- Convert spot separations (MINDTX,Y) into "ideal detector" coordinate
C     frame, as the spot coordinates (generate file coords) are in this frame
C     
         XSEP = ABS(IXSEP*COSOM0 + IYSEP*SINOM0)
         YSEP = ABS(IYSEP*COSOM0 + IXSEP*SINOM0)
         MINDTX = NINT(XSEP)
         MINDTY = NINT(YSEP)
C     
C---- STATISTICS
C     
      ELSE IF (KEY.EQ.'STAT') THEN
         IF (NTOK.EQ.2) THEN
            SUBKEY = LINE(IBEG(2):IEND(2))
C     **************
            CALL CCPUPC(SUBKEY)
C     **************
            IF (SUBKEY.EQ.'ON') THEN
               IMODE = 3
            ELSE IF (SUBKEY.EQ.'OFF') THEN
               IMODE = 0
            ELSE
               WRITE (IOUT,FMT=6006) SUBKEY
               IF (ONLINE) WRITE (ITOUT,FMT=6006) SUBKEY
            END IF
         ELSE 
            IF (NUNI.NE.0) THEN 
               IMODE = 1
               GOTO 280
            ELSE
               WRITE(IOUT,FMT=6100)
               IF (ONLINE) WRITE(ITOUT,FMT=6100)
 6100          FORMAT(1X,'No reflections have been predicted !!')
               GOTO 16
            END IF
         END IF
C     
C---- PART/RUN...Allow possibility of just giving PART/RUN number rather 
C     than START, END if all the run is to be included
C     
      ELSE IF (((KEY.EQ.'RUN').OR.(KEY.EQ.'PART'))
     +        .AND.(NTOK.GE.2)) THEN
         IF (IMODE.NE.3) IMODE = 0
         ISTA = 0
         IFIN = 0
         ICOUNT = 2
C     *******************************************
         CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     *******************************************
         IF (IOERR) THEN
            WRITE(IOUT,FMT=6118)
            IF (ONLINE) WRITE(ITOUT,FMT=6118)
            GOTO 16
         END IF
         JRUN = NINT(VALUE(ICOUNT))
         IF (JRUN.GT.NSTRUN) THEN
            WRITE(IOUT,FMT=6130) JRUN,NSTRUN
            IF (ONLINE) WRITE(ITOUT,FMT=6130) JRUN,NSTRUN
 6130       FORMAT(1X,'*** ERROR *** You have asked for part',I3,
     +           ' but there are only',I3,' parts')
            GOTO 16
         END IF
C     
C---- Check for presence of STEP keyword
C     
         IF (NTOK.GT.2) THEN
            ICOUNT = ICOUNT + 1
            SUBKEY = LINE(IBEG(ICOUNT):IEND(ICOUNT))
C     **************
            CALL CCPUPC(SUBKEY)
C     **************
            IF (SUBKEY.EQ.'STEP') THEN
               ICOUNT = ICOUNT + 1
C     
C     ************************************************
               CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************************        
               IF (IOERR) THEN
                  GOTO 16
               END IF
               PHIINCR = ABS(VALUE(ICOUNT))
C     
C     Not recognised
C     
            ELSE
               INERR = .TRUE.
               WRITE (IOUT,FMT=6006) SUBKEY
               IF (ONLINE) WRITE (ITOUT,FMT=6006) SUBKEY
               GOTO 16
            END IF
         END IF
C     
C---- Find which of the currently stored segments belong to this run,
C     using the fact that the phi values have multiples of 360 added for
C     different runs
C     
         IF (PHIINCR.EQ.0) PHIINCR = 5.0
C     
         DO 30 I = 1,NSEGM
            IRUN = NINT(PHIST(I))/360 + 1
            IF (IRUN.EQ.JRUN) THEN
               NSEGIN = NSEGIN + 1
               IF (NSEGIN.GT.NSEGMAX) THEN
                  WRITE(IOUT,FMT=6004) NSEGMAX
                  IF (ONLINE) WRITE(ITOUT,FMT=6004) NSEGMAX
                  GOTO 20
               END IF
               CPHIST(NSEGIN) = PHIST(I)
               CPHIFI(NSEGIN) = PHIFIN(I)
               CPHIINC(NSEGIN) = PHIINC(I)
               ICRUN(NSEGIN) = JRUN
            END IF
 30      CONTINUE


C     
C---- AUTO
C     
      ELSE IF ((KEY(1:2).EQ.'AU').OR.(KEY(1:2).EQ.'RO')) THEN
C     
C---- Turn OFF statistics
C     
         IMODE = 0
         AUTO = .TRUE.
         ICOUNT = 1
         IROT = 0
         ISEG = 0
         ISIZE = 0
         SIZESET = .FALSE.
         IF (NTOK.EQ.1) GOTO 33
         IF (KEY(1:2).EQ.'RO') THEN
            SUBKEY = KEY
            GOTO 470
         END IF
 32      ICOUNT = ICOUNT + 1
         SUBKEY = LINE(IBEG(ICOUNT):IEND(ICOUNT))
C     **************
         CALL CCPUPC(SUBKEY)
C     **************
C     
C---- ROTATE (AUTO MODE)
C     
 470     IF (SUBKEY(1:2).EQ.'RO') THEN
C     
            IROT = 1
            ICOUNT = ICOUNT + 1
C     ************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************
            IF (IOERR) INERR = .TRUE.
            ROTAUTO = NINT(VALUE(ICOUNT))
C     
C---- SEGMENTS (AUTO MODE)
C     
         ELSE IF (SUBKEY(1:2).EQ.'SE') THEN
C     
            ISEG = 1
            ICOUNT = ICOUNT + 1
C     ************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************
            IF (IOERR) INERR = .TRUE.
            NSEGAUTO = NINT(VALUE(ICOUNT))
C     
C---- SIZES of SEGMENTS (AUTO MODE)
C     
         ELSE IF (SUBKEY(1:2).EQ.'SI') THEN
C     
            SIZESET = .TRUE.
 31         ISIZE = ISIZE + 1
            ICOUNT = ICOUNT + 1
C     ************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************
            IF (IOERR) INERR = .TRUE.
            PHISEGA(ISIZE) = NINT(VALUE(ICOUNT))
            IF (ICOUNT.LT.NTOK) THEN
               IF (ITYP(ICOUNT+1).EQ.2) GOTO 31
            END IF
C     
C---- ANOM (Maximise anomalous pairs)
C     
         ELSE IF (SUBKEY(1:2).EQ.'AN') THEN
            AUTANOM = .TRUE.
C     
C---- Turn off anomalous optimisation
C     
         ELSE IF (SUBKEY.EQ.'NOTA') THEN
            AUTANOM = .FALSE.
C     
C     Not recognised
C     
         ELSE
            INERR = .TRUE.
            WRITE (IOUT,FMT=6006) SUBKEY
            IF (ONLINE) WRITE (ITOUT,FMT=6006) SUBKEY
         END IF
         IF (ICOUNT.LT.NTOK) GOTO 32
 33      IF (INERR) THEN
            WRITE(IOUT,FMT=6118)
            IF (ONLINE) WRITE(ITOUT,FMT=6118)
            AUTO = .FALSE.
            GOTO 16
         END IF
C     
C     
C---- Check that  ROTATE  subkeyword has been given
C     
         IF ((IROT.EQ.0).AND.(.NOT.SIZESET)) THEN
            WRITE(IOUT,FMT=6082)
            IF (ONLINE) WRITE(ITOUT,FMT=6082)
 6082       FORMAT(1X,'*** ERROR ***',/,1X,'A ROTATION keyword must',
     +           ' be given specifying the total phi',/,1X,
     +           'rotation to be used. eg ROTATION 50')
            AUTO = .FALSE.
            IF (WINOPEN) THEN
               LINE = ' '
               WRITE(LINE,FMT=6272)
 6272          FORMAT('** ERROR ** a ROTATION subkeyword ',
     +              'must be given')
               CALL MXDWIO(LINE,1)
            END IF
         END IF
         IF (ISEG.EQ.0) THEN
C     
C---- Set number of segments to one by default
C     
            NSEGAUTO = 1
            WRITE(IOUT,FMT=6084)
            IF (ONLINE) WRITE(ITOUT,FMT=6084)
 6084       FORMAT(1X,'No SEGMENT keyword given, assume 1 segment.')
            IF (WINOPEN) THEN
               LINE = ' '
               WRITE(LINE,FMT=6270)
 6270          FORMAT('No SEGMENT keyword given, assume 1 segment.')
               CALL MXDWIO(LINE,2)
            END IF
         END IF
         IF ((IROT.EQ.0).AND.(.NOT.SIZESET)) GOTO 16
C     
C---- Check that is SIZE has been given, then sizes are specified for ALL
C     segments
C     
         IF ((ISIZE.GT.0).AND.(ISIZE.NE.NSEGAUTO)) THEN
            WRITE(IOUT,FMT=6085) NSEGAUTO
            IF (ONLINE) WRITE(ITOUT,FMT=6085) NSEGAUTO
 6085       FORMAT(1X,'*** ERROR ***',/,1X,'If SIZEs of segments are',
     +           ' given, they must be given for all',I3,' segments')
            IF (WINOPEN) THEN
               LINE = ' '
               WRITE(LINE,FMT=6274) NSEGAUTO
 6274          FORMAT('** ERROR ** Must give SIZEs for all',I3,
     +              ' segments.')
               CALL MXDWIO(LINE,1)
               INERR = .TRUE.
            END IF
            AUTO = .FALSE.
            GOTO 16
         END IF
C     
      ELSE IF (KEY.EQ.'TEST') THEN
        IF(HARRY)THEN
          ICOUNT = 1
          CALL KWTEST(LINE(IBEG(ICOUNT):LENSTR(LINE)),ICOMM,ITINS,
     $         COMREAD,IERR)
          IF(IERR.EQ.50)THEN
            IERR = 0
            GOTO 16
          ENDIF
        ELSE
C     
C---- TESTGEN option
C     
         TESTGEN = .TRUE.
         DONETEST = .TRUE.
         ISTAFLG = 0
         IENDFLG = 0
         ICOUNT = 1
         OSCANG = 0.0
         IF (NTOK.EQ.1) GOTO 35
 34      ICOUNT = ICOUNT + 1
         SUBKEY = LINE(IBEG(ICOUNT):IEND(ICOUNT))
C     **************
         CALL CCPUPC(SUBKEY)
C     **************
         IF (SUBKEY(1:3).EQ.'STA') THEN
            ICOUNT = ICOUNT + 1
C     *******************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     *******************************************
            IF (IOERR) INERR = .TRUE.
            ISTAFLG = 1
            PHSTART = VALUE(ICOUNT)
            IF (ABS(PHSTART-NINT(PHSTART)).GT.0.01) THEN
               WRITE(IOUT,FMT=6086) NINT(PHSTART)
               IF (ONLINE) WRITE(ITOUT,FMT=6086) NINT(PHSTART)
 6086          FORMAT(1X,'*** WARNING ***',/,1X,
     +              'Phi values and step must be',
     +              ' integers, nearest integer',I5,' taken')
            END IF
         ELSE IF (SUBKEY.EQ.'END') THEN
            ICOUNT = ICOUNT + 1
C     
C     ************************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************************        
            IF (IOERR) INERR = .TRUE.
            IENDFLG = 1
            PHEND = VALUE(ICOUNT) 
            IF (ABS(PHEND-NINT(PHEND)).GT.0.01) THEN
               WRITE(IOUT,FMT=6086) NINT(PHEND)
               IF (ONLINE) WRITE(ITOUT,FMT=6086) NINT(PHEND)
            END IF
         ELSE IF (SUBKEY.EQ.'STEP') THEN
            ICOUNT = ICOUNT + 1
C     
C     ************************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************************        
            IF (IOERR) INERR = .TRUE.
            PHSTEP = VALUE(ICOUNT) 
            IF (ABS(PHSTEP-NINT(PHSTEP)).GT.0.01) THEN
               WRITE(IOUT,FMT=6086) NINT(PHSTEP)
               IF (ONLINE) WRITE(ITOUT,FMT=6086) NINT(PHSTEP)
            END IF
         ELSE IF (SUBKEY(1:2).EQ.'AN') THEN
            ICOUNT = ICOUNT + 1
C     
C     ************************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************************        
            IF (IOERR) INERR = .TRUE.
            OSCANG = VALUE(ICOUNT) 
         ELSE IF (SUBKEY(1:3).EQ.'MIN') THEN
            ICOUNT = ICOUNT + 1
C     
C     ************************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************************        
            IF (IOERR) INERR = .TRUE.
            OSCMIN = VALUE(ICOUNT) 
         ELSE IF (SUBKEY(1:3).EQ.'MAX') THEN
            ICOUNT = ICOUNT + 1
C     
C     ************************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************************        
            IF (IOERR) INERR = .TRUE.
            OSCMAX = VALUE(ICOUNT) 
         ELSE IF (SUBKEY(1:2).EQ.'OV') THEN
            ICOUNT = ICOUNT + 1
C     
C     ************************************************
            CALL MKEYNM(1,ICOUNT,LINE,IBEG,IEND,ITYP,NTOK)
C     ************************************************        
            IF (IOERR) INERR = .TRUE.
            XOVER(1) = VALUE(ICOUNT)
C     
C     Not recognised
C     
         ELSE
            INERR = .TRUE.
            WRITE (IOUT,FMT=6006) SUBKEY
            IF (ONLINE) WRITE (ITOUT,FMT=6006) SUBKEY
         END IF
         IF (ICOUNT.LT.NTOK) GOTO 34 
C     
C---- Test all values have been given
C     
 35      IF (INERR) THEN
            WRITE(IOUT,FMT=6118)
            IF (ONLINE) WRITE(ITOUT,FMT=6118)
            GOTO 16
         END IF
         IF ((ISTAFLG.EQ.0).OR.(IENDFLG.EQ.0)) THEN
            WRITE(IOUT,FMT=6088)
            IF (ONLINE) WRITE(ITOUT,FMT=6088)
            IF (WINOPEN) THEN
               WRITE(IOLINE,FMT=6088)
               CALL WINDIO(NULINE)
            END IF
            GOTO 16
         END IF
C     ..
C     .. end of IF(HARRY) block
         ENDIF 
 6088    FORMAT(1X,'*** ERROR ***',/,1X,'START end END keywords',
     +        ' must be given',/,1X,'Full list of possible keywords',
     +        /,1X,'TESTGEN START 0 END 90 STEP 5 OVERLAP 4 MINOSC',
     +        ' 0.3 MAXOSC 4',/,1X,'This will test phi values from',
     +        ' 0 to 90 in steps of 5 degrees. At each phi value',/,1X,
     +        'the oscillation angle giving less than 4% overlapped',
     +        ' spots will be determined',/,1X,'providing this is',
     +        ' between 0.3 and 4 degrees')
         IF (OSCANG.EQ.0) THEN
            WRITE(IOUT,FMT=6090) PHSTART,PHEND,PHSTEP,XOVER(1),
     +           OSCMIN,OSCMAX         
            IF (ONLINE) WRITE(ITOUT,FMT=6090) PHSTART,PHEND,PHSTEP,
     +           XOVER(1),OSCMIN,OSCMAX         
         ELSE
            WRITE(IOUT,FMT=6092) PHSTART,PHEND,PHSTEP,OSCANG
            IF (ONLINE) WRITE(ITOUT,FMT=6092) PHSTART,PHEND,PHSTEP,
     +           OSCANG
         END IF
 6090    FORMAT(1X,'Testing phi values from',F6.1,' to',F6.1,
     +        ' in steps of',F4.1,' degrees.',/,1X,'At each phi value',
     +        ' the oscillation angle giving less than',F5.1,
     +        '% overlapped',/,1X,'SPOTS will be determined ',
     +        'providing this is between',F5.2,' and',F6.2,' degrees')
 6092    FORMAT(1X,'Testing phi values from',F6.1,' to',F6.1,
     +        ' in steps of',F4.1,' degrees.',/,1X,'At each phi value',
     +        ' number of overlaps will be determined for an',/1X,
     +        'oscillation angle of',F6.2)
         WRITE(IOUT,FMT=6093) 2*SETA/DTR,0.01*IXSEP,0.01*IYSEP
         IF (ONLINE) WRITE(ITOUT,FMT=6093) 2*SETA/DTR,0.01*IXSEP,
     +        0.01*IYSEP
 6093    FORMAT(/,1X,'The number of overlaps depends critically on ',
     +        'the estimated mosaic spread',/,1X,'(current value ',
     +        F5.2,') and the minimum spot separation (currently ',
     +        2F5.2,'mm).',/,1X,'These values can be',
     +        ' changed with MOSAIC and SEPARATION keywords.')
C     
C---- HELP library
C     
      ELSE IF (KEY.EQ.'HELP') THEN

         IF (WINOPEN) THEN
            LINE = 'Use the terminal window when using HELP'
            CALL MXDWIO(LINE,3)
         END IF
         HLPMOS = LINE
C     
C     ***************
         CALL MOSHLP(HLPMOS)
C     ***************
C     
C---- RUN or GO
C     
      ELSE IF (KEY.EQ.'RUN ' .OR. KEY.EQ.'GO  ' .or. testrat) THEN
         NEWRUN = .TRUE.
         IF (AUTO) GOTO 1
         IF (TESTGEN) THEN
            STRATEGY = .FALSE.
            ETA = SETA
            DIVH = SDIVH
            DIVV = SDIVV
            DELCOR = SDELCOR
            DELAMB = SDELAMB
C     
C---- If using a reduced cell to speed up strategy option, need to
C     restore original cell for overlap calculation.
C     
            IF (SHRUNK) THEN
               SHRUNK = .FALSE.
               DO 36 I = 1,3
                  CELL(I) = CELL(I)*CELLSCAL
 36            CONTINUE
               IMAT = 1
               IUMAT = 0
               ICELL = 1
               ICHECK = 0
               CALL SETMAT(IMAT,IUMAT,ICELL,ICHECK)
               WRITE(IOUT,FMT=6078) CELL
               IF (ONLINE) WRITE(ITOUT,FMT=6078) CELL
 6078          FORMAT(/,1X,'**** Restoring original cell parameters',
     +              ' for TESTGEN option:',6F8.2)
            END IF
            CALL TESTOVER
            IF(TESTRAT)THEN
               TESTRAT = .FALSE.
               TESTGEN = .FALSE.
               ROTAUTO = 0.0
               NSEGAUTO = 1
               STRATEGY = .FALSE.
               NSTRUN = 0
               NSEGM = 0
               FIRSTRAT = .TRUE.
               NSTRAT = 0
               NLAST = 1
               NNPACKS = 0
               NLASTPACK = 1
               ISTRUN = 0

c---- Reset these to zero because otherwise if another STRATEGY run is done
C     using the AUTO option after a run where the START,END values have
C     been defined it will not generate the complete Laue Group rotation
C     (in S/R ROTATE)
C     
               DO 395 I = 1,NSEGMAX
                  PHIST(I) = 0.0
                  PHIFIN(I) = 0.0
 395           CONTINUE
c     surely to reach this point shrunk must be .false. -> there
c     is no point having this code block??

               IF (SHRUNK) THEN
                  SHRUNK = .FALSE.
                  DO 410 I = 1,3
                     CELL(I) = CELL(I)*CELLSCAL
 410              CONTINUE
                  IMAT = 1
                  IUMAT = 0
                  ICELL = 1
                  ICHECK = 0
                  CALL SETMAT(IMAT,IUMAT,ICELL,ICHECK)
                  WRITE(IOUT,FMT=6078) CELL
                  IF (ONLINE) WRITE(ITOUT,FMT=6078) CELL
               END IF
               RETURN
C     
C---- end of tidying after TESTRAT
C     
            ENDIF
            IF (CELLSCAL.NE.1.0) THEN
               SHRUNK = .TRUE.
               DO 42 I = 1,3
                  CELL(I) = CELL(I)/CELLSCAL
 42            CONTINUE
               IMAT = 1
               IUMAT = 0
               ICELL = 1
               ICHECK = 0
               CALL SETMAT(IMAT,IUMAT,ICELL,ICHECK)
               WRITE(IOUT,FMT=6077) CELL
               IF (ONLINE) WRITE(ITOUT,FMT=6077) CELL
 6077          FORMAT(/,1X,'**** Restoring shrunk cell parameters',
     +              ' for STRATEGY option:',6F8.2)
            END IF
            TESTGEN = .FALSE.
            STRATEGY = .TRUE.
            GOTO 16
         END IF
         GOTO 20
      ELSE IF ((KEY.EQ.'EXIT').OR.(KEY.EQ.'END')) THEN
         WRITE(IOUT,FMT=6080)
         IF (ONLINE) WRITE(ITOUT,FMT=6080)
         IF (.NOT.DONETEST) THEN
            WRITE(IOUT,FMT=6081)
            IF (ONLINE) WRITE(ITOUT,FMT=6081)
         END IF
         IF (WINOPEN) THEN
            WRITE(IOLINE,FMT=6081)
            CALL WINDIO(NULINE)
         END IF
 6080    FORMAT(/1X,'***** WARNING *****',/,1X,'The figures',
     +        ' on completeness assume NO reflections are',
     +        ' spatially overlapped',/,1X,'and no reflections',
     +        ' are lost due to unmatched partials.')
 6081    FORMAT(/,1X,'Use the TESTGEN option to determine',
     +        ' appropriate oscillation angles to avoid',/,1X,
     +        'spatial overlaps.')
C     
         IF (WINOPEN) CALL MXDCIO(1,0,0,0,0)
         ROTAUTO = 0.0
         NSEGAUTO = 1
         STRATEGY = .FALSE.
         NSTRUN = 0
         NSEGM = 0
         FIRSTRAT = .TRUE.
         NSTRAT = 0
         NLAST = 1
         NNPACKS = 0
         NLASTPACK = 1
         ISTRUN = 0
c     
c---- Reset these to zero because otherwise if another STRATEGY run is done
C     using the AUTO option after a run where the START,END values have
C     been defined it will not generate the complete Laue Group rotation
C     (in S/R ROTATE)
C     
         DO 39 I = 1,NSEGMAX
            PHIST(I) = 0.0
            PHIFIN(I) = 0.0
 39      CONTINUE
         IF (SHRUNK) THEN
            SHRUNK = .FALSE.
            DO 40 I = 1,3
               CELL(I) = CELL(I)*CELLSCAL
 40         CONTINUE
            IMAT = 1
            IUMAT = 0
            ICELL = 1
            ICHECK = 0
            CALL SETMAT(IMAT,IUMAT,ICELL,ICHECK)
            WRITE(IOUT,FMT=6078) CELL
            IF (ONLINE) WRITE(ITOUT,FMT=6078) CELL
         END IF
         RETURN
      ELSE
         WRITE (IOUT,FMT=6009) KEY
         IF (ONLINE) WRITE (ITOUT,FMT=6009) KEY
 6009    FORMAT (//1X,'********** Keyword NOT Recognised:',A)
         INERR = .TRUE.
      END IF
      GOTO 16
C     
C---- set up 4*sinsqth/lambdsq limits
C     

c     retrieve the hkl string
      call retrievehkl(ihklstr, ntotal, istatus)
c     interesting problem - iorder is the same as ihklstr...
c     is this copied? no one knows...

 20   CONTINUE
      call complete_engine(IHKLSTR,NTOTAL,IORDER)
C     
C---- Percentage observed
C     
 280  CONTINUE
      IF (NIN1.NE.0) PC = (100.0*NUNI)/REAL(NIN1)
      PC1 = PC
      IF (NIN1.NE.0) PCUNIQA(1) = 100*REAL(NUNIQA(1))/REAL(NIN1)
      IF (AUTANOM.AND.(NUNIANOT.GT.0)) PC = 100.0*NANOMT/REAL(NUNIANOT)
      IF (IMODE.EQ.0) THEN
         IF (DEBUG(57).OR.LAST.OR.(.NOT.AUTO)) THEN
            IF (AUTANOM) THEN
               WRITE(IOUT,FMT=6200) PC
               IF (ONLINE) WRITE(ITOUT,FMT=6200) PC
               IF (WINOPEN.AND.(.NOT.AUTO)) THEN
                  LINE = ' '
                  WRITE(LINE,FMT=6250) PC
 6250             FORMAT('These segments contain',F6.1,
     +                 '% of the possible',
     +                 ' anomalous pairs.')
                  CALL MXDWIO(LINE,1)
                  LINE = ' '
                  WRITE(LINE,FMT=6246)
                  CALL MXDWIO(LINE,3)
               END IF
            ELSE
               WRITE(IOUT,FMT=6037) PC
               IF (ONLINE) WRITE(ITOUT,FMT=6037) PC
               IF (WINOPEN.AND.(.NOT.AUTO)) THEN
                  LINE = ' '
                  WRITE(LINE,FMT=6252) PC
 6252             FORMAT('These segments contain',F6.1,'% of the',
     +                 ' unique data.')
                  CALL MXDWIO(LINE,1)
                  LINE = ' '
                  WRITE(LINE,FMT=6246)
                  CALL MXDWIO(LINE,3)
               END IF
               IF (OFFPHI.AND.(NSEGAUTO.EQ.1).AND.(PCMAX.LT.99)) THEN
                  WRITE(IOUT,FMT=6320)
                  IF (ONLINE) WRITE(ITOUT,FMT=6320)
 6320             FORMAT(1X,
     +                 '*****************************************',
     +                 '***************************',/,1X,
     +                 'It may be possible to get a higher ',
     +                 'completeness using two segments,',/,1X,
     +                 'or a slightly greater rotation angle.',/,1X,
     +                 '*****************************************',
     +                 '***************************')
                  IF (WINOPEN) THEN
                     WRITE(IOLINE,FMT=6320)
                     CALL WINDIO(NULINE)
                  END IF
               END IF
               IF (PHIPAD.NE.0) THEN
                  WRITE(IOUT,FMT=6039) PHILAUE+PHIPAD
                  IF (ONLINE) WRITE(ITOUT,FMT=6039) PHILAUE+PHIPAD
 6039             FORMAT(1X,
     +                 'It may be possible to get a slightly higher',
     +                 ' completeness (particularly at',/,1X,
     +                 'low resolution) for a larger rotation range.',
     +                 /,1X,
     +                 'Try: AUTO ROTATION',F6.1,' SEGMENT 1 to test',
     +                 ' this.')
                  IF (WINOPEN) THEN
                     WRITE(IOLINE,FMT=6039) PHILAUE+PHIPAD
                     CALL WINDIO(NULINE)
                  END IF
               END IF
            END IF
         END IF
 6037    FORMAT(1X,'These segments contain',F6.1,'% of the',
     +        ' unique data.',/,1X,'Type "STATS" for full statistics')
 6200    FORMAT(1X,'These segments contain',F6.1,'% of the possible',
     +        ' anomalous pairs.',/,1X,
     +        'Type "STATS" for full statistics')
         IF ((.NOT.AUTO).OR.LAST) THEN
            WRITE(IOUT,FMT=6080)
            IF (ONLINE) WRITE(ITOUT,FMT=6080)
            WRITE(IOUT,FMT=6081)
            IF (ONLINE) WRITE(ITOUT,FMT=6081)
            IF (WINOPEN) THEN
               WRITE(IOLINE,FMT=6081)
               CALL WINDIO(NULINE)
            END IF
         END IF
         IF (AUTO) THEN
C     
C---- If this is last run with the best parameters, turn AUTO off
C     
            IF (LAST) THEN
               LAST = .FALSE.
               AUTO = .FALSE.
               GOTO 16
            END IF
C     
C---- Store these results
C     
            IF (PC.GT.PCMAX) THEN
               PCMAX = PC
               DO 282 I = 1,NSEGAUTO
                  PHSBEST(I) = CPHIST(NSEGSTART+I-1)
 282           CONTINUE
            END IF
            GOTO 400
         END IF
         GOTO 16
      END IF
      WRITE (IOUT,FMT=6038) NIN2,NUNI,PC1
      IF (ONLINE) WRITE (ITOUT,FMT=6038) NIN2,NUNI,PC1
      IF (AUTANOM) THEN
         WRITE(IOUT,FMT=6202) PC
         IF (AUTANOM) WRITE(ITOUT,FMT=6202) PC
      END IF
      IF (WINOPEN) THEN
         WRITE (IOLINE,FMT=6038) NIN2,NUNI,PC1
         CALL WINDIO(NULINE)
         IF (AUTANOM) THEN
            WRITE(IOLINE,FMT=6202) PC
            CALL WINDIO(NULINE)
         END IF
      END IF


c     more dna bits - this will only come out if stats on is true,
c     which would at the moment break the scheduler

      call dna_output_table_start('strategy_information')
      call dna_output_list_start('reflections')
      call dna_output_integer_item('predicted_reflections', nin2)
      call dna_output_integer_item('unique_reflections', nuni)
      call dna_output_real_item('percentage_unique_data', pc1)
      if(autanom) then
         call dna_output_real_item('percentage_unique_anomolous',
     +        pc)
      end if
      call dna_output_list_end
      call dna_output_table_end

 6038 FORMAT(/1X,'These segments contain',
     +     I7,' predicted reflections and',
     +     I7,' unique reflections',/,1X,'This is',F6.1,
     +     ' percent of the unique data for this spacegroup.',
     +     /,1X,'        =====')
 6202 FORMAT(1X,'Completeness of anomalous pairs is',F6.1,'%')
C     
C---- Print warning if extra reflections exist in data file
C     
      IF (NEXTRA.NE.0) THEN
         WRITE (IOUT,FMT=6040) NEXTRA
         IF (ONLINE) WRITE (ITOUT,FMT=6040) NEXTRA
      END IF
 6040 FORMAT(/1X,'***** WARNING *****',/1X,'*******************',
     +     /1X,I6,' predicted reflections',
     +     '  that are not in list of unique reflections.',
     +     /,1X,'This can arise if the predicted reflections are to a',
     +     ' higher (or lower) resolution',/,1X,'than the unique',
     +     ' reflections',
     +     /1X,'Extra reflections have all been ignored in following',
     +     ' analysis')
C     
      WRITE (IOUT,FMT=6044)
      IF (ONLINE) WRITE (ITOUT,FMT=6044)
 6044 FORMAT(/1X,'UNIQUE DATA AS A FUNCTION OF ROTATION RANGE',
     +     /1X,'===========================================',
     +     /1X,'For each rotation range the total number of ',
     +     'reflections within that'
     +     /1X,'range and the cumulative number',
     +     ' of unique reflections generated is listed'
     +     /15X,'==========')
      IF (WINOPEN) THEN
         WRITE (IOLINE,FMT=6044)
         CALL WINDIO(NULINE)
      END IF
C     
      NBITS = NPACK/NACROSS + 1
      N1 = -NACROSS + 1
C     
C     
      DO 290 K = 1,NBITS
         N1 = N1 + NACROSS
         IF (N1.GT.NPACK) GOTO 290
         N2 = N1 + NACROSS - 1
         IF (N2.GT.NPACK) N2 = NPACK
C     
C     nprint=(n2-n1+1)
C     
         WRITE (IOUT,FMT=6046) (PRSTA(J),PRFIN(J),J=N1,N2)
         WRITE (IOUT,FMT=6048) (NTOT(J),J=N1,N2)
         WRITE (IOUT,FMT=6050) (NUNIQA(J),J=N1,N2)
         WRITE (IOUT,FMT=6051) (PCUNIQA(J),J=N1,N2)
         IF (WINOPEN) THEN
            NULINE = .FALSE.
            WRITE (IOLINE,FMT=6046) (PRSTA(J),PRFIN(J),J=N1,N2)
            CALL WINDIO(NULINE)
            WRITE (IOLINE,FMT=6048) (NTOT(J),J=N1,N2)
            CALL WINDIO(NULINE)
            WRITE (IOLINE,FMT=6050) (NUNIQA(J),J=N1,N2)
            CALL WINDIO(NULINE)
            WRITE (IOLINE,FMT=6051) (PCUNIQA(J),J=N1,N2)
            NULINE = .TRUE.
            CALL WINDIO(NULINE)
         END IF
         IF (ONLINE) WRITE (ITOUT,FMT=6046) (PRSTA(J),PRFIN(J),
     +        J=N1,N2)
         IF (ONLINE) WRITE (ITOUT,FMT=6048) (NTOT(J),J=N1,N2)
         IF (ONLINE) WRITE (ITOUT,FMT=6050) (NUNIQA(J),J=N1,N2)
         IF (ONLINE) WRITE (ITOUT,FMT=6051) (PCUNIQA(J),J=N1,N2)
 6046    FORMAT (/1X,'Angle',8X,4 (F5.0,' to ',F5.0,3X))
 6048    FORMAT (1X,'Number       ',4 (5X,I6,6X))
 6050    FORMAT (1X,'Number unique',4 (5X,I6,6X))
 6051    FORMAT (1X,'%age unique  ',4 (5X,F6.1,6X))
 290  CONTINUE
C     
C     
      WRITE (IOUT,FMT=6052)
      IF (ONLINE) WRITE (ITOUT,FMT=6052)
 6052 FORMAT(//1X,'MULTIPLICITIES'/1X,'=============='/1X,
     +     'For each oscillation range the number of reflections ',
     +     'predicted',
     +     ' once,twice,'/1X,
     +     'three times etc are listed. these numbers ',
     +     ' are cumulative'/47X,'=========='/)
      IF (WINOPEN) THEN
         WRITE (IOLINE,FMT=6052)
         CALL WINDIO(NULINE)
      END IF
      N1 = -NACROSS + 1
C     
C     
      DO 310 K = 1,NBITS
         N1 = N1 + NACROSS
         IF (N1.GT.NPACK) GOTO 310
         N2 = N1 + NACROSS - 1
         IF (N2.GT.NPACK) N2 = NPACK
         WRITE (IOUT,FMT=6054) (PRSTA(J),PRFIN(J),J=N1,N2)
         IF (ONLINE) WRITE (ITOUT,FMT=6054) (PRSTA(J),PRFIN(J),
     +        J=N1,N2)
         WRITE (IOUT,FMT=6056)
         IF (ONLINE) WRITE (ITOUT,FMT=6056)
         IF (WINOPEN) THEN
            WRITE (IOLINE,FMT=6054) (PRSTA(J),PRFIN(J),J=N1,N2)
            NULINE = .FALSE.
            CALL WINDIO(NULINE)
            WRITE (IOLINE,FMT=6056)
            CALL WINDIO(NULINE)
         END IF
C     
C     
         DO 300 J = 1,MAXMLT
            WRITE (IOUT,FMT=6058) J, (NTIMES(I,J),I=N1,N2)
            IF (ONLINE) WRITE (ITOUT,FMT=6058) J, (NTIMES(I,J),I=N1,N2)
            IF (WINOPEN) THEN
               WRITE (IOLINE,FMT=6058) J, (NTIMES(I,J),I=N1,N2)
               CALL WINDIO(NULINE)
            END IF
 300     CONTINUE
         WRITE(IOUT,FMT=6059) (XMULT(I),I=N1,N2)
         IF (ONLINE) WRITE(ITOUT,FMT=6059) (XMULT(I),I=N1,N2)
         IF (WINOPEN) THEN
            WRITE (IOLINE,FMT=6059) (XMULT(I),I=N1,N2)
            NULINE = .TRUE.
            CALL WINDIO(NULINE)
         END IF
C     
C     
 6054    FORMAT (/1X,'Angle',8X,4 (F5.0,' to ',F5.0,3X))
 6056    FORMAT (1X,'Multiplicity')
 6058    FORMAT (6X,I2,6X,4 (5X,I6,6X))
 6059    FORMAT (1X,'Mean multiplicity',1x,F6.1,6X,3 (5X,F6.1,6X))

 921     format('segment_', i1)
 922     format('segment_', i2)

         call dna_output_table_start('strategy_multiplicity')
         do i = n1, n2
            if(i .lt. 10) then
               write(dnahs, 921) i
            else
               write(dnahs, 922) i
            end if
            call dna_output_list_start(dnahs(1:lenstr(dnahs)))
            call dna_output_real_item('average_multiplicity', 
     +           xmult(i))
            call dna_output_list_end
         end do
         call dna_output_table_end




 310  CONTINUE
C     
C     
C     
      WRITE (IOUT,FMT=6060)
      IF (ONLINE) WRITE (ITOUT,FMT=6060)
 6060 FORMAT (///1X,
     +     'Breakdown as a Function of Resolution',/1X,
     +     '=====================================')
      IF (WINOPEN) THEN
         WRITE (IOLINE,FMT=6060)
         CALL WINDIO(NULINE)
      END IF
C     
C     
      WRITE (IOUT,FMT=6062)
      IF (ONLINE) WRITE (ITOUT,FMT=6062)
 6062 FORMAT(/1X,'For each rotation range, the number of newly',
     +     ' predicted unique reflections'/1X,'is listed as a',
     +     ' function of resolution'/,1X,'The D value given for ',
     +     'each bin is the high resolution limit for that bin')
      IF (WINOPEN) THEN
         WRITE (IOLINE,FMT=6062)
         CALL WINDIO(NULINE)
      END IF
      N1 = -NACROSS + 1
C     
C     
      DO 330 K = 1,NBITS
         N1 = N1 + NACROSS
         IF (N1.GT.NPACK) GOTO 330
         N2 = N1 + NACROSS - 1
         IF (N2.GT.NPACK) N2 = NPACK
         NPRINT = N2 - N1 + 1
         WRITE (IOUT,FMT=6064) (PRSTA(J),PRFIN(J),J=N1,N2)
         IF (ONLINE) WRITE (ITOUT,FMT=6064) (PRSTA(J),PRFIN(J),
     +        J=N1,N2)
         IF (WINOPEN) THEN
            WRITE (IOLINE,FMT=6064) (PRSTA(J),PRFIN(J),J=N1,N2)
            NULINE = .FALSE.
            CALL WINDIO(NULINE)
         END IF
C     
C     
         DO 320 I = 1,NBIN
            WRITE (IOUT,FMT=6066) D(I), (NOBSRES(N,I),N=N1,N2)
            IF (ONLINE) WRITE (ITOUT,FMT=6066) D(I), (NOBSRES(N,I),
     +           N=N1,N2)
            IF (WINOPEN) THEN
               WRITE (IOLINE,FMT=6066) D(I), (NOBSRES(N,I),N=N1,N2)
               IF (I.EQ.NBIN) NULINE = .TRUE.
               CALL WINDIO(NULINE)
            END IF
 320     CONTINUE
C     
C     
 6064    FORMAT (/3X,'D     angle',2X,4 (F5.0,' to ',F5.0,3X))
 6066    FORMAT (1X,F5.2,7X,4 (5X,I6,6X))
 330  CONTINUE
C     
C     
C     
C     
      WRITE (IOUT,FMT=6068)
      IF (ONLINE) WRITE (ITOUT,FMT=6068)
      WRITE (IOUT,FMT=6070) (D(I),NUNIRES(I),NTOTRES(I),PCENT(I),
     +     I=1,NBIN)
      IF (ONLINE) WRITE (ITOUT,FMT=6070) (D(I),NUNIRES(I),NTOTRES(I),
     +     PCENT(I),I=1,NBIN)
      IF (WINOPEN) THEN
         WRITE (IOLINE,FMT=6068)
         CALL WINDIO(NULINE)
         WRITE (IOLINE,FMT=6070) (D(I),NUNIRES(I),NTOTRES(I),PCENT(I),
     +        I=1,NBIN)
         CALL WINDIO(NULINE)
      END IF
 6068 FORMAT(/1X,'The number of unique reflections and the ',
     +     'number and percentage of those'/1X,
     +     'predicted is given as a function of resolution.'
     +     /,1X,'The D value given for ',
     +     'each bin is the high resolution limit for that bin.'
     +     //1X,'  D   unique reflections   predicted reflections',
     +     '   percentage predicted')
 6070 FORMAT (1X,F5.2,1X,I10,14X,I10,10X,F10.1)
C     
C---- print statistics on anomalous data
C     
C     
C     
      IF (NUNIANOT.NE.0) PC = (100.0*NANOMT)/REAL(NUNIANOT)
      WRITE (IOUT,FMT=6072) NANOMT,NUNIANOT,PC
      IF (ONLINE) WRITE (ITOUT,FMT=6072) NANOMT,NUNIANOT,PC
 6072 FORMAT (///1X,
     +     'ANOMALOUS DATA',/1X,
     +     '==============',/1X,
     +     'A total of',I7,
     +     ' anomalous pairs have been predicted, out of a total',/,1X,
     +     'possible of',I7,'  ie',F6.1,' percent.')
      WRITE (IOUT,FMT=6074)
      IF (ONLINE) WRITE (ITOUT,FMT=6074)
      WRITE (IOUT,FMT=6076) (D(I),NUNIANO(I),NANOM(I),PCENTANO(I),
     +     I=1,NBIN)
      IF (ONLINE) WRITE (ITOUT,FMT=6076) (D(I),NUNIANO(I),NANOM(I),
     +     PCENTANO(I),I=1,NBIN)
      IF (WINOPEN) THEN
         WRITE (IOLINE,FMT=6072) NANOMT,NUNIANOT,PC
         CALL WINDIO(NULINE)
         WRITE (IOLINE,FMT=6074)
         CALL WINDIO(NULINE)
         WRITE (IOLINE,FMT=6076)(D(I),NUNIANO(I),NANOM(I),PCENTANO(I),
     +        I=1,NBIN)
         CALL WINDIO(NULINE)
      END IF
 6074 FORMAT(/1X,'The number of unique acentric reflections and the ',
     +     'number and percentage of',/,1X,'anomalous pairs predicted',
     +     '  is given as a function of resolution.'
     +     /,1X,'The D value given for ',
     +     'each bin is the high resolution limit for that bin.',
     +     //1X,'  D   unique acentric    generated anomalous pairs',
     +     '     percentage ')
 6076 FORMAT (1X,F5.2,1X,I10,14X,I10,10X,F10.1)
C     
      GOTO 2
C     
      END
C
C $Id: complete_engine.f,v 1.8 2003/07/24 14:08:44 harry Exp $
      subroutine complete_engine(IHKLSTR,NTOTAL,IORDER)
      
      implicit none
      
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
      INTEGER NPARM
      PARAMETER (NPARM=200)
C     IHKLSTR      Array containing the reflections

C     Need to use IHKLSTR(1,NTOTAL) onwards are working array
C     ..
C     .. Scalar Arguments ..
      INTEGER NTOTAL

C     ..
C     .. Array Arguments ..
      INTEGER*2 IHKLSTR(MCOLSTR,NREFSTR)
      INTEGER IORDER(NTOTAL)
C     ..      

C     ..
C     .. External Functions ..
      INTEGER LENSTR
      LOGICAL HKLEQ
      EXTERNAL LENSTR,HKLEQ
C     ..
C     .. External Subroutines ..
      EXTERNAL SORTUP2,MKEYNM,MPARSER,CCPUPC,MOSHLP,TESTOVER,SETMAT,
     +     LWCLOS,WINDIO
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC NINT,REAL,SQRT
C     ..
C     .. Common blocks ..

C&&*&& include  ../inc/completedata.f
C     ..      
C     .. Local Scalars ..
      REAL PC,PC1,PHIFINI,PHIINCI,PHISTI,SN,SN2,STH,DTR,XSEP,YSEP,
     +     SMAX,SMIN,RESMAX,RESMIN,SRESOL,STHINC,STHLMIN,STHLMAX,
     +     DMAX,DMIN,DSTSQ,S,PHI1,PHI2,PHIINCR,CPHISTART,CPHIEND,
     +     PHISEG,PHIFINAL,PHISTAUTO,X,PHITOT,PPHISTI,PPHIFINI,
     +     AUTOINC,PHIADDAUTO,SUM1,SUM2
      INTEGER I,IBATCH,IBIN,ICEN,IFLAG,IPHI,IPKF,IPKS,IREF,ISEG,J,K,
     +     KPACK,MAXMLT,MULT,MULTPACK,N,N1,N2,NACROSS,NANO,
     +     NANOMT,NBITS,NDIFFPACK,NEXTRA,NIN,NIN1,NIN2,
     +     NMULT,NNPACK,NPACK,NPACK1,NPACK2,NPRINT,NRESO,NSEGIN,
     +     NTOTPACK,NUNI,NUNIANOT,NLPRGI,IPRINT,NBIN,NBIT,
     +     NTOK,IFSEG,IH,IK,IL,ITINS,JJ,ICOUNT,KK,ISTA,IFIN,IP,
     +     IMODE,ICLEAR,IRUN,IRUNOLD,JRUN,IBINOLD,ICOMB,IROT,
     +     NSEGSTART,ISTAFLG,IENDFLG,NDBG,ICENOLD,ISIZE,
     +     IMAT,IUMAT,ICELL,ICHECK,MTZPRT,NCH
      LOGICAL DUMPSPOT,EOF,MONITOR,COMREAD,STARTOK,ENDOK,RESET,LAST,
     +     NEWRUN,DONETEST,INERR,NULINE

C     ..                   
C     .. Local Arrays ..
      REAL D(NRESBIN),PCENT(NRESBIN),PCENTANO(NRESBIN),CPHIFI(NSEGMAX),
     +     CPHIFIN(MAXPAX),CPHIST(NSEGMAX),CPHIINC(NSEGMAX),
     +     CPHISTA(MAXPAX),SPHIFI(NSEGMAX),CPHIADD(NSEGMAX),
     +     SPHIINC(NSEGMAX),SPHIST(NSEGMAX),ADATA1(MCOLSTR),
     +     ADATA2(MCOLSTR),KH(3),LH(3),VALUE(NPARM),PRSTA(MAXPAX),
     +     PRFIN(MAXPAX),PHSBEST(NSEGMAX),PCUNIQA(MAXPAX),XMULT(MAXPAX)
      INTEGER IPACK(MULTMAX),HKL1(3),HKL2(3),
     +     IPFSEG(MAXPAX),IPKFI(NSEGMAX),
     +     IPKST(NSEGMAX),IPSSEG(MAXPAX),ISPKFI(NSEGMAX),
     +     ISPKST(NSEGMAX),JPACK(MAXDIFF+1,2),
     +     LOOKUP(MCOLSTR),NANOM(NRESBIN),NISYM(MULTMAX),
     +     NOBSRES(MAXPAX,NRESBIN),NTIMES(MAXPAX,MULTMAX),
     +     NTOT(MAXPAX),NTOTRES(NRESBIN),NUNIANO(NRESBIN),
     +     NUNIQA(MAXPAX),NUNIRES(NRESBIN),IBEG(NPARM),IDEC(NPARM),
     +     IEND(NPARM),ITYP(NPARM),IFIRST(NSEGMAX),ICRUN(NSEGMAX)
      INTEGER*2 JORDER(NSEGMAX),IPHIA(NSEGMAX)
      
      COMMON /noddyblka/ PC,PC1,PHIFINI,PHIINCI,PHISTI,SN,SN2,
     +     STH,DTR,XSEP,YSEP,
     +     SMAX,SMIN,RESMAX,RESMIN,SRESOL,STHINC,STHLMIN,STHLMAX,
     +     DMAX,DMIN,DSTSQ,S,PHI1,PHI2,PHIINCR,CPHISTART,CPHIEND,
     +     PHISEG,PHIFINAL,PHISTAUTO,X,PHITOT,PPHISTI,PPHIFINI,
     +     AUTOINC,PHIADDAUTO,SUM1,SUM2

      common /noddyblkb/ I,IBATCH,IBIN,ICEN,IFLAG,IPHI,IPKF,IPKS,
     +     IREF,ISEG,J,K,
     +     KPACK,MAXMLT,MULT,MULTPACK,N,N1,N2,NACROSS,NANO,
     +     NANOMT,NBITS,nunianot,NDIFFPACK,NEXTRA,NIN,NIN1,NIN2,
     +     NMULT,NNPACK,NPACK,NPACK1,NPACK2,NPRINT,NRESO,NSEGIN,
     +     NTOTPACK,NUNI,NLPRGI,IPRINT,NBIN,NBIT,
     +     NTOK,IFSEG,IH,IK,IL,ITINS,JJ,ICOUNT,KK,ISTA,IFIN,IP,
     +     IMODE,ICLEAR,IRUN,IRUNOLD,JRUN,IBINOLD,ICOMB,IROT

      common /noddyblkc/ NSEGSTART,ISTAFLG,IENDFLG,NDBG,ICENOLD,ISIZE,
     +     IMAT,IUMAT,ICELL,ICHECK,MTZPRT,NCH,
     +     DUMPSPOT,EOF,MONITOR,COMREAD,STARTOK,ENDOK,RESET,LAST,
     +     NEWRUN,DONETEST,INERR,NULINE,
     +     D,PCENT,PCENTANO,CPHIFI,CPHIFIN,CPHIST,CPHIINC,
     +     CPHISTA,SPHIFI,CPHIADD,
     +     SPHIINC,SPHIST,ADATA1,
     +     ADATA2,VALUE,PRSTA

      common /noddyblkd/ PRFIN,PHSBEST,PCUNIQA,
     +     XMULT, IPACK,HKL1,HKL2,
     +     IPFSEG,IPKFI,
     +     IPKST,IPSSEG,ISPKFI,
     +     ISPKST,JPACK,
     +     LOOKUP,NANOM,NISYM,
     +     NOBSRES,NTIMES,
     +     NTOT,NTOTRES,NUNIANO,
     +     NUNIQA,NUNIRES,IBEG,IDEC,
     +     IEND,ITYP,IFIRST,ICRUN,
     +     JORDER,IPHIA
C&&*&& end_include  ../inc/completedata.f
C&&*&& include  ../inc/cell.f
C
C $Id: cell.f,v 1.2 2003/06/16 16:41:13 harry Exp $
C
C--- awk generated include file  cell.h
C---- START of include file cell.h
C
C     CELL cell dimensions (real space)
C     RCELL reciprocal cell parameters in dimensionless rlu
C
C     .. Arrays in Common /CELLCOM/ ..
      REAL UMAT,BMAT,GMAT,CELL,RCELL,UMATCELL,SOFTCELL
      INTEGER LCELL,ICRYST,NUMSPG,NLAUE
C     ..
C     .. Common Block /CELLCOM/ ..
      COMMON /CELLCOM/UMAT(3,3),BMAT(3,3),GMAT(3,3),CELL(6),RCELL(6),
     $       UMATCELL(6),SOFTCELL,LCELL(6),ICRYST,NUMSPG,NLAUE
C     ..
C
C
C&&*&& end_include  ../inc/cell.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/dsplyc.f
C
C $Id: dsplyc.f,v 1.1 2002/05/02 10:46:46 harry Exp $
C
C--- awk generated include file  dsplyc.h
C---- START of include file dsplyc.h
C
C*******************************************************************
C
C  COMMON  /DSPLYC/
C
C	IMGLOW, IMGHI	low & high values of 16-bit image for scaling
C			integer*2 to byte: IMGLOW maps to  0; 
C			IMGHI to maximum. Note that these are not
C			necessarily the actual limits of the data
C	JDSPWD		.LT. 0  before image window has been created
C                       = +-1 for image display that can be panned
C                       = +-2 for non-interactive image display
C       MAXDEN          highest level in colour table to fill up to
C                       must be less than ~240 - number of overlay colours
C       LDSPSG          if .true., treat image as signed, ie after dark
C                          subtraction
C                       if .false., treat image as unsigned
C       NZOOM           zoom factor for image, = 0 if no zoom
C       JYZOOM, JZZOOM  1st pixel in zoomed image
C
C----   WINOPEN Flag for whether or not window is open. Do not
C               confuse with DISPMENU (/CONDATA/)which is true if the run was
C               started with a IMAGE keyword.
C
C
C       CDSPTL          banner title
C
      INTEGER IMGLOW, IMGHI, JDSPWD, MAXDEN,
     $     NZOOM, JYZOOM, JZZOOM
      LOGICAL LDSPSG,WINOPEN,LPAUSE,LHELP
      COMMON /DSPLYC/ IMGLOW, IMGHI, JDSPWD,
     *     MAXDEN, NZOOM, JYZOOM, JZZOOM, LDSPSG,WINOPEN,LPAUSE,LHELP
C
      CHARACTER  CDSPTL*200
      COMMON /DSPLCC/  CDSPTL
C                                                           
C
C*******************************************************************


C&&*&& end_include  ../inc/dsplyc.f
C&&*&& include  ../inc/gui.f
c     gui.h
c     maintained by G.Winter
c     16th April 2002
c     $Id: gui.f,v 1.16 2003/04/04 14:22:01 harry Exp $
c     
c     This defines the variables and common blocks which are used by the
c     new gui control routine. This will also be used in xdisp and control,
c     to switch the new gui on!
c     
c     

      logical gui_switch, refine_cell(6), refine_detector(11),
     +     autocomplete, autoreturn, newmatstore
      integer nargs
      integer imageno, nstart
      parameter (nargs = 200)

c     refine_detector logical block index:
c     1: beam x 2: beam y 3: ccomega 4: yscale
c     5: distance 6: tilt 7: twist 8: roff 9: toff
c     
c     refine_cell logical block index:
c     1: a 2: b 3: c
c     4: alpha 5: beta 6: gamma
c     
c     
c     

      integer keep_phi_segments, keep_phi_start(20), 
     +     keep_phi_end(20)

      real storemeanmult

      common /gui/ gui_switch, imageno, refine_cell, refine_detector,
     +     autocomplete, nstart, autoreturn, newmatstore

      common /keep_phi/ keep_phi_segments, keep_phi_start, 
     +     keep_phi_end, storemeanmult


c     refine_cell(i) is true if you wish to refine cell(i)
C&&*&& end_include  ../inc/gui.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/ioosum.f
C
C $Id: ioosum.f,v 1.2 2004/08/16 13:26:27 harry Exp $
C
C--- awk generated include file  ioosum.h
C---- START of include file ioosum.h
C
C     .. Scalars in common block /IOOSUM/
      INTEGER NLSUM1,NLSUM2,NSUMSTART1,NSUMSTART2
C
C     .. Arrays in common block /IOOSUMC/ ..
      CHARACTER*150 LINESUM1(MAXPAX),LINESUM2(MAXPAX)
      CHARACTER*101  IOLINE(100)
C     ..
C     .. Common block /IOOSUM/ ..
      COMMON /IOOSUM/ NLSUM1,NLSUM2,NSUMSTART1,NSUMSTART2
C     ..
C     .. Common block /IOOSUMC/ ..
      COMMON /IOOSUMC/ LINESUM1,LINESUM2,IOLINE
C&&*&& end_include  ../inc/ioosum.f
C&&*&& include  ../inc/ioomtz.f
C
C $Id: ioomtz.f,v 1.3 2004/05/14 15:44:19 harry Exp $
C
C--- awk generated include file  ioomtz.h
C---- START of include file ioomtz.h
C
C
C     .. Scalars in common block /IOOMTZ/ ..
      INTEGER MTZOUT,BESTHKL
      LOGICAL MTZOPEN
      CHARACTER*100 BSTHKL
C     ..
C     .. Common block /IOOMTZ/ ..
      COMMON /IOOMTZ/ MTZOUT,BESTHKL,MTZOPEN,BSTHKL
C&&*&& end_include  ../inc/ioomtz.f
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
C&&*&& include  ../inc/over.f
C
C $Id: over.f,v 1.1 2002/05/02 10:47:03 harry Exp $
C
C--- awk generated include file  over.h
C---- START of include file over.h
C
C
C     .. Scalars in Common Block /OVER/ ..
C
C     ..
C     .. Scalars in common /OVER/ ..
      INTEGER MINDTX,MINDTY,NPOVL,IXSEP,IYSEP
C     ..
C     .. ARRAYS in common /OVER/ ..
      INTEGER HKLPOVL
C     ..
C     .. Common Block /OVER/ ..
      COMMON /OVER/MINDTX,MINDTY,NPOVL,IXSEP,IYSEP,HKLPOVL(NREFLS/2)
C     ..
C
C
C&&*&& end_include  ../inc/over.f
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/strat.f
C--- awk generated include file  strat.h
C---- START of include file strat.h
C
C---- Stores variables for use in STRATEGY option
C     IROTAX is the axis closest to the rotation axis
C     PHIROTAX is the angle this axis makes with the rotation axis
C
C     PHIZONE is the phi value at which axis "IZONEAX" is along the
C     X-ray beam. (IZONEAX = 1 is a, =2 is b, =3 is c)
C     PHIPAD  is the rotation to be added to PHILAUE to ensure generation
C             of all unique data, and will depend on angle between the
C             unique axis and the rotation axis.
C     AUTANOM if true tries to maximise number of anomalous pairs
C     CELLSCAL is the scale factor applied to the cell edges to
C              speed up the calculation.
C     SHRUNK   is TRUE if the cell has been scaled by CELLSCAL
C     ISTRUN   is used to increment input phi angles by multiples of
C              360 degrees, so that phi values in different parts can
C              be recognised. It starts at zero.
C     FIRSTRAT Starts as TRUE (set in MOSDATA) and is set to FALSE once
C              the MTZ file has been opened for a STRATEGY run.
C              Reset TRUE after EXITing from STRATGEY prompt.
C
C     .. Scalars in common /STRAT/ ..
      INTEGER NSEGM,IPCKCUR,NSTRAT,NUNIQ,NSTRUN,ISTRUN,NSEGAUTO,
     +        IZONEAX,IROTAX,NLAST,NNPACKS,NLASTPACK
      LOGICAL STRATEGY,AUTO,SIZESET,AUTANOM,SHRUNK,FIRSTRAT,
     +         NEWSTRAT,WAITINP,OFFPHI
      REAL ROTAUTO,PHILAUE,PHIPAD,PHIZONE,PHIROTAX,CELLSCAL
C     ..
C     .. Arrays in common /STRAT/ ..
      REAL PHIST,PHIFIN,PHIINC,PHIADD,PHISEGA
      INTEGER IFIRSTONE
C     ..
C     .. Common Block /STRAT/ ..
      COMMON /STRAT/ PHIST(NSEGMAX),PHIFIN(NSEGMAX),PHIINC(NSEGMAX),
     +       PHIADD(NSEGMAX),PHISEGA(NSEGMAX),ROTAUTO,PHILAUE,PHIPAD,
     $       PHIZONE,PHIROTAX,CELLSCAL,IFIRSTONE(NSEGMAX),
     $       NSEGM,IPCKCUR,NSTRAT,NUNIQ,
     +       NSTRUN,ISTRUN,NSEGAUTO,
     +       IZONEAX,IROTAX,NLAST,NNPACKS,NLASTPACK,
     +       STRATEGY,AUTO,SIZESET,AUTANOM,SHRUNK,
     +       FIRSTRAT,NEWSTRAT,WAITINP,
     +       OFFPHI
C     ..
C
C


      
C&&*&& end_include  ../inc/strat.f
C&&*&& include  ../inc/tgen.f
C
C $Id: tgen.f,v 1.1 2002/05/02 10:47:23 harry Exp $
C
C--- awk generated include file  tgen.h
C---- START of include file tgen.h
C
C---- Stores variables for use in TESTGEN option
C
C     .. Arrays in common /TGEN/ ..
c      REAL XOVER
c      INTEGER ISTATS
C
C     .. Scalars in common /TGEN/ ..
      REAL XOVER,PHSTART,PHEND,PHSTEP,OSCMIN,OSCMAX,SDIVH,SDIVV,
     +     SDELCOR,SDELAMB,SETA,OSCANG,PCMAX
      INTEGER ISTATS
      LOGICAL TESTGEN,TESTRAT
C     ..
C     ..
C     .. Common Block /TGEN/ ..
      COMMON /TGEN/XOVER(2),PHSTART,PHEND,PHSTEP,OSCMIN,OSCMAX,
     +     SDIVH,SDIVV,SDELCOR,SDELAMB,SETA,OSCANG,PCMAX,
     $     ISTATS(MAXPAX,3),TESTGEN,TESTRAT

C&&*&& end_include  ../inc/tgen.f

C     .. Equivalences ..
      EQUIVALENCE (KH(1),ADATA1(1)), (LH(1),ADATA2(1))
C     ..                                          
      SAVE
c     this broke the common blocks
c     DATA NUNIANOT/0/
C     ..

c     20 continue target removed since no longer referenced

      IF (DEBUG(57)) THEN
         WRITE(IOUT,FMT=6200) WAVE,DSTMIN,DSTMAX,NBIN,NEWRUN,AUTO,
     +        NSEGAUTO
         IF (ONLINE) WRITE(ITOUT,FMT=6200) WAVE,DSTMIN,DSTMAX,
     +        NBIN,NEWRUN,AUTO,NSEGAUTO, ntotal
 6200    FORMAT(1X,'IN COMPLETE_ENGINE, wave',F8.4,' dstmin,dstmax',
     +        2F8.6,' nbin',I3,',newrun',L1,' auto',L1,
     +        ' nsegauto',I4, 'ntotal', i8)
      END IF
      DMAX = WAVE/DSTMIN
      DMIN = WAVE/DSTMAX

      dtr = 4.0 * atan(1.0) / 180.0
      STHLMIN = 1.0/ (DMAX)**2
      STHLMAX = 1.0/ (DMIN)**2
      STHINC = (STHLMAX-STHLMIN)/NBIN
      IF (NEWRUN.AND.AUTO) THEN
         IF (NSEGAUTO.EQ.1) THEN
            WRITE(IOUT,FMT=6094)
            IF (ONLINE) WRITE(ITOUT,FMT=6094)
         ELSE IF (NSEGAUTO.GE.2) THEN
            WRITE(IOUT,FMT=6096) NSEGAUTO
            IF (ONLINE) WRITE(ITOUT,FMT=6096) NSEGAUTO
            IF (NSEGAUTO.GT.2) THEN
               WRITE(IOUT,FMT=6098)
               IF (ONLINE) WRITE(ITOUT,FMT=6098)
            END IF
         END IF
      END IF
      IF (NEWRUN) NEWRUN = .FALSE.
 6094 FORMAT(/1X,'Checking completeness of data')
 6096 FORMAT(/1X,'Testing to find the best combination of phi ',
     +     'values for the',I2,' segments')
 6098 FORMAT(1X,'This may take some time......')

      DO 22 I = 1,NBIN
         STH = I*STHINC + STHLMIN
         D(I) = SQRT(1.0/STH)
 22   END DO	

C---- now sort segments into order of increasing phi

C     check to see if > 1 segment
      IF (NSEGIN.gt.1) then
         DO 24 I = 1,NSEGIN
            IPHIA(I) = NINT ( CPHIST(I) )
            IF (DEBUG(57)) THEN
               WRITE(IOUT,FMT=6172) I,IPHIA(I)
               IF (ONLINE) WRITE(ITOUT,FMT=6172) I,IPHIA(I)
 6172          FORMAT(1X,'Segment number',I3,' Starting phi',I5)
            END IF
 24      END DO	
C     *************************
         CALL SORTUP2(NSEGIN,IPHIA,JORDER)
C     *************************
         DO 56 I = 1,NSEGIN
            J = JORDER(I)
            ISPKST(I) = IPKST(J)
            ISPKFI(I) = IPKFI(J)
            SPHIST(I) = CPHIST(J)
            SPHIFI(I) = CPHIFI(J)
            SPHIINC(I) = CPHIINC(J)
 56      END DO	
         DO 58 I = 1,NSEGIN
            IPKST(I) = ISPKST(I)
            IPKFI(I) = ISPKFI(I)
            CPHIST(I) = SPHIST(I)
            CPHIFI(I) = SPHIFI(I)
            CPHIINC(I) = SPHIINC(I)
 58      END DO	

 6010    FORMAT (1X,I3,' Input segments sorted on phi angle')
      end if

      IF (DEBUG(57)) THEN
         WRITE(IOUT,FMT=6011)
         IF (ONLINE) WRITE(ITOUT,FMT=6011)
      END IF
 6011 FORMAT(/1X,'The following predicted reflections will be ',
     +     'included in the analysis')

      IRUNOLD = 0
      DO 80 ISEG = 1,NSEGIN
         IRUN = ICRUN(ISEG)
         IF (IRUN.EQ.0) WRITE(IOUT,*)'ERROR...IRUN=0,ISEG=',ISEG
         IF (IRUN.NE.IRUNOLD) THEN
            IF (DEBUG(57).OR.LAST.OR.(.NOT.AUTO)) THEN
               WRITE(IOUT,FMT=6110) IRUN
               IF (ONLINE) WRITE(ITOUT,FMT=6110) IRUN
            END IF
 6110       FORMAT(1X,'Run number',I3)
            IRUNOLD = IRUN
         END IF
         PHISTI = CPHIST(ISEG) - (IRUN-1)*360.0
         PHIFINI = CPHIFI(ISEG) - (IRUN-1)*360.0
         PHIINCI = CPHIINC(ISEG)

C---- Put into range for printing

         PPHISTI = PHISTI
         PPHIFINI = PHIFINI
         IF (PPHISTI.GT.180) THEN
            PPHISTI = PPHISTI - 360
            PPHIFINI = PPHIFINI - 360
         END IF
         IPKS = IPKST(ISEG)
         IPKF = IPKFI(ISEG)
         IF (DEBUG(57).OR.LAST.OR.(.NOT.AUTO)) THEN
            WRITE (IOUT,FMT=6012) PPHISTI,PPHIFINI,PHIINCI
            IF (ONLINE) WRITE (ITOUT,FMT=6012) PPHISTI,PPHIFINI,
     +           PHIINCI
         END IF
 6012    FORMAT(1X,'From phi=',F6.1,' to',F6.1,' tabulating ',
     +        'statistics in steps of',F4.0,' degrees (STEP keyword)')

C---- calculate number of packs

         NNPACK = NINT((PHIFINI-PHISTI)/PHIINCI)
         IF (PHISTI+NNPACK*PHIINCI.LT.PHIFINI) NNPACK = NNPACK + 1

         IF ((NPACK+NNPACK).GT.MAXPAX) THEN
            WRITE (IOUT,FMT=6014) MAXPAX
            IF (ONLINE) WRITE (ITOUT,FMT=6014) MAXPAX
 6014       FORMAT (//2X,
     +           '** ERROR, Number of Packs Exceeds Parameter ',
     +           'MAXPAX (',I3,') ',/1X,
     +           'Change MAXPAX in code and recompile')
         END IF

         DO 70 I = 1,NNPACK
            J = I + NPACK
            IPSSEG(J) = IPKS
            IPFSEG(J) = IPKF
            PRSTA(J) = (I-1)*PHIINCI + PHISTI
            PRFIN(J) = I*PHIINCI + PHISTI
            IF (I.EQ.NNPACK) PRFIN(J) = PHIFINI
            IF (PRSTA(J).GT.180) THEN
               PRSTA(J) = PRSTA(J) - 360
               PRFIN(J) = PRFIN(J) - 360
            END IF
            CPHISTA(J) = (I-1)*PHIINCI + PHISTI+ (IRUN-1)*360
            CPHIFIN(J) = I*PHIINCI + PHISTI + (IRUN-1)*360
            IF (I.EQ.NNPACK) CPHIFIN(J) = PHIFINI + (IRUN-1)*360
 70      END DO	

         NPACK = NPACK + NNPACK
 80   END DO

      NTOTPACK = NPACK
      IF (DEBUG(57)) THEN
         WRITE (IOUT,FMT=6018) NTOTPACK
         IF (ONLINE) WRITE (ITOUT,FMT=6018) NTOTPACK
      END IF

 6018 FORMAT (/1X,I5,' Packs generated in TOTAL')

      ICLEAR = 0
      MULT = 0
      NIN2 = 0                                        
      MAXMLT = 0

C---- Get the first (acceptable) reflection

 100  continue
      NIN = NIN + 1
      IF (NIN.GT.NTOTAL) GOTO 240
      IP = IORDER(NIN)
      DO 102 I = 1,MCOLSTR
         ADATA1(I) = REAL(IHKLSTR(I,IP))
 102  END DO
      IH = NINT(ADATA1(1))
      IK = NINT(ADATA1(2))
      IL = NINT(ADATA1(3))

      IFLAG = NINT (ADATA1(4))

C---- Calculate IBIN here
C---- Calculate dstarsq in dimensionless rlu

      DSTSQ = IH*IH*RCELL(1)*RCELL(1) +IK*IK*RCELL(2)*RCELL(2)
     +     +IL*IL*RCELL(3)*RCELL(3) + 
     +     2.0*IH*IK*RCELL(1)*RCELL(2)*COS(RCELL(6)*DTR) +
     +     2.0*IK*IL*RCELL(2)*RCELL(3)*COS(RCELL(4)*DTR) +
     +     2.0*IH*IL*RCELL(1)*RCELL(3)*COS(RCELL(5)*DTR)

      S = DSTSQ/(WAVE**2)
      
      IBIN = (S-STHLMIN)/STHINC + 1

C---- Check resolution limits, but only count
C     unique reflections outside resolution limits

      IF ((S.LT.STHLMIN).OR.(S.GT.STHLMAX)) THEN
         IF (IFLAG.EQ.-999) NRESO = NRESO + 1
         GOTO 100
      END IF        
      IF (IBIN.LT.1) THEN
         WRITE(IOUT,*)'IBIN,HKL',IBIN,IH,IK,IL
         IBIN = 1
      END IF
      IF (IBIN.GT.NBIN) THEN
         WRITE(IOUT,*)'IBIN,HKL',IBIN,IH,IK,IL
         IBIN = NBIN           
      END IF

C---- Check that this is indeed a "unique" data record (flag=-999)

      IF (IFLAG.NE.-999) THEN
         IF (MONITOR) THEN 
            IF (NEXTRA.EQ.0) THEN
               WRITE(IOUT,FMT=6005)
 6005          FORMAT(/' Extra reflections that are not present in '/,
     +              ' the unique set will be written to extras.dat'/)
            ENDIF
         ENDIF
         NEXTRA = NEXTRA + 1
         GOTO 100
      END IF

      NIN1 = 1
      NUNIRES(IBIN) = NUNIRES(IBIN) + 1

C---- count no. of acentric terms

      ICEN = NINT (ADATA1(5))
      IF (ICEN .EQ. 1) THEN
         NUNIANO(IBIN) = NUNIANO(IBIN) + 1
         NUNIANOT = NUNIANOT + 1
      END IF

C     ****************************
C---- Get next reflection in list
C     ****************************

 110  continue
      NIN = NIN + 1
      IF (NIN.GT.NTOTAL) GOTO 240
      IP = IORDER(NIN)
      DO 112 I = 1,MCOLSTR
         ADATA2(I) = REAL(IHKLSTR(I,IP))
 112  END DO
      
C---- Test resolution limits on UNIQUE reflections only

      IFLAG = NINT (ADATA2(4))
      IF (DEBUG(57).AND.(NDBG.LT.NDEBUG(57))) THEN
         WRITE(IOUT,FMT=6300) (ADATA2(I),I=1,MCOLSTR)
         IF (ONLINE) WRITE(ITOUT,FMT=6300) (ADATA2(I),I=1,MCOLSTR)
 6300    FORMAT(/,1X,'Next record read: ',10F8.0)
      END IF

      IF (IFLAG.EQ.-999) THEN
         IH = NINT(ADATA2(1))
         IK = NINT(ADATA2(2))
         IL = NINT(ADATA2(3))

C---- Calculate dstarsq in dimensionless rlu

         DSTSQ = IH*IH*RCELL(1)*RCELL(1) +IK*IK*RCELL(2)*RCELL(2)
     +        +IL*IL*RCELL(3)*RCELL(3) + 
     +        2.0*IH*IK*RCELL(1)*RCELL(2)*COS(RCELL(6)*DTR) +
     +        2.0*IK*IL*RCELL(2)*RCELL(3)*COS(RCELL(4)*DTR) +
     +        2.0*IH*IL*RCELL(1)*RCELL(3)*COS(RCELL(5)*DTR)

         S = DSTSQ/(WAVE**2)
         IBIN = (S-STHLMIN)/STHINC + 1

C---- Check resolution limits, but only count
C     unique reflections outside resolution limits

         IF ((S.LT.STHLMIN).OR.(S.GT.STHLMAX)) THEN
            WRITE(IOUT,*)'Rejected sinthl limits',IFLAG,IH,IK,IL
            NRESO = NRESO + 1
            GOTO 110
         END IF                   
         IF (IBIN.LT.1) THEN
            WRITE(IOUT,*)'IBIN,HKL',IBIN,IH,IK,IL
            IBIN = 1
         END IF
         IF (IBIN.GT.NBIN) THEN
            WRITE(IOUT,*)'NBIN,IBIN,HKL',NBIN,IBIN,IH,IK,IL
            IBIN = NBIN           
         END IF

         NUNIRES(IBIN) = NUNIRES(IBIN) + 1

C---- count number of acentric terms as a function of resolution

         ICEN = NINT (ADATA2(5))
         IF (ICEN.EQ.1) THEN
            NUNIANO(IBIN) = NUNIANO(IBIN) + 1
            NUNIANOT = NUNIANOT + 1
         END IF
      END IF

C---- If a generated reflection, check it is within desired segments

      IBATCH = NINT (ADATA2(4))
      IF (IBATCH.EQ.9999) THEN

C---- Note that PHI has been stored originally as a truncated real in an
C     integer. This even though we are using NINT below, this will stilln
C     be the true phi truncated to the nearest smaller integer.

         IPHI = NINT (ADATA2(5))
         DO 120 ISEG = 1,NSEGIN
            IF ((IPHI.GE.NINT(CPHIST(ISEG)).AND.
     +           IPHI.LT.NINT(CPHIFI(ISEG)))) GOTO 125
 120     END DO

C---- Not in requested segments

         GOTO 110
      END IF
 125  CONTINUE

C---- Test indices
c     things like this should really be unrolled

      DO 130 I = 1,3
         HKL1(I) = NINT (KH(I))
         HKL2(I) = NINT (LH(I))
 130  END DO

      IF (HKLEQ(HKL1,HKL2)) THEN

C---- Test that ADATA2 is indeed an generated record (BATCH=9999)

         IBATCH = NINT (ADATA2(4))
         IF (IBATCH.NE.9999) THEN
            WRITE (IOUT,FMT=6024) (ADATA1(JJ),JJ=1,MCOLSTR),
     +           (ADATA2(KK),KK=1,MCOLSTR)
            IF (ONLINE) WRITE (ITOUT,FMT=6024) 
     +           (ADATA1(JJ),JJ=1,MCOLSTR),(ADATA2(KK),KK=1,MCOLSTR)
 6024       FORMAT (//2X,
     +           '*** ERROR, ADATA2 is not an generated Record',/,1X,
     +           'ADATA1=',12F8.2,/1X,'ADATA2=',12F8.2)
         END IF

         NIN2 = NIN2 + 1
         MULT = MULT + 1
         IBINOLD = IBIN
         ICENOLD = ICEN

         IF (MULT.GT.MULTMAX) THEN
            WRITE (IOUT,FMT=6026) MULTMAX
            IF (ONLINE) WRITE (ITOUT,FMT=6026) MULTMAX
 6026       FORMAT (//1X,
     +           '*** ERROR ***',/1X,
     +           '  There are more than ',I3,
     +           ' observations of a reflection.',/,
     +           '  Change parameter MULTMAX  and recompile')
         END IF

C---- extract pack number from the phi angle
C     and the batch limits on each segment

         DO 140 I = 1,NTOTPACK
            IF ((IPHI.GE.NINT(CPHISTA(I))).AND.
     +           (IPHI.LT.NINT(CPHIFIN(I)))) THEN
               NPACK = I
               GOTO 150
            END IF
 140     END DO

C---- Pack not found

         WRITE (IOUT,FMT=6028) (ADATA2(J),J=1,MCOLSTR)
         IF (ONLINE) WRITE (ITOUT,FMT=6028) (ADATA2(J),J=1,MCOLSTR)
 6028    FORMAT (//1X,
     +        '*** ERROR ***',/1X,
     +        'Cant find input pack for this reflection',/1X,F8.2)

 150     continue
         NTOT(NPACK) = NTOT(NPACK) + 1

C---- store symmetry number to test for anomalous pairs

         NISYM(MULT) = NINT (ADATA2(6))

C---- NUNI counts number of unique reflections observed in total

         IF (MULT.EQ.1) THEN
            NUNI = NUNI + 1
            NUNIQA(NPACK) = NUNIQA(NPACK) + 1
            NOBSRES(NPACK,IBIN) = NOBSRES(NPACK,IBIN) + 1
         END IF

C---- Store pack number

         IPACK(MULT) = NPACK
         GOTO 110
      ELSE

C---- hkl not equal...

C     first check that we have got some measured observations

         IF (MULT.EQ.0) GOTO 220

C---- the following code is awfull, sorry ****
C     
C     Set up multiplicities for observations as a function of pack
C     
C     First store number of observations of this hkl for each pack
C     NDIFFPACK counts the number of different packs having this
C     observation, and MULTPACK is the number of observations on each
C     pack (stored in JPACK). NMULT keeps track of total number of
C     observations for this hkl

         NDIFFPACK = 0
         IREF = 1
         NMULT = 0

         IF (DEBUG(57).AND.(NDBG.LT.NDEBUG(57))) THEN
            NDBG = NDBG + 1
            WRITE (IOUT,FMT=6030) KH,MULT, (IPACK(I),I=1,MULT)
            IF (ONLINE) WRITE (ITOUT,FMT=6030) KH,MULT, (IPACK(I),
     +           I=1,MULT)
 6030       FORMAT (//,' Refl',3F5.0,6X,'Mult,Ipack',I5,5X,8I5)
         END IF

         DO 180 I = 1,MULT

C---- check if this observation is to be skipped because this pack
C     has already been dealt with

            IF (I.ge.IREF) then
               NPACK1 = IPACK(I)
               MULTPACK = 1
               NDIFFPACK = NDIFFPACK + 1

               IF (NDIFFPACK.GT.MAXDIFF) THEN
                  WRITE (IOUT,FMT=6032) MAXDIFF
                  IF (ONLINE) WRITE (ITOUT,FMT=6032) MAXDIFF
 6032             FORMAT (//1X,
     +                 '*** ERROR ***',/1X,
     +                 'The limit on the number of different ',
     +                 'packs on which a ',/,
     +                 '  reflection can be observed ',/2X,
     +                 '  (currently ',I4,') has been exceeded',/1X,
     +                 'Recompile the program increasing ',
     +                 'parameter MAXDIFF')
               END IF

               IF (I.EQ.MULT) GOTO 170

C---- see if any more observations from same pack

               DO 160 J = I + 1,MULT
                  NPACK2 = IPACK(J)
                  IF (NPACK2.NE.NPACK1) GOTO 170
                  MULTPACK = MULTPACK + 1
 160           END DO

C---- store different pack numbers and cumulative number of
C     observations  from each pack

 170           continue
               
               JPACK(NDIFFPACK,1) = NPACK1
               JPACK(NDIFFPACK,2) = MULTPACK + NMULT
               NMULT = NMULT + MULTPACK
               IF (NMULT.GT.MULTMAX) THEN
                  WRITE(IOUT,FMT=6033) NMULT,MULTMAX
                  IF (ONLINE) WRITE(ITOUT,FMT=6033) NMULT,MULTMAX
 6033             FORMAT(//1X,'*** ERROR ***',/,1X,'NMULT is',I6,
     +                 ' which exceeds limit of MULTMAX (',I6,')'
     +                 ,/,1X, 'Change PARAMETER MULTMAX and ',
     +                 'recompile program')
                  STOP
               END IF

C---- set counter iref to skip any further observations in same pack
C     at top of do loop

               IREF = I + MULTPACK
            end if
 180     END DO

         IF (DEBUG(57).AND.(NDBG.LT.NDEBUG(57))) THEN
            WRITE (IOUT,FMT=6034) NDIFFPACK,NMULT,
     +           ((JPACK(I,J),J=1,2),I=1,NDIFFPACK)
            IF (ONLINE) WRITE (ITOUT,FMT=6034) NDIFFPACK,NMULT,
     +           ((JPACK(I,J),J=1,2),I=1,NDIFFPACK)
 6034       FORMAT (/,' Ndiffpack,Nmult',2I5,/1X,'Jpack',8 (2I5,5X))
         END IF

C---- now accumulate totals

         JPACK(NDIFFPACK+1,1) = NTOTPACK + 1

         DO 200 I = 1,NDIFFPACK
            NPACK1 = JPACK(I,1)
            NPACK2 = JPACK(I+1,1) - 1
            MULT = JPACK(I,2)
            IF (MULT.GT.MAXMLT) MAXMLT = MULT

            IF (DEBUG(57).AND.(NDBG.LT.NDEBUG(57))) THEN
               WRITE (IOUT,FMT=6036) NPACK1,NPACK2,MULT
               IF (ONLINE) WRITE (ITOUT,FMT=6036) NPACK1,NPACK2,MULT
 6036          FORMAT (' Set up NTIMES for pack ',I5,' to '
     +              ,I5,'  Mult= ',I5)
            END IF

            DO 190 J = NPACK1,NPACK2
               NTIMES(J,MULT) = NTIMES(J,MULT) + 1
 190        END DO
            DO 192 J = NPACK1,NPACK2
               SUM1 = 0
               SUM2 = 0
               DO 194 K = 1,MAXMLT
                  SUM1 = SUM1 + K*NTIMES(J,K)
                  SUM2 = SUM2 + NTIMES(J,K)
 194           end do
               XMULT(J) = 0.0
               IF (SUM2.NE.0) XMULT(J) = SUM1/SUM2
 192        end do
 200     end do

C---- now test for presence of anomalous pairs in generated data,
C     if this is an acentric reflection

         IF ((NMULT.EQ.1) .OR. (ICENOLD.EQ.0)) GOTO 220
         NANO = 0
         DO 210 I = 2,NMULT
            IF (NISYM(I).NE.NISYM(I-1)) NANO = 1
 210     end do
         NANOM(IBINOLD) = NANOM(IBINOLD) + NANO
         NANOMT = NANOMT + NANO

C---- check that ADATA2 is indeed a unique record (flag=-999),
C     if not skip to next record

 220     continue
         IFLAG = NINT (ADATA2(4))

         IF (IFLAG.NE.-999) THEN
            NEXTRA = NEXTRA + 1
            WRITE(IOUT,*)'EXTRA REFLECTION',(ADATA2(I),I=1,3)

C---- set mult=0 so the previous set of observations are not added
C     in again

            MULT = 0
            GOTO 110
         END IF

C---- transfer ADATA2 to to ADATA1 and read next record

         DO 230 I = 1,MCOLSTR
            ADATA1(I) = ADATA2(I)
 230     END DO

         MULT = 0
         NIN1 = NIN1 + 1
         GOTO 110
      END IF

C---- End of file, print statistics
C     first cumulate number of unique reflections

 240  CONTINUE
      NPACK = NTOTPACK

      DO 260 I = 1,NBIN
         DO 250 J = 1,NPACK
            NTOTRES(I) = NTOTRES(I) + NOBSRES(J,I)
 250     END DO

         SN = NUNIRES(I)
         SN2 = NUNIANO(I)
         IF (SN.ne.0) then 
            PCENT(I) = (NTOTRES(I)*100.0)/SN
            IF (SN2.EQ.0) GOTO 260
            PCENTANO(I) = (NANOM(I)*100.0)/SN2
         end if
 260  END DO

      IF (NPACK.EQ.1) return

      DO 270 I = 2,NPACK
         NUNIQA(I) = NUNIQA(I-1) + NUNIQA(I)
         IF (NIN1.NE.0) PCUNIQA(I) = 100*REAL(NUNIQA(I))/REAL(NIN1)
 270  END DO
      
      return

      end
















c     complete_setup.f
c     originally by G.Winter
c     26th September 2002
c     
c     A replacement for the complete subroutine which 
c     is something of a muddle. This should flow in a more one
c     way manner. (imho)
c     
c     Subroutine flow:
c     
c     initialisation (1)
c     if(first time of runniing after strategy calculation) then
c     initialisation (2)
c     end if
c     parsing of input (discussed below)
c     switch dependant on input 
c     completeness/uniqueness calculations for defined phi ranges
c     testgen (default)
c     calculate statistics
c     
c     Possible input:
c     complete_setup
c     
c     complete_setup start $angle end $angle step $angle
c     complete_setup testgen on etc.
c     
c     complete_setup oldsegments 3 start 0 end 20 start 40 end 60 start 80 
c     end 120 segments 2 totalwidth 60 phistart 0 phiend 90
c     
c     
c     
c     
c     
c     notes:
c     the input to complete requires a couple of fun beasties -
c     ihklstr, ntotal and iorder - these need sorting out. 
c     
c     Required functionality:
c     1. Set the speed-up - done in strategy_setup
c     2. Optimise for anomolous scattering  - autanom = .true.
c     ---done
c     3. Setting a resolution limit - do this from the mosflm end of things?
c     4. Setting the space group - more complicated - call mrdsymm?
c     ---This already exists in the form of the symmetry keyword...
c     ---can we use this? yes we can!
c     5. TOTAL ROTATION - not size of segments...
c     ---this just requires sorting out the algroithm for separating out
c     ---the sizes of the n segments -- fixed
c     6. Get the multiplicity? No idea what this is! :o)
c     ---fixed this now
c     Nearly there otherwise... even getting things to work through the server
c     7. Next need to work on all of the FORMAT statements.....
c     8. Need to figure out how to add the matrix files...
c     
c     
c     $Id: complete_setup.f,v 1.25 2004/06/02 14:32:57 harry Exp $
c     

      subroutine complete_setup(argc, argv, types, values)

      implicit none

c     include statements

      integer nparm
      parameter (nparm = 200)
      
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C&&*&& include  ../inc/completedata.f
C     ..      
C     .. Local Scalars ..
      REAL PC,PC1,PHIFINI,PHIINCI,PHISTI,SN,SN2,STH,DTR,XSEP,YSEP,
     +     SMAX,SMIN,RESMAX,RESMIN,SRESOL,STHINC,STHLMIN,STHLMAX,
     +     DMAX,DMIN,DSTSQ,S,PHI1,PHI2,PHIINCR,CPHISTART,CPHIEND,
     +     PHISEG,PHIFINAL,PHISTAUTO,X,PHITOT,PPHISTI,PPHIFINI,
     +     AUTOINC,PHIADDAUTO,SUM1,SUM2
      INTEGER I,IBATCH,IBIN,ICEN,IFLAG,IPHI,IPKF,IPKS,IREF,ISEG,J,K,
     +     KPACK,MAXMLT,MULT,MULTPACK,N,N1,N2,NACROSS,NANO,
     +     NANOMT,NBITS,NDIFFPACK,NEXTRA,NIN,NIN1,NIN2,
     +     NMULT,NNPACK,NPACK,NPACK1,NPACK2,NPRINT,NRESO,NSEGIN,
     +     NTOTPACK,NUNI,NUNIANOT,NLPRGI,IPRINT,NBIN,NBIT,
     +     NTOK,IFSEG,IH,IK,IL,ITINS,JJ,ICOUNT,KK,ISTA,IFIN,IP,
     +     IMODE,ICLEAR,IRUN,IRUNOLD,JRUN,IBINOLD,ICOMB,IROT,
     +     NSEGSTART,ISTAFLG,IENDFLG,NDBG,ICENOLD,ISIZE,
     +     IMAT,IUMAT,ICELL,ICHECK,MTZPRT,NCH
      LOGICAL DUMPSPOT,EOF,MONITOR,COMREAD,STARTOK,ENDOK,RESET,LAST,
     +     NEWRUN,DONETEST,INERR,NULINE

C     ..                   
C     .. Local Arrays ..
      REAL D(NRESBIN),PCENT(NRESBIN),PCENTANO(NRESBIN),CPHIFI(NSEGMAX),
     +     CPHIFIN(MAXPAX),CPHIST(NSEGMAX),CPHIINC(NSEGMAX),
     +     CPHISTA(MAXPAX),SPHIFI(NSEGMAX),CPHIADD(NSEGMAX),
     +     SPHIINC(NSEGMAX),SPHIST(NSEGMAX),ADATA1(MCOLSTR),
     +     ADATA2(MCOLSTR),KH(3),LH(3),VALUE(NPARM),PRSTA(MAXPAX),
     +     PRFIN(MAXPAX),PHSBEST(NSEGMAX),PCUNIQA(MAXPAX),XMULT(MAXPAX)
      INTEGER IPACK(MULTMAX),HKL1(3),HKL2(3),
     +     IPFSEG(MAXPAX),IPKFI(NSEGMAX),
     +     IPKST(NSEGMAX),IPSSEG(MAXPAX),ISPKFI(NSEGMAX),
     +     ISPKST(NSEGMAX),JPACK(MAXDIFF+1,2),
     +     LOOKUP(MCOLSTR),NANOM(NRESBIN),NISYM(MULTMAX),
     +     NOBSRES(MAXPAX,NRESBIN),NTIMES(MAXPAX,MULTMAX),
     +     NTOT(MAXPAX),NTOTRES(NRESBIN),NUNIANO(NRESBIN),
     +     NUNIQA(MAXPAX),NUNIRES(NRESBIN),IBEG(NPARM),IDEC(NPARM),
     +     IEND(NPARM),ITYP(NPARM),IFIRST(NSEGMAX),ICRUN(NSEGMAX)
      INTEGER*2 JORDER(NSEGMAX),IPHIA(NSEGMAX)
      
      COMMON /noddyblka/ PC,PC1,PHIFINI,PHIINCI,PHISTI,SN,SN2,
     +     STH,DTR,XSEP,YSEP,
     +     SMAX,SMIN,RESMAX,RESMIN,SRESOL,STHINC,STHLMIN,STHLMAX,
     +     DMAX,DMIN,DSTSQ,S,PHI1,PHI2,PHIINCR,CPHISTART,CPHIEND,
     +     PHISEG,PHIFINAL,PHISTAUTO,X,PHITOT,PPHISTI,PPHIFINI,
     +     AUTOINC,PHIADDAUTO,SUM1,SUM2

      common /noddyblkb/ I,IBATCH,IBIN,ICEN,IFLAG,IPHI,IPKF,IPKS,
     +     IREF,ISEG,J,K,
     +     KPACK,MAXMLT,MULT,MULTPACK,N,N1,N2,NACROSS,NANO,
     +     NANOMT,NBITS,nunianot,NDIFFPACK,NEXTRA,NIN,NIN1,NIN2,
     +     NMULT,NNPACK,NPACK,NPACK1,NPACK2,NPRINT,NRESO,NSEGIN,
     +     NTOTPACK,NUNI,NLPRGI,IPRINT,NBIN,NBIT,
     +     NTOK,IFSEG,IH,IK,IL,ITINS,JJ,ICOUNT,KK,ISTA,IFIN,IP,
     +     IMODE,ICLEAR,IRUN,IRUNOLD,JRUN,IBINOLD,ICOMB,IROT

      common /noddyblkc/ NSEGSTART,ISTAFLG,IENDFLG,NDBG,ICENOLD,ISIZE,
     +     IMAT,IUMAT,ICELL,ICHECK,MTZPRT,NCH,
     +     DUMPSPOT,EOF,MONITOR,COMREAD,STARTOK,ENDOK,RESET,LAST,
     +     NEWRUN,DONETEST,INERR,NULINE,
     +     D,PCENT,PCENTANO,CPHIFI,CPHIFIN,CPHIST,CPHIINC,
     +     CPHISTA,SPHIFI,CPHIADD,
     +     SPHIINC,SPHIST,ADATA1,
     +     ADATA2,VALUE,PRSTA

      common /noddyblkd/ PRFIN,PHSBEST,PCUNIQA,
     +     XMULT, IPACK,HKL1,HKL2,
     +     IPFSEG,IPKFI,
     +     IPKST,IPSSEG,ISPKFI,
     +     ISPKST,JPACK,
     +     LOOKUP,NANOM,NISYM,
     +     NOBSRES,NTIMES,
     +     NTOT,NTOTRES,NUNIANO,
     +     NUNIQA,NUNIRES,IBEG,IDEC,
     +     IEND,ITYP,IFIRST,ICRUN,
     +     JORDER,IPHIA
C&&*&& end_include  ../inc/completedata.f
C&&*&& include  ../inc/cell.f
C
C $Id: cell.f,v 1.2 2003/06/16 16:41:13 harry Exp $
C
C--- awk generated include file  cell.h
C---- START of include file cell.h
C
C     CELL cell dimensions (real space)
C     RCELL reciprocal cell parameters in dimensionless rlu
C
C     .. Arrays in Common /CELLCOM/ ..
      REAL UMAT,BMAT,GMAT,CELL,RCELL,UMATCELL,SOFTCELL
      INTEGER LCELL,ICRYST,NUMSPG,NLAUE
C     ..
C     .. Common Block /CELLCOM/ ..
      COMMON /CELLCOM/UMAT(3,3),BMAT(3,3),GMAT(3,3),CELL(6),RCELL(6),
     $       UMATCELL(6),SOFTCELL,LCELL(6),ICRYST,NUMSPG,NLAUE
C     ..
C
C
C&&*&& end_include  ../inc/cell.f
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/dsplyc.f
C
C $Id: dsplyc.f,v 1.1 2002/05/02 10:46:46 harry Exp $
C
C--- awk generated include file  dsplyc.h
C---- START of include file dsplyc.h
C
C*******************************************************************
C
C  COMMON  /DSPLYC/
C
C	IMGLOW, IMGHI	low & high values of 16-bit image for scaling
C			integer*2 to byte: IMGLOW maps to  0; 
C			IMGHI to maximum. Note that these are not
C			necessarily the actual limits of the data
C	JDSPWD		.LT. 0  before image window has been created
C                       = +-1 for image display that can be panned
C                       = +-2 for non-interactive image display
C       MAXDEN          highest level in colour table to fill up to
C                       must be less than ~240 - number of overlay colours
C       LDSPSG          if .true., treat image as signed, ie after dark
C                          subtraction
C                       if .false., treat image as unsigned
C       NZOOM           zoom factor for image, = 0 if no zoom
C       JYZOOM, JZZOOM  1st pixel in zoomed image
C
C----   WINOPEN Flag for whether or not window is open. Do not
C               confuse with DISPMENU (/CONDATA/)which is true if the run was
C               started with a IMAGE keyword.
C
C
C       CDSPTL          banner title
C
      INTEGER IMGLOW, IMGHI, JDSPWD, MAXDEN,
     $     NZOOM, JYZOOM, JZZOOM
      LOGICAL LDSPSG,WINOPEN,LPAUSE,LHELP
      COMMON /DSPLYC/ IMGLOW, IMGHI, JDSPWD,
     *     MAXDEN, NZOOM, JYZOOM, JZZOOM, LDSPSG,WINOPEN,LPAUSE,LHELP
C
      CHARACTER  CDSPTL*200
      COMMON /DSPLCC/  CDSPTL
C                                                           
C
C*******************************************************************


C&&*&& end_include  ../inc/dsplyc.f
C&&*&& include  ../inc/gui.f
c     gui.h
c     maintained by G.Winter
c     16th April 2002
c     $Id: gui.f,v 1.16 2003/04/04 14:22:01 harry Exp $
c     
c     This defines the variables and common blocks which are used by the
c     new gui control routine. This will also be used in xdisp and control,
c     to switch the new gui on!
c     
c     

      logical gui_switch, refine_cell(6), refine_detector(11),
     +     autocomplete, autoreturn, newmatstore
      integer nargs
      integer imageno, nstart
      parameter (nargs = 200)

c     refine_detector logical block index:
c     1: beam x 2: beam y 3: ccomega 4: yscale
c     5: distance 6: tilt 7: twist 8: roff 9: toff
c     
c     refine_cell logical block index:
c     1: a 2: b 3: c
c     4: alpha 5: beta 6: gamma
c     
c     
c     

      integer keep_phi_segments, keep_phi_start(20), 
     +     keep_phi_end(20)

      real storemeanmult

      common /gui/ gui_switch, imageno, refine_cell, refine_detector,
     +     autocomplete, nstart, autoreturn, newmatstore

      common /keep_phi/ keep_phi_segments, keep_phi_start, 
     +     keep_phi_end, storemeanmult


c     refine_cell(i) is true if you wish to refine cell(i)
C&&*&& end_include  ../inc/gui.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/ioosum.f
C
C $Id: ioosum.f,v 1.2 2004/08/16 13:26:27 harry Exp $
C
C--- awk generated include file  ioosum.h
C---- START of include file ioosum.h
C
C     .. Scalars in common block /IOOSUM/
      INTEGER NLSUM1,NLSUM2,NSUMSTART1,NSUMSTART2
C
C     .. Arrays in common block /IOOSUMC/ ..
      CHARACTER*150 LINESUM1(MAXPAX),LINESUM2(MAXPAX)
      CHARACTER*101  IOLINE(100)
C     ..
C     .. Common block /IOOSUM/ ..
      COMMON /IOOSUM/ NLSUM1,NLSUM2,NSUMSTART1,NSUMSTART2
C     ..
C     .. Common block /IOOSUMC/ ..
      COMMON /IOOSUMC/ LINESUM1,LINESUM2,IOLINE
C&&*&& end_include  ../inc/ioosum.f
C&&*&& include  ../inc/ioomtz.f
C
C $Id: ioomtz.f,v 1.3 2004/05/14 15:44:19 harry Exp $
C
C--- awk generated include file  ioomtz.h
C---- START of include file ioomtz.h
C
C
C     .. Scalars in common block /IOOMTZ/ ..
      INTEGER MTZOUT,BESTHKL
      LOGICAL MTZOPEN
      CHARACTER*100 BSTHKL
C     ..
C     .. Common block /IOOMTZ/ ..
      COMMON /IOOMTZ/ MTZOUT,BESTHKL,MTZOPEN,BSTHKL
C&&*&& end_include  ../inc/ioomtz.f
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
C&&*&& include  ../inc/over.f
C
C $Id: over.f,v 1.1 2002/05/02 10:47:03 harry Exp $
C
C--- awk generated include file  over.h
C---- START of include file over.h
C
C
C     .. Scalars in Common Block /OVER/ ..
C
C     ..
C     .. Scalars in common /OVER/ ..
      INTEGER MINDTX,MINDTY,NPOVL,IXSEP,IYSEP
C     ..
C     .. ARRAYS in common /OVER/ ..
      INTEGER HKLPOVL
C     ..
C     .. Common Block /OVER/ ..
      COMMON /OVER/MINDTX,MINDTY,NPOVL,IXSEP,IYSEP,HKLPOVL(NREFLS/2)
C     ..
C
C
C&&*&& end_include  ../inc/over.f
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/strat.f
C--- awk generated include file  strat.h
C---- START of include file strat.h
C
C---- Stores variables for use in STRATEGY option
C     IROTAX is the axis closest to the rotation axis
C     PHIROTAX is the angle this axis makes with the rotation axis
C
C     PHIZONE is the phi value at which axis "IZONEAX" is along the
C     X-ray beam. (IZONEAX = 1 is a, =2 is b, =3 is c)
C     PHIPAD  is the rotation to be added to PHILAUE to ensure generation
C             of all unique data, and will depend on angle between the
C             unique axis and the rotation axis.
C     AUTANOM if true tries to maximise number of anomalous pairs
C     CELLSCAL is the scale factor applied to the cell edges to
C              speed up the calculation.
C     SHRUNK   is TRUE if the cell has been scaled by CELLSCAL
C     ISTRUN   is used to increment input phi angles by multiples of
C              360 degrees, so that phi values in different parts can
C              be recognised. It starts at zero.
C     FIRSTRAT Starts as TRUE (set in MOSDATA) and is set to FALSE once
C              the MTZ file has been opened for a STRATEGY run.
C              Reset TRUE after EXITing from STRATGEY prompt.
C
C     .. Scalars in common /STRAT/ ..
      INTEGER NSEGM,IPCKCUR,NSTRAT,NUNIQ,NSTRUN,ISTRUN,NSEGAUTO,
     +        IZONEAX,IROTAX,NLAST,NNPACKS,NLASTPACK
      LOGICAL STRATEGY,AUTO,SIZESET,AUTANOM,SHRUNK,FIRSTRAT,
     +         NEWSTRAT,WAITINP,OFFPHI
      REAL ROTAUTO,PHILAUE,PHIPAD,PHIZONE,PHIROTAX,CELLSCAL
C     ..
C     .. Arrays in common /STRAT/ ..
      REAL PHIST,PHIFIN,PHIINC,PHIADD,PHISEGA
      INTEGER IFIRSTONE
C     ..
C     .. Common Block /STRAT/ ..
      COMMON /STRAT/ PHIST(NSEGMAX),PHIFIN(NSEGMAX),PHIINC(NSEGMAX),
     +       PHIADD(NSEGMAX),PHISEGA(NSEGMAX),ROTAUTO,PHILAUE,PHIPAD,
     $       PHIZONE,PHIROTAX,CELLSCAL,IFIRSTONE(NSEGMAX),
     $       NSEGM,IPCKCUR,NSTRAT,NUNIQ,
     +       NSTRUN,ISTRUN,NSEGAUTO,
     +       IZONEAX,IROTAX,NLAST,NNPACKS,NLASTPACK,
     +       STRATEGY,AUTO,SIZESET,AUTANOM,SHRUNK,
     +       FIRSTRAT,NEWSTRAT,WAITINP,
     +       OFFPHI
C     ..
C
C


      
C&&*&& end_include  ../inc/strat.f
C&&*&& include  ../inc/strategy_header.f
c     strategy_header.f
c     maintained by G.Winter
c     14th October 2002
c     
c     Header for the communication of strategy instructions between
c     subroutines...
c     
c     
c     

      logical accumulate
      integer test_offset

      common /strategy_header/ accumulate, test_offset

C&&*&& end_include  ../inc/strategy_header.f
C&&*&& include  ../inc/tgen.f
C
C $Id: tgen.f,v 1.1 2002/05/02 10:47:23 harry Exp $
C
C--- awk generated include file  tgen.h
C---- START of include file tgen.h
C
C---- Stores variables for use in TESTGEN option
C
C     .. Arrays in common /TGEN/ ..
c      REAL XOVER
c      INTEGER ISTATS
C
C     .. Scalars in common /TGEN/ ..
      REAL XOVER,PHSTART,PHEND,PHSTEP,OSCMIN,OSCMAX,SDIVH,SDIVV,
     +     SDELCOR,SDELAMB,SETA,OSCANG,PCMAX
      INTEGER ISTATS
      LOGICAL TESTGEN,TESTRAT
C     ..
C     ..
C     .. Common Block /TGEN/ ..
      COMMON /TGEN/XOVER(2),PHSTART,PHEND,PHSTEP,OSCMIN,OSCMAX,
     +     SDIVH,SDIVV,SDELCOR,SDELAMB,SETA,OSCANG,PCMAX,
     $     ISTATS(MAXPAX,3),TESTGEN,TESTRAT

C&&*&& end_include  ../inc/tgen.f

c     definition of the input variables

      integer argc
      character*80 argv(nargs)
      integer types(nargs)
      real values(nargs)

c     locally used strings - string to write output into, and 
c     words which can be ccplwc'd

      character*80 word, optionvalue, badtype, badvalue, 
     +     segmentword

      integer status, numrefl
      integer*2 ihklstr(mcolstr, nrefstr)
      integer iorder(nrefstr)

c     definitions of local arrays:
c     
c     savestart, end etc are where the best segments are kept
c     searchstart, end describe the limits of the search for each segment
c     autostart, end are the ends of a segment which will be varied
c     staticstart, end are the limits of predefined segments (ie no change)
c     

      integer segmentcount, COUNT
      real autostart(10), autoend(10), width(10)
      real searchstart(10), searchend(10)
      real savestart(10), saveend(10), savewidth(10)
      real staticstart(10), staticend(10)
      real step, phistartauto, phiendauto
      real start(300), end(300), stepsize(300)

      real dtor, startphi, endphi, stepphi, meanmult
      integer totalwidth
      logical dotestgen, error, autosegments, manual_phi
      integer permutations, oldsegcount

c     share the space between the image and the hkl string...
c     must include pel to get the image in... WHY is this done? Is it
C     to save memory usage? If so, the second half of image should be
C     used since this should never interfere with other code.

      equivalence (ihklstr(1,1),image(1))

c     external subroutines and functions

      external ccplwc, lenstr, istrue, input_error
      integer lenstr
      logical istrue

c     initialisation 1
c     initialisation which should occur on every call of this
c     subroutine


c     things learned from fiddling:
c     1 need to properly initialise nsegauto etc
c     2 step is stored in cphiinc(i)
c     3 phi ranges need to be set - phistartauto etc
c     4 must be sure to properly initialise variables before call to comp_eng
c     5 need to make it so that segments which already exist can be used

      npack = 0

c     auto = .irrelevant. ? or is it used by complete_engine. I expect so
      auto = .true.
      autosegments = .false.
      manual_phi = .false.
      segmentcount = 2
      nsegauto = 2
      nsegin = 2
      step = 5
      xover(1) = 10.0
      pcmax = 0
      nuni = 0
      
      do i = 1, 10
         width(i) = 0
      end do

      if (.not. auto) then
         nsegin = 0
      end if
      nunianot = 0
      nin1 = 0
      nreso = 0
      nextra = 0
      nin = 0
      nanomt = 0
      iclear = 1

      phistartauto = 0
      phiendauto = 40

c     initialise things on a bin-by-bin basis
c     number of unique reflections in a bin = 0
c     number of unique anomolous reflections = 0
c     number of anomolous reflections = 0 
c     total number of reflections in this resolution bin = 0

      do i = 1, nresbin
         nunires(i) = 0
         nuniano(i) = 0
         nanom(i) = 0
         ntotres(i) = 0
      end do

c     initialise things which refer to `image' (pack)
c     total reflections in image = 0
c     total unique reflections in image = 0
c     number of observations in each resolution bin = 0
c     multiplicity of reflections in the image = 0

      do i = 1, maxpax
         ntot(i) = 0
         nuniqa(i) = 0
         do j = 1, nresbin
            nobsres(i, j) = 0
         end do
         do j = 1, multmax
            ntimes(i, j) = 0
         end do
      end do

c     initialise all of the other mysterious things which go on in mosflm
      do i = 1, maxdiff + 1
         jpack(i, 1) = 0
         jpack(i, 2) = 0
      end do

c     initialise the rotation segments
c     is icrun the parent strategy run? is the appropriate segment of data
      do i = 1, nsegmax
         ifirst(i) = 0
         ipkst(i) = 0
         ipkfi(i) = 0
         icrun(i) = 1
      end do

c     initialisation 1
c     initialisation of things which should only be done after performing
c     a strategy calculation - ie newstrategy = .true.
c     

c     some of these might be bad initialisation values
c     

      reset = .false.
      last = .false.
      newrun = .false.
      itins = itin
      dtor = 4.0 * atan(1.0) / 180.0
      monitor = .true.
      dumpspot = .false.
      phiincr = 0.0
      
c     turn of the recording of statistics imode -> statsmode
      imode = 0
      
c     number of resolution bins
      nbin = 8
      nacross = 4
      
c     next parse the input at the top of the subroutine - first
c     need to initialise the stuff which will be set by the command
c     line input

      if(argc .eq. 1) then
c     we had no input - by default perform a testgen calculation
c     if a strategy has just been calculated
         do i = 1, nsegm
            cphist(i) = phist(i)
            cphifi(i) = phifin(i)
            cphiinc(i) = phiinc(i)
         end do

         call retrievehkl(ihklstr, numrefl, status)

c     some of this will be unnecessary
         nsegin = nsegm
         nsegauto = nsegm
         segmentcount = nsegm
         npack = 0
         nuni = 0
         nin = 0
         do i = 1,numrefl
           iorder(i) = ihklstr(1,nstart+i-1)
         enddo
         call complete_engine(ihklstr, numrefl, 
     +        iorder)

         meanmult = 0.0
         do i = 1, npack
            meanmult = meanmult + xmult(i)
         end do
         meanmult = meanmult / real(npack)
         write(iout, 127) meanmult
         if(online) then
            write(itout, 127) meanmult
         end if
        
 127     format('Mean Multiplicity = ', f5.2)
         storemeanmult = meanmult
c     pcmax = pc to store the value, so that it can be printed out 
c     in the XML printing subroutines elsewhere...

         pc = (100.0 * nuni) / real(nin1)
         pcmax = pc

         write(iout, 125) pc
         write(itout, 125) pc
         
 125     format('Percentage Completeness = ', f7.2)

c     this is not used...

 126     format('<?xml version="1.0"?><!DOCTYPE ',
     +        'strategy_completeness>',
     +        '<strategy_completeness>', f7.2,
     +        '</strategy_completeness>')

c     perform the testgen calculation too - just for fun

         phstart = phist(1)
         phend = phifin(1)
         
         newrun = .true.
         strategy = .false.
         
         xover(1) = 10.0

c     retrieve the stored parameters
         
         eta = seta
         divh = sdivh
         divv = sdivv
         delcor = sdelcor
         delamb = sdelamb
         
         if(shrunk) then
            call unshrinkcell
         end if
         
         call testover

c     don't need this test!

         if(cellscal .ne. 1.0) then
            call shrinkcell
         end if

         if(shrunk) then
            call unshrinkcell
         end if

         return
      else
         auto = .false.
         dotestgen = .false.
      end if

c     this is irrelevant anyway... :o)

c     start the k for parsing the input - this should
c     be handled in a cleverer way - would certainly to this
c     more cleverly in `c'...

      i = 2

c     initialise the error handling things

      error = .false.
      badtype = ' '
      badvalue = ' '

c     checked this - it won't go around if i >= argc

      do while(i .lt. argc)
         word = argv(i)
         call ccplwc(word)

         if(word .eq. 'testgen') then
            optionvalue = argv(i + 1)
            call ccplwc(optionvalue)
            dotestgen = istrue(optionvalue)

c     check for the input phi limits 

         else if(word .eq. 'start') then
            if(types(i + 1) .eq. 2) then
               startphi = nint(values(i + 1))
            else
               call input_error('strategy_response', argv(i),
     +              argv(i + 1), 'integer')
               return
            end if

         else if(word .eq. 'end') then
            if(types(i + 1) .eq. 2) then
               endphi = nint(values(i + 1))
            else
               call input_error('strategy_response', argv(i),
     +              argv(i + 1), 'integer')
               return
            end if

         else if(word .eq. 'step') then
            if(types(i + 1) .eq. 2) then
               stepphi = nint(values(i + 1))
            else
               call input_error('strategy_response', argv(i),
     +              argv(i + 1), 'integer')
               return
            end if

         else if(word .eq. 'oldsegments') then
c     read in the old segments - first get the number of segments,
c     then confirm that the next 2 * n `keywords' are correct - 
c     ie determining the start and end of each of the old segments

c     this is almost certainly a suboptimal way of doing things.

            if(types(i + 1) .eq. 2) then
               oldsegcount  = nint(values(i + 1))
            else
               call input_error('strategy_response', argv(i),
     +              argv(i + 1), 'integer')
               return
            end if

c     given that we have got this far, the oldsegcount must be a reasonable
c     number - check this

            if(oldsegcount .le. 0) then
c     just ignore it...
            else
c     first check that the next sets of input words are correct
               do j = i + 2, i + (2 * oldsegcount), 2
                  if(j .gt. argc) then
c     this is definately bad input!
                     write(iout, 12)
                     return
                  end if
                  segmentword = argv(j)
                  call ccplwc(segmentword)
                  if((segmentword .ne. 'start') .and.
     +                 (segmentword .ne. 'end')) then
c     throw an error since this input is bad
                     write(iout, 12)
                     return
                  end if
               end do

 12            format('This is bad input - it should be start value ',
     +              'end value start value end value')

c     read in the segments
               
               k = 0
               do j = i + 2, i + 2 + (2 * oldsegcount), 2 
                  segmentword = argv(j)
                  call ccplwc(segmentword)
                  if(segmentword .eq. 'start') then
c     only increment the storage on the start keyword! duh!
                     k = k + 1
                     staticstart(k) = nint(values(j + 1))
                  else
                     staticend(k) = nint(values(j + 1))
                  end if
               end do
c     advance the read pointer the appropriate number of words
               i = i + 2 * oldsegcount
            end if

         else if(word .eq. 'phistart') then
            if(types(i + 1) .eq. 2) then
               phistartauto = nint(values(i + 1))
               manual_phi = .true.
            else
               call input_error('strategy_response', argv(i),
     +              argv(i + 1), 'integer')
               return
            end if
            
         else if(word .eq. 'phiend') then
            if(types(i + 1) .eq. 2) then
               phiendauto = nint(values(i + 1))
               manual_phi = .true.
            else
               call input_error('strategy_response', argv(i),
     +              argv(i + 1), 'integer')
               return
            end if

         else if(word .eq. 'segments') then
            if(types(i + 1) .eq. 2) then
               auto = .true.

c     this smells - there are too many places where this number 
c     ma be stored... - so reduce the count. 
c     
c     nsegin - used by complete_engine so this is needed
c     nsegauto isn't
c     segmentcount is only used within this subroutine

               segmentcount = nint(values(i + 1))
               nsegin = segmentcount
               nsegauto = segmentcount
               totalwidth = 0
               autosegments = .true.
            else
               call input_error('strategy_response', argv(i),
     +              argv(i + 1), 'integer')
               return
            end if

         else if(word .eq. 'anomolous') then
            optionvalue = argv(i + 1)
            call ccplwc(optionvalue)
            autanom = istrue(optionvalue)

         else if(word .eq. 'totalwidth') then
            if(types(i + 1) .eq. 2) then
               totalwidth = nint(values(i + 1))
               do j = 1, 10
                  width(j) = totalwidth
               end do

c     the widths of the segments will be determined when the number of
c     segments is specified - so this will have to be after all of the
c     keywords input is parsed

               autosegments = .true.

            else
               call input_error('strategy_response', argv(i),
     +              argv(i + 1), 'integer')
               return
            end if

         else if(word .eq. 'overlap') then
            if(types(i + 1) .eq. 2) then
               xover(1) = values(i + 1)
            else
               call input_error('strategy_response', argv(i),
     +              argv(i + 1), 'integer')
               return
            end if
 
         else if(word .eq . 'usestrategy') then
            optionvalue = argv(i + 1)
            call ccplwc(optionvalue)
            if(istrue(optionvalue)) then
               phistartauto = phist(1)
               phiendauto = phifin(1)
            end if
           
         else
            write(iout, *) 'option ', word(1:lenstr(word)), 
     +           ' not recognised'
            return
c     end loop over input options
         end if

c     increment the pointer by two words (option + value)
         i = i + 2
      end do

c     next determine the actions to peform, and perform them

      if(autosegments) then
c     we need to automatically determine the segment sizes from totalwidth
         if(totalwidth .eq. 0) then
c     throw an error
            totalwidth = philaue
c            return
         end if

         call determine_segments(segmentcount, totalwidth, width)

         do i = 1, segmentcount
            write(iout, 123) i, nint(width(i))
         end do

         if(online) then
            do i = 1, segmentcount
               write(itout, 123) i, nint(width(i))
            end do
         end if

 123     format('Segment ', i4, ' width = ', i4)

      end if

      if(.not. manual_phi) then
c     copy across the automatic values
         phistartauto = phist(1)
         phiendauto = phifin(1)
      end if

c     first, are we atuomatically calculating segments - if so, we
c     need to compute and test them!
      if(auto) then
         
c     first run a little loop calculation to determine the number of
c     permutations

         permutations = 0
c     compute the end condition - that the most slowly incrementing
c     segment has finished incrementing


c     arrays:
c     segment(start|end)(i) the start/end of segment (i)
c     nsegauto integer giving the number of automatic segments
c     search(start|end)(i) the start and end of the allowed ranges for
c     each thing...

c     initialise the allowable limits on the regions - this is tested

         do i = 1, 10
c     need to think about these limits - the setting of width(i) to
c     0 might not be too clever... :o(
            if(i .le. (nsegauto + oldsegcount)) then
               searchstart(i) = phistartauto - width(i)
               searchend(i) = phiendauto + width(i)
               do j = 1, i
                  searchstart(i) = searchstart(i) + width(j)
               end do
               do j = i, nsegauto
                  searchend(i) = searchend(i) - width(j)
               end do
            else
               searchstart(i) = phistartauto
               searchend(i) = phiendauto
               width(i) = 0
            end if
         end do

c     probably clearer to have a subroutine for the purposes of testing the 
c     segments - this way we can have a clear and flexible loop without
c     masses of code in...

c     loop discussion
c     after a little figuring out, the best thing appears to be to have the 
c     first segment iterated most rapidly, followed by the second etc, 
c     and have them reverse iterated - ie search the segment space backwards 
c     can this be different? yes. Oh. It can be written this way though...

c     the outer layers of the loop will only be run through once when
c     there isn't a segment to be tested...
c     
c     
c     

c     before calling the complete_engine subroutine, will need (want)
c     to refresh the information in the hklstr with retrievehkl...

         status = 0
         call retrievehkl(ihklstr, numrefl, status)

c     make sure that the reflections were retireved successfully...


         do i = 1, 4
            write(iout, 300) i, nint(searchstart(i)), 
     +           nint(searchend(i))
         end do
 
         if(online) then
            do i = 1, 4
               write(itout, 300) i, nint(searchstart(i)), 
     +              nint(searchend(i))
            end do
         end if
        
 300     format('Search region ', i2, ' start ', i4, ' end ', i4)

         if(status .ne. 0) then
c     error - the hkl values weren't retrieved properly
            return
         end if
         permutations = 0
         autoend(4) = searchend(4) 
         if(width(4) .eq. 0) then
            autostart(4) = searchstart(4)
         else
            autostart(4) = autoend(4) - width(4)
         end if
         do while(autostart(4) .ge. searchstart(4))
            autoend(3) = autoend(4) - width(4)
            if(width(3) .eq. 0) then
               autostart(3) = searchstart(3)
            else
               autostart(3) = autoend(3) - width(3)
            end if
            do while(autostart(3) .ge. searchstart(3))
               autoend(2) = autoend(3) - width(3)
               if(width(2) .eq. 0) then
                  autostart(2) = searchstart(2)
               else
                  autostart(2) = autoend(2) - width(2)
               end if
               do while(autostart(2) .ge. searchstart(2))
                  autoend(1) = autoend(2) - width(2)
                  if(width(1) .eq. 0) then
                     autostart(1) = searchstart(1)
                  else
                     autostart(1) = autoend(1) - width(1)
                  end if
                  do while(autostart(1) .ge. searchstart(1))

c     first copy in the old segments - somewhere need to check that these
c     don't overlap...

                     do i = 1, oldsegcount
                        cphist(i) = staticstart(i)
                        cphifi(i) = staticend(i)
                        cphiinc(i) = step
                     end do

                     do i = 1, segmentcount
                        cphist(i + oldsegcount) = autostart(i)
                        cphifi(i + oldsegcount) = autoend(i)
c     cphiinc is the step! Duh...
                        cphiinc(i + oldsegcount) = step
                     end do

                     nsegin = oldsegcount + segmentcount

c     need to copy the start and ends of the segments into the
c     appropriate values for this subroutine. Bummer.
                     
                     npack = 0
                     nuni = 0
                     nin = 0

                     do i = 1,numrefl
                       iorder(i) = ihklstr(1,nstart+i-1)
                     enddo
                     call complete_engine(ihklstr, numrefl, 
     +                    iorder)

                     pc = (100.0 * nuni) / real(nin1)

                     if(debug(57)) then
c     write out debugging information for this experiment - this
c     will become verbose when you have a lot of segments to test
                        write(iout, 200) permutations, pc
                        if(online) then
                           write(itout, 200) permutations, pc
                        end if
                        do i = 1, segmentcount
                           write(iout, 201) cphist(i), cphifi(i)
                        end do
                        if(online) then
                           do i = 1, segmentcount
                              write(itout, 201) cphist(i), cphifi(i)
                           end do
                        end if
                        write(iout, 202)
                        if(online) then
                           write(itout, 200)
                        end if
                     end if

 200                 format('Segment number ', i6, ' pc = ', f6.1)
 201                 format('Segment start ', f6.0, ' end ', f6.0)
 202                 format('End segment')

                     permutations = permutations + 1

                     if(pc .ge. pcmax) then
c     save values - this is a good segment
                        do i = 1, segmentcount
                           savestart(i) = autostart(i)
                           saveend(i) = autoend(i)
                           savewidth(i) = width(i)
                        end do

                        pcmax = pc
                     end if

                     autostart(1) = autostart(1) - step
                     autoend(1) = autoend(1) - step
                  end do
                  autostart(2) = autostart(2) - step
                  autoend(2) = autoend(2) - step
               end do
               autostart(3) = autostart(3) - step
               autoend(3) = autoend(3) - step
            end do
            autostart(4) = autostart(4) - step
            autoend(4) = autoend(4) - step
         end do

         write(iout, *) 'There were ', permutations, ' permutations'

c     next write out the optimum solution
c     first copy in the old segments - somewhere need to check that these
c     don't overlap...

         do i = 1, oldsegcount
            cphist(i) = staticstart(i)
            cphifi(i) = staticend(i)
            cphiinc(i) = step
         end do

         do i = 1, segmentcount
            cphist(i + oldsegcount) = savestart(i)
            cphifi(i + oldsegcount) = saveend(i)
            cphiinc(i + oldsegcount) = step
         end do

         nsegin = oldsegcount + segmentcount

         npack = 0
         nuni = 0
         nin = 0

         do i = 1,numrefl
           iorder(i) = ihklstr(1,nstart+i-1)
         enddo
         call complete_engine(ihklstr, numrefl, iorder)

         meanmult = 0.0
         do i = 1, npack
            meanmult = meanmult + xmult(i)
         end do
         meanmult = meanmult / real(npack)
         write(iout, 127) meanmult
         if(online) then
            write(itout, 127) meanmult
         end if
         
c     storemeanmult = meanmult

         pc = (100.0 * nuni) / real(nin1)
         pcmax = pc

 100     format('Optimum rotation gave')
 101     format('Start ', i4, ' End ', i4, ' Width ', i4)
 102     format('This rotation gave ', f5.1, '% completeness')

         write(iout, 100)
         do i = 1, nsegin
            write(iout, 101) nint(cphist(i)), nint(cphifi(i)),
     +           nint(width(i))
         end do
         write(iout, 102) pc

c     store this away for printing later on...
         
         do i = 1, nsegin
            keep_phi_segments = nsegin
            keep_phi_start(i) = nint(cphist(i))
            keep_phi_end(i) = nint(cphifi(i))
         end do

         if(online) then
            write(itout, 100)
            do i = 1, nsegin
               write(itout, 101) nint(cphist(i)), nint(cphifi(i)),
     +              nint(width(i))
            end do
            write(itout, 102) pc
         end if

c     set up the limits for the completeness calculation...

         if(dotestgen) then
            call reset_segments
               
            accumulate = .true.

            do i = 1, oldsegcount
               phstart = staticstart(i)
               phend = staticend(i)
               newrun = .true.
               strategy = .false.
               
c     retrieve the stored parameters
               
               eta = seta
               divh = sdivh
               divv = sdivv
               delcor = sdelcor
               delamb = sdelamb
               
               if(shrunk) then
                  call unshrinkcell
               end if
               
c     actually call the test for minimisation of overlaps - this will
c     be done for each segment, so the output should be recorded....
c     add an offset? yep - test_offset and accumulate...

               call testover
               
               if(cellscal .ne. 1.0) then
                  call shrinkcell
               end if
            end do

            do i = 1, segmentcount
               phstart = savestart(i)
               phend = saveend(i)
               newrun = .true.
               strategy = .false.
               
c     retrieve the stored parameters
               
               eta = seta
               divh = sdivh
               divv = sdivv
               delcor = sdelcor
               delamb = sdelamb
               
               if(shrunk) then
                  call unshrinkcell
               end if
               
c     actually call the test for minimisation of overlaps
               call testover
               
               if(cellscal .ne. 1.0) then
                  call shrinkcell
               end if
            end do

            call read_segments(start, end, stepsize, count)
            call reset_segments
            accumulate = .false.

         end if

         dotestgen = .false.

      end if
      
      if(dotestgen) then

         if(.not. autosegments) then
            do i = 1, nsegm
               cphist(i) = phist(i)
               cphifi(i) = phifin(i)
               cphiinc(i) = phiinc(i)
            end do
            
            call retrievehkl(ihklstr, numrefl, status)
            
c     some of this will be unnecessary
            nsegin = nsegm
            nsegauto = nsegm
            segmentcount = nsegm
            npack = 0
            nuni = 0
            nin = 0
            
            do i = 1,numrefl
              iorder(i) = ihklstr(1,nstart+i-1)
            enddo
            call complete_engine(ihklstr, numrefl, 
     +           iorder)
            
            do i = 1, nsegm
               keep_phi_segments = nsegm
               keep_phi_start(i) = nint(cphist(i))
               keep_phi_end(i) = nint(cphifi(i))
            end do

            meanmult = 0.0
            do i = 1, npack
               meanmult = meanmult + xmult(i)
            end do
            meanmult = meanmult / real(npack)
            write(iout, 127) meanmult
            if(online) then
               write(itout, 127) meanmult
            end if
            
            storemeanmult = meanmult

            pc = (100.0 * nuni) / real(nin1)
            pcmax = pc
            
            write(iout, 125) pc
            write(itout, 125) pc
                    
         end if

c     do testgen

c     this will generally not be the optimum way of getting things done...
         phstart = phist(1)
         phend = phifin(1)

         newrun = .true.
         strategy = .false.

c     retrieve the stored parameters

         eta = seta
         divh = sdivh
         divv = sdivv
         delcor = sdelcor
         delamb = sdelamb

         if(shrunk) then
            call unshrinkcell
         end if

c     actually call the test for minimisation of overlaps
         call testover

         if(cellscal .ne. 1.0) then
            call shrinkcell
         end if

      end if
      
      if(shrunk) then
         call unshrinkcell
      end if

      return
      
      end
      
C== COMPR ==
      SUBROUTINE COMPR(KREC,IHD,LDUMP,NSPT)
C     =====================================
C
C
C---- Compares current spot in 'process' with reflections
C     specified in 'spotdump' input file, and
C     sets logical variable ldump if the current reflection
C     is to be dumped through ' badspots' output.
C
C---- Aug 82
C
C
C
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C
C
C
C     .. Scalar Arguments ..
      INTEGER KREC,NSPT
      LOGICAL LDUMP
C     ..
C     .. Array Arguments ..
      INTEGER IHD(3,50)
C     ..
C     .. Local Scalars ..
      INTEGER I,JREC,ISYM
C     ..
C     .. Local Arrays ..
      INTEGER IH(7),IHKL(3),IHKLSYM(3)
C     ..
C     .. External Subroutines ..
      EXTERNAL GETHKL,ASUGET
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC ABS
C     ..
C&&*&& include  ../inc/condata.f
C
C $Id: condata.f,v 1.14 2004/07/20 12:40:18 harry Exp $
C
C--- awk generated include file condata.h 
C---- START of include file condata.h 
C 
C
C     FIXSWAP     Forces reversal of normal byte-swapping choice.
C
C---- SUMPART True if two images are to be stored in memory at the
C               same time. This will be the case if post-refinement
C               (other than POSTHOC post-refinement for off-line
C               scanners) is being performed. Note that SUMPART is NOT
C               used to determine if partials should be added across
C               images (this is ADDPART)
C
C---- NEWPREF True if allowing partials over multiple images in post-
C             refinement.
C
C---- ADDPART True if partials are to be summed across images. This is
C               only appropriate for fixed origin (ie on-line)
C               scanners where the X-ray dose is identical for
C               each image.
C     Direct beam coordinates
C             These are read into XMM(3), YMM(3) where (3) is for A,B,C packs
C             Immediately on reading in, these values are transferred
C             into XCENMM, YCENMM, XCENMMIN(J,3) where J=1->MAXPAX.
C
C             If an IMAGE keyword has been given, XCENMM(1,1)=XMM(1) and
C             YCENMM(1)=YSCAL*YMM(1). If swung out, YCENMM(1,1) is updated.
C             If a BEAM keyword has not been given, XMM,YMM, XCENMM,YCENMM,
C             XCENMMIN are all set to the middle of the image.


C             Then, when reflecting input to logfile, it AGAIN sets up
C             XCENMM,YCENMM for all images using XMM,YMM, this time
C             using YSCAL to set up YCENMM, and updating YCENMM if the
C             detctor is swung out. (label 708), DO loop 710. If image
C             is "inverted", corrects XCENMM for all images.


C             XCEN,YCEN are set in "mosflm" to XCENF, YCENF plus
C             camera constants, and XCENF,YCENF are in turn set from
C             XCENMM,YCENMM. Thus XCENMM,YCENMM are what is actually
C             used to define the beam position.

C
C     LPREF   If TRUE, return to display after refinement over entire
C             image. Only active when integrating interactively. Set by
C             toggle button in Parameter window.
C

C     LOVERLAP  If TRUE, do not call the OVERLAP subroutine

C     ALLOUT  If TRUE, all reflections (whether measured or not, or
C             classified as BADSPOTS or not, will be written to the
C             output MTZ file.
C
C     NTDIG   Number of digits in image number, returned as zero if
C             there is an error in the template. Only used if TEMPLATE
C             keyword given.
C
C     TEMPLATE is TRUE if a TEMPLATE keyword has been given.
C
C     NOLP    If TRUE, do NOT apply the Lorentz Polarisation corrections
C
C     MULTIMTZ True if writing each "block" of images to a separate MTZ file
C
C     DISPMENU True if the run was started with a IMAGE keyword. Not to be
C              confused with WINOPEN which is true if the X-window display
C              is being used, but this is not necessarily starting with
C              a "IMAGE" keyword.
c     newgui - this means that we're talking through the new GUI.
c              except that we can't have it here because the prsummary 
c              subroutine, where we REALLY want it, clashes with this common
C
C     HACTIVEMASK,LACTIVEMASK,LACTIVE - only for Rigaku images which 
C     contain a compressed "active mask" (size=HACTIVEMASK bytes)
C     at the end of the image. Compression uses a modified run length encoding
C     at present (10.01.2003).
C
C     ..
C     .. Arrays in common /CONDATA/ ..
      REAL XCENMM,YCENMM,THFOIL,PHIBEGA,PHIENDA,RSYM,XMM,YMM,
     +     XCENMMIN,YCENMMIN
      REAL RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +     PHIRNG,YSCALIN,FULLFRAC,WTIME
C     ..
C     .. Arrays in common /CONDATA/ ..
      INTEGER IDPACK,NFPACK,NFIRST,ICASSET
      INTEGER IPACK1A,IPACK2A,ISERAR
      LOGICAL AVPROF,FILMPLOT,FORCEB,FORCEC
C
C     .. Scalars in common /CONDATA/ ..
C     ..
      INTEGER NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX
      INTEGER IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK
      LOGICAL FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF,ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW, 
     +        spostref,newgui,LACTIVEMASK,USERSPOT,HEADONLY
C     ..
C real arrays, then scalars, integer arrays, scalars, logicals
      COMMON /CONDATA/
     $       XCENMM(MAXPAX,3),
     +       YCENMM(MAXPAX,3), THFOIL(3),PHIBEGA(MAXPAX),
     $       PHIENDA(MAXPAX),RSYM(4,4,96),XMM(3),YMM(3),
     $       XCENMMIN(MAXPAX),YCENMMIN(MAXPAX),
     $       RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +       PHIRNG,YSCALIN,FULLFRAC,WTIME,
     $        IDPACK(MAXPAX),NFPACK(MAXPAX),NFIRST(MAXPAX),
     +        ICASSET(MAXPAX),IPACK1A(50),
     +        IPACK2A(50),ISERAR(50),
     $        AVPROF(MAXPAX),FILMPLOT(MAXPAX),FORCEB(MAXPAX),
     +        FORCEC(MAXPAX),
     $        NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX,
     $        IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK,
     $        FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF, spostref, ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW,
     $        newgui,LACTIVEMASK,USERSPOT,HEADONLY


C&&*&& end_include  ../inc/condata.f
C     ..
C     .. Common blocks ..
C
C
      JREC = ABS(KREC)
C
C          ***************
      CALL GETHKL(JREC,IH)
C          ***************
      DO 2 I = 1,3
        IHKL(I) = IH(I)
 2    CONTINUE
C
      DO 10 I = 1,NSPT
C
C---- Search all symmetry related reflections
C
        DO 30 ISYM = 1,2*NSYMP
          CALL ASUGET(IHKL,IHKLSYM,ISYM)
          LDUMP = ((IHKLSYM(1).EQ.IHD(1,I)) .AND.
     +             (IHKLSYM(2).EQ.IHD(2,I)) .AND.
     +             (IHKLSYM(3).EQ.IHD(3,I)))
          IF (LDUMP) GO TO 20
 30     CONTINUE
   10 CONTINUE
   20 RETURN
C
C
      END
C $Id: correlate.f,v 1.3 2003/04/30 14:01:40 harry Exp $
C== CORRELATE ==
      SUBROUTINE CORRELATE(OD,LRAS,ICOD,MASK,NXC,NYC,R)
C     ================================================
C
C
C---- Calculate a correlation coefficient between peak profile in OD
C     and central box profile in ICOD. As the profiles still have the
C     background present, subtract the minimum value from all pixels
C
C
C
C
C
C
C
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C     ..
C     .. Scalar Arguments ..
      INTEGER NXC,NYC
      REAL R,R1,R2
C     ..
C     .. Array Arguments ..
      INTEGER LRAS(5),MASK(MAXBOX),OD(MAXBOX),ICOD(MAXBOX)
C     ..
C     .. Local Scalars ..
      REAL SX,SXSQ,SXY,SY,SYSQ,OD1,OD2
      INTEGER HX,HXC,HY,HYC,IJ,IJC,N,P,Q,NXY,MINOD,I
C     ..
C     .. Local Arrays ..
      INTEGER ODSUB(MAXBOX),ICODSUB(MAXBOX)
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC SQRT
C     ..
C     .. Common blocks ..
C     ..
C     .. Equivalences ..
C     ..
      SAVE
C
C---- Find min value in OD
C
      NXY = LRAS(1)*LRAS(2)
      MINOD = 999999                                                   
      DO 2 I = 1,NXY
        IF (OD(I).LT.MINOD) MINOD = OD(I)
 2    CONTINUE
C
C---- Subtract min value
C
      DO 4 I = 1,NXY
        ODSUB(I) = OD(I) - MINOD
 4    CONTINUE
C
C---- Find min value in ICOD
C
      NXY = NXC*NYC
      MINOD = 999999
      DO 6 I = 1,NXY
        IF (ICOD(I).LT.MINOD) MINOD = ICOD(I)
 6    CONTINUE
C
C---- Subtract min value
C
      DO 8 I = 1,NXY
        ICODSUB(I) = ICOD(I) - MINOD
 8    CONTINUE
C
      HX = LRAS(1)/2
      HY = LRAS(2)/2
      HXC = NXC/2
      HYC = NYC/2
C
      N = 0
      SX = 0
      SY = 0
      SXY = 0
      SXSQ = 0
      SYSQ = 0
      IJ = 0
      IJC = 0
C
C
      DO 20 P = -HX,HX
        DO 10 Q = -HY,HY
          IJ = IJ + 1
C
C
          IF ((P.GE.-HXC) .AND. (P.LE.HXC) .AND. (Q.GE.-HYC) .AND.
     +        (Q.LE.HYC)) THEN
            IJC = IJC + 1
C
C
            IF (MASK(IJC).GT.0) THEN
              OD1 = ODSUB(IJ)
              OD2 = ICODSUB(IJC)
              SX = SX + OD1
              SY = SY + OD2
              SXY = OD1*OD2 + SXY
              SXSQ = OD1*OD1 + SXSQ
              SYSQ = OD2*OD2 + SYSQ
              N = N + 1
            END IF
          END IF
   10   CONTINUE
   20 CONTINUE
C
C
      R1 = 0.0
      R2 = 0.0
      IF (N.NE.0) R1 = SXSQ-SX*SX/N
      IF (N.NE.0) R2 = SYSQ-SY*SY/N
      IF ((R1.EQ.0.0).OR.(R2.EQ.0.0)) THEN
        R = 0.0
        RETURN
      END IF
      R = (SXY-SX*SY/N)/ (SQRT(R1)*SQRT(R2))
C
C
      END
c     create_image.f
c     maintained by G.Winter
c     16th April 2002
c     
c     This subroutine is for the express and simple purpose of creating jpeg
c     images for the socket from the in-memory image. Thus, I know nothing
c     about how it got there or whether it is even present or no...
c     
c     Change 6th August 2002
c     Remove the allowance for specifying the image size - only the region
c     desired for image creation and a scale factor is allowed.
c     
c     However, the size is specified in the XML document - not the 
c     factor, so determine the factor from the width and (xmax - xmin)
c     
c     
c     
c     
c     $Id: create_image.f,v 1.25 2004/04/29 09:40:22 geoff Exp $
c     

      subroutine create_image(argc, argv, types, values)

c     specification:
c     
c     1. interpret the limits of the desired in screen coordinates, from the
c        command line input (argv).
c     2. convert these limits into the frame of reference used by the in
c        memory image.
c     3. obtain this section of `image', stored in /pelc/, and call write_jpeg,
c        which is written in C, to create the jpeg and rotate it appropriately.
c     4. write the limits of the image, in an xml document, to the socket.

      implicit none

c     we'll probably need a bunch of includes here, to get hold of the image
c     parameter defines the parameters, which set the dimensions of the array
c     used to store image, which is declared in pel. scn has the definitions
c     for nrec and iylen, and ioo includes the server information.

C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C&&*&& include  ../inc/gui.f
c     gui.h
c     maintained by G.Winter
c     16th April 2002
c     $Id: gui.f,v 1.16 2003/04/04 14:22:01 harry Exp $
c     
c     This defines the variables and common blocks which are used by the
c     new gui control routine. This will also be used in xdisp and control,
c     to switch the new gui on!
c     
c     

      logical gui_switch, refine_cell(6), refine_detector(11),
     +     autocomplete, autoreturn, newmatstore
      integer nargs
      integer imageno, nstart
      parameter (nargs = 200)

c     refine_detector logical block index:
c     1: beam x 2: beam y 3: ccomega 4: yscale
c     5: distance 6: tilt 7: twist 8: roff 9: toff
c     
c     refine_cell logical block index:
c     1: a 2: b 3: c
c     4: alpha 5: beta 6: gamma
c     
c     
c     

      integer keep_phi_segments, keep_phi_start(20), 
     +     keep_phi_end(20)

      real storemeanmult

      common /gui/ gui_switch, imageno, refine_cell, refine_detector,
     +     autocomplete, nstart, autoreturn, newmatstore

      common /keep_phi/ keep_phi_segments, keep_phi_start, 
     +     keep_phi_end, storemeanmult


c     refine_cell(i) is true if you wish to refine cell(i)
C&&*&& end_include  ../inc/gui.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/spots.f
C
C $Id: spots.f,v 1.1 2002/05/02 10:47:18 harry Exp $
C
C--- awk generated include file  spots.h
C---- START of include file spots.h
C
C     XSPT,YSPT,ISPT store spot coordinates (in mm) and intensity
C
C     These arrays hold the complete list of spots found on ALL images.
C     Pointers to the first and last spot in each image are kept in arrays
C
C     XSPT....  X coordinates (in mm) of spots in total spot list for
C               all images.
C
C     YSPT....  Y coordinates (in mm) of spots in total spot list for
C               all images.
C
C     ISPT....  Intensity of spots in total spot list for
C               all images.
C
C     ISDSPT..  Standard deviations of intensities
C
C     INDX...   Stores a pointer into arrays XSPT,YSPT,ISPT for the I'th
C               displayed spot (only spots above current threshold are
C               displayed).
C
C     ISTIMG(IMAG)...  Pointer to first spot for image IMAG in arrays
C                      XSPT,YSPT,ISPT
C     IENDIMG(IMAG)...  Pointer to last spot for image IMAG in arrays
C                      XSPT,YSPT,ISPT
C
C     IXSPT,IYSPT...   Spot coordinates in display pixels for current image
C     SELECT....       True for images selected for autoindexing
C     SPOTFND....      True for images on which spots have been found
C     ITHRESH          I/sig(I) threshold for spots to be used in autoindexing
C
C     .. Scalars in Common Block /SPOTS/ ..
        REAL XF,YF,XFID1,YFID1,XFID2,YFID2,XFID3,YFID3,PHIIMG,
     +       LPIXEL,LYSCALE,LOMEGA,LXCEN,LYCEN
        INTEGER NSPT,ISPOT,ITHRESH,IRSCAL,LIXLEN,LIYLEN,INVFLAG,
     +       LISWUNG
        CHARACTER*100 SPTNAM,NSPTNAM

C     ..
C     .. Arrays in common /SPOTS/ ..
        REAL XSPT(NSPOTS),YSPT(NSPOTS)
        INTEGER ISPT(NSPOTS),IXSPT(NSPOTS),IYSPT(NSPOTS),
     +          ISTIMG(MAXIMG),IENDIMG(MAXIMG),ISDSPT(NSPOTS)
        INTEGER*2 INDX(NSPOTS)
        LOGICAL SELECT(MAXIMG),SPOTFND(MAXIMG)
C     ..
C     .. Common Block /SPOTS/ ..
        COMMON /SPOTS/ XF,YF,XFID1,YFID1,XFID2,YFID2,XFID3,YFID3,
     +                 XSPT,YSPT,ISPT,IXSPT,IYSPT,INDX,ISPOT,NSPT,
     +                 ITHRESH,PHIIMG,IRSCAL,LPIXEL,LYSCALE,LOMEGA,
     +                 LIXLEN,LIYLEN,LXCEN,LYCEN,INVFLAG,LISWUNG,
     +                 ISTIMG,IENDIMG,SELECT,ISDSPT,SPOTFND
C
        COMMON /CSPOTS/ SPTNAM,NSPTNAM

C&&*&& end_include  ../inc/spots.f
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
c     startgw
C&&*&& include  ../inc/condata.f
C
C $Id: condata.f,v 1.14 2004/07/20 12:40:18 harry Exp $
C
C--- awk generated include file condata.h 
C---- START of include file condata.h 
C 
C
C     FIXSWAP     Forces reversal of normal byte-swapping choice.
C
C---- SUMPART True if two images are to be stored in memory at the
C               same time. This will be the case if post-refinement
C               (other than POSTHOC post-refinement for off-line
C               scanners) is being performed. Note that SUMPART is NOT
C               used to determine if partials should be added across
C               images (this is ADDPART)
C
C---- NEWPREF True if allowing partials over multiple images in post-
C             refinement.
C
C---- ADDPART True if partials are to be summed across images. This is
C               only appropriate for fixed origin (ie on-line)
C               scanners where the X-ray dose is identical for
C               each image.
C     Direct beam coordinates
C             These are read into XMM(3), YMM(3) where (3) is for A,B,C packs
C             Immediately on reading in, these values are transferred
C             into XCENMM, YCENMM, XCENMMIN(J,3) where J=1->MAXPAX.
C
C             If an IMAGE keyword has been given, XCENMM(1,1)=XMM(1) and
C             YCENMM(1)=YSCAL*YMM(1). If swung out, YCENMM(1,1) is updated.
C             If a BEAM keyword has not been given, XMM,YMM, XCENMM,YCENMM,
C             XCENMMIN are all set to the middle of the image.


C             Then, when reflecting input to logfile, it AGAIN sets up
C             XCENMM,YCENMM for all images using XMM,YMM, this time
C             using YSCAL to set up YCENMM, and updating YCENMM if the
C             detctor is swung out. (label 708), DO loop 710. If image
C             is "inverted", corrects XCENMM for all images.


C             XCEN,YCEN are set in "mosflm" to XCENF, YCENF plus
C             camera constants, and XCENF,YCENF are in turn set from
C             XCENMM,YCENMM. Thus XCENMM,YCENMM are what is actually
C             used to define the beam position.

C
C     LPREF   If TRUE, return to display after refinement over entire
C             image. Only active when integrating interactively. Set by
C             toggle button in Parameter window.
C

C     LOVERLAP  If TRUE, do not call the OVERLAP subroutine

C     ALLOUT  If TRUE, all reflections (whether measured or not, or
C             classified as BADSPOTS or not, will be written to the
C             output MTZ file.
C
C     NTDIG   Number of digits in image number, returned as zero if
C             there is an error in the template. Only used if TEMPLATE
C             keyword given.
C
C     TEMPLATE is TRUE if a TEMPLATE keyword has been given.
C
C     NOLP    If TRUE, do NOT apply the Lorentz Polarisation corrections
C
C     MULTIMTZ True if writing each "block" of images to a separate MTZ file
C
C     DISPMENU True if the run was started with a IMAGE keyword. Not to be
C              confused with WINOPEN which is true if the X-window display
C              is being used, but this is not necessarily starting with
C              a "IMAGE" keyword.
c     newgui - this means that we're talking through the new GUI.
c              except that we can't have it here because the prsummary 
c              subroutine, where we REALLY want it, clashes with this common
C
C     HACTIVEMASK,LACTIVEMASK,LACTIVE - only for Rigaku images which 
C     contain a compressed "active mask" (size=HACTIVEMASK bytes)
C     at the end of the image. Compression uses a modified run length encoding
C     at present (10.01.2003).
C
C     ..
C     .. Arrays in common /CONDATA/ ..
      REAL XCENMM,YCENMM,THFOIL,PHIBEGA,PHIENDA,RSYM,XMM,YMM,
     +     XCENMMIN,YCENMMIN
      REAL RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +     PHIRNG,YSCALIN,FULLFRAC,WTIME
C     ..
C     .. Arrays in common /CONDATA/ ..
      INTEGER IDPACK,NFPACK,NFIRST,ICASSET
      INTEGER IPACK1A,IPACK2A,ISERAR
      LOGICAL AVPROF,FILMPLOT,FORCEB,FORCEC
C
C     .. Scalars in common /CONDATA/ ..
C     ..
      INTEGER NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX
      INTEGER IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK
      LOGICAL FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF,ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW, 
     +        spostref,newgui,LACTIVEMASK,USERSPOT,HEADONLY
C     ..
C real arrays, then scalars, integer arrays, scalars, logicals
      COMMON /CONDATA/
     $       XCENMM(MAXPAX,3),
     +       YCENMM(MAXPAX,3), THFOIL(3),PHIBEGA(MAXPAX),
     $       PHIENDA(MAXPAX),RSYM(4,4,96),XMM(3),YMM(3),
     $       XCENMMIN(MAXPAX),YCENMMIN(MAXPAX),
     $       RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +       PHIRNG,YSCALIN,FULLFRAC,WTIME,
     $        IDPACK(MAXPAX),NFPACK(MAXPAX),NFIRST(MAXPAX),
     +        ICASSET(MAXPAX),IPACK1A(50),
     +        IPACK2A(50),ISERAR(50),
     $        AVPROF(MAXPAX),FILMPLOT(MAXPAX),FORCEB(MAXPAX),
     +        FORCEC(MAXPAX),
     $        NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX,
     $        IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK,
     $        FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF, spostref, ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW,
     $        newgui,LACTIVEMASK,USERSPOT,HEADONLY


C&&*&& end_include  ../inc/condata.f
C&&*&& include  ../inc/gendata.f
C
C $Id: gendata.f,v 1.2 2003/01/10 16:17:53 andrew Exp $
C
C--- awk generated include file  gendata.h
C---- START of include file gendata.h
C
C     IMG       Partiality indicator. 0 for full reflections, 1 to 100
C                   for partials. Negative for partials at the start of the
C                   rotation range, +ve for partials at the end of the 
C                   rotation. Set in subroutine REEK using DELEPS calculated
C                   in subroutine DSTAR
C
C     IRG       Reflection flag  (Set by SPTEST called from DSTAR)
C               =  0  Spot can be measured
C               =  1  Outside R, X, Y limits
C               =  2  Overlapping spot (set later)
C               =  3  Too wide in phi (more than NWMAX images)
C               =  4  DST .GT. DSTMAX  Not included in final film list -
C                       used only to check for overlaps at edge of film.
C               = 10  Spot is within cusp, but will be observed...not included
C                     in final spot list but must be included in predicted
C                      pattern
C
C               =  21  Spot present on 2 images, this is 1st
C               =  22  Spot present on 2 images, this is 2nd
C
C               =  31  Spot present on 3 images, this is 1st
C               =  32  Spot present on 3 images, this is 2nd
C               =  33  Spot present on 3 images, this is 3rd
C
C               =  41  Spot present on 4 images, this is 1st
C               =  42  Spot present on 4 images, this is 2nd
C               =  43  Spot present on 3 images, this is 3rd
C               =  44  Spot present on 4 images, this is 4th
C
C                 etc etc
C
C     XG        Virtual detector X coordinate in 10 micron units, relative to
C               an origin at the direct beam position. X is parallel to the
C               Y axis in the laboratory frame, ie orthogonal to the rotation
C               axis.
C
C     YG        Virtual detector Y coordinate in 10 micron units, relative to
C               an origin at the direct beam position. Y is parallel to the
C               Z axis in the laboratory frame, ie  the rotation axis.
C
C     IX,IY     are the coordinates of the reflection in pixels
C               (integers) wrt the first pixel in the image (lower left corner
C               cameramans view). For testing for spot overlap, these
C               coordinates are in 10 micron units. Also used for display
C               pixel coordinates when displaying predicted pattern.
C
C     IREC      Pointer to the record number of a particular spot in the
C               list of generated reflections.
C
C
C     ..
C     .. Arrays in common /GENDATA/ ..
      REAL FRACG,PHIG,PHIWG,XG,YG,GOODFIT
      INTEGER INTG,IPRO,IX,IY,IREC
      INTEGER*2 IRG,IMG,IGFLAG,ISDPRO,ISDG,IHG,IKG,ILG,IMPARTG,
     +          MISYMG
C     .. Scalars in common /GENDATA/ ..
      INTEGER IPACKREC,IPACKHEAD,IRECLAST
C     ..
C     .. Common block /GENDATA/ ..
      COMMON /GENDATA/FRACG(NREFLS),PHIG(NREFLS),PHIWG(NREFLS),
     $       XG(NREFLS),YG(NREFLS),INTG(NREFLS),IPRO(NREFLS),
     $       IX(NREFLS),IY(NREFLS),IREC(NREFLS),IRG(NREFLS),IMG(NREFLS),
     +       IGFLAG(NREFLS),ISDPRO(NREFLS),ISDG(NREFLS),
     +       IHG(NREFLS),IKG(NREFLS),ILG(NREFLS),IMPARTG(NREFLS),
     +       MISYMG(NREFLS),GOODFIT(NREFLS),IPACKREC,IPACKHEAD,
     +       IRECLAST
C     ..
C
C

C&&*&& end_include  ../inc/gendata.f
C&&*&& include  ../inc/iosp.f
C
C $Id: iosp.f,v 1.1 2002/05/02 10:46:53 harry Exp $
C
C--- awk generated include file  iosp.h
C---- START of include file iosp.h
C
C
C     .. Scalars in common block /IOSP/ ..
      INTEGER NSPOT,NFULL,NOUTGEN
C     ..
C     .. Common Block /IOSP/ ..
      COMMON /IOSP/NSPOT,NFULL,NOUTGEN
C     ..
C
C
C&&*&& end_include  ../inc/iosp.f
C&&*&& include  ../inc/xy.f
C
C $Id: xy.f,v 1.1 2002/05/02 10:47:25 harry Exp $
C
C--- awk generated include file  xy.h
C---- START of include file xy.h
C
C     .. Scalars in common block /XY/ ..
      REAL XTOFD,SINV,COSV,TANV,TWOTHETA
      INTEGER ICASS
C     ..
C     .. Common Block /XY/ ..
      COMMON /XY/XTOFD,SINV,COSV,TANV,TWOTHETA,ICASS
C     ..
C
C     XTOFD....  Crystal to detector distance in 10 micron units. Read from
C                keyworded input and never changed.
C
C                Spot positions are calculated in S/R XYSPOT (Called from
C                REEK) and are for an "ideal" detector at a distance of XTOFD.
C                These are converted into pixel positions in S/R MMTOPX
C                which applies the multiplicative factor XTOFRA to allow
C                for refinement of the distance. XTOFRA is the parameter
C                that is actually refined (in RDIST), rather than XTOFD.
C                The refined distance that is printed in the logfile is
C                actually XTOFRA*XTOFD
C
C     ICASS....  Indicates detector type:
C                0     Flat film
C                1     Vee shaped cassettes
C                2     FAST detector (only used in TESTGEN mode of OSCGEN)
C                3     Swung out FAST (ditto)
C                4     IP detector
C     TWOTHETA   Detector swing angle (degrees)
C&&*&& end_include  ../inc/xy.f
c     endgw

      integer argc, types(nargs)
      character*80 argv(nargs), word, secondword
      character*1000 outline
      real values(nargs)

c     locally used variables

      integer xmin, ymin, xmax, ymax, width, height
      integer i, quality, factor, zoom, cx, cy
      integer centrex, centrey, theta, invert, pixmin, pixmax
      integer tlc(2), brc(2), centre(2)
      integer costheta, sintheta, dx, dy, binary
      real radtheta, dtor
      integer ipx, ipy 
      integer*2 spot_position(10000)
      integer*2 pred_position(2 * nrefls)
      integer*2 pred_type(nrefls)

c     logicals used in the parsing

      logical setsize, setfactor, thumbnail, spots, prediction

c     functions and subroutines used herein

      integer lenstr
      external lenstr, create_image_help

      external ccplwc, write_jpeg, jpeg_set_quality, jpeg_set_filename
c     , get_translation_parameters

c     initialize everything

      dtor = 4.0 * atan(1.0) / 180.0

      xmin = 0
      ymin = 0
      xmax = 0
      ymax = 0
      width = 0
      height = 0
      pixmin = 0
      pixmax = 0
      quality = 85
      theta = 0
      invert = 0
      zoom = -1
      binary = 0

      setsize = .false.
      setfactor = .false.
      thumbnail = .false.
      spots = .false.
      prediction = .false.

c     parse the input

      if(argc .ne. 1) then
         word = argv(2)
         call ccplwc(word)
         if(word .eq. 'help') then
            call create_image_help
            return
         end if
      end if

      i = 2
      do while(i .lt. argc)
         word = argv(i)
         call ccplwc(word)
         if(word .eq. 'xmin') then
            if(types(i + 1) .eq. 2) then
               xmin = nint(values(i + 1))
            else
               write(*, *) 'This should be a number ', argv(i + 1)
            end if
         else if(word .eq. 'ymin') then
            if(types(i + 1) .eq. 2) then
               ymin = nint(values(i + 1))
            else
               write(*, *) 'This should be a number ', argv(i + 1)
            end if
         else if(word .eq. 'xmax') then
            if(types(i + 1) .eq. 2) then
               xmax = nint(values(i + 1))
            else
               write(*, *) 'This should be a number ', argv(i + 1)
            end if
         else if(word .eq. 'ymax') then
            if(types(i + 1) .eq. 2) then
               ymax = nint(values(i + 1))
            else
               write(*, *) 'This should be a number ', argv(i + 1)
            end if
         else if(word .eq. 'width') then
            if(types(i + 1) .eq. 2) then
               width = nint(values(i + 1))
               setsize = .true.
            else
               write(*, *) 'This should be a number ', argv(i + 1)
            end if
         else if(word .eq. 'height') then
            if(types(i + 1) .eq. 2) then
               height = nint(values(i + 1))
               setsize = .true.
            else
               write(*, *) 'This should be a number ', argv(i + 1)
            end if
         else if(word .eq. 'quality') then
            if(types(i + 1) .eq. 2) then
               quality = nint(values(i + 1))
               call jpeg_set_quality(quality)
            else
               write(*, *) 'This should be a number ', argv(i + 1)
            end if
         else if(word .eq. 'theta') then
            if(types(i + 1) .eq. 2) then
               theta = nint(values(i + 1))
            else
               write(*, *) 'This should be a number ', argv(i + 1)
            end if
         else if(word .eq. 'zoom') then
            if(types(i + 1) .eq. 2) then
               zoom = nint(values(i + 1))
               setfactor = .true.
            else
               write(*, *) 'This should be a number ', argv(i + 1)
            end if
         else if(word .eq. 'filename') then
            call jpeg_set_filename(argv(i + 1), lenstr(argv(i + 1)))
         else if(word .eq. 'thumbnail') then
            secondword = argv(i + 1)
            call ccplwc(secondword)
            if((secondword .eq. 'on') .or.
     +           (secondword .eq. 'true') .or.
     +           (secondword .eq. '1')) then
               thumbnail = .true.
            else
               thumbnail = .false.
            end if
         else if(word .eq. 'spots') then
            secondword = argv(i + 1)
            call ccplwc(secondword)
            if((secondword .eq. 'on') .or.
     +           (secondword .eq. 'true') .or.
     +           (secondword .eq. '1')) then
               spots = .true.
            else
               spots = .false.
            end if
         else if(word .eq. 'prediction') then
            secondword = argv(i + 1)
            call ccplwc(secondword)
            if((secondword .eq. 'on') .or.
     +           (secondword .eq. 'true') .or.
     +           (secondword .eq. '1')) then
               prediction = .true.
            else
               prediction = .false.
            end if

         else if(word .eq. 'pixmin') then
            if(types(i + 1) .eq. 2) then
               pixmin = nint(values(i + 1))
            else
               write(*, *) 'This should be a number ', argv(i + 1)
            end if

            
         else if(word .eq. 'pixmax') then
            if(types(i + 1) .eq. 2) then
               pixmax = nint(values(i + 1))
            else
               write(*, *) 'This should be a number ', argv(i + 1)
            end if

         else if(word .eq. 'binary') then
            secondword = argv(i + 1)
            call ccplwc(secondword)
            if((secondword .eq. 'on') .or.
     +           (secondword .eq. 'true') .or.
     +           (secondword .eq. '1')) then
               binary = 1
            else
               binary = 0
            end if
         end if
         i = i + 2
      end do

c     check the input parameters - if there's a mistake, return

      if(setsize .and. setfactor) then
         if(.not. socklo) then
            write(*, *) 'Dont specify zoom and width/height - naughty'
         end if
         return
      end if

c     and get the memory-screen translation parameters

c     call get_translation_parameters(theta, invert)

c     and put it into real units and perform the translation
c     could all of this be encapsulated into a clever subroutine?
c     costheta and sintheta will be -1, 0, +1

      radtheta = 4 * atan(1.0) * real(theta) / 180.0
      costheta = nint(cos(radtheta))
      sintheta = nint(sin(radtheta))

c     this rotation should be performed about the centre of the image
c     so we first need to translate the image centre to the coordinate
c     frame of the display

c     this is an inverse transformation

      centre(1) = costheta * nrec / 2 - sintheta * iylen / 2
      centre(2) = sintheta * nrec / 2 + costheta * iylen / 2

c     check that the limits of the image are not all 0, and if they are, make
c     them the limits of the image

      if(xmin .eq. xmax) then
         xmin = 0
         xmax = 2 * centre(1)
      end if

      if(ymin .eq. ymax) then
         ymin = 0
         ymax = 2 * centre(2)
      end if

      if((xmax - xmin) .lt. 10) then
         cx = 0.5 * (xmax + xmin)
         xmin = cx - 5
         xmax = cx + 5
      end if

      if((ymax - ymin) .lt. 10) then
         cy = 0.5 * (ymax + ymin)
         ymin = cy - 5
         ymax = cy + 5
      end if

      xmin = xmin - centre(1)
      xmax = xmax - centre(1)
      ymin = ymin - centre(2)
      ymax = ymax - centre(2)

c     and this is the forward transformation

      tlc(1) = costheta * xmin + sintheta * ymin
      tlc(2) = - sintheta * xmin + costheta * ymin

      brc(1) = costheta * xmax + sintheta * ymax
      brc(2) = - sintheta * xmax + costheta * ymax

      tlc(1) = tlc(1) + nrec / 2
      tlc(2) = tlc(2) + iylen / 2
      brc(1) = brc(1) + nrec / 2
      brc(2) = brc(2) + iylen / 2

      xmin = tlc(1)
      ymin = tlc(2)
      xmax = brc(1)
      ymax = brc(2)

c     check the limits on the image - make whole image if all zero
c     Hmmm.... nrec and iylen are in internal coordinates?

      if((xmin .eq. 0) .and.
     +     (ymin .eq. 0) .and.
     +     (xmax .eq. 0) .and.
     +     (ymax .eq. 0)) then
         xmax = nrec
         ymax = iylen
      end if

c     check size of image - make whole image if zero, else make a nice 
c     fraction of the original's size if this is a change

      if((width .eq. 0) .or. 
     +     (height .eq. 0)) then

         width = nrec / nint(real(nrec) / real(1000))
         height = iylen / nint(real(nrec) / real(1000))
      end if

      centrex = (xmin + xmax) / 2
      centrey = (ymin + ymax) / 2

c     get a nice box size if the user didn't specify the factor, else use that

      if(.not. setfactor) then
C         if(abs(xmax - xmin) .ge. width) then
C            factor = abs(nint(real(xmax - xmin) / real(width)))
C            xmin = centrex - factor * width / 2
C            xmax = centrex + factor * width / 2
C            factor = abs(nint(real(ymax - ymin) / real(height)))
C            ymin = centrey - factor * height / 2
C            ymax = centrey + factor * height / 2
C            factor = factor * -1
C         else
C            dx = xmax - xmin
C            dy = ymax - ymin
C            factor = abs(nint(real(width) / real(xmax - xmin)))
C            xmin = centrex - width / (2 * factor)
C            xmax = centrex + width / (2 * factor)
C            factor = abs(nint(real(height) / real(ymax - ymin)))
C            ymin = centrey - height / (2 * factor)
C            ymax = centrey + height / (2 * factor)
C         end if
         FACTOR = 1
      else
         if(zoom .gt. 0) then
            width = abs((xmax - xmin) * zoom)
            height = abs((ymax - ymin) * zoom)
            factor = zoom
         else IF (ZOOM.LT.0)THEN
            width = abs((xmax - xmin) / zoom)
            height = abs((ymax - ymin) / zoom)
            factor = zoom
          ELSE
            ZOOM = 1
         end if
      end if

      write(*, *) 'Beam centre = ', xmm(1), ymm(1)

      tlc(1) = xmin
      tlc(2) = ymin
      brc(1) = xmax
      brc(2) = ymax

c     we should translate the image limits back into the screen frame, then
c     write them into an XML document and send them to the GUI.

      xmin = costheta * tlc(1) + sintheta * tlc(2)
      ymin = - sintheta * tlc(1) + costheta * tlc(2)
      xmax = costheta * brc(1) + sintheta * brc(2)
      ymax = - sintheta * brc(1) + costheta * brc(2)

      if((pixmin .eq. 0) .and. (pixmax .eq. 0)) then
         call guess_contrast_limits(image, nrec, iylen,
     +        xmin, xmax, ymin, ymax, pixmin, pixmax)
      end if

c     21st November 2002 - 
c     Add the wavelength, distance etc to the image_response document - this
c     assumes that this information is contained in the image header, which
c     is implicit.
c     
c     

 1101  format('<?xml version="1.0"?><!DOCTYPE image_response>',
     +     '<image_response><status><code>ok</code></status>',
     +     '<region><xmin>', i4, '</xmin><ymin>', i4, '</ymin>',
     +     '<xmax>', i4, '</xmax><ymax>', i4, '</ymax></region>',
     +     '<beam><x>', f10.5, '</x><y>', f10.5, '</y></beam>',
     +     '<contrast><minimum>', i6, '</minimum><maximum>',
     +     i6, '</maximum></contrast>',
     +     '</image_response>')

 101   format('<?xml version="1.0"?><!DOCTYPE image_response>',
     +      '<image_response><status><code>ok</code></status>',
     +      '<region><xmin>', i4, '</xmin><ymin>', i4, '</ymin>',
     +      '<xmax>', i4, '</xmax><ymax>', i4, '</ymax></region>',
     +      '<beam><x>', f10.5, '</x><y>', f10.5, '</y></beam>',
     +      '<contrast><minimum>', i6, '</minimum><maximum>',
     +      i6, '</maximum></contrast>',
     +      '<beamline_parameters><wavelength>', f7.4, '</wavelength>',
     +      '<beam_divergence><horizontal>', f6.3, 
     +      '</horizontal><vertical>', f6.3, '</vertical>',
     +      '</beam_divergence></beamline_parameters>',
     +      '<distance>', f10.4, '</distance>',
     +      '<detector><two_theta>', f8.3, '</two_theta>',
     +       '<resolution_limits><maximum>', f10.4, '</maximum>',
     +       '<minimum>', f10.4, '</minimum></resolution_limits>',
     +       '<gain>', f7.2, '</gain></detector>',
     +      '<header><oscillation_sequence><start>', f7.2,
     +      '</start><range>', f7.2, '</range>',
     +      '</oscillation_sequence></header></image_response>')

c     empty image warning
 102  format('<?xml version="1.0"?><!DOCTYPE image_response>',
     +     '<image_response><status><code>error</code><message>',
     +     'Error loading image - dimensions 0</message>',
     +     '</status></image_response>')

 298  format('<?xml version="1.0"?><!DOCTYPE thumbnail_response>',
     +     '<thumbnail_response><status><code>ok</code></status>',
     +     '<region><xmin>', i5, '</xmin><xmax>', i5, 
     +     '</xmax><ymin>', i5, '</ymin><ymax>', i5, 
     +     '</ymax></region><thumbnail>')

 299  format('</thumbnail></thumbnail_response>')

c     check for empty image

      if((nrec .eq. 0) .or. (iylen .eq. 0)) then
         outline = ' '
         write(outline, fmt=102)
         call write_socket_length(serverfd, lenstr(outline), outline)
         return
      end if

      if(thumbnail) then
         tlc(1) = 0
         tlc(2) = 0
         brc(1) = nrec
         brc(2) = iylen
         outline = ' '
         write(outline, 298) 0, nrec, 0, iylen
         call write_socket_section(serverfd, lenstr(outline), 
     +        outline)
         call write_jpeg(serverfd, nrec, iylen, image, 
     +        pixmin, pixmax, factor, tlc, brc, 0, 0, 0, binary)
         outline = ' '
         write(outline, 299)
         call write_socket_length(serverfd, lenstr(outline), 
     +        outline)
         return
      end if
      outline = ' '
      IF(ABS(DSTMAX).LT.1e-5)DSTMAX = 1
      IF(ABS(DSTMIN).LT.1E-5)DSTMIN = 1
      write(outline, fmt=101) xmin, ymin, xmax, ymax, xmm(1), ymm(1),
     +     pixmin, pixmax, wave, 2.0 * divh / dtor, 2.0 * divv / dtor,
     +     0.01 * xtofd, twotheta, wave/dstmax, wave/dstmin, gain,
     +     phibeg, phiend - phibeg
      IF(ABS(DSTMAX-1.0).LT.1e-5)DSTMAX = 0.0
      IF(ABS(DSTMIN-1.0).LT.1E-5)DSTMIN = 0.0
      call write_socket_length(serverfd, lenstr(outline), outline)

c     next, generate the actual image

      if(.not. socklo) serverfd = -1

      if(spots) then
         do i = 1, nspt
            ipx = nint(xspt(i) / rast)
            ipy = nint(yspt(i) * yscal / rast)
            spot_position(2 * i - 1) = ipx
            spot_position(2 * i) = ipy
         end do
         call write_jpeg_spots(serverfd, nrec, iylen, image, pixmin, 
     +        pixmax, 
     +        factor, tlc, brc, 1, theta, invert, spot_position, nspt)
      else if(prediction) then
         do i = 1, nspot
            ipx = ix(i)
            ipy = iy(i)
            pred_position(2 * i - 1) = ipx
            pred_position(2 * i) = ipy
            pred_type(i) = irg(i)
         end do

         if(binary .eq. 1) then
            write(*, *) 'writing binary jpeg'
         end if

         call write_jpeg_predict(serverfd, nrec, iylen, image, 
     +        pixmin, pixmax, 
     +        factor, tlc, brc, 1, theta, invert, pred_position, 
     +        pred_type, nspot,
     +        binary)

      else

         if(1 .eq. 2) then
            write(*, *) 'Calling write_jpeg with arg list:'
            write(*, *) 'trc = ', tlc(1), tlc(2)
            write(*, *) 'blc = ', brc(1), brc(2)
            write(*, *) 'factor = ', factor
         end if

         write(*, *) 'write_jpeg', serverfd, nrec, iylen, 0, 0
         write(*, *) factor, tlc, brc, 1, theta, invert

c         call write_grey_jpeg()
         call write_jpeg(serverfd, nrec, iylen, image, pixmin, 
     +        pixmax,
     +        factor, tlc, brc, 1, theta, invert, binary)
      end if

      end

      subroutine create_image_help

c     this is just an explaination for the user so that they can find 
c     out how to use the `create_image' function ...
c     
c     
      write(*, *) 'create_image help:'
      write(*, *) 'keyword:        meaning:'
      write(*, *) 'xmin - ymax:    the limits of the image'
      write(*, *) 'width, height:  the size of the resulting jpeg'
      write(*, *) 'quality:        the jpeg quality - use 50 - 80'
      write(*, *) 'theta:          the angle through which to rotate'
      write(*, *) 'zoom:           the zoom factor'
      write(*, *) 'filename:       an output filename'
      write(*, *) 'thumbnail:      return the image embedded in XML?'

      write(*, *) 'The create_image function exists to make a JPEG',
     $     ' image from the image in memory, returning the result to',
     $     ' the socket if that is how you are connecting'

      return
      end

      subroutine guess_contrast_limits(image, nrec, iylen,
     +        xmin, xmax, ymin, ymax, pixmin, pixmax)

      implicit none

C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f

      integer*2 image(iylength * ixwdth)

      integer nrec, iylen, xmin, xmax, ymin, ymax, pixmin, pixmax
      integer i, j
      real total

      total = 0

c     is this the right loop ordering?

      do i = 1, nrec
         do j = 1, iylen
            if(image(i * iylen + nrec) .ge. 0) then
               total = total + image(i * iylen + j)
            else
               total = total + 32767
            end if
         end do
      end do

      pixmin = 4.0 * total / real(nrec * iylen)
      pixmax = 0

      return
      end

c     TGGB> 2nd version for greyscale images.

      subroutine create_grey_image()

c     TGGB> 1. Just call write_grey_jpeg to make a full-size, greyscale jpeg
c     TGGB. 2. Will need to write some stuff in xml too probably, but not yet.

      implicit none

c     TGGB. Keeeping Graeme's includes...

c     we'll probably need a bunch of includes here, to get hold of the image
c     parameter defines the parameters, which set the dimensions of the array
c     used to store image, which is declared in pel. scn has the definitions
c     for nrec and iylen, and ioo includes the server information.

C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C&&*&& include  ../inc/gui.f
c     gui.h
c     maintained by G.Winter
c     16th April 2002
c     $Id: gui.f,v 1.16 2003/04/04 14:22:01 harry Exp $
c     
c     This defines the variables and common blocks which are used by the
c     new gui control routine. This will also be used in xdisp and control,
c     to switch the new gui on!
c     
c     

      logical gui_switch, refine_cell(6), refine_detector(11),
     +     autocomplete, autoreturn, newmatstore
      integer nargs
      integer imageno, nstart
      parameter (nargs = 200)

c     refine_detector logical block index:
c     1: beam x 2: beam y 3: ccomega 4: yscale
c     5: distance 6: tilt 7: twist 8: roff 9: toff
c     
c     refine_cell logical block index:
c     1: a 2: b 3: c
c     4: alpha 5: beta 6: gamma
c     
c     
c     

      integer keep_phi_segments, keep_phi_start(20), 
     +     keep_phi_end(20)

      real storemeanmult

      common /gui/ gui_switch, imageno, refine_cell, refine_detector,
     +     autocomplete, nstart, autoreturn, newmatstore

      common /keep_phi/ keep_phi_segments, keep_phi_start, 
     +     keep_phi_end, storemeanmult


c     refine_cell(i) is true if you wish to refine cell(i)
C&&*&& end_include  ../inc/gui.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C&&*&& include  ../inc/pel.f
C     **** This is the IMAGE PLATE version of this common block ****
C
C
C---- START of include file pel.h
C
C
C     .. Scalars in common blocks /PEL/ and /PELC/ ..
      INTEGER IBA,IPOINT,ISTART
      LOGICAL INCORE
C     ..
C     .. Arrays in common blocks /PEL/ and /PELC/ ..
      LOGICAL RDSTRIP
      INTEGER*2 BOXOD,IMAGE
C     ..
C     .. Common Blocks /PEL/ and /PELC/ ..
      COMMON /PEL/IBA,IPOINT,INCORE,RDSTRIP(IXWDTH),BOXOD(MAXBOX),
     +            ISTART
      COMMON /PELC/ IMAGE(IYLENGTH*IXWDTH)
C     ..
C
C
C---- END of include file pel.h
C
C&&*&& end_include  ../inc/pel.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C&&*&& include  ../inc/spots.f
C
C $Id: spots.f,v 1.1 2002/05/02 10:47:18 harry Exp $
C
C--- awk generated include file  spots.h
C---- START of include file spots.h
C
C     XSPT,YSPT,ISPT store spot coordinates (in mm) and intensity
C
C     These arrays hold the complete list of spots found on ALL images.
C     Pointers to the first and last spot in each image are kept in arrays
C
C     XSPT....  X coordinates (in mm) of spots in total spot list for
C               all images.
C
C     YSPT....  Y coordinates (in mm) of spots in total spot list for
C               all images.
C
C     ISPT....  Intensity of spots in total spot list for
C               all images.
C
C     ISDSPT..  Standard deviations of intensities
C
C     INDX...   Stores a pointer into arrays XSPT,YSPT,ISPT for the I'th
C               displayed spot (only spots above current threshold are
C               displayed).
C
C     ISTIMG(IMAG)...  Pointer to first spot for image IMAG in arrays
C                      XSPT,YSPT,ISPT
C     IENDIMG(IMAG)...  Pointer to last spot for image IMAG in arrays
C                      XSPT,YSPT,ISPT
C
C     IXSPT,IYSPT...   Spot coordinates in display pixels for current image
C     SELECT....       True for images selected for autoindexing
C     SPOTFND....      True for images on which spots have been found
C     ITHRESH          I/sig(I) threshold for spots to be used in autoindexing
C
C     .. Scalars in Common Block /SPOTS/ ..
        REAL XF,YF,XFID1,YFID1,XFID2,YFID2,XFID3,YFID3,PHIIMG,
     +       LPIXEL,LYSCALE,LOMEGA,LXCEN,LYCEN
        INTEGER NSPT,ISPOT,ITHRESH,IRSCAL,LIXLEN,LIYLEN,INVFLAG,
     +       LISWUNG
        CHARACTER*100 SPTNAM,NSPTNAM

C     ..
C     .. Arrays in common /SPOTS/ ..
        REAL XSPT(NSPOTS),YSPT(NSPOTS)
        INTEGER ISPT(NSPOTS),IXSPT(NSPOTS),IYSPT(NSPOTS),
     +          ISTIMG(MAXIMG),IENDIMG(MAXIMG),ISDSPT(NSPOTS)
        INTEGER*2 INDX(NSPOTS)
        LOGICAL SELECT(MAXIMG),SPOTFND(MAXIMG)
C     ..
C     .. Common Block /SPOTS/ ..
        COMMON /SPOTS/ XF,YF,XFID1,YFID1,XFID2,YFID2,XFID3,YFID3,
     +                 XSPT,YSPT,ISPT,IXSPT,IYSPT,INDX,ISPOT,NSPT,
     +                 ITHRESH,PHIIMG,IRSCAL,LPIXEL,LYSCALE,LOMEGA,
     +                 LIXLEN,LIYLEN,LXCEN,LYCEN,INVFLAG,LISWUNG,
     +                 ISTIMG,IENDIMG,SELECT,ISDSPT,SPOTFND
C
        COMMON /CSPOTS/ SPTNAM,NSPTNAM

C&&*&& end_include  ../inc/spots.f
C&&*&& include  ../inc/lmb.f
C
C $Id: lmb.f,v 1.3 2003/07/11 13:16:07 harry Exp $
C
C--- awk generated include file  lmb.h
C---- START of include file lmb.h
C ODSCAL is to scale image numbers into the range 0-255 for plotting
C average profiles.
C  GAIN should be equal to the overall gain (image counts per X-ray photon)
C of the system, and is used to evaluate standard deviations based on
C counting statistics assuming independent pixels (ie point spread function
C less than pixel size).
C INVERTX true if image is inverted in the slow (X) direction when read in.
C ISCAL is to scale final integrated intensities and sigmas
C IDIVIDE is the adc offset
C ICONST is a constant to be added to all pixels (normally zero) to
C        allow processing of images with zero pixel values in the scanned
C        area.
C IMGP is true if working with image plate data
C SPIRAL is true for scanners with a spiral readout (Mar, DIP2000)
C ORTHOG is true for scanners with orthogonal scan (FUJI, RAXIS, MD)
C NULLPIX is the value of pixels within the image but not in the active
C area of the detector
C TILED is true if there are inactive areas of the detector within the
C       inscribing circle or square.
C
C NTILEX Number of tiles in X direction
C NTILEY Number of tiles in Y direction
C TILEX  X Coordinates of the midpoints of the null areas between tiles
C TILEY  Y Coordinates of the midpoints of the null areas between tiles
C TILEWX Width of the null areas between tiles in X
C TILEWY Width of the null areas between tiles in Y


C MACHINE and MODEL denote the type of detector. 
C
C MACHINE is used in the following subroutines:
C GETBLK, GETHDR, INTPXL, INTPXL2, MXDSPL, OPENODS, PROCESS, PUTPXL
C Currently coded types are:
C
C         MACHINE        MODEL               COMMENTS
C         =======        =====               ========
C         MAR            180, 300, 345
C         RAXI(S)        RAXISII, RAXISIV
C         MD
C         FUJI
C         CCD1           CCD1                Princetown CCD at CHESS,Tiff format
C         CCD2           CCD ?               ESRF CCD detector
C         ADSC           QUAD1               ADSC 2x2 CCD detector
C
C     .. Scalars in Common Block /LMB/ ..
	REAL ODSCAL,GAIN,LOGA,LOGB
        INTEGER ISCAL,IDIVIDE,ICONST,NULLPIX,NTILEX,NTILEY,
     $    RAXISCOMP
        LOGICAL IMGP,INVERTX,SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,
     $    NEWRAXIS,BRUKNEW
        CHARACTER MACHINE*4,MODEL*8

C     ..
C     .. Arrays in common /LMB/
        INTEGER TILEX,TILEY,TILEWX,TILEWY
C
C     .. Common Block /LMB/ ..
	COMMON /LMB/ ODSCAL,GAIN,LOGA,LOGB,ISCAL,IDIVIDE,ICONST,
     +               NULLPIX,NTILEX,NTILEY,RAXISCOMP,TILEX(20),
     +               TILEY(20),TILEWX(20),TILEWY(20),IMGP,INVERTX,
     +               SPIRAL,ORTHOG,CIRCULAR,TILED,SETADC,NEWRAXIS,
     $               BRUKNEW
        COMMON /LMBC/ MACHINE,MODEL

C&&*&& end_include  ../inc/lmb.f
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/ori.f
C
C $Id: ori.f,v 1.1 2002/05/02 10:47:02 harry Exp $
C
C--- awk generated include file  ori.h
C---- START of include file ori.h
C
C     XCEN,YCEN    Coordinates (in 10 micron units) of the direct beam
C                  position relative to an origin at the position of the
C                  first pixel in the digitised image.(The SCANNER
C                  coordinate frame). These parameters are refined for
C                  each image. 
C
C     XCEN0,YCEN0  Coordinates of direct beam position at zero swing angle.
C                  (Needed for pxtomm conversion for swung detectors)
C                  These values are assigned on the basis of input direct
C                  beam coordinates, corrected for swing angle if necessary.
C                  They are not (currently) updated during refinement.
C
C     XOFF,YOFF    Distance between centre of detector and direct beam.
C
C     ..
C     .. Arrays in common /ORI/ ..
      LOGICAL FIXPAR
C
C     .. Scalars in common block /ORI/ ..
      REAL COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     +     VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     +     RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,YCEN0,
     +     XOFF,YOFF,TILTMAT,TWISTMAT,DETNOR,DPSIX
      INTEGER CBAR,NODES,NPHI,IJUNK2,IJUNK3
      LOGICAL RESETCCOM
C     ..
C     .. Common Block /ORI/ ..
      COMMON /ORI/COSOM0,SINOM0,XTOFRA,YSCAL,TILT,TWIST,BULGE,
     $       VBNEG,VBPOS,VTILT,VTWIST,VVERT,TOFF,BULGE2,PBULGE,ROFF,
     $       RDTOFF,RDROFF,ROFFPHI,TOFFPHI,JUNK3,XCEN,YCEN,XCEN0,
     +       YCEN0,XOFF,YOFF,TILTMAT,TWISTMAT,DPSIX,DETNOR(3),CBAR,
     +       NODES,NPHI,IJUNK2,IJUNK3,FIXPAR(NRPAR),
     $       RESETCCOM
C     ..
C
C
C&&*&& end_include  ../inc/ori.f
c     startgw
C&&*&& include  ../inc/condata.f
C
C $Id: condata.f,v 1.14 2004/07/20 12:40:18 harry Exp $
C
C--- awk generated include file condata.h 
C---- START of include file condata.h 
C 
C
C     FIXSWAP     Forces reversal of normal byte-swapping choice.
C
C---- SUMPART True if two images are to be stored in memory at the
C               same time. This will be the case if post-refinement
C               (other than POSTHOC post-refinement for off-line
C               scanners) is being performed. Note that SUMPART is NOT
C               used to determine if partials should be added across
C               images (this is ADDPART)
C
C---- NEWPREF True if allowing partials over multiple images in post-
C             refinement.
C
C---- ADDPART True if partials are to be summed across images. This is
C               only appropriate for fixed origin (ie on-line)
C               scanners where the X-ray dose is identical for
C               each image.
C     Direct beam coordinates
C             These are read into XMM(3), YMM(3) where (3) is for A,B,C packs
C             Immediately on reading in, these values are transferred
C             into XCENMM, YCENMM, XCENMMIN(J,3) where J=1->MAXPAX.
C
C             If an IMAGE keyword has been given, XCENMM(1,1)=XMM(1) and
C             YCENMM(1)=YSCAL*YMM(1). If swung out, YCENMM(1,1) is updated.
C             If a BEAM keyword has not been given, XMM,YMM, XCENMM,YCENMM,
C             XCENMMIN are all set to the middle of the image.


C             Then, when reflecting input to logfile, it AGAIN sets up
C             XCENMM,YCENMM for all images using XMM,YMM, this time
C             using YSCAL to set up YCENMM, and updating YCENMM if the
C             detctor is swung out. (label 708), DO loop 710. If image
C             is "inverted", corrects XCENMM for all images.


C             XCEN,YCEN are set in "mosflm" to XCENF, YCENF plus
C             camera constants, and XCENF,YCENF are in turn set from
C             XCENMM,YCENMM. Thus XCENMM,YCENMM are what is actually
C             used to define the beam position.

C
C     LPREF   If TRUE, return to display after refinement over entire
C             image. Only active when integrating interactively. Set by
C             toggle button in Parameter window.
C

C     LOVERLAP  If TRUE, do not call the OVERLAP subroutine

C     ALLOUT  If TRUE, all reflections (whether measured or not, or
C             classified as BADSPOTS or not, will be written to the
C             output MTZ file.
C
C     NTDIG   Number of digits in image number, returned as zero if
C             there is an error in the template. Only used if TEMPLATE
C             keyword given.
C
C     TEMPLATE is TRUE if a TEMPLATE keyword has been given.
C
C     NOLP    If TRUE, do NOT apply the Lorentz Polarisation corrections
C
C     MULTIMTZ True if writing each "block" of images to a separate MTZ file
C
C     DISPMENU True if the run was started with a IMAGE keyword. Not to be
C              confused with WINOPEN which is true if the X-window display
C              is being used, but this is not necessarily starting with
C              a "IMAGE" keyword.
c     newgui - this means that we're talking through the new GUI.
c              except that we can't have it here because the prsummary 
c              subroutine, where we REALLY want it, clashes with this common
C
C     HACTIVEMASK,LACTIVEMASK,LACTIVE - only for Rigaku images which 
C     contain a compressed "active mask" (size=HACTIVEMASK bytes)
C     at the end of the image. Compression uses a modified run length encoding
C     at present (10.01.2003).
C
C     ..
C     .. Arrays in common /CONDATA/ ..
      REAL XCENMM,YCENMM,THFOIL,PHIBEGA,PHIENDA,RSYM,XMM,YMM,
     +     XCENMMIN,YCENMMIN
      REAL RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +     PHIRNG,YSCALIN,FULLFRAC,WTIME
C     ..
C     .. Arrays in common /CONDATA/ ..
      INTEGER IDPACK,NFPACK,NFIRST,ICASSET
      INTEGER IPACK1A,IPACK2A,ISERAR
      LOGICAL AVPROF,FILMPLOT,FORCEB,FORCEC
C
C     .. Scalars in common /CONDATA/ ..
C     ..
      INTEGER NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX
      INTEGER IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK
      LOGICAL FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF,ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW, 
     +        spostref,newgui,LACTIVEMASK,USERSPOT,HEADONLY
C     ..
C real arrays, then scalars, integer arrays, scalars, logicals
      COMMON /CONDATA/
     $       XCENMM(MAXPAX,3),
     +       YCENMM(MAXPAX,3), THFOIL(3),PHIBEGA(MAXPAX),
     $       PHIENDA(MAXPAX),RSYM(4,4,96),XMM(3),YMM(3),
     $       XCENMMIN(MAXPAX),YCENMMIN(MAXPAX),
     $       RMSLIM,WRMSLIM,VLIM,XMID,SEP,THICK,PTMIN,REFREJ,WAIT,
     +       PHIRNG,YSCALIN,FULLFRAC,WTIME,
     $        IDPACK(MAXPAX),NFPACK(MAXPAX),NFIRST(MAXPAX),
     +        ICASSET(MAXPAX),IPACK1A(50),
     +        IPACK2A(50),ISERAR(50),
     $        AVPROF(MAXPAX),FILMPLOT(MAXPAX),FORCEB(MAXPAX),
     +        FORCEC(MAXPAX),
     $        NPACK,NCYC,MAXNX,MAXNY,ITHRESHF,NSIG,IRFMIN,
     +        IRFINC,IXSHIFT,IYSHIFT,LIMIT,NBLOCK,INOGEN,NFGEN,MINREF,
     +        ISERADD,NSEG,NSYM,NSYMP,NRUN,NSERTOT,IWAVE,ISWUNG,IPIX,
     $        IMAT,ICELL,IUMAT,LSYMM,IDIST,IBEAM,ISCAN,NLINE,NRLINE,
     +        NTLINE,ISTARTP,IRAST,INEWMAT,ISEP,NSAVELINE,IPTIME,
     +        ISTRT,IANGLE,IBACKS,IPOLAR,IDIVH,IDIVV,IGAIN,IBLOCK,
     +        IHKLOUT,IGENF,INRES,NTDIG,DELAY,IMULTI,IMISS,IMISSMAT,
     +        IIDENT,HACTIVEMASK,
     $        FINDCC,READCC,NOFID,INTERPOL,CONVOL,NOMEAS,
     +        USEPAR,USEOVR,SUMPART,USEBOX,POSTREF, spostref, ADDPART,
     +        FIXED,POWDER,RWEIGHT,NOREF,MULTISEG,FIXSWAP,POSTHOC,
     +        LPREF,LPINTG,DISPMENU,PRMODE,PRCELL,TEMPLATE,
     +        LOVERLAP,ALLOUT,NOLP,NEWPREF,NOBACK,MOSEST,NUSPOT,
     $        NUBACK,NUFIND,HARVESTREADY,HEADINFO,MULTIMTZ,ANDREW,
     $        newgui,LACTIVEMASK,USERSPOT,HEADONLY


C&&*&& end_include  ../inc/condata.f
C&&*&& include  ../inc/gendata.f
C
C $Id: gendata.f,v 1.2 2003/01/10 16:17:53 andrew Exp $
C
C--- awk generated include file  gendata.h
C---- START of include file gendata.h
C
C     IMG       Partiality indicator. 0 for full reflections, 1 to 100
C                   for partials. Negative for partials at the start of the
C                   rotation range, +ve for partials at the end of the 
C                   rotation. Set in subroutine REEK using DELEPS calculated
C                   in subroutine DSTAR
C
C     IRG       Reflection flag  (Set by SPTEST called from DSTAR)
C               =  0  Spot can be measured
C               =  1  Outside R, X, Y limits
C               =  2  Overlapping spot (set later)
C               =  3  Too wide in phi (more than NWMAX images)
C               =  4  DST .GT. DSTMAX  Not included in final film list -
C                       used only to check for overlaps at edge of film.
C               = 10  Spot is within cusp, but will be observed...not included
C                     in final spot list but must be included in predicted
C                      pattern
C
C               =  21  Spot present on 2 images, this is 1st
C               =  22  Spot present on 2 images, this is 2nd
C
C               =  31  Spot present on 3 images, this is 1st
C               =  32  Spot present on 3 images, this is 2nd
C               =  33  Spot present on 3 images, this is 3rd
C
C               =  41  Spot present on 4 images, this is 1st
C               =  42  Spot present on 4 images, this is 2nd
C               =  43  Spot present on 3 images, this is 3rd
C               =  44  Spot present on 4 images, this is 4th
C
C                 etc etc
C
C     XG        Virtual detector X coordinate in 10 micron units, relative to
C               an origin at the direct beam position. X is parallel to the
C               Y axis in the laboratory frame, ie orthogonal to the rotation
C               axis.
C
C     YG        Virtual detector Y coordinate in 10 micron units, relative to
C               an origin at the direct beam position. Y is parallel to the
C               Z axis in the laboratory frame, ie  the rotation axis.
C
C     IX,IY     are the coordinates of the reflection in pixels
C               (integers) wrt the first pixel in the image (lower left corner
C               cameramans view). For testing for spot overlap, these
C               coordinates are in 10 micron units. Also used for display
C               pixel coordinates when displaying predicted pattern.
C
C     IREC      Pointer to the record number of a particular spot in the
C               list of generated reflections.
C
C
C     ..
C     .. Arrays in common /GENDATA/ ..
      REAL FRACG,PHIG,PHIWG,XG,YG,GOODFIT
      INTEGER INTG,IPRO,IX,IY,IREC
      INTEGER*2 IRG,IMG,IGFLAG,ISDPRO,ISDG,IHG,IKG,ILG,IMPARTG,
     +          MISYMG
C     .. Scalars in common /GENDATA/ ..
      INTEGER IPACKREC,IPACKHEAD,IRECLAST
C     ..
C     .. Common block /GENDATA/ ..
      COMMON /GENDATA/FRACG(NREFLS),PHIG(NREFLS),PHIWG(NREFLS),
     $       XG(NREFLS),YG(NREFLS),INTG(NREFLS),IPRO(NREFLS),
     $       IX(NREFLS),IY(NREFLS),IREC(NREFLS),IRG(NREFLS),IMG(NREFLS),
     +       IGFLAG(NREFLS),ISDPRO(NREFLS),ISDG(NREFLS),
     +       IHG(NREFLS),IKG(NREFLS),ILG(NREFLS),IMPARTG(NREFLS),
     +       MISYMG(NREFLS),GOODFIT(NREFLS),IPACKREC,IPACKHEAD,
     +       IRECLAST
C     ..
C
C

C&&*&& end_include  ../inc/gendata.f
C&&*&& include  ../inc/iosp.f
C
C $Id: iosp.f,v 1.1 2002/05/02 10:46:53 harry Exp $
C
C--- awk generated include file  iosp.h
C---- START of include file iosp.h
C
C
C     .. Scalars in common block /IOSP/ ..
      INTEGER NSPOT,NFULL,NOUTGEN
C     ..
C     .. Common Block /IOSP/ ..
      COMMON /IOSP/NSPOT,NFULL,NOUTGEN
C     ..
C
C
C&&*&& end_include  ../inc/iosp.f
C&&*&& include  ../inc/xy.f
C
C $Id: xy.f,v 1.1 2002/05/02 10:47:25 harry Exp $
C
C--- awk generated include file  xy.h
C---- START of include file xy.h
C
C     .. Scalars in common block /XY/ ..
      REAL XTOFD,SINV,COSV,TANV,TWOTHETA
      INTEGER ICASS
C     ..
C     .. Common Block /XY/ ..
      COMMON /XY/XTOFD,SINV,COSV,TANV,TWOTHETA,ICASS
C     ..
C
C     XTOFD....  Crystal to detector distance in 10 micron units. Read from
C                keyworded input and never changed.
C
C                Spot positions are calculated in S/R XYSPOT (Called from
C                REEK) and are for an "ideal" detector at a distance of XTOFD.
C                These are converted into pixel positions in S/R MMTOPX
C                which applies the multiplicative factor XTOFRA to allow
C                for refinement of the distance. XTOFRA is the parameter
C                that is actually refined (in RDIST), rather than XTOFD.
C                The refined distance that is printed in the logfile is
C                actually XTOFRA*XTOFD
C
C     ICASS....  Indicates detector type:
C                0     Flat film
C                1     Vee shaped cassettes
C                2     FAST detector (only used in TESTGEN mode of OSCGEN)
C                3     Swung out FAST (ditto)
C                4     IP detector
C     TWOTHETA   Detector swing angle (degrees)
C&&*&& end_include  ../inc/xy.f
c     endgw

      real radtheta, dtor
      character*1000 outline

      dtor = 4.0 * atan(1.0) / 180.0
      IF(ABS(DSTMAX).LT.1e-5)DSTMAX = 1
      IF(ABS(DSTMIN).LT.1E-5)DSTMIN = 1
      outline = ' '

 101  format('<?xml version="1.0"?><!DOCTYPE image_response>',
     +     '<image_response><status><code>ok</code></status>',
     +     '<region><xmin>', i4, '</xmin><ymin>', i4, '</ymin>',
     +     '<xmax>', i4, '</xmax><ymax>', i4, '</ymax></region>',
     +     '<beam><x>', f10.5, '</x><y>', f10.5, '</y></beam>',
     +     '<contrast><minimum>', i6, '</minimum><maximum>',
     +     i6, '</maximum></contrast>',
     +     '<beamline_parameters><wavelength>', f7.4, '</wavelength>',
     +     '<beam_divergence><horizontal>', f6.3, 
     +     '</horizontal><vertical>', f6.3, '</vertical>',
     +     '</beam_divergence></beamline_parameters>',
     +     '<distance>', f10.4, '</distance>',
     +     '<detector><two_theta>', f8.3, '</two_theta>',
     +     '<resolution_limits><maximum>', f10.4, '</maximum>',
     +     '<minimum>', f10.4, '</minimum></resolution_limits>',
     +     '<gain>', f7.2, '</gain></detector>',
     +     '<header><oscillation_sequence><start>', f7.2,
     +     '</start><range>', f7.2, '</range>',
     +     '</oscillation_sequence></header></image_response>')
      write(outline, fmt=101) 0, 0, 0, 0, xmm(1), ymm(1),
     +     0, 0, wave, 2.0 * divh / dtor, 2.0 * divv / dtor,
     +     0.01 * xtofd, twotheta, wave/dstmax, wave/dstmin, gain,
     +     phibeg, phiend - phibeg
      write(*, fmt=101) 0, 0, 0, 0, xmm(1), ymm(1),
     +     0, 0, wave, 2.0 * divh / dtor, 2.0 * divv / dtor,
     +     0.01 * xtofd, twotheta, wave/dstmax, wave/dstmin, gain,
     +     phibeg, phiend - phibeg

      call write_grey_jpeg(serverfd, nrec, iylen, image)
      
      end















C
C $Id: cresol.f,v 1.7 2003/04/30 14:01:40 harry Exp $
C
      SUBROUTINE CRESOL(IX1, IY1, DISTANCE, TWOTHETA, WAVELENGTH, RESOL)
c     =============================================================
c
c Calculate resolution of point (based on DETRES)
c
c Input:
c     IX1, IY1    pixel coordinates in image
c     distance    detector distance (mm)
c     twotheta       detector angle (degrees)
c     wavelength  wavelength (A)
c
c Output:
c     resol     resolution in A
c
      IMPLICIT NONE
C     ..
C     .. Scalar Arguments ..
      REAL DISTANCE, TWOTHETA, WAVELENGTH, RESOL
      INTEGER IX1, IY1
C     ..
C     .. Local Scalars ..
C
C     ..
C     .. Local Arrays ..
      REAL CAMCON(8), VDCO(3), DD(3,3), DN(3)
C     ..
C     .. Include files ..
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C     ..
C     .. Data statements ..
      DATA CAMCON /8*0.0/
C
C---- note well! CAMCON(3) should actually be in 10 micron units, not mm; 
C     however, as this is only a scale factor we can omit the
C     conversion here and also the conversion after calling PXTOMM 
C     once we have values for VDCO(1) and VDCO(2). Old-style code needs
C     neither conversion.
C     
      CAMCON(3) = DISTANCE
      CAMCON(5) = -TWOTHETA
      VDCO(3) = 1.0
C
      IF(NUREEK)THEN
C
C---- Detector rotation - new style
C
        CALL DDDN(CAMCON,DD,DN)
C
C---- Convert pixel to mm
C
        CALL PXTOMM(FLOAT(IX1), FLOAT(IY1), VDCO(2), VDCO(1))
      ELSE
C
C---- Detector rotation - old style
C
        CALL DDMAT(DISTANCE, TWOTHETA, DD, DN)
C
C---- Convert pixel to mm
C
        CALL PXTOMM(FLOAT(IX1), FLOAT(IY1), VDCO(1), VDCO(2))
      ENDIF
C
C---- determine resolution
C
      CALL DETRES(DD, VDCO, RESOL)
      RESOL = RESOL * WAVELENGTH
      RETURN
      END
C== CROSS ==
C
C
C
      SUBROUTINE CROSS(A,B,C)
C     =======================
C
C
C     .. Array Arguments ..
      REAL A(3),B(3),C(3)
C     ..
C
C
C
C
      A(1) = B(2)*C(3) - C(2)*B(3)
      A(2) = B(3)*C(1) - C(3)*B(1)
      A(3) = B(1)*C(2) - C(1)*B(2)
C
C
      END
C
C $Id: crysthdr.f,v 1.6 2003/05/15 10:00:50 harry Exp $
C
C== CRYSTHDR ==
      SUBROUTINE CRYSTHDR
C     ===================
C
C
        IMPLICIT NONE
C     .. Parameters ..
C&&*&& include  ../inc/parameter.f
C
C $Id: parameter.f,v 1.5 2004/07/20 12:39:02 harry Exp $
C
C--- awk generated include file  parameter.h
C---- START of include file parameter.h
C
C	PARAMETERS
C	IYLENGTH.. maximum number of I*2 words of data in the 
C                  "fast" (ie most rapidly changing) direction in the
C                  digitised image. This will be HALF the number of pixels
C                  for film data (each pixel is stored in one byte)
C                  but will equal the number of pixels for IP data.
C	IXWDTH...  The maximum number of "stripes" of data in the scanned image
C                  ie the number of pixels in the "slow" direction
C                  (This is the Y direction in the MOSFLM convention)
C                  Note that the array "IMAGE" used to store the image is
C		   declared as size IYLENGTH*IXWDTH I*2 words for IP data
C                  and 2*IYLENGTH*IXWDTH BYTES for film data.
C		   If this exceeds the
C		   available memory, set ixwdth=1, recompile program
C		   and use keyword "NOCORE" when running program.
C                  Note that for the POSTREF and ADDPART options,
C                  two images have to be stored in memory at once so
C                  IXWDTH should be twice the number of records in an
C                  image.
C       MAXHEAD    maximum length of image header (in 4 byte words)
C	NREFLS.... maximum number of spots per film in generate file (10000)
C	MAXBOX.... maximum number of pixels in measurement box (1000)
C	MAXDIM.... maximum box size in either direction (pixels) (41)
C	MAXPAX.... maximum number of packs per generate file (10000)
C	MXDOV2..... maxdim/2
C	MAXBUFF... maximum size of buffer (I*2) for storing ods
C		   of active spots in subroutine meas(20000).
C                  Must be .GE.  MAXBOX*(NNLINE-1) for subroutine process
C       MREF...... maximum number of reflections to be used in post
C                  refinement (6000)
C	NEXPAND... maximum number of expansions of the input measurement
C		   box (2)
C	NMASKS.... maximum number of different profiles (25). Note the
C                  connection between this parameter and NNLINE
C	NVECT..... maximum number of vectors for storing scanned image
C                  in filmplot (10000)
C       NIMAX..... maximum number of images to be used together in 
C                  postrefinement (NADD or WIDTH options) (30)
C       NNLINE...  maximum number of boundary lines for setting up
C                  the areas for profile fitting. The maximum possible
C                  number of standard profiles will be (NNLINE-1)**2
C                  although for a circular detector the actual number
C                  may be less than this as some boxes will lie entirely
C                  outside the detector.
C       NREJMAX... Maximum number of rejected background pixels, resulting
C                  either from overlap of adjacent spots or outliers from
C                  the background plane
C       NSPOTS...  Maximum number of found spots (for autoindexing) that can
C                  be stored (for all images). Also maximum number in 
C                  a file wriitten by IMSTILLS that can be 
C                  stored/displayed/edited. THis must be an even number
C       MCOLS....  Number of columns in output MTZ file
C       MCOLSTR..  Number of columns in output MTZ file for strategy option
C     
C       MTZ Orientation block
C        MBLENG is total length of block, MBLINT, MBLREA are numbers
C          of integers & reals
C       NRPAR....  Maximum number of refineable parameters for detector
C                  positional refinement (subroutine RDIST)
C       NSEGMAX..  Maximum number of segments in STRATEGY
C       MULTMAX... Maximum number of observations with same hkl in COMPLETE
C       MAXDIFF... Maximum number of different packs that a given hkl occurs on
C       NRESBIN... Maximum number of resolution bins (COMPLETE)
C
C       MAXIMG...  Maximum number of images that can be read in using the IMAGE
C                  keyword or the "read Image" menu option.
C       MXSPOT...  Maximum number of spots that can be found on one image
C                  (before rejection on spot size).
C       MXCENT...  Maximum number of active spots during spot finding 
C                  (findspots)
C
C       MGRA, NGRA... maximum number of reflections and images over which a 
C                     reflection can be spread for postrefinement.
C
C     .. Parameters ..
      INTEGER IXWDTH
c      PARAMETER (IXWDTH=8192)
      PARAMETER (IXWDTH=12288)
      INTEGER IYLENGTH
c      PARAMETER (IYLENGTH=4096)
      PARAMETER (IYLENGTH=6144)
      INTEGER MAXHEAD
      PARAMETER (MAXHEAD=5120)
      INTEGER MAXBOX
      PARAMETER (MAXBOX=1500)
      INTEGER MAXBUFF
      PARAMETER (MAXBUFF=20000)
      INTEGER MAXDIM
      PARAMETER (MAXDIM=41)
      INTEGER MAXPAX
      PARAMETER (MAXPAX=10000)
      INTEGER MXDOV2
      PARAMETER (MXDOV2=MAXDIM/2)
      INTEGER NEXPAND
      PARAMETER (NEXPAND=2)
      INTEGER NMASKS
      PARAMETER (NMASKS=25)
      INTEGER NREFLS
      PARAMETER (NREFLS=250000)
      INTEGER MREF
      PARAMETER (MREF=6000)
      INTEGER NVECT
      PARAMETER (NVECT=10000)
      INTEGER NIMAX
      PARAMETER (NIMAX=30)
      INTEGER NNLINE
      PARAMETER (NNLINE=6)
      INTEGER NREJMAX
      PARAMETER (NREJMAX=600)
      INTEGER NSPOTS
      PARAMETER (NSPOTS=5000)
      INTEGER MCOLS
      PARAMETER (MCOLS=18)
      INTEGER MCOLSTR
      PARAMETER (MCOLSTR=6)
      INTEGER NREFSTR
C
C---- Each reflection for strategy run needs MCOLSTR I*2 words
C     plus an I*4 word for the merging
C
      PARAMETER (NREFSTR = IXWDTH*IYLENGTH/(2+MCOLSTR))
      INTEGER MBLENG,MBLINT,MBLREA
      PARAMETER (MBLENG=185,MBLINT=29,MBLREA=156)
      INTEGER NRPAR
      PARAMETER (NRPAR=14)
      INTEGER NSEGMAX
      PARAMETER (NSEGMAX=100)
      INTEGER MULTMAX
      PARAMETER (MULTMAX=100)
      INTEGER MAXDIFF
      PARAMETER (MAXDIFF=100)
      INTEGER NRESBIN
      PARAMETER (NRESBIN=20)
      INTEGER MXSPOT
      PARAMETER (MXSPOT=5000)      
      INTEGER MAXIMG
      PARAMETER (MAXIMG=100)      
      INTEGER NPIXBG
      PARAMETER (NPIXBG=51)
      INTEGER MXCENT
      PARAMETER (MXCENT=500)
      INTEGER    NGRA,MGRA
      PARAMETER (NGRA=20)
      PARAMETER (MGRA=50000)
C&&*&& end_include  ../inc/parameter.f
C
C----     Store information in common /ORIENT/.
C     This routine sets all variables in /ORIENT/ except
C     PHISTT & PHIEND: also LBCELL if it is not in the file.
C     
C     .. Scalar Arguments ..
C      INTEGER
C     
C     ..
C     .. Array Arguments ..
C      REAL
C     ..
C     .. Local Scalars ..
      REAL              DTOR,DELAMBX,DELCORX,ETAD,DIVHD,DIVVD,ALAMBD
      INTEGER           I,J
C      CHARACTER         GTITLE*80,CBUF*88
C     ..
C     .. Local Arrays ..
      REAL              E1AXIS(3),S0VEC(3)
      CHARACTER         ABC(3)*2, AXSLAB*8
C     ..
C     .. External Subroutines ..
C      EXTERNAL          
      INTEGER LENSTR
      EXTERNAL LENSTR
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC         ATAN
C     ..
C     .. Common blocks ..
C&&*&& include  ../inc/cell.f
C
C $Id: cell.f,v 1.2 2003/06/16 16:41:13 harry Exp $
C
C--- awk generated include file  cell.h
C---- START of include file cell.h
C
C     CELL cell dimensions (real space)
C     RCELL reciprocal cell parameters in dimensionless rlu
C
C     .. Arrays in Common /CELLCOM/ ..
      REAL UMAT,BMAT,GMAT,CELL,RCELL,UMATCELL,SOFTCELL
      INTEGER LCELL,ICRYST,NUMSPG,NLAUE
C     ..
C     .. Common Block /CELLCOM/ ..
      COMMON /CELLCOM/UMAT(3,3),BMAT(3,3),GMAT(3,3),CELL(6),RCELL(6),
     $       UMATCELL(6),SOFTCELL,LCELL(6),ICRYST,NUMSPG,NLAUE
C     ..
C
C
C&&*&& end_include  ../inc/cell.f
C&&*&& include  ../inc/extras.f
C
C $Id: extras.f,v 1.2 2003/04/04 14:22:01 harry Exp $
C
C--- awk generated include file  extras.h
C---- START of include file extras.h
C
C
C     .. Scalars in common /EXTRAS/ ..
      INTEGER JUMPAX,NPACKS
      LOGICAL ISKIP,AFILM,BFILM,CFILM,STARTA,STARTB,STARTC,NOSTOP
C     ..
C     .. Common block /EXTRAS/ ..
      COMMON /EXTRAS/JUMPAX,NPACKS,ISKIP,AFILM,BFILM,CFILM,STARTA,
     +       STARTB,STARTC,NOSTOP
C     ..
C
C
C&&*&& end_include  ../inc/extras.f
C&&*&& include  ../inc/misc.f
C
C $Id: misc.f,v 1.1 2002/05/02 10:46:57 harry Exp $
C
C--- awk generated include file  misc.h
C---- START of include file misc.h
C
C
C
C     .. Scalars in common /MISC/ ..
      REAL PHIBEG,PHIEND,RMIN,RMAX,WAVE
      INTEGER IPACKID,MININT,IERRFLG
C     ..
C     .. Arrays in common /MISC/ ..
      REAL DELPHI,RESANI
      INTEGER IAX
C     ..
C     .. LOGICAL
      LOGICAL ANITES

C     ..
C     .. Common Block /MISC/ ..
      COMMON /MISC/DELPHI(3),RESANI(3),PHIBEG,PHIEND,RMIN,RMAX,WAVE,
     $       IAX(3),IPACKID,MININT,IERRFLG,ANITES
C     ..
C
C
C&&*&& end_include  ../inc/misc.f
C&&*&& include  ../inc/orient.f
C
C $Id: orient.f,v 1.3 2003/05/16 15:54:42 harry Exp $
C
C--- awk generated include file  orient.h
C---- START of include file orient.h
C     Orientation block data
C     
C     This contains slots for all information that seems to be essential
C     at present. Each group of parameters is padded at the end for future
C     expansion.
C     
C     Data in the orientation block are referred to the "Cambridge"
C     laboratory axis frame: x along the (idealized) X-ray beam, z along
C     usual rotation axis E1 (omega on 3-axis system). The matrix Q converts
C     a vector in the Madnes frame to the Cambridge frame.  Note that the
C     laboratory frame is essentially defined by the vectors e1,e2,e3 &
C     source. It doesn't really seem necessary to carry through a whole lot
C     of crystal and beam tensors, particularly as we have integrated
C     intensities at this stage, but maybe someone will want to, using the
C     allocated padding
C     
C     The general orientation equation is
C     
C     x  =   R M U B h
C     
C     where x    position in laboratory frame
C     R    goniostat matrix
C     M    missetting angle matrix (if relevant, see MISFLG)
C     PhiZ PhiY PhiX (PHIXYZ)
C     U    crystal orientation matrix UMAT
C     B    cell orthogonalization matrix, derived from cell dimensions
C     h    reflection indices
C     
C     Note that the description below is NOT is the same order as in the
C     common block, in which all the integers come before all the reals 
C     (flagged as I or R in the description below)
C     
CI    NWORDS       number of words in orientation block
CI    NINTGR       number of integers (first part of block,
C     includes these counts)
CI    NREALS       number of reals
CI    IORTYP       type of orientation block (for possible future use, now = 0)
CI    INTPAD(9)    padding for future use (integers)
C     
C---  Information for this crystal
C     
CR    CELLX(6)      cell dimensions  (A & degrees)
CI    LBCELL(6)    refinement flags for cell dimensions
CR    UMATX(3,3)    orientation matrix U. If MISFLG .gt. 0, U is the
C     "standard" setting when PhiXYZ ==0 
CI    MISFLG       status of "missetting" angles PHIXYZ
C     = 0  PHIXYZ not used, all orientation in UMAT
C     = 1  1 set of missetting angles (PHIXYZ(I,1))
C     = 2  2 sets PHIXYZ(I,J), J=1,2
CR    PHIXYZ(3,2)  missetting angles at beginning & end of rotation 
CI    JUMPAX       reciprocal axis closest to principle goniostat axis E1
C     (only used for printing)
CI    NCRYST       crystal number: a crystal may contain several batches
CI    LCRFLG       type of crystal mosaicity information
C     (=0 for isotropic, =1 anisotropic)
C     *** CRYDAT(12) equivalenced to following ***
CR    ETAD         reflection width (full width) (degrees)  (if LCRFLG=0)
C     or
CR    ETADH,ETADV  horizontal & vertical reflection width   (if LCRFLG=1)
CR    rest of CRYDAT: padding for crystal information (eg more complicated
C     mosaicity model)
C     ***
C     
C---  Information for this batch
C     
CI    LDTYPE       type of data
C     = 1    oscillation data   (2D spots)
C     = 2    area detector data (3D spots)
C     = 3    Laue data
CR    DATUM(3)     datum values of goniostat axes, from which Phi is measured
C     (degrees)
CR    PHISTTX,PHIENDX start & stop values of Phi (degrees) relative to datum
CI    JSCAXS       goniostat scan axis number (=1,2,3, or =0 for
C     multiple axis scan
CR    SCANAX(3)    rotation axis in laboratory frame (not yet implemented:
C     only relevant if JSCAXS=0)
CR    TIME1, TIME2 start & stop times in minutes
CI    NBSCAL       number of batch scales & Bfactors plus SD's
C     (4 at present, BSCALE, BBFAC & sd's)
C     set = 0 if batch scales unset
CR    BSCALE       batch scale
CR    BBFAC        batch temperature factor
C     corresponding scale is exp(-2 B (sin theta/lambda)**2)
CR    SDBSCL       sd (Bscale)
CR    SDBFAC       sd (BBfac)
CR    BATPAD(12)   padding for batch information
C     
C---  Crystal goniostat information
C     
CI    NGONAX       number of goniostat axes (normally 1 or 3)
CI    E1(3),E2(3),E3(3) vectors (in "Cambridge" laboratory frame, see below)
C     defining the NGONAX goniostat axes
CC    GONLAB(3)  names of the three goniostat axes
CR    GONPAD(12) padding for goniostat information
C     
C---  Beam information
C     
CR    SOURCE(3)    Idealized (ie excluding tilts) source vector 
C     (antiparallel to beam), in "Cambridge" laboratory frame
C
C     S0(3) moved to reeke.f 06.02.2003 !! replaced here with 
C     SOURCEV(3) 09.05.2003 - we need it here for writing out to MTZ header.
CR    S0(3)        Source vector (antiparallel ! to beam), in
C                   "Cambridge" laboratory frame, including tilts
CI    LBMFLG       flag for type of beam information following 
C                   = 0 for ALAMBD, DELAMB only (laboratory source)
C                   = 1     ALAMBD,DELAMB,DELCORX,DIVHD,DIVVD (synchrotron) 
C                           (other options could include white beam)
C     *** BEMDAT(25) equivalenced to following ***
CR    ALAMBD       Wavelength in Angstroms
CR    DELAMB       dispersion Deltalambda / lambda.
CR    DELCORX       Correlated component of wavelength dispersion.
CR    DIVHD        Horizontal beam divergence in degrees.
CR    DIVVD        Vertical beam divergence (may be 0.0 for isotropic beam
C                        divergence.
CR    rest of BEMDAT: padding for beam information
C                      (*** How much here for Laue? ***)
C     ***
C     
C---  Detector information
C     
CI    NDET         number of detectors (current maximum 2)
C     -- for each detector
CR    DXn          crystal to detector distance (mm)
CR    THETAn       detector tilt angle (=Madnes:tau2) (degrees)
CR    DETLMn(2,2)  minimum & maximum values of detector coordinates (pixels)
C                     (i,j): i = 1 minimum, = 2 maximum
C                            j = 1 Xdet,    = 2 Ydet
C                  The exact detector frame is not important, but Ydet
C                  should be the axis ~ parallel to the pricipal
C                  rotation axis
CR    DETPAD(33)     padding for detector information
C     
C
C     ..
C     .. Common blocks ..
      INTEGER NWORDS,NINTGR,NREALS,IORTYP,LBCELL,MISFLG,
     +     JUMPAXX,NCRYST,LCRFLG,LDTYPE,JSCAXS,NBSCAL,NGONAX,LBMFLG,
     +     NDET,INTPAD
      REAL   CELLX,UMATX,PHIXYZ,CRYDAT,DATUM,
     +     PHISTTX,PHIENDX,SCANAX,TIME1,TIME2,
     +     BSCALE,BBFAC,SDBSCL,SDBFAC,BATPAD,E1,E2,E3,GONPAD,
     +     SOURCE,SOURCEV,BEMDAT,
     +     DX1,THETA1,DETLM1,DX2,THETA2,DETLM2,DETPAD
      CHARACTER BTITLE*70, GONLAB*8
C
C---- MTZ orient common blocks
C
C.... (i) Character variables
C
      COMMON /CORIEN/ BTITLE, GONLAB(3)
C
C.... (ii) Real/integer variables
C
      COMMON /ORIENT/ NWORDS,  NINTGR,  NREALS,
C
C---- Now the Integer variables
     +     IORTYP, LBCELL(6), MISFLG, JUMPAXX, NCRYST, LCRFLG, LDTYPE,
     +     JSCAXS, NBSCAL,    NGONAX, LBMFLG, NDET,   INTPAD(9),
C
C---- Now the Real variables (Batch stuff first)
C
     +     CELLX(6), UMATX(3,3), PHIXYZ(3,2), CRYDAT(12), DATUM(3),
     +     PHISTTX,  PHIENDX,    SCANAX(3),   TIME1,      TIME2,
     +     BSCALE,  BBFAC,     SDBSCL,      SDBFAC,     BATPAD(12),
C
C---- Now Real variables for goniostat and beam/detector info
C
     +     E1(3),   E2(3),      E3(3),       GONPAD(12), SOURCE(3),
     +     SOURCEV(3),BEMDAT(25), DX1,         THETA1,     DETLM1(2,2),
     +     DX2,     THETA2,     DETLM2(2,2), DETPAD(33)
C     
C&&*&& end_include  ../inc/orient.f
C&&*&& include  ../inc/reeke.f
C
C $Id: reeke.f,v 1.7 2004/06/22 14:54:39 harry Exp $
C
C--- awk generated include file  reeke.h
C---- START of include file reeke.h
C
C     TOR     For synchrotron sources, degree of polarisation of the beam
C     IMONO   Collimation flag for polarisation.
C             = 0   Pinhole or mirrors
C             = 1   Graphite Monochromator
C             = 2   Synchrotron, use TOR
C     NWMAX   Maximum reflection width in images
C     DSTMAX  dimensionless rlu, = WAVE/RES where RES is the maximum
C             resolution in Angstrom.
C     DSTMIN  dimensionless rlu, = WAVE/DMAX where DMAX is the maximum
C              Bragg spacing
C     S0      radiation source vector (-1,0,0), but should it be refined?
C
C     GONIO_angle:  machine angles for generalized goniostats
C     GONIO_angle_SET: fixed offset angles for 3- and 4-circle goniostats
C                      i.e. currently 54.74 deg for Bruker CHI, 50.0deg for
C                      Nonius and Oxford KAPPA 
C     ..
C     .. Arrays in common block /REEKE/ ..
      REAL RMC,AMAT,SCAXIS,S0
C     ..
C     .. Scalars in common block /REEKE/ ..
      REAL X1,X2,Y1,Y2,Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,
     +     DIVH,DIVV,DELAMB,ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,
     +     ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET
      INTEGER ISYN,IMONO,NWMAX,IPAD,NSMOOTH
C     ..
C     .. logicals in common block /REEKE/ ..
      LOGICAL LOGETA,NUREEK
C     ..
C     .. Common Block /REEKE/ ..
      COMMON /REEKE/RMC(3,3),AMAT(3,3),SCAXIS(3),S0(3),X1,X2,Y1,Y2,
     +     Z1,Z2,XYS,DSTAR2,DSTMAX,DSTPL,DSTPL2,DIVH,DIVV,DELAMB,
     +     ETA,DELCOR,DSTMAXS,TOR,DSTMIN,WMAX,ETAFRAC,ETASM,
     $     GONIO_CHI,GONIO_PHI,GONIO_KAPPA,GONIO_OMEGA,GONIO_2THETA,
     +     GONIO_CHI_SET,GONIO_KAPPA_SET,ISYN,IMONO,NWMAX,IPAD,
     $     NSMOOTH,LOGETA,NUREEK
C     ..
C
C
C&&*&& end_include  ../inc/reeke.f
C&&*&& include  ../inc/scn.f
C
C $Id: scn.f,v 1.3 2004/08/16 13:26:48 harry Exp $
C
C--- awk generated include file  scn.h
C---- START of include file scn.h
C
C     SCNSZ   is pixel size (in microns) divided by 25
C     RAST    pixel size in slow direction in mm
C     FACT    multiplying by FACT converts from 10 micron units 
C             (the standard unit internal to the program) into pixels
C     IYLEN   The number of pixels in the Y (fastest changing) direction
C             in the digitised image.
C     NREC    The number of pixels in the X (slow) direction in the 
C             digitised image.
C     NWORD   The number of I*2 words in the Y direction.
C     NBYTE   The number of bytes in Y direction = NWORD/2
C     NHBYTE  Number of bytes in header
C
C     ICURR   When several images are stored in a single file, ICURR is the
C             pointer to the first record of the current image in the direct
C             access file (only implemented for film data)
C     NEXTRA  The number of additional (unused) bytes padding the end of
C             each record in image file
C     BYTSWAP True if the "endedness" (Big-endian/Little-endian) of the 
C             machine that MOSFLM is running on is different to that of the
C             machine on which the image was written. This is determined by
C             looking at the value of NXPIX in the header record of the
C             image file (subroutine GETHDR)
C
C     LACTIVE True if using Rigaku active mask, False if ignoring it
C
C     .. Scalars in common block /SCN/ ..
      REAL FACT,SCNSZ,RAST,RASTY
      INTEGER NBYTE,NREC,NWORD,IYLEN,ICURR,NEXTRA,NHBYTE
      LOGICAL BYTSWAP,LACTIVE
C     ..
C     .. Common Block /SCN/ ..
      COMMON /SCN/ FACT,SCNSZ,RAST,RASTY,NBYTE,NREC,NWORD,IYLEN,
     +     ICURR,NEXTRA,NHBYTE,BYTSWAP,LACTIVE
C&&*&& end_include  ../inc/scn.f
C&&*&& include  ../inc/xy.f
C
C $Id: xy.f,v 1.1 2002/05/02 10:47:25 harry Exp $
C
C--- awk generated include file  xy.h
C---- START of include file xy.h
C
C     .. Scalars in common block /XY/ ..
      REAL XTOFD,SINV,COSV,TANV,TWOTHETA
      INTEGER ICASS
C     ..
C     .. Common Block /XY/ ..
      COMMON /XY/XTOFD,SINV,COSV,TANV,TWOTHETA,ICASS
C     ..
C
C     XTOFD....  Crystal to detector distance in 10 micron units. Read from
C                keyworded input and never changed.
C
C                Spot positions are calculated in S/R XYSPOT (Called from
C                REEK) and are for an "ideal" detector at a distance of XTOFD.
C                These are converted into pixel positions in S/R MMTOPX
C                which applies the multiplicative factor XTOFRA to allow
C                for refinement of the distance. XTOFRA is the parameter
C                that is actually refined (in RDIST), rather than XTOFD.
C                The refined distance that is printed in the logfile is
C                actually XTOFRA*XTOFD
C
C     ICASS....  Indicates detector type:
C                0     Flat film
C                1     Vee shaped cassettes
C                2     FAST detector (only used in TESTGEN mode of OSCGEN)
C                3     Swung out FAST (ditto)
C                4     IP detector
C     TWOTHETA   Detector swing angle (degrees)
C&&*&& end_include  ../inc/xy.f
C     
C     
C     
C---- Note well the following equivalences: these are to allow for
C     alternative definitions of crystal mosaicity, beam parameters, etc
C
C     ..
C     .. Equivalences ..
      EQUIVALENCE (ETAD,CRYDAT(1))
      EQUIVALENCE (BEMDAT(1),ALAMBD)
      EQUIVALENCE (BEMDAT(2),DELAMBX)
      EQUIVALENCE (BEMDAT(3),DELCORX)
      EQUIVALENCE (BEMDAT(4),DIVHD)
      EQUIVALENCE (BEMDAT(5),DIVVD)
C
C----  Save it
C
        SAVE
C
C     .. Data statements ..
      DATA              ABC/'a*','b*','c*'/
C Rotation axis E1AXIS, X-ray beam S0VEC
      DATA E1AXIS /0.0,0.0,1.0/, S0VEC/-1.0,0.0,0.0/
C Axis name
      DATA AXSLAB /'PHI'/
C     ..
C
      DTOR = ATAN(1.0)*4.0/180.0
C
C
C---- Set word count for /ORIENT/. 
C     positions orientation blocks in output
C     MTZ file, and setup all the orientation block data
C
      NWORDS = MBLENG
      NINTGR = MBLINT
      NREALS = MBLREA
C Orientation block type 0 (only possibility at present)
      IORTYP = 0
C
C---- Set LDTYPE
C
C    = 0  '*** unknown data type ***'
C    = 1  2D spots
C    = 2  3D spots
C    = 3  Laue data
C
      LDTYPE = 1
C
C---- Set default batch scale and B factor (set later by ROTA/AGROVATA)
C
      NBSCAL = 0
      BSCALE = 1.0
      BBFAC = 0.0
      SDBSCL = 0.0
      SDBFAC = 0.0
C
C---- Transfer cell dimensions
C
      DO 10 I = 1,6
        CELLX(I) = CELL(I)
 10   continue
C
C---- Transfer UMAT
C
      DO 14 I = 1,3
        DO 12 J = 1,3
          UMATX(J,I) = UMAT(J,I)
 12     CONTINUE
 14   CONTINUE
C
C---- Transfer missetting angles
      DO 16 I = 1,3
        PHIXYZ(I,1) = DELPHI(I)
 16   CONTINUE
C
C---- Set final missets to equal initial missets for each image
C
      DO 18 I = 1,3
         PHIXYZ(I,2) = PHIXYZ(I,1)
 18   CONTINUE
C
C---- Transfer phi start,end
C
      PHISTTX = PHIBEG
      PHIENDX = PHIEND
C
C---- Transfer mosaic spread, stored internally as half width in radians
C 
      ETAD = 2.0*ETA/DTOR    
C
C---- Transfer horizonatl and vertical beam divergences
C
      DIVHD = 2.0*DIVH/DTOR
      DIVVD = 2.0*DIVV/DTOR
C
C---- Wavelength and dispersion/correlation
C
      ALAMBD = WAVE
      DELAMBX = DELAMB
      DELCORX = DELCOR
C---- Orientation data type 1 stored in orientation block, ie Umat + Phixyz
      MISFLG = 1
C
C---- All beam parameters set 
      LBMFLG = 1
C---- Isotropic mosaicity
      LCRFLG = 0
C
C---- Set crystal goniostat information (assume single axis)
C
      NGONAX = 1
      DO 20, I=1,3
         E1(I) = E1AXIS(I)
         E2(I) = 0.0
         E3(I) = 0.0
         GONLAB(I) = ' '
C Source vector
         SOURCE(I) = S0VEC(I)
C     HRP - I don't think we can do this assignment after I moved S0
C     from ../inc/orient.f to ../inc/reeke.f - 09.05.2003 
C     S0(I) = SOURCE(I)
         SOURCEV(I) = SOURCE(I)
C Datum = 0
         DATUM(I) = 0.0
C Scan axis (dummy)
         SCANAX(I) = 0.0
 20   CONTINUE
C
C---- Transfer JUMPAX
C
      JUMPAXX = JUMPAX
C
C---- Fill padding GONPAD,BEMDAT,DETPAD,BATPAD,INTPAD
C
      DO 22 I = 1,12
        GONPAD(I) = 0.0
        BATPAD(I) = 0.0
 22   CONTINUE
      DO 24 I = 6,25
        BEMDAT(I) = 0.0
 24   CONTINUE
      DO 26 I = 1,33
        DETPAD(I) = 0.0
 26   CONTINUE
      DO 28 I = 1,9
        INTPAD(I) = 0
 28   CONTINUE
C
      GONLAB(1) = AXSLAB
      JSCAXS = 1
C
C---- Set detector parameters
C
C Single detector
      NDET = 1
C Detector distance (mm)
      DX1  = XTOFD*0.01
C Detector swing angle (unknown)
      THETA1 = 0.0
C
C---- Set detector limits. Use the detector pixel coordinates, rather than
C     virtual detector coordinates.
C
      DETLM1(1,1) = 0
      DETLM1(2,1) = NREC
      DETLM1(1,2) = 0
      DETLM1(2,2) = IYLEN
C
C---- Dummy time limits
C
      TIME1 = 0.0
      TIME2 = 0.0
      DX2 = 0.0
      THETA2 = 0.0
      DETLM2(1,1) = 0
      DETLM2(2,1) = NREC
      DETLM2(1,2) = 0
      DETLM2(2,2) = IYLEN
C     
C---- LBcell values
C     
C     
      DO 30 I = 1,6
         LBCELL(I) = LCELL(I)
 30   CONTINUE
C     
      END
C     
C
C $Id: dddn.f,v 1.8 2003/04/30 14:01:41 harry Exp $
C
      SUBROUTINE DDDN(CAMCON, DD, DN)
      IMPLICIT NONE
C
C     Subroutine to prepare matrix DD and vector DN from the camera constants.
C                                  ==            -- 
C
C---- DEBUG(71) this subroutine, keywords DEBUG DDDN
C
C
C---- originally from MADNES (Albrecht Messerschmidt), made into F77 by Jim
C     Pflugrath.
C
C---- CAMCON(1) = CCX     }             { beam error in X (10 micron units)
C           (2) = CCY     } distortions {   "    "    " Y (10 micron units)
C           (3) = crystal to detector distance (10 micron units)
C           (4) = CCOMEGA in degrees about axis // to X (X-ray beam)
C           (5) = TWIST in degrees about "vertical" axis // to Y (~PHI)
C           (6) = TILT in degrees about "horizontal" axis // to Z, _|_ to Y
C                                 and X-ray                              
C           (7) = inclination angle of primary beam
C           (8) = inclination angle of primary beam
C   obsolete - removed  (9) = twotheta // (coaxial) in DEGREES to Y ( ~PHI)
C   obsolete - removed (10) = azimuthal "twotheta" _|_ in DEGREES to Y (~PHI)
C
C---- DD contains the three vectors DX, DY, D0 from MADNES ;
C
C     See MADNES Phase III, Pp49ff (Paul Tucker) & 
C     Pp57ff (Albrecht Messerschmidt)
C
C
C---- The "TAU" matrices are rotations applied to the detector around
C     the laboratory coordinate axes - Tau(1) about X-ray vector, Tau(2)
C     about the lab "vertical" and Tau(3) about the lab "horizontal".
C     Therefore, DD contains the detector rotation.
C     
C                         | d    d    d   |
C                         |  xx   yx   ox |
C                         |               |
C     Arrange matrix dd = | d    d    d   |
C                         |  xy   yy   oy |
C                         |               |
C                         | d    d    d   | 
C                         |  xz   yz   oz |
C
C     d  = TAU3*TAU2*TAU1*DGDV(J, 1)
C      x   ==== ==== ==== ----------              
C
C     d  = TAU3*TAU2*TAU1*DGDV(J, 2)
C      y   ==== ==== ==== ----------              
C
C     d  = TAU3*TAU2*TAU1*DGDS
C      o   ==== ==== ==== ----
C
C     DN is the vector normal to the detector towards the lab coordinate
C     origin
C
C     Explanations of DGDV and DGDA:
C     
C     DGDA(j,i)   (R)   Components 'j' of the detector rotation axes 'i'
C                       DGDA(1:3,1) = omega vector 
C                       DGDA(1:3,2) = kappa/chi vector
C                       DGDA(1:3,3) = phi vector   
C     DGDV(j,i)   (R)   Components 'j' of detector vectors 'i' = dx, dy
C
C        CAMCON(4-6) now are input in degrees.
C
C     ..
C     .. Scalar Arguments ..
      REAL    CAMCON(8), DD(3, 3), DN(3)      
C     ..
C     .. Local Arrays
      REAL P0(3),DGDS(3),TAU321(3, 3), TAU32(3, 3),
     $     DX(3), DY(3),D0(3),DGDA(3,3),DGDV(3,3)
C     ..
C     .. Local Scalars
      REAL       DTOR
      INTEGER I
C      LOGICAL FIRSTTIME
      EXTERNAL CLEAR,GN3CMP,MATCOPF,MATVEC
C&&*&& include  ../inc/debug.f
C
C $Id: debug.f,v 1.1 2002/05/02 10:46:44 harry Exp $
C
C--- awk generated include file  debug.h
C---- START of include file debug.h
C
C
C
C     .. Arrays in common /DEBUG/ ..
      REAL XWARN
      INTEGER NDEBUG,IWARN
      LOGICAL DEBUG,LPRINT,DUMP,WARN
C
C     .. Scalars in common /DEBUG/ ..
      REAL BGRLIM
      INTEGER NDUMP,IDUMP,MXDUMP
      LOGICAL SPOT
C     
C     ..
C     .. Common Block /DEBUG/..
      COMMON /DEBUG/XWARN(20,100),BGRLIM,NDEBUG(80),IWARN(20,100),
     $       NDUMP,IDUMP,MXDUMP,DEBUG(80),LPRINT(20),DUMP(30),
     +       WARN(100),SPOT
C     ..
C
C&&*&& end_include  ../inc/debug.f
C&&*&& include  ../inc/ioo.f
C
C $Id: ioo.f,v 1.6 2004/03/09 11:39:33 harry Exp $
C
C--- awk generated include file  ioo.h
C---- START of include file ioo.h
C
C
C
C     .. Scalars in common block /IOO/ ..
      INTEGER IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,ISUMMR,
     +        ICOORD,SERVERFD,NSHUTERR,dnafd
      LOGICAL ONLINE,ONEFILE,FHEADER,BRIEF,GRAPH,IOERR,
     $        NODISPLAY,LBELL,JPGOUT,SOCKLO,LBEST,dnaout,INMOOPEN
      CHARACTER dna_image*80
C     ..
C     .. Common block /IOO/ ..
c      COMMON /IOO/IOUT,IUNIT,ONLINE,ITIN,ITOUT,INOD,INMO,IDU,NWRN,
c     +            ONEFILE,FHEADER,BRIEF,IBRIEF,GRAPH,ISUMMR,ICOORD,
c     +            IOERR,NODISPLAY,LBELL
C     ..
C
C
      COMMON /IOO/IOUT,IUNIT,ITIN,ITOUT,INOD,INMO,IDU,NWRN,IBRIEF,
     +        ISUMMR,ICOORD,SERVERFD,NSHUTERR,ONLINE,ONEFILE,
     +        FHEADER,BRIEF,GRAPH,IOERR,NODISPLAY,LBELL,JPGOUT,
     $        SOCKLO,LBEST, dnafd, dnaout,INMOOPEN
      COMMON /CIOO/dna_image

C&&*&& end_include  ../inc/ioo.f
C     ..
      DTOR = ATAN(1.0)/45.0
      IF(DEBUG(71))THEN
        WRITE(IOUT,FMT=6000)CAMCON
        IF(ONLINE)WRITE(ITOUT,FMT=6000)CAMCON
      ENDIF
C
C     Assign values to DGDS and P0
C                      ----     --
      CALL CLEAR(DGDS)
      DGDS(1) =  CAMCON(3)     !
      DGDS(2) =  CAMCON(2)     ! this is t1 on P57 of MADNES Phase III
      DGDS(3) =  CAMCON(1)     !
C
      P0(1) =  CAMCON(3)
      P0(2) =  0.0
      P0(3) =  0.0
c
c---- values for dgda obtained from Phil's madnes source and adapted for 
C     Mosflm axes
c
      CALL CLEAR(DGDA)
C
C---- Omega
C
      DGDA(2,1) =  1.0 
C
C---- Chi/kappa ahpk_2.su
C
      DGDA(1,2) =  1.0
C
C---- Phi?
C
      DGDA(3,3) =  1.0 

      CALL CLEAR(DGDV)
      DGDV(1,1) =  0.0  !  P0 (0,0,D0) - P0 (0,0,D0)
      DGDV(2,2) =  1.0  !  PY (0,1,D0) - P0 (0,0,D0)
      DGDV(3,1) =  1.0  !  PX (1,0,D0) - P0 (0,0,D0) 
      IF(DEBUG(71))THEN
        WRITE(IOUT,FMT=6010)P0,DGDS,DGDA,DGDV
        IF(ONLINE)WRITE(ITOUT,FMT=6010)P0,DGDS,DGDA,DGDV
      ENDIF
C
C     Calculate rotation matrix TAU321 for the resultant
C     rotation about the rotation axes of the detector
C     goniostat and rotation/translation matrix TAU32 for the 
C     determination of DN
C                      --
      CALL GN3CMP(CAMCON(6)*DTOR, CAMCON(5)*DTOR, 
     *     0.0,DGDA(1, 1), DGDA(1, 3), DGDA(1, 2),
     *     0, 0, TAU321)
C
c In this implementation tau321 = tau32
      CALL MATCOPF(TAU32,TAU321,3,3)
C
      CALL MATVEC(DX,TAU321,DGDV(1,1))
      CALL MATVEC(DY,TAU321,DGDV(1,2))
      CALL MATVEC(DN,TAU32,P0)
      CALL MATVEC(D0,TAU321,DGDS)
C
      DO 320 I = 1, 3
         DD(I,1) = DX(I)
         DD(I,2) = DY(I)
         DD(I,3) = D0(I)
320   CONTINUE
C
      RETURN
C
C---- FORMAT STATEMENTS
C
 6000 FORMAT(' Camera constants: ',/,2F7.2,F10.1,5F7.2,/)
 6010 FORMAT(' Vectors generated:',/,20X,'P0:   ',3(F10.3,1X),/,
     $     20X,'DGDS: ',3(F10.3,1X),/,13X,'Matrix DGDA: ',3(F8.3,1X),/,
     $     2(26X,3(F8.3,1X),/),/,13X,'Matrix DGDV: ',3(F8.3,1