#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "../util/util.h"

/* fortran_cell_(float *a): This routine allows FORTRAN program to use DPS routines to
                    to get cell from UB matrix.
*/

float fortran_ub_(float *a, float *b)  

{
  struct matrix_3x3 om;
  struct matrix_3x3 B, U, invB;
    om.r[0].x = a[0];
    om.r[0].y = a[1];
    om.r[0].z = a[2];
    om.r[1].x = a[3];
    om.r[1].y = a[4];
    om.r[1].z = a[5];
    om.r[2].x = a[6];
    om.r[2].y = a[7];
    om.r[2].z = a[8];
    B_and_U_from_om(om, &B, &U);
    print_3x3(B);
    printf("\n");
    print_3x3(U);
    printf("\n");
    mat_mul_3x3(U, B, &om);
    b[0] = om.r[0].x;
    b[1] = om.r[0].y;
    b[2] = om.r[0].z;
    b[3] = om.r[1].x;
    b[4] = om.r[1].y;
    b[5] = om.r[1].z;
    b[6] = om.r[2].x;
    b[7] = om.r[2].y;
    b[8] = om.r[2].z;

}


