/***********************************************************************
 * 
 * marView: colors
 *
 * Copyright by:	Dr. Claudio Klein
 * 			X-ray Research GmbH, Hamburg
 *
 * Version: 	4.0.1
 * Date:	28/09/1998
 *
 ***********************************************************************/

/*
 * MOTIF and X include files needed for widget
 * creation and toolkit initialization.
 */
#include <Xm/Xm.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include <math.h>

#ifdef __ALPHA
#include <stdlib.h>
#endif

#include "marview.h"

XColor		grey;

/*
 * External declarations
 */
extern Display 	*dpy;
extern long 	white, black, color1, color2, color3, color4;
extern int 	screen;
extern int	input_colors;
extern char	dyn_colors;
extern Colormap cmap;

/*
 * Function prototypes
 */
int 		InitColormap	(XColor *, int, unsigned long *);
void		GetColors	(XColor *, int, unsigned long *, int, int); 

/******************************************************************
 * Function: InitColormap = initialize colormap
 ******************************************************************/
int 
InitColormap(XColor *xcolors, int ncolors, unsigned long *colors)
{
int 		MIN_NCOLORS=7, MAX_NCOLORS=input_colors+6;
int		i,j,inc;
unsigned long 	plane_masks[24];
extern int	depth;
int 		nplanes=0;
unsigned long 	ppix[4];


	/* Initialize the colormap for RW colors (PseudoColors only)*/
	if ( depth == 8 ) {
	    if (XAllocColorCells(dpy,cmap,False,plane_masks,nplanes,ppix,4)==0) {
		fprintf(stdout,"Error allocating colors for colormap\n");
		exit(-1);
	    }
	}
	else {
		dyn_colors = 0;
	}

	if (ncolors > NCOLOR)
		ncolors = NCOLOR;

	if ( dyn_colors ) {
		if ( ncolors != 0) {
			ncolors += 6;
			if (XAllocColorCells(dpy,cmap,False,plane_masks,nplanes,colors,ncolors)==0){
				MAX_NCOLORS = ncolors;
				ncolors = 0;
			}
		}

		if (ncolors == 0) {
			ncolors = (MAX_NCOLORS>32)?32:MAX_NCOLORS;

			while (1) {
				if (XAllocColorCells(dpy,cmap,False,plane_masks,nplanes,colors,ncolors)==0){
					MAX_NCOLORS = ncolors;
				}
				else {
					MIN_NCOLORS = ncolors;
					XFreeColors(dpy,cmap,colors,ncolors,(unsigned long)nplanes);
				}
				ncolors = (MIN_NCOLORS + MAX_NCOLORS + 1) / 2;
				if ((ncolors == MAX_NCOLORS) || (ncolors == MIN_NCOLORS)) {
					ncolors = MIN_NCOLORS;
					break;
				}
			}
			fprintf(stdout,"marView: %d colors allocated\n",ncolors);
		
			if (XAllocColorCells(dpy,cmap,False,plane_masks,nplanes,colors,ncolors)==0){
				fprintf(stdout,"marView: Could not allocate %d colors\n",ncolors); fflush(stdout);
				return (0);
			}
		}
	}
	else 
		ncolors = MAX_NCOLORS;

	ncolors -= 6; /* Save last 6 colors for black,white,red,green,blue,orange */

	/* Setup pure colors: only done once */

	/* Black */
	xcolors[ncolors].red = 0;
	xcolors[ncolors].green = 0;
	xcolors[ncolors].blue = 0;
	xcolors[ncolors].flags = DoRed | DoGreen | DoBlue;
	if ( dyn_colors ) {
		xcolors[ncolors].pixel = colors[ncolors];
		black = colors[ncolors];
	}
	else {
		grey.red = grey.green = grey.blue = xcolors[ncolors].red;
		XAllocColor( dpy, cmap, &grey);
		black = colors[ncolors] = grey.pixel;
	}

	/* White */
	xcolors[ncolors+1].red = 65535;
	xcolors[ncolors+1].green = 65535;
	xcolors[ncolors+1].blue = 65535;
	xcolors[ncolors+1].flags = DoRed | DoGreen | DoBlue;
	if ( dyn_colors ) {
		xcolors[ncolors+1].pixel = colors[ncolors+1];
		white = colors[ncolors+1];
	}
	else {
		grey.red = grey.green = grey.blue = xcolors[ncolors+1].red;
		XAllocColor( dpy, cmap, &grey);
		white = colors[ncolors+1] = grey.pixel;
	}

	/* color1 = red */
	xcolors[ncolors+2].red = 65535;
	xcolors[ncolors+2].green = 0;
	xcolors[ncolors+2].blue = 0;
	xcolors[ncolors+2].flags = DoRed | DoGreen | DoBlue;
	if ( dyn_colors ) {
		xcolors[ncolors+2].pixel = colors[ncolors+2];
		color1 = colors[ncolors+2];
	}
	else {
		grey.red = 65535;
		grey.blue = grey.green = 0;
		XAllocColor( dpy, cmap, &grey);
		color1 = colors[ncolors+2] = grey.pixel;
	}

	/* color2 = green */
	xcolors[ncolors+3].red = 0;
	xcolors[ncolors+3].green = 42405;
	xcolors[ncolors+3].blue = 0;
	xcolors[ncolors+3].flags = DoRed | DoGreen | DoBlue;
	if ( dyn_colors ) {
		xcolors[ncolors+3].pixel = colors[ncolors+3];
		color2 = colors[ncolors+3];
	}
	else {
		grey.green = 65535;
		grey.red = grey.blue= 0;
		XAllocColor( dpy, cmap, &grey);
		color2 = colors[ncolors+3] = grey.pixel;
	}

	/* color3 = blue */
	xcolors[ncolors+4].red = 0;
	xcolors[ncolors+4].green = 0;
	xcolors[ncolors+4].blue = 65535;
	xcolors[ncolors+4].flags = DoRed | DoGreen | DoBlue;
	if ( dyn_colors ) {
		xcolors[ncolors+4].pixel = colors[ncolors+4];
		color3 = colors[ncolors+4];
	}
	else {
		grey.blue = 65535;
		grey.red = grey.green = 0;
		XAllocColor( dpy, cmap, &grey);
		color3 = colors[ncolors+4] = grey.pixel;
	}

	/* color4 = orange */
	xcolors[ncolors+5].red   = 65535;
	xcolors[ncolors+5].green = 42405;
	xcolors[ncolors+5].blue  = 0;
	xcolors[ncolors+5].flags = DoRed | DoGreen | DoBlue;
	if ( dyn_colors ) {
		xcolors[ncolors+5].pixel = colors[ncolors+5];
		color4 = colors[ncolors+5];
	}
	else {
		grey.blue = 65535;
		grey.red = grey.green = 0;
		XAllocColor( dpy, cmap, &grey);
		color4 = colors[ncolors+5] = grey.pixel;
	}
	return (ncolors);
}

/******************************************************************
 * Function: GetColors = sets up colors 
 ******************************************************************/
void
GetColors(XColor *xcolors, int ncolors, unsigned long *colors, 
          int depth, int choice)
{
static char	used=0;
int 		i,j;
short int 	stmp;
extern char   	invert_colors;

	/* Free colors, when switching between grey, blue and rainbow */
	if ( dyn_colors == 0 && used == 1 ) {
		XFreeColors( dpy, cmap, colors, ncolors, 0); 
	}
	used = 1;

	switch ( choice ) {

	case 0:				/* Gray scale */
	case 3:				/* Gray scale */
		for(i=0;i<ncolors;i++) {
			if ( invert_colors ) 
				stmp= (unsigned short)(i*65535/(ncolors-1) );
			else
				stmp= (unsigned short)(65535 - i*65535/(ncolors-1) );
	    		xcolors[i].red = xcolors[i].green = xcolors[i].blue = stmp;
			xcolors[i].flags = DoRed | DoGreen | DoBlue;
			if ( dyn_colors ) 
				xcolors[i].pixel = colors[i];
			else {
				grey.red = xcolors[i].red;
				grey.blue = xcolors[i].blue;
				grey.green = xcolors[i].green;
				if ( XAllocColor( dpy, cmap, &grey) == 0 ){
					printf("marView: Cannot alloc color %d %d %d\n",
					grey.red , grey.green, grey.blue);
				}
				colors[i] = grey.pixel;
			}
		}

		if ( invert_colors )
			xcolors[ncolors-1].red = xcolors[ncolors-1].green = xcolors[ncolors-1].blue = 65535;
		else
			xcolors[ncolors-1].red = xcolors[ncolors-1].green = xcolors[ncolors-1].blue = 0;

		/* Gray + Red: set maximum color to red */
		if ( choice == 3 ) {
			xcolors[ncolors-1].red   = 65535;
			xcolors[ncolors-1].green = 0;
			xcolors[ncolors-1].blue  = 65535;
			xcolors[ncolors-1].flags = DoRed | DoGreen | DoBlue;
			if ( dyn_colors ) 
				xcolors[ncolors-1].pixel = colors[ncolors-1];
			else {
				grey.red = xcolors[ncolors-1].red;
				grey.blue = xcolors[ncolors-1].blue;
				grey.green = xcolors[ncolors-1].green;
				if ( XAllocColor( dpy, cmap, &grey) == 0 ){
					printf("marView: Cannot alloc color %d %d %d\n",
					grey.red , grey.green, grey.blue);
				}
				colors[ncolors-1] = grey.pixel;
			}
		}

		break;


	case 1:				/* Blue scale */
		for(i=0;i<ncolors;i++) {
		    if (invert_colors ) {
			/* Black ==> Blue */
			if (i<ncolors*1/3) {
				xcolors[i].red   = 65535 - i*65535/(ncolors/3);
				xcolors[i].green = 65535;
				xcolors[i].blue  = 65535;
			}
			/* Blue ==> Cyan */
			else if (i>=ncolors*1/3 && i<ncolors*2/3 ) {
				xcolors[i].red   = 0; 
				xcolors[i].green = 65535-(i-ncolors/3)*65535/(ncolors/3);
				xcolors[i].blue  = 65535;
			}
			else if (i>=ncolors*2/3 ) {
				xcolors[i].red   = 0; 
				xcolors[i].green = 0;
				xcolors[i].blue  = 65535-(i-ncolors*2/3)*65535/(ncolors/3);
			}
		    }

		    /* Normal colors ... */
		    else {
			/* Black ==> Blue */
			if (i<ncolors*1/3) {
				xcolors[i].red   = 0; 
				xcolors[i].green = 0;
				xcolors[i].blue  = i*65535/(ncolors/3);
			}
			/* Blue ==> Cyan */
			else if (i>=ncolors*1/3 && i<ncolors*2/3 ) {
				xcolors[i].red   = 0; 
				xcolors[i].green = (i-ncolors/3)*65535/(ncolors/3);
				xcolors[i].blue  = 65535;
			}
			else if (i>=ncolors*2/3 ) {
				xcolors[i].red   = (i-ncolors*2/3)*65535/(ncolors/3);
				xcolors[i].green = 65535;
				xcolors[i].blue  = 65535;
			}
		    }

		    xcolors[i].flags = DoRed | DoGreen | DoBlue;
		    if ( dyn_colors ) 
			xcolors[i].pixel = colors[i];
		    else {
			grey.red = xcolors[i].red;
			grey.blue = xcolors[i].blue;
			grey.green = xcolors[i].green;
			if ( XAllocColor( dpy, cmap, &grey) == 0 ){
				printf("marView: Cannot alloc color %d %d %d\n",
				grey.red , grey.green, grey.blue);
			}
			colors[i] = grey.pixel;
		   }

		}

		if ( invert_colors ) {
			xcolors[ncolors-1].red   = 65535; 
			xcolors[ncolors-1].green = xcolors[ncolors-1].blue = 0;
		}
		else {
			xcolors[ncolors-1].red = xcolors[ncolors-1].green = xcolors[ncolors-1].blue = 65535;
		}
		break;


	case 2:				/* Rainbow */
		for(j=0;j<ncolors;j++) {
			i = j;
			if ( invert_colors ) i = ncolors-j-1;
			/* White ==> Yellow */
			if (j<ncolors*1/5) {
				xcolors[i].red   = 65535; 
				xcolors[i].green = 65535;
				xcolors[i].blue  = 65535 - i*65535/(ncolors*1/5);
			}
			/* Yellow ==> Green */
			else if (j>=ncolors/5 && j<ncolors*3/10) {
				xcolors[i].red   = 65535 - (i-ncolors/5)*65535/(ncolors/10);
				xcolors[i].green = 65535;
				xcolors[i].blue  = 0; 
			}
			/* Green  ==> Cyan  */
			else if (j>=ncolors*3/10 && j<ncolors*2/5) {
				xcolors[i].red   = 0; 
				xcolors[i].green = 65535;
				xcolors[i].blue  = (i-ncolors*3/10)*65535/(ncolors/10);
			}
			/* Cyan   ==> Blue  */
			else if (j>=ncolors*2/5 && j<ncolors*3/5) {
				xcolors[i].red   = 0; 
				xcolors[i].green = 65535 - (i-ncolors*2/5)*65535/(ncolors/5);
				xcolors[i].blue  = 65535;
			}
			/* Blue   ==> Navy */
			else if (j>=ncolors*6/10 && j<ncolors*7/10) {
				xcolors[i].red   = 0; 
				xcolors[i].green = 0;
				xcolors[i].blue  = 65535 - (i-ncolors*3/5)*(32767)/(ncolors/9 );
			}
			/* Navy ==> Purple */
			else if (j>=ncolors*7/10 && j<ncolors*9/10) {
				xcolors[i].red   = (i-ncolors*7/10)*32767/(ncolors/5);
				xcolors[i].green = 0;
				xcolors[i].blue  = 32767;
			}
			/* Purple ==> Red   */
			else if (j>=ncolors*9/10) {
				xcolors[i].blue  = 65535/2-(i-ncolors*9/10)*32767/(ncolors/10); 
				xcolors[i].green = 0;
				xcolors[i].red   = 65535/2+(i-ncolors*9/10)*32767/(ncolors/10);
			}
			xcolors[i].flags = DoRed | DoGreen | DoBlue;
			if ( dyn_colors ) 
				xcolors[i].pixel = colors[i];
			else {
				grey.red = xcolors[i].red;
				grey.blue = xcolors[i].blue;
				grey.green = xcolors[i].green;
				if ( XAllocColor( dpy, cmap, &grey) == 0 ){
					printf("marView: Cannot alloc color %d %d %d\n",
					grey.red , grey.green, grey.blue);
				}
				colors[i] = grey.pixel;
			}
		}
		break;

	default:
		break;
	}

}
