/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.util.StringTokenizer;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Union;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class UnionUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller _unmarshaller;
    private int _depth = 0;
    private Union _union = null;
    private Schema _schema = null;
    private boolean _foundAnnotation = false;
    private boolean _foundSimpleType = false;

    public UnionUnmarshaller(Schema schema, AttributeList attributeList) throws SAXException {
        if (schema == null) {
            String string = "'schema' must not be null.";
            throw new IllegalStateException(string);
        }
        this._schema = schema;
        this._union = new Union(this._schema);
        this._union.setId(attributeList.getValue("id"));
        String string = attributeList.getValue("memberTypes");
        this.processMemberTypes(string);
    }

    public String elementName() {
        return "union";
    }

    public Object getObject() {
        return this._union;
    }

    public void finish() throws SAXException {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this._unmarshaller != null) {
            this._unmarshaller.startElement(string, attributeList);
            ++this._depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this._foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of '" + this.elementName() + "'.");
            }
            if (this._foundSimpleType) {
                this.error("An annotation may only appear as the first child of '" + this.elementName() + "'.");
            }
            this._foundAnnotation = true;
            this._unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if ("simpleType".equals(string)) {
            this._foundSimpleType = true;
            this._unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeList);
        } else {
            this.illegalElement(string);
        }
    }

    public void endElement(String string) throws SAXException {
        if (this._unmarshaller != null && this._depth > 0) {
            this._unmarshaller.endElement(string);
            --this._depth;
            return;
        }
        this._unmarshaller.finish();
        if ("annotation".equals(string)) {
            this._union.setLocalAnnotation((Annotation)this._unmarshaller.getObject());
        } else if ("simpleType".equals(string)) {
            SimpleType simpleType = (SimpleType)this._unmarshaller.getObject();
            if (simpleType instanceof Union) {
                String string2 = "A 'union' may only contain SimpleTypes of the atomic or list variety.";
                this.error(string2);
            }
            this._union.addMemberType(simpleType);
        }
        this._unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._unmarshaller != null) {
            this._unmarshaller.characters(cArray, n, n2);
        }
    }

    private void processMemberTypes(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            SimpleType simpleType = this._schema.getSimpleType(string2);
            if (simpleType != null) {
                this._union.addMemberType(simpleType);
                continue;
            }
            this._union.addMemberType(string2);
        }
    }
}

