/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.exolab.castor.xml.schema.simpletypes.ListType;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class SimpleTypeListUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private ListType _list = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;
    private boolean foundItemType = false;

    SimpleTypeListUnmarshaller(Schema schema, AttributeList attributeList) throws SAXException {
        this._schema = schema;
        this._list = new ListType(schema);
        String string = attributeList.getValue("itemType");
        if (string != null && string.length() > 0) {
            this.foundItemType = true;
            XMLType xMLType = this._schema.getType(string);
            if (xMLType == null) {
                this._list.setItemType(string);
            } else {
                if (xMLType.getStructureType() == 6) {
                    String string2 = "The item type of a list cannot be a complexType.";
                    throw new IllegalStateException(string2);
                }
                this._list.setItemType((SimpleType)xMLType);
            }
        }
        this._list.setId(attributeList.getValue("id"));
    }

    public String elementName() {
        return "list";
    }

    public void finish() throws SAXException {
        if (!this.foundItemType && !this.foundSimpleType) {
            String string = "Missing sub-component of <list>, either use  the 'itemType' attribute, or an anonymous simpleType.";
            this.error(string);
        }
    }

    public Object getObject() {
        if (!this.foundItemType && !this.foundSimpleType) {
            String string = "Missing sub-component of <list>, either use  the 'itemType' attribute, or an anonymous simpleType.";
            throw new IllegalStateException(string);
        }
        return this._list;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if (string.equals("annotation")) {
            if (this.foundSimpleType) {
                this.error("An annotation must appear as the first child of 'list' elements.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'list' elements.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if ("simpleType".equals(string)) {
            if (this.foundItemType) {
                this.error("A 'list' element can have either an 'itemType' or  'simpleType'.");
            }
            if (this.foundSimpleType) {
                this.error("Only one (1) 'simpleType' may appear as a child of 'list' elements.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeList);
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._list.setLocalAnnotation(annotation);
        } else if ("simpleType".equals(string)) {
            SimpleType simpleType = (SimpleType)this.unmarshaller.getObject();
            this._list.setItemType(simpleType);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

