/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.util.Hashtable;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.ScopableResolver;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComplexTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ElementUnmarshaller;
import org.exolab.castor.xml.schema.reader.ImportUnmarshaller;
import org.exolab.castor.xml.schema.reader.IncludeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.UnknownUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class SchemaUnmarshaller
extends SaxUnmarshaller {
    public static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String[] UNSUPPORTED_NAMESPACES = new String[]{"http://www.w3.org/2000/10/XMLSchema", "http://www.w3.org/1999/XMLSchema"};
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_PREFIX = "xmlns:";
    private boolean _include = false;
    private SaxUnmarshaller unmarshaller;
    private int _annotationDepth = 0;
    private int depth = 0;
    boolean skipAll = false;
    Resolver _resolver = null;
    Schema _schema = new Schema();
    private boolean foundSchemaDef = false;
    private String defaultNS = null;
    private Hashtable namespaces = null;
    private SchemaUnmarshallerState _state = null;

    public SchemaUnmarshaller() throws SAXException {
        this(null, null);
        this.foundSchemaDef = false;
    }

    public SchemaUnmarshaller(SchemaUnmarshallerState schemaUnmarshallerState) throws SAXException {
        this(null, null);
        this._state = schemaUnmarshallerState;
        this.foundSchemaDef = false;
    }

    public SchemaUnmarshaller(boolean bl, SchemaUnmarshallerState schemaUnmarshallerState) throws SAXException {
        this();
        this._state = schemaUnmarshallerState;
        this._include = bl;
        this.foundSchemaDef = false;
    }

    public SchemaUnmarshaller(AttributeList attributeList, Resolver resolver) throws SAXException {
        this.setResolver(resolver);
        this.foundSchemaDef = true;
        this.namespaces = new Hashtable();
        this._state = new SchemaUnmarshallerState();
        this.init(attributeList);
    }

    public Schema getSchema() {
        return this._schema;
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }

    public Object getObject() {
        return this.getSchema();
    }

    public String elementName() {
        return "schema";
    }

    private void init(AttributeList attributeList) throws SAXException {
        if (attributeList == null) {
            return;
        }
        String string = null;
        String string2 = attributeList.getValue("targetNamespace");
        if (string2 != null && string2.length() == 0) {
            throw new SAXException("empty string is not a legal namespace.");
        }
        if (string2 != null && string2.length() > 0) {
            if (this._include && !this._schema.getTargetNamespace().equals(string2)) {
                throw new SAXException("The target namespace of the included components must be the same as the target namespace of the including schema");
            }
            this._schema.setTargetNamespace(string2);
        }
        this._schema.setId(attributeList.getValue("id"));
        this._schema.setVersion(attributeList.getValue("version"));
        this._schema.setSchemaLocation(this.getDocumentLocator().getSystemId());
        String string3 = attributeList.getValue("attributeFormDefault");
        if (string3 != null) {
            this._schema.setAttributeFormDefault(Form.valueOf(string3));
        }
        if ((string3 = attributeList.getValue("elementFormDefault")) != null) {
            this._schema.setElementFormDefault(Form.valueOf(string3));
        }
        if ((string = attributeList.getValue("blockDefault")) != null) {
            this._schema.setBlockDefault(string);
        }
        if ((string = attributeList.getValue("finalDefault")) != null) {
            this._schema.setFinalDefault(string);
        }
        if ((string = attributeList.getValue("version")) != null) {
            this._schema.setVersion(string);
        }
    }

    private void handleXMLNS(String string, String string2) throws SAXException {
        if (string == null || !string.startsWith(XMLNS)) {
            throw new IllegalArgumentException(string + " is not a namespace attribute.");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("error null or empty namespace value");
        }
        if (string.equals(XMLNS)) {
            this.defaultNS = string2;
            this._schema.addNamespace("", this.defaultNS);
            return;
        }
        String string3 = string.substring(XMLNS_PREFIX.length());
        this.namespaces.put(string3, string2);
        int n = 0;
        while (n < UNSUPPORTED_NAMESPACES.length) {
            if (string2.equals(UNSUPPORTED_NAMESPACES[n])) {
                this.error("The following namespace \"" + string2 + "\" is no longer supported. Please update to " + " W3C XML Schema Recommendation.");
            }
            ++n;
        }
        this._schema.addNamespace(string3, string2);
    }

    private void processNamespaces(AttributeList attributeList) throws SAXException {
        if (attributeList == null) {
            return;
        }
        int n = 0;
        while (n < attributeList.getLength()) {
            String string = attributeList.getName(n);
            if (string.equals(XMLNS) || string.startsWith(XMLNS_PREFIX)) {
                this.handleXMLNS(string, attributeList.getValue(n));
            }
            ++n;
        }
    }

    public void setResolver(Resolver resolver) {
        if (resolver == null) {
            resolver = new ScopableResolver();
        }
        super.setResolver(resolver);
        this._resolver = resolver;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.skipAll) {
            return;
        }
        String string2 = string;
        this.processNamespaces(attributeList);
        String string3 = null;
        int n = string.indexOf(58);
        if (n >= 0) {
            String string4 = string.substring(0, n);
            string = string.substring(n + 1);
            string3 = (String)this.namespaces.get(string4);
        } else {
            string3 = this.defaultNS;
        }
        if (!this.foundSchemaDef && n < 0 && this.defaultNS == null) {
            this.defaultNS = XSD_NAMESPACE;
            string3 = XSD_NAMESPACE;
            System.out.println("No namespace declaration has been found for " + string);
            System.out.print("   * assuming default namespace of ");
            System.out.println(XSD_NAMESPACE);
        }
        if (string.equals("annotation")) {
            ++this._annotationDepth;
        }
        if (!XSD_NAMESPACE.equals(string3) && this._annotationDepth == 0) {
            this.error("'" + string2 + "' has not been declared in the XML " + "Schema namespace.");
        }
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if (string.equals("schema")) {
            if (this.foundSchemaDef) {
                this.illegalElement(string);
            }
            this.foundSchemaDef = true;
            this.init(attributeList);
            return;
        }
        if (string.equals("annotation")) {
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if (string.equals("attribute")) {
            this.unmarshaller = new AttributeUnmarshaller(this._schema, attributeList, this.getResolver());
        } else if (string.equals("attributeGroup")) {
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, attributeList);
        } else if (string.equals("complexType")) {
            this.unmarshaller = new ComplexTypeUnmarshaller(this._schema, attributeList, this._resolver);
        } else if (string.equals("element")) {
            this.unmarshaller = new ElementUnmarshaller(this._schema, attributeList, this._resolver);
        } else if (string.equals("simpleType")) {
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeList);
        } else if (string.equals("group")) {
            this.unmarshaller = new ModelGroupUnmarshaller(this._schema, attributeList, this._resolver);
        } else if (string.equals("include")) {
            this.unmarshaller = new IncludeUnmarshaller(this._schema, attributeList, this._resolver, this.getDocumentLocator(), this._state);
        } else if (string.equals("import")) {
            this.unmarshaller = new ImportUnmarshaller(this._schema, attributeList, this._resolver, this.getDocumentLocator(), this._state);
        } else {
            System.out.print('<');
            System.out.print(string);
            System.out.print("> elements are either currently unsupported ");
            System.out.println("or non-valid schema elements.");
            this.unmarshaller = new UnknownUnmarshaller(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String string) throws SAXException {
        Object object;
        if (this.skipAll) {
            return;
        }
        String string2 = null;
        int n = string.indexOf(58);
        if (n >= 0) {
            object = string.substring(0, n);
            string = string.substring(n + 1);
            string2 = (String)this.namespaces.get(object);
        } else {
            string2 = this.defaultNS;
        }
        if (string.equals("annotation")) {
            --this._annotationDepth;
        }
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        if ((string = string.intern()) == "schema") {
            return;
        }
        if (this.unmarshaller != null) {
            if (!string.equals(this.unmarshaller.elementName())) {
                object = "error: missing end element for ";
                object = (String)object + this.unmarshaller.elementName();
                throw new SAXException((String)object);
            }
        } else {
            object = "error: missing start element for " + string;
            throw new SAXException((String)object);
        }
        this.unmarshaller.finish();
        if (string.equals("annotation")) {
            this._schema.addAnnotation((Annotation)this.unmarshaller.getObject());
        } else if (string.equals("attribute")) {
            this._schema.addAttribute((AttributeDecl)this.unmarshaller.getObject());
        } else if (string.equals("attributeGroup")) {
            object = this.unmarshaller.getObject();
            try {
                this._schema.addAttributeGroup((AttributeGroupDecl)object);
            }
            catch (ClassCastException classCastException) {
                String string3 = "Top-level AttributeGroups must be defining AttributeGroups and not referring AttributeGroups.";
                this.error(string3);
            }
        } else if (string.equals("complexType")) {
            object = null;
            object = ((ComplexTypeUnmarshaller)this.unmarshaller).getComplexType();
            this._schema.addComplexType((ComplexType)object);
            if (((XMLType)object).getName() != null) {
                this._resolver.addResolvable(((ComplexType)object).getReferenceId(), (Referable)object);
            } else {
                System.out.println("warning: top-level complexType with no name.");
            }
        } else if (string.equals("simpleType")) {
            object = null;
            object = ((SimpleTypeUnmarshaller)this.unmarshaller).getSimpleType();
            this._schema.addSimpleType((SimpleType)object);
            this._resolver.addResolvable(((SimpleType)object).getReferenceId(), (Referable)object);
        } else if (string.equals("element")) {
            object = null;
            object = ((ElementUnmarshaller)this.unmarshaller).getElement();
            this._schema.addElementDecl((ElementDecl)object);
        } else if (string.equals("group")) {
            object = null;
            object = ((ModelGroupUnmarshaller)this.unmarshaller).getGroup();
            this._schema.addModelGroup((ModelGroup)object);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }
}

