/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.PathServices;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.AttributeList;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class IncludeUnmarshaller
extends SaxUnmarshaller {
    public IncludeUnmarshaller(Schema schema, AttributeList attributeList, Resolver resolver, Locator locator) throws SAXException {
        this(schema, attributeList, resolver, locator, null);
    }

    public IncludeUnmarshaller(Schema schema, AttributeList attributeList, Resolver resolver, Locator locator, SchemaUnmarshallerState schemaUnmarshallerState) throws SAXException {
        this.setResolver(resolver);
        String string = attributeList.getValue("schemaLocation");
        if (string == null) {
            throw new SAXException("'schemaLocation' attribute missing on 'include'");
        }
        if (string.indexOf("\\") != -1) {
            String string2 = string + " is not a valid URI as defined by IETF RFC 2396.";
            string2 = string2 + "The URI mustn't contain '\\'.";
            throw new SAXException(string2);
        }
        if (schemaUnmarshallerState.processed(string = PathServices.makeAbsolute(string, locator.getSystemId()))) {
            return;
        }
        schemaUnmarshallerState.markAsProcessed(string, schema);
        schema.addInclude(string);
        Parser parser = null;
        try {
            parser = Configuration.getParser();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (parser == null) {
            throw new SAXException("Error failed to create parser for include");
        }
        SchemaUnmarshaller schemaUnmarshaller = new SchemaUnmarshaller(true, schemaUnmarshallerState);
        schemaUnmarshaller.setSchema(schema);
        parser.setDocumentHandler(schemaUnmarshaller);
        parser.setErrorHandler(schemaUnmarshaller);
        try {
            parser.parse(new InputSource(string));
        }
        catch (IOException iOException) {
            throw new SAXException("Error reading include file '" + string + "'");
        }
    }

    public String elementName() {
        return "include";
    }

    public Object getObject() {
        return null;
    }
}

