/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.PathServices;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.AttributeList;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class ImportUnmarshaller
extends SaxUnmarshaller {
    private static final String HTTP_PROTOCOL = "http://";
    private static final String FILE_PROTOCOL = "file://";

    public ImportUnmarshaller(Schema schema, AttributeList attributeList, Resolver resolver, Locator locator) throws SAXException {
        this(schema, attributeList, resolver, locator, null);
    }

    public ImportUnmarshaller(Schema schema, AttributeList attributeList, Resolver resolver, Locator locator, SchemaUnmarshallerState schemaUnmarshallerState) throws SAXException {
        this.setResolver(resolver);
        String string = attributeList.getValue("schemaLocation");
        if (string == null) {
            throw new SAXException("'schemaLocation' attribute missing on 'import'");
        }
        if (string.indexOf("\\") != -1) {
            String string2 = string + " is not a valid URI as defined by IETF RFC 2396.";
            string2 = string2 + "The URI mustn't contain '\\'.";
            throw new SAXException(string2);
        }
        string = PathServices.makeAbsolute(string, locator.getSystemId());
        String string3 = attributeList.getValue("namespace");
        if (string3 == null) {
            throw new SAXException("'namespace' attribute missing on 'import'");
        }
        if (!schema.isKnownNamespace(string3)) {
            throw new SAXException("namespace '" + string3 + "' not declared in schema");
        }
        if (string3.equals(schema.getTargetNamespace())) {
            throw new SAXException("the 'namespace' attribute in the <import> element cannot be the same of the targetNamespace of the global schema");
        }
        boolean bl = false;
        Schema schema2 = schema.getImportedSchema(string3);
        if (schemaUnmarshallerState.processed(string)) {
            if (schema2 == null) {
                schema.addImportedSchema(schemaUnmarshallerState.getSchema(string));
            }
            return;
        }
        if (schema2 == null) {
            schema2 = new Schema();
            bl = true;
        }
        schemaUnmarshallerState.markAsProcessed(string, schema2);
        Parser parser = null;
        try {
            parser = Configuration.getParser();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (parser == null) {
            throw new SAXException("Error failed to create parser for import");
        }
        SchemaUnmarshaller schemaUnmarshaller = new SchemaUnmarshaller(schemaUnmarshallerState);
        schemaUnmarshaller.setSchema(schema2);
        parser.setDocumentHandler(schemaUnmarshaller);
        parser.setErrorHandler(schemaUnmarshaller);
        try {
            parser.parse(new InputSource(string));
        }
        catch (IOException iOException) {
            throw new SAXException("Error reading import file '" + string + "': " + iOException);
        }
        if (bl) {
            schema2.setSchemaLocation(string);
            schema.addImportedSchema(schema2);
        }
    }

    public String elementName() {
        return "import";
    }

    public Object getObject() {
        return null;
    }
}

