/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentModelGroupImpl;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;

public class Group
extends Particle
implements ContentModelGroup,
Referable {
    private ContentModelGroup _contentModel = null;
    private String name = null;
    private boolean export = false;
    private Order order = Order.seq;
    private String _id = null;
    private boolean _isModelGroupDefinition = false;
    private Structure _parent = null;

    public Group() {
        this(null);
    }

    public Group(String string) {
        this.name = string;
        this._contentModel = new ContentModelGroupImpl();
    }

    public void addWildcard(Wildcard wildcard) throws SchemaException {
        if (wildcard.isAttributeWildcard()) {
            throw new SchemaException("only <any> should be add in a group.");
        }
        this._contentModel.addWildcard(wildcard);
    }

    public boolean removeWildcard(Wildcard wildcard) {
        if (wildcard == null) {
            return false;
        }
        return this._contentModel.removeWildcard(wildcard);
    }

    public ContentModelGroup getContentModelGroup() {
        return this._contentModel;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this.name;
    }

    public Order getOrder() {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 10 && this.getMinOccurs() == 1 && this.getMaxOccurs() == 1) {
            return ((Group)particle).getOrder();
        }
        return this.order;
    }

    public Structure getParent() {
        return this._parent;
    }

    public void setIsModelGroupDefinition(boolean bl) {
        this._isModelGroupDefinition = bl;
    }

    public boolean isModelGroupDefinition() {
        return this._isModelGroupDefinition;
    }

    public String getReferenceId() {
        if (this.name != null) {
            return "group:" + this.name;
        }
        return null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setId(String string) {
        this._id = string;
    }

    public void setOrder(Order order) {
        this.order = order == null ? Order.all : order;
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        this._contentModel.addElementDecl(elementDecl);
    }

    public boolean removeElementDecl(ElementDecl elementDecl) {
        return this._contentModel.removeElementDecl(elementDecl);
    }

    public void addGroup(Group group) throws SchemaException {
        this._contentModel.addGroup(group);
        group.setParent(this);
    }

    public boolean removeGroup(Group group) {
        boolean bl = this._contentModel.removeGroup(group);
        group.setParent(null);
        return bl;
    }

    public void addGroup(ModelGroup modelGroup) throws SchemaException {
        this._contentModel.addGroup(modelGroup);
        modelGroup.setParent(this);
    }

    public boolean removeGroup(ModelGroup modelGroup) {
        boolean bl = this._contentModel.removeGroup(modelGroup);
        modelGroup.setParent(null);
        return bl;
    }

    public Enumeration enumerate() {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 10 && this.getMinOccurs() == 1 && this.getMaxOccurs() == 1) {
            return ((Group)particle).enumerate();
        }
        return this._contentModel.enumerate();
    }

    public ElementDecl getElementDecl(String string) {
        return this._contentModel.getElementDecl(string);
    }

    public Particle getParticle(int n) {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 10 && this.getMinOccurs() == 1 && this.getMaxOccurs() == 1) {
            return ((Group)particle).getParticle(n);
        }
        return this._contentModel.getParticle(n);
    }

    public int getParticleCount() {
        Particle particle;
        if (this._contentModel.getParticleCount() == 1 && (particle = this._contentModel.getParticle(0)).getStructureType() == 10 && this.getMinOccurs() == 1 && this.getMaxOccurs() == 1) {
            return ((Group)particle).getParticleCount();
        }
        return this._contentModel.getParticleCount();
    }

    public short getStructureType() {
        return 10;
    }

    public boolean hasAny() {
        boolean bl = false;
        Enumeration enumeration = this._contentModel.enumerate();
        while (enumeration.hasMoreElements() && !bl) {
            Structure structure = (Structure)enumeration.nextElement();
            switch (structure.getStructureType()) {
                case 8: {
                    break;
                }
                case 10: 
                case 16: {
                    bl = ((Group)structure).hasAny();
                    break;
                }
                case 24: {
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public void validate() throws ValidationException {
        Enumeration enumeration = this._contentModel.enumerate();
        while (enumeration.hasMoreElements()) {
            ((Structure)enumeration.nextElement()).validate();
        }
    }

    protected void setParent(Structure structure) {
        if (structure != null) {
            switch (structure.getStructureType()) {
                case 6: 
                case 10: 
                case 16: {
                    break;
                }
                default: {
                    String string = "Invalid parent for group";
                    throw new IllegalArgumentException(string);
                }
            }
        }
        this._parent = structure;
    }
}

