/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class EventListenerList
implements Serializable {
    private static final EventListener[] NULL_ARRAY = new EventListener[0];
    protected transient EventListener[] listenerList = NULL_ARRAY;

    public EventListener[] getListenerList() {
        return this.listenerList;
    }

    public int getListenerCount() {
        return this.listenerList.length;
    }

    public synchronized void add(EventListener eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException("Listener to add must not be null.");
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new EventListener[]{eventListener};
        } else {
            int n = this.listenerList.length;
            EventListener[] eventListenerArray = new EventListener[n + 1];
            System.arraycopy(this.listenerList, 0, eventListenerArray, 0, n);
            eventListenerArray[n] = eventListener;
            this.listenerList = eventListenerArray;
        }
    }

    public synchronized void add(EventListener eventListener, int n) {
        if (eventListener == null) {
            throw new IllegalArgumentException("Listener to add must not be null.");
        }
        if (n < 0 || n > this.listenerList.length) {
            throw new IllegalArgumentException("Index to add listener (" + n + ") is out of bounds. List length is " + this.listenerList.length);
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new EventListener[]{eventListener};
        } else {
            int n2 = this.listenerList.length;
            EventListener[] eventListenerArray = new EventListener[n2 + 1];
            System.arraycopy(this.listenerList, 0, eventListenerArray, 0, n);
            System.arraycopy(this.listenerList, n, eventListenerArray, n + 1, n2 - n);
            eventListenerArray[n] = eventListener;
            this.listenerList = eventListenerArray;
        }
    }

    public synchronized boolean remove(EventListener eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException("Listener to remove must not be null.");
        }
        int n = -1;
        int n2 = this.listenerList.length - 1;
        while (n2 >= 0) {
            if (this.listenerList[n2].equals(eventListener)) {
                n = n2;
                break;
            }
            --n2;
        }
        if (n != -1) {
            EventListener[] eventListenerArray = new EventListener[this.listenerList.length - 1];
            System.arraycopy(this.listenerList, 0, eventListenerArray, 0, n);
            if (n < eventListenerArray.length) {
                System.arraycopy(this.listenerList, n + 1, eventListenerArray, n, eventListenerArray.length - n);
            }
            this.listenerList = eventListenerArray.length == 0 ? NULL_ARRAY : eventListenerArray;
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        EventListener[] eventListenerArray = this.listenerList;
        objectOutputStream.defaultWriteObject();
        int n = 0;
        while (n < eventListenerArray.length) {
            EventListener eventListener = eventListenerArray[n];
            if (eventListener != null && eventListener instanceof Serializable) {
                objectOutputStream.writeObject(eventListener);
            }
            ++n;
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        EventListener eventListener;
        this.listenerList = NULL_ARRAY;
        objectInputStream.defaultReadObject();
        while (null != (eventListener = (EventListener)objectInputStream.readObject())) {
            this.add(eventListener);
        }
    }

    public String toString() {
        EventListener[] eventListenerArray = this.listenerList;
        String string = "EventListenerList: ";
        string = string + eventListenerArray.length + " listeners: ";
        int n = 0;
        while (n < eventListenerArray.length) {
            string = string + " listener " + eventListenerArray[n + 1];
            ++n;
        }
        return string;
    }
}

