/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.DateTimeBase;
import org.exolab.castor.types.OperationNotSupportedException;

public class Time
extends DateTimeBase {
    private static final String TIME_FORMAT = "HH:mm:ss.SSS";

    public Time() {
    }

    public Time(short[] sArray) {
        this.setValues(sArray);
    }

    public Time(long l) {
        if (l > 86400000L) {
            throw new IllegalArgumentException("Bad Time: the long value can't represent more than 24h.");
        }
        this.setHour((short)(l / 3600000L));
        this.setMinute((short)((l %= 3600000L) / 60000L));
        this.setSecond((short)((l %= 6000L) / 100L), (short)(l % 100L));
    }

    public Time(String string) throws ParseException {
        this();
        Time.parseTimeInternal(string, this);
    }

    public void setValues(short[] sArray) {
        if (sArray.length != 4) {
            throw new IllegalArgumentException("Time#setValues: not the right number of values");
        }
        this.setHour(sArray[0]);
        this.setMinute(sArray[1]);
        this.setSecond(sArray[2], sArray[3]);
    }

    public short[] getValues() {
        short[] sArray = null;
        sArray = new short[]{this.getHour(), this.getMinute(), this.getSeconds(), this.getMilli()};
        return sArray;
    }

    public Date toDate() {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
        if (this.isUTC()) {
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
            simpleDateFormat.setTimeZone(simpleTimeZone);
        }
        try {
            date = simpleDateFormat.parse(this.toString());
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isNegative()) {
            stringBuffer.append('-');
        }
        if (this.getHour() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getHour());
        stringBuffer.append(':');
        if (this.getMinute() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getMinute());
        stringBuffer.append(':');
        if (this.getSeconds() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getSeconds());
        stringBuffer.append('.');
        stringBuffer.append(this.getMilli());
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                stringBuffer.append('Z');
            } else {
                StringBuffer stringBuffer2 = new StringBuffer();
                if (this.isZoneNegative()) {
                    stringBuffer2.append('-');
                } else {
                    stringBuffer2.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneHour());
                stringBuffer2.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneMinute());
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2 = null;
            }
        }
        return stringBuffer.toString();
    }

    public static Object parse(String string) throws ParseException {
        return Time.parseTime(string);
    }

    public static Time parseTime(String string) throws ParseException {
        Time time = new Time();
        return Time.parseTimeInternal(string, time);
    }

    private static Time parseTimeInternal(String string, Time time) throws ParseException {
        int n;
        char[] cArray;
        if (string == null) {
            throw new IllegalArgumentException("The string to be parsed must notbe null.");
        }
        if (time == null) {
            time = new Time();
        }
        if ((cArray = string.toCharArray())[n = 0] == '-') {
            ++n;
            time.setNegative();
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 15;
        while (n < cArray.length) {
            char c = cArray[n++];
            switch (c) {
                case ':': {
                    if (!bl2) {
                        throw new ParseException("Bad Time format:" + string + "\nA time field must have 2 digits.", n);
                    }
                    if (n4 == 15) {
                        time.setHour((short)n2);
                        n4 = 7;
                    } else if (n4 == 7) {
                        time.setMinute((short)n2);
                        n4 = 3;
                    } else if (n4 == 3) {
                        time.setSecond((short)n3, (short)n2);
                    } else if (n4 == 1) {
                        n3 = n2;
                        n2 = -1;
                        n4 = 0;
                    } else {
                        throw new ParseException("Bad Time Format:" + string + "\nA Time must follow the pattern hh:mm:ss.s(Z|((+|-)hh:mm)).", n);
                    }
                    bl = false;
                    bl2 = false;
                    break;
                }
                case '.': {
                    if (n4 != 3) {
                        throw new ParseException("Bad Time Format:" + string + "\n'.' is wrong placed", n);
                    }
                    n3 = n2;
                    bl = false;
                    bl2 = false;
                    break;
                }
                case 'Z': {
                    if (n4 != 3) {
                        throw new ParseException("Bad Time Format:" + string + "\n'Z' is wrong placed", n);
                    }
                    time.setUTC();
                    break;
                }
                case '-': {
                    if (n4 != 3) {
                        throw new ParseException("Bad Time Format:" + string + "\n'-' is wrong placed", n);
                    }
                    time.setSecond((short)n3, (short)n2);
                    time.setUTC();
                    time.setZoneNegative();
                    n4 = 1;
                    bl = false;
                    bl2 = false;
                    break;
                }
                case '+': {
                    if (n4 != 3) {
                        throw new ParseException("Bad Time Format:" + string + "\n'+' is wrong placed", n);
                    }
                    time.setSecond((short)n3, (short)n2);
                    time.setUTC();
                    n4 = 1;
                    bl = false;
                    bl2 = false;
                    break;
                }
                default: {
                    if ('0' <= c && c <= '9') {
                        if (bl) {
                            n2 = (short)(n2 * 10 + (c - 48));
                            bl2 = true;
                            break;
                        }
                        bl = true;
                        n2 = (short)(c - 48);
                        break;
                    }
                    throw new ParseException(string + ": Invalid character: " + c, n);
                }
            }
        }
        if (n4 != 3 && n4 != 0) {
            throw new ParseException("Bad Time Format: " + string + "\nA Time must follow the pattern hh:mm:ss.s(Z|((+|-)hh:mm)).", n);
        }
        if (n4 == 3) {
            time.setSecond((short)n3, (short)n2);
        } else if (n4 == 0) {
            if (n2 != -1) {
                time.setZone((short)n3, (short)n2);
            } else {
                throw new ParseException(string + "\n In a time zone, the minute field must always be present.", n);
            }
        }
        return time;
    }

    public short getCentury() {
        String string = "Time: couldn't access to the Century field.";
        throw new OperationNotSupportedException(string);
    }

    public short getYear() {
        String string = "Time: couldn't access to the Year field.";
        throw new OperationNotSupportedException(string);
    }

    public short getMonth() {
        String string = "Time: couldn't access to the Month field.";
        throw new OperationNotSupportedException(string);
    }

    public short getDay() {
        String string = "Time: couldn't access to the Day field.";
        throw new OperationNotSupportedException(string);
    }

    public void setCentury(short s) {
        String string = "Time: couldn't access to the Century field.";
        throw new OperationNotSupportedException(string);
    }

    public void getYear(short s) {
        String string = "Time: couldn't access to the Year field.";
        throw new OperationNotSupportedException(string);
    }

    public void getMonth(short s) {
        String string = "Time: couldn't access to the Month field.";
        throw new OperationNotSupportedException(string);
    }

    public void getDay(short s) {
        String string = "Time: couldn't access to the Day field.";
        throw new OperationNotSupportedException(string);
    }
}

