/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.GYearMonth;
import org.exolab.castor.types.OperationNotSupportedException;

public class GYear
extends GYearMonth {
    private static final String YEAR_FORMAT = "yyyy";

    public GYear() {
    }

    public GYear(short s, short s2) {
        this.setCentury(s);
        this.setYear(s2);
    }

    public GYear(int n) {
        short s = (short)(n / 100);
        this.setCentury(s);
        this.setYear((short)(n %= 100));
    }

    public GYear(short[] sArray) {
        this();
        this.setValues(sArray);
    }

    public GYear(String string) throws ParseException {
        this();
        GYear.parseGYearInternal(string, this);
    }

    public void setValues(short[] sArray) {
        if (sArray.length != 2) {
            throw new IllegalArgumentException("GYear#setValues: not the right number of values");
        }
        this.setCentury(sArray[0]);
        this.setYear(sArray[1]);
        this.setMonth(sArray[2]);
    }

    public short[] getValues() {
        short[] sArray = null;
        sArray = new short[]{this.getCentury(), this.getYear()};
        return sArray;
    }

    public Date toDate() {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YEAR_FORMAT);
        if (this.isUTC()) {
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
            simpleDateFormat.setTimeZone(simpleTimeZone);
        }
        try {
            date = simpleDateFormat.parse(this.toString());
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isNegative()) {
            stringBuffer.append('-');
        }
        stringBuffer.append(this.getCentury());
        if (stringBuffer.length() == 1) {
            stringBuffer.insert(0, 0);
        }
        if (this.getYear() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getYear());
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                stringBuffer.append('Z');
            } else {
                StringBuffer stringBuffer2 = new StringBuffer();
                if (this.isZoneNegative()) {
                    stringBuffer2.append('-');
                } else {
                    stringBuffer2.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneHour());
                stringBuffer2.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneMinute());
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2 = null;
            }
        }
        return stringBuffer.toString();
    }

    public static Object parse(String string) throws ParseException {
        return GYear.parseGYear(string);
    }

    public static GYear parseGYear(String string) throws ParseException {
        GYear gYear = new GYear();
        return GYear.parseGYearInternal(string, gYear);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GYear parseGYearInternal(String string, GYear gYear) throws ParseException {
        int n;
        char[] cArray;
        if (string == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (gYear == null) {
            gYear = new GYear();
        }
        if ((cArray = string.toCharArray())[n = 0] == '-') {
            ++n;
            gYear.setNegative();
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 3;
        while (n < cArray.length) {
            char c = cArray[n++];
            switch (c) {
                case '-': {
                    if (n4 != 3) throw new ParseException("Bad gYear Format:" + string + "\nA gYear must follow the pattern CCYY(Z|((+|-)hh:mm)).", n);
                    if (n2 == 0 && n3 == 0) throw new ParseException("Bad gYear Format: " + string + "\n'0000' is not allowed as a year.", n);
                    if (!bl2) {
                        throw new ParseException("Bad gYear Format: " + string + "\nThe Century field must have 2 digits.", n);
                    }
                    gYear.setCentury((short)n2);
                    gYear.setYear((short)n3);
                    n4 = 1;
                    n3 = -1;
                    gYear.setUTC();
                    gYear.setZoneNegative();
                    bl = false;
                    bl2 = false;
                    break;
                }
                case 'Z': {
                    if (n4 != 3) {
                        throw new ParseException("Bad gYear Format: " + string + "'Z' is wrongly placed", n);
                    }
                    gYear.setUTC();
                    break;
                }
                case '+': {
                    if (n4 != 3) {
                        throw new ParseException("Bad gYear Format: " + string + "'+' is wrongly placed", n);
                    }
                    if (n2 == 0 && n3 == 0) throw new ParseException("Bad gYear Format: " + string + "\n'0000' is not allowed as a year.", n);
                    if (!bl2) {
                        throw new ParseException("Bad gYear Format: " + string + "\nThe Century field must have 2 digits.", n);
                    }
                    gYear.setCentury((short)n2);
                    gYear.setYear((short)n3);
                    gYear.setUTC();
                    n4 = 1;
                    bl = false;
                    bl2 = false;
                    break;
                }
                case ':': {
                    if (n4 != 1) {
                        throw new ParseException("Bad gYear Format: " + string + "':' is wrongly placed", n);
                    }
                    n3 = n2;
                    n2 = -1;
                    n4 = 0;
                    bl = false;
                    bl2 = false;
                    break;
                }
                default: {
                    if ('0' > c || c > '9') throw new ParseException(string + ": Invalid character: " + c, n);
                    if (bl) {
                        if (bl2) {
                            n3 = (short)(n3 * 10 + (c - 48));
                            break;
                        }
                        n2 = (short)(n2 * 10 + (c - 48));
                        bl2 = true;
                        break;
                    }
                    bl = true;
                    n2 = (short)(c - 48);
                    break;
                }
            }
        }
        if (n4 != 3 && n4 != 0) {
            throw new ParseException("Bad gYear Format: " + string + "\nA gYear must follow the pattern CCYY(Z|((+|-)hh:mm)).", n);
        }
        if (n4 == 3) {
            if (n2 == 0 && n3 == 0) throw new ParseException("Bad gYear Format: " + string + "\n'0000' is not allowed as a year.", n);
            if (!bl2) {
                throw new ParseException("Bad gYear Format: " + string + "\nThe Century field must have 2 digits.", n);
            }
            gYear.setCentury((short)n2);
            gYear.setYear((short)n3);
            return gYear;
        } else {
            if (n4 != 0) return gYear;
            if (n2 == -1) throw new ParseException(string + "\n In a time zone, the minute field must always be present.", n);
            gYear.setZone((short)n3, (short)n2);
        }
        return gYear;
    }

    public short getMonth() {
        String string = "GYear: couldn't access to the Month field.";
        throw new OperationNotSupportedException(string);
    }

    public void setMonth(short s) {
        String string = "GYear: couldn't access to the Month field.";
        throw new OperationNotSupportedException(string);
    }
}

