/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingResolver;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.Include;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.util.Messages;
import org.exolab.castor.xml.IDResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Mapping {
    public static final EngineMapping JDO = new EngineMapping("jdo", "org.exolab.castor.jdo.engine.JDOMappingLoader");
    public static final EngineMapping DAX = new EngineMapping("dax", "org.exolab.castor.dax.engine.DAXMappingLoader");
    public static final EngineMapping XML = new EngineMapping("xml", "org.exolab.castor.xml.XMLMappingLoader");
    private PrintWriter _logWriter;
    private ClassLoader _loader;
    private DTDResolver _resolver = new DTDResolver();
    private MappingRoot _mapping;
    private ClassMappingResolver _idResolver = null;
    private Hashtable _resolvers = new Hashtable();
    private MappingState _state = new MappingState();
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$io$PrintWriter;
    static /* synthetic */ Class class$org$exolab$castor$mapping$xml$MappingRoot;
    static /* synthetic */ Class class$org$exolab$castor$mapping$Mapping;

    public Mapping(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this._loader = classLoader;
        this._resolver = new DTDResolver();
        this._idResolver = new ClassMappingResolver();
    }

    public Mapping() {
        this(null);
    }

    public MappingResolver getResolver(EngineMapping engineMapping) throws MappingException {
        return this.getResolver(engineMapping, null);
    }

    public MappingResolver getResolver(EngineMapping engineMapping, Object object) throws MappingException {
        if (this._mapping == null) {
            throw new MappingException("Must call loadMapping first");
        }
        MappingResolver mappingResolver = (MappingResolver)this._resolvers.get(engineMapping);
        if (mappingResolver == null) {
            try {
                Class<?> clazz = this._loader != null ? this._loader.loadClass(engineMapping.getLoaderClass()) : Class.forName(engineMapping.getLoaderClass());
                Constructor<?> constructor = clazz.getConstructor(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Mapping.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = Mapping.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
                MappingLoader mappingLoader = (MappingLoader)constructor.newInstance(this._loader, this._logWriter);
                mappingResolver = mappingLoader;
                this._resolvers.put(engineMapping, mappingResolver);
                mappingLoader.loadMapping(this._mapping, object);
            }
            catch (Exception exception) {
                throw new MappingException(exception);
            }
        }
        return mappingResolver;
    }

    public MappingRoot getRoot() {
        return this._mapping;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._resolver = new DTDResolver(entityResolver);
    }

    public void setBaseURL(String string) {
        try {
            this._resolver.setBaseURL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void loadMapping(String string) throws IOException, MappingException {
        if (this._resolver.getBaseURL() == null) {
            this.setBaseURL(string);
        }
        this.loadMappingInternal(string);
    }

    public void loadMapping(URL uRL) throws IOException, MappingException {
        try {
            InputSource inputSource;
            if (this._resolver.getBaseURL() == null) {
                this._resolver.setBaseURL(uRL);
            }
            if ((inputSource = this._resolver.resolveEntity(null, uRL.toString())) == null) {
                inputSource = new InputSource(uRL.toString());
                inputSource.setByteStream(uRL.openStream());
            } else {
                inputSource.setSystemId(uRL.toString());
            }
            if (this._logWriter != null) {
                this._logWriter.println(Messages.format("mapping.loadingFrom", uRL.toString()));
            }
            this.loadMappingInternal(inputSource);
        }
        catch (SAXException sAXException) {
            throw new MappingException(sAXException);
        }
    }

    public void loadMapping(InputSource inputSource) throws IOException, MappingException {
        this.loadMappingInternal(inputSource);
    }

    private void loadMappingInternal(String string) throws IOException, MappingException {
        try {
            InputSource inputSource = this._resolver.resolveEntity(null, string);
            if (inputSource == null) {
                inputSource = new InputSource(string);
            }
            if (inputSource.getSystemId() == null) {
                inputSource.setSystemId(string);
            }
            if (this._logWriter != null) {
                this._logWriter.println(Messages.format("mapping.loadingFrom", string));
            }
            this.loadMappingInternal(inputSource);
        }
        catch (SAXException sAXException) {
            throw new MappingException(sAXException);
        }
    }

    private void loadMappingInternal(InputSource inputSource) throws IOException, MappingException {
        this._resolvers.clear();
        if (inputSource.getSystemId() != null && this._state.processed(inputSource.getSystemId())) {
            String string = "The mapping located at:" + inputSource.getSystemId();
            string = string + " has already been processed.";
            throw new MappingException(string);
        }
        try {
            if (this._mapping == null) {
                this._mapping = new MappingRoot();
                this._idResolver.setMapping(this._mapping);
            }
            Unmarshaller unmarshaller = new Unmarshaller(class$org$exolab$castor$mapping$xml$MappingRoot == null ? (class$org$exolab$castor$mapping$xml$MappingRoot = Mapping.class$("org.exolab.castor.mapping.xml.MappingRoot")) : class$org$exolab$castor$mapping$xml$MappingRoot);
            unmarshaller.setEntityResolver(this._resolver);
            if (this._logWriter != null) {
                unmarshaller.setLogWriter(this._logWriter);
            }
            unmarshaller.setClassLoader((class$org$exolab$castor$mapping$Mapping == null ? (class$org$exolab$castor$mapping$Mapping = Mapping.class$("org.exolab.castor.mapping.Mapping")) : class$org$exolab$castor$mapping$Mapping).getClassLoader());
            unmarshaller.setIDResolver(this._idResolver);
            MappingRoot mappingRoot = (MappingRoot)unmarshaller.unmarshal(inputSource);
            Enumeration enumeration = mappingRoot.enumerateClassMapping();
            while (enumeration.hasMoreElements()) {
                this._mapping.addClassMapping((ClassMapping)enumeration.nextElement());
            }
            enumeration = mappingRoot.enumerateKeyGeneratorDef();
            while (enumeration.hasMoreElements()) {
                this._mapping.addKeyGeneratorDef((KeyGeneratorDef)enumeration.nextElement());
            }
            if (inputSource.getSystemId() != null) {
                this._state.markAsProcessed(inputSource.getSystemId(), this._mapping);
            }
            Enumeration enumeration2 = mappingRoot.enumerateInclude();
            while (enumeration2.hasMoreElements()) {
                try {
                    this.loadMappingInternal(((Include)enumeration2.nextElement()).getHref());
                }
                catch (Exception exception) {
                    throw new MappingException(exception);
                }
            }
        }
        catch (MarshalException marshalException) {
            if (marshalException.getException() != null) {
                throw new MappingException(marshalException.getException());
            }
            throw new MappingException(marshalException);
        }
        catch (Exception exception) {
            throw new MappingException(exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MappingState {
        private Hashtable _processed = new Hashtable(1);

        MappingState() {
        }

        void markAsProcessed(String string, MappingRoot mappingRoot) {
            this._processed.put(string, mappingRoot);
        }

        boolean processed(MappingRoot mappingRoot) {
            return this._processed.contains(mappingRoot);
        }

        boolean processed(String string) {
            return this._processed.containsKey(string);
        }

        MappingRoot getMapping(String string) {
            return (MappingRoot)this._processed.get(string);
        }
    }

    class ClassMappingResolver
    implements IDResolver {
        private MappingRoot _mapping = null;

        ClassMappingResolver() {
        }

        public void setMapping(MappingRoot mappingRoot) {
            this._mapping = mappingRoot;
        }

        public Object resolve(String string) {
            if (this._mapping == null) {
                return null;
            }
            int n = 0;
            while (n < this._mapping.getClassMappingCount()) {
                ClassMapping classMapping = this._mapping.getClassMapping(n);
                if (string.equals(classMapping.getName())) {
                    return classMapping;
                }
                ++n;
            }
            return null;
        }
    }

    static class EngineMapping {
        private final String _name;
        private final String _loaderClass;

        EngineMapping(String string, String string2) {
            this._name = string;
            this._loaderClass = string2;
        }

        public String getLoaderClass() {
            return this._loaderClass;
        }

        public String toString() {
            return this._name;
        }
    }
}

