/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.jndi;

import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.Exporter;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.dsml.jndi.JNDIConsumer;
import org.exolab.castor.dsml.jndi.JNDIProducer;
import org.exolab.castor.util.Messages;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class JNDIExporter
extends Exporter {
    private DirContext _ctx;

    public JNDIExporter(DirContext dirContext) {
        this._ctx = dirContext;
    }

    protected Consumer createConsumer() {
        return new JNDIConsumer();
    }

    public void export(DocumentHandler documentHandler, boolean bl, boolean bl2) throws ImportExportException {
        NamingEnumeration<SearchResult> namingEnumeration;
        if (this.getSearchDescriptor() == null) {
            throw new IllegalStateException(Messages.message("dsml.searchDescriptorRequired"));
        }
        String string = this.getSearchDescriptor().getFilter();
        if (string == null) {
            string = "()";
        }
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(this.getSearchDescriptor().getReturnAttrs());
            switch (this.getSearchDescriptor().getScope()) {
                case 1: {
                    searchControls.setSearchScope(0);
                    break;
                }
                case 0: {
                    searchControls.setSearchScope(1);
                    break;
                }
                case 3: {
                    searchControls.setSearchScope(2);
                }
            }
            namingEnumeration = this._ctx.search(this.getSearchDescriptor().getBaseDN(), string, searchControls);
        }
        catch (NameNotFoundException nameNotFoundException) {
            namingEnumeration = null;
        }
        catch (NamingException namingException) {
            throw new ImportExportException(namingException);
        }
        try {
            JNDIProducer jNDIProducer = new JNDIProducer(documentHandler, false);
            jNDIProducer.startDocument();
            if (namingEnumeration != null) {
                jNDIProducer.produce(namingEnumeration);
            }
            if (bl2 && this.getImportDescriptor() != null) {
                jNDIProducer.produce(this.getImportDescriptor());
            }
            jNDIProducer.endDocument();
        }
        catch (SAXException sAXException) {
            throw new ImportExportException(sAXException);
        }
    }
}

