/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import stacgui.ParamTable;
import stacgui.PrintfFormat;
import stacgui.STAC_GUI_Button_Panel;
import stacgui.STAC_GUI_File_Chooser_Panel;
import stacgui.StacBCM;
import stacgui.StacUtil;
import stacgui.Stac_Button_actionAdapter;
import stacgui.Stac_FileChooser;
import stacgui.Stac_Out;
import stacgui.TranslationTableModel;

class TranslationWidget
extends JPanel
implements STAC_GUI_Button_Panel,
STAC_GUI_File_Chooser_Panel {
    StacBCM bcm;
    StacUtil utils;
    String motorName = "";
    ParamTable motorParams;
    JTextField jTFGTCInpP = new JTextField();
    JButton jButtonGTC_mvP = new JButton();
    JTextField jTFGTCInpPX = new JTextField();
    JTextField jTFGTCInpPY = new JTextField();
    JTextField jTFGTCInpPZ = new JTextField();
    JButton jButtonGTC_getP = new JButton();
    TranslationTableModel translationTableModel = new TranslationTableModel();
    JTable jTableTrans = new JTable(this.translationTableModel);
    JScrollPane jpanelReorientTable = new JScrollPane(this.jTableTrans);
    JButton jButtonGTC_addLine = new JButton("Add Actual");
    JButton jButtonGTC_delSelected = new JButton("Del Selected");
    JButton jButtonLoad = new JButton("L");
    JButton jButtonSave = new JButton("S");
    Dimension rbSize = new Dimension(100, 30);
    Dimension rbhSize = new Dimension(50, 30);
    Dimension rbdSize = new Dimension(200, 30);
    Dimension fsbSize = new Dimension(30, 30);
    Dimension fsdbSize = new Dimension(60, 30);
    Dimension tfSize = new Dimension(1000, 30);
    Dimension tfnSize = new Dimension(10, 30);

    public TranslationWidget(StacBCM stacbcm, StacUtil stacutil, String rotAxis) {
        this.bcm = stacbcm;
        this.utils = stacutil;
        this.motorName = rotAxis;
        this.setLayout(new BoxLayout(this, 3));
        JPanel jPanelGTCInpP = new JPanel();
        this.add((Component)jPanelGTCInpP, null);
        jPanelGTCInpP.setLayout(new BoxLayout(jPanelGTCInpP, 2));
        jPanelGTCInpP.add(Box.createRigidArea(new Dimension(10, 10)));
        JLabel jLabelGTCInpP = new JLabel();
        jPanelGTCInpP.add((Component)jLabelGTCInpP, null);
        jLabelGTCInpP.setText(String.valueOf(this.motorName) + " translation (datum = only " + this.motorName + "):");
        jLabelGTCInpP.setMinimumSize(this.rbdSize);
        jLabelGTCInpP.setMaximumSize(this.rbdSize);
        jLabelGTCInpP.setPreferredSize(this.rbdSize);
        jPanelGTCInpP.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanelGTCInpP.add(Box.createHorizontalGlue());
        jPanelGTCInpP.add((Component)this.jTFGTCInpP, null);
        this.jTFGTCInpP.setToolTipText(String.valueOf(this.motorName) + " Angle Used");
        this.jTFGTCInpP.setMinimumSize(this.tfnSize);
        this.jTFGTCInpP.setMaximumSize(this.tfSize);
        this.jTFGTCInpP.setPreferredSize(this.tfSize);
        this.jTFGTCInpP.setText("180.0");
        this.jButtonGTC_mvP.setText("Mv " + this.motorName);
        this.jButtonGTC_mvP.setMinimumSize(this.rbSize);
        this.jButtonGTC_mvP.setMaximumSize(this.rbSize);
        this.jButtonGTC_mvP.setPreferredSize(this.rbSize);
        this.jButtonGTC_mvP.setToolTipText("Set Datum = only " + this.motorName);
        this.jButtonGTC_mvP.addActionListener(new Stac_Button_actionAdapter(this));
        this.jButtonGTC_mvP.setEnabled(true);
        jPanelGTCInpP.add((Component)this.jButtonGTC_mvP, null);
        jPanelGTCInpP.add((Component)this.jTFGTCInpPX, null);
        this.jTFGTCInpPX.setToolTipText("X Component of " + this.motorName + " Translation");
        this.jTFGTCInpPX.setMinimumSize(this.tfnSize);
        this.jTFGTCInpPX.setMaximumSize(this.tfSize);
        this.jTFGTCInpPX.setPreferredSize(this.tfSize);
        jPanelGTCInpP.add((Component)this.jTFGTCInpPY, null);
        this.jTFGTCInpPY.setToolTipText("Y Component of " + this.motorName + " Translation");
        this.jTFGTCInpPY.setMinimumSize(this.tfnSize);
        this.jTFGTCInpPY.setMaximumSize(this.tfSize);
        this.jTFGTCInpPY.setPreferredSize(this.tfSize);
        jPanelGTCInpP.add((Component)this.jTFGTCInpPZ, null);
        this.jTFGTCInpPZ.setToolTipText("Z Component of " + this.motorName + " Translation");
        this.jTFGTCInpPZ.setMinimumSize(this.tfnSize);
        this.jTFGTCInpPZ.setMaximumSize(this.tfSize);
        this.jTFGTCInpPZ.setPreferredSize(this.tfSize);
        this.jButtonGTC_getP.setText("Get Trn.");
        this.jButtonGTC_getP.setMinimumSize(this.rbSize);
        this.jButtonGTC_getP.setMaximumSize(this.rbSize);
        this.jButtonGTC_getP.setPreferredSize(this.rbSize);
        this.jButtonGTC_getP.setToolTipText("Get the Current Translation");
        this.jButtonGTC_getP.addActionListener(new Stac_Button_actionAdapter(this));
        this.jButtonGTC_getP.setEnabled(true);
        jPanelGTCInpP.add((Component)this.jButtonGTC_getP, null);
        jPanelGTCInpP.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanelGTCInpP.add(Box.createHorizontalGlue());
        JPanel jPanelGTCTableP = new JPanel();
        this.add((Component)jPanelGTCTableP, null);
        jPanelGTCTableP.setLayout(new BoxLayout(jPanelGTCTableP, 2));
        jPanelGTCTableP.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanelGTCTableP.add((Component)this.jpanelReorientTable, null);
        this.translationTableModel.setTable(this.jTableTrans);
        jPanelGTCTableP.add(Box.createRigidArea(new Dimension(10, 10)));
        JPanel jPanelGTCTablePB = new JPanel();
        jPanelGTCTableP.add((Component)jPanelGTCTablePB, null);
        jPanelGTCTablePB.setLayout(new BoxLayout(jPanelGTCTablePB, 3));
        this.jButtonGTC_addLine.setMinimumSize(this.rbSize);
        this.jButtonGTC_addLine.setMaximumSize(this.rbSize);
        this.jButtonGTC_addLine.setPreferredSize(this.rbSize);
        this.jButtonGTC_addLine.setToolTipText("Adds the Currently Set Values to the Table");
        this.jButtonGTC_addLine.addActionListener(new Stac_Button_actionAdapter(this));
        this.jButtonGTC_addLine.setEnabled(true);
        jPanelGTCTablePB.add((Component)this.jButtonGTC_delSelected, null);
        this.jButtonGTC_delSelected.setMinimumSize(this.rbSize);
        this.jButtonGTC_delSelected.setMaximumSize(this.rbSize);
        this.jButtonGTC_delSelected.setPreferredSize(this.rbSize);
        this.jButtonGTC_delSelected.setToolTipText("Removes the Selected Rows from the Table");
        this.jButtonGTC_delSelected.addActionListener(new Stac_Button_actionAdapter(this));
        this.jButtonGTC_delSelected.setEnabled(true);
        JPanel jPanelLoadSave = new JPanel();
        jPanelGTCTablePB.add((Component)jPanelLoadSave, null);
        jPanelLoadSave.setLayout(new BoxLayout(jPanelLoadSave, 2));
        jPanelLoadSave.add((Component)this.jButtonLoad, null);
        this.jButtonLoad.setMinimumSize(this.rbhSize);
        this.jButtonLoad.setMaximumSize(this.rbhSize);
        this.jButtonLoad.setPreferredSize(this.rbhSize);
        this.jButtonLoad.setToolTipText("Loads data from file to the Table");
        this.jButtonLoad.addActionListener(new Stac_FileChooser(this));
        this.jButtonLoad.setEnabled(true);
        jPanelLoadSave.add(Box.createVerticalGlue());
        jPanelLoadSave.add((Component)this.jButtonSave, null);
        this.jButtonSave.setMinimumSize(this.rbhSize);
        this.jButtonSave.setMaximumSize(this.rbhSize);
        this.jButtonSave.setPreferredSize(this.rbhSize);
        this.jButtonSave.setToolTipText("Saves the Table data to file");
        this.jButtonSave.addActionListener(new Stac_FileChooser(this));
        this.jButtonSave.setEnabled(true);
        jPanelGTCTablePB.add(Box.createVerticalGlue());
        jPanelGTCTableP.add(Box.createRigidArea(new Dimension(10, 10)));
    }

    public Vector getMeasuredData() {
        Vector<AxisAngle4d> data = new Vector<AxisAngle4d>();
        int[] vecIDs = this.jTableTrans.getSelectedRows();
        TranslationTableModel tmodel = (TranslationTableModel)this.jTableTrans.getModel();
        tmodel.setValueAt("ActivateCells", 0, 0);
        try {
            if (vecIDs.length != 0) {
                int i = 0;
                while (i < vecIDs.length) {
                    AxisAngle4d d = new AxisAngle4d();
                    d.x = new Double((String)this.jTableTrans.getValueAt(vecIDs[i], tmodel.getColId("X")));
                    d.y = new Double((String)this.jTableTrans.getValueAt(vecIDs[i], tmodel.getColId("Y")));
                    d.z = new Double((String)this.jTableTrans.getValueAt(vecIDs[i], tmodel.getColId("Z")));
                    d.angle = new Double((String)this.jTableTrans.getValueAt(vecIDs[i], tmodel.getColId("Angle")));
                    data.addElement(d);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.jTableTrans.getRowCount()) {
                    AxisAngle4d d = new AxisAngle4d();
                    d.x = new Double((String)this.jTableTrans.getValueAt(i, tmodel.getColId("X")));
                    d.y = new Double((String)this.jTableTrans.getValueAt(i, tmodel.getColId("Y")));
                    d.z = new Double((String)this.jTableTrans.getValueAt(i, tmodel.getColId("Z")));
                    d.angle = new Double((String)this.jTableTrans.getValueAt(i, tmodel.getColId("Angle")));
                    data.addElement(d);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public void Button_actionAdapter(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            Stac_Out.println("USER ACTION: Button pressed (Translation: " + this.motorName + " - " + ((JButton)e.getSource()).getText() + ")");
        }
        if (e.getSource() == this.jButtonGTC_delSelected) {
            int numOfVecs = this.jTableTrans.getSelectedRowCount();
            int[] vecIDs = this.jTableTrans.getSelectedRows();
            TranslationTableModel tmodel = (TranslationTableModel)this.jTableTrans.getModel();
            int i = vecIDs.length - 1;
            while (i >= 0) {
                tmodel.setValueAt("ClearRow", vecIDs[i], vecIDs[i]);
                --i;
            }
        } else if (e.getSource() == this.jButtonGTC_mvP) {
            double desiredAng = new Double(this.jTFGTCInpP.getText());
            if (this.motorName.compareToIgnoreCase("Phi") == 0) {
                this.bcm.moveToDatum(0.0, 0.0, desiredAng);
            } else if (this.motorName.compareToIgnoreCase("Kappa") == 0) {
                this.bcm.moveToDatum(0.0, desiredAng, 0.0);
            } else {
                this.bcm.moveToDatum(0.0, 0.0, 0.0);
                this.bcm.moveMotor(this.motorName, desiredAng);
            }
            double ang = this.bcm.getMotorPosition(this.motorName);
            if (!(Math.abs(ang - desiredAng) > 0.1)) {
                this.jTFGTCInpP.setText(new PrintfFormat("%.4f").sprintf(ang));
                this.jTFGTCInpPX.setText("");
                this.jTFGTCInpPY.setText("");
                this.jTFGTCInpPZ.setText("");
            }
        } else if (e.getSource() == this.jButtonGTC_getP) {
            double actVal;
            Point3d trn = new Point3d();
            Point3d dat = new Point3d();
            this.bcm.getCurrentDatumTrans(dat, trn);
            double d = this.motorName.compareToIgnoreCase("Phi") == 0 ? dat.z : (actVal = this.motorName.compareToIgnoreCase("Kappa") == 0 ? dat.y : 0.0);
            double zeroVal = this.motorName.compareToIgnoreCase("Phi") == 0 ? dat.y : (this.motorName.compareToIgnoreCase("Kappa") == 0 ? dat.z : 0.0);
            Double d2 = new Double(this.jTFGTCInpP.getText());
            if (Math.abs(this.utils.angleDegreeDiff(actVal, d2)) <= 0.1 && Math.abs(this.utils.angleDegreeDiff(0.0, zeroVal)) <= 0.1) {
                this.jTFGTCInpPX.setText(new PrintfFormat("%.4f").sprintf(trn.x));
                this.jTFGTCInpPY.setText(new PrintfFormat("%.4f").sprintf(trn.y));
                this.jTFGTCInpPZ.setText(new PrintfFormat("%.4f").sprintf(trn.z));
                int rowct = this.jTableTrans.getRowCount();
                TranslationTableModel tmodel = (TranslationTableModel)this.jTableTrans.getModel();
                this.jTableTrans.setValueAt(this.jTFGTCInpP.getText(), rowct, tmodel.getColId("Angle"));
                this.jTableTrans.setValueAt(this.jTFGTCInpPX.getText(), rowct, tmodel.getColId("X"));
                this.jTableTrans.setValueAt(this.jTFGTCInpPY.getText(), rowct, tmodel.getColId("Y"));
                this.jTableTrans.setValueAt(this.jTFGTCInpPZ.getText(), rowct, tmodel.getColId("Z"));
            }
        }
    }

    public void FileChooser_actionPerformed(ActionEvent e) {
        int returnVal;
        JFileChooser fc = new JFileChooser();
        File file = null;
        int n = returnVal = e.getSource() == this.jButtonLoad ? fc.showOpenDialog(this) : fc.showSaveDialog(this);
        if (returnVal == 0) {
            file = fc.getSelectedFile();
        }
        if (file == null) {
            return;
        }
        if (e.getSource() == this.jButtonLoad) {
            ParamTable table = new ParamTable();
            try {
                FileInputStream inputFile = new FileInputStream(file);
                DataInputStream in = new DataInputStream(inputFile);
                table.load(in);
                int rowct = this.jTableTrans.getRowCount();
                TranslationTableModel tmodel = (TranslationTableModel)this.jTableTrans.getModel();
                int i = 0;
                while (i < table.pnames.size()) {
                    this.jTableTrans.setValueAt(table.pnames.elementAt(i), rowct, tmodel.getColId("Angle"));
                    this.jTableTrans.setValueAt(((Vector)table.pvalues.elementAt(i)).elementAt(0), rowct, tmodel.getColId("X"));
                    this.jTableTrans.setValueAt(((Vector)table.pvalues.elementAt(i)).elementAt(1), rowct, tmodel.getColId("Y"));
                    this.jTableTrans.setValueAt(((Vector)table.pvalues.elementAt(i)).elementAt(2), rowct, tmodel.getColId("Z"));
                    ++i;
                    ++rowct;
                }
            }
            catch (Exception ex) {
                Stac_Out.println("Error loading the file: " + file.getAbsolutePath());
            }
        } else if (e.getSource() == this.jButtonSave) {
            ParamTable table = new ParamTable();
            try {
                int rowct = this.jTableTrans.getRowCount();
                TranslationTableModel tmodel = (TranslationTableModel)this.jTableTrans.getModel();
                int i = 0;
                while (i < rowct) {
                    table.pnames.addElement(this.jTableTrans.getValueAt(i, tmodel.getColId("Angle")));
                    Vector<Object> val = new Vector<Object>();
                    val.addElement(this.jTableTrans.getValueAt(i, tmodel.getColId("X")));
                    val.addElement(this.jTableTrans.getValueAt(i, tmodel.getColId("Y")));
                    val.addElement(this.jTableTrans.getValueAt(i, tmodel.getColId("Z")));
                    table.pvalues.addElement(val);
                    ++i;
                }
                FileOutputStream outFile = new FileOutputStream(file);
                DataOutputStream out = new DataOutputStream(outFile);
                table.save(out);
            }
            catch (Exception ex) {
                Stac_Out.println("Error saving the file: " + file.getAbsolutePath());
            }
        }
    }
}

