/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Vector3d;
import stacgui.ParamTable;
import stacgui.PrintfFormat;
import stacgui.StacBCM;
import stacgui.StacUtil;
import stacgui.Stac_Out;
import stacgui.Stac_Plugin;
import stacgui.Stac_StrategyPlugin;
import stacgui.StreamGobbler;
import stacgui.TextReader;

public class Stac_StrategyPlugin_strategy
extends Stac_Plugin
implements Stac_StrategyPlugin {
    public String CalculateStrategy(String workDir, Vector3d currDatum, Vector DesiredOrientations, StacBCM bcm, StacUtil utils) {
        File fp = new File(String.valueOf(workDir) + "STAC_strategy.res");
        fp.delete();
        int i = 0;
        while (i < DesiredOrientations.size()) {
            double omega = ((Vector3d)DesiredOrientations.elementAt((int)i)).x;
            double kappa = ((Vector3d)DesiredOrientations.elementAt((int)i)).y;
            double phi = ((Vector3d)DesiredOrientations.elementAt((int)i)).z;
            utils.change_denzo_matrices_by_gonset(bcm, String.valueOf(workDir) + "name0.x", omega, currDatum.x, kappa, currDatum.y, phi, currDatum.z, String.valueOf(workDir) + "name1.x");
            this.CallExternalStrategy(workDir, utils);
            this.FilterStrategies(workDir, i + 1, kappa, phi, currDatum.y, currDatum.z);
            ++i;
        }
        return "STAC_strategy.res";
    }

    public boolean selectStrategy(String workDir, String myfile, int strID, double kappa, double phi, int selectOption) {
        Stac_Out.println("File to be read: " + myfile);
        boolean complete = false;
        try {
            FileInputStream StrategyResultFile = new FileInputStream(myfile);
            TextReader grf = new TextReader(StrategyResultFile);
            grf.IOCheck(true);
            double omegaStart = 0.0;
            double omegaEnd = 0.0;
            double completion = 0.0;
            double completionRef = -1.0;
            double res = 2.35;
            double rangeRef = 500.0;
            boolean validValue = false;
            try {
                while (true) {
                    double omegaStartTemp = grf.readDouble();
                    double omegaEndTemp = grf.readDouble();
                    double completionTemp = grf.readDouble();
                    double resTemp = grf.readDouble();
                    double rangeTemp = Math.abs(omegaEndTemp - omegaStartTemp);
                    validValue = true;
                    if (selectOption != 1 && !(completionTemp > completionRef) && (completionTemp != completionRef || !(rangeRef > rangeTemp))) continue;
                    omegaStart = omegaStartTemp;
                    omegaEnd = omegaEndTemp;
                    completion = completionTemp;
                    completionRef = completionTemp;
                    res = resTemp;
                    rangeRef = rangeTemp;
                }
            }
            catch (Exception grfex) {
                grf.close();
                StrategyResultFile.close();
                if (validValue) {
                    FileOutputStream aFile = new FileOutputStream(String.valueOf(workDir) + "STAC_strategy.res", true);
                    DataOutputStream outFile = new DataOutputStream(aFile);
                    outFile.writeInt(strID);
                    outFile.writeDouble(omegaStart);
                    outFile.writeDouble(omegaEnd);
                    outFile.writeDouble(kappa);
                    outFile.writeDouble(phi);
                    outFile.writeDouble(completion);
                    outFile.writeDouble(res);
                    outFile.writeDouble(1.0);
                    if (completion == 100.0) {
                        complete = true;
                    }
                    outFile.close();
                    aFile.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return complete;
    }

    public void FilterStrategies(String workDir, int strID, double kappa, double phi, double actkappa, double actphi) {
        if (!this.selectStrategy(workDir, "STAC_strategy1.res", strID, kappa, phi, 1)) {
            this.selectStrategy(workDir, "STAC_strategy2.res", strID, actkappa, actphi, 0);
        }
    }

    public void PrepareStrategyTodo(String fname, String context) {
        try {
            FileWriter dstStream = new FileWriter(fname);
            dstStream.write(context);
            dstStream.flush();
            dstStream.close();
        }
        catch (IOException e) {
            Stac_Out.println("Problem with generating the strategy.todo file: " + fname);
        }
    }

    public void ExecutingStrategy(String workDir, String todofile, boolean removeOldResults, int runNumber) {
        try {
            String osName = System.getProperty("os.name");
            String[] cmd = new String[3];
            String mycmd = new String("p:\\work\\dev\\STAC\\gonset\\argtest.exe sutike < argtest.log");
            if (osName.equals("Windows NT") || osName.equals("Windows XP")) {
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
            } else if (osName.equals("Windows 95")) {
                cmd[0] = "command.com";
                cmd[1] = "/C";
            } else {
                String cmdPre = new String("cd " + workDir + ";");
                if (removeOldResults) {
                    cmdPre = cmdPre.concat("rm STAC_strategy" + runNumber + ".res;");
                }
                mycmd = String.valueOf(cmdPre) + "$STACDIR/strategy/strategy < " + todofile;
                cmd[0] = "sh";
                cmd[1] = "-c";
            }
            cmd[2] = mycmd;
            Runtime rt = Runtime.getRuntime();
            Stac_Out.println("Executing " + cmd[0] + " " + cmd[1] + " " + cmd[2]);
            Process proc = rt.exec(cmd);
            int exitVal = 0;
            try {
                StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
                StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT", String.valueOf(workDir) + "strategy.out");
                errorGobbler.start();
                outputGobbler.start();
                exitVal = proc.waitFor();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Stac_Out.println("Process exitValue: " + exitVal);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void CallExternalStrategy(String workDir, StacUtil utils) {
        ParamTable denzoTable = new ParamTable();
        utils.read_denzo_x(String.valueOf(workDir) + "name0.x", denzoTable);
        this.PrepareStrategyTodo("strategy_run0.todo", new PrintfFormat("XFILE name1.x\nSIMUL AUTO name1.sca\nCOMPLETENESS 100 99 98 97 96 95\nNBINS 10\nPSFILE strategy1.ps\nFORMAT %s\nSPACE GROUP %s\nRESOLUTION %s\n").sprintf(new Object[]{utils.detector_denzo2strategy(denzoTable.getFirstStringValue("detector")), denzoTable.getFirstValue("spg"), denzoTable.getFirstValue("resolution_limits")}));
        this.PrepareStrategyTodo("strategy_run1.todo", new PrintfFormat("XFILE name0.x\nALREADY MEASURED name1.sca\nCOMPLETENESS 99.9 99.7 99 98 97 96 95\nNBINS 10\nPSFILE strategy0.ps\nFORMAT %s\nSPACE GROUP %s\nRESOLUTION %s\n").sprintf(new Object[]{utils.detector_denzo2strategy(denzoTable.getFirstStringValue("detector")), denzoTable.getFirstValue("spg"), denzoTable.getFirstValue("resolution_limits")}));
        this.ExecutingStrategy(workDir, "strategy_run0.todo", true, 1);
        this.ExecutingStrategy(workDir, "strategy_run1.todo", true, 2);
    }

    public String getCreditString() {
        return "using strategy";
    }

    public void initPlugin() {
    }
}

