/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.awt.Component;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JOptionPane;
import stacgui.ParamTable;
import stacgui.PrintfFormat;
import stacgui.Stac_Out;

public class Stac_Session {
    String sessionId;
    int messageCounter = 0;
    boolean logging = true;
    DataOutputStream logOut = null;
    String workDir;
    boolean verbose = false;
    PrintStream exec_log = null;
    Component errorGUI = null;
    ParamTable MsgProcessingErrors;

    public Stac_Session(Component errorGUI) {
        this();
        this.setErrorGUI(errorGUI);
    }

    public Stac_Session() {
        this(true, "./");
    }

    public Stac_Session(boolean logging) {
        this(logging, "./");
    }

    public Stac_Session(String logdir) {
        this(true, logdir);
    }

    public Stac_Session(boolean logging, String logdir) {
        FileOutputStream logFile;
        try {
            this.sessionId = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.sessionId = "UnknownHost";
        }
        GregorianCalendar gc = new GregorianCalendar();
        Date actDate = gc.getTime();
        String actDateStr = new PrintfFormat("%04d_%02d_%02d_%02d:%02d:%02d.%03d").sprintf(new Object[]{new Integer(gc.get(1)), new Integer(gc.get(2) + 1), new Integer(gc.get(5)), new Integer(gc.get(11)), new Integer(gc.get(12)), new Integer(gc.get(13)), new Integer(gc.get(14))});
        this.sessionId = this.sessionId.concat("_" + actDateStr);
        this.workDir = logdir;
        if (logging) {
            try {
                logFile = new FileOutputStream(String.valueOf(this.workDir) + "STAC_LOG_" + this.sessionId);
                this.logOut = new DataOutputStream(logFile);
            }
            catch (Exception e) {
                this.errorInLogging();
            }
        } else {
            this.logging = false;
        }
        try {
            logFile = new FileOutputStream(String.valueOf(this.workDir) + "STAC_EXEC_LOG_" + this.sessionId);
            this.exec_log = new PrintStream(logFile);
        }
        catch (Exception e) {
            Stac_Out.println("I/O Error: STAC Session (" + this.sessionId + ") exec_logging disabled!");
            this.exec_log = null;
        }
        if (this.exec_log != null) {
            Stac_Out.setOutput(this.verbose);
            Stac_Out.setStac_Session(this);
        }
        this.MsgProcessingErrors = new ParamTable();
    }

    public void errorInLogging() {
        Stac_Out.println("I/O Error: STAC Session (" + this.sessionId + ") logging disabled!");
        this.logging = false;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void addModule() {
    }

    public void getModule() {
    }

    public synchronized int getNewMsgId() {
        ++this.messageCounter;
        return this.messageCounter;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        Stac_Out.setOutput(verbose);
    }

    public void print(String log) {
        if (this.exec_log != null) {
            this.exec_log.print(log);
            this.exec_log.flush();
        }
    }

    public void setErrorGUI(Component errorGUI) {
        this.errorGUI = errorGUI;
    }

    public void addErrorMsg(int msgId, String msg) {
        Vector msgList = this.MsgProcessingErrors.getValueList(new Integer(msgId).toString());
        msgList.addElement(msg);
        this.MsgProcessingErrors.setValueList(new Integer(msgId).toString(), msgList);
    }

    public void printErrorMsg(int msgId) {
        Vector msg = this.MsgProcessingErrors.getValueList(new Integer(msgId).toString());
        if (msg.size() > 0) {
            ArrayList<String> msgList = new ArrayList<String>(0);
            msgList.add("Errors occured:");
            int i = 0;
            while (i < msg.size()) {
                msgList.add(" - " + (String)msg.elementAt(i));
                ++i;
            }
            this.errorMsg(msgList);
        }
        this.MsgProcessingErrors.removeOldValueList(new Integer(msgId).toString());
    }

    public void errorMsg(ArrayList msg) {
        if (!msg.isEmpty()) {
            Stac_Out.println("### SYSTEM MESSAGE ###");
            int i = 0;
            while (i < msg.size()) {
                Stac_Out.println((String)msg.get(i));
                ++i;
            }
            Stac_Out.println("######################");
            if (this.errorGUI != null) {
                JOptionPane.showMessageDialog(this.errorGUI, msg.toArray());
            }
        }
    }

    public void errorMsg(String msg) {
        ArrayList<String> msgList = new ArrayList<String>(0);
        msgList.add(msg);
        this.errorMsg(msgList);
    }
}

