/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoDs.TangoConst;
import java.io.FileWriter;
import java.util.Vector;
import javax.vecmath.Point3d;
import jive.DevHelper;
import jive.DevHelperDevFailed;
import jive.ExecDev;
import stacgui.AttrInfo;
import stacgui.CmdInfo;
import stacgui.ParamTable;
import stacgui.StacUtil;
import stacgui.Stac_BCMplugin;
import stacgui.Stac_BCMplugin_base;
import stacgui.Stac_Out;

public class Stac_BCMplugin_tango
extends Stac_BCMplugin_base
implements Stac_BCMplugin,
TangoConst {
    ParamTable motorDescriptor = new ParamTable();
    String tangoURL;
    final int specName = 0;
    final int specMulf = 1;
    final int specOffset = 2;
    DevHelper device;
    String device_name = null;
    String session_id = null;
    int nb_commands;
    CmdInfo[] commands;
    String[] attrs;
    AttrInfo[] attr_configs;
    final String SEP_COMMAND_NAME = "_____________";
    int getto_index;
    int setto_index;
    int setlim_index;
    public static int answerLimit = 2048;

    public boolean set_device_name(String devname) {
        this.device_name = devname;
        try {
            this.device = new DevHelper(this.device_name);
        }
        catch (DevHelperDevFailed e) {
            StringBuffer errmsg = new StringBuffer();
            errmsg.append("failed to import device: " + this.device_name + "\n");
            errmsg.append((Object)e);
            Stac_Out.println(errmsg.toString());
            return true;
        }
        catch (Exception e) {
            StringBuffer errmsg = new StringBuffer();
            errmsg.append("ORB failed connecting to database");
            Stac_Out.println(errmsg.toString());
            return true;
        }
        return false;
    }

    public Stac_BCMplugin_tango() {
        this.read_specdef(System.getProperty("SPECDEF"));
        try {
            this.tangoURL = this.motorDescriptor.getFirstStringValue("TANGOURL");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.set_device_name(this.tangoURL)) {
            Stac_Out.println("Could not connect to Tango device!");
        }
    }

    public void read_specdef(String specfile) {
        StacUtil utils = new StacUtil();
        String corr = utils.opReadCl(specfile);
        String[] tmp1 = corr.split("\n");
        int l = 0;
        while (l < tmp1.length) {
            String[] tmp2;
            if (!tmp1[l].startsWith("#", 0) && (tmp2 = tmp1[l].split("\\s+")).length != 0) {
                String value;
                String name;
                int offset = 0;
                if (tmp2[0].length() == 0) {
                    ++offset;
                }
                if ((name = tmp2[0 + offset]).equals("TANGOURL")) {
                    value = tmp2[1 + offset];
                    this.motorDescriptor.setSingleValue(name, value);
                } else if (name.equals("SOURCE")) {
                    value = tmp2[1 + offset];
                    this.motorDescriptor.setSingleValue(name, value);
                } else if (name.equals("BCM_Plugin")) {
                    value = tmp2[1 + offset];
                    this.motorDescriptor.setSingleValue(name, value);
                } else {
                    Vector<Object> params = new Vector<Object>();
                    String localid = tmp2[1 + offset];
                    params.addElement(localid);
                    Double mulfac = new Double(tmp2[2 + offset]);
                    params.addElement(mulfac);
                    Double offsetValue = new Double(tmp2[3 + offset]);
                    params.addElement(offsetValue);
                    this.motorDescriptor.setValueList(name, params);
                }
            }
            ++l;
        }
    }

    void update_specdef(String motorName, int parameter, double value) {
        try {
            if (parameter == 2) {
                StacUtil utils = new StacUtil();
                String corr = utils.opReadCl(System.getProperty("SPECDEF"));
                FileWriter newFile = new FileWriter(System.getProperty("SPECDEF"));
                String[] tmp1 = corr.split("\n");
                int l = 0;
                while (l < tmp1.length) {
                    if (tmp1[l].startsWith("#", 0)) {
                        newFile.write(String.valueOf(tmp1[l]) + "\n");
                    } else {
                        String[] tmp2 = tmp1[l].split("\\s+");
                        if (tmp2.length == 0) {
                            newFile.write(String.valueOf(tmp1[l]) + "\n");
                        } else {
                            String name;
                            int offset = 0;
                            if (tmp2[0].length() == 0) {
                                ++offset;
                            }
                            if ((name = tmp2[0 + offset]).equals(motorName)) {
                                int pos = 0;
                                while (pos < tmp2.length) {
                                    if (pos == parameter + 1) {
                                        newFile.write(String.valueOf(value) + "   ");
                                    } else {
                                        newFile.write(String.valueOf(tmp2[pos]) + "   ");
                                    }
                                    ++pos;
                                }
                                newFile.write("\n");
                            } else {
                                newFile.write(String.valueOf(tmp1[l]) + "\n");
                            }
                        }
                    }
                    ++l;
                }
                newFile.close();
                this.motorDescriptor.setDoubleValueAt(motorName, parameter, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    double tango_getAttr(String attr_name) {
        String ret_client_string = null;
        try {
            this.device.set_source(new Integer(this.motorDescriptor.getFirstStringValue("SOURCE")).intValue());
            ret_client_string = this.device.read_attr(attr_name);
        }
        catch (DevHelperDevFailed e) {
            StringBuffer errmsg = new StringBuffer();
            errmsg.append("failed reading attribute: " + attr_name + "\n");
            errmsg.append((Object)e);
            Stac_Out.println(errmsg.toString());
            return 0.0;
        }
        catch (Exception e) {
            StringBuffer errmsg = new StringBuffer();
            errmsg.append("Exception: " + e.getClass().getName() + "\n");
            errmsg.append("message:\t" + e.getMessage() + "\n");
            Stac_Out.println(errmsg.toString());
            return 0.0;
        }
        String[] tmp = ret_client_string.split("\n");
        int i = 0;
        while (i < tmp.length) {
            String[] tmp2;
            if (tmp[i] != null && (tmp2 = tmp[i].split(":")) != null && tmp2[0] != null && tmp2[0].equals("read point")) {
                return new Double(tmp2[1]);
            }
            ++i;
        }
        return 0.0;
    }

    void tango_setAttr(String attr_name, double newValue) {
        String ret_client_string = null;
        try {
            this.device.set_source(new Integer(this.motorDescriptor.getFirstStringValue("SOURCE")).intValue());
            Stac_Out.print("Moving " + attr_name + " to " + newValue + " ...");
            ret_client_string = this.device.write_attr(attr_name, "" + newValue);
            boolean inMove = true;
            do {
                ret_client_string = this.tango_CMD(this.motorDescriptor.getFirstStringValue("STATUSREQUEST"), "");
                String[] tmp = ret_client_string.split("\n");
                inMove = false;
                if (tmp[tmp.length - 1].equals(this.motorDescriptor.getFirstStringValue("STATUSOK"))) {
                    ret_client_string = "OK";
                    continue;
                }
                if (!tmp[tmp.length - 1].equals(this.motorDescriptor.getFirstStringValue("STATUSMOVE"))) continue;
                inMove = true;
            } while (inMove);
        }
        catch (DevHelperDevFailed e) {
            StringBuffer errmsg = new StringBuffer();
            errmsg.append("failed writing attribute: " + attr_name + "\n");
            errmsg.append((Object)e);
            Stac_Out.println(errmsg.toString());
            return;
        }
        catch (Exception e) {
            StringBuffer errmsg = new StringBuffer();
            errmsg.append("Exception: " + e.getClass().getName() + "\n");
            errmsg.append("message:\t" + e.getMessage() + "\n");
            Stac_Out.println(errmsg.toString());
            return;
        }
        Stac_Out.println(ret_client_string);
    }

    String tango_CMD(String cmd_name, String cmd_param) {
        String ret_client_string = null;
        try {
            this.device.set_source(new Integer(this.motorDescriptor.getFirstStringValue("SOURCE")).intValue());
            ret_client_string = this.device.exec_command(cmd_name, cmd_param, 0);
        }
        catch (DevHelperDevFailed e) {
            StringBuffer errmsg = new StringBuffer();
            errmsg.append("failed sending command: " + cmd_name + "\n");
            errmsg.append((Object)e);
            Stac_Out.println(errmsg.toString());
            return null;
        }
        catch (Exception e) {
            StringBuffer errmsg = new StringBuffer();
            errmsg.append("Exception: " + e.getClass().getName() + "\n");
            errmsg.append("message:\t" + e.getMessage() + "\n");
            Stac_Out.println(errmsg.toString());
            return null;
        }
        return ret_client_string;
    }

    AttrInfo tango_getAttrProperties(String attr_name) {
        Object ret_client_string = null;
        this.attrs = this.device.get_attribute_list();
        AttributeInfo[] tango_attr_configs = this.device.get_attribute_config();
        int nb_attrs = tango_attr_configs.length;
        this.attr_configs = new AttrInfo[nb_attrs];
        int attrId = 0;
        int i = 0;
        while (i < nb_attrs) {
            if (attr_name.equals(tango_attr_configs[i].name)) {
                this.attr_configs[i] = new AttrInfo(tango_attr_configs[i].name, ExecDev.AttrWriteType_to_string((AttrWriteType)tango_attr_configs[i].writable), ExecDev.AttrDataFormat_to_string((AttrDataFormat)tango_attr_configs[i].data_format), Tango_CmdArgTypeName[tango_attr_configs[i].data_type], tango_attr_configs[i].data_type, Integer.toString(tango_attr_configs[i].max_dim_x), Integer.toString(tango_attr_configs[i].max_dim_y), tango_attr_configs[i].description, tango_attr_configs[i].label, tango_attr_configs[i].unit, tango_attr_configs[i].standard_unit, tango_attr_configs[i].display_unit, tango_attr_configs[i].format, tango_attr_configs[i].min_value, tango_attr_configs[i].max_value, tango_attr_configs[i].min_alarm, tango_attr_configs[i].max_alarm);
                attrId = i;
                break;
            }
            ++i;
        }
        if (attrId < nb_attrs) {
            Stac_Out.println("Attribute (" + attr_name + ") is read");
        } else {
            Stac_Out.println("Attribute (" + attr_name + ") is not available");
        }
        return this.attr_configs[attrId];
    }

    void spec_getMotor(String motorName) {
    }

    public double getMotorPosition(String motorName) throws Exception {
        return this.convertMotorPosition_Plugin2Stac(motorName, this.tango_getAttr(this.motorDescriptor.getFirstStringValue(motorName)));
    }

    public void setMotorPosition(String motorName, double newValue) throws Exception {
        double currentValue = this.getMotorPosition(motorName);
        double actualOffset = this.motorDescriptor.getDoubleValueAt(motorName, 2);
        double newOffset = -newValue * this.motorDescriptor.getDoubleValueAt(motorName, 1) + currentValue * this.motorDescriptor.getDoubleValueAt(motorName, 1) + this.motorDescriptor.getDoubleValueAt(motorName, 2);
        this.update_specdef(motorName, 2, newOffset);
    }

    public void moveMotor(String motorName, double newValue) throws Exception {
        this.tango_setAttr(this.motorDescriptor.getFirstStringValue(motorName), this.convertMotorPosition_Stac2Plugin(motorName, newValue));
    }

    public double getMotorSpeed(String motorName) throws Exception {
        return 1.0;
    }

    public ParamTable getMotorParams(String motorName) throws Exception {
        ParamTable params = new ParamTable();
        params.setSingleDoubleValue("pos", this.getMotorPosition(motorName));
        AttrInfo attr_cfg = this.tango_getAttrProperties(this.motorDescriptor.getFirstStringValue(motorName));
        double minpos = this.convertMotorPosition_Plugin2Stac(motorName, new Double(attr_cfg.min_value));
        double maxpos = this.convertMotorPosition_Plugin2Stac(motorName, new Double(attr_cfg.max_value));
        params.setSingleDoubleValue("minpos", Math.min(minpos, maxpos));
        params.setSingleDoubleValue("maxpos", Math.max(minpos, maxpos));
        params.setSingleDoubleValue("speed", this.getMotorSpeed(motorName));
        params.setSingleDoubleValue("minspeed", this.getMotorSpeedLowLimit(motorName));
        return params;
    }

    public double getMotorSpeedLowLimit(String motorName) throws Exception {
        return 1.0;
    }

    public void setMotorSpeed(String motorName, double newValue) throws Exception {
    }

    public void moveMotors(ParamTable newPositions) throws Exception {
        this.moveMotorsSyncronized(newPositions);
    }

    public void moveMotorsSyncronized(ParamTable newPositions) throws Exception {
        String double_array = new String("[ ");
        String string_array = new String("[ ");
        int i = 0;
        while (i < newPositions.pnames.size()) {
            String motorName = (String)newPositions.pnames.elementAt(i);
            if (i > 0) {
                string_array = string_array.concat(", ");
            }
            string_array = string_array.concat(String.valueOf(this.motorDescriptor.getFirstStringValue(motorName)) + " ");
            double newpos = newPositions.getFirstDoubleValue(motorName);
            if (i > 0) {
                double_array = double_array.concat(", ");
            }
            double_array = double_array.concat(this.convertMotorPosition_Stac2Plugin(motorName, newpos) + " ");
            ++i;
        }
        string_array = string_array.concat(" ] ");
        double_array = double_array.concat(" ] ");
        Stac_Out.print("Synchronised DatumTrans Movement " + double_array + "...");
        String ret_client_string = this.tango_CMD(this.motorDescriptor.getFirstStringValue("SYNC_MOVE"), String.valueOf(double_array) + string_array);
        boolean moving = true;
        do {
            String[] tmp;
            if ((tmp = (ret_client_string = this.tango_CMD(this.motorDescriptor.getFirstStringValue("STATUSREQUEST"), "")).split("\n"))[tmp.length - 1].equals(this.motorDescriptor.getFirstStringValue("STATUSOK"))) {
                ret_client_string = "DONE";
                moving = false;
                continue;
            }
            if (tmp[tmp.length - 1].equalsIgnoreCase("MOVING")) continue;
            ret_client_string = "FAILED";
            moving = false;
        } while (moving);
        Stac_Out.println(ret_client_string);
    }

    public void initMotors() throws Exception {
    }

    public boolean checkDatumTrans(Point3d dat, Point3d trans) {
        boolean valid = true;
        if (dat.y > 270.0) {
            return false;
        }
        return valid;
    }

    public double convertMotorPosition_Plugin2Stac(String motorName, double pluginPos) {
        double stacPos = (pluginPos - this.motorDescriptor.getDoubleValueAt(motorName, 2)) / this.motorDescriptor.getDoubleValueAt(motorName, 1);
        return stacPos;
    }

    public double convertMotorPosition_Stac2Plugin(String motorName, double stacPos) {
        double pluginPos = stacPos * this.motorDescriptor.getDoubleValueAt(motorName, 1) + this.motorDescriptor.getDoubleValueAt(motorName, 2);
        return pluginPos;
    }

    public double loadMotorPosition(String motorName, String data) {
        String spec_motorName = new String(this.motorDescriptor.getFirstStringValue(motorName));
        String[] tmp1 = data.split("\n");
        int l = 0;
        while (l < tmp1.length) {
            String[] tmp2;
            if (!tmp1[l].startsWith("#", 0) && (tmp2 = tmp1[l].split("\\s+")).length != 0) {
                int offset = 0;
                if (tmp2[0].length() == 0) {
                    ++offset;
                }
                if (offset < tmp2.length) {
                    String name = tmp2[0 + offset];
                    String value = tmp2[1 + offset];
                    if (name.equalsIgnoreCase(spec_motorName)) {
                        return this.convertMotorPosition_Plugin2Stac(motorName, new Double(value));
                    }
                }
            }
            ++l;
        }
        return 0.0;
    }

    public void saveMotorPositions(ParamTable positions, String data) {
        int i = 0;
        while (i < positions.pnames.size()) {
            String motorName = (String)positions.pnames.elementAt(i);
            double newValue = positions.getFirstDoubleValue(motorName);
            data.concat(String.valueOf(this.motorDescriptor.getFirstStringValue(motorName)) + "  " + this.convertMotorPosition_Stac2Plugin(motorName, newValue) + "\n");
            ++i;
        }
    }
}

