/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import stacgui.PrintfFormat;
import stacgui.StacUtil;
import stacgui.Stac_BCMplugin;
import stacgui.Stac_BCMplugin_esrf_user;
import stacgui.Stac_Out;

public class Stac_BCMplugin_esrf_safe
extends Stac_BCMplugin_esrf_user
implements Stac_BCMplugin {
    final int specOffset = 2;
    final int dialOffset = 3;

    String spec_getPosition_dial() {
        return new String("getDialPosition");
    }

    public void read_specdef_general(Vector params, String[] lineTokenized, int tokenOffset) {
        if (lineTokenized.length <= tokenOffset + 4) {
            return;
        }
        String localid = lineTokenized[1 + tokenOffset];
        params.addElement(localid);
        Double mulfac = new Double(lineTokenized[2 + tokenOffset]);
        params.addElement(mulfac);
        Double offsetValue = new Double(lineTokenized[3 + tokenOffset]);
        params.addElement(offsetValue);
        Double dialOffsetValue = new Double(lineTokenized[4 + tokenOffset]);
        params.addElement(dialOffsetValue);
    }

    void spec_getMotor(String motorName) {
        boolean finalized = false;
        while (!finalized) {
            String PyCommand = new String();
            try {
                String outfile = "spec_cmd.py";
                FileWriter dstStream = new FileWriter(outfile);
                PyCommand = new PrintfFormat("#! /usr/bin/env python\nimport sys\nfrom SpecClient import *\nm=SpecMotor.SpecMotor('%s','%s',500)\np=m." + this.spec_getPosition() + "()\n" + "print 'position_of_the_specified_motor_is: ',p\n" + "p=m." + this.spec_getPosition_dial() + "()\n" + "print 'dial_position_of_the_specified_motor_is: ',p\n" + "cmd=SpecCommand.SpecCommand('','%s',500)\n" + "print 'speed_of_the_specified_motor_is: ' , cmd.executeCommand('motor_par(%s,\"velocity\")')\n" + "print 'lowest_speed_of_the_specified_motor_is: ' , cmd.executeCommand('motor_par(%s,\"base_rate\")')\n" + "print 'stepsize_of_the_specified_motor_is: ' , cmd.executeCommand('motor_par(%s,\"step_size\")')\n" + "print 'low_limit_of_the_specified_motor_is: ',cmd.executeCommand('" + this.spec_to_plugin_value(motorName, "get_lim(%s,-1)") + "')\n" + "print 'high_limit_of_the_specified_motor_is: ',cmd.executeCommand('" + this.spec_to_plugin_value(motorName, "get_lim(%s,1)") + "')\n").sprintf(new Object[]{motorName, this.specversion, this.specversion, motorName, motorName, motorName, motorName, motorName});
                dstStream.write(PyCommand);
                dstStream.flush();
                dstStream.close();
            }
            catch (IOException e) {
                Stac_Out.println("Problem with generating the spec_cmd.py file");
            }
            Stac_Out.println("Get MotorProperties (" + motorName + ")");
            int exitval = 1;
            int i = 0;
            while (i < 3 && exitval != 0) {
                exitval = this.spec_comm.spec_exec(PyCommand);
                ++i;
            }
            finalized = true;
            if (exitval != 0) continue;
            try {
                double diff;
                String STAC_motorName = (String)this.motorDescriptor.getNameForParam(motorName);
                double userValue = new Double(this.getParam("position_of_the_specified_motor_is:"));
                double dialValue = new Double(this.getParam("dial_position_of_the_specified_motor_is:"));
                double desiredUser = dialValue + this.motorDescriptor.getDoubleValueAt(this.motorDescriptor.getNameForParam(motorName), 3);
                if (STAC_motorName.equalsIgnoreCase("Omega") || STAC_motorName.equalsIgnoreCase("Kappa") || STAC_motorName.equalsIgnoreCase("Phi")) {
                    StacUtil utils = new StacUtil();
                    diff = utils.angleDegreeDiff(userValue, desiredUser);
                } else {
                    diff = Math.abs(userValue - desiredUser);
                }
                if (!(diff > 0.01)) continue;
                Stac_Out.println("WARNING!!!\nSpec user/dial offset has been changed:");
                Stac_Out.println("Spec Motor Name:      " + motorName);
                Stac_Out.println("Current dial value:   " + dialValue);
                Stac_Out.println("Current user value:   " + userValue);
                Stac_Out.println("user value should be: " + desiredUser);
                finalized = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setMotorPosition(String motorName, double newValue) throws Exception {
        double currentValue = this.getMotorPosition(motorName);
        double actualOffset = this.motorDescriptor.getDoubleValueAt(motorName, 2);
        double newOffset = -newValue * this.motorDescriptor.getDoubleValueAt(motorName, 1) + currentValue * this.motorDescriptor.getDoubleValueAt(motorName, 1) + this.motorDescriptor.getDoubleValueAt(motorName, 2);
        Vector motorParam = this.motorDescriptor.getValueList(motorName);
        motorParam.removeElementAt(2);
        motorParam.insertElementAt(new Double(newOffset), 2);
        double userValue = new Double(this.getParam("position_of_the_specified_motor_is:"));
        double dialValue = new Double(this.getParam("dial_position_of_the_specified_motor_is:"));
        double dialOffsetValue = userValue - dialValue;
        motorParam.removeElementAt(3);
        motorParam.insertElementAt(new Double(dialOffsetValue), 3);
        this.update_specdef(motorName, motorParam);
    }

    public void initMotors() throws Exception {
        super.initMotors();
        this.setMotorPosition("Omega", this.getMotorPosition("Omega"));
        this.setMotorPosition("Kappa", this.getMotorPosition("Kappa"));
        this.setMotorPosition("Phi", this.getMotorPosition("Phi"));
    }

    public String getCreditString() {
        return "using BCM-esrfSAFE";
    }
}

