/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Point3d;
import stacgui.ParamTable;
import stacgui.PrintfFormat;
import stacgui.StacUtil;
import stacgui.Stac_BCMplugin;
import stacgui.Stac_BCMplugin_base;
import stacgui.Stac_Out;
import stacgui.spec_communicator_HTTP;

public class Stac_BCMplugin_esrf
extends Stac_BCMplugin_base
implements Stac_BCMplugin {
    ParamTable motorDescriptor;
    String specversion;
    final int specName = 0;
    final int specMulf = 1;
    spec_communicator_HTTP spec_comm = null;

    String spec_mv() {
        return new String("mv");
    }

    String spec_set() {
        return new String("set");
    }

    String spec_getPosition() {
        return new String("getPosition");
    }

    String ProDC_MotorNameSuffix() {
        return new String("");
    }

    public String getCreditString() {
        return "using BCM-esrf";
    }

    public void initPlugin() {
        this.spec_comm = new spec_communicator_HTTP(this.session);
        this.motorDescriptor = new ParamTable();
        this.read_specdef(System.getProperty("SPECDEF"));
        try {
            this.specversion = this.motorDescriptor.getFirstStringValue("SPECVERSION");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void read_specdef(String specfile) {
        StacUtil utils = new StacUtil();
        String corr = utils.opReadCl(specfile);
        String[] tmp1 = corr.split("\n");
        int l = 0;
        while (l < tmp1.length) {
            String[] tmp2;
            if (!tmp1[l].startsWith("#", 0) && (tmp2 = tmp1[l].split("\\s+")).length != 0) {
                String value;
                String name;
                int offset = 0;
                if (tmp2[0].length() == 0) {
                    ++offset;
                }
                if ((name = tmp2[0 + offset]).equals("SPECVERSION")) {
                    value = tmp2[1 + offset];
                    this.motorDescriptor.setSingleValue(name, value);
                } else if (name.equals("BCM_Plugin")) {
                    value = tmp2[1 + offset];
                    this.motorDescriptor.setSingleValue(name, value);
                } else if (name.equals("INITSTRING")) {
                    value = new String("");
                    int i = 1 + offset;
                    while (i < tmp2.length) {
                        value = value.concat(String.valueOf(tmp2[i]) + " ");
                        ++i;
                    }
                    this.motorDescriptor.setSingleValue(name, value);
                } else {
                    Vector<Object> params = new Vector<Object>();
                    String localid = tmp2[1 + offset];
                    params.addElement(localid);
                    Double mulfac = new Double(tmp2[2 + offset]);
                    params.addElement(mulfac);
                    this.motorDescriptor.setValueList(name, params);
                }
            }
            ++l;
        }
    }

    void spec_cmd(String command) {
        String PyCommand = new String();
        try {
            String outfile = "spec_cmd.py";
            FileWriter dstStream = new FileWriter(outfile);
            PyCommand = new PrintfFormat("#! /usr/bin/env python\nimport sys\nfrom SpecClient import *\ntry:\n  cmd=SpecCommand.SpecCommand('','%s',500)\n  cmd=SpecCommand.SpecCommand('','%s')\n  cmd.executeCommand(\"%s\")\nexcept:\n  print 'Could not connect to the spec server!'\n").sprintf(new Object[]{this.specversion, this.specversion, command});
            dstStream.write(PyCommand);
            dstStream.flush();
            dstStream.close();
        }
        catch (IOException e) {
            Stac_Out.println("Problem with generating the spec_cmd.py file");
        }
        Stac_Out.println("Sending Spec Command (" + command + ")");
        int exitval = 1;
        int i = 0;
        while (i < 3 && exitval != 0) {
            exitval = this.spec_comm.spec_exec(PyCommand);
            ++i;
        }
    }

    void spec_getMotor(String motorName) {
        String PyCommand = new String();
        try {
            String outfile = "spec_cmd.py";
            FileWriter dstStream = new FileWriter(outfile);
            PyCommand = new PrintfFormat("#! /usr/bin/env python\nimport sys\nfrom SpecClient import *\nm=SpecMotor.SpecMotor('%s','%s',500)\np=m." + this.spec_getPosition() + "()\n" + "print 'position_of_the_specified_motor_is: ',p\n" + "cmd=SpecCommand.SpecCommand('','%s',500)\n" + "print 'speed_of_the_specified_motor_is: ' , cmd.executeCommand('motor_par(%s,\"velocity\")')\n" + "print 'lowest_speed_of_the_specified_motor_is: ' , cmd.executeCommand('motor_par(%s,\"base_rate\")')\n" + "print 'stepsize_of_the_specified_motor_is: ' , cmd.executeCommand('motor_par(%s,\"step_size\")')\n" + "print 'low_limit_of_the_specified_motor_is: ',cmd.executeCommand('" + this.spec_to_plugin_value(motorName, "get_lim(%s,-1)") + "')\n" + "print 'high_limit_of_the_specified_motor_is: ',cmd.executeCommand('" + this.spec_to_plugin_value(motorName, "get_lim(%s,1)") + "')\n" + "print 'name of the specified motor is: ','%s'").sprintf(new Object[]{motorName, this.specversion, this.specversion, motorName, motorName, motorName, motorName, motorName, motorName});
            dstStream.write(PyCommand);
            dstStream.flush();
            dstStream.close();
        }
        catch (IOException e) {
            Stac_Out.println("Problem with generating the spec_cmd.py file");
        }
        Stac_Out.println("Get MotorProperties (" + motorName + ")");
        int exitval = 1;
        int i = 0;
        while (i < 3 && exitval != 0) {
            exitval = this.spec_comm.spec_exec(PyCommand);
            ++i;
        }
    }

    String getParam(String mask) throws IOException {
        String value = new String("0");
        boolean set = false;
        StacUtil utils = new StacUtil();
        String corr = utils.opReadCl("spec_cmd.out");
        String[] tmp1 = corr.split("\n");
        int l = 0;
        while (l < tmp1.length) {
            int offset;
            String[] tmp2;
            String name;
            if (!tmp1[l].startsWith("#", 0) && (name = (tmp2 = tmp1[l].split("\\s+"))[0 + (offset = 0)]).equals(mask)) {
                value = tmp2[1 + offset];
                set = true;
            }
            ++l;
        }
        if (!set) {
            throw new IOException("Failed to read spec parameter");
        }
        return value;
    }

    double spec_getMotorParam(String motorName, String mask) {
        String pos = null;
        boolean exitval = true;
        int i = 0;
        while (i < 3 && exitval) {
            try {
                this.spec_getMotor(motorName);
                pos = this.getParam(mask);
                exitval = false;
            }
            catch (IOException e) {
                Stac_Out.println(e.getMessage());
                pos = new String("0");
            }
            ++i;
        }
        return new Double(pos);
    }

    public double getMotorPosition(String motorName) throws Exception {
        return this.convertMotorPosition_Plugin2Stac(motorName, this.spec_getMotorParam(this.motorDescriptor.getFirstStringValue(motorName), "position_of_the_specified_motor_is:"));
    }

    public void setMotorPosition(String motorName, double newValue) throws Exception {
        this.spec_cmd(String.valueOf(this.spec_set()) + " " + this.motorDescriptor.getFirstStringValue(motorName) + " " + newValue * this.motorDescriptor.getDoubleValueAt(motorName, 1));
    }

    public void moveMotor(String motorName, double newValue) throws Exception {
        this.spec_cmd(String.valueOf(this.spec_mv()) + " " + this.motorDescriptor.getFirstStringValue(motorName) + " " + this.convertMotorPosition_Stac2Plugin(motorName, newValue));
    }

    public double getMotorSpeed(String motorName) throws Exception {
        return this.spec_getMotorParam(this.motorDescriptor.getFirstStringValue(motorName), "speed_of_the_specified_motor_is:") / this.motorDescriptor.getDoubleValueAt(motorName, 1);
    }

    public ParamTable getMotorParams(String motorName) throws Exception {
        ParamTable params = new ParamTable();
        this.spec_getMotor(this.motorDescriptor.getFirstStringValue(motorName));
        double minpos = this.convertMotorPosition_Plugin2Stac(motorName, new Double(this.getParam("low_limit_of_the_specified_motor_is:")));
        double maxpos = this.convertMotorPosition_Plugin2Stac(motorName, new Double(this.getParam("high_limit_of_the_specified_motor_is:")));
        params.setSingleDoubleValue("pos", this.convertMotorPosition_Plugin2Stac(motorName, new Double(this.getParam("position_of_the_specified_motor_is:"))));
        params.setSingleDoubleValue("minpos", Math.min(minpos, maxpos));
        params.setSingleDoubleValue("maxpos", Math.max(minpos, maxpos));
        params.setSingleDoubleValue("speed", new Double(this.getParam("speed_of_the_specified_motor_is:")) / new Double(this.getParam("stepsize_of_the_specified_motor_is:")));
        params.setSingleDoubleValue("minspeed", new Double(this.getParam("lowest_speed_of_the_specified_motor_is:")) / new Double(this.getParam("stepsize_of_the_specified_motor_is:")));
        params.setSingleDoubleValue("steps", new Double(this.getParam("stepsize_of_the_specified_motor_is:")));
        return params;
    }

    public double getMotorSpeedLowLimit(String motorName) throws Exception {
        return this.spec_getMotorParam(this.motorDescriptor.getFirstStringValue(motorName), "lowest_speed_of_the_specified_motor_is:") / this.motorDescriptor.getDoubleValueAt(motorName, 1);
    }

    public void setMotorSpeed(String motorName, double newValue) throws Exception {
        this.spec_cmd("motor_par(" + this.motorDescriptor.getFirstStringValue(motorName) + ",'velocity'," + newValue + ")");
    }

    public void moveMotors(ParamTable newPositions) throws Exception {
        String cmd = "";
        int i = 0;
        while (i < newPositions.pnames.size()) {
            if (i != 0) {
                cmd = cmd.concat(";");
            }
            String motorName = (String)newPositions.pnames.elementAt(i);
            double newValue = newPositions.getFirstDoubleValue(motorName);
            cmd = cmd.concat("A[" + this.motorDescriptor.getFirstStringValue(motorName) + "]=" + this.spec_A_value(this.motorDescriptor.getFirstStringValue(motorName), this.convertMotorPosition_Stac2Plugin(motorName, newValue)));
            ++i;
        }
        cmd = cmd.concat(";move_all;wait(0)");
        this.spec_cmd(cmd);
    }

    public String spec_A_value(String specMotorName, double value) {
        String A_value = new String("" + value);
        return A_value;
    }

    public String spec_to_plugin_value(String specMotorName, String value) {
        String plugin_value = new String("dial(" + specMotorName + "," + value + ")");
        return plugin_value;
    }

    public void moveMotorsSyncronized_old(ParamTable newPositions) throws Exception {
        this.moveMotors(newPositions);
    }

    public void moveMotorsSyncronized(ParamTable newPositions) throws Exception {
        String motorName;
        ParamTable oldvalues = new ParamTable();
        double time = 0.0;
        int i = 0;
        while (i < newPositions.pnames.size()) {
            String motorName2 = (String)newPositions.pnames.elementAt(i);
            String pos = new String("0");
            String steps = new String("0");
            String vel = new String("0");
            String velLimit = new String("0");
            boolean exitval = true;
            int j = 0;
            while (j < 3 && exitval) {
                try {
                    this.spec_getMotor(this.motorDescriptor.getFirstStringValue(motorName2));
                    pos = this.getParam("position_of_the_specified_motor_is:");
                    steps = this.getParam("stepsize_of_the_specified_motor_is:");
                    vel = this.getParam("speed_of_the_specified_motor_is:");
                    velLimit = this.getParam("lowest_speed_of_the_specified_motor_is:");
                    exitval = false;
                }
                catch (IOException e) {
                    Stac_Out.println(e.getMessage());
                }
                ++j;
            }
            double oldpos = this.convertMotorPosition_Plugin2Stac(motorName2, new Double(pos));
            double newpos = newPositions.getFirstDoubleValue(motorName2);
            double stepsize = new Double(steps) * this.motorDescriptor.getDoubleValueAt(motorName2, 1);
            double velocity = new Double(vel);
            double velocityLimit = new Double(velLimit);
            double A = Math.abs(newpos - oldpos) * Math.abs(stepsize);
            oldvalues.setDoubleValueList(motorName2, new double[]{velocity, A, velocityLimit});
            time = Math.max(time, A / Math.abs(velocity));
            ++i;
        }
        double time_max = time;
        int i2 = 0;
        while (i2 < newPositions.pnames.size()) {
            motorName = (String)newPositions.pnames.elementAt(i2);
            double velocity = oldvalues.getDoubleValueAt(motorName, 0);
            double A = oldvalues.getDoubleValueAt(motorName, 1);
            double velocityLimit = oldvalues.getDoubleValueAt(motorName, 2);
            double velocity_new = Math.max(A / time_max, 1.0) * (double)(velocity < 0.0 ? -1 : 1);
            this.setMotorSpeed(motorName, Math.min(velocity, Math.max(velocity_new, velocityLimit)));
            ++i2;
        }
        this.moveMotors(newPositions);
        i2 = 0;
        while (i2 < newPositions.pnames.size()) {
            motorName = (String)newPositions.pnames.elementAt(i2);
            double velocity = oldvalues.getDoubleValueAt(motorName, 0);
            this.setMotorSpeed(motorName, velocity);
            ++i2;
        }
    }

    public void initMotors() throws Exception {
        String cmd = this.motorDescriptor.getFirstStringValue("INITSTRING");
        this.spec_cmd(cmd);
    }

    public boolean checkDatumTrans(Point3d dat, Point3d trans) {
        boolean valid = true;
        if (dat.y > 270.0) {
            return false;
        }
        return valid;
    }

    public double convertMotorPosition_Plugin2Stac(String motorName, double pluginPos) {
        double stacPos = pluginPos / this.motorDescriptor.getDoubleValueAt(motorName, 1);
        return stacPos;
    }

    public double convertMotorPosition_Stac2Plugin(String motorName, double stacPos) {
        double pluginPos = stacPos * this.motorDescriptor.getDoubleValueAt(motorName, 1);
        return pluginPos;
    }

    public double loadMotorPosition(String motorName, String data) {
        String spec_motorName = new String(this.motorDescriptor.getFirstStringValue(motorName));
        String[] tmp1 = data.split("\n");
        int l = 0;
        while (l < tmp1.length) {
            String[] tmp2;
            if (!tmp1[l].startsWith("#", 0) && (tmp2 = tmp1[l].split("\\s+")).length != 0) {
                int offset = 0;
                if (tmp2[0].length() == 0) {
                    ++offset;
                }
                if (offset < tmp2.length) {
                    String name = tmp2[0 + offset];
                    String value = tmp2[1 + offset];
                    if (name.equalsIgnoreCase(String.valueOf(spec_motorName) + this.ProDC_MotorNameSuffix())) {
                        return this.convertMotorPosition_Plugin2Stac(motorName, new Double(value));
                    }
                }
            }
            ++l;
        }
        return 0.0;
    }

    public void saveMotorPositions(ParamTable positions, String data) {
        int i = 0;
        while (i < positions.pnames.size()) {
            String motorName = (String)positions.pnames.elementAt(i);
            double newValue = positions.getFirstDoubleValue(motorName);
            data.concat(String.valueOf(this.motorDescriptor.getFirstStringValue(motorName)) + "  " + this.convertMotorPosition_Stac2Plugin(motorName, newValue) + "\n");
            ++i;
        }
    }
}

