/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.io.FileWriter;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import stacgui.ParamTable;
import stacgui.StacUtil;
import stacgui.Stac_BCMplugin;
import stacgui.Stac_Plugin;

public class Stac_BCMplugin_base
extends Stac_Plugin
implements Stac_BCMplugin {
    int ct = 0;

    public double getMotorPosition(String motorName) throws Exception {
        return 11 + this.ct;
    }

    public void setMotorPosition(String motorName, double newValue) throws Exception {
    }

    public void moveMotor(String motorName, double newValue) throws Exception {
        ++this.ct;
    }

    public double getMotorSpeed(String motorName) throws Exception {
        return 10.0;
    }

    public double getMotorSpeedLowLimit(String motorName) throws Exception {
        return 1.0;
    }

    public void setMotorSpeed(String motorName, double newValue) throws Exception {
    }

    public ParamTable getMotorParams(String motorName) throws Exception {
        ParamTable params = new ParamTable();
        double minpos = 0.0;
        double maxpos = 270.0;
        params.setSingleDoubleValue("pos", this.getMotorPosition(motorName));
        params.setSingleDoubleValue("minpos", Math.min(minpos, maxpos));
        params.setSingleDoubleValue("maxpos", Math.max(minpos, maxpos));
        params.setSingleDoubleValue("speed", this.getMotorSpeed(motorName));
        params.setSingleDoubleValue("minspeed", this.getMotorSpeedLowLimit(motorName));
        return params;
    }

    public void moveMotors(ParamTable newPositions) throws Exception {
    }

    public void moveMotorsSyncronized(ParamTable newPositions) throws Exception {
    }

    public void initMotors() throws Exception {
    }

    public double loadMotorPosition(String motorName, String data) {
        return 0.0;
    }

    public void saveMotorPositions(ParamTable positions, String data) {
    }

    public boolean checkDatumTrans(Point3d dat, Point3d trans) {
        return true;
    }

    public double convertMotorPosition_Plugin2Stac(String motorName, double pluginPos) {
        return pluginPos;
    }

    public double convertMotorPosition_Stac2Plugin(String motorName, double stacPos) {
        return stacPos;
    }

    public void interpret_specdef(String specline, ParamTable Descr) {
        String name;
        if (specline.startsWith("#", 0)) {
            return;
        }
        String[] tmp2 = specline.split("\\s+");
        if (tmp2.length == 0) {
            return;
        }
        int offset = 0;
        if (tmp2[0].length() == 0) {
            ++offset;
        }
        if ((name = tmp2[0 + offset]).equals("BCM_Plugin")) {
            String value = tmp2[1 + offset];
            Descr.setSingleValue(name, value);
        } else {
            String value = tmp2[1 + offset];
            int i = 2 + offset;
            while (i < tmp2.length) {
                value = String.valueOf(value) + " " + tmp2[i];
                ++i;
            }
            Descr.setSingleValue(name, value);
        }
    }

    public void read_specdef(String specfile, ParamTable Descr) {
        StacUtil utils = new StacUtil();
        String corr = utils.opReadCl(specfile);
        String[] tmp1 = corr.split("\n");
        int l = 0;
        while (l < tmp1.length) {
            this.interpret_specdef(tmp1[l], Descr);
            ++l;
        }
    }

    public void update_specdef(ParamTable BCM_Descriptor, ParamTable newParams) {
        try {
            StacUtil utils = new StacUtil();
            String corr = utils.opReadCl(System.getProperty("SPECDEF"));
            FileWriter newFile = new FileWriter(System.getProperty("SPECDEF"));
            String[] tmp1 = corr.split("\n");
            int l = 0;
            while (l < tmp1.length) {
                if (tmp1[l].startsWith("#", 0)) {
                    newFile.write(String.valueOf(tmp1[l]) + "\n");
                } else {
                    String[] tmp2 = tmp1[l].split("\\s+");
                    if (tmp2.length == 0) {
                        newFile.write(String.valueOf(tmp1[l]) + "\n");
                    } else {
                        String name;
                        Vector paramVal;
                        int offset = 0;
                        if (tmp2[0].length() == 0) {
                            ++offset;
                        }
                        if ((paramVal = newParams.getValueList(name = tmp2[0 + offset])) != null) {
                            String actParam = "";
                            newFile.write(name);
                            int li = 0;
                            while (li < paramVal.size()) {
                                actParam = String.valueOf(actParam) + " " + paramVal.elementAt(li);
                                ++li;
                            }
                            newFile.write(actParam);
                            newFile.write("\n");
                            this.interpret_specdef(String.valueOf(name) + actParam, BCM_Descriptor);
                            newParams.removeOldValueList(name);
                        } else {
                            newFile.write(String.valueOf(tmp1[l]) + "\n");
                        }
                    }
                }
                ++l;
            }
            int i = 0;
            while (i < newParams.pnames.size()) {
                String actParam = "";
                newFile.write("" + newParams.pnames.elementAt(i));
                int li = 0;
                while (li < ((Vector)newParams.pvalues.elementAt(i)).size()) {
                    actParam = String.valueOf(actParam) + " " + ((Vector)newParams.pvalues.elementAt(i)).elementAt(li);
                    ++li;
                }
                newFile.write(actParam);
                newFile.write("\n");
                this.interpret_specdef(newParams.pnames.elementAt(i) + actParam, BCM_Descriptor);
                ++i;
            }
            newFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getCalibration(ParamTable BCM_Descriptor, Vector3d[] okp) {
        int l = 0;
        while (l < 7) {
            okp[l] = new Vector3d();
            ++l;
        }
        String[] data = BCM_Descriptor.getFirstStringValue("OmegaRot").split("\\s+");
        okp[0].set(new Double(data[0]).doubleValue(), new Double(data[1]).doubleValue(), new Double(data[2]).doubleValue());
        data = BCM_Descriptor.getFirstStringValue("KappaRot").split("\\s+");
        okp[1].set(new Double(data[0]).doubleValue(), new Double(data[1]).doubleValue(), new Double(data[2]).doubleValue());
        data = BCM_Descriptor.getFirstStringValue("PhiRot").split("\\s+");
        okp[2].set(new Double(data[0]).doubleValue(), new Double(data[1]).doubleValue(), new Double(data[2]).doubleValue());
        data = BCM_Descriptor.getFirstStringValue("KappaTrans").split("\\s+");
        okp[3].set(new Double(data[0]).doubleValue(), new Double(data[1]).doubleValue(), new Double(data[2]).doubleValue());
        data = BCM_Descriptor.getFirstStringValue("PhiTrans").split("\\s+");
        okp[4].set(new Double(data[0]).doubleValue(), new Double(data[1]).doubleValue(), new Double(data[2]).doubleValue());
        data = BCM_Descriptor.getFirstStringValue("KappaTransD").split("\\s+");
        okp[5].set(new Double(data[0]).doubleValue(), new Double(data[1]).doubleValue(), new Double(data[2]).doubleValue());
        data = BCM_Descriptor.getFirstStringValue("PhiTransD").split("\\s+");
        okp[6].set(new Double(data[0]).doubleValue(), new Double(data[1]).doubleValue(), new Double(data[2]).doubleValue());
    }

    public void setCalibration(ParamTable BCM_Descriptor, Vector3d[] par) {
        ParamTable newValues = new ParamTable();
        newValues.setSingleValue("OmegaRot", par[0].x + " " + par[0].y + " " + par[0].z);
        newValues.setSingleValue("KappaRot", par[1].x + " " + par[1].y + " " + par[1].z);
        newValues.setSingleValue("PhiRot", par[2].x + " " + par[2].y + " " + par[2].z);
        newValues.setSingleValue("KappaTrans", par[3].x + " " + par[3].y + " " + par[3].z);
        newValues.setSingleValue("PhiTrans", par[4].x + " " + par[4].y + " " + par[4].z);
        newValues.setSingleValue("KappaTransD", par[5].x + " " + par[5].y + " " + par[5].z);
        newValues.setSingleValue("PhiTransD", par[6].x + " " + par[6].y + " " + par[6].z);
        this.update_specdef(BCM_Descriptor, newValues);
    }

    public void setCalibration(ParamTable BCM_Descriptor, String gnsfile, StacUtil utils) {
        Vector3d[] okp = new Vector3d[7];
        utils.read_gnsdef(gnsfile, okp);
        this.setCalibration(BCM_Descriptor, okp);
    }

    public void initPlugin() {
    }

    public String getCreditString() {
        return "using BCM-base";
    }
}

