/*
 * Decompiled with CFR 0.152.
 */
package stacgui;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import stacgui.StacBCM;
import stacgui.StacUtil;
import stacgui.Stac_ReqMsg;
import stacgui.Stac_Session;

public class Stac_AlignmentReqMsg
extends Stac_ReqMsg {
    String OMfile;
    Vector3d datum;
    Point3d trans;
    Vector orientations;
    StacBCM bcm;
    StacUtil utils;

    public Stac_AlignmentReqMsg(Stac_Session session) {
        super(session);
    }

    public Stac_AlignmentReqMsg(Stac_Session session, String OMfile, Vector3d datum, Point3d trans, Vector orientations, StacBCM bcm, StacUtil utils) {
        super(session);
        this.set_OMfile(OMfile);
        this.set_datum(datum);
        this.set_trans(trans);
        this.set_orienattions(orientations);
        this.set_bcm(bcm);
        this.set_utils(utils);
    }

    public String get_OMfile() {
        return this.OMfile;
    }

    public Vector3d get_datum() {
        return this.datum;
    }

    public Point3d get_trans() {
        return this.trans;
    }

    public Vector get_orienattions() {
        return this.orientations;
    }

    public StacBCM get_bcm() {
        return this.bcm;
    }

    public StacUtil get_utils() {
        return this.utils;
    }

    public void set_OMfile(String OMfile) {
        this.OMfile = OMfile;
    }

    public void set_datum(Vector3d datum) {
        this.datum = datum;
    }

    public void set_trans(Point3d trans) {
        this.trans = trans;
    }

    public void set_orienattions(Vector orientations) {
        this.orientations = orientations;
    }

    public void set_bcm(StacBCM bcm) {
        this.bcm = bcm;
    }

    public void set_utils(StacUtil utils) {
        this.utils = utils;
    }

    public void load(DataInputStream in) throws IOException {
        this.loadMsgHeader(in);
        this.OMfile = in.readUTF();
        this.datum.x = in.readDouble();
        this.datum.y = in.readDouble();
        this.datum.z = in.readDouble();
        this.trans.x = in.readDouble();
        this.trans.y = in.readDouble();
        this.trans.z = in.readDouble();
        int oct = in.readInt();
        int i = 0;
        while (i < oct) {
            this.orientations.addElement(in.readUTF());
            ++i;
        }
    }

    public void save(DataOutputStream out) throws IOException {
        this.saveMsgHeader(out);
        out.writeChars(this.OMfile);
        out.writeDouble(this.datum.x);
        out.writeDouble(this.datum.y);
        out.writeDouble(this.datum.z);
        out.writeDouble(this.trans.x);
        out.writeDouble(this.trans.y);
        out.writeDouble(this.trans.z);
        out.writeInt(this.orientations.size());
        int i = 0;
        while (i < this.orientations.size()) {
            out.writeUTF((String)this.orientations.elementAt(i++));
            ++i;
        }
    }

    public void loadMsgHeader(DataInputStream in) throws IOException {
        super.loadMsgHeader(in);
        String msgType = in.readUTF();
        if (!msgType.equals("Stac_AlignmentReqMsg")) {
            throw new IOException("STAC Message Type Missmatch!");
        }
    }

    public void saveMsgHeader(DataOutputStream out) throws IOException {
        super.saveMsgHeader(out);
        out.writeUTF("Stac_AlignmentReqMsg");
    }
}

